/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.main;

import com.kreative.bitsnpicas.truetype.CmapSubtable;
import com.kreative.bitsnpicas.truetype.CmapTable;
import com.kreative.bitsnpicas.truetype.PostTable;
import com.kreative.bitsnpicas.truetype.PostTableEntry;
import com.kreative.bitsnpicas.truetype.SvgTable;
import com.kreative.bitsnpicas.truetype.SvgTableEntry;
import com.kreative.bitsnpicas.truetype.TrueTypeFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.StringCharacterIterator;
import java.util.BitSet;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InjectSvg {
    private static final Pattern GLYPH_ID_PATTERN = Pattern.compile("([\"']glyph)\\{\\{\\{([A-Za-z0-9_.:+-]+)\\}\\}\\}([\"'])");
    private static final Pattern G_PATTERN = Pattern.compile("^[Gg][:+]");
    private static final Pattern C_PATTERN = Pattern.compile("^[CcUu][:+]");
    private static final Pattern N_PATTERN = Pattern.compile("^[NnPp][:+]");

    public static void main(String[] stringArray) {
        try {
            System.setProperty("apple.awt.UIElement", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = false;
        for (String string : stringArray) {
            if (string.equals("-z")) {
                bl = true;
                continue;
            }
            if (string.equals("-Z")) {
                bl = false;
                continue;
            }
            File file = new File(string);
            System.out.print("Processing " + file.getAbsolutePath() + "... ");
            try {
                File file2 = new File(file.getParent(), file.getName() + ".svg.d");
                if (!file2.exists() || !file2.isDirectory()) {
                    System.out.println("no svg directory found.");
                    continue;
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                InjectSvg.copyAndClose(new FileInputStream(file), byteArrayOutputStream);
                TrueTypeFile trueTypeFile = new TrueTypeFile();
                trueTypeFile.decompile(byteArrayOutputStream.toByteArray());
                CmapTable cmapTable = (CmapTable)trueTypeFile.getByTableName("cmap");
                CmapSubtable cmapSubtable = cmapTable == null ? null : cmapTable.getBestSubtable();
                PostTable postTable = (PostTable)trueTypeFile.getByTableName("post");
                SvgTable svgTable = (SvgTable)trueTypeFile.getByTableName("SVG ");
                if (svgTable == null) {
                    svgTable = new SvgTable();
                    trueTypeFile.add(svgTable);
                } else {
                    svgTable.clear();
                }
                for (File file3 : file2.listFiles()) {
                    BitSet bitSet;
                    String string2;
                    String string3 = file3.getName();
                    int n = string3.lastIndexOf(46);
                    if (n <= 0 || !(string2 = string3.substring(n + 1)).equalsIgnoreCase("svg") || (bitSet = InjectSvg.getGlyphIndices(string3 = string3.substring(0, n), cmapSubtable, postTable)).isEmpty()) continue;
                    ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                    InjectSvg.copyAndClose(new FileInputStream(file3), byteArrayOutputStream2);
                    byte[] byArray = null;
                    int n2 = bitSet.nextSetBit(0);
                    while (n2 >= 0) {
                        int n3 = bitSet.nextClearBit(n2);
                        SvgTableEntry svgTableEntry = new SvgTableEntry();
                        svgTableEntry.startGlyphID = n2;
                        svgTableEntry.endGlyphID = n3 - 1;
                        if (byArray == null) {
                            OutputStream outputStream = svgTableEntry.getOutputStream(bl);
                            outputStream.write(InjectSvg.rewriteEntryData(byteArrayOutputStream2.toByteArray(), bitSet, cmapSubtable, postTable));
                            outputStream.flush();
                            outputStream.close();
                            byArray = svgTableEntry.svgDocument;
                        } else {
                            svgTableEntry.svgDocument = byArray;
                        }
                        svgTable.add(svgTableEntry);
                        n2 = bitSet.nextSetBit(n3);
                    }
                }
                Collections.sort(svgTable);
                byte[] objectArray = trueTypeFile.compile();
                String string4 = trueTypeFile.isOpenType() ? ".otf" : ".ttf";
                File file4 = new File(file.getParent(), file.getName() + ".svg" + string4);
                FileOutputStream fileOutputStream = new FileOutputStream(file4);
                fileOutputStream.write(objectArray);
                fileOutputStream.flush();
                fileOutputStream.close();
                System.out.println("done.");
            }
            catch (Exception exception) {
                System.out.println("failed (" + exception.getClass().getSimpleName() + ": " + exception.getMessage() + ").");
            }
        }
    }

    private static byte[] rewriteEntryData(byte[] byArray, BitSet bitSet, CmapSubtable cmapSubtable, PostTable postTable) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String string = new String(byArray, "UTF-8");
            Matcher matcher = GLYPH_ID_PATTERN.matcher(string);
            while (matcher.find()) {
                int n = InjectSvg.getGlyphIndex(matcher.group(2), bitSet, cmapSubtable, postTable);
                String string2 = n > 0 ? matcher.group(1) + n + matcher.group(3) : matcher.group();
                matcher.appendReplacement(stringBuffer, string2);
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString().getBytes("UTF-8");
        }
        catch (IOException iOException) {
            return byArray;
        }
    }

    private static int getGlyphIndex(String string, BitSet bitSet, CmapSubtable cmapSubtable, PostTable postTable) {
        if (string.startsWith("glyph_")) {
            try {
                return Integer.parseInt(string.substring(6));
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        if (string.startsWith("char_")) {
            if (cmapSubtable == null) {
                return 0;
            }
            try {
                return cmapSubtable.getGlyphIndex(Integer.parseInt(string.substring(5), 16));
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        if (G_PATTERN.matcher(string).find()) {
            try {
                return Integer.parseInt(string.substring(2));
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        if (C_PATTERN.matcher(string).find()) {
            if (cmapSubtable == null) {
                return 0;
            }
            try {
                return cmapSubtable.getGlyphIndex(Integer.parseInt(string.substring(2), 16));
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        if (N_PATTERN.matcher(string).find()) {
            if (postTable == null) {
                return 0;
            }
            PostTableEntry postTableEntry = PostTableEntry.forCharacterName(string.substring(2));
            return postTable.contains(postTableEntry) ? postTable.indexOf(postTableEntry) : 0;
        }
        try {
            int n = Integer.parseInt(string);
            if (n < 0) {
                return 0;
            }
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                int n3 = bitSet.nextClearBit(n2);
                int n4 = n3 - n2;
                if (n < n4) {
                    return n2 + n;
                }
                n -= n4;
                n2 = bitSet.nextSetBit(n3);
            }
            return 0;
        }
        catch (NumberFormatException numberFormatException) {
            if (postTable == null) {
                return 0;
            }
            PostTableEntry postTableEntry = PostTableEntry.forCharacterName(string);
            return postTable.contains(postTableEntry) ? postTable.indexOf(postTableEntry) : 0;
        }
    }

    private static BitSet getGlyphIndices(String string, CmapSubtable cmapSubtable, PostTable postTable) {
        PostTableEntry postTableEntry;
        if (string.startsWith("glyph_")) {
            String[] stringArray;
            BitSet bitSet = new BitSet();
            for (String string2 : stringArray = string.substring(6).split("[+]")) {
                try {
                    String[] stringArray2 = string2.split("[-_]", 2);
                    int n = Integer.parseInt(stringArray2[0]);
                    int n2 = stringArray2.length > 1 ? Integer.parseInt(stringArray2[1]) : n;
                    int n3 = Math.min(n, n2);
                    int n4 = Math.max(n, n2) + 1;
                    bitSet.set(n3, n4);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return bitSet;
        }
        if (string.startsWith("char_")) {
            BitSet bitSet = new BitSet();
            if (cmapSubtable != null) {
                String[] stringArray;
                for (String string3 : stringArray = string.substring(5).split("[+]")) {
                    try {
                        String[] stringArray3 = string3.split("[-_]", 2);
                        int n = Integer.parseInt(stringArray3[0], 16);
                        int n5 = stringArray3.length > 1 ? Integer.parseInt(stringArray3[1], 16) : n;
                        int n6 = Math.min(n, n5);
                        int n7 = Math.max(n, n5) + 1;
                        for (int i = n6; i < n7; ++i) {
                            bitSet.set(cmapSubtable.getGlyphIndex(i));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return bitSet;
        }
        BitSet bitSet = new BitSet();
        if (postTable != null && postTable.contains(postTableEntry = PostTableEntry.forCharacterName(InjectSvg.unescape(string)))) {
            bitSet.set(postTable.indexOf(postTableEntry));
        }
        return bitSet;
    }

    private static String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            block0 : switch (c) {
                case '!': {
                    c = stringCharacterIterator.next();
                    if (c == '\uffff') {
                        stringBuffer.append('!');
                        break;
                    }
                    stringBuffer.append(Character.toLowerCase(c));
                    break;
                }
                case '^': {
                    c = stringCharacterIterator.next();
                    if (c == '\uffff') {
                        stringBuffer.append('^');
                        break;
                    }
                    stringBuffer.append(Character.toUpperCase(c));
                    break;
                }
                case '#': {
                    c = stringCharacterIterator.next();
                    if (c == '\uffff') {
                        stringBuffer.append('#');
                        break;
                    }
                    stringBuffer.append(Character.toTitleCase(c));
                    break;
                }
                case '=': {
                    c = stringCharacterIterator.next();
                    switch (c) {
                        case '\uffff': {
                            stringBuffer.append('=');
                            break block0;
                        }
                        case 'A': 
                        case 'a': {
                            stringBuffer.append('\'');
                            break block0;
                        }
                        case 'B': 
                        case 'b': {
                            stringBuffer.append('\\');
                            break block0;
                        }
                        case 'C': 
                        case 'c': {
                            stringBuffer.append(':');
                            break block0;
                        }
                        case 'D': 
                        case 'd': {
                            stringBuffer.append('$');
                            break block0;
                        }
                        case 'E': 
                        case 'e': {
                            stringBuffer.append('=');
                            break block0;
                        }
                        case 'F': 
                        case 'f': {
                            stringBuffer.append('/');
                            break block0;
                        }
                        case 'G': 
                        case 'g': {
                            stringBuffer.append('>');
                            break block0;
                        }
                        case 'H': 
                        case 'h': {
                            stringBuffer.append('?');
                            break block0;
                        }
                        case 'I': 
                        case 'i': {
                            stringBuffer.append('[');
                            break block0;
                        }
                        case 'J': 
                        case 'j': {
                            stringBuffer.append(']');
                            break block0;
                        }
                        case 'K': 
                        case 'k': {
                            stringBuffer.append(';');
                            break block0;
                        }
                        case 'L': 
                        case 'l': {
                            stringBuffer.append('<');
                            break block0;
                        }
                        case 'M': 
                        case 'm': {
                            stringBuffer.append('&');
                            break block0;
                        }
                        case 'N': 
                        case 'n': {
                            stringBuffer.append('+');
                            break block0;
                        }
                        case 'O': 
                        case 'o': {
                            stringBuffer.append('#');
                            break block0;
                        }
                        case 'P': 
                        case 'p': {
                            stringBuffer.append('%');
                            break block0;
                        }
                        case 'Q': 
                        case 'q': {
                            stringBuffer.append('\"');
                            break block0;
                        }
                        case 'R': 
                        case 'r': {
                            stringBuffer.append('^');
                            break block0;
                        }
                        case 'S': 
                        case 's': {
                            stringBuffer.append('*');
                            break block0;
                        }
                        case 'T': 
                        case 't': {
                            stringBuffer.append('~');
                            break block0;
                        }
                        case 'U': 
                        case 'u': {
                            stringBuffer.append('_');
                            break block0;
                        }
                        case 'V': 
                        case 'v': {
                            stringBuffer.append('|');
                            break block0;
                        }
                        case 'W': 
                        case 'w': {
                            stringBuffer.append('`');
                            break block0;
                        }
                        case 'X': 
                        case 'x': {
                            stringBuffer.append('!');
                            break block0;
                        }
                        case 'Y': 
                        case 'y': {
                            stringBuffer.append('{');
                            break block0;
                        }
                        case 'Z': 
                        case 'z': {
                            stringBuffer.append('}');
                            break block0;
                        }
                    }
                    stringBuffer.append(c);
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    private static void copyAndClose(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[65536];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
        outputStream.close();
        inputStream.close();
    }
}

