/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.main;

import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.MacUtility;
import com.kreative.bitsnpicas.exporter.BDFBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.CybikoBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.FNTBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.FONTXBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.FZXBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.GEOSBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.HMZKBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.HexBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.KbitsBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.KbitxBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.NFNTBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.OTBBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.PSFBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.PlaydateBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.RFontBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.RockboxBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.SBFBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.SFontBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.TOSBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.TTFBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.U8MBitmapFontExporter;
import com.kreative.bitsnpicas.main.BitmapOutputOptions;
import com.kreative.unicode.data.EncodingList;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BitmapOutputFormat {
    KBITX(".kbitx", new String[]{"kbitx", "kbnp2"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new KbitxBitmapFontExporter();
        }
    }
    ,
    KBITS(".kbits", new String[]{"kbits", "kbnp1"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new KbitsBitmapFontExporter();
        }
    }
    ,
    TTF(".ttf", new String[]{"ttf", "truetype"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new TTFBitmapFontExporter(bitmapOutputOptions.xSize, bitmapOutputOptions.ySize, bitmapOutputOptions.extendWinMetrics);
        }
    }
    ,
    OTB(".otb", new String[]{"otb"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new OTBBitmapFontExporter(bitmapOutputOptions.extendWinMetrics);
        }
    }
    ,
    BDF(".bdf", new String[]{"bdf"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new BDFBitmapFontExporter();
        }
    }
    ,
    PSF2(".psf", new String[]{"psf", "psf2"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new PSFBitmapFontExporter(2, bitmapOutputOptions.getPsfLowEncoding(), bitmapOutputOptions.getPsfHighEncoding(), bitmapOutputOptions.psfUseLowEncoding, bitmapOutputOptions.psfUseHighEncoding, bitmapOutputOptions.psfUseAllGlyphs, bitmapOutputOptions.psfUnicodeTable, false);
        }
    }
    ,
    PSF1(".psf", new String[]{"psf1"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new PSFBitmapFontExporter(1, bitmapOutputOptions.getPsfLowEncoding(), bitmapOutputOptions.getPsfHighEncoding(), bitmapOutputOptions.psfUseLowEncoding, bitmapOutputOptions.psfUseHighEncoding, bitmapOutputOptions.psfUseAllGlyphs, bitmapOutputOptions.psfUnicodeTable, false);
        }
    }
    ,
    PSF2GZ(".psf.gz", new String[]{"psfgz", "psf2gz"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new PSFBitmapFontExporter(2, bitmapOutputOptions.getPsfLowEncoding(), bitmapOutputOptions.getPsfHighEncoding(), bitmapOutputOptions.psfUseLowEncoding, bitmapOutputOptions.psfUseHighEncoding, bitmapOutputOptions.psfUseAllGlyphs, bitmapOutputOptions.psfUnicodeTable, true);
        }
    }
    ,
    PSF1GZ(".psf.gz", new String[]{"psf1gz"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new PSFBitmapFontExporter(1, bitmapOutputOptions.getPsfLowEncoding(), bitmapOutputOptions.getPsfHighEncoding(), bitmapOutputOptions.psfUseLowEncoding, bitmapOutputOptions.psfUseHighEncoding, bitmapOutputOptions.psfUseAllGlyphs, bitmapOutputOptions.psfUnicodeTable, true);
        }
    }
    ,
    SUIT(".suit", "nfnt", "suit", true){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            bitmapOutputOptions.idgen.setRange(128, 32768);
            bitmapOutputOptions.sizegen.setRange(4, 127);
            bitmapOutputOptions.sizegen.setPointSizes(9, 10, 12, 14, 18, 24, 36, 48, 72);
            return new NFNTBitmapFontExporter(bitmapOutputOptions.idgen, bitmapOutputOptions.sizegen, bitmapOutputOptions.getEncoding());
        }

        public void postProcess(File file) throws IOException {
            MacUtility.setTypeAndCreator(file, "FFIL", "DMOV");
        }
    }
    ,
    DFONT(".dfont", new String[]{"dfont"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            bitmapOutputOptions.idgen.setRange(128, 32768);
            bitmapOutputOptions.sizegen.setRange(4, 127);
            bitmapOutputOptions.sizegen.setPointSizes(9, 10, 12, 14, 18, 24, 36, 48, 72);
            return new NFNTBitmapFontExporter(bitmapOutputOptions.idgen, bitmapOutputOptions.sizegen, bitmapOutputOptions.getEncoding());
        }
    }
    ,
    SFONT(".png", new String[]{"png", "sfont"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new SFontBitmapFontExporter();
        }
    }
    ,
    RFONT(".png", new String[]{"rfont"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new RFontBitmapFontExporter();
        }
    }
    ,
    HEX(".hex", new String[]{"hex"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new HexBitmapFontExporter();
        }
    }
    ,
    CVT(".cvt", new String[]{"cvt", "geos"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            bitmapOutputOptions.idgen.setRange(128, 1024);
            bitmapOutputOptions.sizegen.setRange(6, 63);
            bitmapOutputOptions.sizegen.setPointSizes(9, 10, 12, 14, 18, 24, 36, 48, 60);
            return new GEOSBitmapFontExporter(bitmapOutputOptions.idgen, bitmapOutputOptions.sizegen, bitmapOutputOptions.geosMega, bitmapOutputOptions.geosKerning, bitmapOutputOptions.geosUTF8);
        }
    }
    ,
    FZX(".fzx", new String[]{"fzx"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new FZXBitmapFontExporter(bitmapOutputOptions.getEncoding());
        }
    }
    ,
    U8M(".u8m", new String[]{"u8m"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new U8MBitmapFontExporter(bitmapOutputOptions.u8mLoadAddress, bitmapOutputOptions.getEncoding());
        }
    }
    ,
    FNT3(".fnt", new String[]{"fnt", "fnt3"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new FNTBitmapFontExporter(3, bitmapOutputOptions.getEncoding());
        }
    }
    ,
    FNT2(".fnt", new String[]{"fnt2"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new FNTBitmapFontExporter(2, bitmapOutputOptions.getEncoding());
        }
    }
    ,
    FONTX(".fnt", new String[]{"dosv", "fontx", "fontx2"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            if (bitmapOutputOptions.fontxDoubleByte) {
                String string = bitmapOutputOptions.fontxDoubleByteEncoding;
                if (string == null || string.length() == 0) {
                    string = "CP943";
                }
                return new FONTXBitmapFontExporter(string);
            }
            String string = bitmapOutputOptions.encodingName;
            if (string == null || string.length() == 0) {
                string = "CP437";
            }
            return new FONTXBitmapFontExporter(EncodingList.instance().getGlyphList(string));
        }
    }
    ,
    RB12(".fnt", new String[]{"rb12"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new RockboxBitmapFontExporter(1380069682);
        }
    }
    ,
    RB11(".fnt", new String[]{"rb11"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new RockboxBitmapFontExporter(1380069681);
        }
    }
    ,
    CYBIKO(".fnt", new String[]{"cybiko"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new CybikoBitmapFontExporter(bitmapOutputOptions.getEncoding());
        }
    }
    ,
    PLAYDATE_FNT(".fnt", new String[]{"playdate", "playdate-allinone", "playdate-fnt"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new PlaydateBitmapFontExporter(false);
        }
    }
    ,
    PLAYDATE_FNT_PNG(".fnt", new String[]{"playdate-separate", "playdate-fnt+png"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new PlaydateBitmapFontExporter(true);
        }
    }
    ,
    HMZK(".hmzk", new String[]{"hmzk"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new HMZKBitmapFontExporter();
        }
    }
    ,
    SBF(".sbf", new String[]{"sbf"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new SBFBitmapFontExporter(bitmapOutputOptions.getEncoding());
        }
    }
    ,
    TOS(".ft", new String[]{"tos", "ft"}){

        public BitmapFontExporter createExporter(BitmapOutputOptions bitmapOutputOptions) {
            return new TOSBitmapFontExporter();
        }
    };

    public final String[] ids;
    public final String suffix;
    public final boolean macResFork;

    private BitmapOutputFormat(String string2, String ... stringArray) {
        this.ids = stringArray;
        this.suffix = string2;
        this.macResFork = false;
    }

    private BitmapOutputFormat(String string2, String string3, String string4, boolean bl) {
        this.ids = new String[]{string3, string4};
        this.suffix = string2;
        this.macResFork = bl;
    }

    public abstract BitmapFontExporter createExporter(BitmapOutputOptions var1);

    public void postProcess(File file) throws IOException {
    }
}

