/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.importer;

import com.kreative.bitsnpicas.VectorFont;
import com.kreative.bitsnpicas.VectorFontGlyph;
import com.kreative.bitsnpicas.VectorFontImporter;
import com.kreative.bitsnpicas.VectorInstruction;
import com.kreative.bitsnpicas.VectorPath;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class KpcasVectorFontImporter
implements VectorFontImporter {
    public VectorFont[] importFont(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        VectorFont vectorFont = this.importFont(dataInputStream);
        dataInputStream.close();
        byteArrayInputStream.close();
        return new VectorFont[]{vectorFont};
    }

    public VectorFont[] importFont(InputStream inputStream) throws IOException {
        VectorFont vectorFont = this.importFont(new DataInputStream(inputStream));
        return new VectorFont[]{vectorFont};
    }

    public VectorFont[] importFont(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        VectorFont vectorFont = this.importFont(dataInputStream);
        dataInputStream.close();
        fileInputStream.close();
        return new VectorFont[]{vectorFont};
    }

    private VectorFont importFont(DataInputStream dataInputStream) throws IOException {
        if (dataInputStream.readInt() != 1262644816) {
            throw new IOException("bad magic number");
        }
        if (dataInputStream.readInt() != 1885561203) {
            throw new IOException("bad magic number");
        }
        if (dataInputStream.readInt() != 1) {
            throw new IOException("bad version number");
        }
        double d = dataInputStream.readDouble();
        double d2 = dataInputStream.readDouble();
        double d3 = dataInputStream.readDouble();
        double d4 = dataInputStream.readDouble();
        double d5 = dataInputStream.readDouble();
        double d6 = dataInputStream.readDouble();
        VectorFont vectorFont = new VectorFont(d, d2, d3, d4, d6, d6, d5);
        block5: while (true) {
            int n = dataInputStream.readInt();
            switch (n) {
                case 1851878757: {
                    if (dataInputStream.readInt() != 1) {
                        throw new IOException("bad version number");
                    }
                    int n2 = dataInputStream.readInt();
                    String string = dataInputStream.readUTF();
                    vectorFont.setName(n2, string);
                    continue block5;
                }
                case 1667785074: {
                    if (dataInputStream.readInt() != 1) {
                        throw new IOException("bad version number");
                    }
                    int n3 = dataInputStream.readInt();
                    double d7 = dataInputStream.readDouble();
                    ArrayList<VectorPath> arrayList = new ArrayList<VectorPath>();
                    int n4 = dataInputStream.readInt();
                    for (int i = 0; i < n4; ++i) {
                        int n5;
                        VectorPath vectorPath = new VectorPath();
                        while ((n5 = dataInputStream.readInt()) != 795047026) {
                            double d8;
                            double d9;
                            if (n5 == 1836021349) {
                                double d10 = dataInputStream.readDouble();
                                double d11 = dataInputStream.readDouble();
                                vectorPath.add(new VectorInstruction('M', d10, d11));
                                continue;
                            }
                            if (n5 == 1818848869) {
                                double d12 = dataInputStream.readDouble();
                                double d13 = dataInputStream.readDouble();
                                vectorPath.add(new VectorInstruction('L', d12, d13));
                                continue;
                            }
                            if (n5 == 1903518052) {
                                double d14 = dataInputStream.readDouble();
                                double d15 = dataInputStream.readDouble();
                                d9 = dataInputStream.readDouble();
                                d8 = dataInputStream.readDouble();
                                vectorPath.add(new VectorInstruction('Q', d14, d15, d9, d8));
                                continue;
                            }
                            if (n5 == 1668637285) {
                                double d16 = dataInputStream.readDouble();
                                double d17 = dataInputStream.readDouble();
                                d9 = dataInputStream.readDouble();
                                d8 = dataInputStream.readDouble();
                                double d18 = dataInputStream.readDouble();
                                double d19 = dataInputStream.readDouble();
                                vectorPath.add(new VectorInstruction('C', d16, d17, d9, d8, d18, d19));
                                continue;
                            }
                            if (n5 == 795898984) {
                                vectorPath.add(new VectorInstruction('Z', new Number[0]));
                                continue;
                            }
                            if ((n5 & 0xFFC0FFF0) == 0x400000) {
                                char c = (char)(n5 >> 16);
                                Number[] numberArray = new Double[n5 & 0xF];
                                for (int j = 0; j < numberArray.length; ++j) {
                                    numberArray[j] = dataInputStream.readDouble();
                                }
                                vectorPath.add(new VectorInstruction(c, numberArray));
                                continue;
                            }
                            throw new IOException("bad magic number");
                        }
                        arrayList.add(vectorPath);
                    }
                    VectorFontGlyph vectorFontGlyph = new VectorFontGlyph(arrayList, d7);
                    vectorFont.putCharacter(n3, vectorFontGlyph);
                    continue block5;
                }
                case 1718185518: {
                    vectorFont.setCapHeight2D();
                    return vectorFont;
                }
            }
            break;
        }
        throw new IOException("bad magic number");
    }
}

