/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.importer;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.BitmapFontImporter;
import com.kreative.unicode.data.GlyphList;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FONTXBitmapFontImporter
implements BitmapFontImporter {
    private GlyphList singleByteEncoding;
    private String doubleByteEncoding;

    public FONTXBitmapFontImporter() {
        this.singleByteEncoding = null;
        this.doubleByteEncoding = "CP943";
    }

    public FONTXBitmapFontImporter(GlyphList glyphList) {
        this.singleByteEncoding = glyphList;
        this.doubleByteEncoding = "CP943";
    }

    public FONTXBitmapFontImporter(GlyphList glyphList, String string) {
        this.singleByteEncoding = glyphList;
        this.doubleByteEncoding = string;
    }

    public FONTXBitmapFontImporter(String string) {
        this.singleByteEncoding = null;
        this.doubleByteEncoding = string;
    }

    public BitmapFont[] importFont(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BitmapFont bitmapFont = this.importFontImpl(new DataInputStream(byteArrayInputStream));
        byteArrayInputStream.close();
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(InputStream inputStream) throws IOException {
        BitmapFont bitmapFont = this.importFontImpl(new DataInputStream(inputStream));
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BitmapFont bitmapFont = this.importFontImpl(new DataInputStream(fileInputStream));
        fileInputStream.close();
        return new BitmapFont[]{bitmapFont};
    }

    private BitmapFont importFontImpl(DataInputStream dataInputStream) throws IOException {
        if (dataInputStream.readInt() != 1179602516) {
            throw new IOException("bad magic number");
        }
        if (dataInputStream.readShort() != 22578) {
            throw new IOException("bad magic number");
        }
        byte[] byArray = new byte[8];
        dataInputStream.readFully(byArray);
        String string = new String(byArray, "US-ASCII").trim();
        int n = dataInputStream.readUnsignedByte();
        int n2 = dataInputStream.readUnsignedByte();
        byte by = dataInputStream.readByte();
        BitmapFont bitmapFont = new BitmapFont(n2, 0, n2, 0, n2, n2, 0);
        bitmapFont.setName(1, string);
        if (by == 0) {
            for (int i = 0; i < 256; ++i) {
                BitmapFontGlyph bitmapFontGlyph = this.readGlyph(dataInputStream, n, n2);
                int n3 = this.fromSingleByte(i);
                bitmapFont.putCharacter(n3, bitmapFontGlyph);
            }
        } else {
            int n4;
            int n5 = dataInputStream.readUnsignedByte();
            int[] nArray = new int[n5];
            int[] nArray2 = new int[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                nArray[n4] = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
                nArray2[n4] = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
            }
            for (n4 = 0; n4 < n5; ++n4) {
                for (int i = nArray[n4]; i <= nArray2[n4]; ++i) {
                    BitmapFontGlyph bitmapFontGlyph = this.readGlyph(dataInputStream, n, n2);
                    int n6 = this.fromDoubleByte(i);
                    bitmapFont.putCharacter(n6, bitmapFontGlyph);
                }
            }
        }
        bitmapFont.setAscentDescent();
        bitmapFont.setXHeight();
        bitmapFont.setCapHeight();
        return bitmapFont;
    }

    private BitmapFontGlyph readGlyph(DataInputStream dataInputStream, int n, int n2) throws IOException {
        byte[][] byArray = new byte[n2][n];
        for (int i = 0; i < n2; ++i) {
            int n3 = 0;
            while (n3 < n) {
                byte by = dataInputStream.readByte();
                for (int j = 128; n3 < n && j != 0; ++n3, j >>= 1) {
                    if ((by & j) == 0) continue;
                    byArray[i][n3] = -1;
                }
            }
        }
        return new BitmapFontGlyph(byArray, 0, n, n2);
    }

    private int fromSingleByte(int n) {
        int n2;
        if (this.singleByteEncoding != null && (n2 = this.singleByteEncoding.get(n).intValue()) >= 0) {
            return n2;
        }
        return 61440 + n;
    }

    private int fromDoubleByte(int n) {
        if (this.doubleByteEncoding != null) {
            try {
                int n2;
                byte[] byArray = new byte[]{(byte)(n >> 8), (byte)n};
                String string = new String(byArray, this.doubleByteEncoding);
                if (string.codePointCount(0, string.length()) == 1 && (n2 = string.codePointAt(0)) != 65533) {
                    return n2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 983040 + n;
    }
}

