/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.importer;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.BitmapFontImporter;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryBitmapFontImporter
implements BitmapFontImporter {
    public int offset = 0;
    public int bytesPerChar = 8;
    public int bytesPerRow = 1;
    public int cellWidth = 8;
    public int cellHeight = 8;
    public int ascent = 7;
    public int bitsPerPixel = 1;
    public boolean invert = false;
    public boolean rightAlign = false;
    public boolean flipBits = false;
    public boolean flipBytes = false;
    public int cellCount = 128;
    public List<Integer> encoding = null;

    public List<BufferedImage> preview(byte[] byArray) {
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
        int[] nArray = new int[this.cellWidth * this.cellHeight];
        int n = this.offset;
        int n2 = 0;
        while (n2 < this.cellCount) {
            BufferedImage bufferedImage = new BufferedImage(this.cellWidth, this.cellHeight, 2);
            int n3 = 0;
            int n4 = n;
            int n5 = 0;
            while (n5 < this.cellHeight) {
                byte[] byArray2 = this.unpackRow(byArray, n4);
                for (int i = 0; i < this.cellWidth; ++i) {
                    int n6 = 255 - (byArray2[i] & 0xFF);
                    nArray[n3 + i] = 0xFF000000 | n6 << 16 | n6 << 8 | n6 << 0;
                    if (n5 != this.ascent) continue;
                    int n7 = n3 + i;
                    nArray[n7] = nArray[n7] ^ 0xFFFF;
                }
                ++n5;
                n4 += this.bytesPerRow;
                n3 += this.cellWidth;
            }
            bufferedImage.setRGB(0, 0, this.cellWidth, this.cellHeight, nArray, 0, this.cellWidth);
            arrayList.add(bufferedImage);
            ++n2;
            n += this.bytesPerChar;
        }
        return arrayList;
    }

    public BitmapFont[] importFont(byte[] byArray) {
        BitmapFont bitmapFont = new BitmapFont(this.ascent, this.cellHeight - this.ascent, this.ascent, this.cellHeight - this.ascent, 0, 0, 0);
        int n = this.offset;
        int n2 = 0;
        while (n2 < this.cellCount) {
            byte[][] byArrayArray = new byte[this.cellHeight][];
            int n3 = n;
            int n4 = 0;
            while (n4 < this.cellHeight) {
                byArrayArray[n4] = this.unpackRow(byArray, n3);
                ++n4;
                n3 += this.bytesPerRow;
            }
            BitmapFontGlyph bitmapFontGlyph = new BitmapFontGlyph(byArrayArray, 0, this.cellWidth, this.ascent);
            if (this.encoding == null || this.encoding.isEmpty()) {
                bitmapFont.putCharacter(983040 + n2, bitmapFontGlyph);
            } else if (n2 < this.encoding.size()) {
                Integer n5 = this.encoding.get(n2);
                if (n5 != null && n5 >= 0) {
                    bitmapFont.putCharacter(n5, bitmapFontGlyph);
                }
            } else {
                bitmapFont.putCharacter(983040 + n2 - this.encoding.size(), bitmapFontGlyph);
            }
            ++n2;
            n += this.bytesPerChar;
        }
        bitmapFont.setXHeight();
        bitmapFont.setCapHeight();
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[0x100000];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        return this.importFont(byteArrayOutputStream.toByteArray());
    }

    public BitmapFont[] importFont(File file) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[0x100000];
        while ((n = fileInputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        fileInputStream.close();
        return this.importFont(byteArrayOutputStream.toByteArray());
    }

    private byte[] unpackRow(byte[] byArray, int n) {
        byte[] byArray2 = new byte[this.cellWidth];
        int n2 = (1 << this.bitsPerPixel) - 1;
        int n3 = this.cellWidth * this.bitsPerPixel;
        int n4 = (n3 + 7) / 8;
        int n5 = this.rightAlign ? n4 * 8 - n3 : 0;
        int n6 = 0;
        while (n6 < this.cellWidth) {
            int n7 = 0;
            int n8 = 1 << this.bitsPerPixel - 1;
            int n9 = 0;
            while (n9 < this.bitsPerPixel) {
                int n10 = (n5 + n9) / 8;
                if (this.flipBytes) {
                    n10 = n4 - 1 - n10;
                }
                int n11 = (n5 + n9) % 8;
                if (!this.flipBits) {
                    n11 = 7 - n11;
                }
                if (n + n10 < byArray.length && (byArray[n + n10] >> n11 & 1) != 0) {
                    n7 |= n8;
                }
                ++n9;
                n8 >>= 1;
            }
            if (this.invert) {
                n7 ^= n2;
            }
            byArray2[n6] = (byte)(255 * n7 / n2);
            ++n6;
            n5 += this.bitsPerPixel;
        }
        return byArray2;
    }
}

