/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.exporter;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class RFontBitmapFontExporter
implements BitmapFontExporter {
    private int color;

    public RFontBitmapFontExporter() {
        this.color = 0;
    }

    public RFontBitmapFontExporter(int n) {
        this.color = n;
    }

    public byte[] exportFontToBytes(BitmapFont bitmapFont) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.exportFontToStream(bitmapFont, (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void exportFontToStream(BitmapFont bitmapFont, OutputStream outputStream) throws IOException {
        RFontBean rFontBean = this.exportFontToImage(bitmapFont);
        ImageWriter imageWriter = ImageIO.getImageWritersBySuffix("png").next();
        imageWriter.setOutput(ImageIO.createImageOutputStream(outputStream));
        IIOMetadata iIOMetadata = RFontBitmapFontExporter.createMetadata(imageWriter, rFontBean);
        imageWriter.write(new IIOImage(rFontBean.img, null, iIOMetadata));
    }

    public void exportFontToFile(BitmapFont bitmapFont, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.exportFontToStream(bitmapFont, (OutputStream)fileOutputStream);
        fileOutputStream.close();
    }

    public RFontBean exportFontToImage(BitmapFont bitmapFont) {
        int n;
        int n2;
        Object object;
        int n3;
        int n4;
        BitmapFontGlyph[][] bitmapFontGlyphArrayArray = new BitmapFontGlyph[4352][];
        int[][] nArrayArray = new int[4352][];
        int[][] nArrayArray2 = new int[4352][];
        int[][] nArrayArray3 = new int[4352][];
        int n5 = bitmapFont.getLineAscent();
        int n6 = bitmapFont.getLineDescent();
        int n7 = bitmapFont.getLineGap();
        int[] nArray = new int[4352];
        for (n4 = 0; n4 < 4352; ++n4) {
            for (n3 = 0; n3 < 256; ++n3) {
                if (!bitmapFont.containsCharacter(n4 << 8 | n3)) continue;
                if (bitmapFontGlyphArrayArray[n4] == null) {
                    bitmapFontGlyphArrayArray[n4] = new BitmapFontGlyph[256];
                }
                bitmapFontGlyphArrayArray[n4][n3] = (BitmapFontGlyph)bitmapFont.getCharacter(n4 << 8 | n3);
                if (nArrayArray[n4] == null) {
                    nArrayArray[n4] = new int[256];
                }
                nArrayArray[n4][n3] = bitmapFontGlyphArrayArray[n4][n3].getGlyphOffset();
                int n8 = nArrayArray[n4][n3] = nArrayArray[n4][n3] < 0 ? -nArrayArray[n4][n3] : 0;
                if (nArrayArray2[n4] == null) {
                    nArrayArray2[n4] = new int[256];
                }
                nArrayArray2[n4][n3] = bitmapFontGlyphArrayArray[n4][n3].getCharacterWidth();
                if (nArrayArray3[n4] == null) {
                    nArrayArray3[n4] = new int[256];
                }
                nArrayArray3[n4][n3] = bitmapFontGlyphArrayArray[n4][n3].getGlyphOffset() + bitmapFontGlyphArrayArray[n4][n3].getGlyphWidth();
                int n9 = nArrayArray3[n4][n3] = nArrayArray3[n4][n3] > nArrayArray2[n4][n3] ? nArrayArray3[n4][n3] - nArrayArray2[n4][n3] : 0;
                if (bitmapFontGlyphArrayArray[n4][n3].getGlyphAscent() > n5) {
                    n5 = bitmapFontGlyphArrayArray[n4][n3].getGlyphAscent();
                }
                if (bitmapFontGlyphArrayArray[n4][n3].getGlyphDescent() > n6) {
                    n6 = bitmapFontGlyphArrayArray[n4][n3].getGlyphDescent();
                }
                int n10 = n4;
                nArray[n10] = nArray[n10] + (1 + nArrayArray[n4][n3] + nArrayArray2[n4][n3] + nArrayArray3[n4][n3]);
            }
        }
        n4 = 1 + n5 + n6 + n7;
        n3 = 0;
        int n11 = 0;
        for (int i = 0; i < 4352; ++i) {
            if (nArray[i] > n3) {
                n3 = nArray[i];
            }
            if (nArray[i] <= 0) continue;
            n11 += n4;
        }
        BufferedImage bufferedImage = new BufferedImage(n3 += 2, n11, 2);
        int n12 = 0;
        for (int i = 0; i < 4352; ++i) {
            if (nArray[i] <= 0) continue;
            int n13 = 0;
            RFontBitmapFontExporter.setVM(bufferedImage, n13++, n12, bitmapFont, n5, n6);
            for (int j = 0; j < 256; ++j) {
                int n14;
                if (bitmapFontGlyphArrayArray[i][j] == null) continue;
                RFontBitmapFontExporter.setCC(bufferedImage, n13, n12, n4, i << 8 | j);
                for (n14 = 0; n14 < nArrayArray[i][j]; ++n14) {
                    bufferedImage.setRGB(n13 + 1 + n14, n12, -65536);
                }
                for (n14 = 0; n14 < nArrayArray3[i][j]; ++n14) {
                    bufferedImage.setRGB(n13 + 1 + nArrayArray[i][j] + nArrayArray2[i][j] + n14, n12, -16776961);
                }
                object = bitmapFontGlyphArrayArray[i][j].getGlyph();
                n2 = 0;
                for (n = n12 + 1 + n5 - bitmapFontGlyphArrayArray[i][j].getGlyphAscent(); n2 < ((Object)object).length && n < n11; ++n2, ++n) {
                    int n15 = 0;
                    for (int k = n13 + 1 + nArrayArray[i][j] + bitmapFontGlyphArrayArray[i][j].getGlyphOffset(); n15 < ((Object)object[n2]).length && k < n3; ++n15, ++k) {
                        bufferedImage.setRGB(k, n, (object[n2][n15] & 0xFF) << 24 | this.color & 0xFFFFFF);
                    }
                }
                n13 += 1 + nArrayArray[i][j] + nArrayArray2[i][j] + nArrayArray3[i][j];
            }
            RFontBitmapFontExporter.setCC(bufferedImage, n13, n12, n4, -1);
            n12 += n4;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            if (n4 < 256) {
                dataOutputStream.writeShort(1);
                dataOutputStream.writeByte(n5);
                dataOutputStream.writeByte(bitmapFont.getLineAscent());
                dataOutputStream.writeByte(bitmapFont.getEmAscent());
                dataOutputStream.writeByte(bitmapFont.getXHeight());
                dataOutputStream.writeByte(bitmapFont.getEmDescent());
                dataOutputStream.writeByte(bitmapFont.getLineDescent());
                dataOutputStream.writeByte(n6);
                dataOutputStream.writeByte(n7);
                dataOutputStream.writeByte(n5 - 1);
                dataOutputStream.writeByte(n4 - 1);
            } else {
                dataOutputStream.writeShort(2);
                dataOutputStream.writeShort(n5);
                dataOutputStream.writeShort(bitmapFont.getLineAscent());
                dataOutputStream.writeShort(bitmapFont.getEmAscent());
                dataOutputStream.writeShort(bitmapFont.getXHeight());
                dataOutputStream.writeShort(bitmapFont.getEmDescent());
                dataOutputStream.writeShort(bitmapFont.getLineDescent());
                dataOutputStream.writeShort(n6);
                dataOutputStream.writeShort(n7);
                dataOutputStream.writeShort(n5 - 1);
                dataOutputStream.writeShort(n4 - 1);
            }
            dataOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        object = new DataOutputStream(byteArrayOutputStream2);
        try {
            int n16;
            n2 = 0;
            n = 0;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList arrayList2 = new ArrayList();
            n12 = 0;
            for (n16 = 0; n16 < 4352; ++n16) {
                if (nArray[n16] <= 0) continue;
                int n17 = 1;
                for (int i = 0; i < 256; ++i) {
                    if (bitmapFontGlyphArrayArray[n16][i] == null) continue;
                    int n18 = n16 << 8 | i;
                    int[] nArray2 = new int[]{nArrayArray[n16][i], nArrayArray2[n16][i], nArrayArray3[n16][i], nArrayArray[n16][i] + nArrayArray2[n16][i] + nArrayArray3[n16][i], n17 + 1, n12 + 1};
                    if (arrayList.isEmpty() || n18 != n + 1) {
                        arrayList.add(n18);
                        ArrayList<int[]> arrayList3 = new ArrayList<int[]>();
                        arrayList3.add(nArray2);
                        arrayList2.add(arrayList3);
                    } else {
                        ((List)arrayList2.get(arrayList2.size() - 1)).add(nArray2);
                    }
                    if (nArray2[3] > n2) {
                        n2 = nArray2[3];
                    }
                    n = n18;
                    n17 += 1 + nArrayArray[n16][i] + nArrayArray2[n16][i] + nArrayArray3[n16][i];
                }
                n12 += n4;
            }
            if (n2 < 256 && n3 < 65536 && n11 < 65536) {
                ((DataOutputStream)object).writeShort(1);
            } else {
                ((DataOutputStream)object).writeShort(2);
            }
            ((DataOutputStream)object).writeInt(arrayList.size());
            for (n16 = 0; n16 < arrayList.size(); ++n16) {
                ((DataOutputStream)object).writeInt((Integer)arrayList.get(n16));
                ((DataOutputStream)object).writeInt(((List)arrayList2.get(n16)).size());
                for (int[] nArray3 : (List)arrayList2.get(n16)) {
                    if (n2 < 256 && n3 < 65536 && n11 < 65536) {
                        ((DataOutputStream)object).writeByte(nArray3[0]);
                        ((DataOutputStream)object).writeByte(nArray3[1]);
                        ((DataOutputStream)object).writeByte(nArray3[2]);
                        ((DataOutputStream)object).writeByte(nArray3[3]);
                        ((DataOutputStream)object).writeShort(nArray3[4]);
                        ((DataOutputStream)object).writeShort(nArray3[5]);
                        continue;
                    }
                    ((DataOutputStream)object).writeShort(nArray3[0]);
                    ((DataOutputStream)object).writeShort(nArray3[1]);
                    ((DataOutputStream)object).writeShort(nArray3[2]);
                    ((DataOutputStream)object).writeShort(nArray3[3]);
                    ((DataOutputStream)object).writeInt(nArray3[4]);
                    ((DataOutputStream)object).writeInt(nArray3[5]);
                }
            }
            ((FilterOutputStream)object).close();
            byteArrayOutputStream2.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        RFontBean rFontBean = new RFontBean();
        rFontBean.fname = bitmapFont.getName(1);
        rFontBean.sname = bitmapFont.getName(2);
        rFontBean.copy = bitmapFont.getName(0);
        rFontBean.img = bufferedImage;
        rFontBean.vmtx = byteArrayOutputStream.toByteArray();
        rFontBean.hmtx = byteArrayOutputStream2.toByteArray();
        return rFontBean;
    }

    private static void setCC(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        int n5 = n2;
        bufferedImage.setRGB(n, n5++, -65281);
        for (int i = 0; i < n3 - 1; ++i) {
            bufferedImage.setRGB(n, n5++, RFontBitmapFontExporter.codepixel(n4, i));
        }
    }

    private static int codepixel(int n, int n2) {
        int n3 = (int)Math.floor((1.0 + Math.sqrt(1 + 8 * n2)) / 2.0);
        int n4 = n2 - n3 * (n3 - 1) / 2;
        int n5 = -16777216;
        int n6 = 0;
        for (int i = 20; n6 < 6 && i >= 0; ++n6, i -= 4) {
            int n7 = 5 - (n4 * 6 + n6) / n3;
            n5 |= (n >> (n7 << 2) & 0xF) << i;
        }
        return n5;
    }

    private static void setVM(BufferedImage bufferedImage, int n, int n2, BitmapFont bitmapFont, int n3, int n4) {
        int n5;
        int n6 = n2;
        bufferedImage.setRGB(n, n6++, -65281);
        for (n5 = n3; n5 > bitmapFont.getLineAscent(); --n5) {
            bufferedImage.setRGB(n, n6++, -65536);
        }
        for (n5 = bitmapFont.getLineAscent(); n5 > bitmapFont.getEmAscent(); --n5) {
            bufferedImage.setRGB(n, n6++, Short.MIN_VALUE);
        }
        for (n5 = bitmapFont.getEmAscent(); n5 > bitmapFont.getXHeight(); --n5) {
            bufferedImage.setRGB(n, n6++, -256);
        }
        for (n5 = bitmapFont.getXHeight(); n5 > 0; --n5) {
            bufferedImage.setRGB(n, n6++, 0);
        }
        for (n5 = bitmapFont.getEmDescent(); n5 > 0; --n5) {
            bufferedImage.setRGB(n, n6++, -16711936);
        }
        for (n5 = bitmapFont.getLineDescent(); n5 > bitmapFont.getEmDescent(); --n5) {
            bufferedImage.setRGB(n, n6++, -16711681);
        }
        for (n5 = n4; n5 > bitmapFont.getLineDescent(); --n5) {
            bufferedImage.setRGB(n, n6++, -16776961);
        }
        for (n5 = bitmapFont.getLineGap(); n5 > 0; --n5) {
            bufferedImage.setRGB(n, n6++, -8388353);
        }
    }

    private static IIOMetadata createMetadata(ImageWriter imageWriter, RFontBean rFontBean) {
        IIOMetadataNode iIOMetadataNode;
        IIOMetadataNode iIOMetadataNode2;
        ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(rFontBean.img);
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        IIOMetadata iIOMetadata = imageWriter.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
        String string = iIOMetadata.getNativeMetadataFormatName();
        Node node = iIOMetadata.getAsTree(string);
        if (rFontBean.fname != null || rFontBean.sname != null || rFontBean.copy != null) {
            iIOMetadataNode2 = new IIOMetadataNode("tEXt");
            if (rFontBean.fname != null) {
                iIOMetadataNode = new IIOMetadataNode("tEXtEntry");
                iIOMetadataNode.setAttribute("keyword", "FontFamily");
                iIOMetadataNode.setAttribute("value", rFontBean.fname);
                iIOMetadataNode2.appendChild(iIOMetadataNode);
            }
            if (rFontBean.sname != null) {
                iIOMetadataNode = new IIOMetadataNode("tEXtEntry");
                iIOMetadataNode.setAttribute("keyword", "FontStyle");
                iIOMetadataNode.setAttribute("value", rFontBean.sname);
                iIOMetadataNode2.appendChild(iIOMetadataNode);
            }
            if (rFontBean.copy != null) {
                iIOMetadataNode = new IIOMetadataNode("tEXtEntry");
                iIOMetadataNode.setAttribute("keyword", "Copyright");
                iIOMetadataNode.setAttribute("value", rFontBean.copy);
                iIOMetadataNode2.appendChild(iIOMetadataNode);
            }
            node.appendChild(iIOMetadataNode2);
        }
        iIOMetadataNode2 = new IIOMetadataNode("UnknownChunks");
        iIOMetadataNode = new IIOMetadataNode("UnknownChunk");
        iIOMetadataNode.setAttribute("type", "rfVM");
        iIOMetadataNode.setUserObject(rFontBean.vmtx);
        iIOMetadataNode2.appendChild(iIOMetadataNode);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("UnknownChunk");
        iIOMetadataNode3.setAttribute("type", "rfHM");
        iIOMetadataNode3.setUserObject(rFontBean.hmtx);
        iIOMetadataNode2.appendChild(iIOMetadataNode3);
        node.appendChild(iIOMetadataNode2);
        try {
            iIOMetadata.mergeTree(string, node);
        }
        catch (IIOInvalidTreeException iIOInvalidTreeException) {
            iIOInvalidTreeException.printStackTrace();
        }
        return iIOMetadata;
    }

    public class RFontBean {
        public String fname;
        public String sname;
        public String copy;
        public RenderedImage img;
        public byte[] vmtx;
        public byte[] hmtx;
    }
}

