/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.exporter;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.unicode.data.GlyphList;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FZXBitmapFontExporter
implements BitmapFontExporter {
    private GlyphList encoding;

    public FZXBitmapFontExporter() {
        this.encoding = null;
    }

    public FZXBitmapFontExporter(GlyphList glyphList) {
        this.encoding = glyphList;
    }

    public byte[] exportFontToBytes(BitmapFont bitmapFont) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.exportFontToStream(bitmapFont, (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void exportFontToStream(BitmapFont bitmapFont, OutputStream outputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = bitmapFont.getLineAscent();
        int n6 = n5 + bitmapFont.getLineDescent();
        int n7 = 255;
        for (n4 = 255; n4 > 32 && !bitmapFont.containsCharacter(this.zxcp(n4)); --n4) {
        }
        for (n3 = 32; n3 <= n4; ++n3) {
            BitmapFontGlyph bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(this.zxcp(n3));
            if (bitmapFontGlyph == null) continue;
            int n8 = bitmapFontGlyph.getCharacterWidth() - (bitmapFontGlyph.getGlyphOffset() + bitmapFontGlyph.getGlyphWidth());
            if (n8 <= 0) {
                n7 = 0;
                break;
            }
            if (n8 >= n7) continue;
            n7 = n8;
        }
        if (n6 < 1) {
            n6 = 1;
        }
        if (n6 > 255) {
            n6 = 255;
        }
        n3 = (n4 - 30) * 3;
        int n9 = n3 + 2;
        int[] nArray = new int[n4 - 31];
        int[] nArray2 = new int[n4 - 31];
        int[] nArray3 = new int[n4 - 31];
        int[] nArray4 = new int[n4 - 31];
        byte[][] byArrayArray = new byte[n4 - 31][];
        int n10 = 0;
        int n11 = 32;
        while (n11 <= n4) {
            BitmapFontGlyph bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(this.zxcp(n11));
            if (bitmapFontGlyph == null) {
                nArray[n10] = n9;
                nArray2[n10] = 0;
                nArray3[n10] = 0;
                nArray4[n10] = 1;
                byArrayArray[n10] = new byte[0];
            } else {
                int n12;
                n2 = bitmapFontGlyph.getGlyphOffset();
                n = n5 - bitmapFontGlyph.getGlyphAscent();
                int n13 = bitmapFontGlyph.getCharacterWidth() - (n2 + bitmapFontGlyph.getGlyphWidth());
                nArray[n10] = n9;
                int n14 = n2 <= -3 ? 3 : (nArray2[n10] = n2 >= 0 ? 0 : -n2);
                nArray3[n10] = n <= 0 ? 0 : (n >= 15 ? 15 : n);
                int n15 = n2 + nArray2[n10];
                int n16 = n - nArray3[n10];
                int n17 = n13 - n7;
                int n18 = bitmapFontGlyph.getGlyphWidth() + n15 + n17;
                int n19 = bitmapFontGlyph.getGlyphHeight() + n16;
                int n20 = n12 = n18 <= 8 ? 1 : 2;
                nArray4[n10] = n18 <= 1 ? 1 : (n18 >= 16 ? 16 : n18);
                byArrayArray[n10] = new byte[n19 * n12];
                boolean bl = false;
                byte[][] byArray = bitmapFontGlyph.getGlyph();
                int n21 = -n16;
                int n22 = 0;
                int n23 = 0;
                while (n23 < n19) {
                    if (n21 >= 0 && n21 < byArray.length) {
                        int n24 = -n15;
                        int n25 = 32768;
                        int n26 = 0;
                        while (n26 < nArray4[n10]) {
                            if (n24 >= 0 && n24 < byArray[n21].length && byArray[n21][n24] < 0) {
                                if (n25 < 256) {
                                    byte[] byArray2 = byArrayArray[n10];
                                    int n27 = n22 + 1;
                                    byArray2[n27] = (byte)(byArray2[n27] | n25);
                                } else {
                                    byte[] byArray3 = byArrayArray[n10];
                                    int n28 = n22;
                                    byArray3[n28] = (byte)(byArray3[n28] | n25 >> 8);
                                }
                                bl = true;
                            }
                            ++n26;
                            n25 >>= 1;
                            ++n24;
                        }
                    }
                    ++n23;
                    n22 += n12;
                    ++n21;
                }
                if (bl) {
                    n9 += byArrayArray[n10].length;
                } else {
                    nArray2[n10] = 0;
                    nArray3[n10] = 0;
                    byArrayArray[n10] = new byte[0];
                }
            }
            ++n11;
            ++n10;
        }
        outputStream.write(n6);
        outputStream.write(n7);
        outputStream.write(n4);
        n10 = 3;
        n11 = 0;
        int n29 = 32;
        while (n29 <= n4) {
            n2 = nArray[n11] - n10 & 0x3FFF | nArray2[n11] << 14;
            n = nArray3[n11] << 4 | nArray4[n11] - 1 & 0xF;
            outputStream.write(n2);
            outputStream.write(n2 >> 8);
            outputStream.write(n);
            ++n29;
            ++n11;
            n10 += 3;
        }
        outputStream.write(n9 - n3);
        outputStream.write(n9 - n3 >> 8);
        for (byte[] byArray : byArrayArray) {
            outputStream.write(byArray);
        }
    }

    public void exportFontToFile(BitmapFont bitmapFont, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.exportFontToStream(bitmapFont, (OutputStream)fileOutputStream);
        fileOutputStream.close();
    }

    private int zxcp(int n) {
        if (this.encoding != null) {
            return this.encoding.get(n);
        }
        if (n == 96) {
            return 163;
        }
        if (n == 127) {
            return 169;
        }
        if (n < 128) {
            return n;
        }
        return 61440 + n;
    }
}

