/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.edit.GlyphList;
import com.kreative.bitsnpicas.edit.GlyphListModel;
import com.kreative.bitsnpicas.edit.GlyphLocator;
import com.kreative.bitsnpicas.edit.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetSelectionDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final GlyphList<?> gl;
    private JRadioButton byCodePointButton;
    private JRadioButton byIndexButton;
    private JTextArea selectionField;
    private JButton cancelButton;
    private JButton okButton;
    private static final Pattern RANGE_PATTERN = Pattern.compile("\\{([0-9]+)(-+|:+|\\.\\.+)([0-9]+)\\}");

    public SetSelectionDialog(Dialog dialog, GlyphList<?> glyphList) {
        super(dialog, "Set Selection");
        this.setModal(true);
        this.gl = glyphList;
        this.make();
    }

    public SetSelectionDialog(Frame frame, GlyphList<?> glyphList) {
        super(frame, "Set Selection");
        this.setModal(true);
        this.gl = glyphList;
        this.make();
    }

    public SetSelectionDialog(Window window, GlyphList<?> glyphList) {
        super(window, "Set Selection");
        this.setModal(true);
        this.gl = glyphList;
        this.make();
    }

    private void make() {
        this.byCodePointButton = new JRadioButton("By Code Point");
        this.byIndexButton = new JRadioButton("By Index");
        this.selectionField = new JTextArea();
        this.cancelButton = new JButton("Cancel");
        this.okButton = new JButton("OK");
        boolean bl = SetSelectionDialog.isUnicodeRange(this.gl.getModel());
        this.byCodePointButton.setSelected(bl);
        this.byIndexButton.setSelected(!bl);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.byCodePointButton);
        buttonGroup.add(this.byIndexButton);
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 8, 8));
        jPanel.add(this.byCodePointButton);
        jPanel.add(this.byIndexButton);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 4, 4));
        jPanel2.add(jPanel);
        jPanel2.add(new JLabel("(Non-numeric values will be treated as glyph names.)"));
        Dimension dimension = new Dimension(240, 120);
        this.selectionField.setMinimumSize(dimension);
        this.selectionField.setPreferredSize(dimension);
        this.selectionField.setLineWrap(true);
        this.selectionField.setWrapStyleWord(true);
        this.selectionField.setText(SetSelectionDialog.selectionToString(this.gl.getSelection(), !bl));
        JScrollPane jScrollPane = new JScrollPane(this.selectionField, 22, 31);
        JPanel jPanel3 = new JPanel(new BorderLayout(8, 8));
        jPanel3.add((Component)jPanel2, "First");
        jPanel3.add((Component)jScrollPane, "Center");
        JPanel jPanel4 = new JPanel(new FlowLayout());
        jPanel4.add(this.cancelButton);
        jPanel4.add(this.okButton);
        JPanel jPanel5 = new JPanel(new BorderLayout(8, 8));
        jPanel5.add((Component)jPanel3, "Center");
        jPanel5.add((Component)jPanel4, "Last");
        jPanel5.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.setContentPane(jPanel5);
        SwingUtils.setCancelButton(this.getRootPane(), this.cancelButton);
        SwingUtils.setDefaultButton(this.getRootPane(), this.okButton);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(null);
        this.selectionField.requestFocusInWindow();
        this.byCodePointButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetSelectionDialog.this.selectionField.setText(SetSelectionDialog.selectionToString(SetSelectionDialog.this.gl.getSelection(), false));
            }
        });
        this.byIndexButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetSelectionDialog.this.selectionField.setText(SetSelectionDialog.selectionToString(SetSelectionDialog.this.gl.getSelection(), true));
            }
        });
        this.selectionField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        SetSelectionDialog.this.okButton.doClick();
                        break;
                    }
                    case 27: {
                        SetSelectionDialog.this.cancelButton.doClick();
                        break;
                    }
                    case 85: {
                        if (!keyEvent.isControlDown() && !keyEvent.isMetaDown()) break;
                        SetSelectionDialog.this.byCodePointButton.doClick();
                        break;
                    }
                    case 73: {
                        if (!keyEvent.isControlDown() && !keyEvent.isMetaDown()) break;
                        SetSelectionDialog.this.byIndexButton.doClick();
                    }
                }
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetSelectionDialog.this.gl.setSelectedIndices(SetSelectionDialog.stringToIndices(SetSelectionDialog.this.selectionField.getText(), SetSelectionDialog.this.gl.getModel(), SetSelectionDialog.this.byIndexButton.isSelected()), true);
                SetSelectionDialog.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetSelectionDialog.this.dispose();
            }
        });
    }

    private static boolean isUnicodeRange(GlyphListModel glyphListModel) {
        int n = -1;
        int n2 = glyphListModel.getCellCount();
        for (int i = 0; i < n2; ++i) {
            int n3;
            block4: {
                block3: {
                    if (!glyphListModel.isCodePoint(i)) break block3;
                    n3 = glyphListModel.getCodePoint(i);
                    if (n < 0 || n + 1 == n3) break block4;
                }
                return false;
            }
            n = n3;
        }
        return true;
    }

    private static String selectionToString(Collection<? extends GlyphLocator<?>> collection, boolean bl) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (GlyphLocator<?> object2 : collection) {
            if (bl) {
                arrayList.add(object2.getGlyphIndex());
                continue;
            }
            if (object2.isCodePoint()) {
                arrayList.add(object2.getCodePoint());
                continue;
            }
            if (!object2.isGlyphName()) continue;
            arrayList2.add(object2.getGlyphName());
        }
        Collections.sort(arrayList);
        Collections.sort(arrayList2);
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<int[]> arrayList3 = new ArrayList<int[]>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int nArray = (Integer)iterator.next();
            if (arrayList3.isEmpty()) {
                arrayList3.add(new int[]{nArray, nArray});
                continue;
            }
            if (nArray == ((int[])arrayList3.get(arrayList3.size() - 1))[1] + 1) {
                ((int[])arrayList3.get((int)(arrayList3.size() - 1)))[1] = nArray;
                continue;
            }
            arrayList3.add(new int[]{nArray, nArray});
        }
        for (int[] string : arrayList3) {
            int n;
            String string2;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            if (bl) {
                stringBuffer.append(string[0]);
            } else {
                stringBuffer.append("U+");
                string2 = Integer.toHexString(string[0]).toUpperCase();
                for (n = string2.length(); n < 4; ++n) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string2);
            }
            if (string[0] == string[1]) continue;
            stringBuffer.append("-");
            if (bl) {
                stringBuffer.append(string[1]);
                continue;
            }
            stringBuffer.append("U+");
            string2 = Integer.toHexString(string[1]).toUpperCase();
            for (n = string2.length(); n < 4; ++n) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string2);
        }
        for (String string : arrayList2) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private static Collection<Integer> stringToIndices(String string, GlyphListModel glyphListModel, boolean bl) {
        String[] stringArray;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (String string2 : stringArray = string.split("[,;]")) {
            try {
                int n;
                int n2;
                int[] nArray = SetSelectionDialog.parseRange(string2);
                if (bl) {
                    n2 = glyphListModel.getCellCount();
                    for (n = nArray[0]; n <= nArray[1]; ++n) {
                        if (n < 0 || n >= n2) continue;
                        treeSet.add(n);
                    }
                    continue;
                }
                for (n2 = nArray[0]; n2 <= nArray[1]; ++n2) {
                    n = glyphListModel.indexOfCodePoint(n2);
                    if (n < 0) continue;
                    treeSet.add(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                string2 = string2.trim();
                if (string2.length() <= 0) continue;
                TreeSet<String> treeSet2 = new TreeSet<String>();
                SetSelectionDialog.parseGlyphNames(string2, treeSet2);
                for (String string3 : treeSet2) {
                    int n = glyphListModel.indexOfGlyphName(string3);
                    if (n < 0) continue;
                    treeSet.add(n);
                }
            }
        }
        return treeSet;
    }

    private static int[] parseRange(String string) {
        String[] stringArray = string.split("-+|:+|\\.\\.+", 2);
        if (stringArray.length == 2) {
            int n = SetSelectionDialog.parseInt(stringArray[0].trim());
            int n2 = SetSelectionDialog.parseInt(stringArray[1].trim());
            int n3 = Math.min(n, n2);
            int n4 = Math.max(n, n2);
            return new int[]{n3, n4};
        }
        int n = SetSelectionDialog.parseInt(string.trim());
        return new int[]{n, n};
    }

    private static int parseInt(String string) {
        if (string.startsWith("0x")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        if (string.startsWith("0X")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        if (string.startsWith("U+")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        if (string.startsWith("u+")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        if (string.startsWith("$")) {
            return Integer.parseInt(string.substring(1), 16);
        }
        if (string.startsWith("#")) {
            return Integer.parseInt(string.substring(1), 10);
        }
        return Integer.parseInt(string, 10);
    }

    private static void parseGlyphNames(String string, Collection<String> collection) {
        Matcher matcher = RANGE_PATTERN.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(3);
            int n = Integer.parseInt(string2);
            int n2 = Integer.parseInt(string3);
            int n3 = Math.min(string2.length(), string3.length());
            int n4 = Math.min(n, n2);
            int n5 = Math.max(n, n2);
            String string4 = string.substring(0, matcher.start());
            String string5 = string.substring(matcher.end());
            for (int i = n4; i <= n5; ++i) {
                String string6 = Integer.toString(i);
                while (string6.length() < n3) {
                    string6 = "0" + string6;
                }
                SetSelectionDialog.parseGlyphNames(string4 + string6 + string5, collection);
            }
        } else {
            collection.add(string);
        }
    }
}

