/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.FontGlyph;
import com.kreative.bitsnpicas.edit.GlyphList;
import com.kreative.bitsnpicas.edit.GlyphListModel;
import com.kreative.bitsnpicas.edit.GlyphLocator;
import com.kreative.bitsnpicas.edit.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MoveGlyphsDialog<G extends FontGlyph, S>
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final boolean copy;
    private final GlyphList<G> glyphList;
    private JRadioButton byCodePointButton;
    private JRadioButton byIndexButton;
    private JTextField offsetField;
    private JButton cancelButton;
    private JButton okButton;

    public MoveGlyphsDialog(Dialog dialog, boolean bl, GlyphList<G> glyphList) {
        super(dialog, bl ? "Copy Glyphs" : "Move Glyphs");
        this.copy = bl;
        this.glyphList = glyphList;
        this.setModal(true);
        this.make();
    }

    public MoveGlyphsDialog(Frame frame, boolean bl, GlyphList<G> glyphList) {
        super(frame, bl ? "Copy Glyphs" : "Move Glyphs");
        this.copy = bl;
        this.glyphList = glyphList;
        this.setModal(true);
        this.make();
    }

    public MoveGlyphsDialog(Window window, boolean bl, GlyphList<G> glyphList) {
        super(window, bl ? "Copy Glyphs" : "Move Glyphs");
        this.copy = bl;
        this.glyphList = glyphList;
        this.setModal(true);
        this.make();
    }

    private void make() {
        final List<GlyphLocator<G>> list = this.glyphList.getSelection();
        GlyphListModel glyphListModel = this.glyphList.getModel();
        Boolean bl = glyphListModel.tracksFont() ? (this.copy ? Boolean.FALSE : null) : Boolean.valueOf(!MoveGlyphsDialog.isUnicodeRange(glyphListModel));
        this.byCodePointButton = new JRadioButton("By Code Point");
        this.byIndexButton = new JRadioButton("By Index");
        this.offsetField = new JTextField("+0");
        this.cancelButton = new JButton("Cancel");
        this.okButton = new JButton("OK");
        if (bl == null) {
            this.byCodePointButton.setSelected(true);
            this.byIndexButton.setSelected(false);
            this.byIndexButton.setEnabled(false);
        } else {
            this.byCodePointButton.setSelected(bl == false);
            this.byIndexButton.setSelected(bl);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.byCodePointButton);
        buttonGroup.add(this.byIndexButton);
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 8, 8));
        jPanel.add(this.byCodePointButton);
        jPanel.add(this.byIndexButton);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 4, 4));
        jPanel2.add(jPanel);
        jPanel2.add(new JLabel("(Non-numeric values will be treated as glyph names.)"));
        JPanel jPanel3 = new JPanel(new BorderLayout(8, 8));
        jPanel3.add((Component)jPanel2, "First");
        jPanel3.add((Component)this.offsetField, "Center");
        JPanel jPanel4 = new JPanel(new FlowLayout());
        jPanel4.add(this.cancelButton);
        jPanel4.add(this.okButton);
        JPanel jPanel5 = new JPanel(new BorderLayout(8, 8));
        jPanel5.add((Component)jPanel3, "Center");
        jPanel5.add((Component)jPanel4, "Last");
        jPanel5.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.setContentPane(jPanel5);
        SwingUtils.setCancelButton(this.getRootPane(), this.cancelButton);
        SwingUtils.setDefaultButton(this.getRootPane(), this.okButton);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(null);
        this.offsetField.requestFocusInWindow();
        this.offsetField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        MoveGlyphsDialog.this.okButton.doClick();
                        break;
                    }
                    case 27: {
                        MoveGlyphsDialog.this.cancelButton.doClick();
                        break;
                    }
                    case 85: {
                        if (!keyEvent.isControlDown() && !keyEvent.isMetaDown()) break;
                        MoveGlyphsDialog.this.byCodePointButton.doClick();
                        break;
                    }
                    case 73: {
                        if (!keyEvent.isControlDown() && !keyEvent.isMetaDown()) break;
                        MoveGlyphsDialog.this.byIndexButton.doClick();
                    }
                }
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = MoveGlyphsDialog.this.offsetField.getText().trim();
                boolean bl = MoveGlyphsDialog.this.byIndexButton.isSelected();
                try {
                    int n;
                    boolean bl2;
                    if (string.startsWith("+")) {
                        bl2 = true;
                        n = MoveGlyphsDialog.parseInt(string.substring(1));
                    } else if (string.startsWith("-")) {
                        bl2 = true;
                        n = -MoveGlyphsDialog.parseInt(string.substring(1));
                    } else if (string.startsWith("@")) {
                        bl2 = false;
                        n = MoveGlyphsDialog.parseInt(string.substring(1));
                    } else {
                        bl2 = false;
                        n = MoveGlyphsDialog.parseInt(string);
                    }
                    List list2 = MoveGlyphsDialog.this.serializeGlyphs(list);
                    if (!MoveGlyphsDialog.this.copy) {
                        MoveGlyphsDialog.this.glyphList.deleteSelection();
                    }
                    if (bl) {
                        MoveGlyphsDialog.this.moveByIndex(list, list2, bl2, n);
                    } else {
                        MoveGlyphsDialog.this.moveByCodePoint(list, list2, bl2, n);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (string.length() > 0) {
                        List list3 = MoveGlyphsDialog.this.serializeGlyphs(list);
                        if (!MoveGlyphsDialog.this.copy) {
                            MoveGlyphsDialog.this.glyphList.deleteSelection();
                        }
                        MoveGlyphsDialog.this.moveByGlyphName(list, list3, string);
                    }
                    Toolkit.getDefaultToolkit().beep();
                }
                MoveGlyphsDialog.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MoveGlyphsDialog.this.dispose();
            }
        });
    }

    public abstract S serializeGlyph(G var1);

    public abstract G deserializeGlyph(S var1);

    private static boolean isUnicodeRange(GlyphListModel glyphListModel) {
        int n = -1;
        int n2 = glyphListModel.getCellCount();
        for (int i = 0; i < n2; ++i) {
            int n3;
            block4: {
                block3: {
                    if (!glyphListModel.isCodePoint(i)) break block3;
                    n3 = glyphListModel.getCodePoint(i);
                    if (n < 0 || n + 1 == n3) break block4;
                }
                return false;
            }
            n = n3;
        }
        return true;
    }

    private static int parseInt(String string) {
        if (string.startsWith("0x")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        if (string.startsWith("0X")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        if (string.startsWith("U+")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        if (string.startsWith("u+")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        if (string.startsWith("$")) {
            return Integer.parseInt(string.substring(1), 16);
        }
        if (string.startsWith("#")) {
            return Integer.parseInt(string.substring(1), 10);
        }
        return Integer.parseInt(string, 10);
    }

    private List<S> serializeGlyphs(List<GlyphLocator<G>> list) {
        ArrayList<S> arrayList = new ArrayList<S>();
        for (GlyphLocator<G> glyphLocator : list) {
            G g = glyphLocator.getGlyph();
            if (g == null) {
                arrayList.add(null);
                continue;
            }
            arrayList.add(this.serializeGlyph(g));
        }
        return arrayList;
    }

    private void moveByIndex(List<GlyphLocator<G>> list, List<S> list2, boolean bl, int n) {
        Font<G> font = this.glyphList.getGlyphFont();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        GlyphListModel glyphListModel = this.glyphList.getModel();
        int n2 = glyphListModel.getCellCount();
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            int n4 = list.get(i).getGlyphIndex();
            if (n4 < 0) continue;
            n4 = bl ? (n4 += n) : n + i;
            if (n4 < 0 || n4 >= n2) continue;
            treeSet.add(n4);
            S s = list2.get(i);
            if (s == null) continue;
            new GlyphLocator<G>(font, glyphListModel, n4).setGlyph(this.deserializeGlyph(s));
        }
        this.glyphList.glyphRepertoireChanged();
        this.glyphList.setSelectedIndices(treeSet, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void moveByCodePoint(List<GlyphLocator<G>> list, List<S> list2, boolean bl, int n) {
        Font<G> font = this.glyphList.getGlyphFont();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        ArrayList<GlyphLocator<G>> arrayList = new ArrayList<GlyphLocator<G>>();
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            int n3;
            block7: {
                if (bl) {
                    GlyphLocator<G> glyphLocator = list.get(i);
                    if (glyphLocator.isCodePoint()) {
                        n3 = glyphLocator.getCodePoint() + n;
                        break block7;
                    } else {
                        arrayList.add(glyphLocator);
                        S s = list2.get(i);
                        if (s == null) continue;
                        glyphLocator.setGlyph(this.deserializeGlyph(s));
                        continue;
                    }
                }
                n3 = n + i;
            }
            if (!Character.isValidCodePoint(n3)) continue;
            treeSet.add(n3);
            S s = list2.get(i);
            if (s == null) continue;
            font.putCharacter(n3, this.deserializeGlyph(s));
        }
        this.glyphList.glyphRepertoireChanged();
        GlyphListModel glyphListModel = this.glyphList.getModel();
        TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            treeSet2.add(glyphListModel.indexOfCodePoint(n4));
        }
        iterator = arrayList.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.glyphList.setSelectedIndices(treeSet2, true);
                return;
            }
            GlyphLocator glyphLocator = (GlyphLocator)iterator.next();
            treeSet2.add(glyphLocator.getGlyphIndex());
        }
    }

    private void moveByGlyphName(List<GlyphLocator<G>> list, List<S> list2, String string) {
        Font<G> font = this.glyphList.getGlyphFont();
        TreeSet<String> treeSet = new TreeSet<String>();
        GlyphListModel glyphListModel = this.glyphList.getModel();
        int n = glyphListModel.getCellCount();
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            String string2 = this.formatGlyphName(string, i, n2, list.get(i), n);
            if (string2.length() == 0) continue;
            treeSet.add(string2);
            S s = list2.get(i);
            if (s == null) continue;
            font.putNamedGlyph(string2, this.deserializeGlyph(s));
        }
        this.glyphList.glyphRepertoireChanged();
        TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
        for (String string2 : treeSet) {
            treeSet2.add(glyphListModel.indexOfGlyphName(string2));
        }
        this.glyphList.setSelectedIndices(treeSet2, true);
    }

    private String formatGlyphName(String string, int n, int n2, GlyphLocator<G> glyphLocator, int n3) {
        int n4 = glyphLocator.getGlyphIndex();
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n5 = 0;
        int n6 = cArray.length;
        block17: while (n5 < n6) {
            char c;
            if ((c = cArray[n5++]) == '%' && n5 < n6) {
                StringBuffer stringBuffer2 = new StringBuffer();
                int n7 = 0;
                char c2 = cArray[n5++];
                int n8 = Character.digit(c2, 10);
                while (n8 >= 0 && n5 < n6) {
                    stringBuffer2.append(c2);
                    n7 = n7 * 10 + n8;
                    c2 = cArray[n5++];
                    n8 = Character.digit(c2, 10);
                }
                switch (c2) {
                    case '%': {
                        stringBuffer.append('%');
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        int n9;
                        if (!glyphLocator.isCodePoint()) continue block17;
                        String string2 = Integer.toString(glyphLocator.getCodePoint());
                        for (n9 = string2.length(); n9 < n7; ++n9) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(string2);
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        int n9;
                        if (!glyphLocator.isCodePoint()) continue block17;
                        String string2 = Integer.toHexString(glyphLocator.getCodePoint());
                        if (c2 == 'x') {
                            string2 = string2.toLowerCase();
                        }
                        if (c2 == 'X') {
                            string2 = string2.toUpperCase();
                        }
                        for (n9 = string2.length(); n9 < n7; ++n9) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(string2);
                        break;
                    }
                    case 'S': 
                    case 's': {
                        int n9;
                        String string2;
                        if (glyphLocator.isCodePoint()) {
                            n9 = glyphLocator.getCodePoint();
                            string2 = Integer.toHexString(n9).toUpperCase();
                            while (string2.length() < 4) {
                                string2 = "0" + string2;
                            }
                            string2 = n9 < 65536 ? "uni" + string2 : "u" + string2;
                        } else {
                            string2 = glyphLocator.isGlyphName() ? glyphLocator.getGlyphName() : "";
                        }
                        if (n5 < n6 && cArray[n5] == '/') {
                            char c3;
                            char c4;
                            ++n5;
                            StringBuffer stringBuffer3 = new StringBuffer();
                            while (n5 < n6 && (c4 = cArray[n5++]) != '/') {
                                if (c4 == '\\' && n5 < n6 && (c4 = cArray[n5++]) != '/') {
                                    stringBuffer3.append('\\');
                                }
                                stringBuffer3.append(c4);
                            }
                            StringBuffer stringBuffer4 = new StringBuffer();
                            while (n5 < n6 && (c3 = cArray[n5++]) != '/') {
                                if (c3 == '\\' && n5 < n6 && (c3 = cArray[n5++]) != '/') {
                                    stringBuffer4.append('\\');
                                }
                                stringBuffer4.append(c3);
                            }
                            try {
                                string2 = string2.replaceAll(stringBuffer3.toString(), stringBuffer4.toString());
                            }
                            catch (PatternSyntaxException patternSyntaxException) {
                                string2 = string2.replace(stringBuffer3.toString(), stringBuffer4.toString());
                            }
                        }
                        stringBuffer.append(string2);
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        int n9;
                        if (n4 < 0) continue block17;
                        String string2 = Integer.toString(n4);
                        for (n9 = string2.length(); n9 < n7; ++n9) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(string2);
                        break;
                    }
                    case 'O': 
                    case 'o': {
                        int n9;
                        if (n4 < 0) continue block17;
                        String string2 = Integer.toString(n4, 8);
                        for (n9 = string2.length(); n9 < n7; ++n9) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(string2);
                        break;
                    }
                    case 'H': 
                    case 'h': {
                        int n9;
                        if (n4 < 0) continue block17;
                        String string2 = Integer.toHexString(n4);
                        if (c2 == 'h') {
                            string2 = string2.toLowerCase();
                        }
                        if (c2 == 'H') {
                            string2 = string2.toUpperCase();
                        }
                        for (n9 = string2.length(); n9 < n7; ++n9) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(string2);
                        break;
                    }
                    case 'i': {
                        int n9;
                        if (n < 0) continue block17;
                        String string2 = Integer.toString(n);
                        for (n9 = string2.length(); n9 < n7; ++n9) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(string2);
                        break;
                    }
                    case 'j': {
                        int n9;
                        if (n < 0) continue block17;
                        String string2 = Integer.toString(n + 1);
                        for (n9 = string2.length(); n9 < n7; ++n9) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(string2);
                        break;
                    }
                    case 'n': {
                        int n9;
                        if (n2 < 0) continue block17;
                        String string2 = Integer.toString(n2);
                        for (n9 = string2.length(); n9 < n7; ++n9) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(string2);
                        break;
                    }
                    case 'I': {
                        int n9;
                        if (n4 < 0) continue block17;
                        String string2 = Integer.toString(n4);
                        for (n9 = string2.length(); n9 < n7; ++n9) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(string2);
                        break;
                    }
                    case 'J': {
                        int n9;
                        if (n4 < 0) continue block17;
                        String string2 = Integer.toString(n4 + 1);
                        for (n9 = string2.length(); n9 < n7; ++n9) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(string2);
                        break;
                    }
                    case 'N': {
                        int n9;
                        if (n3 < 0) continue block17;
                        String string2 = Integer.toString(n3);
                        for (n9 = string2.length(); n9 < n7; ++n9) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(string2);
                        break;
                    }
                    default: {
                        stringBuffer.append('%');
                        stringBuffer.append(stringBuffer2);
                        stringBuffer.append(c2);
                        break;
                    }
                }
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString().trim();
    }
}

