/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.edit.CommonMenuItems;
import com.kreative.bitsnpicas.edit.GlyphList;
import com.kreative.bitsnpicas.edit.SaveManager;
import com.kreative.bitsnpicas.edit.SetSelectionDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyphListMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 1L;

    public GlyphListMenuBar(Frame frame, SaveManager saveManager, Font<?> font, GlyphList<?> glyphList) {
        this.add(new FileMenu(frame, saveManager, font));
        this.add(new EditMenu(frame, glyphList));
        this.add(new ViewMenu(frame, glyphList));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class RowCountMenuItem
    extends JRadioButtonMenuItem {
        private static final long serialVersionUID = 1L;

        public RowCountMenuItem(ButtonGroup buttonGroup, final Frame frame, final GlyphList<?> glyphList, final int n, KeyStroke keyStroke) {
            super(n + " Cell High Window");
            this.setAccelerator(keyStroke);
            this.setSelected(glyphList.getRowCount() == n);
            buttonGroup.add(this);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    glyphList.setRowCount(n);
                    RowCountMenuItem.this.setSelected(true);
                    frame.pack();
                }
            });
            glyphList.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    RowCountMenuItem.this.setSelected(glyphList.getRowCount() == n);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ColumnCountMenuItem
    extends JRadioButtonMenuItem {
        private static final long serialVersionUID = 1L;

        public ColumnCountMenuItem(ButtonGroup buttonGroup, final Frame frame, final GlyphList<?> glyphList, final int n, KeyStroke keyStroke) {
            super(n + " Cell Wide Window");
            this.setAccelerator(keyStroke);
            this.setSelected(glyphList.getColumnCount() == n);
            buttonGroup.add(this);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    glyphList.setColumnCount(n);
                    ColumnCountMenuItem.this.setSelected(true);
                    frame.pack();
                }
            });
            glyphList.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    ColumnCountMenuItem.this.setSelected(glyphList.getColumnCount() == n);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CellSizeMenuItem
    extends JRadioButtonMenuItem {
        private static final long serialVersionUID = 1L;

        public CellSizeMenuItem(ButtonGroup buttonGroup, final Frame frame, final GlyphList<?> glyphList, final int n, KeyStroke keyStroke) {
            super(n + " Pixel Cell Size");
            this.setAccelerator(keyStroke);
            this.setSelected(glyphList.getCellSize() == n);
            buttonGroup.add(this);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    glyphList.setCellSize(n);
                    CellSizeMenuItem.this.setSelected(true);
                    frame.pack();
                }
            });
            glyphList.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    CellSizeMenuItem.this.setSelected(glyphList.getCellSize() == n);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ZoomOutMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public ZoomOutMenuItem(final Frame frame, final GlyphList<?> glyphList) {
            super("Zoom Out");
            this.setAccelerator(KeyStroke.getKeyStroke(45, CommonMenuItems.SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    switch (glyphList.getCellSize()) {
                        case 24: {
                            glyphList.setCellSize(12);
                            break;
                        }
                        case 36: {
                            glyphList.setCellSize(24);
                            break;
                        }
                        case 48: {
                            glyphList.setCellSize(36);
                            break;
                        }
                        case 72: {
                            glyphList.setCellSize(48);
                            break;
                        }
                        case 96: {
                            glyphList.setCellSize(72);
                            break;
                        }
                        case 128: {
                            glyphList.setCellSize(96);
                        }
                    }
                    frame.pack();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ZoomInMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public ZoomInMenuItem(final Frame frame, final GlyphList<?> glyphList) {
            super("Zoom In");
            this.setAccelerator(KeyStroke.getKeyStroke(61, CommonMenuItems.SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    switch (glyphList.getCellSize()) {
                        case 12: {
                            glyphList.setCellSize(24);
                            break;
                        }
                        case 24: {
                            glyphList.setCellSize(36);
                            break;
                        }
                        case 36: {
                            glyphList.setCellSize(48);
                            break;
                        }
                        case 48: {
                            glyphList.setCellSize(72);
                            break;
                        }
                        case 72: {
                            glyphList.setCellSize(96);
                            break;
                        }
                        case 96: {
                            glyphList.setCellSize(128);
                        }
                    }
                    frame.pack();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ViewMenu
    extends JMenu {
        private static final long serialVersionUID = 1L;

        public ViewMenu(Frame frame, GlyphList<?> glyphList) {
            super("View");
            this.add(new ZoomOutMenuItem(frame, glyphList));
            this.add(new ZoomInMenuItem(frame, glyphList));
            this.addSeparator();
            ButtonGroup buttonGroup = new ButtonGroup();
            this.add(new CellSizeMenuItem(buttonGroup, frame, glyphList, 12, KeyStroke.getKeyStroke(49, CommonMenuItems.SHORTCUT_KEY)));
            this.add(new CellSizeMenuItem(buttonGroup, frame, glyphList, 24, KeyStroke.getKeyStroke(50, CommonMenuItems.SHORTCUT_KEY)));
            this.add(new CellSizeMenuItem(buttonGroup, frame, glyphList, 36, KeyStroke.getKeyStroke(51, CommonMenuItems.SHORTCUT_KEY)));
            this.add(new CellSizeMenuItem(buttonGroup, frame, glyphList, 48, KeyStroke.getKeyStroke(52, CommonMenuItems.SHORTCUT_KEY)));
            this.add(new CellSizeMenuItem(buttonGroup, frame, glyphList, 72, KeyStroke.getKeyStroke(53, CommonMenuItems.SHORTCUT_KEY)));
            this.add(new CellSizeMenuItem(buttonGroup, frame, glyphList, 96, KeyStroke.getKeyStroke(54, CommonMenuItems.SHORTCUT_KEY)));
            this.add(new CellSizeMenuItem(buttonGroup, frame, glyphList, 128, KeyStroke.getKeyStroke(55, CommonMenuItems.SHORTCUT_KEY)));
            this.addSeparator();
            ButtonGroup buttonGroup2 = new ButtonGroup();
            this.add(new ColumnCountMenuItem(buttonGroup2, frame, glyphList, 8, KeyStroke.getKeyStroke(56, CommonMenuItems.SHORTCUT_KEY)));
            this.add(new ColumnCountMenuItem(buttonGroup2, frame, glyphList, 16, KeyStroke.getKeyStroke(57, CommonMenuItems.SHORTCUT_KEY)));
            this.add(new ColumnCountMenuItem(buttonGroup2, frame, glyphList, 32, KeyStroke.getKeyStroke(48, CommonMenuItems.SHORTCUT_KEY)));
            this.addSeparator();
            ButtonGroup buttonGroup3 = new ButtonGroup();
            this.add(new RowCountMenuItem(buttonGroup3, frame, glyphList, 4, KeyStroke.getKeyStroke(56, CommonMenuItems.SHORTCUT_KEY | 1)));
            this.add(new RowCountMenuItem(buttonGroup3, frame, glyphList, 8, KeyStroke.getKeyStroke(57, CommonMenuItems.SHORTCUT_KEY | 1)));
            this.add(new RowCountMenuItem(buttonGroup3, frame, glyphList, 16, KeyStroke.getKeyStroke(48, CommonMenuItems.SHORTCUT_KEY | 1)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DeleteMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public DeleteMenuItem(final GlyphList<?> glyphList) {
            super("Delete Glyphs");
            this.setAccelerator(KeyStroke.getKeyStroke(68, CommonMenuItems.SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (glyphList.getSelection().isEmpty()) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    glyphList.deleteSelection();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EditMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public EditMenuItem(final GlyphList<?> glyphList) {
            super("Edit Glyphs");
            this.setAccelerator(KeyStroke.getKeyStroke(69, CommonMenuItems.SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (glyphList.getSelection().isEmpty()) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    glyphList.openSelection();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SetSelectionMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public SetSelectionMenuItem(final Frame frame, final GlyphList<?> glyphList) {
            super("Set Selection...");
            this.setAccelerator(KeyStroke.getKeyStroke(46, CommonMenuItems.SHORTCUT_KEY | 1));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    new SetSelectionDialog(frame, glyphList).setVisible(true);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SelectNoneMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public SelectNoneMenuItem(final GlyphList<?> glyphList) {
            super("Select None");
            this.setAccelerator(KeyStroke.getKeyStroke(65, CommonMenuItems.SHORTCUT_KEY | 1));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    glyphList.clearSelection();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SelectAllMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public SelectAllMenuItem(final GlyphList<?> glyphList) {
            super("Select All");
            this.setAccelerator(KeyStroke.getKeyStroke(65, CommonMenuItems.SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    glyphList.selectAll();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EditMenu
    extends JMenu {
        private static final long serialVersionUID = 1L;

        public EditMenu(Frame frame, GlyphList<?> glyphList) {
            super("Edit");
            this.add(new SelectAllMenuItem(glyphList));
            this.add(new SelectNoneMenuItem(glyphList));
            this.add(new SetSelectionMenuItem(frame, glyphList));
            this.addSeparator();
            this.add(new EditMenuItem(glyphList));
            this.add(new DeleteMenuItem(glyphList));
            this.addSeparator();
            this.add(new CommonMenuItems.FontMapMenuItem());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FileMenu
    extends JMenu {
        private static final long serialVersionUID = 1L;

        public FileMenu(Frame frame, SaveManager saveManager, Font<?> font) {
            super("File");
            this.add(new CommonMenuItems.NewMenu());
            this.add(new CommonMenuItems.OpenMenuItem());
            this.add(new CommonMenuItems.CloseMenuItem(frame));
            this.addSeparator();
            this.add(new CommonMenuItems.SaveMenuItem(saveManager));
            this.add(new CommonMenuItems.SaveAsMenuItem(saveManager));
            this.addSeparator();
            this.add(new CommonMenuItems.FontInfoMenuItem(font, saveManager));
            if (!CommonMenuItems.IS_MAC_OS) {
                this.addSeparator();
                this.add(new CommonMenuItems.ExitMenuItem());
            }
        }
    }
}

