/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.edit.GlyphListModel;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyphListFontModel
implements GlyphListModel {
    private final Font<?> font;
    private final boolean codePoints;
    private final boolean glyphNames;
    private final List<Object> ids;
    private final String name;

    public GlyphListFontModel(Font<?> font, boolean bl, boolean bl2, String string) {
        this.font = font;
        this.codePoints = bl;
        this.glyphNames = bl2;
        this.ids = new ArrayList<Object>();
        if (bl) {
            this.ids.addAll(font.characters(false).keySet());
        }
        if (bl2) {
            int n = this.ids.size();
            this.ids.addAll(font.namedGlyphs(false).keySet());
            this.ids.remove(".notdef");
            this.ids.add(n, ".notdef");
        }
        this.name = string;
    }

    @Override
    public boolean tracksFont() {
        this.ids.clear();
        if (this.codePoints) {
            this.ids.addAll(this.font.characters(false).keySet());
        }
        if (this.glyphNames) {
            int n = this.ids.size();
            this.ids.addAll(this.font.namedGlyphs(false).keySet());
            this.ids.remove(".notdef");
            this.ids.add(n, ".notdef");
        }
        return true;
    }

    @Override
    public int getCellCount() {
        return this.ids.size();
    }

    @Override
    public boolean isCodePoint(int n) {
        Object object = this.ids.get(n);
        if (!(object instanceof Integer)) {
            return false;
        }
        return Character.isValidCodePoint((Integer)object);
    }

    @Override
    public Integer getCodePoint(int n) {
        Object object = this.ids.get(n);
        if (!(object instanceof Integer)) {
            return null;
        }
        return (Integer)object;
    }

    @Override
    public int indexOfCodePoint(Integer n) {
        return this.ids.indexOf(n);
    }

    @Override
    public boolean isGlyphName(int n) {
        Object object = this.ids.get(n);
        if (!(object instanceof String)) {
            return false;
        }
        return ((String)object).length() > 0;
    }

    @Override
    public String getGlyphName(int n) {
        Object object = this.ids.get(n);
        if (!(object instanceof String)) {
            return null;
        }
        return (String)object;
    }

    @Override
    public int indexOfGlyphName(String string) {
        return this.ids.indexOf(string);
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public String getURL() {
        return null;
    }

    @Override
    public String getIconGroup() {
        return "font";
    }

    public boolean equals(Object object) {
        if (object instanceof GlyphListFontModel) {
            GlyphListFontModel glyphListFontModel = (GlyphListFontModel)object;
            return this.font == glyphListFontModel.font && this.codePoints == glyphListFontModel.codePoints && this.glyphNames == glyphListFontModel.glyphNames && this.name.equals(glyphListFontModel.name);
        }
        return false;
    }

    public int hashCode() {
        return this.font.hashCode() ^ this.name.hashCode();
    }
}

