#! /bin/sh
# Do not edit this file!
# this file is generated by 'generate_test.pl'.

#
# Maaping test.
# No 'map' entry.
# idnkit assumes "widthmap lowercase nfc delimitermap language-local nfc"
# is specified.
#
# The input name is U+FF21 + U+0300 + U+3002 + U+FF8A + U+309B
# (FULL WIDTH 'A' + grave + IDEOGRAPHIC FULL STOP + HALF WIDTH KATAKANA 'HA'
# + VOICED SOUND MARK).
#
# 1. widthmap
#    It converts U+FF21 to U+00041 and U+FF8A to U+30CF, respectively.
#    The result is U+0041 U+0300 U+3002 U+30CF U+309B.
#
# 2. lowercase
#    It converts U+0041 to U+0061.
#    The result is U+0061 U+0300 U+3002 U+30CF U+309B.
#
# 3. nfc
#    It converts U+0061 + U+0300 to U+00E0.
#    The result is U+00E0 U+3002 U+30CF U+309B.
#
# 4. delimitermap
#    It converts U+3002 to U+002E.
#    The result is U+00E0 U+002E U+30CF U+309B.
#
# 5. localmap
#    It converts U+00E0 to U+0101 and U+309B to U+3099, respectively.
#    The result is U+0101 U+002E U+30CF U+3099.
#
# 6. nfc (again)
#    It converts U+30CF + U+3099 to U+30D0.
#    The result is U+0101 U+002E U+30D0.
#
#             api: encodename
#  local_encoding: U-escape
#            conf: delimiters 3002
#            conf: language-local * @LOCALMAP_FILE1@
#       localmap1: 309B; 3099
#       localmap1: 00E0; 0101
#            from: \u{ff21}\u{300}\u{3002}\u{ff8a}\u{309b}
#         actions: IDN_UNICODECONV IDN_MAP IDN_LOCALCONV
#          result: success
#              to: \u{101}.\u{30d0}

################## setup ##################

unset LC_ALL
unset LC_CTYPE
unset LC_MESSAGES
unset LANG
unset IDN_LOCAL_CODESET
unset IDN_LOG_LEVEL

SRCDIR=`dirname $0`
SYSCONFDIR=${SYSCONFDIR-"/etc"}
IGNORE=false
export IDN_LOCAL_CODESET; IDN_LOCAL_CODESET=U-escape

rm -f idn2.conf
touch idn2.conf
echo 'delimiters 3002' >> idn2.conf
echo 'language-local * localmap1' >> idn2.conf

rm -f localmap1
echo '309B; 3099' >> localmap1
echo '00E0; 0101' >> localmap1

rm -f localmap2
rm -f localmap3
rm -f localmap4
rm -f localset
rm -f expect.txt
rm -f output.txt

################## test ##################

echo 'from: \u{ff21}\u{300}\u{3002}\u{ff8a}\u{309b}' >> expect.txt
echo 'result: success' >> expect.txt
echo 'to: \u{101}.\u{30d0}' >> expect.txt
../common/test_encodename -conffile=idn2.conf -localcheckfile=  -unicodeconv -map -localconv -- '\u{ff21}\u{300}\u{3002}\u{ff8a}\u{309b}' > output.txt

################## teardown ##################

cmp expect.txt output.txt > /dev/null 2>&1
RESULT=$?
[ X$IGNORE = Xtrue ] && RESULT=77
if [ X$QUIET != Xtrue ]; then
    if [ $RESULT -eq 0 ]; then
        echo "PASS: $0"
    elif [ $RESULT -eq 77 ]; then
        echo "SKIP: $0"
    else
        echo "FAIL: $0"
    fi
fi
[ $RESULT -eq 0 -o $RESULT -eq 77 ] || exit $RESULT
rm -f idn2.conf
rm -f localmap1
rm -f localmap2
rm -f localmap3
rm -f localmap4
rm -f localset
rm -f expect.txt
rm -f output.txt
exit $RESULT
