// -*- C++ -*-
//
// This file is part of HepMC
// Copyright (C) 2014-2024 The HepMC collaboration (see AUTHORS for details)
//
#include "HepMC3/GenEvent.h"
#include "HepMC3/ReaderAsciiHepMC2.h"
#include "HepMC3/WriterAsciiHepMC2.h"
#include "HepMC3TestUtils.h"
#include <sstream>

const std::string rawevent = R"(
HepMC::Version 3.02.08
HepMC::IO_GenEvent-START_EVENT_LISTING
E 0 0 9.188128e+01 1.298440e-01 7.818181e-03 221 0 7 10001 10004 0 1 1.0000000000000000e+00
N 1 "0"
U GEV MM
C 2.6442255100000002e+03 2.6442255100000002e+03
F 11 -11 9.97420767e-01 9.99999975e-01 9.18812775e+01 1.56824725e+01 2.82148362e+06 0 0
V -1 0 0 0 0 0 1 2 0
P 10001 11 0.0000000000000000e+00 0.0000000000000000e+00 4.5999999997161737e+01 4.6000000000000007e+01 5.1099999999999995e-04 4 0 0 -1 0
P 10002 11 0.0000000000000000e+00 0.0000000000000000e+00 4.5881355265109363e+01 4.5881355265109363e+01 0.0000000000000000e+00 61 0 0 -3 0
P 10003 22 0.0000000000000000e+00 0.0000000000000000e+00 1.1864473489064410e-01 1.1864473489064410e-01 0.0000000000000000e+00 1 0 0 0 0
V -2 0 0 0 0 0 1 2 0
P 10004 -11 0.0000000000000000e+00 0.0000000000000000e+00 -4.5999999997161737e+01 4.6000000000000007e+01 5.1099999999999995e-04 4 0 0 -2 0
P 10005 -11 0.0000000000000000e+00 0.0000000000000000e+00 -4.5999998855671230e+01 4.5999998855671230e+01 0.0000000000000000e+00 61 0 0 -4 0
P 10006 22 0.0000000000000000e+00 0.0000000000000000e+00 -1.1443287704082650e-06 1.1443287704082650e-06 0.0000000000000000e+00 1 0 0 0 0
V -3 0 0 0 0 0 0 1 0
P 10007 11 0.0000000000000000e+00 0.0000000000000000e+00 4.5881355265109363e+01 4.5881355265109363e+01 0.0000000000000000e+00 21 0 0 -5 0
V -4 0 0 0 0 0 0 1 0
P 10008 -11 0.0000000000000000e+00 0.0000000000000000e+00 -4.5999998855671230e+01 4.5999998855671230e+01 0.0000000000000000e+00 21 0 0 -5 0
V -5 0 0 0 0 0 0 1 0
P 10009 23 0.0000000000000000e+00 0.0000000000000000e+00 -1.1864359056187369e-01 9.1881354120780586e+01 9.1881277520323493e+01 22 0 0 -6 0
V -6 0 0 0 0 0 0 1 0
P 10010 23 0.0000000000000000e+00 0.0000000000000000e+00 -1.1864359056187369e-01 9.1881354120780586e+01 9.1881277520323493e+01 62 0 0 -7 0
V -7 0 0 0 0 0 0 2 0
P 10011 15 -2.3389081325813049e+01 -2.6534544925397689e+01 -2.9321164328115071e+01 4.5978461985283630e+01 1.7768200000000001e+00 1 0 0 0 0
P 10012 -15 2.3389081325813049e+01 2.6534544925397689e+01 2.9202520737553190e+01 4.5902892135496963e+01 1.7768200000000001e+00 1 0 0 0 0
HepMC::IO_GenEvent-END_EVENT_LISTING
)";


using namespace HepMC3;
int main()
{
    std::stringstream input;
    std::stringstream output;
    input << rawevent;
    ReaderAsciiHepMC2 inputA(input);
    if(inputA.failed()) return 1;
    WriterAsciiHepMC2       outputA(output);
    if(outputA.failed()) return 2;
    while( !inputA.failed() )
    {
        GenEvent evt(Units::GEV,Units::MM);
        inputA.read_event(evt);
        if( inputA.failed() )  {
            printf("End of file reached. Exit.\n");
            break;
        }
        outputA.write_event(evt);
        evt.clear();
    }
    inputA.close();
    outputA.close();
    outputA.close();
    outputA.close();
    std::cout<<output.str();
    std::stringstream inputtest; 
    inputtest << rawevent;
    std::stringstream outputtest; 
    outputtest << output.str();
    return COMPARE_ASCII_STREAMS(inputtest, outputtest);
}
