// Implementation file for parser generated by fsyacc
module internal FSharp.Compiler.AbstractIL.AsciiParser
#nowarn "64";; // turn off warnings that type variables used in production annotations are instantiated to concrete type
open FSharp.Compiler.AbstractIL.AsciiConstants
open FSharp.Compiler.AbstractIL.IL
open Internal.Utilities.Text.Lexing
open Internal.Utilities.Text.Parsing.ParseHelpers
//# 3 "src/Compiler/AbstractIL/ilpars.fsy"


#nowarn "1182"  // the generated code often has unused variable "parseState"

open Internal.Utilities.Library

type ResolvedAtMethodSpecScope<'T> = 
    ResolvedAtMethodSpecScope of (ILGenericParameterDefs -> 'T)

let noMethodSpecScope x = ResolvedAtMethodSpecScope (fun _cgparams -> x)
let resolveMethodSpecScope (ResolvedAtMethodSpecScope f) x = f x
let resolveMethodSpecScopeThen (ResolvedAtMethodSpecScope f) g = 
  ResolvedAtMethodSpecScope (fun x -> resolveMethodSpecScope (g(f x)) x)

let resolveCurrentMethodSpecScope obj = 
    resolveMethodSpecScope obj mkILEmptyGenericParams


//# 27 "ilpars.fs"
// This type is the type of tokens accepted by the parser
type token = 
  | VOID
  | VARARG
  | VALUETYPE
  | VALUE
  | UNSIGNED
  | UNMANAGED
  | UINT8
  | UINT64
  | UINT32
  | UINT16
  | UINT
  | STRING
  | STAR
  | SLASH
  | RPAREN
  | RBRACK
  | PLUS
  | OBJECT
  | NATIVE
  | METHOD
  | LPAREN
  | LESS
  | LBRACK
  | INT8
  | INT64
  | INT32
  | INT16
  | INT
  | INSTANCE
  | GREATER
  | FLOAT64
  | FLOAT32
  | FIELD
  | EXPLICIT
  | EOF
  | ELIPSES
  | DOT
  | DEFAULT
  | DCOLON
  | COMMA
  | CLASS
  | CHAR
  | BYTEARRAY
  | BOOL
  | BANG
  | AMP
  | VAL_SQSTRING of (string)
  | VAL_QSTRING of (string)
  | VAL_DOTTEDNAME of (string)
  | VAL_ID of (string)
  | VAL_HEXBYTE of (int)
  | INSTR_VALUETYPE of (ValueTypeInstr)
  | INSTR_INT_TYPE of (IntTypeInstr)
  | INSTR_TYPE of (TypeInstr)
  | INSTR_TOK of (TokenInstr)
  | INSTR_STRING of (StringInstr)
  | INSTR_NONE of (NoArgInstr)
  | INSTR_R of (DoubleInstr)
  | INSTR_I8 of (Int64Instr)
  | INSTR_I32_I32 of (Int32Int32Instr)
  | INSTR_I of (Int32Instr)
  | VAL_FLOAT64 of (double)
  | VAL_INT32_ELIPSES of (int32)
  | VAL_INT64 of (int64)
// This type is used to give symbolic names to token indexes, useful for error messages
type tokenId = 
    | TOKEN_VOID
    | TOKEN_VARARG
    | TOKEN_VALUETYPE
    | TOKEN_VALUE
    | TOKEN_UNSIGNED
    | TOKEN_UNMANAGED
    | TOKEN_UINT8
    | TOKEN_UINT64
    | TOKEN_UINT32
    | TOKEN_UINT16
    | TOKEN_UINT
    | TOKEN_STRING
    | TOKEN_STAR
    | TOKEN_SLASH
    | TOKEN_RPAREN
    | TOKEN_RBRACK
    | TOKEN_PLUS
    | TOKEN_OBJECT
    | TOKEN_NATIVE
    | TOKEN_METHOD
    | TOKEN_LPAREN
    | TOKEN_LESS
    | TOKEN_LBRACK
    | TOKEN_INT8
    | TOKEN_INT64
    | TOKEN_INT32
    | TOKEN_INT16
    | TOKEN_INT
    | TOKEN_INSTANCE
    | TOKEN_GREATER
    | TOKEN_FLOAT64
    | TOKEN_FLOAT32
    | TOKEN_FIELD
    | TOKEN_EXPLICIT
    | TOKEN_EOF
    | TOKEN_ELIPSES
    | TOKEN_DOT
    | TOKEN_DEFAULT
    | TOKEN_DCOLON
    | TOKEN_COMMA
    | TOKEN_CLASS
    | TOKEN_CHAR
    | TOKEN_BYTEARRAY
    | TOKEN_BOOL
    | TOKEN_BANG
    | TOKEN_AMP
    | TOKEN_VAL_SQSTRING
    | TOKEN_VAL_QSTRING
    | TOKEN_VAL_DOTTEDNAME
    | TOKEN_VAL_ID
    | TOKEN_VAL_HEXBYTE
    | TOKEN_INSTR_VALUETYPE
    | TOKEN_INSTR_INT_TYPE
    | TOKEN_INSTR_TYPE
    | TOKEN_INSTR_TOK
    | TOKEN_INSTR_STRING
    | TOKEN_INSTR_NONE
    | TOKEN_INSTR_R
    | TOKEN_INSTR_I8
    | TOKEN_INSTR_I32_I32
    | TOKEN_INSTR_I
    | TOKEN_VAL_FLOAT64
    | TOKEN_VAL_INT32_ELIPSES
    | TOKEN_VAL_INT64
    | TOKEN_end_of_input
    | TOKEN_error
// This type is used to give symbolic names to token indexes, useful for error messages
type nonTerminalId = 
    | NONTERM__startilInstrs
    | NONTERM__startilType
    | NONTERM_ilType
    | NONTERM_ilInstrs
    | NONTERM_compQstring
    | NONTERM_methodName
    | NONTERM_instrs2
    | NONTERM_instr
    | NONTERM_name1
    | NONTERM_className
    | NONTERM_slashedName
    | NONTERM_typeNameInst
    | NONTERM_typeName
    | NONTERM_typSpec
    | NONTERM_callConv
    | NONTERM_callKind
    | NONTERM_typ
    | NONTERM_bounds1
    | NONTERM_bound
    | NONTERM_id
    | NONTERM_int32
    | NONTERM_int64
    | NONTERM_float64
    | NONTERM_opt_actual_tyargs
    | NONTERM_actual_tyargs
    | NONTERM_actualTypSpecs

// This function maps tokens to integer indexes
let tagOfToken (t:token) = 
  match t with
  | VOID  -> 0 
  | VARARG  -> 1 
  | VALUETYPE  -> 2 
  | VALUE  -> 3 
  | UNSIGNED  -> 4 
  | UNMANAGED  -> 5 
  | UINT8  -> 6 
  | UINT64  -> 7 
  | UINT32  -> 8 
  | UINT16  -> 9 
  | UINT  -> 10 
  | STRING  -> 11 
  | STAR  -> 12 
  | SLASH  -> 13 
  | RPAREN  -> 14 
  | RBRACK  -> 15 
  | PLUS  -> 16 
  | OBJECT  -> 17 
  | NATIVE  -> 18 
  | METHOD  -> 19 
  | LPAREN  -> 20 
  | LESS  -> 21 
  | LBRACK  -> 22 
  | INT8  -> 23 
  | INT64  -> 24 
  | INT32  -> 25 
  | INT16  -> 26 
  | INT  -> 27 
  | INSTANCE  -> 28 
  | GREATER  -> 29 
  | FLOAT64  -> 30 
  | FLOAT32  -> 31 
  | FIELD  -> 32 
  | EXPLICIT  -> 33 
  | EOF  -> 34 
  | ELIPSES  -> 35 
  | DOT  -> 36 
  | DEFAULT  -> 37 
  | DCOLON  -> 38 
  | COMMA  -> 39 
  | CLASS  -> 40 
  | CHAR  -> 41 
  | BYTEARRAY  -> 42 
  | BOOL  -> 43 
  | BANG  -> 44 
  | AMP  -> 45 
  | VAL_SQSTRING _ -> 46 
  | VAL_QSTRING _ -> 47 
  | VAL_DOTTEDNAME _ -> 48 
  | VAL_ID _ -> 49 
  | VAL_HEXBYTE _ -> 50 
  | INSTR_VALUETYPE _ -> 51 
  | INSTR_INT_TYPE _ -> 52 
  | INSTR_TYPE _ -> 53 
  | INSTR_TOK _ -> 54 
  | INSTR_STRING _ -> 55 
  | INSTR_NONE _ -> 56 
  | INSTR_R _ -> 57 
  | INSTR_I8 _ -> 58 
  | INSTR_I32_I32 _ -> 59 
  | INSTR_I _ -> 60 
  | VAL_FLOAT64 _ -> 61 
  | VAL_INT32_ELIPSES _ -> 62 
  | VAL_INT64 _ -> 63 

// This function maps integer indexes to symbolic token ids
let tokenTagToTokenId (tokenIdx:int) = 
  match tokenIdx with
  | 0 -> TOKEN_VOID 
  | 1 -> TOKEN_VARARG 
  | 2 -> TOKEN_VALUETYPE 
  | 3 -> TOKEN_VALUE 
  | 4 -> TOKEN_UNSIGNED 
  | 5 -> TOKEN_UNMANAGED 
  | 6 -> TOKEN_UINT8 
  | 7 -> TOKEN_UINT64 
  | 8 -> TOKEN_UINT32 
  | 9 -> TOKEN_UINT16 
  | 10 -> TOKEN_UINT 
  | 11 -> TOKEN_STRING 
  | 12 -> TOKEN_STAR 
  | 13 -> TOKEN_SLASH 
  | 14 -> TOKEN_RPAREN 
  | 15 -> TOKEN_RBRACK 
  | 16 -> TOKEN_PLUS 
  | 17 -> TOKEN_OBJECT 
  | 18 -> TOKEN_NATIVE 
  | 19 -> TOKEN_METHOD 
  | 20 -> TOKEN_LPAREN 
  | 21 -> TOKEN_LESS 
  | 22 -> TOKEN_LBRACK 
  | 23 -> TOKEN_INT8 
  | 24 -> TOKEN_INT64 
  | 25 -> TOKEN_INT32 
  | 26 -> TOKEN_INT16 
  | 27 -> TOKEN_INT 
  | 28 -> TOKEN_INSTANCE 
  | 29 -> TOKEN_GREATER 
  | 30 -> TOKEN_FLOAT64 
  | 31 -> TOKEN_FLOAT32 
  | 32 -> TOKEN_FIELD 
  | 33 -> TOKEN_EXPLICIT 
  | 34 -> TOKEN_EOF 
  | 35 -> TOKEN_ELIPSES 
  | 36 -> TOKEN_DOT 
  | 37 -> TOKEN_DEFAULT 
  | 38 -> TOKEN_DCOLON 
  | 39 -> TOKEN_COMMA 
  | 40 -> TOKEN_CLASS 
  | 41 -> TOKEN_CHAR 
  | 42 -> TOKEN_BYTEARRAY 
  | 43 -> TOKEN_BOOL 
  | 44 -> TOKEN_BANG 
  | 45 -> TOKEN_AMP 
  | 46 -> TOKEN_VAL_SQSTRING 
  | 47 -> TOKEN_VAL_QSTRING 
  | 48 -> TOKEN_VAL_DOTTEDNAME 
  | 49 -> TOKEN_VAL_ID 
  | 50 -> TOKEN_VAL_HEXBYTE 
  | 51 -> TOKEN_INSTR_VALUETYPE 
  | 52 -> TOKEN_INSTR_INT_TYPE 
  | 53 -> TOKEN_INSTR_TYPE 
  | 54 -> TOKEN_INSTR_TOK 
  | 55 -> TOKEN_INSTR_STRING 
  | 56 -> TOKEN_INSTR_NONE 
  | 57 -> TOKEN_INSTR_R 
  | 58 -> TOKEN_INSTR_I8 
  | 59 -> TOKEN_INSTR_I32_I32 
  | 60 -> TOKEN_INSTR_I 
  | 61 -> TOKEN_VAL_FLOAT64 
  | 62 -> TOKEN_VAL_INT32_ELIPSES 
  | 63 -> TOKEN_VAL_INT64 
  | 66 -> TOKEN_end_of_input
  | 64 -> TOKEN_error
  | _ -> failwith "tokenTagToTokenId: bad token"

/// This function maps production indexes returned in syntax errors to strings representing the non terminal that would be produced by that production
let prodIdxToNonTerminal (prodIdx:int) = 
  match prodIdx with
    | 0 -> NONTERM__startilInstrs 
    | 1 -> NONTERM__startilType 
    | 2 -> NONTERM_ilType 
    | 3 -> NONTERM_ilInstrs 
    | 4 -> NONTERM_compQstring 
    | 5 -> NONTERM_compQstring 
    | 6 -> NONTERM_methodName 
    | 7 -> NONTERM_instrs2 
    | 8 -> NONTERM_instrs2 
    | 9 -> NONTERM_instr 
    | 10 -> NONTERM_instr 
    | 11 -> NONTERM_instr 
    | 12 -> NONTERM_instr 
    | 13 -> NONTERM_instr 
    | 14 -> NONTERM_instr 
    | 15 -> NONTERM_instr 
    | 16 -> NONTERM_instr 
    | 17 -> NONTERM_instr 
    | 18 -> NONTERM_instr 
    | 19 -> NONTERM_name1 
    | 20 -> NONTERM_name1 
    | 21 -> NONTERM_name1 
    | 22 -> NONTERM_className 
    | 23 -> NONTERM_className 
    | 24 -> NONTERM_slashedName 
    | 25 -> NONTERM_slashedName 
    | 26 -> NONTERM_typeNameInst 
    | 27 -> NONTERM_typeName 
    | 28 -> NONTERM_typSpec 
    | 29 -> NONTERM_typSpec 
    | 30 -> NONTERM_typSpec 
    | 31 -> NONTERM_callConv 
    | 32 -> NONTERM_callConv 
    | 33 -> NONTERM_callConv 
    | 34 -> NONTERM_callKind 
    | 35 -> NONTERM_callKind 
    | 36 -> NONTERM_callKind 
    | 37 -> NONTERM_typ 
    | 38 -> NONTERM_typ 
    | 39 -> NONTERM_typ 
    | 40 -> NONTERM_typ 
    | 41 -> NONTERM_typ 
    | 42 -> NONTERM_typ 
    | 43 -> NONTERM_typ 
    | 44 -> NONTERM_typ 
    | 45 -> NONTERM_typ 
    | 46 -> NONTERM_typ 
    | 47 -> NONTERM_typ 
    | 48 -> NONTERM_typ 
    | 49 -> NONTERM_typ 
    | 50 -> NONTERM_typ 
    | 51 -> NONTERM_typ 
    | 52 -> NONTERM_typ 
    | 53 -> NONTERM_typ 
    | 54 -> NONTERM_typ 
    | 55 -> NONTERM_typ 
    | 56 -> NONTERM_typ 
    | 57 -> NONTERM_typ 
    | 58 -> NONTERM_typ 
    | 59 -> NONTERM_typ 
    | 60 -> NONTERM_typ 
    | 61 -> NONTERM_typ 
    | 62 -> NONTERM_typ 
    | 63 -> NONTERM_typ 
    | 64 -> NONTERM_typ 
    | 65 -> NONTERM_typ 
    | 66 -> NONTERM_typ 
    | 67 -> NONTERM_bounds1 
    | 68 -> NONTERM_bounds1 
    | 69 -> NONTERM_bound 
    | 70 -> NONTERM_bound 
    | 71 -> NONTERM_bound 
    | 72 -> NONTERM_bound 
    | 73 -> NONTERM_bound 
    | 74 -> NONTERM_bound 
    | 75 -> NONTERM_id 
    | 76 -> NONTERM_id 
    | 77 -> NONTERM_int32 
    | 78 -> NONTERM_int64 
    | 79 -> NONTERM_float64 
    | 80 -> NONTERM_float64 
    | 81 -> NONTERM_opt_actual_tyargs 
    | 82 -> NONTERM_opt_actual_tyargs 
    | 83 -> NONTERM_actual_tyargs 
    | 84 -> NONTERM_actualTypSpecs 
    | 85 -> NONTERM_actualTypSpecs 
    | _ -> failwith "prodIdxToNonTerminal: bad production index"

let _fsyacc_endOfInputTag = 66 
let _fsyacc_tagOfErrorTerminal = 64

// This function gets the name of a token as a string
let token_to_string (t:token) = 
  match t with 
  | VOID  -> "VOID" 
  | VARARG  -> "VARARG" 
  | VALUETYPE  -> "VALUETYPE" 
  | VALUE  -> "VALUE" 
  | UNSIGNED  -> "UNSIGNED" 
  | UNMANAGED  -> "UNMANAGED" 
  | UINT8  -> "UINT8" 
  | UINT64  -> "UINT64" 
  | UINT32  -> "UINT32" 
  | UINT16  -> "UINT16" 
  | UINT  -> "UINT" 
  | STRING  -> "STRING" 
  | STAR  -> "STAR" 
  | SLASH  -> "SLASH" 
  | RPAREN  -> "RPAREN" 
  | RBRACK  -> "RBRACK" 
  | PLUS  -> "PLUS" 
  | OBJECT  -> "OBJECT" 
  | NATIVE  -> "NATIVE" 
  | METHOD  -> "METHOD" 
  | LPAREN  -> "LPAREN" 
  | LESS  -> "LESS" 
  | LBRACK  -> "LBRACK" 
  | INT8  -> "INT8" 
  | INT64  -> "INT64" 
  | INT32  -> "INT32" 
  | INT16  -> "INT16" 
  | INT  -> "INT" 
  | INSTANCE  -> "INSTANCE" 
  | GREATER  -> "GREATER" 
  | FLOAT64  -> "FLOAT64" 
  | FLOAT32  -> "FLOAT32" 
  | FIELD  -> "FIELD" 
  | EXPLICIT  -> "EXPLICIT" 
  | EOF  -> "EOF" 
  | ELIPSES  -> "ELIPSES" 
  | DOT  -> "DOT" 
  | DEFAULT  -> "DEFAULT" 
  | DCOLON  -> "DCOLON" 
  | COMMA  -> "COMMA" 
  | CLASS  -> "CLASS" 
  | CHAR  -> "CHAR" 
  | BYTEARRAY  -> "BYTEARRAY" 
  | BOOL  -> "BOOL" 
  | BANG  -> "BANG" 
  | AMP  -> "AMP" 
  | VAL_SQSTRING _ -> "VAL_SQSTRING" 
  | VAL_QSTRING _ -> "VAL_QSTRING" 
  | VAL_DOTTEDNAME _ -> "VAL_DOTTEDNAME" 
  | VAL_ID _ -> "VAL_ID" 
  | VAL_HEXBYTE _ -> "VAL_HEXBYTE" 
  | INSTR_VALUETYPE _ -> "INSTR_VALUETYPE" 
  | INSTR_INT_TYPE _ -> "INSTR_INT_TYPE" 
  | INSTR_TYPE _ -> "INSTR_TYPE" 
  | INSTR_TOK _ -> "INSTR_TOK" 
  | INSTR_STRING _ -> "INSTR_STRING" 
  | INSTR_NONE _ -> "INSTR_NONE" 
  | INSTR_R _ -> "INSTR_R" 
  | INSTR_I8 _ -> "INSTR_I8" 
  | INSTR_I32_I32 _ -> "INSTR_I32_I32" 
  | INSTR_I _ -> "INSTR_I" 
  | VAL_FLOAT64 _ -> "VAL_FLOAT64" 
  | VAL_INT32_ELIPSES _ -> "VAL_INT32_ELIPSES" 
  | VAL_INT64 _ -> "VAL_INT64" 

// This function gets the data carried by a token as an object
let _fsyacc_dataOfToken (t:token) = 
  match t with 
  | VOID  -> (null : System.Object) 
  | VARARG  -> (null : System.Object) 
  | VALUETYPE  -> (null : System.Object) 
  | VALUE  -> (null : System.Object) 
  | UNSIGNED  -> (null : System.Object) 
  | UNMANAGED  -> (null : System.Object) 
  | UINT8  -> (null : System.Object) 
  | UINT64  -> (null : System.Object) 
  | UINT32  -> (null : System.Object) 
  | UINT16  -> (null : System.Object) 
  | UINT  -> (null : System.Object) 
  | STRING  -> (null : System.Object) 
  | STAR  -> (null : System.Object) 
  | SLASH  -> (null : System.Object) 
  | RPAREN  -> (null : System.Object) 
  | RBRACK  -> (null : System.Object) 
  | PLUS  -> (null : System.Object) 
  | OBJECT  -> (null : System.Object) 
  | NATIVE  -> (null : System.Object) 
  | METHOD  -> (null : System.Object) 
  | LPAREN  -> (null : System.Object) 
  | LESS  -> (null : System.Object) 
  | LBRACK  -> (null : System.Object) 
  | INT8  -> (null : System.Object) 
  | INT64  -> (null : System.Object) 
  | INT32  -> (null : System.Object) 
  | INT16  -> (null : System.Object) 
  | INT  -> (null : System.Object) 
  | INSTANCE  -> (null : System.Object) 
  | GREATER  -> (null : System.Object) 
  | FLOAT64  -> (null : System.Object) 
  | FLOAT32  -> (null : System.Object) 
  | FIELD  -> (null : System.Object) 
  | EXPLICIT  -> (null : System.Object) 
  | EOF  -> (null : System.Object) 
  | ELIPSES  -> (null : System.Object) 
  | DOT  -> (null : System.Object) 
  | DEFAULT  -> (null : System.Object) 
  | DCOLON  -> (null : System.Object) 
  | COMMA  -> (null : System.Object) 
  | CLASS  -> (null : System.Object) 
  | CHAR  -> (null : System.Object) 
  | BYTEARRAY  -> (null : System.Object) 
  | BOOL  -> (null : System.Object) 
  | BANG  -> (null : System.Object) 
  | AMP  -> (null : System.Object) 
  | VAL_SQSTRING _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | VAL_QSTRING _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | VAL_DOTTEDNAME _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | VAL_ID _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | VAL_HEXBYTE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INSTR_VALUETYPE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INSTR_INT_TYPE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INSTR_TYPE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INSTR_TOK _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INSTR_STRING _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INSTR_NONE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INSTR_R _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INSTR_I8 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INSTR_I32_I32 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INSTR_I _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | VAL_FLOAT64 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | VAL_INT32_ELIPSES _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | VAL_INT64 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
let _fsyacc_gotos = [| 0us;65535us;0us;65535us;1us;65535us;2us;3us;1us;65535us;0us;1us;0us;65535us;0us;65535us;2us;65535us;0us;6us;8us;9us;2us;65535us;0us;8us;8us;8us;12us;65535us;21us;33us;24us;33us;26us;33us;28us;33us;36us;32us;37us;33us;40us;33us;52us;33us;55us;33us;57us;33us;108us;33us;112us;33us;9us;65535us;21us;44us;24us;44us;26us;44us;28us;44us;52us;42us;55us;42us;57us;42us;108us;44us;112us;44us;11us;65535us;21us;39us;24us;39us;26us;39us;28us;39us;37us;38us;40us;41us;52us;39us;55us;39us;57us;39us;108us;39us;112us;39us;3us;65535us;52us;53us;55us;56us;57us;58us;6us;65535us;21us;45us;24us;45us;26us;45us;28us;45us;108us;45us;112us;45us;6us;65535us;21us;22us;24us;25us;26us;27us;28us;29us;108us;111us;112us;113us;0us;65535us;0us;65535us;8us;65535us;2us;4us;21us;46us;24us;46us;26us;46us;28us;46us;47us;48us;108us;46us;112us;46us;1us;65535us;59us;61us;2us;65535us;59us;90us;91us;92us;13us;65535us;21us;30us;24us;30us;26us;30us;28us;30us;34us;35us;36us;30us;37us;30us;40us;30us;52us;30us;55us;30us;57us;30us;108us;30us;112us;30us;9us;65535us;11us;12us;13us;14us;14us;15us;23us;24us;59us;93us;88us;89us;91us;93us;94us;95us;96us;97us;3us;65535us;16us;17us;18us;20us;104us;105us;1us;65535us;18us;19us;1us;65535us;42us;43us;1us;65535us;42us;107us;1us;65535us;108us;109us;|]
let _fsyacc_sparseGotoTableRowOffsets = [|0us;1us;2us;4us;6us;7us;8us;11us;14us;27us;37us;49us;53us;60us;67us;68us;69us;78us;80us;83us;97us;107us;111us;113us;115us;117us;|]
let _fsyacc_stateToProdIdxsTableElements = [| 1us;0us;1us;0us;1us;1us;1us;1us;5us;2us;42us;43us;44us;45us;1us;2us;1us;3us;1us;3us;1us;7us;1us;7us;1us;9us;1us;10us;1us;10us;1us;11us;1us;11us;1us;11us;1us;12us;1us;12us;2us;13us;14us;1us;13us;1us;14us;1us;15us;1us;15us;1us;16us;1us;16us;1us;16us;1us;17us;1us;17us;1us;18us;1us;18us;1us;19us;1us;20us;2us;21us;22us;3us;21us;24us;25us;1us;21us;1us;21us;1us;22us;1us;22us;1us;22us;1us;23us;1us;25us;1us;25us;1us;26us;1us;26us;1us;27us;1us;28us;5us;29us;42us;43us;44us;45us;1us;30us;5us;30us;42us;43us;44us;45us;1us;30us;1us;37us;1us;38us;1us;39us;1us;39us;1us;40us;1us;40us;1us;40us;1us;41us;1us;41us;2us;42us;43us;1us;42us;2us;43us;68us;1us;43us;1us;44us;1us;45us;1us;46us;1us;47us;1us;48us;1us;49us;1us;50us;1us;51us;1us;52us;1us;53us;1us;54us;4us;55us;56us;57us;58us;1us;55us;1us;56us;1us;57us;1us;58us;1us;59us;1us;60us;1us;61us;1us;62us;3us;63us;64us;65us;1us;63us;1us;64us;1us;64us;1us;65us;1us;66us;1us;66us;1us;67us;1us;68us;1us;68us;3us;70us;71us;72us;2us;71us;72us;1us;71us;2us;73us;74us;1us;73us;1us;75us;1us;76us;1us;77us;1us;78us;1us;79us;1us;80us;1us;80us;1us;80us;1us;80us;1us;82us;1us;83us;2us;83us;85us;1us;83us;1us;84us;1us;85us;1us;85us;|]
let _fsyacc_stateToProdIdxsTableRowOffsets = [|0us;2us;4us;6us;8us;14us;16us;18us;20us;22us;24us;26us;28us;30us;32us;34us;36us;38us;40us;43us;45us;47us;49us;51us;53us;55us;57us;59us;61us;63us;65us;67us;69us;72us;76us;78us;80us;82us;84us;86us;88us;90us;92us;94us;96us;98us;100us;106us;108us;114us;116us;118us;120us;122us;124us;126us;128us;130us;132us;134us;137us;139us;142us;144us;146us;148us;150us;152us;154us;156us;158us;160us;162us;164us;166us;171us;173us;175us;177us;179us;181us;183us;185us;187us;191us;193us;195us;197us;199us;201us;203us;205us;207us;209us;213us;216us;218us;221us;223us;225us;227us;229us;231us;233us;235us;237us;239us;241us;243us;245us;248us;250us;252us;254us;|]
let _fsyacc_action_rows = 114
let _fsyacc_actionTableElements = [|9us;16392us;51us;26us;52us;23us;53us;21us;54us;28us;56us;10us;57us;18us;58us;16us;59us;13us;60us;11us;0us;49152us;21us;32768us;0us;66us;2us;57us;3us;54us;4us;74us;6us;79us;7us;82us;8us;81us;9us;80us;11us;50us;17us;51us;18us;83us;23us;68us;24us;71us;25us;70us;26us;69us;30us;73us;31us;72us;40us;52us;41us;65us;43us;67us;44us;88us;0us;49152us;4us;32768us;12us;64us;22us;59us;34us;5us;45us;63us;0us;16386us;1us;32768us;34us;7us;0us;16387us;9us;16392us;51us;26us;52us;23us;53us;21us;54us;28us;56us;10us;57us;18us;58us;16us;59us;13us;60us;11us;0us;16391us;0us;16393us;1us;32768us;63us;100us;0us;16394us;1us;32768us;63us;100us;1us;32768us;63us;100us;0us;16395us;1us;32768us;63us;101us;0us;16396us;3us;32768us;30us;103us;61us;102us;63us;101us;0us;16397us;0us;16398us;26us;32768us;0us;66us;2us;57us;3us;54us;4us;74us;6us;79us;7us;82us;8us;81us;9us;80us;11us;50us;17us;51us;18us;83us;20us;47us;22us;36us;23us;68us;24us;71us;25us;70us;26us;69us;30us;73us;31us;72us;40us;52us;41us;65us;43us;67us;44us;88us;46us;99us;48us;31us;49us;98us;0us;16399us;1us;32768us;63us;100us;26us;32768us;0us;66us;2us;57us;3us;54us;4us;74us;6us;79us;7us;82us;8us;81us;9us;80us;11us;50us;17us;51us;18us;83us;20us;47us;22us;36us;23us;68us;24us;71us;25us;70us;26us;69us;30us;73us;31us;72us;40us;52us;41us;65us;43us;67us;44us;88us;46us;99us;48us;31us;49us;98us;0us;16400us;26us;32768us;0us;66us;2us;57us;3us;54us;4us;74us;6us;79us;7us;82us;8us;81us;9us;80us;11us;50us;17us;51us;18us;83us;20us;47us;22us;36us;23us;68us;24us;71us;25us;70us;26us;69us;30us;73us;31us;72us;40us;52us;41us;65us;43us;67us;44us;88us;46us;99us;48us;31us;49us;98us;0us;16401us;26us;32768us;0us;66us;2us;57us;3us;54us;4us;74us;6us;79us;7us;82us;8us;81us;9us;80us;11us;50us;17us;51us;18us;83us;20us;47us;22us;36us;23us;68us;24us;71us;25us;70us;26us;69us;30us;73us;31us;72us;40us;52us;41us;65us;43us;67us;44us;88us;46us;99us;48us;31us;49us;98us;0us;16402us;0us;16403us;0us;16404us;2us;32768us;15us;37us;36us;34us;2us;16408us;13us;40us;36us;34us;2us;32768us;46us;99us;49us;98us;0us;16405us;3us;32768us;46us;99us;48us;31us;49us;98us;3us;32768us;46us;99us;48us;31us;49us;98us;0us;16406us;0us;16407us;3us;32768us;46us;99us;48us;31us;49us;98us;0us;16409us;1us;16465us;21us;108us;0us;16410us;0us;16411us;0us;16412us;3us;16413us;12us;64us;22us;59us;45us;63us;21us;32768us;0us;66us;2us;57us;3us;54us;4us;74us;6us;79us;7us;82us;8us;81us;9us;80us;11us;50us;17us;51us;18us;83us;23us;68us;24us;71us;25us;70us;26us;69us;30us;73us;31us;72us;40us;52us;41us;65us;43us;67us;44us;88us;4us;32768us;12us;64us;14us;49us;22us;59us;45us;63us;0us;16414us;0us;16421us;0us;16422us;4us;32768us;22us;36us;46us;99us;48us;31us;49us;98us;0us;16423us;1us;32768us;40us;55us;4us;32768us;22us;36us;46us;99us;48us;31us;49us;98us;0us;16424us;4us;32768us;22us;36us;46us;99us;48us;31us;49us;98us;0us;16425us;3us;16453us;15us;60us;62us;96us;63us;100us;0us;16426us;2us;32768us;15us;62us;39us;91us;0us;16427us;0us;16428us;0us;16429us;0us;16430us;0us;16431us;0us;16432us;0us;16433us;0us;16434us;0us;16435us;0us;16436us;0us;16437us;0us;16438us;4us;32768us;23us;75us;24us;78us;25us;77us;26us;76us;0us;16439us;0us;16440us;0us;16441us;0us;16442us;0us;16443us;0us;16444us;0us;16445us;0us;16446us;3us;32768us;4us;85us;10us;87us;27us;84us;0us;16447us;1us;32768us;27us;86us;0us;16448us;0us;16449us;1us;32768us;63us;100us;0us;16450us;0us;16451us;2us;16453us;62us;96us;63us;100us;0us;16452us;1us;16454us;35us;94us;1us;16456us;63us;100us;0us;16455us;1us;16458us;63us;100us;0us;16457us;0us;16459us;0us;16460us;0us;16461us;0us;16462us;0us;16463us;1us;32768us;20us;104us;1us;32768us;63us;101us;1us;32768us;14us;106us;0us;16464us;0us;16466us;26us;32768us;0us;66us;2us;57us;3us;54us;4us;74us;6us;79us;7us;82us;8us;81us;9us;80us;11us;50us;17us;51us;18us;83us;20us;47us;22us;36us;23us;68us;24us;71us;25us;70us;26us;69us;30us;73us;31us;72us;40us;52us;41us;65us;43us;67us;44us;88us;46us;99us;48us;31us;49us;98us;2us;32768us;29us;110us;39us;112us;0us;16467us;0us;16468us;26us;32768us;0us;66us;2us;57us;3us;54us;4us;74us;6us;79us;7us;82us;8us;81us;9us;80us;11us;50us;17us;51us;18us;83us;20us;47us;22us;36us;23us;68us;24us;71us;25us;70us;26us;69us;30us;73us;31us;72us;40us;52us;41us;65us;43us;67us;44us;88us;46us;99us;48us;31us;49us;98us;0us;16469us;|]
let _fsyacc_actionTableRowOffsets = [|0us;10us;11us;33us;34us;39us;40us;42us;43us;53us;54us;55us;57us;58us;60us;62us;63us;65us;66us;70us;71us;72us;99us;100us;102us;129us;130us;157us;158us;185us;186us;187us;188us;191us;194us;197us;198us;202us;206us;207us;208us;212us;213us;215us;216us;217us;218us;222us;244us;249us;250us;251us;252us;257us;258us;260us;265us;266us;271us;272us;276us;277us;280us;281us;282us;283us;284us;285us;286us;287us;288us;289us;290us;291us;292us;297us;298us;299us;300us;301us;302us;303us;304us;305us;309us;310us;312us;313us;314us;316us;317us;318us;321us;322us;324us;326us;327us;329us;330us;331us;332us;333us;334us;335us;337us;339us;341us;342us;343us;370us;373us;374us;375us;402us;|]
let _fsyacc_reductionSymbolCounts = [|1us;1us;2us;2us;1us;3us;1us;2us;0us;1us;2us;3us;2us;2us;2us;2us;3us;2us;2us;1us;1us;3us;4us;1us;1us;3us;2us;1us;1us;1us;3us;2us;2us;1us;0us;1us;1us;1us;1us;2us;3us;2us;3us;4us;2us;2us;1us;1us;1us;1us;1us;1us;1us;1us;1us;2us;2us;2us;2us;1us;1us;1us;1us;2us;3us;2us;2us;1us;3us;0us;1us;3us;2us;2us;1us;1us;1us;1us;1us;1us;4us;0us;1us;3us;1us;3us;|]
let _fsyacc_productionToNonTerminalTable = [|0us;1us;2us;3us;4us;4us;5us;6us;6us;7us;7us;7us;7us;7us;7us;7us;7us;7us;7us;8us;8us;8us;9us;9us;10us;10us;11us;12us;13us;13us;13us;14us;14us;14us;15us;15us;15us;16us;16us;16us;16us;16us;16us;16us;16us;16us;16us;16us;16us;16us;16us;16us;16us;16us;16us;16us;16us;16us;16us;16us;16us;16us;16us;16us;16us;16us;16us;17us;17us;18us;18us;18us;18us;18us;18us;19us;19us;20us;21us;22us;22us;23us;23us;24us;25us;25us;|]
let _fsyacc_immediateActions = [|65535us;49152us;65535us;49152us;65535us;16386us;65535us;16387us;65535us;16391us;16393us;65535us;16394us;65535us;65535us;16395us;65535us;16396us;65535us;16397us;16398us;65535us;16399us;65535us;65535us;16400us;65535us;16401us;65535us;16402us;16403us;16404us;65535us;65535us;65535us;16405us;65535us;65535us;16406us;16407us;65535us;16409us;65535us;16410us;16411us;16412us;65535us;65535us;65535us;16414us;16421us;16422us;65535us;16423us;65535us;65535us;16424us;65535us;16425us;65535us;16426us;65535us;16427us;16428us;16429us;16430us;16431us;16432us;16433us;16434us;16435us;16436us;16437us;16438us;65535us;16439us;16440us;16441us;16442us;16443us;16444us;16445us;16446us;65535us;16447us;65535us;16448us;16449us;65535us;16450us;16451us;65535us;16452us;65535us;65535us;16455us;65535us;16457us;16459us;16460us;16461us;16462us;16463us;65535us;65535us;65535us;16464us;16466us;65535us;65535us;16467us;16468us;65535us;16469us;|]
let _fsyacc_reductions = lazy [|
//# 570 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ILInstr array in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
                      raise (Internal.Utilities.Text.Parsing.Accept(Microsoft.FSharp.Core.Operators.box _1))
                   )
                 : 'gentype__startilInstrs));
//# 579 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ILType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
                      raise (Internal.Utilities.Text.Parsing.Accept(Microsoft.FSharp.Core.Operators.box _1))
                   )
                 : 'gentype__startilType));
//# 588 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ILType ResolvedAtMethodSpecScope in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 102 "src/Compiler/AbstractIL/ilpars.fsy"
                              resolveMethodSpecScope _1 [] 
                   )
//# 102 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType));
//# 599 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_instrs2 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 106 "src/Compiler/AbstractIL/ilpars.fsy"
                              Array.ofList _1 
                   )
//# 106 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILInstr array));
//# 610 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> string in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 110 "src/Compiler/AbstractIL/ilpars.fsy"
                                        _1 
                   )
//# 110 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_compQstring));
//# 621 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_compQstring in
            let _3 = parseState.GetInput(3) :?> string in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 111 "src/Compiler/AbstractIL/ilpars.fsy"
                                                         _1 + _3 
                   )
//# 111 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_compQstring));
//# 633 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> string in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 113 "src/Compiler/AbstractIL/ilpars.fsy"
                                          _1 
                   )
//# 113 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_methodName));
//# 644 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_instr in
            let _2 = parseState.GetInput(2) :?> 'gentype_instrs2 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 117 "src/Compiler/AbstractIL/ilpars.fsy"
                               _1 :: _2  
                   )
//# 117 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_instrs2));
//# 656 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 118 "src/Compiler/AbstractIL/ilpars.fsy"
                            [] 
                   )
//# 118 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_instrs2));
//# 666 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> NoArgInstr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 122 "src/Compiler/AbstractIL/ilpars.fsy"
                                (_1 ()) 
                   )
//# 122 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_instr));
//# 677 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Int32Instr in
            let _2 = parseState.GetInput(2) :?> 'gentype_int32 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 124 "src/Compiler/AbstractIL/ilpars.fsy"
                                (_1 _2) 
                   )
//# 124 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_instr));
//# 689 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Int32Int32Instr in
            let _2 = parseState.GetInput(2) :?> 'gentype_int32 in
            let _3 = parseState.GetInput(3) :?> 'gentype_int32 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 126 "src/Compiler/AbstractIL/ilpars.fsy"
                                (_1 (_2,_3)) 
                   )
//# 126 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_instr));
//# 702 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Int64Instr in
            let _2 = parseState.GetInput(2) :?> 'gentype_int64 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 128 "src/Compiler/AbstractIL/ilpars.fsy"
                                (_1 _2) 
                   )
//# 128 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_instr));
//# 714 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> DoubleInstr in
            let _2 = parseState.GetInput(2) :?> 'gentype_float64 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 130 "src/Compiler/AbstractIL/ilpars.fsy"
                                (_1 (ILConst.R8 _2)) 
                   )
//# 130 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_instr));
//# 726 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> DoubleInstr in
            let _2 = parseState.GetInput(2) :?> 'gentype_int64 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 132 "src/Compiler/AbstractIL/ilpars.fsy"
                                (_1 (ILConst.R8 (float _2))) 
                   )
//# 132 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_instr));
//# 738 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> TypeInstr in
            let _2 = parseState.GetInput(2) :?> 'gentype_typSpec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 134 "src/Compiler/AbstractIL/ilpars.fsy"
                               _1 (resolveCurrentMethodSpecScope _2) 
                   )
//# 134 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_instr));
//# 750 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> IntTypeInstr in
            let _2 = parseState.GetInput(2) :?> 'gentype_int32 in
            let _3 = parseState.GetInput(3) :?> 'gentype_typSpec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 136 "src/Compiler/AbstractIL/ilpars.fsy"
                               _1 ( _2,resolveCurrentMethodSpecScope _3) 
                   )
//# 136 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_instr));
//# 763 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ValueTypeInstr in
            let _2 = parseState.GetInput(2) :?> 'gentype_typSpec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 138 "src/Compiler/AbstractIL/ilpars.fsy"
                               _1 (resolveCurrentMethodSpecScope _2) 
                   )
//# 138 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_instr));
//# 775 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> TokenInstr in
            let _2 = parseState.GetInput(2) :?> 'gentype_typSpec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 140 "src/Compiler/AbstractIL/ilpars.fsy"
                                (_1 (ILToken.ILType (resolveCurrentMethodSpecScope _2)))  
                   )
//# 140 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_instr));
//# 787 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_id in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 147 "src/Compiler/AbstractIL/ilpars.fsy"
                               _1 
                   )
//# 147 "src/Compiler/AbstractIL/ilpars.fsy"
                 : string));
//# 798 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> string in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 149 "src/Compiler/AbstractIL/ilpars.fsy"
                               _1 
                   )
//# 149 "src/Compiler/AbstractIL/ilpars.fsy"
                 : string));
//# 809 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> string in
            let _3 = parseState.GetInput(3) :?> 'gentype_id in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 151 "src/Compiler/AbstractIL/ilpars.fsy"
                               _1 + "." + _3 
                   )
//# 151 "src/Compiler/AbstractIL/ilpars.fsy"
                 : string));
//# 821 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> string in
            let _4 = parseState.GetInput(4) :?> 'gentype_slashedName in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 155 "src/Compiler/AbstractIL/ilpars.fsy"
                               let (enc,nm) = _4 
                               ILScopeRef.PrimaryAssembly, enc, nm 
                   )
//# 155 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_className));
//# 834 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_slashedName in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 158 "src/Compiler/AbstractIL/ilpars.fsy"
                               let enc, nm = _1 in (ILScopeRef.Local, enc, nm) 
                   )
//# 158 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_className));
//# 845 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> string in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 162 "src/Compiler/AbstractIL/ilpars.fsy"
                               ([],_1) 
                   )
//# 162 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_slashedName));
//# 856 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> string in
            let _3 = parseState.GetInput(3) :?> 'gentype_slashedName in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 164 "src/Compiler/AbstractIL/ilpars.fsy"
                               let (enc,nm) = _3 in (_1 :: enc, nm)  
                   )
//# 164 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_slashedName));
//# 868 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_className in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_actual_tyargs in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 168 "src/Compiler/AbstractIL/ilpars.fsy"
                               let (a,b,c) = _1 
                               resolveMethodSpecScopeThen _2 (fun inst -> 
                               noMethodSpecScope ( (mkILTySpec ( (mkILNestedTyRef (a,b,c)), inst)))) 
                   )
//# 168 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_typeNameInst));
//# 882 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_className in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 175 "src/Compiler/AbstractIL/ilpars.fsy"
                               let (a,b,c) = _1 
                               noMethodSpecScope ( (mkILTySpec ( (mkILNestedTyRef (a,b,c)), []))) 
                   )
//# 175 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_typeName));
//# 894 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typeName in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 181 "src/Compiler/AbstractIL/ilpars.fsy"
                               resolveMethodSpecScopeThen _1 (fun tref -> 
                               noMethodSpecScope (mkILBoxedType tref))  
                   )
//# 181 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_typSpec));
//# 906 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ILType ResolvedAtMethodSpecScope in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 184 "src/Compiler/AbstractIL/ilpars.fsy"
                               _1 
                   )
//# 184 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_typSpec));
//# 917 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> ILType ResolvedAtMethodSpecScope in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 186 "src/Compiler/AbstractIL/ilpars.fsy"
                               _2 
                   )
//# 186 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_typSpec));
//# 928 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_callKind in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 191 "src/Compiler/AbstractIL/ilpars.fsy"
                               Callconv (ILThisConvention.Instance,_2) 
                   )
//# 191 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_callConv));
//# 939 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_callKind in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 193 "src/Compiler/AbstractIL/ilpars.fsy"
                               Callconv (ILThisConvention.InstanceExplicit,_2) 
                   )
//# 193 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_callConv));
//# 950 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_callKind in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 195 "src/Compiler/AbstractIL/ilpars.fsy"
                               Callconv (ILThisConvention.Static,_1) 
                   )
//# 195 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_callConv));
//# 961 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 199 "src/Compiler/AbstractIL/ilpars.fsy"
                             ILArgConvention.Default 
                   )
//# 199 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_callKind));
//# 971 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 201 "src/Compiler/AbstractIL/ilpars.fsy"
                             ILArgConvention.Default 
                   )
//# 201 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_callKind));
//# 981 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 203 "src/Compiler/AbstractIL/ilpars.fsy"
                             ILArgConvention.VarArg 
                   )
//# 203 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_callKind));
//# 991 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 212 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope PrimaryAssemblyILGlobals.typ_String 
                   )
//# 212 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1001 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 214 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope PrimaryAssemblyILGlobals.typ_Object 
                   )
//# 214 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1011 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_typeNameInst in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 216 "src/Compiler/AbstractIL/ilpars.fsy"
                              resolveMethodSpecScopeThen _2 (fun tspec -> 
                               noMethodSpecScope (mkILBoxedType tspec)) 
                   )
//# 216 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1023 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> 'gentype_typeNameInst in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 219 "src/Compiler/AbstractIL/ilpars.fsy"
                              resolveMethodSpecScopeThen _3 (fun tspec -> 
                              noMethodSpecScope (ILType.Value tspec)) 
                   )
//# 219 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1035 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_typeNameInst in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 222 "src/Compiler/AbstractIL/ilpars.fsy"
                              resolveMethodSpecScopeThen _2 (fun tspec -> 
                              noMethodSpecScope (ILType.Value tspec)) 
                   )
//# 222 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1047 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ILType ResolvedAtMethodSpecScope in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 225 "src/Compiler/AbstractIL/ilpars.fsy"
                              resolveMethodSpecScopeThen _1 (fun ty -> noMethodSpecScope (mkILArr1DTy ty)) 
                   )
//# 225 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1058 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ILType ResolvedAtMethodSpecScope in
            let _3 = parseState.GetInput(3) :?> 'gentype_bounds1 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 227 "src/Compiler/AbstractIL/ilpars.fsy"
                              resolveMethodSpecScopeThen _1 (fun ty -> noMethodSpecScope (mkILArrTy (ty,ILArrayShape _3))) 
                   )
//# 227 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1070 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ILType ResolvedAtMethodSpecScope in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 229 "src/Compiler/AbstractIL/ilpars.fsy"
                              resolveMethodSpecScopeThen _1 (fun ty -> noMethodSpecScope (ILType.Byref ty)) 
                   )
//# 229 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1081 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ILType ResolvedAtMethodSpecScope in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 231 "src/Compiler/AbstractIL/ilpars.fsy"
                              resolveMethodSpecScopeThen _1 (fun ty -> noMethodSpecScope (ILType.Ptr ty)) 
                   )
//# 231 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1092 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 233 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope PrimaryAssemblyILGlobals.typ_Char 
                   )
//# 233 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1102 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 235 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope ILType.Void 
                   )
//# 235 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1112 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 237 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope PrimaryAssemblyILGlobals.typ_Bool 
                   )
//# 237 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1122 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 239 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope PrimaryAssemblyILGlobals.typ_SByte 
                   )
//# 239 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1132 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 241 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope PrimaryAssemblyILGlobals.typ_Int16 
                   )
//# 241 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1142 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 243 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope PrimaryAssemblyILGlobals.typ_Int32 
                   )
//# 243 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1152 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 245 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope PrimaryAssemblyILGlobals.typ_Int64 
                   )
//# 245 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1162 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 247 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope PrimaryAssemblyILGlobals.typ_Single 
                   )
//# 247 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1172 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 249 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope PrimaryAssemblyILGlobals.typ_Double 
                   )
//# 249 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1182 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 251 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope PrimaryAssemblyILGlobals.typ_Byte 
                   )
//# 251 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1192 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 253 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope PrimaryAssemblyILGlobals.typ_UInt16 
                   )
//# 253 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1202 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 255 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope PrimaryAssemblyILGlobals.typ_UInt32 
                   )
//# 255 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1212 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 257 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope PrimaryAssemblyILGlobals.typ_UInt64 
                   )
//# 257 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1222 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 259 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope PrimaryAssemblyILGlobals.typ_Byte 
                   )
//# 259 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1232 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 261 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope PrimaryAssemblyILGlobals.typ_UInt16 
                   )
//# 261 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1242 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 263 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope PrimaryAssemblyILGlobals.typ_UInt32 
                   )
//# 263 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1252 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 265 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope PrimaryAssemblyILGlobals.typ_UInt64 
                   )
//# 265 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1262 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 267 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope PrimaryAssemblyILGlobals.typ_IntPtr 
                   )
//# 267 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1272 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 269 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope PrimaryAssemblyILGlobals.typ_UIntPtr 
                   )
//# 269 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1282 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 271 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope PrimaryAssemblyILGlobals.typ_UIntPtr 
                   )
//# 271 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1292 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_int32 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 274 "src/Compiler/AbstractIL/ilpars.fsy"
                              noMethodSpecScope (ILType.TypeVar (uint16 ( _2)))  
                   )
//# 274 "src/Compiler/AbstractIL/ilpars.fsy"
                 : ILType ResolvedAtMethodSpecScope));
//# 1303 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_bound in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 279 "src/Compiler/AbstractIL/ilpars.fsy"
                              [_1] 
                   )
//# 279 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_bounds1));
//# 1314 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_bounds1 in
            let _3 = parseState.GetInput(3) :?> 'gentype_bound in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 281 "src/Compiler/AbstractIL/ilpars.fsy"
                              _1 @ [_3] 
                   )
//# 281 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_bounds1));
//# 1326 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 285 "src/Compiler/AbstractIL/ilpars.fsy"
                              (None, None) 
                   )
//# 285 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_bound));
//# 1336 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_int32 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 287 "src/Compiler/AbstractIL/ilpars.fsy"
                              (None, Some _1) 
                   )
//# 287 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_bound));
//# 1347 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_int32 in
            let _3 = parseState.GetInput(3) :?> 'gentype_int32 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 289 "src/Compiler/AbstractIL/ilpars.fsy"
                              (Some _1, Some (_3 - _1 + 1)) 
                   )
//# 289 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_bound));
//# 1359 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_int32 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 291 "src/Compiler/AbstractIL/ilpars.fsy"
                              (Some _1, None) 
                   )
//# 291 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_bound));
//# 1370 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> int32 in
            let _2 = parseState.GetInput(2) :?> 'gentype_int32 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 298 "src/Compiler/AbstractIL/ilpars.fsy"
                              (Some _1, Some (_2 - _1 + 1)) 
                   )
//# 298 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_bound));
//# 1382 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> int32 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 300 "src/Compiler/AbstractIL/ilpars.fsy"
                              (Some _1, None) 
                   )
//# 300 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_bound));
//# 1393 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> string in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 304 "src/Compiler/AbstractIL/ilpars.fsy"
                              _1 
                   )
//# 304 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_id));
//# 1404 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> string in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 306 "src/Compiler/AbstractIL/ilpars.fsy"
                              _1 
                   )
//# 306 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_id));
//# 1415 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> int64 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 310 "src/Compiler/AbstractIL/ilpars.fsy"
                              int32 _1 
                   )
//# 310 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_int32));
//# 1426 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> int64 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 314 "src/Compiler/AbstractIL/ilpars.fsy"
                              _1 
                   )
//# 314 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_int64));
//# 1437 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> double in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 318 "src/Compiler/AbstractIL/ilpars.fsy"
                              _1 
                   )
//# 318 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_float64));
//# 1448 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> 'gentype_int64 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 320 "src/Compiler/AbstractIL/ilpars.fsy"
                              System.BitConverter.Int64BitsToDouble _3 
                   )
//# 320 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_float64));
//# 1459 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 324 "src/Compiler/AbstractIL/ilpars.fsy"
                               noMethodSpecScope [] 
                   )
//# 324 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_opt_actual_tyargs));
//# 1469 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_actual_tyargs in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 326 "src/Compiler/AbstractIL/ilpars.fsy"
                               resolveMethodSpecScopeThen _1 (fun res -> 
                               noMethodSpecScope  res) 
                   )
//# 326 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_opt_actual_tyargs));
//# 1481 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_actualTypSpecs in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 331 "src/Compiler/AbstractIL/ilpars.fsy"
                               _2 
                   )
//# 331 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_actual_tyargs));
//# 1492 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typSpec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 335 "src/Compiler/AbstractIL/ilpars.fsy"
                               resolveMethodSpecScopeThen _1 (fun res -> 
                               noMethodSpecScope [ res]) 
                   )
//# 335 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_actualTypSpecs));
//# 1504 "ilpars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_actualTypSpecs in
            let _3 = parseState.GetInput(3) :?> 'gentype_typSpec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 338 "src/Compiler/AbstractIL/ilpars.fsy"
                               resolveMethodSpecScopeThen _1 (fun x -> 
                               resolveMethodSpecScopeThen _3 (fun y -> 
                               noMethodSpecScope (x @ [ y]))) 
                   )
//# 338 "src/Compiler/AbstractIL/ilpars.fsy"
                 : 'gentype_actualTypSpecs));
|]
//# 1519 "ilpars.fs"
let tables : Internal.Utilities.Text.Parsing.Tables<_> = 
  { reductions = _fsyacc_reductions.Value;
    endOfInputTag = _fsyacc_endOfInputTag;
    tagOfToken = tagOfToken;
    dataOfToken = _fsyacc_dataOfToken; 
    actionTableElements = _fsyacc_actionTableElements;
    actionTableRowOffsets = _fsyacc_actionTableRowOffsets;
    stateToProdIdxsTableElements = _fsyacc_stateToProdIdxsTableElements;
    stateToProdIdxsTableRowOffsets = _fsyacc_stateToProdIdxsTableRowOffsets;
    reductionSymbolCounts = _fsyacc_reductionSymbolCounts;
    immediateActions = _fsyacc_immediateActions;
    gotos = _fsyacc_gotos;
    sparseGotoTableRowOffsets = _fsyacc_sparseGotoTableRowOffsets;
    tagOfErrorTerminal = _fsyacc_tagOfErrorTerminal;
    parseError = (fun (ctxt:Internal.Utilities.Text.Parsing.ParseErrorContext<_>) -> 
                              match parse_error_rich with 
                              | Some f -> f ctxt
                              | None -> parse_error ctxt.Message);
    numTerminals = 67;
    productionToNonTerminalTable = _fsyacc_productionToNonTerminalTable  }
let engine lexer lexbuf startState = tables.Interpret(lexer, lexbuf, startState)
let ilInstrs lexer lexbuf : ILInstr array =
    engine lexer lexbuf 0 :?> _
let ilType lexer lexbuf : ILType =
    engine lexer lexbuf 2 :?> _
