/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.SelectorNode;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.TypeInfo;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.BitSet;
import macromedia.asc.util.Context;

public class SetExpressionNode
extends SelectorNode {
    public ArgumentListNode args;
    public TypeInfo value_type;
    public boolean is_constinit;
    public boolean is_initializer;
    public BitSet gen_bits;
    public boolean void_result;

    @Override
    public ReferenceValue getRef(Context cx) {
        return this.ref;
    }

    public SetExpressionNode(Node expr, ArgumentListNode args) {
        this.expr = expr;
        this.args = args;
        this.ref = null;
        this.gen_bits = null;
        this.void_result = false;
        this.is_constinit = false;
        this.is_initializer = false;
    }

    @Override
    public Value evaluate(Context cx, Evaluator evaluator) {
        if (evaluator.checkFeature(cx, this)) {
            return evaluator.evaluate(cx, this);
        }
        return null;
    }

    @Override
    public void voidResult() {
        this.void_result = true;
        this.expr.voidResult();
    }

    @Override
    public boolean isSetExpression() {
        return true;
    }

    @Override
    public boolean isQualified() {
        QualifiedIdentifierNode qin;
        QualifiedIdentifierNode qualifiedIdentifierNode = qin = this.expr instanceof QualifiedIdentifierNode ? (QualifiedIdentifierNode)this.expr : null;
        return qin != null ? qin.qualifier != null : false;
    }

    @Override
    public boolean isAttributeIdentifier() {
        return this.expr instanceof IdentifierNode ? ((IdentifierNode)this.expr).isAttr() : false;
    }

    @Override
    public boolean isAny() {
        return this.expr instanceof IdentifierNode ? ((IdentifierNode)this.expr).isAny() : false;
    }

    @Override
    public BitSet getGenBits() {
        return this.gen_bits;
    }

    @Override
    public BitSet getKillBits() {
        if (this.ref != null && this.ref.slot != null) {
            if (this.ref.slot.getDefBits() != null) {
                return BitSet.xor(this.ref.slot.getDefBits(), this.gen_bits);
            }
            return this.gen_bits;
        }
        return null;
    }

    @Override
    public String toString() {
        return "SetExpression";
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }
}

