package kusto

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AzureScaleType enumerates the values for azure scale type.
type AzureScaleType string

const (
	// Automatic ...
	Automatic AzureScaleType = "automatic"
	// Manual ...
	Manual AzureScaleType = "manual"
	// None ...
	None AzureScaleType = "none"
)

// PossibleAzureScaleTypeValues returns an array of possible values for the AzureScaleType const type.
func PossibleAzureScaleTypeValues() []AzureScaleType {
	return []AzureScaleType{Automatic, Manual, None}
}

// AzureSkuName enumerates the values for azure sku name.
type AzureSkuName string

const (
	// DevNoSLAStandardD11V2 ...
	DevNoSLAStandardD11V2 AzureSkuName = "Dev(No SLA)_Standard_D11_v2"
	// DevNoSLAStandardE2aV4 ...
	DevNoSLAStandardE2aV4 AzureSkuName = "Dev(No SLA)_Standard_E2a_v4"
	// StandardD11V2 ...
	StandardD11V2 AzureSkuName = "Standard_D11_v2"
	// StandardD12V2 ...
	StandardD12V2 AzureSkuName = "Standard_D12_v2"
	// StandardD13V2 ...
	StandardD13V2 AzureSkuName = "Standard_D13_v2"
	// StandardD14V2 ...
	StandardD14V2 AzureSkuName = "Standard_D14_v2"
	// StandardDS13V21TBPS ...
	StandardDS13V21TBPS AzureSkuName = "Standard_DS13_v2+1TB_PS"
	// StandardDS13V22TBPS ...
	StandardDS13V22TBPS AzureSkuName = "Standard_DS13_v2+2TB_PS"
	// StandardDS14V23TBPS ...
	StandardDS14V23TBPS AzureSkuName = "Standard_DS14_v2+3TB_PS"
	// StandardDS14V24TBPS ...
	StandardDS14V24TBPS AzureSkuName = "Standard_DS14_v2+4TB_PS"
	// StandardE16asV43TBPS ...
	StandardE16asV43TBPS AzureSkuName = "Standard_E16as_v4+3TB_PS"
	// StandardE16asV44TBPS ...
	StandardE16asV44TBPS AzureSkuName = "Standard_E16as_v4+4TB_PS"
	// StandardE16aV4 ...
	StandardE16aV4 AzureSkuName = "Standard_E16a_v4"
	// StandardE2aV4 ...
	StandardE2aV4 AzureSkuName = "Standard_E2a_v4"
	// StandardE4aV4 ...
	StandardE4aV4 AzureSkuName = "Standard_E4a_v4"
	// StandardE64iV3 ...
	StandardE64iV3 AzureSkuName = "Standard_E64i_v3"
	// StandardE8asV41TBPS ...
	StandardE8asV41TBPS AzureSkuName = "Standard_E8as_v4+1TB_PS"
	// StandardE8asV42TBPS ...
	StandardE8asV42TBPS AzureSkuName = "Standard_E8as_v4+2TB_PS"
	// StandardE8aV4 ...
	StandardE8aV4 AzureSkuName = "Standard_E8a_v4"
	// StandardL16s ...
	StandardL16s AzureSkuName = "Standard_L16s"
	// StandardL4s ...
	StandardL4s AzureSkuName = "Standard_L4s"
	// StandardL8s ...
	StandardL8s AzureSkuName = "Standard_L8s"
)

// PossibleAzureSkuNameValues returns an array of possible values for the AzureSkuName const type.
func PossibleAzureSkuNameValues() []AzureSkuName {
	return []AzureSkuName{DevNoSLAStandardD11V2, DevNoSLAStandardE2aV4, StandardD11V2, StandardD12V2, StandardD13V2, StandardD14V2, StandardDS13V21TBPS, StandardDS13V22TBPS, StandardDS14V23TBPS, StandardDS14V24TBPS, StandardE16asV43TBPS, StandardE16asV44TBPS, StandardE16aV4, StandardE2aV4, StandardE4aV4, StandardE64iV3, StandardE8asV41TBPS, StandardE8asV42TBPS, StandardE8aV4, StandardL16s, StandardL4s, StandardL8s}
}

// AzureSkuTier enumerates the values for azure sku tier.
type AzureSkuTier string

const (
	// Basic ...
	Basic AzureSkuTier = "Basic"
	// Standard ...
	Standard AzureSkuTier = "Standard"
)

// PossibleAzureSkuTierValues returns an array of possible values for the AzureSkuTier const type.
func PossibleAzureSkuTierValues() []AzureSkuTier {
	return []AzureSkuTier{Basic, Standard}
}

// BlobStorageEventType enumerates the values for blob storage event type.
type BlobStorageEventType string

const (
	// MicrosoftStorageBlobCreated ...
	MicrosoftStorageBlobCreated BlobStorageEventType = "Microsoft.Storage.BlobCreated"
	// MicrosoftStorageBlobRenamed ...
	MicrosoftStorageBlobRenamed BlobStorageEventType = "Microsoft.Storage.BlobRenamed"
)

// PossibleBlobStorageEventTypeValues returns an array of possible values for the BlobStorageEventType const type.
func PossibleBlobStorageEventTypeValues() []BlobStorageEventType {
	return []BlobStorageEventType{MicrosoftStorageBlobCreated, MicrosoftStorageBlobRenamed}
}

// ClusterPrincipalRole enumerates the values for cluster principal role.
type ClusterPrincipalRole string

const (
	// AllDatabasesAdmin ...
	AllDatabasesAdmin ClusterPrincipalRole = "AllDatabasesAdmin"
	// AllDatabasesViewer ...
	AllDatabasesViewer ClusterPrincipalRole = "AllDatabasesViewer"
)

// PossibleClusterPrincipalRoleValues returns an array of possible values for the ClusterPrincipalRole const type.
func PossibleClusterPrincipalRoleValues() []ClusterPrincipalRole {
	return []ClusterPrincipalRole{AllDatabasesAdmin, AllDatabasesViewer}
}

// Compression enumerates the values for compression.
type Compression string

const (
	// CompressionGZip ...
	CompressionGZip Compression = "GZip"
	// CompressionNone ...
	CompressionNone Compression = "None"
)

// PossibleCompressionValues returns an array of possible values for the Compression const type.
func PossibleCompressionValues() []Compression {
	return []Compression{CompressionGZip, CompressionNone}
}

// DatabasePrincipalRole enumerates the values for database principal role.
type DatabasePrincipalRole string

const (
	// Admin ...
	Admin DatabasePrincipalRole = "Admin"
	// Ingestor ...
	Ingestor DatabasePrincipalRole = "Ingestor"
	// Monitor ...
	Monitor DatabasePrincipalRole = "Monitor"
	// UnrestrictedViewers ...
	UnrestrictedViewers DatabasePrincipalRole = "UnrestrictedViewers"
	// User ...
	User DatabasePrincipalRole = "User"
	// Viewer ...
	Viewer DatabasePrincipalRole = "Viewer"
)

// PossibleDatabasePrincipalRoleValues returns an array of possible values for the DatabasePrincipalRole const type.
func PossibleDatabasePrincipalRoleValues() []DatabasePrincipalRole {
	return []DatabasePrincipalRole{Admin, Ingestor, Monitor, UnrestrictedViewers, User, Viewer}
}

// DatabasePrincipalType enumerates the values for database principal type.
type DatabasePrincipalType string

const (
	// DatabasePrincipalTypeApp ...
	DatabasePrincipalTypeApp DatabasePrincipalType = "App"
	// DatabasePrincipalTypeGroup ...
	DatabasePrincipalTypeGroup DatabasePrincipalType = "Group"
	// DatabasePrincipalTypeUser ...
	DatabasePrincipalTypeUser DatabasePrincipalType = "User"
)

// PossibleDatabasePrincipalTypeValues returns an array of possible values for the DatabasePrincipalType const type.
func PossibleDatabasePrincipalTypeValues() []DatabasePrincipalType {
	return []DatabasePrincipalType{DatabasePrincipalTypeApp, DatabasePrincipalTypeGroup, DatabasePrincipalTypeUser}
}

// DefaultPrincipalsModificationKind enumerates the values for default principals modification kind.
type DefaultPrincipalsModificationKind string

const (
	// DefaultPrincipalsModificationKindNone ...
	DefaultPrincipalsModificationKindNone DefaultPrincipalsModificationKind = "None"
	// DefaultPrincipalsModificationKindReplace ...
	DefaultPrincipalsModificationKindReplace DefaultPrincipalsModificationKind = "Replace"
	// DefaultPrincipalsModificationKindUnion ...
	DefaultPrincipalsModificationKindUnion DefaultPrincipalsModificationKind = "Union"
)

// PossibleDefaultPrincipalsModificationKindValues returns an array of possible values for the DefaultPrincipalsModificationKind const type.
func PossibleDefaultPrincipalsModificationKindValues() []DefaultPrincipalsModificationKind {
	return []DefaultPrincipalsModificationKind{DefaultPrincipalsModificationKindNone, DefaultPrincipalsModificationKindReplace, DefaultPrincipalsModificationKindUnion}
}

// EngineType enumerates the values for engine type.
type EngineType string

const (
	// V2 ...
	V2 EngineType = "V2"
	// V3 ...
	V3 EngineType = "V3"
)

// PossibleEngineTypeValues returns an array of possible values for the EngineType const type.
func PossibleEngineTypeValues() []EngineType {
	return []EngineType{V2, V3}
}

// EventGridDataFormat enumerates the values for event grid data format.
type EventGridDataFormat string

const (
	// APACHEAVRO ...
	APACHEAVRO EventGridDataFormat = "APACHEAVRO"
	// AVRO ...
	AVRO EventGridDataFormat = "AVRO"
	// CSV ...
	CSV EventGridDataFormat = "CSV"
	// JSON ...
	JSON EventGridDataFormat = "JSON"
	// MULTIJSON ...
	MULTIJSON EventGridDataFormat = "MULTIJSON"
	// ORC ...
	ORC EventGridDataFormat = "ORC"
	// PARQUET ...
	PARQUET EventGridDataFormat = "PARQUET"
	// PSV ...
	PSV EventGridDataFormat = "PSV"
	// RAW ...
	RAW EventGridDataFormat = "RAW"
	// SCSV ...
	SCSV EventGridDataFormat = "SCSV"
	// SINGLEJSON ...
	SINGLEJSON EventGridDataFormat = "SINGLEJSON"
	// SOHSV ...
	SOHSV EventGridDataFormat = "SOHSV"
	// TSV ...
	TSV EventGridDataFormat = "TSV"
	// TSVE ...
	TSVE EventGridDataFormat = "TSVE"
	// TXT ...
	TXT EventGridDataFormat = "TXT"
	// W3CLOGFILE ...
	W3CLOGFILE EventGridDataFormat = "W3CLOGFILE"
)

// PossibleEventGridDataFormatValues returns an array of possible values for the EventGridDataFormat const type.
func PossibleEventGridDataFormatValues() []EventGridDataFormat {
	return []EventGridDataFormat{APACHEAVRO, AVRO, CSV, JSON, MULTIJSON, ORC, PARQUET, PSV, RAW, SCSV, SINGLEJSON, SOHSV, TSV, TSVE, TXT, W3CLOGFILE}
}

// EventHubDataFormat enumerates the values for event hub data format.
type EventHubDataFormat string

const (
	// EventHubDataFormatAPACHEAVRO ...
	EventHubDataFormatAPACHEAVRO EventHubDataFormat = "APACHEAVRO"
	// EventHubDataFormatAVRO ...
	EventHubDataFormatAVRO EventHubDataFormat = "AVRO"
	// EventHubDataFormatCSV ...
	EventHubDataFormatCSV EventHubDataFormat = "CSV"
	// EventHubDataFormatJSON ...
	EventHubDataFormatJSON EventHubDataFormat = "JSON"
	// EventHubDataFormatMULTIJSON ...
	EventHubDataFormatMULTIJSON EventHubDataFormat = "MULTIJSON"
	// EventHubDataFormatORC ...
	EventHubDataFormatORC EventHubDataFormat = "ORC"
	// EventHubDataFormatPARQUET ...
	EventHubDataFormatPARQUET EventHubDataFormat = "PARQUET"
	// EventHubDataFormatPSV ...
	EventHubDataFormatPSV EventHubDataFormat = "PSV"
	// EventHubDataFormatRAW ...
	EventHubDataFormatRAW EventHubDataFormat = "RAW"
	// EventHubDataFormatSCSV ...
	EventHubDataFormatSCSV EventHubDataFormat = "SCSV"
	// EventHubDataFormatSINGLEJSON ...
	EventHubDataFormatSINGLEJSON EventHubDataFormat = "SINGLEJSON"
	// EventHubDataFormatSOHSV ...
	EventHubDataFormatSOHSV EventHubDataFormat = "SOHSV"
	// EventHubDataFormatTSV ...
	EventHubDataFormatTSV EventHubDataFormat = "TSV"
	// EventHubDataFormatTSVE ...
	EventHubDataFormatTSVE EventHubDataFormat = "TSVE"
	// EventHubDataFormatTXT ...
	EventHubDataFormatTXT EventHubDataFormat = "TXT"
	// EventHubDataFormatW3CLOGFILE ...
	EventHubDataFormatW3CLOGFILE EventHubDataFormat = "W3CLOGFILE"
)

// PossibleEventHubDataFormatValues returns an array of possible values for the EventHubDataFormat const type.
func PossibleEventHubDataFormatValues() []EventHubDataFormat {
	return []EventHubDataFormat{EventHubDataFormatAPACHEAVRO, EventHubDataFormatAVRO, EventHubDataFormatCSV, EventHubDataFormatJSON, EventHubDataFormatMULTIJSON, EventHubDataFormatORC, EventHubDataFormatPARQUET, EventHubDataFormatPSV, EventHubDataFormatRAW, EventHubDataFormatSCSV, EventHubDataFormatSINGLEJSON, EventHubDataFormatSOHSV, EventHubDataFormatTSV, EventHubDataFormatTSVE, EventHubDataFormatTXT, EventHubDataFormatW3CLOGFILE}
}

// IdentityType enumerates the values for identity type.
type IdentityType string

const (
	// IdentityTypeNone ...
	IdentityTypeNone IdentityType = "None"
	// IdentityTypeSystemAssigned ...
	IdentityTypeSystemAssigned IdentityType = "SystemAssigned"
	// IdentityTypeSystemAssignedUserAssigned ...
	IdentityTypeSystemAssignedUserAssigned IdentityType = "SystemAssigned, UserAssigned"
	// IdentityTypeUserAssigned ...
	IdentityTypeUserAssigned IdentityType = "UserAssigned"
)

// PossibleIdentityTypeValues returns an array of possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{IdentityTypeNone, IdentityTypeSystemAssigned, IdentityTypeSystemAssignedUserAssigned, IdentityTypeUserAssigned}
}

// IotHubDataFormat enumerates the values for iot hub data format.
type IotHubDataFormat string

const (
	// IotHubDataFormatAPACHEAVRO ...
	IotHubDataFormatAPACHEAVRO IotHubDataFormat = "APACHEAVRO"
	// IotHubDataFormatAVRO ...
	IotHubDataFormatAVRO IotHubDataFormat = "AVRO"
	// IotHubDataFormatCSV ...
	IotHubDataFormatCSV IotHubDataFormat = "CSV"
	// IotHubDataFormatJSON ...
	IotHubDataFormatJSON IotHubDataFormat = "JSON"
	// IotHubDataFormatMULTIJSON ...
	IotHubDataFormatMULTIJSON IotHubDataFormat = "MULTIJSON"
	// IotHubDataFormatORC ...
	IotHubDataFormatORC IotHubDataFormat = "ORC"
	// IotHubDataFormatPARQUET ...
	IotHubDataFormatPARQUET IotHubDataFormat = "PARQUET"
	// IotHubDataFormatPSV ...
	IotHubDataFormatPSV IotHubDataFormat = "PSV"
	// IotHubDataFormatRAW ...
	IotHubDataFormatRAW IotHubDataFormat = "RAW"
	// IotHubDataFormatSCSV ...
	IotHubDataFormatSCSV IotHubDataFormat = "SCSV"
	// IotHubDataFormatSINGLEJSON ...
	IotHubDataFormatSINGLEJSON IotHubDataFormat = "SINGLEJSON"
	// IotHubDataFormatSOHSV ...
	IotHubDataFormatSOHSV IotHubDataFormat = "SOHSV"
	// IotHubDataFormatTSV ...
	IotHubDataFormatTSV IotHubDataFormat = "TSV"
	// IotHubDataFormatTSVE ...
	IotHubDataFormatTSVE IotHubDataFormat = "TSVE"
	// IotHubDataFormatTXT ...
	IotHubDataFormatTXT IotHubDataFormat = "TXT"
	// IotHubDataFormatW3CLOGFILE ...
	IotHubDataFormatW3CLOGFILE IotHubDataFormat = "W3CLOGFILE"
)

// PossibleIotHubDataFormatValues returns an array of possible values for the IotHubDataFormat const type.
func PossibleIotHubDataFormatValues() []IotHubDataFormat {
	return []IotHubDataFormat{IotHubDataFormatAPACHEAVRO, IotHubDataFormatAVRO, IotHubDataFormatCSV, IotHubDataFormatJSON, IotHubDataFormatMULTIJSON, IotHubDataFormatORC, IotHubDataFormatPARQUET, IotHubDataFormatPSV, IotHubDataFormatRAW, IotHubDataFormatSCSV, IotHubDataFormatSINGLEJSON, IotHubDataFormatSOHSV, IotHubDataFormatTSV, IotHubDataFormatTSVE, IotHubDataFormatTXT, IotHubDataFormatW3CLOGFILE}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindDatabase ...
	KindDatabase Kind = "Database"
	// KindReadOnlyFollowing ...
	KindReadOnlyFollowing Kind = "ReadOnlyFollowing"
	// KindReadWrite ...
	KindReadWrite Kind = "ReadWrite"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindDatabase, KindReadOnlyFollowing, KindReadWrite}
}

// KindBasicDataConnection enumerates the values for kind basic data connection.
type KindBasicDataConnection string

const (
	// KindDataConnection ...
	KindDataConnection KindBasicDataConnection = "DataConnection"
	// KindEventGrid ...
	KindEventGrid KindBasicDataConnection = "EventGrid"
	// KindEventHub ...
	KindEventHub KindBasicDataConnection = "EventHub"
	// KindIotHub ...
	KindIotHub KindBasicDataConnection = "IotHub"
)

// PossibleKindBasicDataConnectionValues returns an array of possible values for the KindBasicDataConnection const type.
func PossibleKindBasicDataConnectionValues() []KindBasicDataConnection {
	return []KindBasicDataConnection{KindDataConnection, KindEventGrid, KindEventHub, KindIotHub}
}

// LanguageExtensionName enumerates the values for language extension name.
type LanguageExtensionName string

const (
	// PYTHON ...
	PYTHON LanguageExtensionName = "PYTHON"
	// R ...
	R LanguageExtensionName = "R"
)

// PossibleLanguageExtensionNameValues returns an array of possible values for the LanguageExtensionName const type.
func PossibleLanguageExtensionNameValues() []LanguageExtensionName {
	return []LanguageExtensionName{PYTHON, R}
}

// PrincipalsModificationKind enumerates the values for principals modification kind.
type PrincipalsModificationKind string

const (
	// PrincipalsModificationKindNone ...
	PrincipalsModificationKindNone PrincipalsModificationKind = "None"
	// PrincipalsModificationKindReplace ...
	PrincipalsModificationKindReplace PrincipalsModificationKind = "Replace"
	// PrincipalsModificationKindUnion ...
	PrincipalsModificationKindUnion PrincipalsModificationKind = "Union"
)

// PossiblePrincipalsModificationKindValues returns an array of possible values for the PrincipalsModificationKind const type.
func PossiblePrincipalsModificationKindValues() []PrincipalsModificationKind {
	return []PrincipalsModificationKind{PrincipalsModificationKindNone, PrincipalsModificationKindReplace, PrincipalsModificationKindUnion}
}

// PrincipalType enumerates the values for principal type.
type PrincipalType string

const (
	// PrincipalTypeApp ...
	PrincipalTypeApp PrincipalType = "App"
	// PrincipalTypeGroup ...
	PrincipalTypeGroup PrincipalType = "Group"
	// PrincipalTypeUser ...
	PrincipalTypeUser PrincipalType = "User"
)

// PossiblePrincipalTypeValues returns an array of possible values for the PrincipalType const type.
func PossiblePrincipalTypeValues() []PrincipalType {
	return []PrincipalType{PrincipalTypeApp, PrincipalTypeGroup, PrincipalTypeUser}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Creating ...
	Creating ProvisioningState = "Creating"
	// Deleting ...
	Deleting ProvisioningState = "Deleting"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Moving ...
	Moving ProvisioningState = "Moving"
	// Running ...
	Running ProvisioningState = "Running"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Creating, Deleting, Failed, Moving, Running, Succeeded}
}

// Reason enumerates the values for reason.
type Reason string

const (
	// AlreadyExists ...
	AlreadyExists Reason = "AlreadyExists"
	// Invalid ...
	Invalid Reason = "Invalid"
)

// PossibleReasonValues returns an array of possible values for the Reason const type.
func PossibleReasonValues() []Reason {
	return []Reason{AlreadyExists, Invalid}
}

// State enumerates the values for state.
type State string

const (
	// StateCreating ...
	StateCreating State = "Creating"
	// StateDeleted ...
	StateDeleted State = "Deleted"
	// StateDeleting ...
	StateDeleting State = "Deleting"
	// StateRunning ...
	StateRunning State = "Running"
	// StateStarting ...
	StateStarting State = "Starting"
	// StateStopped ...
	StateStopped State = "Stopped"
	// StateStopping ...
	StateStopping State = "Stopping"
	// StateUnavailable ...
	StateUnavailable State = "Unavailable"
	// StateUpdating ...
	StateUpdating State = "Updating"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{StateCreating, StateDeleted, StateDeleting, StateRunning, StateStarting, StateStopped, StateStopping, StateUnavailable, StateUpdating}
}

// Type enumerates the values for type.
type Type string

const (
	// MicrosoftKustoclustersattachedDatabaseConfigurations ...
	MicrosoftKustoclustersattachedDatabaseConfigurations Type = "Microsoft.Kusto/clusters/attachedDatabaseConfigurations"
	// MicrosoftKustoclustersdatabases ...
	MicrosoftKustoclustersdatabases Type = "Microsoft.Kusto/clusters/databases"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{MicrosoftKustoclustersattachedDatabaseConfigurations, MicrosoftKustoclustersdatabases}
}
