/*
 * Copyright (c) 2022, NVIDIA CORPORATION.  All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * File:   DcgmSettings.h
 */

#ifndef DCGMSETTINGS_H
#define DCGMSETTINGS_H

#include "DcgmLogging.h"
#include "dcgm_structs.h"

#define DCGM_MIN_DRIVER_VERSION "384.00"

#define DCGM_ENV_LOG_PREFIX "__DCGM_DBG"

/* Environmental variable to bypass the white list */
#define DCGM_ENV_WL_BYPASS "__DCGM_WL_BYPASS"

#define DCGM_MODE_EMBEDDED_HE   0 /* Mode when Host Engine is Embedded. ISV Agent Use Case */
#define DCGM_MODE_STANDALONE_HE 1 /* Mode when Host Engine is Standalone. NV Agent Use Case */

/*****************************************************************************/
/* Null/failure IDs to use as initializers and error returns */
#define DCGM_NVML_ID_BAD   (-1)
#define DCGM_GPU_ID_BAD    ((unsigned int)-1)
#define DCGM_ENTITY_ID_BAD DCGM_GPU_ID_BAD

#endif /* DCGMSETTINGS_H */
