import 'package:flutter/material.dart';
import 'package:hooks_riverpod/hooks_riverpod.dart';
import 'package:immich_mobile/modules/home/ui/asset_grid/thumbnail_image.dart';
import 'package:immich_mobile/shared/models/asset.dart';

class SearchResultGrid extends HookConsumerWidget {
  const SearchResultGrid({super.key, required this.assets});

  final List<Asset> assets;

  Asset _loadAsset(int index) => assets[index];

  @override
  Widget build(BuildContext context, WidgetRef ref) {
    return GridView.builder(
      gridDelegate: const SliverGridDelegateWithFixedCrossAxisCount(
        crossAxisCount: 4,
        childAspectRatio: 1,
        crossAxisSpacing: 4,
        mainAxisSpacing: 4,
      ),
      itemCount: assets.length,
      itemBuilder: (context, index) {
        final asset = assets[index];
        return ThumbnailImage(
          asset: asset,
          index: index,
          loadAsset: _loadAsset,
          totalAssets: assets.length,
          useGrayBoxPlaceholder: true,
        );
      },
    );
  }
}
