import 'package:flutter/material.dart';
import 'package:flutter_hooks/flutter_hooks.dart';

/// This example emulates the basic Counter app generated by the
/// `flutter create` command to demonstrates the `useReducer` hook.
///
/// First, instead of a StatefulWidget, use a HookWidget instead!

@immutable
class State {
  const State({this.counter = 0});
  final int counter;
}

// Create the actions you wish to dispatch to the reducer
class IncrementCounter {
  IncrementCounter({this.counter});
  int counter;
}

class UseReducerExample extends HookWidget {
  @override
  Widget build(BuildContext context) {
    // Create the reducer function that will handle the actions you dispatch
    State _reducer(State state, IncrementCounter action) {
      if (action is IncrementCounter) {
        return State(counter: state.counter + action.counter);
      }
      return state;
    }

    // Next, invoke the `useReducer` function with the reducer function and initial state to create a
    // `_store` variable that contains the current state and dispatch. Whenever the value is
    // changed, this Widget will be rebuilt!
    final _store = useReducer<State, IncrementCounter>(
      _reducer,
      initialState: const State(),
      initialAction: null,
    );

    return Scaffold(
      appBar: AppBar(
        title: const Text('useState example'),
      ),
      body: Center(
        // Read the current value from the counter
        child: Text('Button tapped ${_store.state.counter} times'),
      ),
      floatingActionButton: FloatingActionButton(
        // When the button is pressed, dispatch the Action you wish to trigger! This
        // will trigger a rebuild, displaying the latest value in the Text
        // Widget above!
        onPressed: () => _store.dispatch(IncrementCounter(counter: 1)),
        child: const Icon(Icons.add),
      ),
    );
  }
}
