# openapi
Immich API

This Dart package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.59.1
- Build package: org.openapitools.codegen.languages.DartClientCodegen

## Requirements

Dart 2.12 or later

## Installation & Usage

### Github
If this Dart package is published to Github, add the following dependency to your pubspec.yaml
```
dependencies:
  openapi:
    git: https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```

### Local
To use the package in your local drive, add the following dependency to your pubspec.yaml
```
dependencies:
  openapi:
    path: /path/to/openapi
```

## Tests

TODO

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```dart
import 'package:openapi/api.dart';

// TODO Configure API key authorization: cookie
//defaultApiClient.getAuthentication<ApiKeyAuth>('cookie').apiKey = 'YOUR_API_KEY';
// uncomment below to setup prefix (e.g. Bearer) for API key, if needed
//defaultApiClient.getAuthentication<ApiKeyAuth>('cookie').apiKeyPrefix = 'Bearer';
// TODO Configure API key authorization: api_key
//defaultApiClient.getAuthentication<ApiKeyAuth>('api_key').apiKey = 'YOUR_API_KEY';
// uncomment below to setup prefix (e.g. Bearer) for API key, if needed
//defaultApiClient.getAuthentication<ApiKeyAuth>('api_key').apiKeyPrefix = 'Bearer';
// TODO Configure HTTP Bearer authorization: bearer
// Case 1. Use String Token
//defaultApiClient.getAuthentication<HttpBearerAuth>('bearer').setAccessToken('YOUR_ACCESS_TOKEN');
// Case 2. Use Function which generate token.
// String yourTokenGeneratorFunction() { ... }
//defaultApiClient.getAuthentication<HttpBearerAuth>('bearer').setAccessToken(yourTokenGeneratorFunction);

final api_instance = APIKeyApi();
final aPIKeyCreateDto = APIKeyCreateDto(); // APIKeyCreateDto | 

try {
    final result = api_instance.createKey(aPIKeyCreateDto);
    print(result);
} catch (e) {
    print('Exception when calling APIKeyApi->createKey: $e\n');
}

```

## Documentation for API Endpoints

All URIs are relative to */api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*APIKeyApi* | [**createKey**](doc//APIKeyApi.md#createkey) | **POST** /api-key | 
*APIKeyApi* | [**deleteKey**](doc//APIKeyApi.md#deletekey) | **DELETE** /api-key/{id} | 
*APIKeyApi* | [**getKey**](doc//APIKeyApi.md#getkey) | **GET** /api-key/{id} | 
*APIKeyApi* | [**getKeys**](doc//APIKeyApi.md#getkeys) | **GET** /api-key | 
*APIKeyApi* | [**updateKey**](doc//APIKeyApi.md#updatekey) | **PUT** /api-key/{id} | 
*AlbumApi* | [**addAssetsToAlbum**](doc//AlbumApi.md#addassetstoalbum) | **PUT** /album/{id}/assets | 
*AlbumApi* | [**addUsersToAlbum**](doc//AlbumApi.md#adduserstoalbum) | **PUT** /album/{id}/users | 
*AlbumApi* | [**createAlbum**](doc//AlbumApi.md#createalbum) | **POST** /album | 
*AlbumApi* | [**createAlbumSharedLink**](doc//AlbumApi.md#createalbumsharedlink) | **POST** /album/create-shared-link | 
*AlbumApi* | [**deleteAlbum**](doc//AlbumApi.md#deletealbum) | **DELETE** /album/{id} | 
*AlbumApi* | [**downloadArchive**](doc//AlbumApi.md#downloadarchive) | **GET** /album/{id}/download | 
*AlbumApi* | [**getAlbumCountByUserId**](doc//AlbumApi.md#getalbumcountbyuserid) | **GET** /album/count-by-user-id | 
*AlbumApi* | [**getAlbumInfo**](doc//AlbumApi.md#getalbuminfo) | **GET** /album/{id} | 
*AlbumApi* | [**getAllAlbums**](doc//AlbumApi.md#getallalbums) | **GET** /album | 
*AlbumApi* | [**removeAssetFromAlbum**](doc//AlbumApi.md#removeassetfromalbum) | **DELETE** /album/{id}/assets | 
*AlbumApi* | [**removeUserFromAlbum**](doc//AlbumApi.md#removeuserfromalbum) | **DELETE** /album/{id}/user/{userId} | 
*AlbumApi* | [**updateAlbumInfo**](doc//AlbumApi.md#updatealbuminfo) | **PATCH** /album/{id} | 
*AssetApi* | [**addAssetsToSharedLink**](doc//AssetApi.md#addassetstosharedlink) | **PATCH** /asset/shared-link/add | 
*AssetApi* | [**bulkUploadCheck**](doc//AssetApi.md#bulkuploadcheck) | **POST** /asset/bulk-upload-check | 
*AssetApi* | [**checkDuplicateAsset**](doc//AssetApi.md#checkduplicateasset) | **POST** /asset/check | 
*AssetApi* | [**checkExistingAssets**](doc//AssetApi.md#checkexistingassets) | **POST** /asset/exist | 
*AssetApi* | [**createAssetsSharedLink**](doc//AssetApi.md#createassetssharedlink) | **POST** /asset/shared-link | 
*AssetApi* | [**deleteAsset**](doc//AssetApi.md#deleteasset) | **DELETE** /asset | 
*AssetApi* | [**downloadFile**](doc//AssetApi.md#downloadfile) | **GET** /asset/download/{assetId} | 
*AssetApi* | [**downloadFiles**](doc//AssetApi.md#downloadfiles) | **POST** /asset/download-files | 
*AssetApi* | [**downloadLibrary**](doc//AssetApi.md#downloadlibrary) | **GET** /asset/download-library | 
*AssetApi* | [**getAllAssets**](doc//AssetApi.md#getallassets) | **GET** /asset | 
*AssetApi* | [**getArchivedAssetCountByUserId**](doc//AssetApi.md#getarchivedassetcountbyuserid) | **GET** /asset/stat/archive | 
*AssetApi* | [**getAssetById**](doc//AssetApi.md#getassetbyid) | **GET** /asset/assetById/{assetId} | 
*AssetApi* | [**getAssetByTimeBucket**](doc//AssetApi.md#getassetbytimebucket) | **POST** /asset/time-bucket | 
*AssetApi* | [**getAssetCountByTimeBucket**](doc//AssetApi.md#getassetcountbytimebucket) | **POST** /asset/count-by-time-bucket | 
*AssetApi* | [**getAssetCountByUserId**](doc//AssetApi.md#getassetcountbyuserid) | **GET** /asset/count-by-user-id | 
*AssetApi* | [**getAssetSearchTerms**](doc//AssetApi.md#getassetsearchterms) | **GET** /asset/search-terms | 
*AssetApi* | [**getAssetThumbnail**](doc//AssetApi.md#getassetthumbnail) | **GET** /asset/thumbnail/{assetId} | 
*AssetApi* | [**getCuratedLocations**](doc//AssetApi.md#getcuratedlocations) | **GET** /asset/curated-locations | 
*AssetApi* | [**getCuratedObjects**](doc//AssetApi.md#getcuratedobjects) | **GET** /asset/curated-objects | 
*AssetApi* | [**getMapMarkers**](doc//AssetApi.md#getmapmarkers) | **GET** /asset/map-marker | 
*AssetApi* | [**getUserAssetsByDeviceId**](doc//AssetApi.md#getuserassetsbydeviceid) | **GET** /asset/{deviceId} | 
*AssetApi* | [**removeAssetsFromSharedLink**](doc//AssetApi.md#removeassetsfromsharedlink) | **PATCH** /asset/shared-link/remove | 
*AssetApi* | [**searchAsset**](doc//AssetApi.md#searchasset) | **POST** /asset/search | 
*AssetApi* | [**serveFile**](doc//AssetApi.md#servefile) | **GET** /asset/file/{assetId} | 
*AssetApi* | [**updateAsset**](doc//AssetApi.md#updateasset) | **PUT** /asset/{assetId} | 
*AssetApi* | [**uploadFile**](doc//AssetApi.md#uploadfile) | **POST** /asset/upload | 
*AuthenticationApi* | [**adminSignUp**](doc//AuthenticationApi.md#adminsignup) | **POST** /auth/admin-sign-up | 
*AuthenticationApi* | [**changePassword**](doc//AuthenticationApi.md#changepassword) | **POST** /auth/change-password | 
*AuthenticationApi* | [**getAuthDevices**](doc//AuthenticationApi.md#getauthdevices) | **GET** /auth/devices | 
*AuthenticationApi* | [**login**](doc//AuthenticationApi.md#login) | **POST** /auth/login | 
*AuthenticationApi* | [**logout**](doc//AuthenticationApi.md#logout) | **POST** /auth/logout | 
*AuthenticationApi* | [**logoutAuthDevice**](doc//AuthenticationApi.md#logoutauthdevice) | **DELETE** /auth/devices/{id} | 
*AuthenticationApi* | [**logoutAuthDevices**](doc//AuthenticationApi.md#logoutauthdevices) | **DELETE** /auth/devices | 
*AuthenticationApi* | [**validateAccessToken**](doc//AuthenticationApi.md#validateaccesstoken) | **POST** /auth/validateToken | 
*JobApi* | [**getAllJobsStatus**](doc//JobApi.md#getalljobsstatus) | **GET** /jobs | 
*JobApi* | [**sendJobCommand**](doc//JobApi.md#sendjobcommand) | **PUT** /jobs/{jobId} | 
*OAuthApi* | [**callback**](doc//OAuthApi.md#callback) | **POST** /oauth/callback | 
*OAuthApi* | [**generateConfig**](doc//OAuthApi.md#generateconfig) | **POST** /oauth/config | 
*OAuthApi* | [**link**](doc//OAuthApi.md#link) | **POST** /oauth/link | 
*OAuthApi* | [**mobileRedirect**](doc//OAuthApi.md#mobileredirect) | **GET** /oauth/mobile-redirect | 
*OAuthApi* | [**unlink**](doc//OAuthApi.md#unlink) | **POST** /oauth/unlink | 
*PartnerApi* | [**createPartner**](doc//PartnerApi.md#createpartner) | **POST** /partner/{id} | 
*PartnerApi* | [**getPartners**](doc//PartnerApi.md#getpartners) | **GET** /partner | 
*PartnerApi* | [**removePartner**](doc//PartnerApi.md#removepartner) | **DELETE** /partner/{id} | 
*PersonApi* | [**getAllPeople**](doc//PersonApi.md#getallpeople) | **GET** /person | 
*PersonApi* | [**getPerson**](doc//PersonApi.md#getperson) | **GET** /person/{id} | 
*PersonApi* | [**getPersonAssets**](doc//PersonApi.md#getpersonassets) | **GET** /person/{id}/assets | 
*PersonApi* | [**getPersonThumbnail**](doc//PersonApi.md#getpersonthumbnail) | **GET** /person/{id}/thumbnail | 
*PersonApi* | [**updatePerson**](doc//PersonApi.md#updateperson) | **PUT** /person/{id} | 
*SearchApi* | [**getExploreData**](doc//SearchApi.md#getexploredata) | **GET** /search/explore | 
*SearchApi* | [**getSearchConfig**](doc//SearchApi.md#getsearchconfig) | **GET** /search/config | 
*SearchApi* | [**search**](doc//SearchApi.md#search) | **GET** /search | 
*ServerInfoApi* | [**getServerInfo**](doc//ServerInfoApi.md#getserverinfo) | **GET** /server-info | 
*ServerInfoApi* | [**getServerVersion**](doc//ServerInfoApi.md#getserverversion) | **GET** /server-info/version | 
*ServerInfoApi* | [**getStats**](doc//ServerInfoApi.md#getstats) | **GET** /server-info/stats | 
*ServerInfoApi* | [**pingServer**](doc//ServerInfoApi.md#pingserver) | **GET** /server-info/ping | 
*ShareApi* | [**editSharedLink**](doc//ShareApi.md#editsharedlink) | **PATCH** /share/{id} | 
*ShareApi* | [**getAllSharedLinks**](doc//ShareApi.md#getallsharedlinks) | **GET** /share | 
*ShareApi* | [**getMySharedLink**](doc//ShareApi.md#getmysharedlink) | **GET** /share/me | 
*ShareApi* | [**getSharedLinkById**](doc//ShareApi.md#getsharedlinkbyid) | **GET** /share/{id} | 
*ShareApi* | [**removeSharedLink**](doc//ShareApi.md#removesharedlink) | **DELETE** /share/{id} | 
*SystemConfigApi* | [**getConfig**](doc//SystemConfigApi.md#getconfig) | **GET** /system-config | 
*SystemConfigApi* | [**getDefaults**](doc//SystemConfigApi.md#getdefaults) | **GET** /system-config/defaults | 
*SystemConfigApi* | [**getStorageTemplateOptions**](doc//SystemConfigApi.md#getstoragetemplateoptions) | **GET** /system-config/storage-template-options | 
*SystemConfigApi* | [**updateConfig**](doc//SystemConfigApi.md#updateconfig) | **PUT** /system-config | 
*TagApi* | [**create**](doc//TagApi.md#create) | **POST** /tag | 
*TagApi* | [**delete**](doc//TagApi.md#delete) | **DELETE** /tag/{id} | 
*TagApi* | [**findAll**](doc//TagApi.md#findall) | **GET** /tag | 
*TagApi* | [**findOne**](doc//TagApi.md#findone) | **GET** /tag/{id} | 
*TagApi* | [**update**](doc//TagApi.md#update) | **PATCH** /tag/{id} | 
*UserApi* | [**createProfileImage**](doc//UserApi.md#createprofileimage) | **POST** /user/profile-image | 
*UserApi* | [**createUser**](doc//UserApi.md#createuser) | **POST** /user | 
*UserApi* | [**deleteUser**](doc//UserApi.md#deleteuser) | **DELETE** /user/{userId} | 
*UserApi* | [**getAllUsers**](doc//UserApi.md#getallusers) | **GET** /user | 
*UserApi* | [**getMyUserInfo**](doc//UserApi.md#getmyuserinfo) | **GET** /user/me | 
*UserApi* | [**getProfileImage**](doc//UserApi.md#getprofileimage) | **GET** /user/profile-image/{userId} | 
*UserApi* | [**getUserById**](doc//UserApi.md#getuserbyid) | **GET** /user/info/{userId} | 
*UserApi* | [**getUserCount**](doc//UserApi.md#getusercount) | **GET** /user/count | 
*UserApi* | [**restoreUser**](doc//UserApi.md#restoreuser) | **POST** /user/{userId}/restore | 
*UserApi* | [**updateUser**](doc//UserApi.md#updateuser) | **PUT** /user | 


## Documentation For Models

 - [APIKeyCreateDto](doc//APIKeyCreateDto.md)
 - [APIKeyCreateResponseDto](doc//APIKeyCreateResponseDto.md)
 - [APIKeyResponseDto](doc//APIKeyResponseDto.md)
 - [APIKeyUpdateDto](doc//APIKeyUpdateDto.md)
 - [AddAssetsDto](doc//AddAssetsDto.md)
 - [AddAssetsResponseDto](doc//AddAssetsResponseDto.md)
 - [AddUsersDto](doc//AddUsersDto.md)
 - [AdminSignupResponseDto](doc//AdminSignupResponseDto.md)
 - [AlbumCountResponseDto](doc//AlbumCountResponseDto.md)
 - [AlbumResponseDto](doc//AlbumResponseDto.md)
 - [AllJobStatusResponseDto](doc//AllJobStatusResponseDto.md)
 - [AssetBulkUploadCheckDto](doc//AssetBulkUploadCheckDto.md)
 - [AssetBulkUploadCheckItem](doc//AssetBulkUploadCheckItem.md)
 - [AssetBulkUploadCheckResponseDto](doc//AssetBulkUploadCheckResponseDto.md)
 - [AssetBulkUploadCheckResult](doc//AssetBulkUploadCheckResult.md)
 - [AssetCountByTimeBucket](doc//AssetCountByTimeBucket.md)
 - [AssetCountByTimeBucketResponseDto](doc//AssetCountByTimeBucketResponseDto.md)
 - [AssetCountByUserIdResponseDto](doc//AssetCountByUserIdResponseDto.md)
 - [AssetFileUploadResponseDto](doc//AssetFileUploadResponseDto.md)
 - [AssetResponseDto](doc//AssetResponseDto.md)
 - [AssetTypeEnum](doc//AssetTypeEnum.md)
 - [AuthDeviceResponseDto](doc//AuthDeviceResponseDto.md)
 - [ChangePasswordDto](doc//ChangePasswordDto.md)
 - [CheckDuplicateAssetDto](doc//CheckDuplicateAssetDto.md)
 - [CheckDuplicateAssetResponseDto](doc//CheckDuplicateAssetResponseDto.md)
 - [CheckExistingAssetsDto](doc//CheckExistingAssetsDto.md)
 - [CheckExistingAssetsResponseDto](doc//CheckExistingAssetsResponseDto.md)
 - [CreateAlbumDto](doc//CreateAlbumDto.md)
 - [CreateAlbumShareLinkDto](doc//CreateAlbumShareLinkDto.md)
 - [CreateAssetsShareLinkDto](doc//CreateAssetsShareLinkDto.md)
 - [CreateProfileImageResponseDto](doc//CreateProfileImageResponseDto.md)
 - [CreateTagDto](doc//CreateTagDto.md)
 - [CreateUserDto](doc//CreateUserDto.md)
 - [CuratedLocationsResponseDto](doc//CuratedLocationsResponseDto.md)
 - [CuratedObjectsResponseDto](doc//CuratedObjectsResponseDto.md)
 - [DeleteAssetDto](doc//DeleteAssetDto.md)
 - [DeleteAssetResponseDto](doc//DeleteAssetResponseDto.md)
 - [DeleteAssetStatus](doc//DeleteAssetStatus.md)
 - [DownloadFilesDto](doc//DownloadFilesDto.md)
 - [EditSharedLinkDto](doc//EditSharedLinkDto.md)
 - [ExifResponseDto](doc//ExifResponseDto.md)
 - [GetAssetByTimeBucketDto](doc//GetAssetByTimeBucketDto.md)
 - [GetAssetCountByTimeBucketDto](doc//GetAssetCountByTimeBucketDto.md)
 - [JobCommand](doc//JobCommand.md)
 - [JobCommandDto](doc//JobCommandDto.md)
 - [JobCountsDto](doc//JobCountsDto.md)
 - [JobName](doc//JobName.md)
 - [JobStatusDto](doc//JobStatusDto.md)
 - [LoginCredentialDto](doc//LoginCredentialDto.md)
 - [LoginResponseDto](doc//LoginResponseDto.md)
 - [LogoutResponseDto](doc//LogoutResponseDto.md)
 - [MapMarkerResponseDto](doc//MapMarkerResponseDto.md)
 - [OAuthCallbackDto](doc//OAuthCallbackDto.md)
 - [OAuthConfigDto](doc//OAuthConfigDto.md)
 - [OAuthConfigResponseDto](doc//OAuthConfigResponseDto.md)
 - [PersonResponseDto](doc//PersonResponseDto.md)
 - [PersonUpdateDto](doc//PersonUpdateDto.md)
 - [QueueStatusDto](doc//QueueStatusDto.md)
 - [RemoveAssetsDto](doc//RemoveAssetsDto.md)
 - [SearchAlbumResponseDto](doc//SearchAlbumResponseDto.md)
 - [SearchAssetDto](doc//SearchAssetDto.md)
 - [SearchAssetResponseDto](doc//SearchAssetResponseDto.md)
 - [SearchConfigResponseDto](doc//SearchConfigResponseDto.md)
 - [SearchExploreItem](doc//SearchExploreItem.md)
 - [SearchExploreResponseDto](doc//SearchExploreResponseDto.md)
 - [SearchFacetCountResponseDto](doc//SearchFacetCountResponseDto.md)
 - [SearchFacetResponseDto](doc//SearchFacetResponseDto.md)
 - [SearchResponseDto](doc//SearchResponseDto.md)
 - [ServerInfoResponseDto](doc//ServerInfoResponseDto.md)
 - [ServerPingResponse](doc//ServerPingResponse.md)
 - [ServerStatsResponseDto](doc//ServerStatsResponseDto.md)
 - [ServerVersionReponseDto](doc//ServerVersionReponseDto.md)
 - [SharedLinkResponseDto](doc//SharedLinkResponseDto.md)
 - [SharedLinkType](doc//SharedLinkType.md)
 - [SignUpDto](doc//SignUpDto.md)
 - [SmartInfoResponseDto](doc//SmartInfoResponseDto.md)
 - [SystemConfigDto](doc//SystemConfigDto.md)
 - [SystemConfigFFmpegDto](doc//SystemConfigFFmpegDto.md)
 - [SystemConfigOAuthDto](doc//SystemConfigOAuthDto.md)
 - [SystemConfigPasswordLoginDto](doc//SystemConfigPasswordLoginDto.md)
 - [SystemConfigStorageTemplateDto](doc//SystemConfigStorageTemplateDto.md)
 - [SystemConfigTemplateStorageOptionDto](doc//SystemConfigTemplateStorageOptionDto.md)
 - [TagResponseDto](doc//TagResponseDto.md)
 - [TagTypeEnum](doc//TagTypeEnum.md)
 - [ThumbnailFormat](doc//ThumbnailFormat.md)
 - [TimeGroupEnum](doc//TimeGroupEnum.md)
 - [UpdateAlbumDto](doc//UpdateAlbumDto.md)
 - [UpdateAssetDto](doc//UpdateAssetDto.md)
 - [UpdateTagDto](doc//UpdateTagDto.md)
 - [UpdateUserDto](doc//UpdateUserDto.md)
 - [UsageByUserDto](doc//UsageByUserDto.md)
 - [UserCountResponseDto](doc//UserCountResponseDto.md)
 - [UserResponseDto](doc//UserResponseDto.md)
 - [ValidateAccessTokenResponseDto](doc//ValidateAccessTokenResponseDto.md)


## Documentation For Authorization


## bearer

- **Type**: HTTP Bearer authentication

## cookie

- **Type**: API key
- **API key parameter name**: immich_access_token
- **Location**: 

## api_key

- **Type**: API key
- **API key parameter name**: x-api-key
- **Location**: HTTP header


## Author



