// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v3.1.5), do not edit directly.
// See also: https://pub.dev/packages/pigeon
#import "messages.g.h"
#import <Flutter/Flutter.h>

#if !__has_feature(objc_arc)
#error File requires ARC to be enabled.
#endif

static NSDictionary<NSString *, id> *wrapResult(id result, FlutterError *error) {
  NSDictionary *errorDict = (NSDictionary *)[NSNull null];
  if (error) {
    errorDict = @{
      @"code" : (error.code ?: [NSNull null]),
      @"message" : (error.message ?: [NSNull null]),
      @"details" : (error.details ?: [NSNull null]),
    };
  }
  return @{
    @"result" : (result ?: [NSNull null]),
    @"error" : errorDict,
  };
}

@interface FLTPathProviderApiCodecReader : FlutterStandardReader
@end
@implementation FLTPathProviderApiCodecReader
@end

@interface FLTPathProviderApiCodecWriter : FlutterStandardWriter
@end
@implementation FLTPathProviderApiCodecWriter
@end

@interface FLTPathProviderApiCodecReaderWriter : FlutterStandardReaderWriter
@end
@implementation FLTPathProviderApiCodecReaderWriter
- (FlutterStandardWriter *)writerWithData:(NSMutableData *)data {
  return [[FLTPathProviderApiCodecWriter alloc] initWithData:data];
}
- (FlutterStandardReader *)readerWithData:(NSData *)data {
  return [[FLTPathProviderApiCodecReader alloc] initWithData:data];
}
@end

NSObject<FlutterMessageCodec> *FLTPathProviderApiGetCodec() {
  static dispatch_once_t sPred = 0;
  static FlutterStandardMessageCodec *sSharedObject = nil;
  dispatch_once(&sPred, ^{
    FLTPathProviderApiCodecReaderWriter *readerWriter =
        [[FLTPathProviderApiCodecReaderWriter alloc] init];
    sSharedObject = [FlutterStandardMessageCodec codecWithReaderWriter:readerWriter];
  });
  return sSharedObject;
}

void FLTPathProviderApiSetup(id<FlutterBinaryMessenger> binaryMessenger,
                             NSObject<FLTPathProviderApi> *api) {
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:@"dev.flutter.pigeon.PathProviderApi.getTemporaryPath"
        binaryMessenger:binaryMessenger
                  codec:FLTPathProviderApiGetCodec()];
    if (api) {
      NSCAssert(
          [api respondsToSelector:@selector(getTemporaryPathWithError:)],
          @"FLTPathProviderApi api (%@) doesn't respond to @selector(getTemporaryPathWithError:)",
          api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        NSString *output = [api getTemporaryPathWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:@"dev.flutter.pigeon.PathProviderApi.getApplicationSupportPath"
        binaryMessenger:binaryMessenger
                  codec:FLTPathProviderApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getApplicationSupportPathWithError:)],
                @"FLTPathProviderApi api (%@) doesn't respond to "
                @"@selector(getApplicationSupportPathWithError:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        NSString *output = [api getApplicationSupportPathWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:@"dev.flutter.pigeon.PathProviderApi.getLibraryPath"
        binaryMessenger:binaryMessenger
                  codec:FLTPathProviderApiGetCodec()];
    if (api) {
      NSCAssert(
          [api respondsToSelector:@selector(getLibraryPathWithError:)],
          @"FLTPathProviderApi api (%@) doesn't respond to @selector(getLibraryPathWithError:)",
          api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        NSString *output = [api getLibraryPathWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:@"dev.flutter.pigeon.PathProviderApi.getApplicationDocumentsPath"
        binaryMessenger:binaryMessenger
                  codec:FLTPathProviderApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getApplicationDocumentsPathWithError:)],
                @"FLTPathProviderApi api (%@) doesn't respond to "
                @"@selector(getApplicationDocumentsPathWithError:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        NSString *output = [api getApplicationDocumentsPathWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
}
