import 'package:flutter/material.dart';

class ImmichLoadingIndicator extends StatelessWidget {
  const ImmichLoadingIndicator({
    Key? key,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      height: 60,
      width: 60,
      decoration: BoxDecoration(
        color: Theme.of(context).primaryColor.withAlpha(200),
        borderRadius: BorderRadius.circular(10),
      ),
      padding: const EdgeInsets.all(15),
      child: const CircularProgressIndicator(color: Colors.white),
    );
  }
}
