# openapi
Immich API

This Dart package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.17.0
- Build package: org.openapitools.codegen.languages.DartClientCodegen

## Requirements

Dart 2.12 or later

## Installation & Usage

### Github
If this Dart package is published to Github, add the following dependency to your pubspec.yaml
```
dependencies:
  openapi:
    git: https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```

### Local
To use the package in your local drive, add the following dependency to your pubspec.yaml
```
dependencies:
  openapi:
    path: /path/to/openapi
```

## Tests

TODO

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```dart
import 'package:openapi/api.dart';

// TODO Configure HTTP Bearer authorization: bearer
// Case 1. Use String Token
//defaultApiClient.getAuthentication<HttpBearerAuth>('bearer').setAccessToken('YOUR_ACCESS_TOKEN');
// Case 2. Use Function which generate token.
// String yourTokenGeneratorFunction() { ... }
//defaultApiClient.getAuthentication<HttpBearerAuth>('bearer').setAccessToken(yourTokenGeneratorFunction);

final api_instance = AlbumApi();
final albumId = albumId_example; // String | 
final addAssetsDto = AddAssetsDto(); // AddAssetsDto | 

try {
    final result = api_instance.addAssetsToAlbum(albumId, addAssetsDto);
    print(result);
} catch (e) {
    print('Exception when calling AlbumApi->addAssetsToAlbum: $e\n');
}

```

## Documentation for API Endpoints

All URIs are relative to */api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AlbumApi* | [**addAssetsToAlbum**](doc//AlbumApi.md#addassetstoalbum) | **PUT** /album/{albumId}/assets | 
*AlbumApi* | [**addUsersToAlbum**](doc//AlbumApi.md#adduserstoalbum) | **PUT** /album/{albumId}/users | 
*AlbumApi* | [**createAlbum**](doc//AlbumApi.md#createalbum) | **POST** /album | 
*AlbumApi* | [**deleteAlbum**](doc//AlbumApi.md#deletealbum) | **DELETE** /album/{albumId} | 
*AlbumApi* | [**getAlbumInfo**](doc//AlbumApi.md#getalbuminfo) | **GET** /album/{albumId} | 
*AlbumApi* | [**getAllAlbums**](doc//AlbumApi.md#getallalbums) | **GET** /album | 
*AlbumApi* | [**removeAssetFromAlbum**](doc//AlbumApi.md#removeassetfromalbum) | **DELETE** /album/{albumId}/assets | 
*AlbumApi* | [**removeUserFromAlbum**](doc//AlbumApi.md#removeuserfromalbum) | **DELETE** /album/{albumId}/user/{userId} | 
*AlbumApi* | [**updateAlbumInfo**](doc//AlbumApi.md#updatealbuminfo) | **PATCH** /album/{albumId} | 
*AssetApi* | [**checkDuplicateAsset**](doc//AssetApi.md#checkduplicateasset) | **POST** /asset/check | 
*AssetApi* | [**deleteAsset**](doc//AssetApi.md#deleteasset) | **DELETE** /asset | 
*AssetApi* | [**downloadFile**](doc//AssetApi.md#downloadfile) | **GET** /asset/download | 
*AssetApi* | [**getAllAssets**](doc//AssetApi.md#getallassets) | **GET** /asset | 
*AssetApi* | [**getAssetById**](doc//AssetApi.md#getassetbyid) | **GET** /asset/assetById/{assetId} | 
*AssetApi* | [**getAssetSearchTerms**](doc//AssetApi.md#getassetsearchterms) | **GET** /asset/searchTerm | 
*AssetApi* | [**getAssetThumbnail**](doc//AssetApi.md#getassetthumbnail) | **GET** /asset/thumbnail/{assetId} | 
*AssetApi* | [**getCuratedLocations**](doc//AssetApi.md#getcuratedlocations) | **GET** /asset/allLocation | 
*AssetApi* | [**getCuratedObjects**](doc//AssetApi.md#getcuratedobjects) | **GET** /asset/allObjects | 
*AssetApi* | [**getUserAssetsByDeviceId**](doc//AssetApi.md#getuserassetsbydeviceid) | **GET** /asset/{deviceId} | 
*AssetApi* | [**searchAsset**](doc//AssetApi.md#searchasset) | **POST** /asset/search | 
*AssetApi* | [**serveFile**](doc//AssetApi.md#servefile) | **GET** /asset/file | 
*AssetApi* | [**uploadFile**](doc//AssetApi.md#uploadfile) | **POST** /asset/upload | 
*AuthenticationApi* | [**adminSignUp**](doc//AuthenticationApi.md#adminsignup) | **POST** /auth/admin-sign-up | 
*AuthenticationApi* | [**login**](doc//AuthenticationApi.md#login) | **POST** /auth/login | 
*AuthenticationApi* | [**logout**](doc//AuthenticationApi.md#logout) | **POST** /auth/logout | 
*AuthenticationApi* | [**validateAccessToken**](doc//AuthenticationApi.md#validateaccesstoken) | **POST** /auth/validateToken | 
*DeviceInfoApi* | [**createDeviceInfo**](doc//DeviceInfoApi.md#createdeviceinfo) | **POST** /device-info | 
*DeviceInfoApi* | [**updateDeviceInfo**](doc//DeviceInfoApi.md#updatedeviceinfo) | **PATCH** /device-info | 
*ServerInfoApi* | [**getServerInfo**](doc//ServerInfoApi.md#getserverinfo) | **GET** /server-info | 
*ServerInfoApi* | [**getServerVersion**](doc//ServerInfoApi.md#getserverversion) | **GET** /server-info/version | 
*ServerInfoApi* | [**pingServer**](doc//ServerInfoApi.md#pingserver) | **GET** /server-info/ping | 
*UserApi* | [**createProfileImage**](doc//UserApi.md#createprofileimage) | **POST** /user/profile-image | 
*UserApi* | [**createUser**](doc//UserApi.md#createuser) | **POST** /user | 
*UserApi* | [**getAllUsers**](doc//UserApi.md#getallusers) | **GET** /user | 
*UserApi* | [**getMyUserInfo**](doc//UserApi.md#getmyuserinfo) | **GET** /user/me | 
*UserApi* | [**getProfileImage**](doc//UserApi.md#getprofileimage) | **GET** /user/profile-image/{userId} | 
*UserApi* | [**getUserById**](doc//UserApi.md#getuserbyid) | **GET** /user/info/{userId} | 
*UserApi* | [**getUserCount**](doc//UserApi.md#getusercount) | **GET** /user/count | 
*UserApi* | [**updateUser**](doc//UserApi.md#updateuser) | **PUT** /user | 


## Documentation For Models

 - [AddAssetsDto](doc//AddAssetsDto.md)
 - [AddUsersDto](doc//AddUsersDto.md)
 - [AdminSignupResponseDto](doc//AdminSignupResponseDto.md)
 - [AlbumResponseDto](doc//AlbumResponseDto.md)
 - [AssetFileUploadResponseDto](doc//AssetFileUploadResponseDto.md)
 - [AssetResponseDto](doc//AssetResponseDto.md)
 - [AssetTypeEnum](doc//AssetTypeEnum.md)
 - [CheckDuplicateAssetDto](doc//CheckDuplicateAssetDto.md)
 - [CheckDuplicateAssetResponseDto](doc//CheckDuplicateAssetResponseDto.md)
 - [CreateAlbumDto](doc//CreateAlbumDto.md)
 - [CreateDeviceInfoDto](doc//CreateDeviceInfoDto.md)
 - [CreateProfileImageResponseDto](doc//CreateProfileImageResponseDto.md)
 - [CreateUserDto](doc//CreateUserDto.md)
 - [CuratedLocationsResponseDto](doc//CuratedLocationsResponseDto.md)
 - [CuratedObjectsResponseDto](doc//CuratedObjectsResponseDto.md)
 - [DeleteAssetDto](doc//DeleteAssetDto.md)
 - [DeleteAssetResponseDto](doc//DeleteAssetResponseDto.md)
 - [DeleteAssetStatus](doc//DeleteAssetStatus.md)
 - [DeviceInfoResponseDto](doc//DeviceInfoResponseDto.md)
 - [DeviceTypeEnum](doc//DeviceTypeEnum.md)
 - [ExifResponseDto](doc//ExifResponseDto.md)
 - [LoginCredentialDto](doc//LoginCredentialDto.md)
 - [LoginResponseDto](doc//LoginResponseDto.md)
 - [LogoutResponseDto](doc//LogoutResponseDto.md)
 - [RemoveAssetsDto](doc//RemoveAssetsDto.md)
 - [SearchAssetDto](doc//SearchAssetDto.md)
 - [ServerInfoResponseDto](doc//ServerInfoResponseDto.md)
 - [ServerPingResponse](doc//ServerPingResponse.md)
 - [ServerVersionReponseDto](doc//ServerVersionReponseDto.md)
 - [SignUpDto](doc//SignUpDto.md)
 - [SmartInfoResponseDto](doc//SmartInfoResponseDto.md)
 - [ThumbnailFormat](doc//ThumbnailFormat.md)
 - [UpdateAlbumDto](doc//UpdateAlbumDto.md)
 - [UpdateDeviceInfoDto](doc//UpdateDeviceInfoDto.md)
 - [UpdateUserDto](doc//UpdateUserDto.md)
 - [UserCountResponseDto](doc//UserCountResponseDto.md)
 - [UserResponseDto](doc//UserResponseDto.md)
 - [ValidateAccessTokenResponseDto](doc//ValidateAccessTokenResponseDto.md)


## Documentation For Authorization


## bearer

- **Type**: HTTP Bearer authentication


## Author



