<p align="center">
  <br/>
  <a href="https://opensource.org/license/agpl-v3"><img src="https://img.shields.io/badge/License-AGPL_v3-blue.svg?color=3F51B5&style=for-the-badge&label=License&logoColor=000000&labelColor=ececec" alt="Licença: AGPLv3"></a>
  <a href="https://discord.immich.app">
    <img src="https://img.shields.io/discord/979116623879368755.svg?label=Discord&logo=Discord&style=for-the-badge&logoColor=000000&labelColor=ececec" alt="Discord"/>
  </a>
  <br/>
  <br/>
</p>

<p align="center">
<img src="../design/immich-logo-stacked-light.svg" width="150" title="Immich Logo">
</p>
<h3 align="center">Solução self-hosted de alta performance para backup de fotos e vídeos</h3>
<br/>
<a href="https://immich.app">
<img src="../design/immich-screenshots.png" title="Captura de tela princial">
</a>
<br/>
<p align="center">

<a href="../README.md">English</a>
<a href="README_ca_ES.md">Català</a>
<a href="README_es_ES.md">Español</a>
<a href="README_fr_FR.md">Français</a>
<a href="README_it_IT.md">Italiano</a>
<a href="README_ja_JP.md">日本語</a>
<a href="README_ko_KR.md">한국어</a>
<a href="README_de_DE.md">Deutsch</a>
<a href="README_nl_NL.md">Nederlands</a>
<a href="README_tr_TR.md">Türkçe</a>
<a href="README_zh_CN.md">简体中文</a>
<a href="README_zh_TW.md">正體中文</a>
<a href="README_uk_UA.md">Українська</a>
<a href="README_ru_RU.md">Русский</a>
<a href="README_sv_SE.md">Svenska</a>
<a href="README_ar_JO.md">العربية</a>
<a href="README_vi_VN.md">Tiếng Việt</a>
<a href="README_th_TH.md">ภาษาไทย</a>

</p>

## Avisos

- ⚠️ Este projeto está sob **desenvolvimento constante**.
- ⚠️ Podem ocorrer bugs e _breaking changes_ (alterações que quebram a
  compatibilidade com versões anteriores).
- ⚠️ **Não use esta solução como a única forma de fazer backup das suas fotos e
  vídeos.**
- ⚠️ Sempre siga o plano
  [3-2-1](https://www.backblaze.com/blog/the-3-2-1-backup-strategy/) de backup
  para as suas mídias preciosas!

> [!NOTE]
> Você pode encontrar a documentação principal, incluindo guias de instalação, em https://immich.app/.

## Links

- [Documentação](https://docs.immich.app)
- [Sobre](https://docs.immich.app/overview/introduction)
- [Instalação](https://docs.immich.app/install/requirements)
- [Roadmap](https://github.com/orgs/immich-app/projects/1)
- [Demonstração](#demonstração)
- [Funcionalidades](#funcionalidades)
- [Traduções](https://docs.immich.app/developer/translations)
- [Diretrizes de Contribuição](https://docs.immich.app/overview/support-the-project)

## Demonstração

Acesse a demonstração [aqui](https://demo.immich.app). No aplicativo para dispositivos móveis, você pode usar
`https://demo.immich.app` no campo `Server Endpoint URL`

### Credenciais de login

| Email           | Senha |
| --------------- | ----- |
| demo@immich.app | demo  |

## Atividades

![Atividades](https://repobeats.axiom.co/api/embed/9e86d9dc3ddd137161f2f6d2e758d7863b1789cb.svg "Imagem de Analytics do Repobeats")

## Funcionalidades

| Funcionalidades                                     | Aplicativo Móvel | Web |
| :-------------------------------------------------- | ---------------- | --- |
| Fazer upload e visualizar fotos e vídeos            | Sim              | Sim |
| Backup automático ao abrir o aplicativo             | Sim              | N/A |
| Prevenir a duplicação de arquivos                   | Sim              | Sim |
| Backup de álbuns específicos                        | Sim              | N/A |
| Baixar fotos e vídeos para o dispositivo            | Sim              | Sim |
| Suporte multi-usuários                              | Sim              | Sim |
| Criação de álbuns e álbuns compartilhados           | Sim              | Sim |
| Barra de rolagem arrastável                         | Sim              | Sim |
| Suporta formatos RAW                                | Sim              | Sim |
| Visualização de metadados (EXIF, mapa)              | Sim              | Sim |
| Pesquisar por metadados, objetos, rostos, e CLIP    | Sim              | Sim |
| Funções administrativas (gerenciamento de usuários) | Não              | Sim |
| Backup em segundo plano                             | Sim              | N/A |
| Rolagem virtual                                     | Sim              | Sim |
| Suporte OAuth                                       | Sim              | Sim |
| Chaves de API                                       | N/A              | Sim |
| Backup e reprodução de LivePhoto/MotionPhoto        | Sim              | Sim |
| Visualização de imagens 360º                        | Não              | Sim |
| Estrutura de armazenamento definida pelo usuário    | Sim              | Sim |
| Compartilhar com o público                          | Sim              | Sim |
| Arquivo e Favoritos                                 | Sim              | Sim |
| Mapa Global                                         | Sim              | Sim |
| Compartilhamento com parceiro                       | Sim              | Sim |
| Reconhecimento facial e agrupamento                 | Sim              | Sim |
| Memórias (x anos atrás)                             | Sim              | Sim |
| Suporte off-line                                    | Sim              | Não |
| Galeria em modo apenas leitura                      | Sim              | Sim |
| Empilhamento de fotos                               | Sim              | Sim |

## Traduções

Leia mais sobre as traduções
[aqui](https://docs.immich.app/developer/translations).

<a href="https://hosted.weblate.org/engage/immich/">
<img src="https://hosted.weblate.org/widget/immich/immich/multi-auto.svg" alt="Status da tradução" />
</a>

## Atividade do repositório

![Activities](https://repobeats.axiom.co/api/embed/9e86d9dc3ddd137161f2f6d2e758d7863b1789cb.svg "Imagem de análise de atividade Repobeats")

## Histórico de estrelas

<a href="https://star-history.com/#immich-app/immich&Date">
 <picture>
   <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=immich-app/immich&type=Date&theme=dark" />
   <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=immich-app/immich&type=Date" />
   <img alt="Gráfico de histórico de estrelas" src="https://api.star-history.com/svg?repos=immich-app/immich&type=Date" width="100%" />
 </picture>
</a>

## Contribuidores

<a href="https://github.com/alextran1502/immich/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=immich-app/immich" width="100%"/>
</a>
