//
// AUTO-GENERATED FILE, DO NOT MODIFY!
//
// @dart=2.18

// ignore_for_file: unused_element, unused_import
// ignore_for_file: always_put_required_named_parameters_first
// ignore_for_file: constant_identifier_names
// ignore_for_file: lines_longer_than_80_chars

part of openapi.api;


class FacesApi {
  FacesApi([ApiClient? apiClient]) : apiClient = apiClient ?? defaultApiClient;

  final ApiClient apiClient;

  /// Create a face
  ///
  /// Create a new face that has not been discovered by facial recognition. The content of the bounding box is considered a face.
  ///
  /// Note: This method returns the HTTP [Response].
  ///
  /// Parameters:
  ///
  /// * [AssetFaceCreateDto] assetFaceCreateDto (required):
  Future<Response> createFaceWithHttpInfo(AssetFaceCreateDto assetFaceCreateDto,) async {
    // ignore: prefer_const_declarations
    final apiPath = r'/faces';

    // ignore: prefer_final_locals
    Object? postBody = assetFaceCreateDto;

    final queryParams = <QueryParam>[];
    final headerParams = <String, String>{};
    final formParams = <String, String>{};

    const contentTypes = <String>['application/json'];


    return apiClient.invokeAPI(
      apiPath,
      'POST',
      queryParams,
      postBody,
      headerParams,
      formParams,
      contentTypes.isEmpty ? null : contentTypes.first,
    );
  }

  /// Create a face
  ///
  /// Create a new face that has not been discovered by facial recognition. The content of the bounding box is considered a face.
  ///
  /// Parameters:
  ///
  /// * [AssetFaceCreateDto] assetFaceCreateDto (required):
  Future<void> createFace(AssetFaceCreateDto assetFaceCreateDto,) async {
    final response = await createFaceWithHttpInfo(assetFaceCreateDto,);
    if (response.statusCode >= HttpStatus.badRequest) {
      throw ApiException(response.statusCode, await _decodeBodyBytes(response));
    }
  }

  /// Delete a face
  ///
  /// Delete a face identified by the id. Optionally can be force deleted.
  ///
  /// Note: This method returns the HTTP [Response].
  ///
  /// Parameters:
  ///
  /// * [String] id (required):
  ///
  /// * [AssetFaceDeleteDto] assetFaceDeleteDto (required):
  Future<Response> deleteFaceWithHttpInfo(String id, AssetFaceDeleteDto assetFaceDeleteDto,) async {
    // ignore: prefer_const_declarations
    final apiPath = r'/faces/{id}'
      .replaceAll('{id}', id);

    // ignore: prefer_final_locals
    Object? postBody = assetFaceDeleteDto;

    final queryParams = <QueryParam>[];
    final headerParams = <String, String>{};
    final formParams = <String, String>{};

    const contentTypes = <String>['application/json'];


    return apiClient.invokeAPI(
      apiPath,
      'DELETE',
      queryParams,
      postBody,
      headerParams,
      formParams,
      contentTypes.isEmpty ? null : contentTypes.first,
    );
  }

  /// Delete a face
  ///
  /// Delete a face identified by the id. Optionally can be force deleted.
  ///
  /// Parameters:
  ///
  /// * [String] id (required):
  ///
  /// * [AssetFaceDeleteDto] assetFaceDeleteDto (required):
  Future<void> deleteFace(String id, AssetFaceDeleteDto assetFaceDeleteDto,) async {
    final response = await deleteFaceWithHttpInfo(id, assetFaceDeleteDto,);
    if (response.statusCode >= HttpStatus.badRequest) {
      throw ApiException(response.statusCode, await _decodeBodyBytes(response));
    }
  }

  /// Retrieve faces for asset
  ///
  /// Retrieve all faces belonging to an asset.
  ///
  /// Note: This method returns the HTTP [Response].
  ///
  /// Parameters:
  ///
  /// * [String] id (required):
  Future<Response> getFacesWithHttpInfo(String id,) async {
    // ignore: prefer_const_declarations
    final apiPath = r'/faces';

    // ignore: prefer_final_locals
    Object? postBody;

    final queryParams = <QueryParam>[];
    final headerParams = <String, String>{};
    final formParams = <String, String>{};

      queryParams.addAll(_queryParams('', 'id', id));

    const contentTypes = <String>[];


    return apiClient.invokeAPI(
      apiPath,
      'GET',
      queryParams,
      postBody,
      headerParams,
      formParams,
      contentTypes.isEmpty ? null : contentTypes.first,
    );
  }

  /// Retrieve faces for asset
  ///
  /// Retrieve all faces belonging to an asset.
  ///
  /// Parameters:
  ///
  /// * [String] id (required):
  Future<List<AssetFaceResponseDto>?> getFaces(String id,) async {
    final response = await getFacesWithHttpInfo(id,);
    if (response.statusCode >= HttpStatus.badRequest) {
      throw ApiException(response.statusCode, await _decodeBodyBytes(response));
    }
    // When a remote server returns no body with a status of 204, we shall not decode it.
    // At the time of writing this, `dart:convert` will throw an "Unexpected end of input"
    // FormatException when trying to decode an empty string.
    if (response.body.isNotEmpty && response.statusCode != HttpStatus.noContent) {
      final responseBody = await _decodeBodyBytes(response);
      return (await apiClient.deserializeAsync(responseBody, 'List<AssetFaceResponseDto>') as List)
        .cast<AssetFaceResponseDto>()
        .toList(growable: false);

    }
    return null;
  }

  /// Re-assign a face to another person
  ///
  /// Re-assign the face provided in the body to the person identified by the id in the path parameter.
  ///
  /// Note: This method returns the HTTP [Response].
  ///
  /// Parameters:
  ///
  /// * [String] id (required):
  ///
  /// * [FaceDto] faceDto (required):
  Future<Response> reassignFacesByIdWithHttpInfo(String id, FaceDto faceDto,) async {
    // ignore: prefer_const_declarations
    final apiPath = r'/faces/{id}'
      .replaceAll('{id}', id);

    // ignore: prefer_final_locals
    Object? postBody = faceDto;

    final queryParams = <QueryParam>[];
    final headerParams = <String, String>{};
    final formParams = <String, String>{};

    const contentTypes = <String>['application/json'];


    return apiClient.invokeAPI(
      apiPath,
      'PUT',
      queryParams,
      postBody,
      headerParams,
      formParams,
      contentTypes.isEmpty ? null : contentTypes.first,
    );
  }

  /// Re-assign a face to another person
  ///
  /// Re-assign the face provided in the body to the person identified by the id in the path parameter.
  ///
  /// Parameters:
  ///
  /// * [String] id (required):
  ///
  /// * [FaceDto] faceDto (required):
  Future<PersonResponseDto?> reassignFacesById(String id, FaceDto faceDto,) async {
    final response = await reassignFacesByIdWithHttpInfo(id, faceDto,);
    if (response.statusCode >= HttpStatus.badRequest) {
      throw ApiException(response.statusCode, await _decodeBodyBytes(response));
    }
    // When a remote server returns no body with a status of 204, we shall not decode it.
    // At the time of writing this, `dart:convert` will throw an "Unexpected end of input"
    // FormatException when trying to decode an empty string.
    if (response.body.isNotEmpty && response.statusCode != HttpStatus.noContent) {
      return await apiClient.deserializeAsync(await _decodeBodyBytes(response), 'PersonResponseDto',) as PersonResponseDto;
    
    }
    return null;
  }
}
