# openapi
Immich API

This Dart package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.4.0
- Generator version: 7.8.0
- Build package: org.openapitools.codegen.languages.DartClientCodegen

## Requirements

Dart 2.12 or later

## Installation & Usage

### Github
If this Dart package is published to Github, add the following dependency to your pubspec.yaml
```
dependencies:
  openapi:
    git: https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```

### Local
To use the package in your local drive, add the following dependency to your pubspec.yaml
```
dependencies:
  openapi:
    path: /path/to/openapi
```

## Tests

TODO

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```dart
import 'package:openapi/api.dart';

// TODO Configure API key authorization: cookie
//defaultApiClient.getAuthentication<ApiKeyAuth>('cookie').apiKey = 'YOUR_API_KEY';
// uncomment below to setup prefix (e.g. Bearer) for API key, if needed
//defaultApiClient.getAuthentication<ApiKeyAuth>('cookie').apiKeyPrefix = 'Bearer';
// TODO Configure API key authorization: api_key
//defaultApiClient.getAuthentication<ApiKeyAuth>('api_key').apiKey = 'YOUR_API_KEY';
// uncomment below to setup prefix (e.g. Bearer) for API key, if needed
//defaultApiClient.getAuthentication<ApiKeyAuth>('api_key').apiKeyPrefix = 'Bearer';
// TODO Configure HTTP Bearer authorization: bearer
// Case 1. Use String Token
//defaultApiClient.getAuthentication<HttpBearerAuth>('bearer').setAccessToken('YOUR_ACCESS_TOKEN');
// Case 2. Use Function which generate token.
// String yourTokenGeneratorFunction() { ... }
//defaultApiClient.getAuthentication<HttpBearerAuth>('bearer').setAccessToken(yourTokenGeneratorFunction);

final api_instance = APIKeysApi();
final aPIKeyCreateDto = APIKeyCreateDto(); // APIKeyCreateDto | 

try {
    final result = api_instance.createApiKey(aPIKeyCreateDto);
    print(result);
} catch (e) {
    print('Exception when calling APIKeysApi->createApiKey: $e\n');
}

```

## Documentation for API Endpoints

All URIs are relative to */api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*APIKeysApi* | [**createApiKey**](doc//APIKeysApi.md#createapikey) | **POST** /api-keys | Create an API key
*APIKeysApi* | [**deleteApiKey**](doc//APIKeysApi.md#deleteapikey) | **DELETE** /api-keys/{id} | Delete an API key
*APIKeysApi* | [**getApiKey**](doc//APIKeysApi.md#getapikey) | **GET** /api-keys/{id} | Retrieve an API key
*APIKeysApi* | [**getApiKeys**](doc//APIKeysApi.md#getapikeys) | **GET** /api-keys | List all API keys
*APIKeysApi* | [**getMyApiKey**](doc//APIKeysApi.md#getmyapikey) | **GET** /api-keys/me | Retrieve the current API key
*APIKeysApi* | [**updateApiKey**](doc//APIKeysApi.md#updateapikey) | **PUT** /api-keys/{id} | Update an API key
*ActivitiesApi* | [**createActivity**](doc//ActivitiesApi.md#createactivity) | **POST** /activities | Create an activity
*ActivitiesApi* | [**deleteActivity**](doc//ActivitiesApi.md#deleteactivity) | **DELETE** /activities/{id} | Delete an activity
*ActivitiesApi* | [**getActivities**](doc//ActivitiesApi.md#getactivities) | **GET** /activities | List all activities
*ActivitiesApi* | [**getActivityStatistics**](doc//ActivitiesApi.md#getactivitystatistics) | **GET** /activities/statistics | Retrieve activity statistics
*AlbumsApi* | [**addAssetsToAlbum**](doc//AlbumsApi.md#addassetstoalbum) | **PUT** /albums/{id}/assets | Add assets to an album
*AlbumsApi* | [**addAssetsToAlbums**](doc//AlbumsApi.md#addassetstoalbums) | **PUT** /albums/assets | Add assets to albums
*AlbumsApi* | [**addUsersToAlbum**](doc//AlbumsApi.md#adduserstoalbum) | **PUT** /albums/{id}/users | Share album with users
*AlbumsApi* | [**createAlbum**](doc//AlbumsApi.md#createalbum) | **POST** /albums | Create an album
*AlbumsApi* | [**deleteAlbum**](doc//AlbumsApi.md#deletealbum) | **DELETE** /albums/{id} | Delete an album
*AlbumsApi* | [**getAlbumInfo**](doc//AlbumsApi.md#getalbuminfo) | **GET** /albums/{id} | Retrieve an album
*AlbumsApi* | [**getAlbumStatistics**](doc//AlbumsApi.md#getalbumstatistics) | **GET** /albums/statistics | Retrieve album statistics
*AlbumsApi* | [**getAllAlbums**](doc//AlbumsApi.md#getallalbums) | **GET** /albums | List all albums
*AlbumsApi* | [**removeAssetFromAlbum**](doc//AlbumsApi.md#removeassetfromalbum) | **DELETE** /albums/{id}/assets | Remove assets from an album
*AlbumsApi* | [**removeUserFromAlbum**](doc//AlbumsApi.md#removeuserfromalbum) | **DELETE** /albums/{id}/user/{userId} | Remove user from album
*AlbumsApi* | [**updateAlbumInfo**](doc//AlbumsApi.md#updatealbuminfo) | **PATCH** /albums/{id} | Update an album
*AlbumsApi* | [**updateAlbumUser**](doc//AlbumsApi.md#updatealbumuser) | **PUT** /albums/{id}/user/{userId} | Update user role
*AssetsApi* | [**checkBulkUpload**](doc//AssetsApi.md#checkbulkupload) | **POST** /assets/bulk-upload-check | Check bulk upload
*AssetsApi* | [**checkExistingAssets**](doc//AssetsApi.md#checkexistingassets) | **POST** /assets/exist | Check existing assets
*AssetsApi* | [**copyAsset**](doc//AssetsApi.md#copyasset) | **PUT** /assets/copy | Copy asset
*AssetsApi* | [**deleteAssetMetadata**](doc//AssetsApi.md#deleteassetmetadata) | **DELETE** /assets/{id}/metadata/{key} | Delete asset metadata by key
*AssetsApi* | [**deleteAssets**](doc//AssetsApi.md#deleteassets) | **DELETE** /assets | Delete assets
*AssetsApi* | [**downloadAsset**](doc//AssetsApi.md#downloadasset) | **GET** /assets/{id}/original | Download original asset
*AssetsApi* | [**getAllUserAssetsByDeviceId**](doc//AssetsApi.md#getalluserassetsbydeviceid) | **GET** /assets/device/{deviceId} | Retrieve assets by device ID
*AssetsApi* | [**getAssetInfo**](doc//AssetsApi.md#getassetinfo) | **GET** /assets/{id} | Retrieve an asset
*AssetsApi* | [**getAssetMetadata**](doc//AssetsApi.md#getassetmetadata) | **GET** /assets/{id}/metadata | Get asset metadata
*AssetsApi* | [**getAssetMetadataByKey**](doc//AssetsApi.md#getassetmetadatabykey) | **GET** /assets/{id}/metadata/{key} | Retrieve asset metadata by key
*AssetsApi* | [**getAssetOcr**](doc//AssetsApi.md#getassetocr) | **GET** /assets/{id}/ocr | Retrieve asset OCR data
*AssetsApi* | [**getAssetStatistics**](doc//AssetsApi.md#getassetstatistics) | **GET** /assets/statistics | Get asset statistics
*AssetsApi* | [**getRandom**](doc//AssetsApi.md#getrandom) | **GET** /assets/random | Get random assets
*AssetsApi* | [**playAssetVideo**](doc//AssetsApi.md#playassetvideo) | **GET** /assets/{id}/video/playback | Play asset video
*AssetsApi* | [**replaceAsset**](doc//AssetsApi.md#replaceasset) | **PUT** /assets/{id}/original | Replace asset
*AssetsApi* | [**runAssetJobs**](doc//AssetsApi.md#runassetjobs) | **POST** /assets/jobs | Run an asset job
*AssetsApi* | [**updateAsset**](doc//AssetsApi.md#updateasset) | **PUT** /assets/{id} | Update an asset
*AssetsApi* | [**updateAssetMetadata**](doc//AssetsApi.md#updateassetmetadata) | **PUT** /assets/{id}/metadata | Update asset metadata
*AssetsApi* | [**updateAssets**](doc//AssetsApi.md#updateassets) | **PUT** /assets | Update assets
*AssetsApi* | [**uploadAsset**](doc//AssetsApi.md#uploadasset) | **POST** /assets | Upload asset
*AssetsApi* | [**viewAsset**](doc//AssetsApi.md#viewasset) | **GET** /assets/{id}/thumbnail | View asset thumbnail
*AuthenticationApi* | [**changePassword**](doc//AuthenticationApi.md#changepassword) | **POST** /auth/change-password | Change password
*AuthenticationApi* | [**changePinCode**](doc//AuthenticationApi.md#changepincode) | **PUT** /auth/pin-code | Change pin code
*AuthenticationApi* | [**finishOAuth**](doc//AuthenticationApi.md#finishoauth) | **POST** /oauth/callback | Finish OAuth
*AuthenticationApi* | [**getAuthStatus**](doc//AuthenticationApi.md#getauthstatus) | **GET** /auth/status | Retrieve auth status
*AuthenticationApi* | [**linkOAuthAccount**](doc//AuthenticationApi.md#linkoauthaccount) | **POST** /oauth/link | Link OAuth account
*AuthenticationApi* | [**lockAuthSession**](doc//AuthenticationApi.md#lockauthsession) | **POST** /auth/session/lock | Lock auth session
*AuthenticationApi* | [**login**](doc//AuthenticationApi.md#login) | **POST** /auth/login | Login
*AuthenticationApi* | [**logout**](doc//AuthenticationApi.md#logout) | **POST** /auth/logout | Logout
*AuthenticationApi* | [**redirectOAuthToMobile**](doc//AuthenticationApi.md#redirectoauthtomobile) | **GET** /oauth/mobile-redirect | Redirect OAuth to mobile
*AuthenticationApi* | [**resetPinCode**](doc//AuthenticationApi.md#resetpincode) | **DELETE** /auth/pin-code | Reset pin code
*AuthenticationApi* | [**setupPinCode**](doc//AuthenticationApi.md#setuppincode) | **POST** /auth/pin-code | Setup pin code
*AuthenticationApi* | [**signUpAdmin**](doc//AuthenticationApi.md#signupadmin) | **POST** /auth/admin-sign-up | Register admin
*AuthenticationApi* | [**startOAuth**](doc//AuthenticationApi.md#startoauth) | **POST** /oauth/authorize | Start OAuth
*AuthenticationApi* | [**unlinkOAuthAccount**](doc//AuthenticationApi.md#unlinkoauthaccount) | **POST** /oauth/unlink | Unlink OAuth account
*AuthenticationApi* | [**unlockAuthSession**](doc//AuthenticationApi.md#unlockauthsession) | **POST** /auth/session/unlock | Unlock auth session
*AuthenticationApi* | [**validateAccessToken**](doc//AuthenticationApi.md#validateaccesstoken) | **POST** /auth/validateToken | Validate access token
*AuthenticationAdminApi* | [**unlinkAllOAuthAccountsAdmin**](doc//AuthenticationAdminApi.md#unlinkalloauthaccountsadmin) | **POST** /admin/auth/unlink-all | Unlink all OAuth accounts
*DeprecatedApi* | [**createPartnerDeprecated**](doc//DeprecatedApi.md#createpartnerdeprecated) | **POST** /partners/{id} | Create a partner
*DeprecatedApi* | [**getAllUserAssetsByDeviceId**](doc//DeprecatedApi.md#getalluserassetsbydeviceid) | **GET** /assets/device/{deviceId} | Retrieve assets by device ID
*DeprecatedApi* | [**getDeltaSync**](doc//DeprecatedApi.md#getdeltasync) | **POST** /sync/delta-sync | Get delta sync for user
*DeprecatedApi* | [**getFullSyncForUser**](doc//DeprecatedApi.md#getfullsyncforuser) | **POST** /sync/full-sync | Get full sync for user
*DeprecatedApi* | [**getQueuesLegacy**](doc//DeprecatedApi.md#getqueueslegacy) | **GET** /jobs | Retrieve queue counts and status
*DeprecatedApi* | [**getRandom**](doc//DeprecatedApi.md#getrandom) | **GET** /assets/random | Get random assets
*DeprecatedApi* | [**replaceAsset**](doc//DeprecatedApi.md#replaceasset) | **PUT** /assets/{id}/original | Replace asset
*DeprecatedApi* | [**runQueueCommandLegacy**](doc//DeprecatedApi.md#runqueuecommandlegacy) | **PUT** /jobs/{name} | Run jobs
*DownloadApi* | [**downloadArchive**](doc//DownloadApi.md#downloadarchive) | **POST** /download/archive | Download asset archive
*DownloadApi* | [**getDownloadInfo**](doc//DownloadApi.md#getdownloadinfo) | **POST** /download/info | Retrieve download information
*DuplicatesApi* | [**deleteDuplicate**](doc//DuplicatesApi.md#deleteduplicate) | **DELETE** /duplicates/{id} | Delete a duplicate
*DuplicatesApi* | [**deleteDuplicates**](doc//DuplicatesApi.md#deleteduplicates) | **DELETE** /duplicates | Delete duplicates
*DuplicatesApi* | [**getAssetDuplicates**](doc//DuplicatesApi.md#getassetduplicates) | **GET** /duplicates | Retrieve duplicates
*FacesApi* | [**createFace**](doc//FacesApi.md#createface) | **POST** /faces | Create a face
*FacesApi* | [**deleteFace**](doc//FacesApi.md#deleteface) | **DELETE** /faces/{id} | Delete a face
*FacesApi* | [**getFaces**](doc//FacesApi.md#getfaces) | **GET** /faces | Retrieve faces for asset
*FacesApi* | [**reassignFacesById**](doc//FacesApi.md#reassignfacesbyid) | **PUT** /faces/{id} | Re-assign a face to another person
*JobsApi* | [**createJob**](doc//JobsApi.md#createjob) | **POST** /jobs | Create a manual job
*JobsApi* | [**getQueuesLegacy**](doc//JobsApi.md#getqueueslegacy) | **GET** /jobs | Retrieve queue counts and status
*JobsApi* | [**runQueueCommandLegacy**](doc//JobsApi.md#runqueuecommandlegacy) | **PUT** /jobs/{name} | Run jobs
*LibrariesApi* | [**createLibrary**](doc//LibrariesApi.md#createlibrary) | **POST** /libraries | Create a library
*LibrariesApi* | [**deleteLibrary**](doc//LibrariesApi.md#deletelibrary) | **DELETE** /libraries/{id} | Delete a library
*LibrariesApi* | [**getAllLibraries**](doc//LibrariesApi.md#getalllibraries) | **GET** /libraries | Retrieve libraries
*LibrariesApi* | [**getLibrary**](doc//LibrariesApi.md#getlibrary) | **GET** /libraries/{id} | Retrieve a library
*LibrariesApi* | [**getLibraryStatistics**](doc//LibrariesApi.md#getlibrarystatistics) | **GET** /libraries/{id}/statistics | Retrieve library statistics
*LibrariesApi* | [**scanLibrary**](doc//LibrariesApi.md#scanlibrary) | **POST** /libraries/{id}/scan | Scan a library
*LibrariesApi* | [**updateLibrary**](doc//LibrariesApi.md#updatelibrary) | **PUT** /libraries/{id} | Update a library
*LibrariesApi* | [**validate**](doc//LibrariesApi.md#validate) | **POST** /libraries/{id}/validate | Validate library settings
*MaintenanceAdminApi* | [**maintenanceLogin**](doc//MaintenanceAdminApi.md#maintenancelogin) | **POST** /admin/maintenance/login | Log into maintenance mode
*MaintenanceAdminApi* | [**setMaintenanceMode**](doc//MaintenanceAdminApi.md#setmaintenancemode) | **POST** /admin/maintenance | Set maintenance mode
*MapApi* | [**getMapMarkers**](doc//MapApi.md#getmapmarkers) | **GET** /map/markers | Retrieve map markers
*MapApi* | [**reverseGeocode**](doc//MapApi.md#reversegeocode) | **GET** /map/reverse-geocode | Reverse geocode coordinates
*MemoriesApi* | [**addMemoryAssets**](doc//MemoriesApi.md#addmemoryassets) | **PUT** /memories/{id}/assets | Add assets to a memory
*MemoriesApi* | [**createMemory**](doc//MemoriesApi.md#creatememory) | **POST** /memories | Create a memory
*MemoriesApi* | [**deleteMemory**](doc//MemoriesApi.md#deletememory) | **DELETE** /memories/{id} | Delete a memory
*MemoriesApi* | [**getMemory**](doc//MemoriesApi.md#getmemory) | **GET** /memories/{id} | Retrieve a memory
*MemoriesApi* | [**memoriesStatistics**](doc//MemoriesApi.md#memoriesstatistics) | **GET** /memories/statistics | Retrieve memories statistics
*MemoriesApi* | [**removeMemoryAssets**](doc//MemoriesApi.md#removememoryassets) | **DELETE** /memories/{id}/assets | Remove assets from a memory
*MemoriesApi* | [**searchMemories**](doc//MemoriesApi.md#searchmemories) | **GET** /memories | Retrieve memories
*MemoriesApi* | [**updateMemory**](doc//MemoriesApi.md#updatememory) | **PUT** /memories/{id} | Update a memory
*NotificationsApi* | [**deleteNotification**](doc//NotificationsApi.md#deletenotification) | **DELETE** /notifications/{id} | Delete a notification
*NotificationsApi* | [**deleteNotifications**](doc//NotificationsApi.md#deletenotifications) | **DELETE** /notifications | Delete notifications
*NotificationsApi* | [**getNotification**](doc//NotificationsApi.md#getnotification) | **GET** /notifications/{id} | Get a notification
*NotificationsApi* | [**getNotifications**](doc//NotificationsApi.md#getnotifications) | **GET** /notifications | Retrieve notifications
*NotificationsApi* | [**updateNotification**](doc//NotificationsApi.md#updatenotification) | **PUT** /notifications/{id} | Update a notification
*NotificationsApi* | [**updateNotifications**](doc//NotificationsApi.md#updatenotifications) | **PUT** /notifications | Update notifications
*NotificationsAdminApi* | [**createNotification**](doc//NotificationsAdminApi.md#createnotification) | **POST** /admin/notifications | Create a notification
*NotificationsAdminApi* | [**getNotificationTemplateAdmin**](doc//NotificationsAdminApi.md#getnotificationtemplateadmin) | **POST** /admin/notifications/templates/{name} | Render email template
*NotificationsAdminApi* | [**sendTestEmailAdmin**](doc//NotificationsAdminApi.md#sendtestemailadmin) | **POST** /admin/notifications/test-email | Send test email
*PartnersApi* | [**createPartner**](doc//PartnersApi.md#createpartner) | **POST** /partners | Create a partner
*PartnersApi* | [**createPartnerDeprecated**](doc//PartnersApi.md#createpartnerdeprecated) | **POST** /partners/{id} | Create a partner
*PartnersApi* | [**getPartners**](doc//PartnersApi.md#getpartners) | **GET** /partners | Retrieve partners
*PartnersApi* | [**removePartner**](doc//PartnersApi.md#removepartner) | **DELETE** /partners/{id} | Remove a partner
*PartnersApi* | [**updatePartner**](doc//PartnersApi.md#updatepartner) | **PUT** /partners/{id} | Update a partner
*PeopleApi* | [**createPerson**](doc//PeopleApi.md#createperson) | **POST** /people | Create a person
*PeopleApi* | [**deletePeople**](doc//PeopleApi.md#deletepeople) | **DELETE** /people | Delete people
*PeopleApi* | [**deletePerson**](doc//PeopleApi.md#deleteperson) | **DELETE** /people/{id} | Delete person
*PeopleApi* | [**getAllPeople**](doc//PeopleApi.md#getallpeople) | **GET** /people | Get all people
*PeopleApi* | [**getPerson**](doc//PeopleApi.md#getperson) | **GET** /people/{id} | Get a person
*PeopleApi* | [**getPersonStatistics**](doc//PeopleApi.md#getpersonstatistics) | **GET** /people/{id}/statistics | Get person statistics
*PeopleApi* | [**getPersonThumbnail**](doc//PeopleApi.md#getpersonthumbnail) | **GET** /people/{id}/thumbnail | Get person thumbnail
*PeopleApi* | [**mergePerson**](doc//PeopleApi.md#mergeperson) | **POST** /people/{id}/merge | Merge people
*PeopleApi* | [**reassignFaces**](doc//PeopleApi.md#reassignfaces) | **PUT** /people/{id}/reassign | Reassign faces
*PeopleApi* | [**updatePeople**](doc//PeopleApi.md#updatepeople) | **PUT** /people | Update people
*PeopleApi* | [**updatePerson**](doc//PeopleApi.md#updateperson) | **PUT** /people/{id} | Update person
*PluginsApi* | [**getPlugin**](doc//PluginsApi.md#getplugin) | **GET** /plugins/{id} | Retrieve a plugin
*PluginsApi* | [**getPlugins**](doc//PluginsApi.md#getplugins) | **GET** /plugins | List all plugins
*QueuesApi* | [**emptyQueue**](doc//QueuesApi.md#emptyqueue) | **DELETE** /queues/{name}/jobs | Empty a queue
*QueuesApi* | [**getQueue**](doc//QueuesApi.md#getqueue) | **GET** /queues/{name} | Retrieve a queue
*QueuesApi* | [**getQueueJobs**](doc//QueuesApi.md#getqueuejobs) | **GET** /queues/{name}/jobs | Retrieve queue jobs
*QueuesApi* | [**getQueues**](doc//QueuesApi.md#getqueues) | **GET** /queues | List all queues
*QueuesApi* | [**updateQueue**](doc//QueuesApi.md#updatequeue) | **PUT** /queues/{name} | Update a queue
*SearchApi* | [**getAssetsByCity**](doc//SearchApi.md#getassetsbycity) | **GET** /search/cities | Retrieve assets by city
*SearchApi* | [**getExploreData**](doc//SearchApi.md#getexploredata) | **GET** /search/explore | Retrieve explore data
*SearchApi* | [**getSearchSuggestions**](doc//SearchApi.md#getsearchsuggestions) | **GET** /search/suggestions | Retrieve search suggestions
*SearchApi* | [**searchAssetStatistics**](doc//SearchApi.md#searchassetstatistics) | **POST** /search/statistics | Search asset statistics
*SearchApi* | [**searchAssets**](doc//SearchApi.md#searchassets) | **POST** /search/metadata | Search assets by metadata
*SearchApi* | [**searchLargeAssets**](doc//SearchApi.md#searchlargeassets) | **POST** /search/large-assets | Search large assets
*SearchApi* | [**searchPerson**](doc//SearchApi.md#searchperson) | **GET** /search/person | Search people
*SearchApi* | [**searchPlaces**](doc//SearchApi.md#searchplaces) | **GET** /search/places | Search places
*SearchApi* | [**searchRandom**](doc//SearchApi.md#searchrandom) | **POST** /search/random | Search random assets
*SearchApi* | [**searchSmart**](doc//SearchApi.md#searchsmart) | **POST** /search/smart | Smart asset search
*ServerApi* | [**deleteServerLicense**](doc//ServerApi.md#deleteserverlicense) | **DELETE** /server/license | Delete server product key
*ServerApi* | [**getAboutInfo**](doc//ServerApi.md#getaboutinfo) | **GET** /server/about | Get server information
*ServerApi* | [**getApkLinks**](doc//ServerApi.md#getapklinks) | **GET** /server/apk-links | Get APK links
*ServerApi* | [**getServerConfig**](doc//ServerApi.md#getserverconfig) | **GET** /server/config | Get config
*ServerApi* | [**getServerFeatures**](doc//ServerApi.md#getserverfeatures) | **GET** /server/features | Get features
*ServerApi* | [**getServerLicense**](doc//ServerApi.md#getserverlicense) | **GET** /server/license | Get product key
*ServerApi* | [**getServerStatistics**](doc//ServerApi.md#getserverstatistics) | **GET** /server/statistics | Get statistics
*ServerApi* | [**getServerVersion**](doc//ServerApi.md#getserverversion) | **GET** /server/version | Get server version
*ServerApi* | [**getStorage**](doc//ServerApi.md#getstorage) | **GET** /server/storage | Get storage
*ServerApi* | [**getSupportedMediaTypes**](doc//ServerApi.md#getsupportedmediatypes) | **GET** /server/media-types | Get supported media types
*ServerApi* | [**getTheme**](doc//ServerApi.md#gettheme) | **GET** /server/theme | Get theme
*ServerApi* | [**getVersionCheck**](doc//ServerApi.md#getversioncheck) | **GET** /server/version-check | Get version check status
*ServerApi* | [**getVersionHistory**](doc//ServerApi.md#getversionhistory) | **GET** /server/version-history | Get version history
*ServerApi* | [**pingServer**](doc//ServerApi.md#pingserver) | **GET** /server/ping | Ping
*ServerApi* | [**setServerLicense**](doc//ServerApi.md#setserverlicense) | **PUT** /server/license | Set server product key
*SessionsApi* | [**createSession**](doc//SessionsApi.md#createsession) | **POST** /sessions | Create a session
*SessionsApi* | [**deleteAllSessions**](doc//SessionsApi.md#deleteallsessions) | **DELETE** /sessions | Delete all sessions
*SessionsApi* | [**deleteSession**](doc//SessionsApi.md#deletesession) | **DELETE** /sessions/{id} | Delete a session
*SessionsApi* | [**getSessions**](doc//SessionsApi.md#getsessions) | **GET** /sessions | Retrieve sessions
*SessionsApi* | [**lockSession**](doc//SessionsApi.md#locksession) | **POST** /sessions/{id}/lock | Lock a session
*SessionsApi* | [**updateSession**](doc//SessionsApi.md#updatesession) | **PUT** /sessions/{id} | Update a session
*SharedLinksApi* | [**addSharedLinkAssets**](doc//SharedLinksApi.md#addsharedlinkassets) | **PUT** /shared-links/{id}/assets | Add assets to a shared link
*SharedLinksApi* | [**createSharedLink**](doc//SharedLinksApi.md#createsharedlink) | **POST** /shared-links | Create a shared link
*SharedLinksApi* | [**getAllSharedLinks**](doc//SharedLinksApi.md#getallsharedlinks) | **GET** /shared-links | Retrieve all shared links
*SharedLinksApi* | [**getMySharedLink**](doc//SharedLinksApi.md#getmysharedlink) | **GET** /shared-links/me | Retrieve current shared link
*SharedLinksApi* | [**getSharedLinkById**](doc//SharedLinksApi.md#getsharedlinkbyid) | **GET** /shared-links/{id} | Retrieve a shared link
*SharedLinksApi* | [**removeSharedLink**](doc//SharedLinksApi.md#removesharedlink) | **DELETE** /shared-links/{id} | Delete a shared link
*SharedLinksApi* | [**removeSharedLinkAssets**](doc//SharedLinksApi.md#removesharedlinkassets) | **DELETE** /shared-links/{id}/assets | Remove assets from a shared link
*SharedLinksApi* | [**updateSharedLink**](doc//SharedLinksApi.md#updatesharedlink) | **PATCH** /shared-links/{id} | Update a shared link
*StacksApi* | [**createStack**](doc//StacksApi.md#createstack) | **POST** /stacks | Create a stack
*StacksApi* | [**deleteStack**](doc//StacksApi.md#deletestack) | **DELETE** /stacks/{id} | Delete a stack
*StacksApi* | [**deleteStacks**](doc//StacksApi.md#deletestacks) | **DELETE** /stacks | Delete stacks
*StacksApi* | [**getStack**](doc//StacksApi.md#getstack) | **GET** /stacks/{id} | Retrieve a stack
*StacksApi* | [**removeAssetFromStack**](doc//StacksApi.md#removeassetfromstack) | **DELETE** /stacks/{id}/assets/{assetId} | Remove an asset from a stack
*StacksApi* | [**searchStacks**](doc//StacksApi.md#searchstacks) | **GET** /stacks | Retrieve stacks
*StacksApi* | [**updateStack**](doc//StacksApi.md#updatestack) | **PUT** /stacks/{id} | Update a stack
*SyncApi* | [**deleteSyncAck**](doc//SyncApi.md#deletesyncack) | **DELETE** /sync/ack | Delete acknowledgements
*SyncApi* | [**getDeltaSync**](doc//SyncApi.md#getdeltasync) | **POST** /sync/delta-sync | Get delta sync for user
*SyncApi* | [**getFullSyncForUser**](doc//SyncApi.md#getfullsyncforuser) | **POST** /sync/full-sync | Get full sync for user
*SyncApi* | [**getSyncAck**](doc//SyncApi.md#getsyncack) | **GET** /sync/ack | Retrieve acknowledgements
*SyncApi* | [**getSyncStream**](doc//SyncApi.md#getsyncstream) | **POST** /sync/stream | Stream sync changes
*SyncApi* | [**sendSyncAck**](doc//SyncApi.md#sendsyncack) | **POST** /sync/ack | Acknowledge changes
*SystemConfigApi* | [**getConfig**](doc//SystemConfigApi.md#getconfig) | **GET** /system-config | Get system configuration
*SystemConfigApi* | [**getConfigDefaults**](doc//SystemConfigApi.md#getconfigdefaults) | **GET** /system-config/defaults | Get system configuration defaults
*SystemConfigApi* | [**getStorageTemplateOptions**](doc//SystemConfigApi.md#getstoragetemplateoptions) | **GET** /system-config/storage-template-options | Get storage template options
*SystemConfigApi* | [**updateConfig**](doc//SystemConfigApi.md#updateconfig) | **PUT** /system-config | Update system configuration
*SystemMetadataApi* | [**getAdminOnboarding**](doc//SystemMetadataApi.md#getadminonboarding) | **GET** /system-metadata/admin-onboarding | Retrieve admin onboarding
*SystemMetadataApi* | [**getReverseGeocodingState**](doc//SystemMetadataApi.md#getreversegeocodingstate) | **GET** /system-metadata/reverse-geocoding-state | Retrieve reverse geocoding state
*SystemMetadataApi* | [**getVersionCheckState**](doc//SystemMetadataApi.md#getversioncheckstate) | **GET** /system-metadata/version-check-state | Retrieve version check state
*SystemMetadataApi* | [**updateAdminOnboarding**](doc//SystemMetadataApi.md#updateadminonboarding) | **POST** /system-metadata/admin-onboarding | Update admin onboarding
*TagsApi* | [**bulkTagAssets**](doc//TagsApi.md#bulktagassets) | **PUT** /tags/assets | Tag assets
*TagsApi* | [**createTag**](doc//TagsApi.md#createtag) | **POST** /tags | Create a tag
*TagsApi* | [**deleteTag**](doc//TagsApi.md#deletetag) | **DELETE** /tags/{id} | Delete a tag
*TagsApi* | [**getAllTags**](doc//TagsApi.md#getalltags) | **GET** /tags | Retrieve tags
*TagsApi* | [**getTagById**](doc//TagsApi.md#gettagbyid) | **GET** /tags/{id} | Retrieve a tag
*TagsApi* | [**tagAssets**](doc//TagsApi.md#tagassets) | **PUT** /tags/{id}/assets | Tag assets
*TagsApi* | [**untagAssets**](doc//TagsApi.md#untagassets) | **DELETE** /tags/{id}/assets | Untag assets
*TagsApi* | [**updateTag**](doc//TagsApi.md#updatetag) | **PUT** /tags/{id} | Update a tag
*TagsApi* | [**upsertTags**](doc//TagsApi.md#upserttags) | **PUT** /tags | Upsert tags
*TimelineApi* | [**getTimeBucket**](doc//TimelineApi.md#gettimebucket) | **GET** /timeline/bucket | Get time bucket
*TimelineApi* | [**getTimeBuckets**](doc//TimelineApi.md#gettimebuckets) | **GET** /timeline/buckets | Get time buckets
*TrashApi* | [**emptyTrash**](doc//TrashApi.md#emptytrash) | **POST** /trash/empty | Empty trash
*TrashApi* | [**restoreAssets**](doc//TrashApi.md#restoreassets) | **POST** /trash/restore/assets | Restore assets
*TrashApi* | [**restoreTrash**](doc//TrashApi.md#restoretrash) | **POST** /trash/restore | Restore trash
*UsersApi* | [**createProfileImage**](doc//UsersApi.md#createprofileimage) | **POST** /users/profile-image | Create user profile image
*UsersApi* | [**deleteProfileImage**](doc//UsersApi.md#deleteprofileimage) | **DELETE** /users/profile-image | Delete user profile image
*UsersApi* | [**deleteUserLicense**](doc//UsersApi.md#deleteuserlicense) | **DELETE** /users/me/license | Delete user product key
*UsersApi* | [**deleteUserOnboarding**](doc//UsersApi.md#deleteuseronboarding) | **DELETE** /users/me/onboarding | Delete user onboarding
*UsersApi* | [**getMyPreferences**](doc//UsersApi.md#getmypreferences) | **GET** /users/me/preferences | Get my preferences
*UsersApi* | [**getMyUser**](doc//UsersApi.md#getmyuser) | **GET** /users/me | Get current user
*UsersApi* | [**getProfileImage**](doc//UsersApi.md#getprofileimage) | **GET** /users/{id}/profile-image | Retrieve user profile image
*UsersApi* | [**getUser**](doc//UsersApi.md#getuser) | **GET** /users/{id} | Retrieve a user
*UsersApi* | [**getUserLicense**](doc//UsersApi.md#getuserlicense) | **GET** /users/me/license | Retrieve user product key
*UsersApi* | [**getUserOnboarding**](doc//UsersApi.md#getuseronboarding) | **GET** /users/me/onboarding | Retrieve user onboarding
*UsersApi* | [**searchUsers**](doc//UsersApi.md#searchusers) | **GET** /users | Get all users
*UsersApi* | [**setUserLicense**](doc//UsersApi.md#setuserlicense) | **PUT** /users/me/license | Set user product key
*UsersApi* | [**setUserOnboarding**](doc//UsersApi.md#setuseronboarding) | **PUT** /users/me/onboarding | Update user onboarding
*UsersApi* | [**updateMyPreferences**](doc//UsersApi.md#updatemypreferences) | **PUT** /users/me/preferences | Update my preferences
*UsersApi* | [**updateMyUser**](doc//UsersApi.md#updatemyuser) | **PUT** /users/me | Update current user
*UsersAdminApi* | [**createUserAdmin**](doc//UsersAdminApi.md#createuseradmin) | **POST** /admin/users | Create a user
*UsersAdminApi* | [**deleteUserAdmin**](doc//UsersAdminApi.md#deleteuseradmin) | **DELETE** /admin/users/{id} | Delete a user
*UsersAdminApi* | [**getUserAdmin**](doc//UsersAdminApi.md#getuseradmin) | **GET** /admin/users/{id} | Retrieve a user
*UsersAdminApi* | [**getUserPreferencesAdmin**](doc//UsersAdminApi.md#getuserpreferencesadmin) | **GET** /admin/users/{id}/preferences | Retrieve user preferences
*UsersAdminApi* | [**getUserSessionsAdmin**](doc//UsersAdminApi.md#getusersessionsadmin) | **GET** /admin/users/{id}/sessions | Retrieve user sessions
*UsersAdminApi* | [**getUserStatisticsAdmin**](doc//UsersAdminApi.md#getuserstatisticsadmin) | **GET** /admin/users/{id}/statistics | Retrieve user statistics
*UsersAdminApi* | [**restoreUserAdmin**](doc//UsersAdminApi.md#restoreuseradmin) | **POST** /admin/users/{id}/restore | Restore a deleted user
*UsersAdminApi* | [**searchUsersAdmin**](doc//UsersAdminApi.md#searchusersadmin) | **GET** /admin/users | Search users
*UsersAdminApi* | [**updateUserAdmin**](doc//UsersAdminApi.md#updateuseradmin) | **PUT** /admin/users/{id} | Update a user
*UsersAdminApi* | [**updateUserPreferencesAdmin**](doc//UsersAdminApi.md#updateuserpreferencesadmin) | **PUT** /admin/users/{id}/preferences | Update user preferences
*ViewsApi* | [**getAssetsByOriginalPath**](doc//ViewsApi.md#getassetsbyoriginalpath) | **GET** /view/folder | Retrieve assets by original path
*ViewsApi* | [**getUniqueOriginalPaths**](doc//ViewsApi.md#getuniqueoriginalpaths) | **GET** /view/folder/unique-paths | Retrieve unique paths
*WorkflowsApi* | [**createWorkflow**](doc//WorkflowsApi.md#createworkflow) | **POST** /workflows | Create a workflow
*WorkflowsApi* | [**deleteWorkflow**](doc//WorkflowsApi.md#deleteworkflow) | **DELETE** /workflows/{id} | Delete a workflow
*WorkflowsApi* | [**getWorkflow**](doc//WorkflowsApi.md#getworkflow) | **GET** /workflows/{id} | Retrieve a workflow
*WorkflowsApi* | [**getWorkflows**](doc//WorkflowsApi.md#getworkflows) | **GET** /workflows | List all workflows
*WorkflowsApi* | [**updateWorkflow**](doc//WorkflowsApi.md#updateworkflow) | **PUT** /workflows/{id} | Update a workflow


## Documentation For Models

 - [APIKeyCreateDto](doc//APIKeyCreateDto.md)
 - [APIKeyCreateResponseDto](doc//APIKeyCreateResponseDto.md)
 - [APIKeyResponseDto](doc//APIKeyResponseDto.md)
 - [APIKeyUpdateDto](doc//APIKeyUpdateDto.md)
 - [ActivityCreateDto](doc//ActivityCreateDto.md)
 - [ActivityResponseDto](doc//ActivityResponseDto.md)
 - [ActivityStatisticsResponseDto](doc//ActivityStatisticsResponseDto.md)
 - [AddUsersDto](doc//AddUsersDto.md)
 - [AdminOnboardingUpdateDto](doc//AdminOnboardingUpdateDto.md)
 - [AlbumResponseDto](doc//AlbumResponseDto.md)
 - [AlbumStatisticsResponseDto](doc//AlbumStatisticsResponseDto.md)
 - [AlbumUserAddDto](doc//AlbumUserAddDto.md)
 - [AlbumUserCreateDto](doc//AlbumUserCreateDto.md)
 - [AlbumUserResponseDto](doc//AlbumUserResponseDto.md)
 - [AlbumUserRole](doc//AlbumUserRole.md)
 - [AlbumsAddAssetsDto](doc//AlbumsAddAssetsDto.md)
 - [AlbumsAddAssetsResponseDto](doc//AlbumsAddAssetsResponseDto.md)
 - [AlbumsResponse](doc//AlbumsResponse.md)
 - [AlbumsUpdate](doc//AlbumsUpdate.md)
 - [AssetBulkDeleteDto](doc//AssetBulkDeleteDto.md)
 - [AssetBulkUpdateDto](doc//AssetBulkUpdateDto.md)
 - [AssetBulkUploadCheckDto](doc//AssetBulkUploadCheckDto.md)
 - [AssetBulkUploadCheckItem](doc//AssetBulkUploadCheckItem.md)
 - [AssetBulkUploadCheckResponseDto](doc//AssetBulkUploadCheckResponseDto.md)
 - [AssetBulkUploadCheckResult](doc//AssetBulkUploadCheckResult.md)
 - [AssetCopyDto](doc//AssetCopyDto.md)
 - [AssetDeltaSyncDto](doc//AssetDeltaSyncDto.md)
 - [AssetDeltaSyncResponseDto](doc//AssetDeltaSyncResponseDto.md)
 - [AssetFaceCreateDto](doc//AssetFaceCreateDto.md)
 - [AssetFaceDeleteDto](doc//AssetFaceDeleteDto.md)
 - [AssetFaceResponseDto](doc//AssetFaceResponseDto.md)
 - [AssetFaceUpdateDto](doc//AssetFaceUpdateDto.md)
 - [AssetFaceUpdateItem](doc//AssetFaceUpdateItem.md)
 - [AssetFaceWithoutPersonResponseDto](doc//AssetFaceWithoutPersonResponseDto.md)
 - [AssetFullSyncDto](doc//AssetFullSyncDto.md)
 - [AssetIdsDto](doc//AssetIdsDto.md)
 - [AssetIdsResponseDto](doc//AssetIdsResponseDto.md)
 - [AssetJobName](doc//AssetJobName.md)
 - [AssetJobsDto](doc//AssetJobsDto.md)
 - [AssetMediaResponseDto](doc//AssetMediaResponseDto.md)
 - [AssetMediaSize](doc//AssetMediaSize.md)
 - [AssetMediaStatus](doc//AssetMediaStatus.md)
 - [AssetMetadataKey](doc//AssetMetadataKey.md)
 - [AssetMetadataResponseDto](doc//AssetMetadataResponseDto.md)
 - [AssetMetadataUpsertDto](doc//AssetMetadataUpsertDto.md)
 - [AssetMetadataUpsertItemDto](doc//AssetMetadataUpsertItemDto.md)
 - [AssetOcrResponseDto](doc//AssetOcrResponseDto.md)
 - [AssetOrder](doc//AssetOrder.md)
 - [AssetResponseDto](doc//AssetResponseDto.md)
 - [AssetStackResponseDto](doc//AssetStackResponseDto.md)
 - [AssetStatsResponseDto](doc//AssetStatsResponseDto.md)
 - [AssetTypeEnum](doc//AssetTypeEnum.md)
 - [AssetVisibility](doc//AssetVisibility.md)
 - [AudioCodec](doc//AudioCodec.md)
 - [AuthStatusResponseDto](doc//AuthStatusResponseDto.md)
 - [AvatarUpdate](doc//AvatarUpdate.md)
 - [BulkIdErrorReason](doc//BulkIdErrorReason.md)
 - [BulkIdResponseDto](doc//BulkIdResponseDto.md)
 - [BulkIdsDto](doc//BulkIdsDto.md)
 - [CLIPConfig](doc//CLIPConfig.md)
 - [CQMode](doc//CQMode.md)
 - [CastResponse](doc//CastResponse.md)
 - [CastUpdate](doc//CastUpdate.md)
 - [ChangePasswordDto](doc//ChangePasswordDto.md)
 - [CheckExistingAssetsDto](doc//CheckExistingAssetsDto.md)
 - [CheckExistingAssetsResponseDto](doc//CheckExistingAssetsResponseDto.md)
 - [Colorspace](doc//Colorspace.md)
 - [ContributorCountResponseDto](doc//ContributorCountResponseDto.md)
 - [CreateAlbumDto](doc//CreateAlbumDto.md)
 - [CreateLibraryDto](doc//CreateLibraryDto.md)
 - [CreateProfileImageResponseDto](doc//CreateProfileImageResponseDto.md)
 - [DatabaseBackupConfig](doc//DatabaseBackupConfig.md)
 - [DownloadArchiveInfo](doc//DownloadArchiveInfo.md)
 - [DownloadInfoDto](doc//DownloadInfoDto.md)
 - [DownloadResponse](doc//DownloadResponse.md)
 - [DownloadResponseDto](doc//DownloadResponseDto.md)
 - [DownloadUpdate](doc//DownloadUpdate.md)
 - [DuplicateDetectionConfig](doc//DuplicateDetectionConfig.md)
 - [DuplicateResponseDto](doc//DuplicateResponseDto.md)
 - [EmailNotificationsResponse](doc//EmailNotificationsResponse.md)
 - [EmailNotificationsUpdate](doc//EmailNotificationsUpdate.md)
 - [ExifResponseDto](doc//ExifResponseDto.md)
 - [FaceDto](doc//FaceDto.md)
 - [FacialRecognitionConfig](doc//FacialRecognitionConfig.md)
 - [FoldersResponse](doc//FoldersResponse.md)
 - [FoldersUpdate](doc//FoldersUpdate.md)
 - [ImageFormat](doc//ImageFormat.md)
 - [JobCreateDto](doc//JobCreateDto.md)
 - [JobName](doc//JobName.md)
 - [JobSettingsDto](doc//JobSettingsDto.md)
 - [LibraryResponseDto](doc//LibraryResponseDto.md)
 - [LibraryStatsResponseDto](doc//LibraryStatsResponseDto.md)
 - [LicenseKeyDto](doc//LicenseKeyDto.md)
 - [LicenseResponseDto](doc//LicenseResponseDto.md)
 - [LogLevel](doc//LogLevel.md)
 - [LoginCredentialDto](doc//LoginCredentialDto.md)
 - [LoginResponseDto](doc//LoginResponseDto.md)
 - [LogoutResponseDto](doc//LogoutResponseDto.md)
 - [MachineLearningAvailabilityChecksDto](doc//MachineLearningAvailabilityChecksDto.md)
 - [MaintenanceAction](doc//MaintenanceAction.md)
 - [MaintenanceAuthDto](doc//MaintenanceAuthDto.md)
 - [MaintenanceLoginDto](doc//MaintenanceLoginDto.md)
 - [ManualJobName](doc//ManualJobName.md)
 - [MapMarkerResponseDto](doc//MapMarkerResponseDto.md)
 - [MapReverseGeocodeResponseDto](doc//MapReverseGeocodeResponseDto.md)
 - [MemoriesResponse](doc//MemoriesResponse.md)
 - [MemoriesUpdate](doc//MemoriesUpdate.md)
 - [MemoryCreateDto](doc//MemoryCreateDto.md)
 - [MemoryResponseDto](doc//MemoryResponseDto.md)
 - [MemorySearchOrder](doc//MemorySearchOrder.md)
 - [MemoryStatisticsResponseDto](doc//MemoryStatisticsResponseDto.md)
 - [MemoryType](doc//MemoryType.md)
 - [MemoryUpdateDto](doc//MemoryUpdateDto.md)
 - [MergePersonDto](doc//MergePersonDto.md)
 - [MetadataSearchDto](doc//MetadataSearchDto.md)
 - [NotificationCreateDto](doc//NotificationCreateDto.md)
 - [NotificationDeleteAllDto](doc//NotificationDeleteAllDto.md)
 - [NotificationDto](doc//NotificationDto.md)
 - [NotificationLevel](doc//NotificationLevel.md)
 - [NotificationType](doc//NotificationType.md)
 - [NotificationUpdateAllDto](doc//NotificationUpdateAllDto.md)
 - [NotificationUpdateDto](doc//NotificationUpdateDto.md)
 - [OAuthAuthorizeResponseDto](doc//OAuthAuthorizeResponseDto.md)
 - [OAuthCallbackDto](doc//OAuthCallbackDto.md)
 - [OAuthConfigDto](doc//OAuthConfigDto.md)
 - [OAuthTokenEndpointAuthMethod](doc//OAuthTokenEndpointAuthMethod.md)
 - [OcrConfig](doc//OcrConfig.md)
 - [OnThisDayDto](doc//OnThisDayDto.md)
 - [OnboardingDto](doc//OnboardingDto.md)
 - [OnboardingResponseDto](doc//OnboardingResponseDto.md)
 - [PartnerCreateDto](doc//PartnerCreateDto.md)
 - [PartnerDirection](doc//PartnerDirection.md)
 - [PartnerResponseDto](doc//PartnerResponseDto.md)
 - [PartnerUpdateDto](doc//PartnerUpdateDto.md)
 - [PeopleResponse](doc//PeopleResponse.md)
 - [PeopleResponseDto](doc//PeopleResponseDto.md)
 - [PeopleUpdate](doc//PeopleUpdate.md)
 - [PeopleUpdateDto](doc//PeopleUpdateDto.md)
 - [PeopleUpdateItem](doc//PeopleUpdateItem.md)
 - [Permission](doc//Permission.md)
 - [PersonCreateDto](doc//PersonCreateDto.md)
 - [PersonResponseDto](doc//PersonResponseDto.md)
 - [PersonStatisticsResponseDto](doc//PersonStatisticsResponseDto.md)
 - [PersonUpdateDto](doc//PersonUpdateDto.md)
 - [PersonWithFacesResponseDto](doc//PersonWithFacesResponseDto.md)
 - [PinCodeChangeDto](doc//PinCodeChangeDto.md)
 - [PinCodeResetDto](doc//PinCodeResetDto.md)
 - [PinCodeSetupDto](doc//PinCodeSetupDto.md)
 - [PlacesResponseDto](doc//PlacesResponseDto.md)
 - [PluginActionResponseDto](doc//PluginActionResponseDto.md)
 - [PluginContext](doc//PluginContext.md)
 - [PluginFilterResponseDto](doc//PluginFilterResponseDto.md)
 - [PluginResponseDto](doc//PluginResponseDto.md)
 - [PluginTriggerType](doc//PluginTriggerType.md)
 - [PurchaseResponse](doc//PurchaseResponse.md)
 - [PurchaseUpdate](doc//PurchaseUpdate.md)
 - [QueueCommand](doc//QueueCommand.md)
 - [QueueCommandDto](doc//QueueCommandDto.md)
 - [QueueDeleteDto](doc//QueueDeleteDto.md)
 - [QueueJobResponseDto](doc//QueueJobResponseDto.md)
 - [QueueJobStatus](doc//QueueJobStatus.md)
 - [QueueName](doc//QueueName.md)
 - [QueueResponseDto](doc//QueueResponseDto.md)
 - [QueueResponseLegacyDto](doc//QueueResponseLegacyDto.md)
 - [QueueStatisticsDto](doc//QueueStatisticsDto.md)
 - [QueueStatusLegacyDto](doc//QueueStatusLegacyDto.md)
 - [QueueUpdateDto](doc//QueueUpdateDto.md)
 - [QueuesResponseLegacyDto](doc//QueuesResponseLegacyDto.md)
 - [RandomSearchDto](doc//RandomSearchDto.md)
 - [RatingsResponse](doc//RatingsResponse.md)
 - [RatingsUpdate](doc//RatingsUpdate.md)
 - [ReactionLevel](doc//ReactionLevel.md)
 - [ReactionType](doc//ReactionType.md)
 - [ReverseGeocodingStateResponseDto](doc//ReverseGeocodingStateResponseDto.md)
 - [SearchAlbumResponseDto](doc//SearchAlbumResponseDto.md)
 - [SearchAssetResponseDto](doc//SearchAssetResponseDto.md)
 - [SearchExploreItem](doc//SearchExploreItem.md)
 - [SearchExploreResponseDto](doc//SearchExploreResponseDto.md)
 - [SearchFacetCountResponseDto](doc//SearchFacetCountResponseDto.md)
 - [SearchFacetResponseDto](doc//SearchFacetResponseDto.md)
 - [SearchResponseDto](doc//SearchResponseDto.md)
 - [SearchStatisticsResponseDto](doc//SearchStatisticsResponseDto.md)
 - [SearchSuggestionType](doc//SearchSuggestionType.md)
 - [ServerAboutResponseDto](doc//ServerAboutResponseDto.md)
 - [ServerApkLinksDto](doc//ServerApkLinksDto.md)
 - [ServerConfigDto](doc//ServerConfigDto.md)
 - [ServerFeaturesDto](doc//ServerFeaturesDto.md)
 - [ServerMediaTypesResponseDto](doc//ServerMediaTypesResponseDto.md)
 - [ServerPingResponse](doc//ServerPingResponse.md)
 - [ServerStatsResponseDto](doc//ServerStatsResponseDto.md)
 - [ServerStorageResponseDto](doc//ServerStorageResponseDto.md)
 - [ServerThemeDto](doc//ServerThemeDto.md)
 - [ServerVersionHistoryResponseDto](doc//ServerVersionHistoryResponseDto.md)
 - [ServerVersionResponseDto](doc//ServerVersionResponseDto.md)
 - [SessionCreateDto](doc//SessionCreateDto.md)
 - [SessionCreateResponseDto](doc//SessionCreateResponseDto.md)
 - [SessionResponseDto](doc//SessionResponseDto.md)
 - [SessionUnlockDto](doc//SessionUnlockDto.md)
 - [SessionUpdateDto](doc//SessionUpdateDto.md)
 - [SetMaintenanceModeDto](doc//SetMaintenanceModeDto.md)
 - [SharedLinkCreateDto](doc//SharedLinkCreateDto.md)
 - [SharedLinkEditDto](doc//SharedLinkEditDto.md)
 - [SharedLinkResponseDto](doc//SharedLinkResponseDto.md)
 - [SharedLinkType](doc//SharedLinkType.md)
 - [SharedLinksResponse](doc//SharedLinksResponse.md)
 - [SharedLinksUpdate](doc//SharedLinksUpdate.md)
 - [SignUpDto](doc//SignUpDto.md)
 - [SmartSearchDto](doc//SmartSearchDto.md)
 - [SourceType](doc//SourceType.md)
 - [StackCreateDto](doc//StackCreateDto.md)
 - [StackResponseDto](doc//StackResponseDto.md)
 - [StackUpdateDto](doc//StackUpdateDto.md)
 - [StatisticsSearchDto](doc//StatisticsSearchDto.md)
 - [SyncAckDeleteDto](doc//SyncAckDeleteDto.md)
 - [SyncAckDto](doc//SyncAckDto.md)
 - [SyncAckSetDto](doc//SyncAckSetDto.md)
 - [SyncAlbumDeleteV1](doc//SyncAlbumDeleteV1.md)
 - [SyncAlbumToAssetDeleteV1](doc//SyncAlbumToAssetDeleteV1.md)
 - [SyncAlbumToAssetV1](doc//SyncAlbumToAssetV1.md)
 - [SyncAlbumUserDeleteV1](doc//SyncAlbumUserDeleteV1.md)
 - [SyncAlbumUserV1](doc//SyncAlbumUserV1.md)
 - [SyncAlbumV1](doc//SyncAlbumV1.md)
 - [SyncAssetDeleteV1](doc//SyncAssetDeleteV1.md)
 - [SyncAssetExifV1](doc//SyncAssetExifV1.md)
 - [SyncAssetFaceDeleteV1](doc//SyncAssetFaceDeleteV1.md)
 - [SyncAssetFaceV1](doc//SyncAssetFaceV1.md)
 - [SyncAssetMetadataDeleteV1](doc//SyncAssetMetadataDeleteV1.md)
 - [SyncAssetMetadataV1](doc//SyncAssetMetadataV1.md)
 - [SyncAssetV1](doc//SyncAssetV1.md)
 - [SyncAuthUserV1](doc//SyncAuthUserV1.md)
 - [SyncEntityType](doc//SyncEntityType.md)
 - [SyncMemoryAssetDeleteV1](doc//SyncMemoryAssetDeleteV1.md)
 - [SyncMemoryAssetV1](doc//SyncMemoryAssetV1.md)
 - [SyncMemoryDeleteV1](doc//SyncMemoryDeleteV1.md)
 - [SyncMemoryV1](doc//SyncMemoryV1.md)
 - [SyncPartnerDeleteV1](doc//SyncPartnerDeleteV1.md)
 - [SyncPartnerV1](doc//SyncPartnerV1.md)
 - [SyncPersonDeleteV1](doc//SyncPersonDeleteV1.md)
 - [SyncPersonV1](doc//SyncPersonV1.md)
 - [SyncRequestType](doc//SyncRequestType.md)
 - [SyncStackDeleteV1](doc//SyncStackDeleteV1.md)
 - [SyncStackV1](doc//SyncStackV1.md)
 - [SyncStreamDto](doc//SyncStreamDto.md)
 - [SyncUserDeleteV1](doc//SyncUserDeleteV1.md)
 - [SyncUserMetadataDeleteV1](doc//SyncUserMetadataDeleteV1.md)
 - [SyncUserMetadataV1](doc//SyncUserMetadataV1.md)
 - [SyncUserV1](doc//SyncUserV1.md)
 - [SystemConfigBackupsDto](doc//SystemConfigBackupsDto.md)
 - [SystemConfigDto](doc//SystemConfigDto.md)
 - [SystemConfigFFmpegDto](doc//SystemConfigFFmpegDto.md)
 - [SystemConfigFacesDto](doc//SystemConfigFacesDto.md)
 - [SystemConfigGeneratedFullsizeImageDto](doc//SystemConfigGeneratedFullsizeImageDto.md)
 - [SystemConfigGeneratedImageDto](doc//SystemConfigGeneratedImageDto.md)
 - [SystemConfigImageDto](doc//SystemConfigImageDto.md)
 - [SystemConfigJobDto](doc//SystemConfigJobDto.md)
 - [SystemConfigLibraryDto](doc//SystemConfigLibraryDto.md)
 - [SystemConfigLibraryScanDto](doc//SystemConfigLibraryScanDto.md)
 - [SystemConfigLibraryWatchDto](doc//SystemConfigLibraryWatchDto.md)
 - [SystemConfigLoggingDto](doc//SystemConfigLoggingDto.md)
 - [SystemConfigMachineLearningDto](doc//SystemConfigMachineLearningDto.md)
 - [SystemConfigMapDto](doc//SystemConfigMapDto.md)
 - [SystemConfigMetadataDto](doc//SystemConfigMetadataDto.md)
 - [SystemConfigNewVersionCheckDto](doc//SystemConfigNewVersionCheckDto.md)
 - [SystemConfigNightlyTasksDto](doc//SystemConfigNightlyTasksDto.md)
 - [SystemConfigNotificationsDto](doc//SystemConfigNotificationsDto.md)
 - [SystemConfigOAuthDto](doc//SystemConfigOAuthDto.md)
 - [SystemConfigPasswordLoginDto](doc//SystemConfigPasswordLoginDto.md)
 - [SystemConfigReverseGeocodingDto](doc//SystemConfigReverseGeocodingDto.md)
 - [SystemConfigServerDto](doc//SystemConfigServerDto.md)
 - [SystemConfigSmtpDto](doc//SystemConfigSmtpDto.md)
 - [SystemConfigSmtpTransportDto](doc//SystemConfigSmtpTransportDto.md)
 - [SystemConfigStorageTemplateDto](doc//SystemConfigStorageTemplateDto.md)
 - [SystemConfigTemplateEmailsDto](doc//SystemConfigTemplateEmailsDto.md)
 - [SystemConfigTemplateStorageOptionDto](doc//SystemConfigTemplateStorageOptionDto.md)
 - [SystemConfigTemplatesDto](doc//SystemConfigTemplatesDto.md)
 - [SystemConfigThemeDto](doc//SystemConfigThemeDto.md)
 - [SystemConfigTrashDto](doc//SystemConfigTrashDto.md)
 - [SystemConfigUserDto](doc//SystemConfigUserDto.md)
 - [TagBulkAssetsDto](doc//TagBulkAssetsDto.md)
 - [TagBulkAssetsResponseDto](doc//TagBulkAssetsResponseDto.md)
 - [TagCreateDto](doc//TagCreateDto.md)
 - [TagResponseDto](doc//TagResponseDto.md)
 - [TagUpdateDto](doc//TagUpdateDto.md)
 - [TagUpsertDto](doc//TagUpsertDto.md)
 - [TagsResponse](doc//TagsResponse.md)
 - [TagsUpdate](doc//TagsUpdate.md)
 - [TemplateDto](doc//TemplateDto.md)
 - [TemplateResponseDto](doc//TemplateResponseDto.md)
 - [TestEmailResponseDto](doc//TestEmailResponseDto.md)
 - [TimeBucketAssetResponseDto](doc//TimeBucketAssetResponseDto.md)
 - [TimeBucketsResponseDto](doc//TimeBucketsResponseDto.md)
 - [ToneMapping](doc//ToneMapping.md)
 - [TranscodeHWAccel](doc//TranscodeHWAccel.md)
 - [TranscodePolicy](doc//TranscodePolicy.md)
 - [TrashResponseDto](doc//TrashResponseDto.md)
 - [UpdateAlbumDto](doc//UpdateAlbumDto.md)
 - [UpdateAlbumUserDto](doc//UpdateAlbumUserDto.md)
 - [UpdateAssetDto](doc//UpdateAssetDto.md)
 - [UpdateLibraryDto](doc//UpdateLibraryDto.md)
 - [UsageByUserDto](doc//UsageByUserDto.md)
 - [UserAdminCreateDto](doc//UserAdminCreateDto.md)
 - [UserAdminDeleteDto](doc//UserAdminDeleteDto.md)
 - [UserAdminResponseDto](doc//UserAdminResponseDto.md)
 - [UserAdminUpdateDto](doc//UserAdminUpdateDto.md)
 - [UserAvatarColor](doc//UserAvatarColor.md)
 - [UserLicense](doc//UserLicense.md)
 - [UserMetadataKey](doc//UserMetadataKey.md)
 - [UserPreferencesResponseDto](doc//UserPreferencesResponseDto.md)
 - [UserPreferencesUpdateDto](doc//UserPreferencesUpdateDto.md)
 - [UserResponseDto](doc//UserResponseDto.md)
 - [UserStatus](doc//UserStatus.md)
 - [UserUpdateMeDto](doc//UserUpdateMeDto.md)
 - [ValidateAccessTokenResponseDto](doc//ValidateAccessTokenResponseDto.md)
 - [ValidateLibraryDto](doc//ValidateLibraryDto.md)
 - [ValidateLibraryImportPathResponseDto](doc//ValidateLibraryImportPathResponseDto.md)
 - [ValidateLibraryResponseDto](doc//ValidateLibraryResponseDto.md)
 - [VersionCheckStateResponseDto](doc//VersionCheckStateResponseDto.md)
 - [VideoCodec](doc//VideoCodec.md)
 - [VideoContainer](doc//VideoContainer.md)
 - [WorkflowActionItemDto](doc//WorkflowActionItemDto.md)
 - [WorkflowActionResponseDto](doc//WorkflowActionResponseDto.md)
 - [WorkflowCreateDto](doc//WorkflowCreateDto.md)
 - [WorkflowFilterItemDto](doc//WorkflowFilterItemDto.md)
 - [WorkflowFilterResponseDto](doc//WorkflowFilterResponseDto.md)
 - [WorkflowResponseDto](doc//WorkflowResponseDto.md)
 - [WorkflowUpdateDto](doc//WorkflowUpdateDto.md)


## Documentation For Authorization


Authentication schemes defined for the API:
### bearer

- **Type**: HTTP Bearer authentication

### cookie

- **Type**: API key
- **API key parameter name**: immich_access_token
- **Location**: 

### api_key

- **Type**: API key
- **API key parameter name**: x-api-key
- **Location**: HTTP header


## Author



