import 'package:easy_localization/easy_localization.dart';
import 'package:flutter/material.dart';
import 'package:immich_mobile/extensions/build_context_extensions.dart';

class FilterBottomSheetScaffold extends StatelessWidget {
  const FilterBottomSheetScaffold({
    super.key,
    required this.child,
    this.onSearch,
    required this.onClear,
    required this.title,
    this.expanded,
  });

  final bool? expanded;
  final String title;
  final Widget child;
  final Function()? onSearch;
  final Function() onClear;

  @override
  Widget build(BuildContext context) {
    buildChildWidget() {
      if (expanded != null && expanded == true) {
        return Expanded(child: child);
      }
      return child;
    }

    return SafeArea(
      child: Column(
        mainAxisSize: MainAxisSize.min,
        children: [
          Padding(
            padding: const EdgeInsets.all(16.0),
            child: Text(title, style: context.textTheme.headlineSmall),
          ),
          buildChildWidget(),
          Padding(
            padding: const EdgeInsets.all(8.0),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.end,
              children: [
                OutlinedButton(
                  onPressed: () {
                    onClear();
                    context.pop();
                  },
                  child: const Text('clear').tr(),
                ),
                if (onSearch != null) const SizedBox(width: 8),
                if (onSearch != null)
                  ElevatedButton(
                    key: const Key('search_filter_apply'),
                    onPressed: () {
                      onSearch!();
                      context.pop();
                    },
                    child: const Text('search_filter_apply').tr(),
                  ),
              ],
            ),
          ),
        ],
      ),
    );
  }
}
