// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'package:test/test.dart';
import 'package:vm_service/vm_service.dart';

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart pkg/vm_service/test/issue_25465_test.dart
//
const LINE_A = 22;
const LINE_B = 23;
// AUTOGENERATED END

void testMain() {
  final int foo; // LINE_A
  foo = 42; // LINE_B
  print(foo);
}

final tests = <IsolateTest>[
  hasPausedAtStart,
  // Add breakpoints.
  (VmService service, IsolateRef isolateRef) async {
    final isolateId = isolateRef.id!;
    final isolate = await service.getIsolate(isolateId);
    final rootLib = await service.getObject(
      isolateId,
      isolate.rootLib!.id!,
    ) as Library;
    final scriptId = rootLib.scripts![0].id!;

    final bpt1 = await service.addBreakpoint(isolateId, scriptId, LINE_A);
    final bpt2 = await service.addBreakpoint(isolateId, scriptId, LINE_B);
    expect(bpt1.location!.line, LINE_A);
    expect(bpt2.location!.line, LINE_B);
  },
  resumeIsolate,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_A),
  (VmService service, IsolateRef isolateRef) async {
    final isolateId = isolateRef.id!;
    final isolate = await service.getIsolate(isolateId);
    final breakpoints = isolate.breakpoints!;
    expect(breakpoints.length, 2);
    for (final bpt in isolate.breakpoints!) {
      await service.removeBreakpoint(isolateId, bpt.id!);
    }
  },
  stepOver,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_B),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'issue_25465_test.dart',
      testeeConcurrent: testMain,
      pauseOnStart: true,
    );
