// Autogenerated from Pigeon (v3.0.3), do not edit directly.
// See also: https://pub.dev/packages/pigeon

package com.shoutsocial.share_handler;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

/** Generated class from Pigeon. */
@SuppressWarnings({"unused", "unchecked", "CodeBlock2Expr", "RedundantSuppression"})
public class Messages {

  public enum SharedAttachmentType {
    image(0),
    video(1),
    audio(2),
    file(3);

    private int index;
    private SharedAttachmentType(final int index) {
      this.index = index;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static class SharedAttachment {
    private @NonNull String path;
    public @NonNull String getPath() { return path; }
    public void setPath(@NonNull String setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"path\" is null.");
      }
      this.path = setterArg;
    }

    private @NonNull SharedAttachmentType type;
    public @NonNull SharedAttachmentType getType() { return type; }
    public void setType(@NonNull SharedAttachmentType setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"type\" is null.");
      }
      this.type = setterArg;
    }

    /** Constructor is private to enforce null safety; use Builder. */
    private SharedAttachment() {}
    public static final class Builder {
      private @Nullable String path;
      public @NonNull Builder setPath(@NonNull String setterArg) {
        this.path = setterArg;
        return this;
      }
      private @Nullable SharedAttachmentType type;
      public @NonNull Builder setType(@NonNull SharedAttachmentType setterArg) {
        this.type = setterArg;
        return this;
      }
      public @NonNull SharedAttachment build() {
        SharedAttachment pigeonReturn = new SharedAttachment();
        pigeonReturn.setPath(path);
        pigeonReturn.setType(type);
        return pigeonReturn;
      }
    }
    @NonNull Map<String, Object> toMap() {
      Map<String, Object> toMapResult = new HashMap<>();
      toMapResult.put("path", path);
      toMapResult.put("type", type == null ? null : type.index);
      return toMapResult;
    }
    static @NonNull SharedAttachment fromMap(@NonNull Map<String, Object> map) {
      SharedAttachment pigeonResult = new SharedAttachment();
      Object path = map.get("path");
      pigeonResult.setPath((String)path);
      Object type = map.get("type");
      pigeonResult.setType(type == null ? null : SharedAttachmentType.values()[(int)type]);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static class SharedMedia {
    private @Nullable List<SharedAttachment> attachments;
    public @Nullable List<SharedAttachment> getAttachments() { return attachments; }
    public void setAttachments(@Nullable List<SharedAttachment> setterArg) {
      this.attachments = setterArg;
    }

    private @Nullable String conversationIdentifier;
    public @Nullable String getConversationIdentifier() { return conversationIdentifier; }
    public void setConversationIdentifier(@Nullable String setterArg) {
      this.conversationIdentifier = setterArg;
    }

    private @Nullable String content;
    public @Nullable String getContent() { return content; }
    public void setContent(@Nullable String setterArg) {
      this.content = setterArg;
    }

    private @Nullable String speakableGroupName;
    public @Nullable String getSpeakableGroupName() { return speakableGroupName; }
    public void setSpeakableGroupName(@Nullable String setterArg) {
      this.speakableGroupName = setterArg;
    }

    private @Nullable String serviceName;
    public @Nullable String getServiceName() { return serviceName; }
    public void setServiceName(@Nullable String setterArg) {
      this.serviceName = setterArg;
    }

    private @Nullable String senderIdentifier;
    public @Nullable String getSenderIdentifier() { return senderIdentifier; }
    public void setSenderIdentifier(@Nullable String setterArg) {
      this.senderIdentifier = setterArg;
    }

    private @Nullable String imageFilePath;
    public @Nullable String getImageFilePath() { return imageFilePath; }
    public void setImageFilePath(@Nullable String setterArg) {
      this.imageFilePath = setterArg;
    }

    public static final class Builder {
      private @Nullable List<SharedAttachment> attachments;
      public @NonNull Builder setAttachments(@Nullable List<SharedAttachment> setterArg) {
        this.attachments = setterArg;
        return this;
      }
      private @Nullable String conversationIdentifier;
      public @NonNull Builder setConversationIdentifier(@Nullable String setterArg) {
        this.conversationIdentifier = setterArg;
        return this;
      }
      private @Nullable String content;
      public @NonNull Builder setContent(@Nullable String setterArg) {
        this.content = setterArg;
        return this;
      }
      private @Nullable String speakableGroupName;
      public @NonNull Builder setSpeakableGroupName(@Nullable String setterArg) {
        this.speakableGroupName = setterArg;
        return this;
      }
      private @Nullable String serviceName;
      public @NonNull Builder setServiceName(@Nullable String setterArg) {
        this.serviceName = setterArg;
        return this;
      }
      private @Nullable String senderIdentifier;
      public @NonNull Builder setSenderIdentifier(@Nullable String setterArg) {
        this.senderIdentifier = setterArg;
        return this;
      }
      private @Nullable String imageFilePath;
      public @NonNull Builder setImageFilePath(@Nullable String setterArg) {
        this.imageFilePath = setterArg;
        return this;
      }
      public @NonNull SharedMedia build() {
        SharedMedia pigeonReturn = new SharedMedia();
        pigeonReturn.setAttachments(attachments);
        pigeonReturn.setConversationIdentifier(conversationIdentifier);
        pigeonReturn.setContent(content);
        pigeonReturn.setSpeakableGroupName(speakableGroupName);
        pigeonReturn.setServiceName(serviceName);
        pigeonReturn.setSenderIdentifier(senderIdentifier);
        pigeonReturn.setImageFilePath(imageFilePath);
        return pigeonReturn;
      }
    }
    @NonNull Map<String, Object> toMap() {
      Map<String, Object> toMapResult = new HashMap<>();
      List<Map<String, Object>> list = new ArrayList();
      for (int i = 0; i < (attachments == null ? 0 : attachments.size()); i++) {
        list.add(attachments.get(i).toMap());
      }
      toMapResult.put("attachments", list.isEmpty() ? null : list);
      toMapResult.put("conversationIdentifier", conversationIdentifier);
      toMapResult.put("content", content);
      toMapResult.put("speakableGroupName", speakableGroupName);
      toMapResult.put("serviceName", serviceName);
      toMapResult.put("senderIdentifier", senderIdentifier);
      toMapResult.put("imageFilePath", imageFilePath);
      return toMapResult;
    }
    static @NonNull SharedMedia fromMap(@NonNull Map<String, Object> map) {
      SharedMedia pigeonResult = new SharedMedia();
      List<Map<String, Object>> attachments = (List<Map<String, Object>>) map.get("attachments");
      List<SharedAttachment> list = new ArrayList<>();
      for (int i = 0; i < (attachments == null ? 0 : attachments.size()); i++) {
        list.add(SharedAttachment.fromMap(attachments.get(i)));
      }
      pigeonResult.setAttachments(list);
      Object conversationIdentifier = map.get("conversationIdentifier");
      pigeonResult.setConversationIdentifier((String)conversationIdentifier);
      Object content = map.get("content");
      pigeonResult.setContent((String)content);
      Object speakableGroupName = map.get("speakableGroupName");
      pigeonResult.setSpeakableGroupName((String)speakableGroupName);
      Object serviceName = map.get("serviceName");
      pigeonResult.setServiceName((String)serviceName);
      Object senderIdentifier = map.get("senderIdentifier");
      pigeonResult.setSenderIdentifier((String)senderIdentifier);
      Object imageFilePath = map.get("imageFilePath");
      pigeonResult.setImageFilePath((String)imageFilePath);
      return pigeonResult;
    }
  }

  public interface Result<T> {
    void success(T result);
    void error(Throwable error);
  }
  private static class ShareHandlerApiCodec extends StandardMessageCodec {
    public static final ShareHandlerApiCodec INSTANCE = new ShareHandlerApiCodec();
    private ShareHandlerApiCodec() {}
    @Override
    protected Object readValueOfType(byte type, ByteBuffer buffer) {
      switch (type) {
        case (byte)128:         
          return SharedAttachment.fromMap((Map<String, Object>) readValue(buffer));
        
        case (byte)129:         
          return SharedMedia.fromMap((Map<String, Object>) readValue(buffer));
        
        case (byte)130:         
          return SharedMedia.fromMap((Map<String, Object>) readValue(buffer));
        
        default:        
          return super.readValueOfType(type, buffer);
        
      }
    }
    @Override
    protected void writeValue(ByteArrayOutputStream stream, Object value)     {
      if (value instanceof SharedAttachment) {
        stream.write(128);
        writeValue(stream, ((SharedAttachment) value).toMap());
      } else 
      if (value instanceof SharedMedia) {
        stream.write(129);
        writeValue(stream, ((SharedMedia) value).toMap());
      } else 
      if (value instanceof SharedMedia) {
        stream.write(130);
        writeValue(stream, ((SharedMedia) value).toMap());
      } else 
{
        super.writeValue(stream, value);
      }
    }
  }

  /** Generated interface from Pigeon that represents a handler of messages from Flutter.*/
  public interface ShareHandlerApi {
    void getInitialSharedMedia(Result<SharedMedia> result);
    void recordSentMessage(@NonNull SharedMedia media);
    void resetInitialSharedMedia();

    /** The codec used by ShareHandlerApi. */
    static MessageCodec<Object> getCodec() {
      return ShareHandlerApiCodec.INSTANCE;
    }

    /** Sets up an instance of `ShareHandlerApi` to handle messages through the `binaryMessenger`. */
    static void setup(BinaryMessenger binaryMessenger, ShareHandlerApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(binaryMessenger, "dev.flutter.pigeon.ShareHandlerApi.getInitialSharedMedia", getCodec());
        if (api != null) {
          channel.setMessageHandler((message, reply) -> {
            Map<String, Object> wrapped = new HashMap<>();
            try {
              Result<SharedMedia> resultCallback = new Result<SharedMedia>() {
                public void success(SharedMedia result) {
                  wrapped.put("result", result);
                  reply.reply(wrapped);
                }
                public void error(Throwable error) {
                  wrapped.put("error", wrapError(error));
                  reply.reply(wrapped);
                }
              };

              api.getInitialSharedMedia(resultCallback);
            }
            catch (Error | RuntimeException exception) {
              wrapped.put("error", wrapError(exception));
              reply.reply(wrapped);
            }
          });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(binaryMessenger, "dev.flutter.pigeon.ShareHandlerApi.recordSentMessage", getCodec());
        if (api != null) {
          channel.setMessageHandler((message, reply) -> {
            Map<String, Object> wrapped = new HashMap<>();
            try {
              ArrayList<Object> args = (ArrayList<Object>)message;
              SharedMedia mediaArg = (SharedMedia)args.get(0);
              if (mediaArg == null) {
                throw new NullPointerException("mediaArg unexpectedly null.");
              }
              api.recordSentMessage(mediaArg);
              wrapped.put("result", null);
            }
            catch (Error | RuntimeException exception) {
              wrapped.put("error", wrapError(exception));
            }
            reply.reply(wrapped);
          });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(binaryMessenger, "dev.flutter.pigeon.ShareHandlerApi.resetInitialSharedMedia", getCodec());
        if (api != null) {
          channel.setMessageHandler((message, reply) -> {
            Map<String, Object> wrapped = new HashMap<>();
            try {
              api.resetInitialSharedMedia();
              wrapped.put("result", null);
            }
            catch (Error | RuntimeException exception) {
              wrapped.put("error", wrapError(exception));
            }
            reply.reply(wrapped);
          });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  private static Map<String, Object> wrapError(Throwable exception) {
    Map<String, Object> errorMap = new HashMap<>();
    errorMap.put("message", exception.toString());
    errorMap.put("code", exception.getClass().getSimpleName());
    errorMap.put("details", "Cause: " + exception.getCause() + ", Stacktrace: " + Log.getStackTraceString(exception));
    return errorMap;
  }
}
