// Copyright 2013 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// Autogenerated from Pigeon, do not edit directly.
// See also: https://pub.dev/packages/pigeon

import Foundation

#if os(iOS)
  import Flutter
#elseif os(macOS)
  import FlutterMacOS
#else
  #error("Unsupported platform.")
#endif

/// Error class for passing custom error details to Dart side.
final class PigeonError: Error {
  let code: String
  let message: String?
  let details: Sendable?

  init(code: String, message: String?, details: Sendable?) {
    self.code = code
    self.message = message
    self.details = details
  }

  var localizedDescription: String {
    return
      "PigeonError(code: \(code), message: \(message ?? "<nil>"), details: \(details ?? "<nil>")"
  }
}

private func wrapResult(_ result: Any?) -> [Any?] {
  return [result]
}

private func wrapError(_ error: Any) -> [Any?] {
  if let pigeonError = error as? PigeonError {
    return [
      pigeonError.code,
      pigeonError.message,
      pigeonError.details,
    ]
  }
  if let flutterError = error as? FlutterError {
    return [
      flutterError.code,
      flutterError.message,
      flutterError.details,
    ]
  }
  return [
    "\(error)",
    "\(type(of: error))",
    "Stacktrace: \(Thread.callStackSymbols)",
  ]
}

private func createConnectionError(withChannelName channelName: String) -> PigeonError {
  return PigeonError(
    code: "channel-error", message: "Unable to establish connection on channel: '\(channelName)'.",
    details: "")
}

private func isNullish(_ value: Any?) -> Bool {
  return value is NSNull || value == nil
}

private func nilOrValue<T>(_ value: Any?) -> T? {
  if value is NSNull { return nil }
  return value as! T?
}

func deepEqualsCoreTests(_ lhs: Any?, _ rhs: Any?) -> Bool {
  let cleanLhs = nilOrValue(lhs) as Any?
  let cleanRhs = nilOrValue(rhs) as Any?
  switch (cleanLhs, cleanRhs) {
  case (nil, nil):
    return true

  case (nil, _), (_, nil):
    return false

  case is (Void, Void):
    return true

  case let (cleanLhsHashable, cleanRhsHashable) as (AnyHashable, AnyHashable):
    return cleanLhsHashable == cleanRhsHashable

  case let (cleanLhsArray, cleanRhsArray) as ([Any?], [Any?]):
    guard cleanLhsArray.count == cleanRhsArray.count else { return false }
    for (index, element) in cleanLhsArray.enumerated() {
      if !deepEqualsCoreTests(element, cleanRhsArray[index]) {
        return false
      }
    }
    return true

  case let (cleanLhsDictionary, cleanRhsDictionary) as ([AnyHashable: Any?], [AnyHashable: Any?]):
    guard cleanLhsDictionary.count == cleanRhsDictionary.count else { return false }
    for (key, cleanLhsValue) in cleanLhsDictionary {
      guard cleanRhsDictionary.index(forKey: key) != nil else { return false }
      if !deepEqualsCoreTests(cleanLhsValue, cleanRhsDictionary[key]!) {
        return false
      }
    }
    return true

  default:
    // Any other type shouldn't be able to be used with pigeon. File an issue if you find this to be untrue.
    return false
  }
}

func deepHashCoreTests(value: Any?, hasher: inout Hasher) {
  if let valueList = value as? [AnyHashable] {
    for item in valueList { deepHashCoreTests(value: item, hasher: &hasher) }
    return
  }

  if let valueDict = value as? [AnyHashable: AnyHashable] {
    for key in valueDict.keys {
      hasher.combine(key)
      deepHashCoreTests(value: valueDict[key]!, hasher: &hasher)
    }
    return
  }

  if let hashableValue = value as? AnyHashable {
    hasher.combine(hashableValue.hashValue)
  }

  return hasher.combine(String(describing: value))
}

enum AnEnum: Int {
  case one = 0
  case two = 1
  case three = 2
  case fortyTwo = 3
  case fourHundredTwentyTwo = 4
}

enum AnotherEnum: Int {
  case justInCase = 0
}

/// Generated class from Pigeon that represents data sent in messages.
struct UnusedClass: Hashable {
  var aField: Any? = nil

  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> UnusedClass? {
    let aField: Any? = pigeonVar_list[0]

    return UnusedClass(
      aField: aField
    )
  }
  func toList() -> [Any?] {
    return [
      aField
    ]
  }
  static func == (lhs: UnusedClass, rhs: UnusedClass) -> Bool {
    return deepEqualsCoreTests(lhs.toList(), rhs.toList())
  }
  func hash(into hasher: inout Hasher) {
    deepHashCoreTests(value: toList(), hasher: &hasher)
  }
}

/// A class containing all supported types.
///
/// Generated class from Pigeon that represents data sent in messages.
struct AllTypes: Hashable {
  var aBool: Bool
  var anInt: Int64
  var anInt64: Int64
  var aDouble: Double
  var aByteArray: FlutterStandardTypedData
  var a4ByteArray: FlutterStandardTypedData
  var a8ByteArray: FlutterStandardTypedData
  var aFloatArray: FlutterStandardTypedData
  var anEnum: AnEnum
  var anotherEnum: AnotherEnum
  var aString: String
  var anObject: Any
  var list: [Any?]
  var stringList: [String]
  var intList: [Int64]
  var doubleList: [Double]
  var boolList: [Bool]
  var enumList: [AnEnum]
  var objectList: [Any]
  var listList: [[Any?]]
  var mapList: [[AnyHashable?: Any?]]
  var map: [AnyHashable?: Any?]
  var stringMap: [String: String]
  var intMap: [Int64: Int64]
  var enumMap: [AnEnum: AnEnum]
  var objectMap: [AnyHashable: Any]
  var listMap: [Int64: [Any?]]
  var mapMap: [Int64: [AnyHashable?: Any?]]

  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> AllTypes? {
    let aBool = pigeonVar_list[0] as! Bool
    let anInt = pigeonVar_list[1] as! Int64
    let anInt64 = pigeonVar_list[2] as! Int64
    let aDouble = pigeonVar_list[3] as! Double
    let aByteArray = pigeonVar_list[4] as! FlutterStandardTypedData
    let a4ByteArray = pigeonVar_list[5] as! FlutterStandardTypedData
    let a8ByteArray = pigeonVar_list[6] as! FlutterStandardTypedData
    let aFloatArray = pigeonVar_list[7] as! FlutterStandardTypedData
    let anEnum = pigeonVar_list[8] as! AnEnum
    let anotherEnum = pigeonVar_list[9] as! AnotherEnum
    let aString = pigeonVar_list[10] as! String
    let anObject = pigeonVar_list[11]!
    let list = pigeonVar_list[12] as! [Any?]
    let stringList = pigeonVar_list[13] as! [String]
    let intList = pigeonVar_list[14] as! [Int64]
    let doubleList = pigeonVar_list[15] as! [Double]
    let boolList = pigeonVar_list[16] as! [Bool]
    let enumList = pigeonVar_list[17] as! [AnEnum]
    let objectList = pigeonVar_list[18] as! [Any]
    let listList = pigeonVar_list[19] as! [[Any?]]
    let mapList = pigeonVar_list[20] as! [[AnyHashable?: Any?]]
    let map = pigeonVar_list[21] as! [AnyHashable?: Any?]
    let stringMap = pigeonVar_list[22] as! [String: String]
    let intMap = pigeonVar_list[23] as! [Int64: Int64]
    let enumMap = pigeonVar_list[24] as? [AnEnum: AnEnum]
    let objectMap = pigeonVar_list[25] as! [AnyHashable: Any]
    let listMap = pigeonVar_list[26] as! [Int64: [Any?]]
    let mapMap = pigeonVar_list[27] as! [Int64: [AnyHashable?: Any?]]

    return AllTypes(
      aBool: aBool,
      anInt: anInt,
      anInt64: anInt64,
      aDouble: aDouble,
      aByteArray: aByteArray,
      a4ByteArray: a4ByteArray,
      a8ByteArray: a8ByteArray,
      aFloatArray: aFloatArray,
      anEnum: anEnum,
      anotherEnum: anotherEnum,
      aString: aString,
      anObject: anObject,
      list: list,
      stringList: stringList,
      intList: intList,
      doubleList: doubleList,
      boolList: boolList,
      enumList: enumList,
      objectList: objectList,
      listList: listList,
      mapList: mapList,
      map: map,
      stringMap: stringMap,
      intMap: intMap,
      enumMap: enumMap!,
      objectMap: objectMap,
      listMap: listMap,
      mapMap: mapMap
    )
  }
  func toList() -> [Any?] {
    return [
      aBool,
      anInt,
      anInt64,
      aDouble,
      aByteArray,
      a4ByteArray,
      a8ByteArray,
      aFloatArray,
      anEnum,
      anotherEnum,
      aString,
      anObject,
      list,
      stringList,
      intList,
      doubleList,
      boolList,
      enumList,
      objectList,
      listList,
      mapList,
      map,
      stringMap,
      intMap,
      enumMap,
      objectMap,
      listMap,
      mapMap,
    ]
  }
  static func == (lhs: AllTypes, rhs: AllTypes) -> Bool {
    return deepEqualsCoreTests(lhs.toList(), rhs.toList())
  }
  func hash(into hasher: inout Hasher) {
    deepHashCoreTests(value: toList(), hasher: &hasher)
  }
}

/// A class containing all supported nullable types.
///
/// Generated class from Pigeon that represents data sent in messages.
class AllNullableTypes: Hashable {
  init(
    aNullableBool: Bool? = nil,
    aNullableInt: Int64? = nil,
    aNullableInt64: Int64? = nil,
    aNullableDouble: Double? = nil,
    aNullableByteArray: FlutterStandardTypedData? = nil,
    aNullable4ByteArray: FlutterStandardTypedData? = nil,
    aNullable8ByteArray: FlutterStandardTypedData? = nil,
    aNullableFloatArray: FlutterStandardTypedData? = nil,
    aNullableEnum: AnEnum? = nil,
    anotherNullableEnum: AnotherEnum? = nil,
    aNullableString: String? = nil,
    aNullableObject: Any? = nil,
    allNullableTypes: AllNullableTypes? = nil,
    list: [Any?]? = nil,
    stringList: [String?]? = nil,
    intList: [Int64?]? = nil,
    doubleList: [Double?]? = nil,
    boolList: [Bool?]? = nil,
    enumList: [AnEnum?]? = nil,
    objectList: [Any?]? = nil,
    listList: [[Any?]?]? = nil,
    mapList: [[AnyHashable?: Any?]?]? = nil,
    recursiveClassList: [AllNullableTypes?]? = nil,
    map: [AnyHashable?: Any?]? = nil,
    stringMap: [String?: String?]? = nil,
    intMap: [Int64?: Int64?]? = nil,
    enumMap: [AnEnum?: AnEnum?]? = nil,
    objectMap: [AnyHashable?: Any?]? = nil,
    listMap: [Int64?: [Any?]?]? = nil,
    mapMap: [Int64?: [AnyHashable?: Any?]?]? = nil,
    recursiveClassMap: [Int64?: AllNullableTypes?]? = nil
  ) {
    self.aNullableBool = aNullableBool
    self.aNullableInt = aNullableInt
    self.aNullableInt64 = aNullableInt64
    self.aNullableDouble = aNullableDouble
    self.aNullableByteArray = aNullableByteArray
    self.aNullable4ByteArray = aNullable4ByteArray
    self.aNullable8ByteArray = aNullable8ByteArray
    self.aNullableFloatArray = aNullableFloatArray
    self.aNullableEnum = aNullableEnum
    self.anotherNullableEnum = anotherNullableEnum
    self.aNullableString = aNullableString
    self.aNullableObject = aNullableObject
    self.allNullableTypes = allNullableTypes
    self.list = list
    self.stringList = stringList
    self.intList = intList
    self.doubleList = doubleList
    self.boolList = boolList
    self.enumList = enumList
    self.objectList = objectList
    self.listList = listList
    self.mapList = mapList
    self.recursiveClassList = recursiveClassList
    self.map = map
    self.stringMap = stringMap
    self.intMap = intMap
    self.enumMap = enumMap
    self.objectMap = objectMap
    self.listMap = listMap
    self.mapMap = mapMap
    self.recursiveClassMap = recursiveClassMap
  }
  var aNullableBool: Bool?
  var aNullableInt: Int64?
  var aNullableInt64: Int64?
  var aNullableDouble: Double?
  var aNullableByteArray: FlutterStandardTypedData?
  var aNullable4ByteArray: FlutterStandardTypedData?
  var aNullable8ByteArray: FlutterStandardTypedData?
  var aNullableFloatArray: FlutterStandardTypedData?
  var aNullableEnum: AnEnum?
  var anotherNullableEnum: AnotherEnum?
  var aNullableString: String?
  var aNullableObject: Any?
  var allNullableTypes: AllNullableTypes?
  var list: [Any?]?
  var stringList: [String?]?
  var intList: [Int64?]?
  var doubleList: [Double?]?
  var boolList: [Bool?]?
  var enumList: [AnEnum?]?
  var objectList: [Any?]?
  var listList: [[Any?]?]?
  var mapList: [[AnyHashable?: Any?]?]?
  var recursiveClassList: [AllNullableTypes?]?
  var map: [AnyHashable?: Any?]?
  var stringMap: [String?: String?]?
  var intMap: [Int64?: Int64?]?
  var enumMap: [AnEnum?: AnEnum?]?
  var objectMap: [AnyHashable?: Any?]?
  var listMap: [Int64?: [Any?]?]?
  var mapMap: [Int64?: [AnyHashable?: Any?]?]?
  var recursiveClassMap: [Int64?: AllNullableTypes?]?

  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> AllNullableTypes? {
    let aNullableBool: Bool? = nilOrValue(pigeonVar_list[0])
    let aNullableInt: Int64? = nilOrValue(pigeonVar_list[1])
    let aNullableInt64: Int64? = nilOrValue(pigeonVar_list[2])
    let aNullableDouble: Double? = nilOrValue(pigeonVar_list[3])
    let aNullableByteArray: FlutterStandardTypedData? = nilOrValue(pigeonVar_list[4])
    let aNullable4ByteArray: FlutterStandardTypedData? = nilOrValue(pigeonVar_list[5])
    let aNullable8ByteArray: FlutterStandardTypedData? = nilOrValue(pigeonVar_list[6])
    let aNullableFloatArray: FlutterStandardTypedData? = nilOrValue(pigeonVar_list[7])
    let aNullableEnum: AnEnum? = nilOrValue(pigeonVar_list[8])
    let anotherNullableEnum: AnotherEnum? = nilOrValue(pigeonVar_list[9])
    let aNullableString: String? = nilOrValue(pigeonVar_list[10])
    let aNullableObject: Any? = pigeonVar_list[11]
    let allNullableTypes: AllNullableTypes? = nilOrValue(pigeonVar_list[12])
    let list: [Any?]? = nilOrValue(pigeonVar_list[13])
    let stringList: [String?]? = nilOrValue(pigeonVar_list[14])
    let intList: [Int64?]? = nilOrValue(pigeonVar_list[15])
    let doubleList: [Double?]? = nilOrValue(pigeonVar_list[16])
    let boolList: [Bool?]? = nilOrValue(pigeonVar_list[17])
    let enumList: [AnEnum?]? = nilOrValue(pigeonVar_list[18])
    let objectList: [Any?]? = nilOrValue(pigeonVar_list[19])
    let listList: [[Any?]?]? = nilOrValue(pigeonVar_list[20])
    let mapList: [[AnyHashable?: Any?]?]? = nilOrValue(pigeonVar_list[21])
    let recursiveClassList: [AllNullableTypes?]? = nilOrValue(pigeonVar_list[22])
    let map: [AnyHashable?: Any?]? = nilOrValue(pigeonVar_list[23])
    let stringMap: [String?: String?]? = nilOrValue(pigeonVar_list[24])
    let intMap: [Int64?: Int64?]? = nilOrValue(pigeonVar_list[25])
    let enumMap: [AnEnum?: AnEnum?]? = pigeonVar_list[26] as? [AnEnum?: AnEnum?]
    let objectMap: [AnyHashable?: Any?]? = nilOrValue(pigeonVar_list[27])
    let listMap: [Int64?: [Any?]?]? = nilOrValue(pigeonVar_list[28])
    let mapMap: [Int64?: [AnyHashable?: Any?]?]? = nilOrValue(pigeonVar_list[29])
    let recursiveClassMap: [Int64?: AllNullableTypes?]? = nilOrValue(pigeonVar_list[30])

    return AllNullableTypes(
      aNullableBool: aNullableBool,
      aNullableInt: aNullableInt,
      aNullableInt64: aNullableInt64,
      aNullableDouble: aNullableDouble,
      aNullableByteArray: aNullableByteArray,
      aNullable4ByteArray: aNullable4ByteArray,
      aNullable8ByteArray: aNullable8ByteArray,
      aNullableFloatArray: aNullableFloatArray,
      aNullableEnum: aNullableEnum,
      anotherNullableEnum: anotherNullableEnum,
      aNullableString: aNullableString,
      aNullableObject: aNullableObject,
      allNullableTypes: allNullableTypes,
      list: list,
      stringList: stringList,
      intList: intList,
      doubleList: doubleList,
      boolList: boolList,
      enumList: enumList,
      objectList: objectList,
      listList: listList,
      mapList: mapList,
      recursiveClassList: recursiveClassList,
      map: map,
      stringMap: stringMap,
      intMap: intMap,
      enumMap: enumMap,
      objectMap: objectMap,
      listMap: listMap,
      mapMap: mapMap,
      recursiveClassMap: recursiveClassMap
    )
  }
  func toList() -> [Any?] {
    return [
      aNullableBool,
      aNullableInt,
      aNullableInt64,
      aNullableDouble,
      aNullableByteArray,
      aNullable4ByteArray,
      aNullable8ByteArray,
      aNullableFloatArray,
      aNullableEnum,
      anotherNullableEnum,
      aNullableString,
      aNullableObject,
      allNullableTypes,
      list,
      stringList,
      intList,
      doubleList,
      boolList,
      enumList,
      objectList,
      listList,
      mapList,
      recursiveClassList,
      map,
      stringMap,
      intMap,
      enumMap,
      objectMap,
      listMap,
      mapMap,
      recursiveClassMap,
    ]
  }
  static func == (lhs: AllNullableTypes, rhs: AllNullableTypes) -> Bool {
    if lhs === rhs {
      return true
    }
    return deepEqualsCoreTests(lhs.toList(), rhs.toList())
  }
  func hash(into hasher: inout Hasher) {
    deepHashCoreTests(value: toList(), hasher: &hasher)
  }
}

/// The primary purpose for this class is to ensure coverage of Swift structs
/// with nullable items, as the primary [AllNullableTypes] class is being used to
/// test Swift classes.
///
/// Generated class from Pigeon that represents data sent in messages.
struct AllNullableTypesWithoutRecursion: Hashable {
  var aNullableBool: Bool? = nil
  var aNullableInt: Int64? = nil
  var aNullableInt64: Int64? = nil
  var aNullableDouble: Double? = nil
  var aNullableByteArray: FlutterStandardTypedData? = nil
  var aNullable4ByteArray: FlutterStandardTypedData? = nil
  var aNullable8ByteArray: FlutterStandardTypedData? = nil
  var aNullableFloatArray: FlutterStandardTypedData? = nil
  var aNullableEnum: AnEnum? = nil
  var anotherNullableEnum: AnotherEnum? = nil
  var aNullableString: String? = nil
  var aNullableObject: Any? = nil
  var list: [Any?]? = nil
  var stringList: [String?]? = nil
  var intList: [Int64?]? = nil
  var doubleList: [Double?]? = nil
  var boolList: [Bool?]? = nil
  var enumList: [AnEnum?]? = nil
  var objectList: [Any?]? = nil
  var listList: [[Any?]?]? = nil
  var mapList: [[AnyHashable?: Any?]?]? = nil
  var map: [AnyHashable?: Any?]? = nil
  var stringMap: [String?: String?]? = nil
  var intMap: [Int64?: Int64?]? = nil
  var enumMap: [AnEnum?: AnEnum?]? = nil
  var objectMap: [AnyHashable?: Any?]? = nil
  var listMap: [Int64?: [Any?]?]? = nil
  var mapMap: [Int64?: [AnyHashable?: Any?]?]? = nil

  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> AllNullableTypesWithoutRecursion? {
    let aNullableBool: Bool? = nilOrValue(pigeonVar_list[0])
    let aNullableInt: Int64? = nilOrValue(pigeonVar_list[1])
    let aNullableInt64: Int64? = nilOrValue(pigeonVar_list[2])
    let aNullableDouble: Double? = nilOrValue(pigeonVar_list[3])
    let aNullableByteArray: FlutterStandardTypedData? = nilOrValue(pigeonVar_list[4])
    let aNullable4ByteArray: FlutterStandardTypedData? = nilOrValue(pigeonVar_list[5])
    let aNullable8ByteArray: FlutterStandardTypedData? = nilOrValue(pigeonVar_list[6])
    let aNullableFloatArray: FlutterStandardTypedData? = nilOrValue(pigeonVar_list[7])
    let aNullableEnum: AnEnum? = nilOrValue(pigeonVar_list[8])
    let anotherNullableEnum: AnotherEnum? = nilOrValue(pigeonVar_list[9])
    let aNullableString: String? = nilOrValue(pigeonVar_list[10])
    let aNullableObject: Any? = pigeonVar_list[11]
    let list: [Any?]? = nilOrValue(pigeonVar_list[12])
    let stringList: [String?]? = nilOrValue(pigeonVar_list[13])
    let intList: [Int64?]? = nilOrValue(pigeonVar_list[14])
    let doubleList: [Double?]? = nilOrValue(pigeonVar_list[15])
    let boolList: [Bool?]? = nilOrValue(pigeonVar_list[16])
    let enumList: [AnEnum?]? = nilOrValue(pigeonVar_list[17])
    let objectList: [Any?]? = nilOrValue(pigeonVar_list[18])
    let listList: [[Any?]?]? = nilOrValue(pigeonVar_list[19])
    let mapList: [[AnyHashable?: Any?]?]? = nilOrValue(pigeonVar_list[20])
    let map: [AnyHashable?: Any?]? = nilOrValue(pigeonVar_list[21])
    let stringMap: [String?: String?]? = nilOrValue(pigeonVar_list[22])
    let intMap: [Int64?: Int64?]? = nilOrValue(pigeonVar_list[23])
    let enumMap: [AnEnum?: AnEnum?]? = pigeonVar_list[24] as? [AnEnum?: AnEnum?]
    let objectMap: [AnyHashable?: Any?]? = nilOrValue(pigeonVar_list[25])
    let listMap: [Int64?: [Any?]?]? = nilOrValue(pigeonVar_list[26])
    let mapMap: [Int64?: [AnyHashable?: Any?]?]? = nilOrValue(pigeonVar_list[27])

    return AllNullableTypesWithoutRecursion(
      aNullableBool: aNullableBool,
      aNullableInt: aNullableInt,
      aNullableInt64: aNullableInt64,
      aNullableDouble: aNullableDouble,
      aNullableByteArray: aNullableByteArray,
      aNullable4ByteArray: aNullable4ByteArray,
      aNullable8ByteArray: aNullable8ByteArray,
      aNullableFloatArray: aNullableFloatArray,
      aNullableEnum: aNullableEnum,
      anotherNullableEnum: anotherNullableEnum,
      aNullableString: aNullableString,
      aNullableObject: aNullableObject,
      list: list,
      stringList: stringList,
      intList: intList,
      doubleList: doubleList,
      boolList: boolList,
      enumList: enumList,
      objectList: objectList,
      listList: listList,
      mapList: mapList,
      map: map,
      stringMap: stringMap,
      intMap: intMap,
      enumMap: enumMap,
      objectMap: objectMap,
      listMap: listMap,
      mapMap: mapMap
    )
  }
  func toList() -> [Any?] {
    return [
      aNullableBool,
      aNullableInt,
      aNullableInt64,
      aNullableDouble,
      aNullableByteArray,
      aNullable4ByteArray,
      aNullable8ByteArray,
      aNullableFloatArray,
      aNullableEnum,
      anotherNullableEnum,
      aNullableString,
      aNullableObject,
      list,
      stringList,
      intList,
      doubleList,
      boolList,
      enumList,
      objectList,
      listList,
      mapList,
      map,
      stringMap,
      intMap,
      enumMap,
      objectMap,
      listMap,
      mapMap,
    ]
  }
  static func == (lhs: AllNullableTypesWithoutRecursion, rhs: AllNullableTypesWithoutRecursion)
    -> Bool
  {
    return deepEqualsCoreTests(lhs.toList(), rhs.toList())
  }
  func hash(into hasher: inout Hasher) {
    deepHashCoreTests(value: toList(), hasher: &hasher)
  }
}

/// A class for testing nested class handling.
///
/// This is needed to test nested nullable and non-nullable classes,
/// `AllNullableTypes` is non-nullable here as it is easier to instantiate
/// than `AllTypes` when testing doesn't require both (ie. testing null classes).
///
/// Generated class from Pigeon that represents data sent in messages.
struct AllClassesWrapper: Hashable {
  var allNullableTypes: AllNullableTypes
  var allNullableTypesWithoutRecursion: AllNullableTypesWithoutRecursion? = nil
  var allTypes: AllTypes? = nil
  var classList: [AllTypes?]
  var nullableClassList: [AllNullableTypesWithoutRecursion?]? = nil
  var classMap: [Int64?: AllTypes?]
  var nullableClassMap: [Int64?: AllNullableTypesWithoutRecursion?]? = nil

  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> AllClassesWrapper? {
    let allNullableTypes = pigeonVar_list[0] as! AllNullableTypes
    let allNullableTypesWithoutRecursion: AllNullableTypesWithoutRecursion? = nilOrValue(
      pigeonVar_list[1])
    let allTypes: AllTypes? = nilOrValue(pigeonVar_list[2])
    let classList = pigeonVar_list[3] as! [AllTypes?]
    let nullableClassList: [AllNullableTypesWithoutRecursion?]? = nilOrValue(pigeonVar_list[4])
    let classMap = pigeonVar_list[5] as! [Int64?: AllTypes?]
    let nullableClassMap: [Int64?: AllNullableTypesWithoutRecursion?]? = nilOrValue(
      pigeonVar_list[6])

    return AllClassesWrapper(
      allNullableTypes: allNullableTypes,
      allNullableTypesWithoutRecursion: allNullableTypesWithoutRecursion,
      allTypes: allTypes,
      classList: classList,
      nullableClassList: nullableClassList,
      classMap: classMap,
      nullableClassMap: nullableClassMap
    )
  }
  func toList() -> [Any?] {
    return [
      allNullableTypes,
      allNullableTypesWithoutRecursion,
      allTypes,
      classList,
      nullableClassList,
      classMap,
      nullableClassMap,
    ]
  }
  static func == (lhs: AllClassesWrapper, rhs: AllClassesWrapper) -> Bool {
    return deepEqualsCoreTests(lhs.toList(), rhs.toList())
  }
  func hash(into hasher: inout Hasher) {
    deepHashCoreTests(value: toList(), hasher: &hasher)
  }
}

/// A data class containing a List, used in unit tests.
///
/// Generated class from Pigeon that represents data sent in messages.
struct TestMessage: Hashable {
  var testList: [Any?]? = nil

  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> TestMessage? {
    let testList: [Any?]? = nilOrValue(pigeonVar_list[0])

    return TestMessage(
      testList: testList
    )
  }
  func toList() -> [Any?] {
    return [
      testList
    ]
  }
  static func == (lhs: TestMessage, rhs: TestMessage) -> Bool {
    return deepEqualsCoreTests(lhs.toList(), rhs.toList())
  }
  func hash(into hasher: inout Hasher) {
    deepHashCoreTests(value: toList(), hasher: &hasher)
  }
}

private class CoreTestsPigeonCodecReader: FlutterStandardReader {
  override func readValue(ofType type: UInt8) -> Any? {
    switch type {
    case 129:
      let enumResultAsInt: Int? = nilOrValue(self.readValue() as! Int?)
      if let enumResultAsInt = enumResultAsInt {
        return AnEnum(rawValue: enumResultAsInt)
      }
      return nil
    case 130:
      let enumResultAsInt: Int? = nilOrValue(self.readValue() as! Int?)
      if let enumResultAsInt = enumResultAsInt {
        return AnotherEnum(rawValue: enumResultAsInt)
      }
      return nil
    case 131:
      return UnusedClass.fromList(self.readValue() as! [Any?])
    case 132:
      return AllTypes.fromList(self.readValue() as! [Any?])
    case 133:
      return AllNullableTypes.fromList(self.readValue() as! [Any?])
    case 134:
      return AllNullableTypesWithoutRecursion.fromList(self.readValue() as! [Any?])
    case 135:
      return AllClassesWrapper.fromList(self.readValue() as! [Any?])
    case 136:
      return TestMessage.fromList(self.readValue() as! [Any?])
    default:
      return super.readValue(ofType: type)
    }
  }
}

private class CoreTestsPigeonCodecWriter: FlutterStandardWriter {
  override func writeValue(_ value: Any) {
    if let value = value as? AnEnum {
      super.writeByte(129)
      super.writeValue(value.rawValue)
    } else if let value = value as? AnotherEnum {
      super.writeByte(130)
      super.writeValue(value.rawValue)
    } else if let value = value as? UnusedClass {
      super.writeByte(131)
      super.writeValue(value.toList())
    } else if let value = value as? AllTypes {
      super.writeByte(132)
      super.writeValue(value.toList())
    } else if let value = value as? AllNullableTypes {
      super.writeByte(133)
      super.writeValue(value.toList())
    } else if let value = value as? AllNullableTypesWithoutRecursion {
      super.writeByte(134)
      super.writeValue(value.toList())
    } else if let value = value as? AllClassesWrapper {
      super.writeByte(135)
      super.writeValue(value.toList())
    } else if let value = value as? TestMessage {
      super.writeByte(136)
      super.writeValue(value.toList())
    } else {
      super.writeValue(value)
    }
  }
}

private class CoreTestsPigeonCodecReaderWriter: FlutterStandardReaderWriter {
  override func reader(with data: Data) -> FlutterStandardReader {
    return CoreTestsPigeonCodecReader(data: data)
  }

  override func writer(with data: NSMutableData) -> FlutterStandardWriter {
    return CoreTestsPigeonCodecWriter(data: data)
  }
}

class CoreTestsPigeonCodec: FlutterStandardMessageCodec, @unchecked Sendable {
  static let shared = CoreTestsPigeonCodec(readerWriter: CoreTestsPigeonCodecReaderWriter())
}

/// The core interface that each host language plugin must implement in
/// platform_test integration tests.
///
/// Generated protocol from Pigeon that represents a handler of messages from Flutter.
protocol HostIntegrationCoreApi {
  /// A no-op function taking no arguments and returning no value, to sanity
  /// test basic calling.
  func noop() throws
  /// Returns the passed object, to test serialization and deserialization.
  func echo(_ everything: AllTypes) throws -> AllTypes
  /// Returns an error, to test error handling.
  func throwError() throws -> Any?
  /// Returns an error from a void function, to test error handling.
  func throwErrorFromVoid() throws
  /// Returns a Flutter error, to test error handling.
  func throwFlutterError() throws -> Any?
  /// Returns passed in int.
  func echo(_ anInt: Int64) throws -> Int64
  /// Returns passed in double.
  func echo(_ aDouble: Double) throws -> Double
  /// Returns the passed in boolean.
  func echo(_ aBool: Bool) throws -> Bool
  /// Returns the passed in string.
  func echo(_ aString: String) throws -> String
  /// Returns the passed in Uint8List.
  func echo(_ aUint8List: FlutterStandardTypedData) throws -> FlutterStandardTypedData
  /// Returns the passed in generic Object.
  func echo(_ anObject: Any) throws -> Any
  /// Returns the passed list, to test serialization and deserialization.
  func echo(_ list: [Any?]) throws -> [Any?]
  /// Returns the passed list, to test serialization and deserialization.
  func echo(enumList: [AnEnum?]) throws -> [AnEnum?]
  /// Returns the passed list, to test serialization and deserialization.
  func echo(classList: [AllNullableTypes?]) throws -> [AllNullableTypes?]
  /// Returns the passed list, to test serialization and deserialization.
  func echoNonNull(enumList: [AnEnum]) throws -> [AnEnum]
  /// Returns the passed list, to test serialization and deserialization.
  func echoNonNull(classList: [AllNullableTypes]) throws -> [AllNullableTypes]
  /// Returns the passed map, to test serialization and deserialization.
  func echo(_ map: [AnyHashable?: Any?]) throws -> [AnyHashable?: Any?]
  /// Returns the passed map, to test serialization and deserialization.
  func echo(stringMap: [String?: String?]) throws -> [String?: String?]
  /// Returns the passed map, to test serialization and deserialization.
  func echo(intMap: [Int64?: Int64?]) throws -> [Int64?: Int64?]
  /// Returns the passed map, to test serialization and deserialization.
  func echo(enumMap: [AnEnum?: AnEnum?]) throws -> [AnEnum?: AnEnum?]
  /// Returns the passed map, to test serialization and deserialization.
  func echo(classMap: [Int64?: AllNullableTypes?]) throws -> [Int64?: AllNullableTypes?]
  /// Returns the passed map, to test serialization and deserialization.
  func echoNonNull(stringMap: [String: String]) throws -> [String: String]
  /// Returns the passed map, to test serialization and deserialization.
  func echoNonNull(intMap: [Int64: Int64]) throws -> [Int64: Int64]
  /// Returns the passed map, to test serialization and deserialization.
  func echoNonNull(enumMap: [AnEnum: AnEnum]) throws -> [AnEnum: AnEnum]
  /// Returns the passed map, to test serialization and deserialization.
  func echoNonNull(classMap: [Int64: AllNullableTypes]) throws -> [Int64: AllNullableTypes]
  /// Returns the passed class to test nested class serialization and deserialization.
  func echo(_ wrapper: AllClassesWrapper) throws -> AllClassesWrapper
  /// Returns the passed enum to test serialization and deserialization.
  func echo(_ anEnum: AnEnum) throws -> AnEnum
  /// Returns the passed enum to test serialization and deserialization.
  func echo(_ anotherEnum: AnotherEnum) throws -> AnotherEnum
  /// Returns the default string.
  func echoNamedDefault(_ aString: String) throws -> String
  /// Returns passed in double.
  func echoOptionalDefault(_ aDouble: Double) throws -> Double
  /// Returns passed in int.
  func echoRequired(_ anInt: Int64) throws -> Int64
  /// Returns the passed object, to test serialization and deserialization.
  func echo(_ everything: AllNullableTypes?) throws -> AllNullableTypes?
  /// Returns the passed object, to test serialization and deserialization.
  func echo(_ everything: AllNullableTypesWithoutRecursion?) throws
    -> AllNullableTypesWithoutRecursion?
  /// Returns the inner `aString` value from the wrapped object, to test
  /// sending of nested objects.
  func extractNestedNullableString(from wrapper: AllClassesWrapper) throws -> String?
  /// Returns the inner `aString` value from the wrapped object, to test
  /// sending of nested objects.
  func createNestedObject(with nullableString: String?) throws -> AllClassesWrapper
  /// Returns passed in arguments of multiple types.
  func sendMultipleNullableTypes(
    aBool aNullableBool: Bool?, anInt aNullableInt: Int64?, aString aNullableString: String?
  ) throws -> AllNullableTypes
  /// Returns passed in arguments of multiple types.
  func sendMultipleNullableTypesWithoutRecursion(
    aBool aNullableBool: Bool?, anInt aNullableInt: Int64?, aString aNullableString: String?
  ) throws -> AllNullableTypesWithoutRecursion
  /// Returns passed in int.
  func echo(_ aNullableInt: Int64?) throws -> Int64?
  /// Returns passed in double.
  func echo(_ aNullableDouble: Double?) throws -> Double?
  /// Returns the passed in boolean.
  func echo(_ aNullableBool: Bool?) throws -> Bool?
  /// Returns the passed in string.
  func echo(_ aNullableString: String?) throws -> String?
  /// Returns the passed in Uint8List.
  func echo(_ aNullableUint8List: FlutterStandardTypedData?) throws -> FlutterStandardTypedData?
  /// Returns the passed in generic Object.
  func echo(_ aNullableObject: Any?) throws -> Any?
  /// Returns the passed list, to test serialization and deserialization.
  func echoNullable(_ aNullableList: [Any?]?) throws -> [Any?]?
  /// Returns the passed list, to test serialization and deserialization.
  func echoNullable(enumList: [AnEnum?]?) throws -> [AnEnum?]?
  /// Returns the passed list, to test serialization and deserialization.
  func echoNullable(classList: [AllNullableTypes?]?) throws -> [AllNullableTypes?]?
  /// Returns the passed list, to test serialization and deserialization.
  func echoNullableNonNull(enumList: [AnEnum]?) throws -> [AnEnum]?
  /// Returns the passed list, to test serialization and deserialization.
  func echoNullableNonNull(classList: [AllNullableTypes]?) throws -> [AllNullableTypes]?
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullable(_ map: [AnyHashable?: Any?]?) throws -> [AnyHashable?: Any?]?
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullable(stringMap: [String?: String?]?) throws -> [String?: String?]?
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullable(intMap: [Int64?: Int64?]?) throws -> [Int64?: Int64?]?
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullable(enumMap: [AnEnum?: AnEnum?]?) throws -> [AnEnum?: AnEnum?]?
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullable(classMap: [Int64?: AllNullableTypes?]?) throws -> [Int64?: AllNullableTypes?]?
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullableNonNull(stringMap: [String: String]?) throws -> [String: String]?
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullableNonNull(intMap: [Int64: Int64]?) throws -> [Int64: Int64]?
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullableNonNull(enumMap: [AnEnum: AnEnum]?) throws -> [AnEnum: AnEnum]?
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullableNonNull(classMap: [Int64: AllNullableTypes]?) throws -> [Int64:
    AllNullableTypes]?
  func echoNullable(_ anEnum: AnEnum?) throws -> AnEnum?
  func echoNullable(_ anotherEnum: AnotherEnum?) throws -> AnotherEnum?
  /// Returns passed in int.
  func echoOptional(_ aNullableInt: Int64?) throws -> Int64?
  /// Returns the passed in string.
  func echoNamed(_ aNullableString: String?) throws -> String?
  /// A no-op function taking no arguments and returning no value, to sanity
  /// test basic asynchronous calling.
  func noopAsync(completion: @escaping (Result<Void, Error>) -> Void)
  /// Returns passed in int asynchronously.
  func echoAsync(_ anInt: Int64, completion: @escaping (Result<Int64, Error>) -> Void)
  /// Returns passed in double asynchronously.
  func echoAsync(_ aDouble: Double, completion: @escaping (Result<Double, Error>) -> Void)
  /// Returns the passed in boolean asynchronously.
  func echoAsync(_ aBool: Bool, completion: @escaping (Result<Bool, Error>) -> Void)
  /// Returns the passed string asynchronously.
  func echoAsync(_ aString: String, completion: @escaping (Result<String, Error>) -> Void)
  /// Returns the passed in Uint8List asynchronously.
  func echoAsync(
    _ aUint8List: FlutterStandardTypedData,
    completion: @escaping (Result<FlutterStandardTypedData, Error>) -> Void)
  /// Returns the passed in generic Object asynchronously.
  func echoAsync(_ anObject: Any, completion: @escaping (Result<Any, Error>) -> Void)
  /// Returns the passed list, to test asynchronous serialization and deserialization.
  func echoAsync(_ list: [Any?], completion: @escaping (Result<[Any?], Error>) -> Void)
  /// Returns the passed list, to test asynchronous serialization and deserialization.
  func echoAsync(enumList: [AnEnum?], completion: @escaping (Result<[AnEnum?], Error>) -> Void)
  /// Returns the passed list, to test asynchronous serialization and deserialization.
  func echoAsync(
    classList: [AllNullableTypes?],
    completion: @escaping (Result<[AllNullableTypes?], Error>) -> Void)
  /// Returns the passed map, to test asynchronous serialization and deserialization.
  func echoAsync(
    _ map: [AnyHashable?: Any?], completion: @escaping (Result<[AnyHashable?: Any?], Error>) -> Void
  )
  /// Returns the passed map, to test asynchronous serialization and deserialization.
  func echoAsync(
    stringMap: [String?: String?], completion: @escaping (Result<[String?: String?], Error>) -> Void
  )
  /// Returns the passed map, to test asynchronous serialization and deserialization.
  func echoAsync(
    intMap: [Int64?: Int64?], completion: @escaping (Result<[Int64?: Int64?], Error>) -> Void)
  /// Returns the passed map, to test asynchronous serialization and deserialization.
  func echoAsync(
    enumMap: [AnEnum?: AnEnum?], completion: @escaping (Result<[AnEnum?: AnEnum?], Error>) -> Void)
  /// Returns the passed map, to test asynchronous serialization and deserialization.
  func echoAsync(
    classMap: [Int64?: AllNullableTypes?],
    completion: @escaping (Result<[Int64?: AllNullableTypes?], Error>) -> Void)
  /// Returns the passed enum, to test asynchronous serialization and deserialization.
  func echoAsync(_ anEnum: AnEnum, completion: @escaping (Result<AnEnum, Error>) -> Void)
  /// Returns the passed enum, to test asynchronous serialization and deserialization.
  func echoAsync(
    _ anotherEnum: AnotherEnum, completion: @escaping (Result<AnotherEnum, Error>) -> Void)
  /// Responds with an error from an async function returning a value.
  func throwAsyncError(completion: @escaping (Result<Any?, Error>) -> Void)
  /// Responds with an error from an async void function.
  func throwAsyncErrorFromVoid(completion: @escaping (Result<Void, Error>) -> Void)
  /// Responds with a Flutter error from an async function returning a value.
  func throwAsyncFlutterError(completion: @escaping (Result<Any?, Error>) -> Void)
  /// Returns the passed object, to test async serialization and deserialization.
  func echoAsync(_ everything: AllTypes, completion: @escaping (Result<AllTypes, Error>) -> Void)
  /// Returns the passed object, to test serialization and deserialization.
  func echoAsync(
    _ everything: AllNullableTypes?,
    completion: @escaping (Result<AllNullableTypes?, Error>) -> Void)
  /// Returns the passed object, to test serialization and deserialization.
  func echoAsync(
    _ everything: AllNullableTypesWithoutRecursion?,
    completion: @escaping (Result<AllNullableTypesWithoutRecursion?, Error>) -> Void)
  /// Returns passed in int asynchronously.
  func echoAsyncNullable(_ anInt: Int64?, completion: @escaping (Result<Int64?, Error>) -> Void)
  /// Returns passed in double asynchronously.
  func echoAsyncNullable(_ aDouble: Double?, completion: @escaping (Result<Double?, Error>) -> Void)
  /// Returns the passed in boolean asynchronously.
  func echoAsyncNullable(_ aBool: Bool?, completion: @escaping (Result<Bool?, Error>) -> Void)
  /// Returns the passed string asynchronously.
  func echoAsyncNullable(_ aString: String?, completion: @escaping (Result<String?, Error>) -> Void)
  /// Returns the passed in Uint8List asynchronously.
  func echoAsyncNullable(
    _ aUint8List: FlutterStandardTypedData?,
    completion: @escaping (Result<FlutterStandardTypedData?, Error>) -> Void)
  /// Returns the passed in generic Object asynchronously.
  func echoAsyncNullable(_ anObject: Any?, completion: @escaping (Result<Any?, Error>) -> Void)
  /// Returns the passed list, to test asynchronous serialization and deserialization.
  func echoAsyncNullable(_ list: [Any?]?, completion: @escaping (Result<[Any?]?, Error>) -> Void)
  /// Returns the passed list, to test asynchronous serialization and deserialization.
  func echoAsyncNullable(
    enumList: [AnEnum?]?, completion: @escaping (Result<[AnEnum?]?, Error>) -> Void)
  /// Returns the passed list, to test asynchronous serialization and deserialization.
  func echoAsyncNullable(
    classList: [AllNullableTypes?]?,
    completion: @escaping (Result<[AllNullableTypes?]?, Error>) -> Void)
  /// Returns the passed map, to test asynchronous serialization and deserialization.
  func echoAsyncNullable(
    _ map: [AnyHashable?: Any?]?,
    completion: @escaping (Result<[AnyHashable?: Any?]?, Error>) -> Void)
  /// Returns the passed map, to test asynchronous serialization and deserialization.
  func echoAsyncNullable(
    stringMap: [String?: String?]?,
    completion: @escaping (Result<[String?: String?]?, Error>) -> Void)
  /// Returns the passed map, to test asynchronous serialization and deserialization.
  func echoAsyncNullable(
    intMap: [Int64?: Int64?]?, completion: @escaping (Result<[Int64?: Int64?]?, Error>) -> Void)
  /// Returns the passed map, to test asynchronous serialization and deserialization.
  func echoAsyncNullable(
    enumMap: [AnEnum?: AnEnum?]?, completion: @escaping (Result<[AnEnum?: AnEnum?]?, Error>) -> Void
  )
  /// Returns the passed map, to test asynchronous serialization and deserialization.
  func echoAsyncNullable(
    classMap: [Int64?: AllNullableTypes?]?,
    completion: @escaping (Result<[Int64?: AllNullableTypes?]?, Error>) -> Void)
  /// Returns the passed enum, to test asynchronous serialization and deserialization.
  func echoAsyncNullable(_ anEnum: AnEnum?, completion: @escaping (Result<AnEnum?, Error>) -> Void)
  /// Returns the passed enum, to test asynchronous serialization and deserialization.
  func echoAsyncNullable(
    _ anotherEnum: AnotherEnum?, completion: @escaping (Result<AnotherEnum?, Error>) -> Void)
  /// Returns true if the handler is run on a main thread, which should be
  /// true since there is no TaskQueue annotation.
  func defaultIsMainThread() throws -> Bool
  /// Returns true if the handler is run on a non-main thread, which should be
  /// true for any platform with TaskQueue support.
  func taskQueueIsBackgroundThread() throws -> Bool
  func callFlutterNoop(completion: @escaping (Result<Void, Error>) -> Void)
  func callFlutterThrowError(completion: @escaping (Result<Any?, Error>) -> Void)
  func callFlutterThrowErrorFromVoid(completion: @escaping (Result<Void, Error>) -> Void)
  func callFlutterEcho(
    _ everything: AllTypes, completion: @escaping (Result<AllTypes, Error>) -> Void)
  func callFlutterEcho(
    _ everything: AllNullableTypes?,
    completion: @escaping (Result<AllNullableTypes?, Error>) -> Void)
  func callFlutterSendMultipleNullableTypes(
    aBool aNullableBool: Bool?, anInt aNullableInt: Int64?, aString aNullableString: String?,
    completion: @escaping (Result<AllNullableTypes, Error>) -> Void)
  func callFlutterEcho(
    _ everything: AllNullableTypesWithoutRecursion?,
    completion: @escaping (Result<AllNullableTypesWithoutRecursion?, Error>) -> Void)
  func callFlutterSendMultipleNullableTypesWithoutRecursion(
    aBool aNullableBool: Bool?, anInt aNullableInt: Int64?, aString aNullableString: String?,
    completion: @escaping (Result<AllNullableTypesWithoutRecursion, Error>) -> Void)
  func callFlutterEcho(_ aBool: Bool, completion: @escaping (Result<Bool, Error>) -> Void)
  func callFlutterEcho(_ anInt: Int64, completion: @escaping (Result<Int64, Error>) -> Void)
  func callFlutterEcho(_ aDouble: Double, completion: @escaping (Result<Double, Error>) -> Void)
  func callFlutterEcho(_ aString: String, completion: @escaping (Result<String, Error>) -> Void)
  func callFlutterEcho(
    _ list: FlutterStandardTypedData,
    completion: @escaping (Result<FlutterStandardTypedData, Error>) -> Void)
  func callFlutterEcho(_ list: [Any?], completion: @escaping (Result<[Any?], Error>) -> Void)
  func callFlutterEcho(
    enumList: [AnEnum?], completion: @escaping (Result<[AnEnum?], Error>) -> Void)
  func callFlutterEcho(
    classList: [AllNullableTypes?],
    completion: @escaping (Result<[AllNullableTypes?], Error>) -> Void)
  func callFlutterEchoNonNull(
    enumList: [AnEnum], completion: @escaping (Result<[AnEnum], Error>) -> Void)
  func callFlutterEchoNonNull(
    classList: [AllNullableTypes], completion: @escaping (Result<[AllNullableTypes], Error>) -> Void
  )
  func callFlutterEcho(
    _ map: [AnyHashable?: Any?], completion: @escaping (Result<[AnyHashable?: Any?], Error>) -> Void
  )
  func callFlutterEcho(
    stringMap: [String?: String?], completion: @escaping (Result<[String?: String?], Error>) -> Void
  )
  func callFlutterEcho(
    intMap: [Int64?: Int64?], completion: @escaping (Result<[Int64?: Int64?], Error>) -> Void)
  func callFlutterEcho(
    enumMap: [AnEnum?: AnEnum?], completion: @escaping (Result<[AnEnum?: AnEnum?], Error>) -> Void)
  func callFlutterEcho(
    classMap: [Int64?: AllNullableTypes?],
    completion: @escaping (Result<[Int64?: AllNullableTypes?], Error>) -> Void)
  func callFlutterEchoNonNull(
    stringMap: [String: String], completion: @escaping (Result<[String: String], Error>) -> Void)
  func callFlutterEchoNonNull(
    intMap: [Int64: Int64], completion: @escaping (Result<[Int64: Int64], Error>) -> Void)
  func callFlutterEchoNonNull(
    enumMap: [AnEnum: AnEnum], completion: @escaping (Result<[AnEnum: AnEnum], Error>) -> Void)
  func callFlutterEchoNonNull(
    classMap: [Int64: AllNullableTypes],
    completion: @escaping (Result<[Int64: AllNullableTypes], Error>) -> Void)
  func callFlutterEcho(_ anEnum: AnEnum, completion: @escaping (Result<AnEnum, Error>) -> Void)
  func callFlutterEcho(
    _ anotherEnum: AnotherEnum, completion: @escaping (Result<AnotherEnum, Error>) -> Void)
  func callFlutterEchoNullable(_ aBool: Bool?, completion: @escaping (Result<Bool?, Error>) -> Void)
  func callFlutterEchoNullable(
    _ anInt: Int64?, completion: @escaping (Result<Int64?, Error>) -> Void)
  func callFlutterEchoNullable(
    _ aDouble: Double?, completion: @escaping (Result<Double?, Error>) -> Void)
  func callFlutterEchoNullable(
    _ aString: String?, completion: @escaping (Result<String?, Error>) -> Void)
  func callFlutterEchoNullable(
    _ list: FlutterStandardTypedData?,
    completion: @escaping (Result<FlutterStandardTypedData?, Error>) -> Void)
  func callFlutterEchoNullable(
    _ list: [Any?]?, completion: @escaping (Result<[Any?]?, Error>) -> Void)
  func callFlutterEchoNullable(
    enumList: [AnEnum?]?, completion: @escaping (Result<[AnEnum?]?, Error>) -> Void)
  func callFlutterEchoNullable(
    classList: [AllNullableTypes?]?,
    completion: @escaping (Result<[AllNullableTypes?]?, Error>) -> Void)
  func callFlutterEchoNullableNonNull(
    enumList: [AnEnum]?, completion: @escaping (Result<[AnEnum]?, Error>) -> Void)
  func callFlutterEchoNullableNonNull(
    classList: [AllNullableTypes]?,
    completion: @escaping (Result<[AllNullableTypes]?, Error>) -> Void)
  func callFlutterEchoNullable(
    _ map: [AnyHashable?: Any?]?,
    completion: @escaping (Result<[AnyHashable?: Any?]?, Error>) -> Void)
  func callFlutterEchoNullable(
    stringMap: [String?: String?]?,
    completion: @escaping (Result<[String?: String?]?, Error>) -> Void)
  func callFlutterEchoNullable(
    intMap: [Int64?: Int64?]?, completion: @escaping (Result<[Int64?: Int64?]?, Error>) -> Void)
  func callFlutterEchoNullable(
    enumMap: [AnEnum?: AnEnum?]?, completion: @escaping (Result<[AnEnum?: AnEnum?]?, Error>) -> Void
  )
  func callFlutterEchoNullable(
    classMap: [Int64?: AllNullableTypes?]?,
    completion: @escaping (Result<[Int64?: AllNullableTypes?]?, Error>) -> Void)
  func callFlutterEchoNullableNonNull(
    stringMap: [String: String]?, completion: @escaping (Result<[String: String]?, Error>) -> Void)
  func callFlutterEchoNullableNonNull(
    intMap: [Int64: Int64]?, completion: @escaping (Result<[Int64: Int64]?, Error>) -> Void)
  func callFlutterEchoNullableNonNull(
    enumMap: [AnEnum: AnEnum]?, completion: @escaping (Result<[AnEnum: AnEnum]?, Error>) -> Void)
  func callFlutterEchoNullableNonNull(
    classMap: [Int64: AllNullableTypes]?,
    completion: @escaping (Result<[Int64: AllNullableTypes]?, Error>) -> Void)
  func callFlutterEchoNullable(
    _ anEnum: AnEnum?, completion: @escaping (Result<AnEnum?, Error>) -> Void)
  func callFlutterEchoNullable(
    _ anotherEnum: AnotherEnum?, completion: @escaping (Result<AnotherEnum?, Error>) -> Void)
  func callFlutterSmallApiEcho(
    _ aString: String, completion: @escaping (Result<String, Error>) -> Void)
}

/// Generated setup class from Pigeon to handle messages through the `binaryMessenger`.
class HostIntegrationCoreApiSetup {
  static var codec: FlutterStandardMessageCodec { CoreTestsPigeonCodec.shared }
  /// Sets up an instance of `HostIntegrationCoreApi` to handle messages through the `binaryMessenger`.
  static func setUp(
    binaryMessenger: FlutterBinaryMessenger, api: HostIntegrationCoreApi?,
    messageChannelSuffix: String = ""
  ) {
    let channelSuffix = messageChannelSuffix.count > 0 ? ".\(messageChannelSuffix)" : ""
    #if os(iOS)
      let taskQueue = binaryMessenger.makeBackgroundTaskQueue?()
    #else
      let taskQueue: FlutterTaskQueue? = nil
    #endif
    /// A no-op function taking no arguments and returning no value, to sanity
    /// test basic calling.
    let noopChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.noop\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      noopChannel.setMessageHandler { _, reply in
        do {
          try api.noop()
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      noopChannel.setMessageHandler(nil)
    }
    /// Returns the passed object, to test serialization and deserialization.
    let echoAllTypesChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAllTypes\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAllTypesChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let everythingArg = args[0] as! AllTypes
        do {
          let result = try api.echo(everythingArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoAllTypesChannel.setMessageHandler(nil)
    }
    /// Returns an error, to test error handling.
    let throwErrorChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.throwError\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      throwErrorChannel.setMessageHandler { _, reply in
        do {
          let result = try api.throwError()
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      throwErrorChannel.setMessageHandler(nil)
    }
    /// Returns an error from a void function, to test error handling.
    let throwErrorFromVoidChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.throwErrorFromVoid\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      throwErrorFromVoidChannel.setMessageHandler { _, reply in
        do {
          try api.throwErrorFromVoid()
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      throwErrorFromVoidChannel.setMessageHandler(nil)
    }
    /// Returns a Flutter error, to test error handling.
    let throwFlutterErrorChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.throwFlutterError\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      throwFlutterErrorChannel.setMessageHandler { _, reply in
        do {
          let result = try api.throwFlutterError()
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      throwFlutterErrorChannel.setMessageHandler(nil)
    }
    /// Returns passed in int.
    let echoIntChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoInt\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoIntChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let anIntArg = args[0] as! Int64
        do {
          let result = try api.echo(anIntArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoIntChannel.setMessageHandler(nil)
    }
    /// Returns passed in double.
    let echoDoubleChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoDouble\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoDoubleChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aDoubleArg = args[0] as! Double
        do {
          let result = try api.echo(aDoubleArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoDoubleChannel.setMessageHandler(nil)
    }
    /// Returns the passed in boolean.
    let echoBoolChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoBool\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoBoolChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aBoolArg = args[0] as! Bool
        do {
          let result = try api.echo(aBoolArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoBoolChannel.setMessageHandler(nil)
    }
    /// Returns the passed in string.
    let echoStringChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoString\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoStringChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aStringArg = args[0] as! String
        do {
          let result = try api.echo(aStringArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoStringChannel.setMessageHandler(nil)
    }
    /// Returns the passed in Uint8List.
    let echoUint8ListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoUint8List\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoUint8ListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aUint8ListArg = args[0] as! FlutterStandardTypedData
        do {
          let result = try api.echo(aUint8ListArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoUint8ListChannel.setMessageHandler(nil)
    }
    /// Returns the passed in generic Object.
    let echoObjectChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoObject\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoObjectChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let anObjectArg = args[0]!
        do {
          let result = try api.echo(anObjectArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoObjectChannel.setMessageHandler(nil)
    }
    /// Returns the passed list, to test serialization and deserialization.
    let echoListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let listArg = args[0] as! [Any?]
        do {
          let result = try api.echo(listArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoListChannel.setMessageHandler(nil)
    }
    /// Returns the passed list, to test serialization and deserialization.
    let echoEnumListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoEnumList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoEnumListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let enumListArg = args[0] as! [AnEnum?]
        do {
          let result = try api.echo(enumList: enumListArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoEnumListChannel.setMessageHandler(nil)
    }
    /// Returns the passed list, to test serialization and deserialization.
    let echoClassListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoClassList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoClassListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let classListArg = args[0] as! [AllNullableTypes?]
        do {
          let result = try api.echo(classList: classListArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoClassListChannel.setMessageHandler(nil)
    }
    /// Returns the passed list, to test serialization and deserialization.
    let echoNonNullEnumListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNonNullEnumList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNonNullEnumListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let enumListArg = args[0] as! [AnEnum]
        do {
          let result = try api.echoNonNull(enumList: enumListArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNonNullEnumListChannel.setMessageHandler(nil)
    }
    /// Returns the passed list, to test serialization and deserialization.
    let echoNonNullClassListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNonNullClassList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNonNullClassListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let classListArg = args[0] as! [AllNullableTypes]
        do {
          let result = try api.echoNonNull(classList: classListArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNonNullClassListChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test serialization and deserialization.
    let echoMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let mapArg = args[0] as! [AnyHashable?: Any?]
        do {
          let result = try api.echo(mapArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test serialization and deserialization.
    let echoStringMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoStringMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoStringMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let stringMapArg = args[0] as! [String?: String?]
        do {
          let result = try api.echo(stringMap: stringMapArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoStringMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test serialization and deserialization.
    let echoIntMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoIntMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoIntMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let intMapArg = args[0] as! [Int64?: Int64?]
        do {
          let result = try api.echo(intMap: intMapArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoIntMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test serialization and deserialization.
    let echoEnumMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoEnumMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoEnumMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let enumMapArg = args[0] as? [AnEnum?: AnEnum?]
        do {
          let result = try api.echo(enumMap: enumMapArg!)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoEnumMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test serialization and deserialization.
    let echoClassMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoClassMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoClassMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let classMapArg = args[0] as! [Int64?: AllNullableTypes?]
        do {
          let result = try api.echo(classMap: classMapArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoClassMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test serialization and deserialization.
    let echoNonNullStringMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNonNullStringMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNonNullStringMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let stringMapArg = args[0] as! [String: String]
        do {
          let result = try api.echoNonNull(stringMap: stringMapArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNonNullStringMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test serialization and deserialization.
    let echoNonNullIntMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNonNullIntMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNonNullIntMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let intMapArg = args[0] as! [Int64: Int64]
        do {
          let result = try api.echoNonNull(intMap: intMapArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNonNullIntMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test serialization and deserialization.
    let echoNonNullEnumMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNonNullEnumMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNonNullEnumMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let enumMapArg = args[0] as? [AnEnum: AnEnum]
        do {
          let result = try api.echoNonNull(enumMap: enumMapArg!)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNonNullEnumMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test serialization and deserialization.
    let echoNonNullClassMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNonNullClassMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNonNullClassMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let classMapArg = args[0] as! [Int64: AllNullableTypes]
        do {
          let result = try api.echoNonNull(classMap: classMapArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNonNullClassMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed class to test nested class serialization and deserialization.
    let echoClassWrapperChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoClassWrapper\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoClassWrapperChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let wrapperArg = args[0] as! AllClassesWrapper
        do {
          let result = try api.echo(wrapperArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoClassWrapperChannel.setMessageHandler(nil)
    }
    /// Returns the passed enum to test serialization and deserialization.
    let echoEnumChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoEnum\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoEnumChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let anEnumArg = args[0] as! AnEnum
        do {
          let result = try api.echo(anEnumArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoEnumChannel.setMessageHandler(nil)
    }
    /// Returns the passed enum to test serialization and deserialization.
    let echoAnotherEnumChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAnotherEnum\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAnotherEnumChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let anotherEnumArg = args[0] as! AnotherEnum
        do {
          let result = try api.echo(anotherEnumArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoAnotherEnumChannel.setMessageHandler(nil)
    }
    /// Returns the default string.
    let echoNamedDefaultStringChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNamedDefaultString\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNamedDefaultStringChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aStringArg = args[0] as! String
        do {
          let result = try api.echoNamedDefault(aStringArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNamedDefaultStringChannel.setMessageHandler(nil)
    }
    /// Returns passed in double.
    let echoOptionalDefaultDoubleChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoOptionalDefaultDouble\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoOptionalDefaultDoubleChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aDoubleArg = args[0] as! Double
        do {
          let result = try api.echoOptionalDefault(aDoubleArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoOptionalDefaultDoubleChannel.setMessageHandler(nil)
    }
    /// Returns passed in int.
    let echoRequiredIntChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoRequiredInt\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoRequiredIntChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let anIntArg = args[0] as! Int64
        do {
          let result = try api.echoRequired(anIntArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoRequiredIntChannel.setMessageHandler(nil)
    }
    /// Returns the passed object, to test serialization and deserialization.
    let echoAllNullableTypesChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAllNullableTypes\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAllNullableTypesChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let everythingArg: AllNullableTypes? = nilOrValue(args[0])
        do {
          let result = try api.echo(everythingArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoAllNullableTypesChannel.setMessageHandler(nil)
    }
    /// Returns the passed object, to test serialization and deserialization.
    let echoAllNullableTypesWithoutRecursionChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAllNullableTypesWithoutRecursion\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAllNullableTypesWithoutRecursionChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let everythingArg: AllNullableTypesWithoutRecursion? = nilOrValue(args[0])
        do {
          let result = try api.echo(everythingArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoAllNullableTypesWithoutRecursionChannel.setMessageHandler(nil)
    }
    /// Returns the inner `aString` value from the wrapped object, to test
    /// sending of nested objects.
    let extractNestedNullableStringChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.extractNestedNullableString\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      extractNestedNullableStringChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let wrapperArg = args[0] as! AllClassesWrapper
        do {
          let result = try api.extractNestedNullableString(from: wrapperArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      extractNestedNullableStringChannel.setMessageHandler(nil)
    }
    /// Returns the inner `aString` value from the wrapped object, to test
    /// sending of nested objects.
    let createNestedNullableStringChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.createNestedNullableString\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      createNestedNullableStringChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let nullableStringArg: String? = nilOrValue(args[0])
        do {
          let result = try api.createNestedObject(with: nullableStringArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      createNestedNullableStringChannel.setMessageHandler(nil)
    }
    /// Returns passed in arguments of multiple types.
    let sendMultipleNullableTypesChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.sendMultipleNullableTypes\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      sendMultipleNullableTypesChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aNullableBoolArg: Bool? = nilOrValue(args[0])
        let aNullableIntArg: Int64? = nilOrValue(args[1])
        let aNullableStringArg: String? = nilOrValue(args[2])
        do {
          let result = try api.sendMultipleNullableTypes(
            aBool: aNullableBoolArg, anInt: aNullableIntArg, aString: aNullableStringArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      sendMultipleNullableTypesChannel.setMessageHandler(nil)
    }
    /// Returns passed in arguments of multiple types.
    let sendMultipleNullableTypesWithoutRecursionChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.sendMultipleNullableTypesWithoutRecursion\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      sendMultipleNullableTypesWithoutRecursionChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aNullableBoolArg: Bool? = nilOrValue(args[0])
        let aNullableIntArg: Int64? = nilOrValue(args[1])
        let aNullableStringArg: String? = nilOrValue(args[2])
        do {
          let result = try api.sendMultipleNullableTypesWithoutRecursion(
            aBool: aNullableBoolArg, anInt: aNullableIntArg, aString: aNullableStringArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      sendMultipleNullableTypesWithoutRecursionChannel.setMessageHandler(nil)
    }
    /// Returns passed in int.
    let echoNullableIntChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableInt\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableIntChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aNullableIntArg: Int64? = nilOrValue(args[0])
        do {
          let result = try api.echo(aNullableIntArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableIntChannel.setMessageHandler(nil)
    }
    /// Returns passed in double.
    let echoNullableDoubleChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableDouble\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableDoubleChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aNullableDoubleArg: Double? = nilOrValue(args[0])
        do {
          let result = try api.echo(aNullableDoubleArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableDoubleChannel.setMessageHandler(nil)
    }
    /// Returns the passed in boolean.
    let echoNullableBoolChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableBool\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableBoolChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aNullableBoolArg: Bool? = nilOrValue(args[0])
        do {
          let result = try api.echo(aNullableBoolArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableBoolChannel.setMessageHandler(nil)
    }
    /// Returns the passed in string.
    let echoNullableStringChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableString\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableStringChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aNullableStringArg: String? = nilOrValue(args[0])
        do {
          let result = try api.echo(aNullableStringArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableStringChannel.setMessageHandler(nil)
    }
    /// Returns the passed in Uint8List.
    let echoNullableUint8ListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableUint8List\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableUint8ListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aNullableUint8ListArg: FlutterStandardTypedData? = nilOrValue(args[0])
        do {
          let result = try api.echo(aNullableUint8ListArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableUint8ListChannel.setMessageHandler(nil)
    }
    /// Returns the passed in generic Object.
    let echoNullableObjectChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableObject\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableObjectChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aNullableObjectArg: Any? = args[0]
        do {
          let result = try api.echo(aNullableObjectArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableObjectChannel.setMessageHandler(nil)
    }
    /// Returns the passed list, to test serialization and deserialization.
    let echoNullableListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aNullableListArg: [Any?]? = nilOrValue(args[0])
        do {
          let result = try api.echoNullable(aNullableListArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableListChannel.setMessageHandler(nil)
    }
    /// Returns the passed list, to test serialization and deserialization.
    let echoNullableEnumListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableEnumList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableEnumListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let enumListArg: [AnEnum?]? = nilOrValue(args[0])
        do {
          let result = try api.echoNullable(enumList: enumListArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableEnumListChannel.setMessageHandler(nil)
    }
    /// Returns the passed list, to test serialization and deserialization.
    let echoNullableClassListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableClassList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableClassListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let classListArg: [AllNullableTypes?]? = nilOrValue(args[0])
        do {
          let result = try api.echoNullable(classList: classListArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableClassListChannel.setMessageHandler(nil)
    }
    /// Returns the passed list, to test serialization and deserialization.
    let echoNullableNonNullEnumListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableNonNullEnumList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableNonNullEnumListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let enumListArg: [AnEnum]? = nilOrValue(args[0])
        do {
          let result = try api.echoNullableNonNull(enumList: enumListArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableNonNullEnumListChannel.setMessageHandler(nil)
    }
    /// Returns the passed list, to test serialization and deserialization.
    let echoNullableNonNullClassListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableNonNullClassList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableNonNullClassListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let classListArg: [AllNullableTypes]? = nilOrValue(args[0])
        do {
          let result = try api.echoNullableNonNull(classList: classListArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableNonNullClassListChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test serialization and deserialization.
    let echoNullableMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let mapArg: [AnyHashable?: Any?]? = nilOrValue(args[0])
        do {
          let result = try api.echoNullable(mapArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test serialization and deserialization.
    let echoNullableStringMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableStringMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableStringMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let stringMapArg: [String?: String?]? = nilOrValue(args[0])
        do {
          let result = try api.echoNullable(stringMap: stringMapArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableStringMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test serialization and deserialization.
    let echoNullableIntMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableIntMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableIntMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let intMapArg: [Int64?: Int64?]? = nilOrValue(args[0])
        do {
          let result = try api.echoNullable(intMap: intMapArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableIntMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test serialization and deserialization.
    let echoNullableEnumMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableEnumMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableEnumMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let enumMapArg: [AnEnum?: AnEnum?]? = args[0] as? [AnEnum?: AnEnum?]
        do {
          let result = try api.echoNullable(enumMap: enumMapArg!)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableEnumMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test serialization and deserialization.
    let echoNullableClassMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableClassMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableClassMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let classMapArg: [Int64?: AllNullableTypes?]? = nilOrValue(args[0])
        do {
          let result = try api.echoNullable(classMap: classMapArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableClassMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test serialization and deserialization.
    let echoNullableNonNullStringMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableNonNullStringMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableNonNullStringMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let stringMapArg: [String: String]? = nilOrValue(args[0])
        do {
          let result = try api.echoNullableNonNull(stringMap: stringMapArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableNonNullStringMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test serialization and deserialization.
    let echoNullableNonNullIntMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableNonNullIntMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableNonNullIntMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let intMapArg: [Int64: Int64]? = nilOrValue(args[0])
        do {
          let result = try api.echoNullableNonNull(intMap: intMapArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableNonNullIntMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test serialization and deserialization.
    let echoNullableNonNullEnumMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableNonNullEnumMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableNonNullEnumMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let enumMapArg: [AnEnum: AnEnum]? = args[0] as? [AnEnum: AnEnum]
        do {
          let result = try api.echoNullableNonNull(enumMap: enumMapArg!)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableNonNullEnumMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test serialization and deserialization.
    let echoNullableNonNullClassMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableNonNullClassMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableNonNullClassMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let classMapArg: [Int64: AllNullableTypes]? = nilOrValue(args[0])
        do {
          let result = try api.echoNullableNonNull(classMap: classMapArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableNonNullClassMapChannel.setMessageHandler(nil)
    }
    let echoNullableEnumChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableEnum\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableEnumChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let anEnumArg: AnEnum? = nilOrValue(args[0])
        do {
          let result = try api.echoNullable(anEnumArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableEnumChannel.setMessageHandler(nil)
    }
    let echoAnotherNullableEnumChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAnotherNullableEnum\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAnotherNullableEnumChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let anotherEnumArg: AnotherEnum? = nilOrValue(args[0])
        do {
          let result = try api.echoNullable(anotherEnumArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoAnotherNullableEnumChannel.setMessageHandler(nil)
    }
    /// Returns passed in int.
    let echoOptionalNullableIntChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoOptionalNullableInt\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoOptionalNullableIntChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aNullableIntArg: Int64? = nilOrValue(args[0])
        do {
          let result = try api.echoOptional(aNullableIntArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoOptionalNullableIntChannel.setMessageHandler(nil)
    }
    /// Returns the passed in string.
    let echoNamedNullableStringChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNamedNullableString\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNamedNullableStringChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aNullableStringArg: String? = nilOrValue(args[0])
        do {
          let result = try api.echoNamed(aNullableStringArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNamedNullableStringChannel.setMessageHandler(nil)
    }
    /// A no-op function taking no arguments and returning no value, to sanity
    /// test basic asynchronous calling.
    let noopAsyncChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.noopAsync\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      noopAsyncChannel.setMessageHandler { _, reply in
        api.noopAsync { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      noopAsyncChannel.setMessageHandler(nil)
    }
    /// Returns passed in int asynchronously.
    let echoAsyncIntChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncInt\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncIntChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let anIntArg = args[0] as! Int64
        api.echoAsync(anIntArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncIntChannel.setMessageHandler(nil)
    }
    /// Returns passed in double asynchronously.
    let echoAsyncDoubleChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncDouble\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncDoubleChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aDoubleArg = args[0] as! Double
        api.echoAsync(aDoubleArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncDoubleChannel.setMessageHandler(nil)
    }
    /// Returns the passed in boolean asynchronously.
    let echoAsyncBoolChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncBool\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncBoolChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aBoolArg = args[0] as! Bool
        api.echoAsync(aBoolArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncBoolChannel.setMessageHandler(nil)
    }
    /// Returns the passed string asynchronously.
    let echoAsyncStringChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncString\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncStringChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aStringArg = args[0] as! String
        api.echoAsync(aStringArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncStringChannel.setMessageHandler(nil)
    }
    /// Returns the passed in Uint8List asynchronously.
    let echoAsyncUint8ListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncUint8List\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncUint8ListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aUint8ListArg = args[0] as! FlutterStandardTypedData
        api.echoAsync(aUint8ListArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncUint8ListChannel.setMessageHandler(nil)
    }
    /// Returns the passed in generic Object asynchronously.
    let echoAsyncObjectChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncObject\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncObjectChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let anObjectArg = args[0]!
        api.echoAsync(anObjectArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncObjectChannel.setMessageHandler(nil)
    }
    /// Returns the passed list, to test asynchronous serialization and deserialization.
    let echoAsyncListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let listArg = args[0] as! [Any?]
        api.echoAsync(listArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncListChannel.setMessageHandler(nil)
    }
    /// Returns the passed list, to test asynchronous serialization and deserialization.
    let echoAsyncEnumListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncEnumList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncEnumListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let enumListArg = args[0] as! [AnEnum?]
        api.echoAsync(enumList: enumListArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncEnumListChannel.setMessageHandler(nil)
    }
    /// Returns the passed list, to test asynchronous serialization and deserialization.
    let echoAsyncClassListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncClassList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncClassListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let classListArg = args[0] as! [AllNullableTypes?]
        api.echoAsync(classList: classListArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncClassListChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test asynchronous serialization and deserialization.
    let echoAsyncMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let mapArg = args[0] as! [AnyHashable?: Any?]
        api.echoAsync(mapArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test asynchronous serialization and deserialization.
    let echoAsyncStringMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncStringMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncStringMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let stringMapArg = args[0] as! [String?: String?]
        api.echoAsync(stringMap: stringMapArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncStringMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test asynchronous serialization and deserialization.
    let echoAsyncIntMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncIntMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncIntMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let intMapArg = args[0] as! [Int64?: Int64?]
        api.echoAsync(intMap: intMapArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncIntMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test asynchronous serialization and deserialization.
    let echoAsyncEnumMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncEnumMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncEnumMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let enumMapArg = args[0] as? [AnEnum?: AnEnum?]
        api.echoAsync(enumMap: enumMapArg!) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncEnumMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test asynchronous serialization and deserialization.
    let echoAsyncClassMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncClassMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncClassMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let classMapArg = args[0] as! [Int64?: AllNullableTypes?]
        api.echoAsync(classMap: classMapArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncClassMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed enum, to test asynchronous serialization and deserialization.
    let echoAsyncEnumChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncEnum\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncEnumChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let anEnumArg = args[0] as! AnEnum
        api.echoAsync(anEnumArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncEnumChannel.setMessageHandler(nil)
    }
    /// Returns the passed enum, to test asynchronous serialization and deserialization.
    let echoAnotherAsyncEnumChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAnotherAsyncEnum\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAnotherAsyncEnumChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let anotherEnumArg = args[0] as! AnotherEnum
        api.echoAsync(anotherEnumArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAnotherAsyncEnumChannel.setMessageHandler(nil)
    }
    /// Responds with an error from an async function returning a value.
    let throwAsyncErrorChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.throwAsyncError\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      throwAsyncErrorChannel.setMessageHandler { _, reply in
        api.throwAsyncError { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      throwAsyncErrorChannel.setMessageHandler(nil)
    }
    /// Responds with an error from an async void function.
    let throwAsyncErrorFromVoidChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.throwAsyncErrorFromVoid\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      throwAsyncErrorFromVoidChannel.setMessageHandler { _, reply in
        api.throwAsyncErrorFromVoid { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      throwAsyncErrorFromVoidChannel.setMessageHandler(nil)
    }
    /// Responds with a Flutter error from an async function returning a value.
    let throwAsyncFlutterErrorChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.throwAsyncFlutterError\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      throwAsyncFlutterErrorChannel.setMessageHandler { _, reply in
        api.throwAsyncFlutterError { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      throwAsyncFlutterErrorChannel.setMessageHandler(nil)
    }
    /// Returns the passed object, to test async serialization and deserialization.
    let echoAsyncAllTypesChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncAllTypes\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncAllTypesChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let everythingArg = args[0] as! AllTypes
        api.echoAsync(everythingArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncAllTypesChannel.setMessageHandler(nil)
    }
    /// Returns the passed object, to test serialization and deserialization.
    let echoAsyncNullableAllNullableTypesChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableAllNullableTypes\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableAllNullableTypesChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let everythingArg: AllNullableTypes? = nilOrValue(args[0])
        api.echoAsync(everythingArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableAllNullableTypesChannel.setMessageHandler(nil)
    }
    /// Returns the passed object, to test serialization and deserialization.
    let echoAsyncNullableAllNullableTypesWithoutRecursionChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableAllNullableTypesWithoutRecursion\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableAllNullableTypesWithoutRecursionChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let everythingArg: AllNullableTypesWithoutRecursion? = nilOrValue(args[0])
        api.echoAsync(everythingArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableAllNullableTypesWithoutRecursionChannel.setMessageHandler(nil)
    }
    /// Returns passed in int asynchronously.
    let echoAsyncNullableIntChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableInt\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableIntChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let anIntArg: Int64? = nilOrValue(args[0])
        api.echoAsyncNullable(anIntArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableIntChannel.setMessageHandler(nil)
    }
    /// Returns passed in double asynchronously.
    let echoAsyncNullableDoubleChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableDouble\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableDoubleChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aDoubleArg: Double? = nilOrValue(args[0])
        api.echoAsyncNullable(aDoubleArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableDoubleChannel.setMessageHandler(nil)
    }
    /// Returns the passed in boolean asynchronously.
    let echoAsyncNullableBoolChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableBool\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableBoolChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aBoolArg: Bool? = nilOrValue(args[0])
        api.echoAsyncNullable(aBoolArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableBoolChannel.setMessageHandler(nil)
    }
    /// Returns the passed string asynchronously.
    let echoAsyncNullableStringChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableString\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableStringChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aStringArg: String? = nilOrValue(args[0])
        api.echoAsyncNullable(aStringArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableStringChannel.setMessageHandler(nil)
    }
    /// Returns the passed in Uint8List asynchronously.
    let echoAsyncNullableUint8ListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableUint8List\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableUint8ListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aUint8ListArg: FlutterStandardTypedData? = nilOrValue(args[0])
        api.echoAsyncNullable(aUint8ListArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableUint8ListChannel.setMessageHandler(nil)
    }
    /// Returns the passed in generic Object asynchronously.
    let echoAsyncNullableObjectChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableObject\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableObjectChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let anObjectArg: Any? = args[0]
        api.echoAsyncNullable(anObjectArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableObjectChannel.setMessageHandler(nil)
    }
    /// Returns the passed list, to test asynchronous serialization and deserialization.
    let echoAsyncNullableListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let listArg: [Any?]? = nilOrValue(args[0])
        api.echoAsyncNullable(listArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableListChannel.setMessageHandler(nil)
    }
    /// Returns the passed list, to test asynchronous serialization and deserialization.
    let echoAsyncNullableEnumListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableEnumList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableEnumListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let enumListArg: [AnEnum?]? = nilOrValue(args[0])
        api.echoAsyncNullable(enumList: enumListArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableEnumListChannel.setMessageHandler(nil)
    }
    /// Returns the passed list, to test asynchronous serialization and deserialization.
    let echoAsyncNullableClassListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableClassList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableClassListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let classListArg: [AllNullableTypes?]? = nilOrValue(args[0])
        api.echoAsyncNullable(classList: classListArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableClassListChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test asynchronous serialization and deserialization.
    let echoAsyncNullableMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let mapArg: [AnyHashable?: Any?]? = nilOrValue(args[0])
        api.echoAsyncNullable(mapArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test asynchronous serialization and deserialization.
    let echoAsyncNullableStringMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableStringMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableStringMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let stringMapArg: [String?: String?]? = nilOrValue(args[0])
        api.echoAsyncNullable(stringMap: stringMapArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableStringMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test asynchronous serialization and deserialization.
    let echoAsyncNullableIntMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableIntMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableIntMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let intMapArg: [Int64?: Int64?]? = nilOrValue(args[0])
        api.echoAsyncNullable(intMap: intMapArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableIntMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test asynchronous serialization and deserialization.
    let echoAsyncNullableEnumMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableEnumMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableEnumMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let enumMapArg: [AnEnum?: AnEnum?]? = args[0] as? [AnEnum?: AnEnum?]
        api.echoAsyncNullable(enumMap: enumMapArg!) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableEnumMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed map, to test asynchronous serialization and deserialization.
    let echoAsyncNullableClassMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableClassMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableClassMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let classMapArg: [Int64?: AllNullableTypes?]? = nilOrValue(args[0])
        api.echoAsyncNullable(classMap: classMapArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableClassMapChannel.setMessageHandler(nil)
    }
    /// Returns the passed enum, to test asynchronous serialization and deserialization.
    let echoAsyncNullableEnumChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableEnum\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableEnumChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let anEnumArg: AnEnum? = nilOrValue(args[0])
        api.echoAsyncNullable(anEnumArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableEnumChannel.setMessageHandler(nil)
    }
    /// Returns the passed enum, to test asynchronous serialization and deserialization.
    let echoAnotherAsyncNullableEnumChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAnotherAsyncNullableEnum\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAnotherAsyncNullableEnumChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let anotherEnumArg: AnotherEnum? = nilOrValue(args[0])
        api.echoAsyncNullable(anotherEnumArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAnotherAsyncNullableEnumChannel.setMessageHandler(nil)
    }
    /// Returns true if the handler is run on a main thread, which should be
    /// true since there is no TaskQueue annotation.
    let defaultIsMainThreadChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.defaultIsMainThread\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      defaultIsMainThreadChannel.setMessageHandler { _, reply in
        do {
          let result = try api.defaultIsMainThread()
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      defaultIsMainThreadChannel.setMessageHandler(nil)
    }
    /// Returns true if the handler is run on a non-main thread, which should be
    /// true for any platform with TaskQueue support.
    let taskQueueIsBackgroundThreadChannel =
      taskQueue == nil
      ? FlutterBasicMessageChannel(
        name:
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.taskQueueIsBackgroundThread\(channelSuffix)",
        binaryMessenger: binaryMessenger, codec: codec)
      : FlutterBasicMessageChannel(
        name:
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.taskQueueIsBackgroundThread\(channelSuffix)",
        binaryMessenger: binaryMessenger, codec: codec, taskQueue: taskQueue)
    if let api = api {
      taskQueueIsBackgroundThreadChannel.setMessageHandler { _, reply in
        do {
          let result = try api.taskQueueIsBackgroundThread()
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      taskQueueIsBackgroundThreadChannel.setMessageHandler(nil)
    }
    let callFlutterNoopChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterNoop\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterNoopChannel.setMessageHandler { _, reply in
        api.callFlutterNoop { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterNoopChannel.setMessageHandler(nil)
    }
    let callFlutterThrowErrorChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterThrowError\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterThrowErrorChannel.setMessageHandler { _, reply in
        api.callFlutterThrowError { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterThrowErrorChannel.setMessageHandler(nil)
    }
    let callFlutterThrowErrorFromVoidChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterThrowErrorFromVoid\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterThrowErrorFromVoidChannel.setMessageHandler { _, reply in
        api.callFlutterThrowErrorFromVoid { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterThrowErrorFromVoidChannel.setMessageHandler(nil)
    }
    let callFlutterEchoAllTypesChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoAllTypes\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoAllTypesChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let everythingArg = args[0] as! AllTypes
        api.callFlutterEcho(everythingArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoAllTypesChannel.setMessageHandler(nil)
    }
    let callFlutterEchoAllNullableTypesChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoAllNullableTypes\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoAllNullableTypesChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let everythingArg: AllNullableTypes? = nilOrValue(args[0])
        api.callFlutterEcho(everythingArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoAllNullableTypesChannel.setMessageHandler(nil)
    }
    let callFlutterSendMultipleNullableTypesChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterSendMultipleNullableTypes\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterSendMultipleNullableTypesChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aNullableBoolArg: Bool? = nilOrValue(args[0])
        let aNullableIntArg: Int64? = nilOrValue(args[1])
        let aNullableStringArg: String? = nilOrValue(args[2])
        api.callFlutterSendMultipleNullableTypes(
          aBool: aNullableBoolArg, anInt: aNullableIntArg, aString: aNullableStringArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterSendMultipleNullableTypesChannel.setMessageHandler(nil)
    }
    let callFlutterEchoAllNullableTypesWithoutRecursionChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoAllNullableTypesWithoutRecursion\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoAllNullableTypesWithoutRecursionChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let everythingArg: AllNullableTypesWithoutRecursion? = nilOrValue(args[0])
        api.callFlutterEcho(everythingArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoAllNullableTypesWithoutRecursionChannel.setMessageHandler(nil)
    }
    let callFlutterSendMultipleNullableTypesWithoutRecursionChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterSendMultipleNullableTypesWithoutRecursion\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterSendMultipleNullableTypesWithoutRecursionChannel.setMessageHandler {
        message, reply in
        let args = message as! [Any?]
        let aNullableBoolArg: Bool? = nilOrValue(args[0])
        let aNullableIntArg: Int64? = nilOrValue(args[1])
        let aNullableStringArg: String? = nilOrValue(args[2])
        api.callFlutterSendMultipleNullableTypesWithoutRecursion(
          aBool: aNullableBoolArg, anInt: aNullableIntArg, aString: aNullableStringArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterSendMultipleNullableTypesWithoutRecursionChannel.setMessageHandler(nil)
    }
    let callFlutterEchoBoolChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoBool\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoBoolChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aBoolArg = args[0] as! Bool
        api.callFlutterEcho(aBoolArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoBoolChannel.setMessageHandler(nil)
    }
    let callFlutterEchoIntChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoInt\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoIntChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let anIntArg = args[0] as! Int64
        api.callFlutterEcho(anIntArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoIntChannel.setMessageHandler(nil)
    }
    let callFlutterEchoDoubleChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoDouble\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoDoubleChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aDoubleArg = args[0] as! Double
        api.callFlutterEcho(aDoubleArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoDoubleChannel.setMessageHandler(nil)
    }
    let callFlutterEchoStringChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoString\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoStringChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aStringArg = args[0] as! String
        api.callFlutterEcho(aStringArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoStringChannel.setMessageHandler(nil)
    }
    let callFlutterEchoUint8ListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoUint8List\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoUint8ListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let listArg = args[0] as! FlutterStandardTypedData
        api.callFlutterEcho(listArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoUint8ListChannel.setMessageHandler(nil)
    }
    let callFlutterEchoListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let listArg = args[0] as! [Any?]
        api.callFlutterEcho(listArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoListChannel.setMessageHandler(nil)
    }
    let callFlutterEchoEnumListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoEnumList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoEnumListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let enumListArg = args[0] as! [AnEnum?]
        api.callFlutterEcho(enumList: enumListArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoEnumListChannel.setMessageHandler(nil)
    }
    let callFlutterEchoClassListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoClassList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoClassListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let classListArg = args[0] as! [AllNullableTypes?]
        api.callFlutterEcho(classList: classListArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoClassListChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNonNullEnumListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNonNullEnumList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNonNullEnumListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let enumListArg = args[0] as! [AnEnum]
        api.callFlutterEchoNonNull(enumList: enumListArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNonNullEnumListChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNonNullClassListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNonNullClassList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNonNullClassListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let classListArg = args[0] as! [AllNullableTypes]
        api.callFlutterEchoNonNull(classList: classListArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNonNullClassListChannel.setMessageHandler(nil)
    }
    let callFlutterEchoMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let mapArg = args[0] as! [AnyHashable?: Any?]
        api.callFlutterEcho(mapArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoMapChannel.setMessageHandler(nil)
    }
    let callFlutterEchoStringMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoStringMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoStringMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let stringMapArg = args[0] as! [String?: String?]
        api.callFlutterEcho(stringMap: stringMapArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoStringMapChannel.setMessageHandler(nil)
    }
    let callFlutterEchoIntMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoIntMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoIntMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let intMapArg = args[0] as! [Int64?: Int64?]
        api.callFlutterEcho(intMap: intMapArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoIntMapChannel.setMessageHandler(nil)
    }
    let callFlutterEchoEnumMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoEnumMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoEnumMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let enumMapArg = args[0] as? [AnEnum?: AnEnum?]
        api.callFlutterEcho(enumMap: enumMapArg!) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoEnumMapChannel.setMessageHandler(nil)
    }
    let callFlutterEchoClassMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoClassMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoClassMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let classMapArg = args[0] as! [Int64?: AllNullableTypes?]
        api.callFlutterEcho(classMap: classMapArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoClassMapChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNonNullStringMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNonNullStringMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNonNullStringMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let stringMapArg = args[0] as! [String: String]
        api.callFlutterEchoNonNull(stringMap: stringMapArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNonNullStringMapChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNonNullIntMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNonNullIntMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNonNullIntMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let intMapArg = args[0] as! [Int64: Int64]
        api.callFlutterEchoNonNull(intMap: intMapArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNonNullIntMapChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNonNullEnumMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNonNullEnumMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNonNullEnumMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let enumMapArg = args[0] as? [AnEnum: AnEnum]
        api.callFlutterEchoNonNull(enumMap: enumMapArg!) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNonNullEnumMapChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNonNullClassMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNonNullClassMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNonNullClassMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let classMapArg = args[0] as! [Int64: AllNullableTypes]
        api.callFlutterEchoNonNull(classMap: classMapArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNonNullClassMapChannel.setMessageHandler(nil)
    }
    let callFlutterEchoEnumChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoEnum\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoEnumChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let anEnumArg = args[0] as! AnEnum
        api.callFlutterEcho(anEnumArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoEnumChannel.setMessageHandler(nil)
    }
    let callFlutterEchoAnotherEnumChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoAnotherEnum\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoAnotherEnumChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let anotherEnumArg = args[0] as! AnotherEnum
        api.callFlutterEcho(anotherEnumArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoAnotherEnumChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableBoolChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableBool\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableBoolChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aBoolArg: Bool? = nilOrValue(args[0])
        api.callFlutterEchoNullable(aBoolArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableBoolChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableIntChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableInt\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableIntChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let anIntArg: Int64? = nilOrValue(args[0])
        api.callFlutterEchoNullable(anIntArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableIntChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableDoubleChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableDouble\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableDoubleChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aDoubleArg: Double? = nilOrValue(args[0])
        api.callFlutterEchoNullable(aDoubleArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableDoubleChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableStringChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableString\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableStringChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aStringArg: String? = nilOrValue(args[0])
        api.callFlutterEchoNullable(aStringArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableStringChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableUint8ListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableUint8List\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableUint8ListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let listArg: FlutterStandardTypedData? = nilOrValue(args[0])
        api.callFlutterEchoNullable(listArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableUint8ListChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let listArg: [Any?]? = nilOrValue(args[0])
        api.callFlutterEchoNullable(listArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableListChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableEnumListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableEnumList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableEnumListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let enumListArg: [AnEnum?]? = nilOrValue(args[0])
        api.callFlutterEchoNullable(enumList: enumListArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableEnumListChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableClassListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableClassList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableClassListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let classListArg: [AllNullableTypes?]? = nilOrValue(args[0])
        api.callFlutterEchoNullable(classList: classListArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableClassListChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableNonNullEnumListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableNonNullEnumList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableNonNullEnumListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let enumListArg: [AnEnum]? = nilOrValue(args[0])
        api.callFlutterEchoNullableNonNull(enumList: enumListArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableNonNullEnumListChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableNonNullClassListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableNonNullClassList\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableNonNullClassListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let classListArg: [AllNullableTypes]? = nilOrValue(args[0])
        api.callFlutterEchoNullableNonNull(classList: classListArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableNonNullClassListChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let mapArg: [AnyHashable?: Any?]? = nilOrValue(args[0])
        api.callFlutterEchoNullable(mapArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableMapChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableStringMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableStringMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableStringMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let stringMapArg: [String?: String?]? = nilOrValue(args[0])
        api.callFlutterEchoNullable(stringMap: stringMapArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableStringMapChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableIntMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableIntMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableIntMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let intMapArg: [Int64?: Int64?]? = nilOrValue(args[0])
        api.callFlutterEchoNullable(intMap: intMapArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableIntMapChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableEnumMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableEnumMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableEnumMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let enumMapArg: [AnEnum?: AnEnum?]? = args[0] as? [AnEnum?: AnEnum?]
        api.callFlutterEchoNullable(enumMap: enumMapArg!) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableEnumMapChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableClassMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableClassMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableClassMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let classMapArg: [Int64?: AllNullableTypes?]? = nilOrValue(args[0])
        api.callFlutterEchoNullable(classMap: classMapArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableClassMapChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableNonNullStringMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableNonNullStringMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableNonNullStringMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let stringMapArg: [String: String]? = nilOrValue(args[0])
        api.callFlutterEchoNullableNonNull(stringMap: stringMapArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableNonNullStringMapChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableNonNullIntMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableNonNullIntMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableNonNullIntMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let intMapArg: [Int64: Int64]? = nilOrValue(args[0])
        api.callFlutterEchoNullableNonNull(intMap: intMapArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableNonNullIntMapChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableNonNullEnumMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableNonNullEnumMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableNonNullEnumMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let enumMapArg: [AnEnum: AnEnum]? = args[0] as? [AnEnum: AnEnum]
        api.callFlutterEchoNullableNonNull(enumMap: enumMapArg!) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableNonNullEnumMapChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableNonNullClassMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableNonNullClassMap\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableNonNullClassMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let classMapArg: [Int64: AllNullableTypes]? = nilOrValue(args[0])
        api.callFlutterEchoNullableNonNull(classMap: classMapArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableNonNullClassMapChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableEnumChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableEnum\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableEnumChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let anEnumArg: AnEnum? = nilOrValue(args[0])
        api.callFlutterEchoNullable(anEnumArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableEnumChannel.setMessageHandler(nil)
    }
    let callFlutterEchoAnotherNullableEnumChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoAnotherNullableEnum\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoAnotherNullableEnumChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let anotherEnumArg: AnotherEnum? = nilOrValue(args[0])
        api.callFlutterEchoNullable(anotherEnumArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoAnotherNullableEnumChannel.setMessageHandler(nil)
    }
    let callFlutterSmallApiEchoStringChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterSmallApiEchoString\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterSmallApiEchoStringChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aStringArg = args[0] as! String
        api.callFlutterSmallApiEcho(aStringArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterSmallApiEchoStringChannel.setMessageHandler(nil)
    }
  }
}
/// The core interface that the Dart platform_test code implements for host
/// integration tests to call into.
///
/// Generated protocol from Pigeon that represents Flutter messages that can be called from Swift.
protocol FlutterIntegrationCoreApiProtocol {
  /// A no-op function taking no arguments and returning no value, to sanity
  /// test basic calling.
  func noop(completion: @escaping (Result<Void, PigeonError>) -> Void)
  /// Responds with an error from an async function returning a value.
  func throwError(completion: @escaping (Result<Any?, PigeonError>) -> Void)
  /// Responds with an error from an async void function.
  func throwErrorFromVoid(completion: @escaping (Result<Void, PigeonError>) -> Void)
  /// Returns the passed object, to test serialization and deserialization.
  func echo(
    _ everythingArg: AllTypes, completion: @escaping (Result<AllTypes, PigeonError>) -> Void)
  /// Returns the passed object, to test serialization and deserialization.
  func echoNullable(
    _ everythingArg: AllNullableTypes?,
    completion: @escaping (Result<AllNullableTypes?, PigeonError>) -> Void)
  /// Returns passed in arguments of multiple types.
  ///
  /// Tests multiple-arity FlutterApi handling.
  func sendMultipleNullableTypes(
    aBool aNullableBoolArg: Bool?, anInt aNullableIntArg: Int64?,
    aString aNullableStringArg: String?,
    completion: @escaping (Result<AllNullableTypes, PigeonError>) -> Void)
  /// Returns the passed object, to test serialization and deserialization.
  func echoNullable(
    _ everythingArg: AllNullableTypesWithoutRecursion?,
    completion: @escaping (Result<AllNullableTypesWithoutRecursion?, PigeonError>) -> Void)
  /// Returns passed in arguments of multiple types.
  ///
  /// Tests multiple-arity FlutterApi handling.
  func sendMultipleNullableTypesWithoutRecursion(
    aBool aNullableBoolArg: Bool?, anInt aNullableIntArg: Int64?,
    aString aNullableStringArg: String?,
    completion: @escaping (Result<AllNullableTypesWithoutRecursion, PigeonError>) -> Void)
  /// Returns the passed boolean, to test serialization and deserialization.
  func echo(_ aBoolArg: Bool, completion: @escaping (Result<Bool, PigeonError>) -> Void)
  /// Returns the passed int, to test serialization and deserialization.
  func echo(_ anIntArg: Int64, completion: @escaping (Result<Int64, PigeonError>) -> Void)
  /// Returns the passed double, to test serialization and deserialization.
  func echo(_ aDoubleArg: Double, completion: @escaping (Result<Double, PigeonError>) -> Void)
  /// Returns the passed string, to test serialization and deserialization.
  func echo(_ aStringArg: String, completion: @escaping (Result<String, PigeonError>) -> Void)
  /// Returns the passed byte list, to test serialization and deserialization.
  func echo(
    _ listArg: FlutterStandardTypedData,
    completion: @escaping (Result<FlutterStandardTypedData, PigeonError>) -> Void)
  /// Returns the passed list, to test serialization and deserialization.
  func echo(_ listArg: [Any?], completion: @escaping (Result<[Any?], PigeonError>) -> Void)
  /// Returns the passed list, to test serialization and deserialization.
  func echo(
    enumList enumListArg: [AnEnum?], completion: @escaping (Result<[AnEnum?], PigeonError>) -> Void)
  /// Returns the passed list, to test serialization and deserialization.
  func echo(
    classList classListArg: [AllNullableTypes?],
    completion: @escaping (Result<[AllNullableTypes?], PigeonError>) -> Void)
  /// Returns the passed list, to test serialization and deserialization.
  func echoNonNull(
    enumList enumListArg: [AnEnum], completion: @escaping (Result<[AnEnum], PigeonError>) -> Void)
  /// Returns the passed list, to test serialization and deserialization.
  func echoNonNull(
    classList classListArg: [AllNullableTypes],
    completion: @escaping (Result<[AllNullableTypes], PigeonError>) -> Void)
  /// Returns the passed map, to test serialization and deserialization.
  func echo(
    _ mapArg: [AnyHashable?: Any?],
    completion: @escaping (Result<[AnyHashable?: Any?], PigeonError>) -> Void)
  /// Returns the passed map, to test serialization and deserialization.
  func echo(
    stringMap stringMapArg: [String?: String?],
    completion: @escaping (Result<[String?: String?], PigeonError>) -> Void)
  /// Returns the passed map, to test serialization and deserialization.
  func echo(
    intMap intMapArg: [Int64?: Int64?],
    completion: @escaping (Result<[Int64?: Int64?], PigeonError>) -> Void)
  /// Returns the passed map, to test serialization and deserialization.
  func echo(
    enumMap enumMapArg: [AnEnum?: AnEnum?],
    completion: @escaping (Result<[AnEnum?: AnEnum?], PigeonError>) -> Void)
  /// Returns the passed map, to test serialization and deserialization.
  func echo(
    classMap classMapArg: [Int64?: AllNullableTypes?],
    completion: @escaping (Result<[Int64?: AllNullableTypes?], PigeonError>) -> Void)
  /// Returns the passed map, to test serialization and deserialization.
  func echoNonNull(
    stringMap stringMapArg: [String: String],
    completion: @escaping (Result<[String: String], PigeonError>) -> Void)
  /// Returns the passed map, to test serialization and deserialization.
  func echoNonNull(
    intMap intMapArg: [Int64: Int64],
    completion: @escaping (Result<[Int64: Int64], PigeonError>) -> Void)
  /// Returns the passed map, to test serialization and deserialization.
  func echoNonNull(
    enumMap enumMapArg: [AnEnum: AnEnum],
    completion: @escaping (Result<[AnEnum: AnEnum], PigeonError>) -> Void)
  /// Returns the passed map, to test serialization and deserialization.
  func echoNonNull(
    classMap classMapArg: [Int64: AllNullableTypes],
    completion: @escaping (Result<[Int64: AllNullableTypes], PigeonError>) -> Void)
  /// Returns the passed enum to test serialization and deserialization.
  func echo(_ anEnumArg: AnEnum, completion: @escaping (Result<AnEnum, PigeonError>) -> Void)
  /// Returns the passed enum to test serialization and deserialization.
  func echo(
    _ anotherEnumArg: AnotherEnum, completion: @escaping (Result<AnotherEnum, PigeonError>) -> Void)
  /// Returns the passed boolean, to test serialization and deserialization.
  func echoNullable(_ aBoolArg: Bool?, completion: @escaping (Result<Bool?, PigeonError>) -> Void)
  /// Returns the passed int, to test serialization and deserialization.
  func echoNullable(_ anIntArg: Int64?, completion: @escaping (Result<Int64?, PigeonError>) -> Void)
  /// Returns the passed double, to test serialization and deserialization.
  func echoNullable(
    _ aDoubleArg: Double?, completion: @escaping (Result<Double?, PigeonError>) -> Void)
  /// Returns the passed string, to test serialization and deserialization.
  func echoNullable(
    _ aStringArg: String?, completion: @escaping (Result<String?, PigeonError>) -> Void)
  /// Returns the passed byte list, to test serialization and deserialization.
  func echoNullable(
    _ listArg: FlutterStandardTypedData?,
    completion: @escaping (Result<FlutterStandardTypedData?, PigeonError>) -> Void)
  /// Returns the passed list, to test serialization and deserialization.
  func echoNullable(
    _ listArg: [Any?]?, completion: @escaping (Result<[Any?]?, PigeonError>) -> Void)
  /// Returns the passed list, to test serialization and deserialization.
  func echoNullable(
    enumList enumListArg: [AnEnum?]?,
    completion: @escaping (Result<[AnEnum?]?, PigeonError>) -> Void)
  /// Returns the passed list, to test serialization and deserialization.
  func echoNullable(
    classList classListArg: [AllNullableTypes?]?,
    completion: @escaping (Result<[AllNullableTypes?]?, PigeonError>) -> Void)
  /// Returns the passed list, to test serialization and deserialization.
  func echoNullableNonNull(
    enumList enumListArg: [AnEnum]?, completion: @escaping (Result<[AnEnum]?, PigeonError>) -> Void)
  /// Returns the passed list, to test serialization and deserialization.
  func echoNullableNonNull(
    classList classListArg: [AllNullableTypes]?,
    completion: @escaping (Result<[AllNullableTypes]?, PigeonError>) -> Void)
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullable(
    _ mapArg: [AnyHashable?: Any?]?,
    completion: @escaping (Result<[AnyHashable?: Any?]?, PigeonError>) -> Void)
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullable(
    stringMap stringMapArg: [String?: String?]?,
    completion: @escaping (Result<[String?: String?]?, PigeonError>) -> Void)
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullable(
    intMap intMapArg: [Int64?: Int64?]?,
    completion: @escaping (Result<[Int64?: Int64?]?, PigeonError>) -> Void)
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullable(
    enumMap enumMapArg: [AnEnum?: AnEnum?]?,
    completion: @escaping (Result<[AnEnum?: AnEnum?]?, PigeonError>) -> Void)
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullable(
    classMap classMapArg: [Int64?: AllNullableTypes?]?,
    completion: @escaping (Result<[Int64?: AllNullableTypes?]?, PigeonError>) -> Void)
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullableNonNull(
    stringMap stringMapArg: [String: String]?,
    completion: @escaping (Result<[String: String]?, PigeonError>) -> Void)
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullableNonNull(
    intMap intMapArg: [Int64: Int64]?,
    completion: @escaping (Result<[Int64: Int64]?, PigeonError>) -> Void)
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullableNonNull(
    enumMap enumMapArg: [AnEnum: AnEnum]?,
    completion: @escaping (Result<[AnEnum: AnEnum]?, PigeonError>) -> Void)
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullableNonNull(
    classMap classMapArg: [Int64: AllNullableTypes]?,
    completion: @escaping (Result<[Int64: AllNullableTypes]?, PigeonError>) -> Void)
  /// Returns the passed enum to test serialization and deserialization.
  func echoNullable(
    _ anEnumArg: AnEnum?, completion: @escaping (Result<AnEnum?, PigeonError>) -> Void)
  /// Returns the passed enum to test serialization and deserialization.
  func echoNullable(
    _ anotherEnumArg: AnotherEnum?,
    completion: @escaping (Result<AnotherEnum?, PigeonError>) -> Void)
  /// A no-op function taking no arguments and returning no value, to sanity
  /// test basic asynchronous calling.
  func noopAsync(completion: @escaping (Result<Void, PigeonError>) -> Void)
  /// Returns the passed in generic Object asynchronously.
  func echoAsync(_ aStringArg: String, completion: @escaping (Result<String, PigeonError>) -> Void)
}
class FlutterIntegrationCoreApi: FlutterIntegrationCoreApiProtocol {
  private let binaryMessenger: FlutterBinaryMessenger
  private let messageChannelSuffix: String
  init(binaryMessenger: FlutterBinaryMessenger, messageChannelSuffix: String = "") {
    self.binaryMessenger = binaryMessenger
    self.messageChannelSuffix = messageChannelSuffix.count > 0 ? ".\(messageChannelSuffix)" : ""
  }
  var codec: CoreTestsPigeonCodec {
    return CoreTestsPigeonCodec.shared
  }
  /// A no-op function taking no arguments and returning no value, to sanity
  /// test basic calling.
  func noop(completion: @escaping (Result<Void, PigeonError>) -> Void) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.noop\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage(nil) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        completion(.success(()))
      }
    }
  }
  /// Responds with an error from an async function returning a value.
  func throwError(completion: @escaping (Result<Any?, PigeonError>) -> Void) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.throwError\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage(nil) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: Any? = listResponse[0]
        completion(.success(result))
      }
    }
  }
  /// Responds with an error from an async void function.
  func throwErrorFromVoid(completion: @escaping (Result<Void, PigeonError>) -> Void) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.throwErrorFromVoid\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage(nil) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        completion(.success(()))
      }
    }
  }
  /// Returns the passed object, to test serialization and deserialization.
  func echo(
    _ everythingArg: AllTypes, completion: @escaping (Result<AllTypes, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoAllTypes\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([everythingArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! AllTypes
        completion(.success(result))
      }
    }
  }
  /// Returns the passed object, to test serialization and deserialization.
  func echoNullable(
    _ everythingArg: AllNullableTypes?,
    completion: @escaping (Result<AllNullableTypes?, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoAllNullableTypes\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([everythingArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: AllNullableTypes? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }
  /// Returns passed in arguments of multiple types.
  ///
  /// Tests multiple-arity FlutterApi handling.
  func sendMultipleNullableTypes(
    aBool aNullableBoolArg: Bool?, anInt aNullableIntArg: Int64?,
    aString aNullableStringArg: String?,
    completion: @escaping (Result<AllNullableTypes, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.sendMultipleNullableTypes\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([aNullableBoolArg, aNullableIntArg, aNullableStringArg] as [Any?]) {
      response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! AllNullableTypes
        completion(.success(result))
      }
    }
  }
  /// Returns the passed object, to test serialization and deserialization.
  func echoNullable(
    _ everythingArg: AllNullableTypesWithoutRecursion?,
    completion: @escaping (Result<AllNullableTypesWithoutRecursion?, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoAllNullableTypesWithoutRecursion\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([everythingArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: AllNullableTypesWithoutRecursion? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }
  /// Returns passed in arguments of multiple types.
  ///
  /// Tests multiple-arity FlutterApi handling.
  func sendMultipleNullableTypesWithoutRecursion(
    aBool aNullableBoolArg: Bool?, anInt aNullableIntArg: Int64?,
    aString aNullableStringArg: String?,
    completion: @escaping (Result<AllNullableTypesWithoutRecursion, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.sendMultipleNullableTypesWithoutRecursion\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([aNullableBoolArg, aNullableIntArg, aNullableStringArg] as [Any?]) {
      response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! AllNullableTypesWithoutRecursion
        completion(.success(result))
      }
    }
  }
  /// Returns the passed boolean, to test serialization and deserialization.
  func echo(_ aBoolArg: Bool, completion: @escaping (Result<Bool, PigeonError>) -> Void) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoBool\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([aBoolArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! Bool
        completion(.success(result))
      }
    }
  }
  /// Returns the passed int, to test serialization and deserialization.
  func echo(_ anIntArg: Int64, completion: @escaping (Result<Int64, PigeonError>) -> Void) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoInt\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([anIntArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! Int64
        completion(.success(result))
      }
    }
  }
  /// Returns the passed double, to test serialization and deserialization.
  func echo(_ aDoubleArg: Double, completion: @escaping (Result<Double, PigeonError>) -> Void) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoDouble\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([aDoubleArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! Double
        completion(.success(result))
      }
    }
  }
  /// Returns the passed string, to test serialization and deserialization.
  func echo(_ aStringArg: String, completion: @escaping (Result<String, PigeonError>) -> Void) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoString\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([aStringArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! String
        completion(.success(result))
      }
    }
  }
  /// Returns the passed byte list, to test serialization and deserialization.
  func echo(
    _ listArg: FlutterStandardTypedData,
    completion: @escaping (Result<FlutterStandardTypedData, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoUint8List\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([listArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! FlutterStandardTypedData
        completion(.success(result))
      }
    }
  }
  /// Returns the passed list, to test serialization and deserialization.
  func echo(_ listArg: [Any?], completion: @escaping (Result<[Any?], PigeonError>) -> Void) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoList\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([listArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! [Any?]
        completion(.success(result))
      }
    }
  }
  /// Returns the passed list, to test serialization and deserialization.
  func echo(
    enumList enumListArg: [AnEnum?], completion: @escaping (Result<[AnEnum?], PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoEnumList\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([enumListArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! [AnEnum?]
        completion(.success(result))
      }
    }
  }
  /// Returns the passed list, to test serialization and deserialization.
  func echo(
    classList classListArg: [AllNullableTypes?],
    completion: @escaping (Result<[AllNullableTypes?], PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoClassList\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([classListArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! [AllNullableTypes?]
        completion(.success(result))
      }
    }
  }
  /// Returns the passed list, to test serialization and deserialization.
  func echoNonNull(
    enumList enumListArg: [AnEnum], completion: @escaping (Result<[AnEnum], PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNonNullEnumList\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([enumListArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! [AnEnum]
        completion(.success(result))
      }
    }
  }
  /// Returns the passed list, to test serialization and deserialization.
  func echoNonNull(
    classList classListArg: [AllNullableTypes],
    completion: @escaping (Result<[AllNullableTypes], PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNonNullClassList\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([classListArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! [AllNullableTypes]
        completion(.success(result))
      }
    }
  }
  /// Returns the passed map, to test serialization and deserialization.
  func echo(
    _ mapArg: [AnyHashable?: Any?],
    completion: @escaping (Result<[AnyHashable?: Any?], PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoMap\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([mapArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! [AnyHashable?: Any?]
        completion(.success(result))
      }
    }
  }
  /// Returns the passed map, to test serialization and deserialization.
  func echo(
    stringMap stringMapArg: [String?: String?],
    completion: @escaping (Result<[String?: String?], PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoStringMap\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([stringMapArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! [String?: String?]
        completion(.success(result))
      }
    }
  }
  /// Returns the passed map, to test serialization and deserialization.
  func echo(
    intMap intMapArg: [Int64?: Int64?],
    completion: @escaping (Result<[Int64?: Int64?], PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoIntMap\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([intMapArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! [Int64?: Int64?]
        completion(.success(result))
      }
    }
  }
  /// Returns the passed map, to test serialization and deserialization.
  func echo(
    enumMap enumMapArg: [AnEnum?: AnEnum?],
    completion: @escaping (Result<[AnEnum?: AnEnum?], PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoEnumMap\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([enumMapArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as? [AnEnum?: AnEnum?]
        completion(.success(result!))
      }
    }
  }
  /// Returns the passed map, to test serialization and deserialization.
  func echo(
    classMap classMapArg: [Int64?: AllNullableTypes?],
    completion: @escaping (Result<[Int64?: AllNullableTypes?], PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoClassMap\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([classMapArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! [Int64?: AllNullableTypes?]
        completion(.success(result))
      }
    }
  }
  /// Returns the passed map, to test serialization and deserialization.
  func echoNonNull(
    stringMap stringMapArg: [String: String],
    completion: @escaping (Result<[String: String], PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNonNullStringMap\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([stringMapArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! [String: String]
        completion(.success(result))
      }
    }
  }
  /// Returns the passed map, to test serialization and deserialization.
  func echoNonNull(
    intMap intMapArg: [Int64: Int64],
    completion: @escaping (Result<[Int64: Int64], PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNonNullIntMap\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([intMapArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! [Int64: Int64]
        completion(.success(result))
      }
    }
  }
  /// Returns the passed map, to test serialization and deserialization.
  func echoNonNull(
    enumMap enumMapArg: [AnEnum: AnEnum],
    completion: @escaping (Result<[AnEnum: AnEnum], PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNonNullEnumMap\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([enumMapArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as? [AnEnum: AnEnum]
        completion(.success(result!))
      }
    }
  }
  /// Returns the passed map, to test serialization and deserialization.
  func echoNonNull(
    classMap classMapArg: [Int64: AllNullableTypes],
    completion: @escaping (Result<[Int64: AllNullableTypes], PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNonNullClassMap\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([classMapArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! [Int64: AllNullableTypes]
        completion(.success(result))
      }
    }
  }
  /// Returns the passed enum to test serialization and deserialization.
  func echo(_ anEnumArg: AnEnum, completion: @escaping (Result<AnEnum, PigeonError>) -> Void) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoEnum\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([anEnumArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! AnEnum
        completion(.success(result))
      }
    }
  }
  /// Returns the passed enum to test serialization and deserialization.
  func echo(
    _ anotherEnumArg: AnotherEnum, completion: @escaping (Result<AnotherEnum, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoAnotherEnum\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([anotherEnumArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! AnotherEnum
        completion(.success(result))
      }
    }
  }
  /// Returns the passed boolean, to test serialization and deserialization.
  func echoNullable(_ aBoolArg: Bool?, completion: @escaping (Result<Bool?, PigeonError>) -> Void) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableBool\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([aBoolArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: Bool? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }
  /// Returns the passed int, to test serialization and deserialization.
  func echoNullable(_ anIntArg: Int64?, completion: @escaping (Result<Int64?, PigeonError>) -> Void)
  {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableInt\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([anIntArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: Int64? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }
  /// Returns the passed double, to test serialization and deserialization.
  func echoNullable(
    _ aDoubleArg: Double?, completion: @escaping (Result<Double?, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableDouble\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([aDoubleArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: Double? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }
  /// Returns the passed string, to test serialization and deserialization.
  func echoNullable(
    _ aStringArg: String?, completion: @escaping (Result<String?, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableString\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([aStringArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: String? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }
  /// Returns the passed byte list, to test serialization and deserialization.
  func echoNullable(
    _ listArg: FlutterStandardTypedData?,
    completion: @escaping (Result<FlutterStandardTypedData?, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableUint8List\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([listArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: FlutterStandardTypedData? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }
  /// Returns the passed list, to test serialization and deserialization.
  func echoNullable(
    _ listArg: [Any?]?, completion: @escaping (Result<[Any?]?, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableList\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([listArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: [Any?]? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }
  /// Returns the passed list, to test serialization and deserialization.
  func echoNullable(
    enumList enumListArg: [AnEnum?]?,
    completion: @escaping (Result<[AnEnum?]?, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableEnumList\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([enumListArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: [AnEnum?]? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }
  /// Returns the passed list, to test serialization and deserialization.
  func echoNullable(
    classList classListArg: [AllNullableTypes?]?,
    completion: @escaping (Result<[AllNullableTypes?]?, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableClassList\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([classListArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: [AllNullableTypes?]? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }
  /// Returns the passed list, to test serialization and deserialization.
  func echoNullableNonNull(
    enumList enumListArg: [AnEnum]?, completion: @escaping (Result<[AnEnum]?, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableNonNullEnumList\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([enumListArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: [AnEnum]? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }
  /// Returns the passed list, to test serialization and deserialization.
  func echoNullableNonNull(
    classList classListArg: [AllNullableTypes]?,
    completion: @escaping (Result<[AllNullableTypes]?, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableNonNullClassList\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([classListArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: [AllNullableTypes]? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullable(
    _ mapArg: [AnyHashable?: Any?]?,
    completion: @escaping (Result<[AnyHashable?: Any?]?, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableMap\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([mapArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: [AnyHashable?: Any?]? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullable(
    stringMap stringMapArg: [String?: String?]?,
    completion: @escaping (Result<[String?: String?]?, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableStringMap\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([stringMapArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: [String?: String?]? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullable(
    intMap intMapArg: [Int64?: Int64?]?,
    completion: @escaping (Result<[Int64?: Int64?]?, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableIntMap\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([intMapArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: [Int64?: Int64?]? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullable(
    enumMap enumMapArg: [AnEnum?: AnEnum?]?,
    completion: @escaping (Result<[AnEnum?: AnEnum?]?, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableEnumMap\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([enumMapArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: [AnEnum?: AnEnum?]? = listResponse[0] as? [AnEnum?: AnEnum?]
        completion(.success(result!))
      }
    }
  }
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullable(
    classMap classMapArg: [Int64?: AllNullableTypes?]?,
    completion: @escaping (Result<[Int64?: AllNullableTypes?]?, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableClassMap\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([classMapArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: [Int64?: AllNullableTypes?]? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullableNonNull(
    stringMap stringMapArg: [String: String]?,
    completion: @escaping (Result<[String: String]?, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableNonNullStringMap\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([stringMapArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: [String: String]? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullableNonNull(
    intMap intMapArg: [Int64: Int64]?,
    completion: @escaping (Result<[Int64: Int64]?, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableNonNullIntMap\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([intMapArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: [Int64: Int64]? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullableNonNull(
    enumMap enumMapArg: [AnEnum: AnEnum]?,
    completion: @escaping (Result<[AnEnum: AnEnum]?, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableNonNullEnumMap\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([enumMapArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: [AnEnum: AnEnum]? = listResponse[0] as? [AnEnum: AnEnum]
        completion(.success(result!))
      }
    }
  }
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullableNonNull(
    classMap classMapArg: [Int64: AllNullableTypes]?,
    completion: @escaping (Result<[Int64: AllNullableTypes]?, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableNonNullClassMap\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([classMapArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: [Int64: AllNullableTypes]? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }
  /// Returns the passed enum to test serialization and deserialization.
  func echoNullable(
    _ anEnumArg: AnEnum?, completion: @escaping (Result<AnEnum?, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableEnum\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([anEnumArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: AnEnum? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }
  /// Returns the passed enum to test serialization and deserialization.
  func echoNullable(
    _ anotherEnumArg: AnotherEnum?,
    completion: @escaping (Result<AnotherEnum?, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoAnotherNullableEnum\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([anotherEnumArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        let result: AnotherEnum? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }
  /// A no-op function taking no arguments and returning no value, to sanity
  /// test basic asynchronous calling.
  func noopAsync(completion: @escaping (Result<Void, PigeonError>) -> Void) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.noopAsync\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage(nil) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        completion(.success(()))
      }
    }
  }
  /// Returns the passed in generic Object asynchronously.
  func echoAsync(_ aStringArg: String, completion: @escaping (Result<String, PigeonError>) -> Void)
  {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoAsyncString\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([aStringArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! String
        completion(.success(result))
      }
    }
  }
}
/// An API that can be implemented for minimal, compile-only tests.
///
/// Generated protocol from Pigeon that represents a handler of messages from Flutter.
protocol HostTrivialApi {
  func noop() throws
}

/// Generated setup class from Pigeon to handle messages through the `binaryMessenger`.
class HostTrivialApiSetup {
  static var codec: FlutterStandardMessageCodec { CoreTestsPigeonCodec.shared }
  /// Sets up an instance of `HostTrivialApi` to handle messages through the `binaryMessenger`.
  static func setUp(
    binaryMessenger: FlutterBinaryMessenger, api: HostTrivialApi?, messageChannelSuffix: String = ""
  ) {
    let channelSuffix = messageChannelSuffix.count > 0 ? ".\(messageChannelSuffix)" : ""
    let noopChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.HostTrivialApi.noop\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      noopChannel.setMessageHandler { _, reply in
        do {
          try api.noop()
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      noopChannel.setMessageHandler(nil)
    }
  }
}
/// A simple API implemented in some unit tests.
///
/// Generated protocol from Pigeon that represents a handler of messages from Flutter.
protocol HostSmallApi {
  func echo(aString: String, completion: @escaping (Result<String, Error>) -> Void)
  func voidVoid(completion: @escaping (Result<Void, Error>) -> Void)
}

/// Generated setup class from Pigeon to handle messages through the `binaryMessenger`.
class HostSmallApiSetup {
  static var codec: FlutterStandardMessageCodec { CoreTestsPigeonCodec.shared }
  /// Sets up an instance of `HostSmallApi` to handle messages through the `binaryMessenger`.
  static func setUp(
    binaryMessenger: FlutterBinaryMessenger, api: HostSmallApi?, messageChannelSuffix: String = ""
  ) {
    let channelSuffix = messageChannelSuffix.count > 0 ? ".\(messageChannelSuffix)" : ""
    let echoChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.HostSmallApi.echo\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aStringArg = args[0] as! String
        api.echo(aString: aStringArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoChannel.setMessageHandler(nil)
    }
    let voidVoidChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.HostSmallApi.voidVoid\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      voidVoidChannel.setMessageHandler { _, reply in
        api.voidVoid { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      voidVoidChannel.setMessageHandler(nil)
    }
  }
}
/// A simple API called in some unit tests.
///
/// Generated protocol from Pigeon that represents Flutter messages that can be called from Swift.
protocol FlutterSmallApiProtocol {
  func echo(_ msgArg: TestMessage, completion: @escaping (Result<TestMessage, PigeonError>) -> Void)
  func echo(string aStringArg: String, completion: @escaping (Result<String, PigeonError>) -> Void)
}
class FlutterSmallApi: FlutterSmallApiProtocol {
  private let binaryMessenger: FlutterBinaryMessenger
  private let messageChannelSuffix: String
  init(binaryMessenger: FlutterBinaryMessenger, messageChannelSuffix: String = "") {
    self.binaryMessenger = binaryMessenger
    self.messageChannelSuffix = messageChannelSuffix.count > 0 ? ".\(messageChannelSuffix)" : ""
  }
  var codec: CoreTestsPigeonCodec {
    return CoreTestsPigeonCodec.shared
  }
  func echo(_ msgArg: TestMessage, completion: @escaping (Result<TestMessage, PigeonError>) -> Void)
  {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterSmallApi.echoWrappedList\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([msgArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! TestMessage
        completion(.success(result))
      }
    }
  }
  func echo(string aStringArg: String, completion: @escaping (Result<String, PigeonError>) -> Void)
  {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterSmallApi.echoString\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([aStringArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            PigeonError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! String
        completion(.success(result))
      }
    }
  }
}
