// Copyright 2013 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// Autogenerated from Pigeon, do not edit directly.
// See also: https://pub.dev/packages/pigeon
@file:Suppress("UNCHECKED_CAST", "ArrayInDataClass")

package com.example.test_plugin

import android.util.Log
import io.flutter.plugin.common.BasicMessageChannel
import io.flutter.plugin.common.BinaryMessenger
import io.flutter.plugin.common.MessageCodec
import io.flutter.plugin.common.StandardMessageCodec
import java.io.ByteArrayOutputStream
import java.nio.ByteBuffer

private object CoreTestsPigeonUtils {

  fun createConnectionError(channelName: String): FlutterError {
    return FlutterError(
        "channel-error", "Unable to establish connection on channel: '$channelName'.", "")
  }

  fun wrapResult(result: Any?): List<Any?> {
    return listOf(result)
  }

  fun wrapError(exception: Throwable): List<Any?> {
    return if (exception is FlutterError) {
      listOf(exception.code, exception.message, exception.details)
    } else {
      listOf(
          exception.javaClass.simpleName,
          exception.toString(),
          "Cause: " + exception.cause + ", Stacktrace: " + Log.getStackTraceString(exception))
    }
  }

  fun deepEquals(a: Any?, b: Any?): Boolean {
    if (a is ByteArray && b is ByteArray) {
      return a.contentEquals(b)
    }
    if (a is IntArray && b is IntArray) {
      return a.contentEquals(b)
    }
    if (a is LongArray && b is LongArray) {
      return a.contentEquals(b)
    }
    if (a is DoubleArray && b is DoubleArray) {
      return a.contentEquals(b)
    }
    if (a is Array<*> && b is Array<*>) {
      return a.size == b.size && a.indices.all { deepEquals(a[it], b[it]) }
    }
    if (a is List<*> && b is List<*>) {
      return a.size == b.size && a.indices.all { deepEquals(a[it], b[it]) }
    }
    if (a is Map<*, *> && b is Map<*, *>) {
      return a.size == b.size &&
          a.all { (b as Map<Any?, Any?>).containsKey(it.key) && deepEquals(it.value, b[it.key]) }
    }
    return a == b
  }
}

/**
 * Error class for passing custom error details to Flutter via a thrown PlatformException.
 *
 * @property code The error code.
 * @property message The error message.
 * @property details The error details. Must be a datatype supported by the api codec.
 */
class FlutterError(
    val code: String,
    override val message: String? = null,
    val details: Any? = null
) : Throwable()

enum class AnEnum(val raw: Int) {
  ONE(0),
  TWO(1),
  THREE(2),
  FORTY_TWO(3),
  FOUR_HUNDRED_TWENTY_TWO(4);

  companion object {
    fun ofRaw(raw: Int): AnEnum? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

enum class AnotherEnum(val raw: Int) {
  JUST_IN_CASE(0);

  companion object {
    fun ofRaw(raw: Int): AnotherEnum? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/** Generated class from Pigeon that represents data sent in messages. */
data class UnusedClass(val aField: Any? = null) {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): UnusedClass {
      val aField = pigeonVar_list[0]
      return UnusedClass(aField)
    }
  }

  fun toList(): List<Any?> {
    return listOf(
        aField,
    )
  }

  override fun equals(other: Any?): Boolean {
    if (other !is UnusedClass) {
      return false
    }
    if (this === other) {
      return true
    }
    return CoreTestsPigeonUtils.deepEquals(toList(), other.toList())
  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * A class containing all supported types.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class AllTypes(
    val aBool: Boolean,
    val anInt: Long,
    val anInt64: Long,
    val aDouble: Double,
    val aByteArray: ByteArray,
    val a4ByteArray: IntArray,
    val a8ByteArray: LongArray,
    val aFloatArray: DoubleArray,
    val anEnum: AnEnum,
    val anotherEnum: AnotherEnum,
    val aString: String,
    val anObject: Any,
    val list: List<Any?>,
    val stringList: List<String>,
    val intList: List<Long>,
    val doubleList: List<Double>,
    val boolList: List<Boolean>,
    val enumList: List<AnEnum>,
    val objectList: List<Any>,
    val listList: List<List<Any?>>,
    val mapList: List<Map<Any?, Any?>>,
    val map: Map<Any, Any?>,
    val stringMap: Map<String, String>,
    val intMap: Map<Long, Long>,
    val enumMap: Map<AnEnum, AnEnum>,
    val objectMap: Map<Any, Any>,
    val listMap: Map<Long, List<Any?>>,
    val mapMap: Map<Long, Map<Any?, Any?>>
) {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): AllTypes {
      val aBool = pigeonVar_list[0] as Boolean
      val anInt = pigeonVar_list[1] as Long
      val anInt64 = pigeonVar_list[2] as Long
      val aDouble = pigeonVar_list[3] as Double
      val aByteArray = pigeonVar_list[4] as ByteArray
      val a4ByteArray = pigeonVar_list[5] as IntArray
      val a8ByteArray = pigeonVar_list[6] as LongArray
      val aFloatArray = pigeonVar_list[7] as DoubleArray
      val anEnum = pigeonVar_list[8] as AnEnum
      val anotherEnum = pigeonVar_list[9] as AnotherEnum
      val aString = pigeonVar_list[10] as String
      val anObject = pigeonVar_list[11] as Any
      val list = pigeonVar_list[12] as List<Any?>
      val stringList = pigeonVar_list[13] as List<String>
      val intList = pigeonVar_list[14] as List<Long>
      val doubleList = pigeonVar_list[15] as List<Double>
      val boolList = pigeonVar_list[16] as List<Boolean>
      val enumList = pigeonVar_list[17] as List<AnEnum>
      val objectList = pigeonVar_list[18] as List<Any>
      val listList = pigeonVar_list[19] as List<List<Any?>>
      val mapList = pigeonVar_list[20] as List<Map<Any?, Any?>>
      val map = pigeonVar_list[21] as Map<Any, Any?>
      val stringMap = pigeonVar_list[22] as Map<String, String>
      val intMap = pigeonVar_list[23] as Map<Long, Long>
      val enumMap = pigeonVar_list[24] as Map<AnEnum, AnEnum>
      val objectMap = pigeonVar_list[25] as Map<Any, Any>
      val listMap = pigeonVar_list[26] as Map<Long, List<Any?>>
      val mapMap = pigeonVar_list[27] as Map<Long, Map<Any?, Any?>>
      return AllTypes(
          aBool,
          anInt,
          anInt64,
          aDouble,
          aByteArray,
          a4ByteArray,
          a8ByteArray,
          aFloatArray,
          anEnum,
          anotherEnum,
          aString,
          anObject,
          list,
          stringList,
          intList,
          doubleList,
          boolList,
          enumList,
          objectList,
          listList,
          mapList,
          map,
          stringMap,
          intMap,
          enumMap,
          objectMap,
          listMap,
          mapMap)
    }
  }

  fun toList(): List<Any?> {
    return listOf(
        aBool,
        anInt,
        anInt64,
        aDouble,
        aByteArray,
        a4ByteArray,
        a8ByteArray,
        aFloatArray,
        anEnum,
        anotherEnum,
        aString,
        anObject,
        list,
        stringList,
        intList,
        doubleList,
        boolList,
        enumList,
        objectList,
        listList,
        mapList,
        map,
        stringMap,
        intMap,
        enumMap,
        objectMap,
        listMap,
        mapMap,
    )
  }

  override fun equals(other: Any?): Boolean {
    if (other !is AllTypes) {
      return false
    }
    if (this === other) {
      return true
    }
    return CoreTestsPigeonUtils.deepEquals(toList(), other.toList())
  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * A class containing all supported nullable types.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class AllNullableTypes(
    val aNullableBool: Boolean? = null,
    val aNullableInt: Long? = null,
    val aNullableInt64: Long? = null,
    val aNullableDouble: Double? = null,
    val aNullableByteArray: ByteArray? = null,
    val aNullable4ByteArray: IntArray? = null,
    val aNullable8ByteArray: LongArray? = null,
    val aNullableFloatArray: DoubleArray? = null,
    val aNullableEnum: AnEnum? = null,
    val anotherNullableEnum: AnotherEnum? = null,
    val aNullableString: String? = null,
    val aNullableObject: Any? = null,
    val allNullableTypes: AllNullableTypes? = null,
    val list: List<Any?>? = null,
    val stringList: List<String?>? = null,
    val intList: List<Long?>? = null,
    val doubleList: List<Double?>? = null,
    val boolList: List<Boolean?>? = null,
    val enumList: List<AnEnum?>? = null,
    val objectList: List<Any?>? = null,
    val listList: List<List<Any?>?>? = null,
    val mapList: List<Map<Any?, Any?>?>? = null,
    val recursiveClassList: List<AllNullableTypes?>? = null,
    val map: Map<Any, Any?>? = null,
    val stringMap: Map<String?, String?>? = null,
    val intMap: Map<Long?, Long?>? = null,
    val enumMap: Map<AnEnum?, AnEnum?>? = null,
    val objectMap: Map<Any?, Any?>? = null,
    val listMap: Map<Long?, List<Any?>?>? = null,
    val mapMap: Map<Long?, Map<Any?, Any?>?>? = null,
    val recursiveClassMap: Map<Long?, AllNullableTypes?>? = null
) {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): AllNullableTypes {
      val aNullableBool = pigeonVar_list[0] as Boolean?
      val aNullableInt = pigeonVar_list[1] as Long?
      val aNullableInt64 = pigeonVar_list[2] as Long?
      val aNullableDouble = pigeonVar_list[3] as Double?
      val aNullableByteArray = pigeonVar_list[4] as ByteArray?
      val aNullable4ByteArray = pigeonVar_list[5] as IntArray?
      val aNullable8ByteArray = pigeonVar_list[6] as LongArray?
      val aNullableFloatArray = pigeonVar_list[7] as DoubleArray?
      val aNullableEnum = pigeonVar_list[8] as AnEnum?
      val anotherNullableEnum = pigeonVar_list[9] as AnotherEnum?
      val aNullableString = pigeonVar_list[10] as String?
      val aNullableObject = pigeonVar_list[11]
      val allNullableTypes = pigeonVar_list[12] as AllNullableTypes?
      val list = pigeonVar_list[13] as List<Any?>?
      val stringList = pigeonVar_list[14] as List<String?>?
      val intList = pigeonVar_list[15] as List<Long?>?
      val doubleList = pigeonVar_list[16] as List<Double?>?
      val boolList = pigeonVar_list[17] as List<Boolean?>?
      val enumList = pigeonVar_list[18] as List<AnEnum?>?
      val objectList = pigeonVar_list[19] as List<Any?>?
      val listList = pigeonVar_list[20] as List<List<Any?>?>?
      val mapList = pigeonVar_list[21] as List<Map<Any?, Any?>?>?
      val recursiveClassList = pigeonVar_list[22] as List<AllNullableTypes?>?
      val map = pigeonVar_list[23] as Map<Any, Any?>?
      val stringMap = pigeonVar_list[24] as Map<String?, String?>?
      val intMap = pigeonVar_list[25] as Map<Long?, Long?>?
      val enumMap = pigeonVar_list[26] as Map<AnEnum?, AnEnum?>?
      val objectMap = pigeonVar_list[27] as Map<Any?, Any?>?
      val listMap = pigeonVar_list[28] as Map<Long?, List<Any?>?>?
      val mapMap = pigeonVar_list[29] as Map<Long?, Map<Any?, Any?>?>?
      val recursiveClassMap = pigeonVar_list[30] as Map<Long?, AllNullableTypes?>?
      return AllNullableTypes(
          aNullableBool,
          aNullableInt,
          aNullableInt64,
          aNullableDouble,
          aNullableByteArray,
          aNullable4ByteArray,
          aNullable8ByteArray,
          aNullableFloatArray,
          aNullableEnum,
          anotherNullableEnum,
          aNullableString,
          aNullableObject,
          allNullableTypes,
          list,
          stringList,
          intList,
          doubleList,
          boolList,
          enumList,
          objectList,
          listList,
          mapList,
          recursiveClassList,
          map,
          stringMap,
          intMap,
          enumMap,
          objectMap,
          listMap,
          mapMap,
          recursiveClassMap)
    }
  }

  fun toList(): List<Any?> {
    return listOf(
        aNullableBool,
        aNullableInt,
        aNullableInt64,
        aNullableDouble,
        aNullableByteArray,
        aNullable4ByteArray,
        aNullable8ByteArray,
        aNullableFloatArray,
        aNullableEnum,
        anotherNullableEnum,
        aNullableString,
        aNullableObject,
        allNullableTypes,
        list,
        stringList,
        intList,
        doubleList,
        boolList,
        enumList,
        objectList,
        listList,
        mapList,
        recursiveClassList,
        map,
        stringMap,
        intMap,
        enumMap,
        objectMap,
        listMap,
        mapMap,
        recursiveClassMap,
    )
  }

  override fun equals(other: Any?): Boolean {
    if (other !is AllNullableTypes) {
      return false
    }
    if (this === other) {
      return true
    }
    return CoreTestsPigeonUtils.deepEquals(toList(), other.toList())
  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * The primary purpose for this class is to ensure coverage of Swift structs with nullable items, as
 * the primary [AllNullableTypes] class is being used to test Swift classes.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class AllNullableTypesWithoutRecursion(
    val aNullableBool: Boolean? = null,
    val aNullableInt: Long? = null,
    val aNullableInt64: Long? = null,
    val aNullableDouble: Double? = null,
    val aNullableByteArray: ByteArray? = null,
    val aNullable4ByteArray: IntArray? = null,
    val aNullable8ByteArray: LongArray? = null,
    val aNullableFloatArray: DoubleArray? = null,
    val aNullableEnum: AnEnum? = null,
    val anotherNullableEnum: AnotherEnum? = null,
    val aNullableString: String? = null,
    val aNullableObject: Any? = null,
    val list: List<Any?>? = null,
    val stringList: List<String?>? = null,
    val intList: List<Long?>? = null,
    val doubleList: List<Double?>? = null,
    val boolList: List<Boolean?>? = null,
    val enumList: List<AnEnum?>? = null,
    val objectList: List<Any?>? = null,
    val listList: List<List<Any?>?>? = null,
    val mapList: List<Map<Any?, Any?>?>? = null,
    val map: Map<Any, Any?>? = null,
    val stringMap: Map<String?, String?>? = null,
    val intMap: Map<Long?, Long?>? = null,
    val enumMap: Map<AnEnum?, AnEnum?>? = null,
    val objectMap: Map<Any?, Any?>? = null,
    val listMap: Map<Long?, List<Any?>?>? = null,
    val mapMap: Map<Long?, Map<Any?, Any?>?>? = null
) {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): AllNullableTypesWithoutRecursion {
      val aNullableBool = pigeonVar_list[0] as Boolean?
      val aNullableInt = pigeonVar_list[1] as Long?
      val aNullableInt64 = pigeonVar_list[2] as Long?
      val aNullableDouble = pigeonVar_list[3] as Double?
      val aNullableByteArray = pigeonVar_list[4] as ByteArray?
      val aNullable4ByteArray = pigeonVar_list[5] as IntArray?
      val aNullable8ByteArray = pigeonVar_list[6] as LongArray?
      val aNullableFloatArray = pigeonVar_list[7] as DoubleArray?
      val aNullableEnum = pigeonVar_list[8] as AnEnum?
      val anotherNullableEnum = pigeonVar_list[9] as AnotherEnum?
      val aNullableString = pigeonVar_list[10] as String?
      val aNullableObject = pigeonVar_list[11]
      val list = pigeonVar_list[12] as List<Any?>?
      val stringList = pigeonVar_list[13] as List<String?>?
      val intList = pigeonVar_list[14] as List<Long?>?
      val doubleList = pigeonVar_list[15] as List<Double?>?
      val boolList = pigeonVar_list[16] as List<Boolean?>?
      val enumList = pigeonVar_list[17] as List<AnEnum?>?
      val objectList = pigeonVar_list[18] as List<Any?>?
      val listList = pigeonVar_list[19] as List<List<Any?>?>?
      val mapList = pigeonVar_list[20] as List<Map<Any?, Any?>?>?
      val map = pigeonVar_list[21] as Map<Any, Any?>?
      val stringMap = pigeonVar_list[22] as Map<String?, String?>?
      val intMap = pigeonVar_list[23] as Map<Long?, Long?>?
      val enumMap = pigeonVar_list[24] as Map<AnEnum?, AnEnum?>?
      val objectMap = pigeonVar_list[25] as Map<Any?, Any?>?
      val listMap = pigeonVar_list[26] as Map<Long?, List<Any?>?>?
      val mapMap = pigeonVar_list[27] as Map<Long?, Map<Any?, Any?>?>?
      return AllNullableTypesWithoutRecursion(
          aNullableBool,
          aNullableInt,
          aNullableInt64,
          aNullableDouble,
          aNullableByteArray,
          aNullable4ByteArray,
          aNullable8ByteArray,
          aNullableFloatArray,
          aNullableEnum,
          anotherNullableEnum,
          aNullableString,
          aNullableObject,
          list,
          stringList,
          intList,
          doubleList,
          boolList,
          enumList,
          objectList,
          listList,
          mapList,
          map,
          stringMap,
          intMap,
          enumMap,
          objectMap,
          listMap,
          mapMap)
    }
  }

  fun toList(): List<Any?> {
    return listOf(
        aNullableBool,
        aNullableInt,
        aNullableInt64,
        aNullableDouble,
        aNullableByteArray,
        aNullable4ByteArray,
        aNullable8ByteArray,
        aNullableFloatArray,
        aNullableEnum,
        anotherNullableEnum,
        aNullableString,
        aNullableObject,
        list,
        stringList,
        intList,
        doubleList,
        boolList,
        enumList,
        objectList,
        listList,
        mapList,
        map,
        stringMap,
        intMap,
        enumMap,
        objectMap,
        listMap,
        mapMap,
    )
  }

  override fun equals(other: Any?): Boolean {
    if (other !is AllNullableTypesWithoutRecursion) {
      return false
    }
    if (this === other) {
      return true
    }
    return CoreTestsPigeonUtils.deepEquals(toList(), other.toList())
  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * A class for testing nested class handling.
 *
 * This is needed to test nested nullable and non-nullable classes, `AllNullableTypes` is
 * non-nullable here as it is easier to instantiate than `AllTypes` when testing doesn't require
 * both (ie. testing null classes).
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class AllClassesWrapper(
    val allNullableTypes: AllNullableTypes,
    val allNullableTypesWithoutRecursion: AllNullableTypesWithoutRecursion? = null,
    val allTypes: AllTypes? = null,
    val classList: List<AllTypes?>,
    val nullableClassList: List<AllNullableTypesWithoutRecursion?>? = null,
    val classMap: Map<Long?, AllTypes?>,
    val nullableClassMap: Map<Long?, AllNullableTypesWithoutRecursion?>? = null
) {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): AllClassesWrapper {
      val allNullableTypes = pigeonVar_list[0] as AllNullableTypes
      val allNullableTypesWithoutRecursion = pigeonVar_list[1] as AllNullableTypesWithoutRecursion?
      val allTypes = pigeonVar_list[2] as AllTypes?
      val classList = pigeonVar_list[3] as List<AllTypes?>
      val nullableClassList = pigeonVar_list[4] as List<AllNullableTypesWithoutRecursion?>?
      val classMap = pigeonVar_list[5] as Map<Long?, AllTypes?>
      val nullableClassMap = pigeonVar_list[6] as Map<Long?, AllNullableTypesWithoutRecursion?>?
      return AllClassesWrapper(
          allNullableTypes,
          allNullableTypesWithoutRecursion,
          allTypes,
          classList,
          nullableClassList,
          classMap,
          nullableClassMap)
    }
  }

  fun toList(): List<Any?> {
    return listOf(
        allNullableTypes,
        allNullableTypesWithoutRecursion,
        allTypes,
        classList,
        nullableClassList,
        classMap,
        nullableClassMap,
    )
  }

  override fun equals(other: Any?): Boolean {
    if (other !is AllClassesWrapper) {
      return false
    }
    if (this === other) {
      return true
    }
    return CoreTestsPigeonUtils.deepEquals(toList(), other.toList())
  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * A data class containing a List, used in unit tests.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class TestMessage(val testList: List<Any?>? = null) {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): TestMessage {
      val testList = pigeonVar_list[0] as List<Any?>?
      return TestMessage(testList)
    }
  }

  fun toList(): List<Any?> {
    return listOf(
        testList,
    )
  }

  override fun equals(other: Any?): Boolean {
    if (other !is TestMessage) {
      return false
    }
    if (this === other) {
      return true
    }
    return CoreTestsPigeonUtils.deepEquals(toList(), other.toList())
  }

  override fun hashCode(): Int = toList().hashCode()
}

private open class CoreTestsPigeonCodec : StandardMessageCodec() {
  override fun readValueOfType(type: Byte, buffer: ByteBuffer): Any? {
    return when (type) {
      129.toByte() -> {
        return (readValue(buffer) as Long?)?.let { AnEnum.ofRaw(it.toInt()) }
      }
      130.toByte() -> {
        return (readValue(buffer) as Long?)?.let { AnotherEnum.ofRaw(it.toInt()) }
      }
      131.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let { UnusedClass.fromList(it) }
      }
      132.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let { AllTypes.fromList(it) }
      }
      133.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let { AllNullableTypes.fromList(it) }
      }
      134.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          AllNullableTypesWithoutRecursion.fromList(it)
        }
      }
      135.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let { AllClassesWrapper.fromList(it) }
      }
      136.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let { TestMessage.fromList(it) }
      }
      else -> super.readValueOfType(type, buffer)
    }
  }

  override fun writeValue(stream: ByteArrayOutputStream, value: Any?) {
    when (value) {
      is AnEnum -> {
        stream.write(129)
        writeValue(stream, value.raw)
      }
      is AnotherEnum -> {
        stream.write(130)
        writeValue(stream, value.raw)
      }
      is UnusedClass -> {
        stream.write(131)
        writeValue(stream, value.toList())
      }
      is AllTypes -> {
        stream.write(132)
        writeValue(stream, value.toList())
      }
      is AllNullableTypes -> {
        stream.write(133)
        writeValue(stream, value.toList())
      }
      is AllNullableTypesWithoutRecursion -> {
        stream.write(134)
        writeValue(stream, value.toList())
      }
      is AllClassesWrapper -> {
        stream.write(135)
        writeValue(stream, value.toList())
      }
      is TestMessage -> {
        stream.write(136)
        writeValue(stream, value.toList())
      }
      else -> super.writeValue(stream, value)
    }
  }
}

/**
 * The core interface that each host language plugin must implement in platform_test integration
 * tests.
 *
 * Generated interface from Pigeon that represents a handler of messages from Flutter.
 */
interface HostIntegrationCoreApi {
  /** A no-op function taking no arguments and returning no value, to sanity test basic calling. */
  fun noop()
  /** Returns the passed object, to test serialization and deserialization. */
  fun echoAllTypes(everything: AllTypes): AllTypes
  /** Returns an error, to test error handling. */
  fun throwError(): Any?
  /** Returns an error from a void function, to test error handling. */
  fun throwErrorFromVoid()
  /** Returns a Flutter error, to test error handling. */
  fun throwFlutterError(): Any?
  /** Returns passed in int. */
  fun echoInt(anInt: Long): Long
  /** Returns passed in double. */
  fun echoDouble(aDouble: Double): Double
  /** Returns the passed in boolean. */
  fun echoBool(aBool: Boolean): Boolean
  /** Returns the passed in string. */
  fun echoString(aString: String): String
  /** Returns the passed in Uint8List. */
  fun echoUint8List(aUint8List: ByteArray): ByteArray
  /** Returns the passed in generic Object. */
  fun echoObject(anObject: Any): Any
  /** Returns the passed list, to test serialization and deserialization. */
  fun echoList(list: List<Any?>): List<Any?>
  /** Returns the passed list, to test serialization and deserialization. */
  fun echoEnumList(enumList: List<AnEnum?>): List<AnEnum?>
  /** Returns the passed list, to test serialization and deserialization. */
  fun echoClassList(classList: List<AllNullableTypes?>): List<AllNullableTypes?>
  /** Returns the passed list, to test serialization and deserialization. */
  fun echoNonNullEnumList(enumList: List<AnEnum>): List<AnEnum>
  /** Returns the passed list, to test serialization and deserialization. */
  fun echoNonNullClassList(classList: List<AllNullableTypes>): List<AllNullableTypes>
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoMap(map: Map<Any?, Any?>): Map<Any?, Any?>
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoStringMap(stringMap: Map<String?, String?>): Map<String?, String?>
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoIntMap(intMap: Map<Long?, Long?>): Map<Long?, Long?>
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoEnumMap(enumMap: Map<AnEnum?, AnEnum?>): Map<AnEnum?, AnEnum?>
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoClassMap(classMap: Map<Long?, AllNullableTypes?>): Map<Long?, AllNullableTypes?>
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNonNullStringMap(stringMap: Map<String, String>): Map<String, String>
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNonNullIntMap(intMap: Map<Long, Long>): Map<Long, Long>
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNonNullEnumMap(enumMap: Map<AnEnum, AnEnum>): Map<AnEnum, AnEnum>
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNonNullClassMap(classMap: Map<Long, AllNullableTypes>): Map<Long, AllNullableTypes>
  /** Returns the passed class to test nested class serialization and deserialization. */
  fun echoClassWrapper(wrapper: AllClassesWrapper): AllClassesWrapper
  /** Returns the passed enum to test serialization and deserialization. */
  fun echoEnum(anEnum: AnEnum): AnEnum
  /** Returns the passed enum to test serialization and deserialization. */
  fun echoAnotherEnum(anotherEnum: AnotherEnum): AnotherEnum
  /** Returns the default string. */
  fun echoNamedDefaultString(aString: String): String
  /** Returns passed in double. */
  fun echoOptionalDefaultDouble(aDouble: Double): Double
  /** Returns passed in int. */
  fun echoRequiredInt(anInt: Long): Long
  /** Returns the passed object, to test serialization and deserialization. */
  fun echoAllNullableTypes(everything: AllNullableTypes?): AllNullableTypes?
  /** Returns the passed object, to test serialization and deserialization. */
  fun echoAllNullableTypesWithoutRecursion(
      everything: AllNullableTypesWithoutRecursion?
  ): AllNullableTypesWithoutRecursion?
  /**
   * Returns the inner `aString` value from the wrapped object, to test sending of nested objects.
   */
  fun extractNestedNullableString(wrapper: AllClassesWrapper): String?
  /**
   * Returns the inner `aString` value from the wrapped object, to test sending of nested objects.
   */
  fun createNestedNullableString(nullableString: String?): AllClassesWrapper
  /** Returns passed in arguments of multiple types. */
  fun sendMultipleNullableTypes(
      aNullableBool: Boolean?,
      aNullableInt: Long?,
      aNullableString: String?
  ): AllNullableTypes
  /** Returns passed in arguments of multiple types. */
  fun sendMultipleNullableTypesWithoutRecursion(
      aNullableBool: Boolean?,
      aNullableInt: Long?,
      aNullableString: String?
  ): AllNullableTypesWithoutRecursion
  /** Returns passed in int. */
  fun echoNullableInt(aNullableInt: Long?): Long?
  /** Returns passed in double. */
  fun echoNullableDouble(aNullableDouble: Double?): Double?
  /** Returns the passed in boolean. */
  fun echoNullableBool(aNullableBool: Boolean?): Boolean?
  /** Returns the passed in string. */
  fun echoNullableString(aNullableString: String?): String?
  /** Returns the passed in Uint8List. */
  fun echoNullableUint8List(aNullableUint8List: ByteArray?): ByteArray?
  /** Returns the passed in generic Object. */
  fun echoNullableObject(aNullableObject: Any?): Any?
  /** Returns the passed list, to test serialization and deserialization. */
  fun echoNullableList(aNullableList: List<Any?>?): List<Any?>?
  /** Returns the passed list, to test serialization and deserialization. */
  fun echoNullableEnumList(enumList: List<AnEnum?>?): List<AnEnum?>?
  /** Returns the passed list, to test serialization and deserialization. */
  fun echoNullableClassList(classList: List<AllNullableTypes?>?): List<AllNullableTypes?>?
  /** Returns the passed list, to test serialization and deserialization. */
  fun echoNullableNonNullEnumList(enumList: List<AnEnum>?): List<AnEnum>?
  /** Returns the passed list, to test serialization and deserialization. */
  fun echoNullableNonNullClassList(classList: List<AllNullableTypes>?): List<AllNullableTypes>?
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNullableMap(map: Map<Any?, Any?>?): Map<Any?, Any?>?
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNullableStringMap(stringMap: Map<String?, String?>?): Map<String?, String?>?
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNullableIntMap(intMap: Map<Long?, Long?>?): Map<Long?, Long?>?
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNullableEnumMap(enumMap: Map<AnEnum?, AnEnum?>?): Map<AnEnum?, AnEnum?>?
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNullableClassMap(classMap: Map<Long?, AllNullableTypes?>?): Map<Long?, AllNullableTypes?>?
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNullableNonNullStringMap(stringMap: Map<String, String>?): Map<String, String>?
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNullableNonNullIntMap(intMap: Map<Long, Long>?): Map<Long, Long>?
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNullableNonNullEnumMap(enumMap: Map<AnEnum, AnEnum>?): Map<AnEnum, AnEnum>?
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNullableNonNullClassMap(
      classMap: Map<Long, AllNullableTypes>?
  ): Map<Long, AllNullableTypes>?

  fun echoNullableEnum(anEnum: AnEnum?): AnEnum?

  fun echoAnotherNullableEnum(anotherEnum: AnotherEnum?): AnotherEnum?
  /** Returns passed in int. */
  fun echoOptionalNullableInt(aNullableInt: Long?): Long?
  /** Returns the passed in string. */
  fun echoNamedNullableString(aNullableString: String?): String?
  /**
   * A no-op function taking no arguments and returning no value, to sanity test basic asynchronous
   * calling.
   */
  fun noopAsync(callback: (Result<Unit>) -> Unit)
  /** Returns passed in int asynchronously. */
  fun echoAsyncInt(anInt: Long, callback: (Result<Long>) -> Unit)
  /** Returns passed in double asynchronously. */
  fun echoAsyncDouble(aDouble: Double, callback: (Result<Double>) -> Unit)
  /** Returns the passed in boolean asynchronously. */
  fun echoAsyncBool(aBool: Boolean, callback: (Result<Boolean>) -> Unit)
  /** Returns the passed string asynchronously. */
  fun echoAsyncString(aString: String, callback: (Result<String>) -> Unit)
  /** Returns the passed in Uint8List asynchronously. */
  fun echoAsyncUint8List(aUint8List: ByteArray, callback: (Result<ByteArray>) -> Unit)
  /** Returns the passed in generic Object asynchronously. */
  fun echoAsyncObject(anObject: Any, callback: (Result<Any>) -> Unit)
  /** Returns the passed list, to test asynchronous serialization and deserialization. */
  fun echoAsyncList(list: List<Any?>, callback: (Result<List<Any?>>) -> Unit)
  /** Returns the passed list, to test asynchronous serialization and deserialization. */
  fun echoAsyncEnumList(enumList: List<AnEnum?>, callback: (Result<List<AnEnum?>>) -> Unit)
  /** Returns the passed list, to test asynchronous serialization and deserialization. */
  fun echoAsyncClassList(
      classList: List<AllNullableTypes?>,
      callback: (Result<List<AllNullableTypes?>>) -> Unit
  )
  /** Returns the passed map, to test asynchronous serialization and deserialization. */
  fun echoAsyncMap(map: Map<Any?, Any?>, callback: (Result<Map<Any?, Any?>>) -> Unit)
  /** Returns the passed map, to test asynchronous serialization and deserialization. */
  fun echoAsyncStringMap(
      stringMap: Map<String?, String?>,
      callback: (Result<Map<String?, String?>>) -> Unit
  )
  /** Returns the passed map, to test asynchronous serialization and deserialization. */
  fun echoAsyncIntMap(intMap: Map<Long?, Long?>, callback: (Result<Map<Long?, Long?>>) -> Unit)
  /** Returns the passed map, to test asynchronous serialization and deserialization. */
  fun echoAsyncEnumMap(
      enumMap: Map<AnEnum?, AnEnum?>,
      callback: (Result<Map<AnEnum?, AnEnum?>>) -> Unit
  )
  /** Returns the passed map, to test asynchronous serialization and deserialization. */
  fun echoAsyncClassMap(
      classMap: Map<Long?, AllNullableTypes?>,
      callback: (Result<Map<Long?, AllNullableTypes?>>) -> Unit
  )
  /** Returns the passed enum, to test asynchronous serialization and deserialization. */
  fun echoAsyncEnum(anEnum: AnEnum, callback: (Result<AnEnum>) -> Unit)
  /** Returns the passed enum, to test asynchronous serialization and deserialization. */
  fun echoAnotherAsyncEnum(anotherEnum: AnotherEnum, callback: (Result<AnotherEnum>) -> Unit)
  /** Responds with an error from an async function returning a value. */
  fun throwAsyncError(callback: (Result<Any?>) -> Unit)
  /** Responds with an error from an async void function. */
  fun throwAsyncErrorFromVoid(callback: (Result<Unit>) -> Unit)
  /** Responds with a Flutter error from an async function returning a value. */
  fun throwAsyncFlutterError(callback: (Result<Any?>) -> Unit)
  /** Returns the passed object, to test async serialization and deserialization. */
  fun echoAsyncAllTypes(everything: AllTypes, callback: (Result<AllTypes>) -> Unit)
  /** Returns the passed object, to test serialization and deserialization. */
  fun echoAsyncNullableAllNullableTypes(
      everything: AllNullableTypes?,
      callback: (Result<AllNullableTypes?>) -> Unit
  )
  /** Returns the passed object, to test serialization and deserialization. */
  fun echoAsyncNullableAllNullableTypesWithoutRecursion(
      everything: AllNullableTypesWithoutRecursion?,
      callback: (Result<AllNullableTypesWithoutRecursion?>) -> Unit
  )
  /** Returns passed in int asynchronously. */
  fun echoAsyncNullableInt(anInt: Long?, callback: (Result<Long?>) -> Unit)
  /** Returns passed in double asynchronously. */
  fun echoAsyncNullableDouble(aDouble: Double?, callback: (Result<Double?>) -> Unit)
  /** Returns the passed in boolean asynchronously. */
  fun echoAsyncNullableBool(aBool: Boolean?, callback: (Result<Boolean?>) -> Unit)
  /** Returns the passed string asynchronously. */
  fun echoAsyncNullableString(aString: String?, callback: (Result<String?>) -> Unit)
  /** Returns the passed in Uint8List asynchronously. */
  fun echoAsyncNullableUint8List(aUint8List: ByteArray?, callback: (Result<ByteArray?>) -> Unit)
  /** Returns the passed in generic Object asynchronously. */
  fun echoAsyncNullableObject(anObject: Any?, callback: (Result<Any?>) -> Unit)
  /** Returns the passed list, to test asynchronous serialization and deserialization. */
  fun echoAsyncNullableList(list: List<Any?>?, callback: (Result<List<Any?>?>) -> Unit)
  /** Returns the passed list, to test asynchronous serialization and deserialization. */
  fun echoAsyncNullableEnumList(
      enumList: List<AnEnum?>?,
      callback: (Result<List<AnEnum?>?>) -> Unit
  )
  /** Returns the passed list, to test asynchronous serialization and deserialization. */
  fun echoAsyncNullableClassList(
      classList: List<AllNullableTypes?>?,
      callback: (Result<List<AllNullableTypes?>?>) -> Unit
  )
  /** Returns the passed map, to test asynchronous serialization and deserialization. */
  fun echoAsyncNullableMap(map: Map<Any?, Any?>?, callback: (Result<Map<Any?, Any?>?>) -> Unit)
  /** Returns the passed map, to test asynchronous serialization and deserialization. */
  fun echoAsyncNullableStringMap(
      stringMap: Map<String?, String?>?,
      callback: (Result<Map<String?, String?>?>) -> Unit
  )
  /** Returns the passed map, to test asynchronous serialization and deserialization. */
  fun echoAsyncNullableIntMap(
      intMap: Map<Long?, Long?>?,
      callback: (Result<Map<Long?, Long?>?>) -> Unit
  )
  /** Returns the passed map, to test asynchronous serialization and deserialization. */
  fun echoAsyncNullableEnumMap(
      enumMap: Map<AnEnum?, AnEnum?>?,
      callback: (Result<Map<AnEnum?, AnEnum?>?>) -> Unit
  )
  /** Returns the passed map, to test asynchronous serialization and deserialization. */
  fun echoAsyncNullableClassMap(
      classMap: Map<Long?, AllNullableTypes?>?,
      callback: (Result<Map<Long?, AllNullableTypes?>?>) -> Unit
  )
  /** Returns the passed enum, to test asynchronous serialization and deserialization. */
  fun echoAsyncNullableEnum(anEnum: AnEnum?, callback: (Result<AnEnum?>) -> Unit)
  /** Returns the passed enum, to test asynchronous serialization and deserialization. */
  fun echoAnotherAsyncNullableEnum(
      anotherEnum: AnotherEnum?,
      callback: (Result<AnotherEnum?>) -> Unit
  )
  /**
   * Returns true if the handler is run on a main thread, which should be true since there is no
   * TaskQueue annotation.
   */
  fun defaultIsMainThread(): Boolean
  /**
   * Returns true if the handler is run on a non-main thread, which should be true for any platform
   * with TaskQueue support.
   */
  fun taskQueueIsBackgroundThread(): Boolean

  fun callFlutterNoop(callback: (Result<Unit>) -> Unit)

  fun callFlutterThrowError(callback: (Result<Any?>) -> Unit)

  fun callFlutterThrowErrorFromVoid(callback: (Result<Unit>) -> Unit)

  fun callFlutterEchoAllTypes(everything: AllTypes, callback: (Result<AllTypes>) -> Unit)

  fun callFlutterEchoAllNullableTypes(
      everything: AllNullableTypes?,
      callback: (Result<AllNullableTypes?>) -> Unit
  )

  fun callFlutterSendMultipleNullableTypes(
      aNullableBool: Boolean?,
      aNullableInt: Long?,
      aNullableString: String?,
      callback: (Result<AllNullableTypes>) -> Unit
  )

  fun callFlutterEchoAllNullableTypesWithoutRecursion(
      everything: AllNullableTypesWithoutRecursion?,
      callback: (Result<AllNullableTypesWithoutRecursion?>) -> Unit
  )

  fun callFlutterSendMultipleNullableTypesWithoutRecursion(
      aNullableBool: Boolean?,
      aNullableInt: Long?,
      aNullableString: String?,
      callback: (Result<AllNullableTypesWithoutRecursion>) -> Unit
  )

  fun callFlutterEchoBool(aBool: Boolean, callback: (Result<Boolean>) -> Unit)

  fun callFlutterEchoInt(anInt: Long, callback: (Result<Long>) -> Unit)

  fun callFlutterEchoDouble(aDouble: Double, callback: (Result<Double>) -> Unit)

  fun callFlutterEchoString(aString: String, callback: (Result<String>) -> Unit)

  fun callFlutterEchoUint8List(list: ByteArray, callback: (Result<ByteArray>) -> Unit)

  fun callFlutterEchoList(list: List<Any?>, callback: (Result<List<Any?>>) -> Unit)

  fun callFlutterEchoEnumList(enumList: List<AnEnum?>, callback: (Result<List<AnEnum?>>) -> Unit)

  fun callFlutterEchoClassList(
      classList: List<AllNullableTypes?>,
      callback: (Result<List<AllNullableTypes?>>) -> Unit
  )

  fun callFlutterEchoNonNullEnumList(
      enumList: List<AnEnum>,
      callback: (Result<List<AnEnum>>) -> Unit
  )

  fun callFlutterEchoNonNullClassList(
      classList: List<AllNullableTypes>,
      callback: (Result<List<AllNullableTypes>>) -> Unit
  )

  fun callFlutterEchoMap(map: Map<Any?, Any?>, callback: (Result<Map<Any?, Any?>>) -> Unit)

  fun callFlutterEchoStringMap(
      stringMap: Map<String?, String?>,
      callback: (Result<Map<String?, String?>>) -> Unit
  )

  fun callFlutterEchoIntMap(
      intMap: Map<Long?, Long?>,
      callback: (Result<Map<Long?, Long?>>) -> Unit
  )

  fun callFlutterEchoEnumMap(
      enumMap: Map<AnEnum?, AnEnum?>,
      callback: (Result<Map<AnEnum?, AnEnum?>>) -> Unit
  )

  fun callFlutterEchoClassMap(
      classMap: Map<Long?, AllNullableTypes?>,
      callback: (Result<Map<Long?, AllNullableTypes?>>) -> Unit
  )

  fun callFlutterEchoNonNullStringMap(
      stringMap: Map<String, String>,
      callback: (Result<Map<String, String>>) -> Unit
  )

  fun callFlutterEchoNonNullIntMap(
      intMap: Map<Long, Long>,
      callback: (Result<Map<Long, Long>>) -> Unit
  )

  fun callFlutterEchoNonNullEnumMap(
      enumMap: Map<AnEnum, AnEnum>,
      callback: (Result<Map<AnEnum, AnEnum>>) -> Unit
  )

  fun callFlutterEchoNonNullClassMap(
      classMap: Map<Long, AllNullableTypes>,
      callback: (Result<Map<Long, AllNullableTypes>>) -> Unit
  )

  fun callFlutterEchoEnum(anEnum: AnEnum, callback: (Result<AnEnum>) -> Unit)

  fun callFlutterEchoAnotherEnum(anotherEnum: AnotherEnum, callback: (Result<AnotherEnum>) -> Unit)

  fun callFlutterEchoNullableBool(aBool: Boolean?, callback: (Result<Boolean?>) -> Unit)

  fun callFlutterEchoNullableInt(anInt: Long?, callback: (Result<Long?>) -> Unit)

  fun callFlutterEchoNullableDouble(aDouble: Double?, callback: (Result<Double?>) -> Unit)

  fun callFlutterEchoNullableString(aString: String?, callback: (Result<String?>) -> Unit)

  fun callFlutterEchoNullableUint8List(list: ByteArray?, callback: (Result<ByteArray?>) -> Unit)

  fun callFlutterEchoNullableList(list: List<Any?>?, callback: (Result<List<Any?>?>) -> Unit)

  fun callFlutterEchoNullableEnumList(
      enumList: List<AnEnum?>?,
      callback: (Result<List<AnEnum?>?>) -> Unit
  )

  fun callFlutterEchoNullableClassList(
      classList: List<AllNullableTypes?>?,
      callback: (Result<List<AllNullableTypes?>?>) -> Unit
  )

  fun callFlutterEchoNullableNonNullEnumList(
      enumList: List<AnEnum>?,
      callback: (Result<List<AnEnum>?>) -> Unit
  )

  fun callFlutterEchoNullableNonNullClassList(
      classList: List<AllNullableTypes>?,
      callback: (Result<List<AllNullableTypes>?>) -> Unit
  )

  fun callFlutterEchoNullableMap(
      map: Map<Any?, Any?>?,
      callback: (Result<Map<Any?, Any?>?>) -> Unit
  )

  fun callFlutterEchoNullableStringMap(
      stringMap: Map<String?, String?>?,
      callback: (Result<Map<String?, String?>?>) -> Unit
  )

  fun callFlutterEchoNullableIntMap(
      intMap: Map<Long?, Long?>?,
      callback: (Result<Map<Long?, Long?>?>) -> Unit
  )

  fun callFlutterEchoNullableEnumMap(
      enumMap: Map<AnEnum?, AnEnum?>?,
      callback: (Result<Map<AnEnum?, AnEnum?>?>) -> Unit
  )

  fun callFlutterEchoNullableClassMap(
      classMap: Map<Long?, AllNullableTypes?>?,
      callback: (Result<Map<Long?, AllNullableTypes?>?>) -> Unit
  )

  fun callFlutterEchoNullableNonNullStringMap(
      stringMap: Map<String, String>?,
      callback: (Result<Map<String, String>?>) -> Unit
  )

  fun callFlutterEchoNullableNonNullIntMap(
      intMap: Map<Long, Long>?,
      callback: (Result<Map<Long, Long>?>) -> Unit
  )

  fun callFlutterEchoNullableNonNullEnumMap(
      enumMap: Map<AnEnum, AnEnum>?,
      callback: (Result<Map<AnEnum, AnEnum>?>) -> Unit
  )

  fun callFlutterEchoNullableNonNullClassMap(
      classMap: Map<Long, AllNullableTypes>?,
      callback: (Result<Map<Long, AllNullableTypes>?>) -> Unit
  )

  fun callFlutterEchoNullableEnum(anEnum: AnEnum?, callback: (Result<AnEnum?>) -> Unit)

  fun callFlutterEchoAnotherNullableEnum(
      anotherEnum: AnotherEnum?,
      callback: (Result<AnotherEnum?>) -> Unit
  )

  fun callFlutterSmallApiEchoString(aString: String, callback: (Result<String>) -> Unit)

  companion object {
    /** The codec used by HostIntegrationCoreApi. */
    val codec: MessageCodec<Any?> by lazy { CoreTestsPigeonCodec() }
    /**
     * Sets up an instance of `HostIntegrationCoreApi` to handle messages through the
     * `binaryMessenger`.
     */
    @JvmOverloads
    fun setUp(
        binaryMessenger: BinaryMessenger,
        api: HostIntegrationCoreApi?,
        messageChannelSuffix: String = ""
    ) {
      val separatedMessageChannelSuffix =
          if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      val taskQueue = binaryMessenger.makeBackgroundTaskQueue()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.noop$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> =
                try {
                  api.noop()
                  listOf(null)
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAllTypes$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val everythingArg = args[0] as AllTypes
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoAllTypes(everythingArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.throwError$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> =
                try {
                  listOf(api.throwError())
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.throwErrorFromVoid$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> =
                try {
                  api.throwErrorFromVoid()
                  listOf(null)
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.throwFlutterError$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> =
                try {
                  listOf(api.throwFlutterError())
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoInt$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val anIntArg = args[0] as Long
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoInt(anIntArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoDouble$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aDoubleArg = args[0] as Double
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoDouble(aDoubleArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoBool$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aBoolArg = args[0] as Boolean
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoBool(aBoolArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoString$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aStringArg = args[0] as String
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoString(aStringArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoUint8List$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aUint8ListArg = args[0] as ByteArray
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoUint8List(aUint8ListArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoObject$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val anObjectArg = args[0] as Any
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoObject(anObjectArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val listArg = args[0] as List<Any?>
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoList(listArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoEnumList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val enumListArg = args[0] as List<AnEnum?>
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoEnumList(enumListArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoClassList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val classListArg = args[0] as List<AllNullableTypes?>
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoClassList(classListArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNonNullEnumList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val enumListArg = args[0] as List<AnEnum>
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNonNullEnumList(enumListArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNonNullClassList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val classListArg = args[0] as List<AllNullableTypes>
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNonNullClassList(classListArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val mapArg = args[0] as Map<Any?, Any?>
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoMap(mapArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoStringMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val stringMapArg = args[0] as Map<String?, String?>
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoStringMap(stringMapArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoIntMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val intMapArg = args[0] as Map<Long?, Long?>
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoIntMap(intMapArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoEnumMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val enumMapArg = args[0] as Map<AnEnum?, AnEnum?>
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoEnumMap(enumMapArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoClassMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val classMapArg = args[0] as Map<Long?, AllNullableTypes?>
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoClassMap(classMapArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNonNullStringMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val stringMapArg = args[0] as Map<String, String>
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNonNullStringMap(stringMapArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNonNullIntMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val intMapArg = args[0] as Map<Long, Long>
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNonNullIntMap(intMapArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNonNullEnumMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val enumMapArg = args[0] as Map<AnEnum, AnEnum>
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNonNullEnumMap(enumMapArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNonNullClassMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val classMapArg = args[0] as Map<Long, AllNullableTypes>
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNonNullClassMap(classMapArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoClassWrapper$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val wrapperArg = args[0] as AllClassesWrapper
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoClassWrapper(wrapperArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoEnum$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val anEnumArg = args[0] as AnEnum
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoEnum(anEnumArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAnotherEnum$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val anotherEnumArg = args[0] as AnotherEnum
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoAnotherEnum(anotherEnumArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNamedDefaultString$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aStringArg = args[0] as String
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNamedDefaultString(aStringArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoOptionalDefaultDouble$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aDoubleArg = args[0] as Double
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoOptionalDefaultDouble(aDoubleArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoRequiredInt$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val anIntArg = args[0] as Long
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoRequiredInt(anIntArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAllNullableTypes$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val everythingArg = args[0] as AllNullableTypes?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoAllNullableTypes(everythingArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAllNullableTypesWithoutRecursion$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val everythingArg = args[0] as AllNullableTypesWithoutRecursion?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoAllNullableTypesWithoutRecursion(everythingArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.extractNestedNullableString$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val wrapperArg = args[0] as AllClassesWrapper
            val wrapped: List<Any?> =
                try {
                  listOf(api.extractNestedNullableString(wrapperArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.createNestedNullableString$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val nullableStringArg = args[0] as String?
            val wrapped: List<Any?> =
                try {
                  listOf(api.createNestedNullableString(nullableStringArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.sendMultipleNullableTypes$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aNullableBoolArg = args[0] as Boolean?
            val aNullableIntArg = args[1] as Long?
            val aNullableStringArg = args[2] as String?
            val wrapped: List<Any?> =
                try {
                  listOf(
                      api.sendMultipleNullableTypes(
                          aNullableBoolArg, aNullableIntArg, aNullableStringArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.sendMultipleNullableTypesWithoutRecursion$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aNullableBoolArg = args[0] as Boolean?
            val aNullableIntArg = args[1] as Long?
            val aNullableStringArg = args[2] as String?
            val wrapped: List<Any?> =
                try {
                  listOf(
                      api.sendMultipleNullableTypesWithoutRecursion(
                          aNullableBoolArg, aNullableIntArg, aNullableStringArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableInt$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aNullableIntArg = args[0] as Long?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableInt(aNullableIntArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableDouble$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aNullableDoubleArg = args[0] as Double?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableDouble(aNullableDoubleArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableBool$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aNullableBoolArg = args[0] as Boolean?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableBool(aNullableBoolArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableString$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aNullableStringArg = args[0] as String?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableString(aNullableStringArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableUint8List$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aNullableUint8ListArg = args[0] as ByteArray?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableUint8List(aNullableUint8ListArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableObject$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aNullableObjectArg = args[0]
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableObject(aNullableObjectArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aNullableListArg = args[0] as List<Any?>?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableList(aNullableListArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableEnumList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val enumListArg = args[0] as List<AnEnum?>?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableEnumList(enumListArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableClassList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val classListArg = args[0] as List<AllNullableTypes?>?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableClassList(classListArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableNonNullEnumList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val enumListArg = args[0] as List<AnEnum>?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableNonNullEnumList(enumListArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableNonNullClassList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val classListArg = args[0] as List<AllNullableTypes>?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableNonNullClassList(classListArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val mapArg = args[0] as Map<Any?, Any?>?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableMap(mapArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableStringMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val stringMapArg = args[0] as Map<String?, String?>?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableStringMap(stringMapArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableIntMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val intMapArg = args[0] as Map<Long?, Long?>?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableIntMap(intMapArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableEnumMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val enumMapArg = args[0] as Map<AnEnum?, AnEnum?>?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableEnumMap(enumMapArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableClassMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val classMapArg = args[0] as Map<Long?, AllNullableTypes?>?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableClassMap(classMapArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableNonNullStringMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val stringMapArg = args[0] as Map<String, String>?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableNonNullStringMap(stringMapArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableNonNullIntMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val intMapArg = args[0] as Map<Long, Long>?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableNonNullIntMap(intMapArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableNonNullEnumMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val enumMapArg = args[0] as Map<AnEnum, AnEnum>?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableNonNullEnumMap(enumMapArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableNonNullClassMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val classMapArg = args[0] as Map<Long, AllNullableTypes>?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableNonNullClassMap(classMapArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableEnum$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val anEnumArg = args[0] as AnEnum?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableEnum(anEnumArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAnotherNullableEnum$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val anotherEnumArg = args[0] as AnotherEnum?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoAnotherNullableEnum(anotherEnumArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoOptionalNullableInt$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aNullableIntArg = args[0] as Long?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoOptionalNullableInt(aNullableIntArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNamedNullableString$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aNullableStringArg = args[0] as String?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNamedNullableString(aNullableStringArg))
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.noopAsync$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.noopAsync { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                reply.reply(CoreTestsPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncInt$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val anIntArg = args[0] as Long
            api.echoAsyncInt(anIntArg) { result: Result<Long> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncDouble$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aDoubleArg = args[0] as Double
            api.echoAsyncDouble(aDoubleArg) { result: Result<Double> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncBool$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aBoolArg = args[0] as Boolean
            api.echoAsyncBool(aBoolArg) { result: Result<Boolean> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncString$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aStringArg = args[0] as String
            api.echoAsyncString(aStringArg) { result: Result<String> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncUint8List$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aUint8ListArg = args[0] as ByteArray
            api.echoAsyncUint8List(aUint8ListArg) { result: Result<ByteArray> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncObject$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val anObjectArg = args[0] as Any
            api.echoAsyncObject(anObjectArg) { result: Result<Any> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val listArg = args[0] as List<Any?>
            api.echoAsyncList(listArg) { result: Result<List<Any?>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncEnumList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val enumListArg = args[0] as List<AnEnum?>
            api.echoAsyncEnumList(enumListArg) { result: Result<List<AnEnum?>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncClassList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val classListArg = args[0] as List<AllNullableTypes?>
            api.echoAsyncClassList(classListArg) { result: Result<List<AllNullableTypes?>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val mapArg = args[0] as Map<Any?, Any?>
            api.echoAsyncMap(mapArg) { result: Result<Map<Any?, Any?>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncStringMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val stringMapArg = args[0] as Map<String?, String?>
            api.echoAsyncStringMap(stringMapArg) { result: Result<Map<String?, String?>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncIntMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val intMapArg = args[0] as Map<Long?, Long?>
            api.echoAsyncIntMap(intMapArg) { result: Result<Map<Long?, Long?>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncEnumMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val enumMapArg = args[0] as Map<AnEnum?, AnEnum?>
            api.echoAsyncEnumMap(enumMapArg) { result: Result<Map<AnEnum?, AnEnum?>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncClassMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val classMapArg = args[0] as Map<Long?, AllNullableTypes?>
            api.echoAsyncClassMap(classMapArg) { result: Result<Map<Long?, AllNullableTypes?>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncEnum$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val anEnumArg = args[0] as AnEnum
            api.echoAsyncEnum(anEnumArg) { result: Result<AnEnum> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAnotherAsyncEnum$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val anotherEnumArg = args[0] as AnotherEnum
            api.echoAnotherAsyncEnum(anotherEnumArg) { result: Result<AnotherEnum> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.throwAsyncError$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.throwAsyncError { result: Result<Any?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.throwAsyncErrorFromVoid$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.throwAsyncErrorFromVoid { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                reply.reply(CoreTestsPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.throwAsyncFlutterError$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.throwAsyncFlutterError { result: Result<Any?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncAllTypes$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val everythingArg = args[0] as AllTypes
            api.echoAsyncAllTypes(everythingArg) { result: Result<AllTypes> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableAllNullableTypes$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val everythingArg = args[0] as AllNullableTypes?
            api.echoAsyncNullableAllNullableTypes(everythingArg) { result: Result<AllNullableTypes?>
              ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableAllNullableTypesWithoutRecursion$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val everythingArg = args[0] as AllNullableTypesWithoutRecursion?
            api.echoAsyncNullableAllNullableTypesWithoutRecursion(everythingArg) {
                result: Result<AllNullableTypesWithoutRecursion?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableInt$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val anIntArg = args[0] as Long?
            api.echoAsyncNullableInt(anIntArg) { result: Result<Long?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableDouble$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aDoubleArg = args[0] as Double?
            api.echoAsyncNullableDouble(aDoubleArg) { result: Result<Double?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableBool$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aBoolArg = args[0] as Boolean?
            api.echoAsyncNullableBool(aBoolArg) { result: Result<Boolean?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableString$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aStringArg = args[0] as String?
            api.echoAsyncNullableString(aStringArg) { result: Result<String?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableUint8List$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aUint8ListArg = args[0] as ByteArray?
            api.echoAsyncNullableUint8List(aUint8ListArg) { result: Result<ByteArray?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableObject$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val anObjectArg = args[0]
            api.echoAsyncNullableObject(anObjectArg) { result: Result<Any?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val listArg = args[0] as List<Any?>?
            api.echoAsyncNullableList(listArg) { result: Result<List<Any?>?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableEnumList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val enumListArg = args[0] as List<AnEnum?>?
            api.echoAsyncNullableEnumList(enumListArg) { result: Result<List<AnEnum?>?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableClassList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val classListArg = args[0] as List<AllNullableTypes?>?
            api.echoAsyncNullableClassList(classListArg) { result: Result<List<AllNullableTypes?>?>
              ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val mapArg = args[0] as Map<Any?, Any?>?
            api.echoAsyncNullableMap(mapArg) { result: Result<Map<Any?, Any?>?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableStringMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val stringMapArg = args[0] as Map<String?, String?>?
            api.echoAsyncNullableStringMap(stringMapArg) { result: Result<Map<String?, String?>?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableIntMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val intMapArg = args[0] as Map<Long?, Long?>?
            api.echoAsyncNullableIntMap(intMapArg) { result: Result<Map<Long?, Long?>?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableEnumMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val enumMapArg = args[0] as Map<AnEnum?, AnEnum?>?
            api.echoAsyncNullableEnumMap(enumMapArg) { result: Result<Map<AnEnum?, AnEnum?>?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableClassMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val classMapArg = args[0] as Map<Long?, AllNullableTypes?>?
            api.echoAsyncNullableClassMap(classMapArg) {
                result: Result<Map<Long?, AllNullableTypes?>?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableEnum$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val anEnumArg = args[0] as AnEnum?
            api.echoAsyncNullableEnum(anEnumArg) { result: Result<AnEnum?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAnotherAsyncNullableEnum$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val anotherEnumArg = args[0] as AnotherEnum?
            api.echoAnotherAsyncNullableEnum(anotherEnumArg) { result: Result<AnotherEnum?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.defaultIsMainThread$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> =
                try {
                  listOf(api.defaultIsMainThread())
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.taskQueueIsBackgroundThread$separatedMessageChannelSuffix",
                codec,
                taskQueue)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> =
                try {
                  listOf(api.taskQueueIsBackgroundThread())
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterNoop$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.callFlutterNoop { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                reply.reply(CoreTestsPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterThrowError$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.callFlutterThrowError { result: Result<Any?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterThrowErrorFromVoid$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.callFlutterThrowErrorFromVoid { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                reply.reply(CoreTestsPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoAllTypes$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val everythingArg = args[0] as AllTypes
            api.callFlutterEchoAllTypes(everythingArg) { result: Result<AllTypes> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoAllNullableTypes$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val everythingArg = args[0] as AllNullableTypes?
            api.callFlutterEchoAllNullableTypes(everythingArg) { result: Result<AllNullableTypes?>
              ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterSendMultipleNullableTypes$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aNullableBoolArg = args[0] as Boolean?
            val aNullableIntArg = args[1] as Long?
            val aNullableStringArg = args[2] as String?
            api.callFlutterSendMultipleNullableTypes(
                aNullableBoolArg, aNullableIntArg, aNullableStringArg) {
                    result: Result<AllNullableTypes> ->
                  val error = result.exceptionOrNull()
                  if (error != null) {
                    reply.reply(CoreTestsPigeonUtils.wrapError(error))
                  } else {
                    val data = result.getOrNull()
                    reply.reply(CoreTestsPigeonUtils.wrapResult(data))
                  }
                }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoAllNullableTypesWithoutRecursion$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val everythingArg = args[0] as AllNullableTypesWithoutRecursion?
            api.callFlutterEchoAllNullableTypesWithoutRecursion(everythingArg) {
                result: Result<AllNullableTypesWithoutRecursion?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterSendMultipleNullableTypesWithoutRecursion$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aNullableBoolArg = args[0] as Boolean?
            val aNullableIntArg = args[1] as Long?
            val aNullableStringArg = args[2] as String?
            api.callFlutterSendMultipleNullableTypesWithoutRecursion(
                aNullableBoolArg, aNullableIntArg, aNullableStringArg) {
                    result: Result<AllNullableTypesWithoutRecursion> ->
                  val error = result.exceptionOrNull()
                  if (error != null) {
                    reply.reply(CoreTestsPigeonUtils.wrapError(error))
                  } else {
                    val data = result.getOrNull()
                    reply.reply(CoreTestsPigeonUtils.wrapResult(data))
                  }
                }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoBool$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aBoolArg = args[0] as Boolean
            api.callFlutterEchoBool(aBoolArg) { result: Result<Boolean> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoInt$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val anIntArg = args[0] as Long
            api.callFlutterEchoInt(anIntArg) { result: Result<Long> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoDouble$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aDoubleArg = args[0] as Double
            api.callFlutterEchoDouble(aDoubleArg) { result: Result<Double> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoString$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aStringArg = args[0] as String
            api.callFlutterEchoString(aStringArg) { result: Result<String> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoUint8List$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val listArg = args[0] as ByteArray
            api.callFlutterEchoUint8List(listArg) { result: Result<ByteArray> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val listArg = args[0] as List<Any?>
            api.callFlutterEchoList(listArg) { result: Result<List<Any?>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoEnumList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val enumListArg = args[0] as List<AnEnum?>
            api.callFlutterEchoEnumList(enumListArg) { result: Result<List<AnEnum?>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoClassList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val classListArg = args[0] as List<AllNullableTypes?>
            api.callFlutterEchoClassList(classListArg) { result: Result<List<AllNullableTypes?>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNonNullEnumList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val enumListArg = args[0] as List<AnEnum>
            api.callFlutterEchoNonNullEnumList(enumListArg) { result: Result<List<AnEnum>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNonNullClassList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val classListArg = args[0] as List<AllNullableTypes>
            api.callFlutterEchoNonNullClassList(classListArg) {
                result: Result<List<AllNullableTypes>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val mapArg = args[0] as Map<Any?, Any?>
            api.callFlutterEchoMap(mapArg) { result: Result<Map<Any?, Any?>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoStringMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val stringMapArg = args[0] as Map<String?, String?>
            api.callFlutterEchoStringMap(stringMapArg) { result: Result<Map<String?, String?>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoIntMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val intMapArg = args[0] as Map<Long?, Long?>
            api.callFlutterEchoIntMap(intMapArg) { result: Result<Map<Long?, Long?>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoEnumMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val enumMapArg = args[0] as Map<AnEnum?, AnEnum?>
            api.callFlutterEchoEnumMap(enumMapArg) { result: Result<Map<AnEnum?, AnEnum?>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoClassMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val classMapArg = args[0] as Map<Long?, AllNullableTypes?>
            api.callFlutterEchoClassMap(classMapArg) { result: Result<Map<Long?, AllNullableTypes?>>
              ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNonNullStringMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val stringMapArg = args[0] as Map<String, String>
            api.callFlutterEchoNonNullStringMap(stringMapArg) { result: Result<Map<String, String>>
              ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNonNullIntMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val intMapArg = args[0] as Map<Long, Long>
            api.callFlutterEchoNonNullIntMap(intMapArg) { result: Result<Map<Long, Long>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNonNullEnumMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val enumMapArg = args[0] as Map<AnEnum, AnEnum>
            api.callFlutterEchoNonNullEnumMap(enumMapArg) { result: Result<Map<AnEnum, AnEnum>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNonNullClassMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val classMapArg = args[0] as Map<Long, AllNullableTypes>
            api.callFlutterEchoNonNullClassMap(classMapArg) {
                result: Result<Map<Long, AllNullableTypes>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoEnum$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val anEnumArg = args[0] as AnEnum
            api.callFlutterEchoEnum(anEnumArg) { result: Result<AnEnum> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoAnotherEnum$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val anotherEnumArg = args[0] as AnotherEnum
            api.callFlutterEchoAnotherEnum(anotherEnumArg) { result: Result<AnotherEnum> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableBool$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aBoolArg = args[0] as Boolean?
            api.callFlutterEchoNullableBool(aBoolArg) { result: Result<Boolean?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableInt$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val anIntArg = args[0] as Long?
            api.callFlutterEchoNullableInt(anIntArg) { result: Result<Long?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableDouble$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aDoubleArg = args[0] as Double?
            api.callFlutterEchoNullableDouble(aDoubleArg) { result: Result<Double?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableString$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aStringArg = args[0] as String?
            api.callFlutterEchoNullableString(aStringArg) { result: Result<String?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableUint8List$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val listArg = args[0] as ByteArray?
            api.callFlutterEchoNullableUint8List(listArg) { result: Result<ByteArray?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val listArg = args[0] as List<Any?>?
            api.callFlutterEchoNullableList(listArg) { result: Result<List<Any?>?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableEnumList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val enumListArg = args[0] as List<AnEnum?>?
            api.callFlutterEchoNullableEnumList(enumListArg) { result: Result<List<AnEnum?>?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableClassList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val classListArg = args[0] as List<AllNullableTypes?>?
            api.callFlutterEchoNullableClassList(classListArg) {
                result: Result<List<AllNullableTypes?>?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableNonNullEnumList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val enumListArg = args[0] as List<AnEnum>?
            api.callFlutterEchoNullableNonNullEnumList(enumListArg) { result: Result<List<AnEnum>?>
              ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableNonNullClassList$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val classListArg = args[0] as List<AllNullableTypes>?
            api.callFlutterEchoNullableNonNullClassList(classListArg) {
                result: Result<List<AllNullableTypes>?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val mapArg = args[0] as Map<Any?, Any?>?
            api.callFlutterEchoNullableMap(mapArg) { result: Result<Map<Any?, Any?>?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableStringMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val stringMapArg = args[0] as Map<String?, String?>?
            api.callFlutterEchoNullableStringMap(stringMapArg) {
                result: Result<Map<String?, String?>?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableIntMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val intMapArg = args[0] as Map<Long?, Long?>?
            api.callFlutterEchoNullableIntMap(intMapArg) { result: Result<Map<Long?, Long?>?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableEnumMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val enumMapArg = args[0] as Map<AnEnum?, AnEnum?>?
            api.callFlutterEchoNullableEnumMap(enumMapArg) { result: Result<Map<AnEnum?, AnEnum?>?>
              ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableClassMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val classMapArg = args[0] as Map<Long?, AllNullableTypes?>?
            api.callFlutterEchoNullableClassMap(classMapArg) {
                result: Result<Map<Long?, AllNullableTypes?>?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableNonNullStringMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val stringMapArg = args[0] as Map<String, String>?
            api.callFlutterEchoNullableNonNullStringMap(stringMapArg) {
                result: Result<Map<String, String>?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableNonNullIntMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val intMapArg = args[0] as Map<Long, Long>?
            api.callFlutterEchoNullableNonNullIntMap(intMapArg) { result: Result<Map<Long, Long>?>
              ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableNonNullEnumMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val enumMapArg = args[0] as Map<AnEnum, AnEnum>?
            api.callFlutterEchoNullableNonNullEnumMap(enumMapArg) {
                result: Result<Map<AnEnum, AnEnum>?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableNonNullClassMap$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val classMapArg = args[0] as Map<Long, AllNullableTypes>?
            api.callFlutterEchoNullableNonNullClassMap(classMapArg) {
                result: Result<Map<Long, AllNullableTypes>?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableEnum$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val anEnumArg = args[0] as AnEnum?
            api.callFlutterEchoNullableEnum(anEnumArg) { result: Result<AnEnum?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoAnotherNullableEnum$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val anotherEnumArg = args[0] as AnotherEnum?
            api.callFlutterEchoAnotherNullableEnum(anotherEnumArg) { result: Result<AnotherEnum?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterSmallApiEchoString$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aStringArg = args[0] as String
            api.callFlutterSmallApiEchoString(aStringArg) { result: Result<String> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/**
 * The core interface that the Dart platform_test code implements for host integration tests to call
 * into.
 *
 * Generated class from Pigeon that represents Flutter messages that can be called from Kotlin.
 */
class FlutterIntegrationCoreApi(
    private val binaryMessenger: BinaryMessenger,
    private val messageChannelSuffix: String = ""
) {
  companion object {
    /** The codec used by FlutterIntegrationCoreApi. */
    val codec: MessageCodec<Any?> by lazy { CoreTestsPigeonCodec() }
  }
  /** A no-op function taking no arguments and returning no value, to sanity test basic calling. */
  fun noop(callback: (Result<Unit>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.noop$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(null) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Responds with an error from an async function returning a value. */
  fun throwError(callback: (Result<Any?>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.throwError$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(null) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0]
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Responds with an error from an async void function. */
  fun throwErrorFromVoid(callback: (Result<Unit>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.throwErrorFromVoid$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(null) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed object, to test serialization and deserialization. */
  fun echoAllTypes(everythingArg: AllTypes, callback: (Result<AllTypes>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoAllTypes$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(everythingArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as AllTypes
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed object, to test serialization and deserialization. */
  fun echoAllNullableTypes(
      everythingArg: AllNullableTypes?,
      callback: (Result<AllNullableTypes?>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoAllNullableTypes$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(everythingArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as AllNullableTypes?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /**
   * Returns passed in arguments of multiple types.
   *
   * Tests multiple-arity FlutterApi handling.
   */
  fun sendMultipleNullableTypes(
      aNullableBoolArg: Boolean?,
      aNullableIntArg: Long?,
      aNullableStringArg: String?,
      callback: (Result<AllNullableTypes>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.sendMultipleNullableTypes$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(aNullableBoolArg, aNullableIntArg, aNullableStringArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as AllNullableTypes
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed object, to test serialization and deserialization. */
  fun echoAllNullableTypesWithoutRecursion(
      everythingArg: AllNullableTypesWithoutRecursion?,
      callback: (Result<AllNullableTypesWithoutRecursion?>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoAllNullableTypesWithoutRecursion$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(everythingArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as AllNullableTypesWithoutRecursion?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /**
   * Returns passed in arguments of multiple types.
   *
   * Tests multiple-arity FlutterApi handling.
   */
  fun sendMultipleNullableTypesWithoutRecursion(
      aNullableBoolArg: Boolean?,
      aNullableIntArg: Long?,
      aNullableStringArg: String?,
      callback: (Result<AllNullableTypesWithoutRecursion>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.sendMultipleNullableTypesWithoutRecursion$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(aNullableBoolArg, aNullableIntArg, aNullableStringArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as AllNullableTypesWithoutRecursion
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed boolean, to test serialization and deserialization. */
  fun echoBool(aBoolArg: Boolean, callback: (Result<Boolean>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoBool$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(aBoolArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as Boolean
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed int, to test serialization and deserialization. */
  fun echoInt(anIntArg: Long, callback: (Result<Long>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoInt$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(anIntArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as Long
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed double, to test serialization and deserialization. */
  fun echoDouble(aDoubleArg: Double, callback: (Result<Double>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoDouble$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(aDoubleArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as Double
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed string, to test serialization and deserialization. */
  fun echoString(aStringArg: String, callback: (Result<String>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoString$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(aStringArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as String
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed byte list, to test serialization and deserialization. */
  fun echoUint8List(listArg: ByteArray, callback: (Result<ByteArray>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoUint8List$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(listArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as ByteArray
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed list, to test serialization and deserialization. */
  fun echoList(listArg: List<Any?>, callback: (Result<List<Any?>>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoList$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(listArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as List<Any?>
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed list, to test serialization and deserialization. */
  fun echoEnumList(enumListArg: List<AnEnum?>, callback: (Result<List<AnEnum?>>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoEnumList$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(enumListArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as List<AnEnum?>
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed list, to test serialization and deserialization. */
  fun echoClassList(
      classListArg: List<AllNullableTypes?>,
      callback: (Result<List<AllNullableTypes?>>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoClassList$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(classListArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as List<AllNullableTypes?>
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed list, to test serialization and deserialization. */
  fun echoNonNullEnumList(enumListArg: List<AnEnum>, callback: (Result<List<AnEnum>>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNonNullEnumList$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(enumListArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as List<AnEnum>
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed list, to test serialization and deserialization. */
  fun echoNonNullClassList(
      classListArg: List<AllNullableTypes>,
      callback: (Result<List<AllNullableTypes>>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNonNullClassList$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(classListArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as List<AllNullableTypes>
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoMap(mapArg: Map<Any?, Any?>, callback: (Result<Map<Any?, Any?>>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoMap$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(mapArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as Map<Any?, Any?>
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoStringMap(
      stringMapArg: Map<String?, String?>,
      callback: (Result<Map<String?, String?>>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoStringMap$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(stringMapArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as Map<String?, String?>
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoIntMap(intMapArg: Map<Long?, Long?>, callback: (Result<Map<Long?, Long?>>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoIntMap$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(intMapArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as Map<Long?, Long?>
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoEnumMap(
      enumMapArg: Map<AnEnum?, AnEnum?>,
      callback: (Result<Map<AnEnum?, AnEnum?>>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoEnumMap$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(enumMapArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as Map<AnEnum?, AnEnum?>
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoClassMap(
      classMapArg: Map<Long?, AllNullableTypes?>,
      callback: (Result<Map<Long?, AllNullableTypes?>>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoClassMap$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(classMapArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as Map<Long?, AllNullableTypes?>
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNonNullStringMap(
      stringMapArg: Map<String, String>,
      callback: (Result<Map<String, String>>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNonNullStringMap$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(stringMapArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as Map<String, String>
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNonNullIntMap(intMapArg: Map<Long, Long>, callback: (Result<Map<Long, Long>>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNonNullIntMap$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(intMapArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as Map<Long, Long>
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNonNullEnumMap(
      enumMapArg: Map<AnEnum, AnEnum>,
      callback: (Result<Map<AnEnum, AnEnum>>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNonNullEnumMap$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(enumMapArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as Map<AnEnum, AnEnum>
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNonNullClassMap(
      classMapArg: Map<Long, AllNullableTypes>,
      callback: (Result<Map<Long, AllNullableTypes>>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNonNullClassMap$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(classMapArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as Map<Long, AllNullableTypes>
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed enum to test serialization and deserialization. */
  fun echoEnum(anEnumArg: AnEnum, callback: (Result<AnEnum>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoEnum$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(anEnumArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as AnEnum
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed enum to test serialization and deserialization. */
  fun echoAnotherEnum(anotherEnumArg: AnotherEnum, callback: (Result<AnotherEnum>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoAnotherEnum$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(anotherEnumArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as AnotherEnum
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed boolean, to test serialization and deserialization. */
  fun echoNullableBool(aBoolArg: Boolean?, callback: (Result<Boolean?>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableBool$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(aBoolArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as Boolean?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed int, to test serialization and deserialization. */
  fun echoNullableInt(anIntArg: Long?, callback: (Result<Long?>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableInt$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(anIntArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as Long?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed double, to test serialization and deserialization. */
  fun echoNullableDouble(aDoubleArg: Double?, callback: (Result<Double?>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableDouble$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(aDoubleArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as Double?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed string, to test serialization and deserialization. */
  fun echoNullableString(aStringArg: String?, callback: (Result<String?>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableString$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(aStringArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as String?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed byte list, to test serialization and deserialization. */
  fun echoNullableUint8List(listArg: ByteArray?, callback: (Result<ByteArray?>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableUint8List$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(listArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as ByteArray?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed list, to test serialization and deserialization. */
  fun echoNullableList(listArg: List<Any?>?, callback: (Result<List<Any?>?>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableList$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(listArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as List<Any?>?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed list, to test serialization and deserialization. */
  fun echoNullableEnumList(
      enumListArg: List<AnEnum?>?,
      callback: (Result<List<AnEnum?>?>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableEnumList$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(enumListArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as List<AnEnum?>?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed list, to test serialization and deserialization. */
  fun echoNullableClassList(
      classListArg: List<AllNullableTypes?>?,
      callback: (Result<List<AllNullableTypes?>?>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableClassList$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(classListArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as List<AllNullableTypes?>?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed list, to test serialization and deserialization. */
  fun echoNullableNonNullEnumList(
      enumListArg: List<AnEnum>?,
      callback: (Result<List<AnEnum>?>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableNonNullEnumList$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(enumListArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as List<AnEnum>?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed list, to test serialization and deserialization. */
  fun echoNullableNonNullClassList(
      classListArg: List<AllNullableTypes>?,
      callback: (Result<List<AllNullableTypes>?>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableNonNullClassList$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(classListArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as List<AllNullableTypes>?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNullableMap(mapArg: Map<Any?, Any?>?, callback: (Result<Map<Any?, Any?>?>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableMap$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(mapArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as Map<Any?, Any?>?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNullableStringMap(
      stringMapArg: Map<String?, String?>?,
      callback: (Result<Map<String?, String?>?>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableStringMap$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(stringMapArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as Map<String?, String?>?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNullableIntMap(
      intMapArg: Map<Long?, Long?>?,
      callback: (Result<Map<Long?, Long?>?>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableIntMap$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(intMapArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as Map<Long?, Long?>?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNullableEnumMap(
      enumMapArg: Map<AnEnum?, AnEnum?>?,
      callback: (Result<Map<AnEnum?, AnEnum?>?>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableEnumMap$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(enumMapArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as Map<AnEnum?, AnEnum?>?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNullableClassMap(
      classMapArg: Map<Long?, AllNullableTypes?>?,
      callback: (Result<Map<Long?, AllNullableTypes?>?>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableClassMap$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(classMapArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as Map<Long?, AllNullableTypes?>?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNullableNonNullStringMap(
      stringMapArg: Map<String, String>?,
      callback: (Result<Map<String, String>?>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableNonNullStringMap$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(stringMapArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as Map<String, String>?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNullableNonNullIntMap(
      intMapArg: Map<Long, Long>?,
      callback: (Result<Map<Long, Long>?>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableNonNullIntMap$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(intMapArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as Map<Long, Long>?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNullableNonNullEnumMap(
      enumMapArg: Map<AnEnum, AnEnum>?,
      callback: (Result<Map<AnEnum, AnEnum>?>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableNonNullEnumMap$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(enumMapArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as Map<AnEnum, AnEnum>?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed map, to test serialization and deserialization. */
  fun echoNullableNonNullClassMap(
      classMapArg: Map<Long, AllNullableTypes>?,
      callback: (Result<Map<Long, AllNullableTypes>?>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableNonNullClassMap$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(classMapArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as Map<Long, AllNullableTypes>?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed enum to test serialization and deserialization. */
  fun echoNullableEnum(anEnumArg: AnEnum?, callback: (Result<AnEnum?>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableEnum$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(anEnumArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as AnEnum?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed enum to test serialization and deserialization. */
  fun echoAnotherNullableEnum(
      anotherEnumArg: AnotherEnum?,
      callback: (Result<AnotherEnum?>) -> Unit
  ) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoAnotherNullableEnum$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(anotherEnumArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as AnotherEnum?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /**
   * A no-op function taking no arguments and returning no value, to sanity test basic asynchronous
   * calling.
   */
  fun noopAsync(callback: (Result<Unit>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.noopAsync$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(null) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
  /** Returns the passed in generic Object asynchronously. */
  fun echoAsyncString(aStringArg: String, callback: (Result<String>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoAsyncString$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(aStringArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as String
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
}
/**
 * An API that can be implemented for minimal, compile-only tests.
 *
 * Generated interface from Pigeon that represents a handler of messages from Flutter.
 */
interface HostTrivialApi {
  fun noop()

  companion object {
    /** The codec used by HostTrivialApi. */
    val codec: MessageCodec<Any?> by lazy { CoreTestsPigeonCodec() }
    /** Sets up an instance of `HostTrivialApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(
        binaryMessenger: BinaryMessenger,
        api: HostTrivialApi?,
        messageChannelSuffix: String = ""
    ) {
      val separatedMessageChannelSuffix =
          if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostTrivialApi.noop$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> =
                try {
                  api.noop()
                  listOf(null)
                } catch (exception: Throwable) {
                  CoreTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/**
 * A simple API implemented in some unit tests.
 *
 * Generated interface from Pigeon that represents a handler of messages from Flutter.
 */
interface HostSmallApi {
  fun echo(aString: String, callback: (Result<String>) -> Unit)

  fun voidVoid(callback: (Result<Unit>) -> Unit)

  companion object {
    /** The codec used by HostSmallApi. */
    val codec: MessageCodec<Any?> by lazy { CoreTestsPigeonCodec() }
    /** Sets up an instance of `HostSmallApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(
        binaryMessenger: BinaryMessenger,
        api: HostSmallApi?,
        messageChannelSuffix: String = ""
    ) {
      val separatedMessageChannelSuffix =
          if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostSmallApi.echo$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aStringArg = args[0] as String
            api.echo(aStringArg) { result: Result<String> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CoreTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostSmallApi.voidVoid$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.voidVoid { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CoreTestsPigeonUtils.wrapError(error))
              } else {
                reply.reply(CoreTestsPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/**
 * A simple API called in some unit tests.
 *
 * Generated class from Pigeon that represents Flutter messages that can be called from Kotlin.
 */
class FlutterSmallApi(
    private val binaryMessenger: BinaryMessenger,
    private val messageChannelSuffix: String = ""
) {
  companion object {
    /** The codec used by FlutterSmallApi. */
    val codec: MessageCodec<Any?> by lazy { CoreTestsPigeonCodec() }
  }

  fun echoWrappedList(msgArg: TestMessage, callback: (Result<TestMessage>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterSmallApi.echoWrappedList$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(msgArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as TestMessage
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  fun echoString(aStringArg: String, callback: (Result<String>) -> Unit) {
    val separatedMessageChannelSuffix =
        if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.FlutterSmallApi.echoString$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(aStringArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  FlutterError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as String
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(CoreTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
}
