// Copyright 2013 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon, do not edit directly.
// See also: https://pub.dev/packages/pigeon

#include "messages.g.h"

struct _PigeonExamplePackageMessageData {
  GObject parent_instance;

  gchar* name;
  gchar* description;
  PigeonExamplePackageCode code;
  FlValue* data;
};

G_DEFINE_TYPE(PigeonExamplePackageMessageData,
              pigeon_example_package_message_data, G_TYPE_OBJECT)

static void pigeon_example_package_message_data_dispose(GObject* object) {
  PigeonExamplePackageMessageData* self =
      PIGEON_EXAMPLE_PACKAGE_MESSAGE_DATA(object);
  g_clear_pointer(&self->name, g_free);
  g_clear_pointer(&self->description, g_free);
  g_clear_pointer(&self->data, fl_value_unref);
  G_OBJECT_CLASS(pigeon_example_package_message_data_parent_class)
      ->dispose(object);
}

static void pigeon_example_package_message_data_init(
    PigeonExamplePackageMessageData* self) {}

static void pigeon_example_package_message_data_class_init(
    PigeonExamplePackageMessageDataClass* klass) {
  G_OBJECT_CLASS(klass)->dispose = pigeon_example_package_message_data_dispose;
}

PigeonExamplePackageMessageData* pigeon_example_package_message_data_new(
    const gchar* name, const gchar* description, PigeonExamplePackageCode code,
    FlValue* data) {
  PigeonExamplePackageMessageData* self = PIGEON_EXAMPLE_PACKAGE_MESSAGE_DATA(
      g_object_new(pigeon_example_package_message_data_get_type(), nullptr));
  if (name != nullptr) {
    self->name = g_strdup(name);
  } else {
    self->name = nullptr;
  }
  if (description != nullptr) {
    self->description = g_strdup(description);
  } else {
    self->description = nullptr;
  }
  self->code = code;
  self->data = fl_value_ref(data);
  return self;
}

const gchar* pigeon_example_package_message_data_get_name(
    PigeonExamplePackageMessageData* self) {
  g_return_val_if_fail(PIGEON_EXAMPLE_PACKAGE_IS_MESSAGE_DATA(self), nullptr);
  return self->name;
}

const gchar* pigeon_example_package_message_data_get_description(
    PigeonExamplePackageMessageData* self) {
  g_return_val_if_fail(PIGEON_EXAMPLE_PACKAGE_IS_MESSAGE_DATA(self), nullptr);
  return self->description;
}

PigeonExamplePackageCode pigeon_example_package_message_data_get_code(
    PigeonExamplePackageMessageData* self) {
  g_return_val_if_fail(PIGEON_EXAMPLE_PACKAGE_IS_MESSAGE_DATA(self),
                       static_cast<PigeonExamplePackageCode>(0));
  return self->code;
}

FlValue* pigeon_example_package_message_data_get_data(
    PigeonExamplePackageMessageData* self) {
  g_return_val_if_fail(PIGEON_EXAMPLE_PACKAGE_IS_MESSAGE_DATA(self), nullptr);
  return self->data;
}

static FlValue* pigeon_example_package_message_data_to_list(
    PigeonExamplePackageMessageData* self) {
  FlValue* values = fl_value_new_list();
  fl_value_append_take(values, self->name != nullptr
                                   ? fl_value_new_string(self->name)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->description != nullptr
                                   ? fl_value_new_string(self->description)
                                   : fl_value_new_null());
  fl_value_append_take(values,
                       fl_value_new_custom(pigeon_example_package_code_type_id,
                                           fl_value_new_int(self->code),
                                           (GDestroyNotify)fl_value_unref));
  fl_value_append_take(values, fl_value_ref(self->data));
  return values;
}

static PigeonExamplePackageMessageData*
pigeon_example_package_message_data_new_from_list(FlValue* values) {
  FlValue* value0 = fl_value_get_list_value(values, 0);
  const gchar* name = nullptr;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    name = fl_value_get_string(value0);
  }
  FlValue* value1 = fl_value_get_list_value(values, 1);
  const gchar* description = nullptr;
  if (fl_value_get_type(value1) != FL_VALUE_TYPE_NULL) {
    description = fl_value_get_string(value1);
  }
  FlValue* value2 = fl_value_get_list_value(values, 2);
  PigeonExamplePackageCode code = static_cast<PigeonExamplePackageCode>(
      fl_value_get_int(reinterpret_cast<FlValue*>(
          const_cast<gpointer>(fl_value_get_custom_value(value2)))));
  FlValue* value3 = fl_value_get_list_value(values, 3);
  FlValue* data = value3;
  return pigeon_example_package_message_data_new(name, description, code, data);
}

struct _PigeonExamplePackageMessageCodec {
  FlStandardMessageCodec parent_instance;
};

G_DEFINE_TYPE(PigeonExamplePackageMessageCodec,
              pigeon_example_package_message_codec,
              fl_standard_message_codec_get_type())

const int pigeon_example_package_code_type_id = 129;
const int pigeon_example_package_message_data_type_id = 130;

static gboolean
pigeon_example_package_message_codec_write_pigeon_example_package_code(
    FlStandardMessageCodec* codec, GByteArray* buffer, FlValue* value,
    GError** error) {
  uint8_t type = pigeon_example_package_code_type_id;
  g_byte_array_append(buffer, &type, sizeof(uint8_t));
  return fl_standard_message_codec_write_value(codec, buffer, value, error);
}

static gboolean
pigeon_example_package_message_codec_write_pigeon_example_package_message_data(
    FlStandardMessageCodec* codec, GByteArray* buffer,
    PigeonExamplePackageMessageData* value, GError** error) {
  uint8_t type = pigeon_example_package_message_data_type_id;
  g_byte_array_append(buffer, &type, sizeof(uint8_t));
  g_autoptr(FlValue) values =
      pigeon_example_package_message_data_to_list(value);
  return fl_standard_message_codec_write_value(codec, buffer, values, error);
}

static gboolean pigeon_example_package_message_codec_write_value(
    FlStandardMessageCodec* codec, GByteArray* buffer, FlValue* value,
    GError** error) {
  if (fl_value_get_type(value) == FL_VALUE_TYPE_CUSTOM) {
    switch (fl_value_get_custom_type(value)) {
      case pigeon_example_package_code_type_id:
        return pigeon_example_package_message_codec_write_pigeon_example_package_code(
            codec, buffer,
            reinterpret_cast<FlValue*>(
                const_cast<gpointer>(fl_value_get_custom_value(value))),
            error);
      case pigeon_example_package_message_data_type_id:
        return pigeon_example_package_message_codec_write_pigeon_example_package_message_data(
            codec, buffer,
            PIGEON_EXAMPLE_PACKAGE_MESSAGE_DATA(
                fl_value_get_custom_value_object(value)),
            error);
    }
  }

  return FL_STANDARD_MESSAGE_CODEC_CLASS(
             pigeon_example_package_message_codec_parent_class)
      ->write_value(codec, buffer, value, error);
}

static FlValue*
pigeon_example_package_message_codec_read_pigeon_example_package_code(
    FlStandardMessageCodec* codec, GBytes* buffer, size_t* offset,
    GError** error) {
  return fl_value_new_custom(
      pigeon_example_package_code_type_id,
      fl_standard_message_codec_read_value(codec, buffer, offset, error),
      (GDestroyNotify)fl_value_unref);
}

static FlValue*
pigeon_example_package_message_codec_read_pigeon_example_package_message_data(
    FlStandardMessageCodec* codec, GBytes* buffer, size_t* offset,
    GError** error) {
  g_autoptr(FlValue) values =
      fl_standard_message_codec_read_value(codec, buffer, offset, error);
  if (values == nullptr) {
    return nullptr;
  }

  g_autoptr(PigeonExamplePackageMessageData) value =
      pigeon_example_package_message_data_new_from_list(values);
  if (value == nullptr) {
    g_set_error(error, FL_MESSAGE_CODEC_ERROR, FL_MESSAGE_CODEC_ERROR_FAILED,
                "Invalid data received for MessageData");
    return nullptr;
  }

  return fl_value_new_custom_object(pigeon_example_package_message_data_type_id,
                                    G_OBJECT(value));
}

static FlValue* pigeon_example_package_message_codec_read_value_of_type(
    FlStandardMessageCodec* codec, GBytes* buffer, size_t* offset, int type,
    GError** error) {
  switch (type) {
    case pigeon_example_package_code_type_id:
      return pigeon_example_package_message_codec_read_pigeon_example_package_code(
          codec, buffer, offset, error);
    case pigeon_example_package_message_data_type_id:
      return pigeon_example_package_message_codec_read_pigeon_example_package_message_data(
          codec, buffer, offset, error);
    default:
      return FL_STANDARD_MESSAGE_CODEC_CLASS(
                 pigeon_example_package_message_codec_parent_class)
          ->read_value_of_type(codec, buffer, offset, type, error);
  }
}

static void pigeon_example_package_message_codec_init(
    PigeonExamplePackageMessageCodec* self) {}

static void pigeon_example_package_message_codec_class_init(
    PigeonExamplePackageMessageCodecClass* klass) {
  FL_STANDARD_MESSAGE_CODEC_CLASS(klass)->write_value =
      pigeon_example_package_message_codec_write_value;
  FL_STANDARD_MESSAGE_CODEC_CLASS(klass)->read_value_of_type =
      pigeon_example_package_message_codec_read_value_of_type;
}

static PigeonExamplePackageMessageCodec*
pigeon_example_package_message_codec_new() {
  PigeonExamplePackageMessageCodec* self = PIGEON_EXAMPLE_PACKAGE_MESSAGE_CODEC(
      g_object_new(pigeon_example_package_message_codec_get_type(), nullptr));
  return self;
}

struct _PigeonExamplePackageExampleHostApiResponseHandle {
  GObject parent_instance;

  FlBasicMessageChannel* channel;
  FlBasicMessageChannelResponseHandle* response_handle;
};

G_DEFINE_TYPE(PigeonExamplePackageExampleHostApiResponseHandle,
              pigeon_example_package_example_host_api_response_handle,
              G_TYPE_OBJECT)

static void pigeon_example_package_example_host_api_response_handle_dispose(
    GObject* object) {
  PigeonExamplePackageExampleHostApiResponseHandle* self =
      PIGEON_EXAMPLE_PACKAGE_EXAMPLE_HOST_API_RESPONSE_HANDLE(object);
  g_clear_object(&self->channel);
  g_clear_object(&self->response_handle);
  G_OBJECT_CLASS(
      pigeon_example_package_example_host_api_response_handle_parent_class)
      ->dispose(object);
}

static void pigeon_example_package_example_host_api_response_handle_init(
    PigeonExamplePackageExampleHostApiResponseHandle* self) {}

static void pigeon_example_package_example_host_api_response_handle_class_init(
    PigeonExamplePackageExampleHostApiResponseHandleClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      pigeon_example_package_example_host_api_response_handle_dispose;
}

static PigeonExamplePackageExampleHostApiResponseHandle*
pigeon_example_package_example_host_api_response_handle_new(
    FlBasicMessageChannel* channel,
    FlBasicMessageChannelResponseHandle* response_handle) {
  PigeonExamplePackageExampleHostApiResponseHandle* self =
      PIGEON_EXAMPLE_PACKAGE_EXAMPLE_HOST_API_RESPONSE_HANDLE(g_object_new(
          pigeon_example_package_example_host_api_response_handle_get_type(),
          nullptr));
  self->channel = FL_BASIC_MESSAGE_CHANNEL(g_object_ref(channel));
  self->response_handle =
      FL_BASIC_MESSAGE_CHANNEL_RESPONSE_HANDLE(g_object_ref(response_handle));
  return self;
}

struct _PigeonExamplePackageExampleHostApiGetHostLanguageResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    PigeonExamplePackageExampleHostApiGetHostLanguageResponse,
    pigeon_example_package_example_host_api_get_host_language_response,
    G_TYPE_OBJECT)

static void
pigeon_example_package_example_host_api_get_host_language_response_dispose(
    GObject* object) {
  PigeonExamplePackageExampleHostApiGetHostLanguageResponse* self =
      PIGEON_EXAMPLE_PACKAGE_EXAMPLE_HOST_API_GET_HOST_LANGUAGE_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      pigeon_example_package_example_host_api_get_host_language_response_parent_class)
      ->dispose(object);
}

static void
pigeon_example_package_example_host_api_get_host_language_response_init(
    PigeonExamplePackageExampleHostApiGetHostLanguageResponse* self) {}

static void
pigeon_example_package_example_host_api_get_host_language_response_class_init(
    PigeonExamplePackageExampleHostApiGetHostLanguageResponseClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      pigeon_example_package_example_host_api_get_host_language_response_dispose;
}

PigeonExamplePackageExampleHostApiGetHostLanguageResponse*
pigeon_example_package_example_host_api_get_host_language_response_new(
    const gchar* return_value) {
  PigeonExamplePackageExampleHostApiGetHostLanguageResponse* self =
      PIGEON_EXAMPLE_PACKAGE_EXAMPLE_HOST_API_GET_HOST_LANGUAGE_RESPONSE(g_object_new(
          pigeon_example_package_example_host_api_get_host_language_response_get_type(),
          nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(return_value));
  return self;
}

PigeonExamplePackageExampleHostApiGetHostLanguageResponse*
pigeon_example_package_example_host_api_get_host_language_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  PigeonExamplePackageExampleHostApiGetHostLanguageResponse* self =
      PIGEON_EXAMPLE_PACKAGE_EXAMPLE_HOST_API_GET_HOST_LANGUAGE_RESPONSE(g_object_new(
          pigeon_example_package_example_host_api_get_host_language_response_get_type(),
          nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _PigeonExamplePackageExampleHostApiAddResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(PigeonExamplePackageExampleHostApiAddResponse,
              pigeon_example_package_example_host_api_add_response,
              G_TYPE_OBJECT)

static void pigeon_example_package_example_host_api_add_response_dispose(
    GObject* object) {
  PigeonExamplePackageExampleHostApiAddResponse* self =
      PIGEON_EXAMPLE_PACKAGE_EXAMPLE_HOST_API_ADD_RESPONSE(object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      pigeon_example_package_example_host_api_add_response_parent_class)
      ->dispose(object);
}

static void pigeon_example_package_example_host_api_add_response_init(
    PigeonExamplePackageExampleHostApiAddResponse* self) {}

static void pigeon_example_package_example_host_api_add_response_class_init(
    PigeonExamplePackageExampleHostApiAddResponseClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      pigeon_example_package_example_host_api_add_response_dispose;
}

PigeonExamplePackageExampleHostApiAddResponse*
pigeon_example_package_example_host_api_add_response_new(int64_t return_value) {
  PigeonExamplePackageExampleHostApiAddResponse* self =
      PIGEON_EXAMPLE_PACKAGE_EXAMPLE_HOST_API_ADD_RESPONSE(g_object_new(
          pigeon_example_package_example_host_api_add_response_get_type(),
          nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_int(return_value));
  return self;
}

PigeonExamplePackageExampleHostApiAddResponse*
pigeon_example_package_example_host_api_add_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  PigeonExamplePackageExampleHostApiAddResponse* self =
      PIGEON_EXAMPLE_PACKAGE_EXAMPLE_HOST_API_ADD_RESPONSE(g_object_new(
          pigeon_example_package_example_host_api_add_response_get_type(),
          nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    PigeonExamplePackageExampleHostApiSendMessageResponse,
    pigeon_example_package_example_host_api_send_message_response,
    PIGEON_EXAMPLE_PACKAGE, EXAMPLE_HOST_API_SEND_MESSAGE_RESPONSE, GObject)

struct _PigeonExamplePackageExampleHostApiSendMessageResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(PigeonExamplePackageExampleHostApiSendMessageResponse,
              pigeon_example_package_example_host_api_send_message_response,
              G_TYPE_OBJECT)

static void
pigeon_example_package_example_host_api_send_message_response_dispose(
    GObject* object) {
  PigeonExamplePackageExampleHostApiSendMessageResponse* self =
      PIGEON_EXAMPLE_PACKAGE_EXAMPLE_HOST_API_SEND_MESSAGE_RESPONSE(object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      pigeon_example_package_example_host_api_send_message_response_parent_class)
      ->dispose(object);
}

static void pigeon_example_package_example_host_api_send_message_response_init(
    PigeonExamplePackageExampleHostApiSendMessageResponse* self) {}

static void
pigeon_example_package_example_host_api_send_message_response_class_init(
    PigeonExamplePackageExampleHostApiSendMessageResponseClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      pigeon_example_package_example_host_api_send_message_response_dispose;
}

static PigeonExamplePackageExampleHostApiSendMessageResponse*
pigeon_example_package_example_host_api_send_message_response_new(
    gboolean return_value) {
  PigeonExamplePackageExampleHostApiSendMessageResponse* self =
      PIGEON_EXAMPLE_PACKAGE_EXAMPLE_HOST_API_SEND_MESSAGE_RESPONSE(g_object_new(
          pigeon_example_package_example_host_api_send_message_response_get_type(),
          nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_bool(return_value));
  return self;
}

static PigeonExamplePackageExampleHostApiSendMessageResponse*
pigeon_example_package_example_host_api_send_message_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  PigeonExamplePackageExampleHostApiSendMessageResponse* self =
      PIGEON_EXAMPLE_PACKAGE_EXAMPLE_HOST_API_SEND_MESSAGE_RESPONSE(g_object_new(
          pigeon_example_package_example_host_api_send_message_response_get_type(),
          nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _PigeonExamplePackageExampleHostApi {
  GObject parent_instance;

  const PigeonExamplePackageExampleHostApiVTable* vtable;
  gpointer user_data;
  GDestroyNotify user_data_free_func;
};

G_DEFINE_TYPE(PigeonExamplePackageExampleHostApi,
              pigeon_example_package_example_host_api, G_TYPE_OBJECT)

static void pigeon_example_package_example_host_api_dispose(GObject* object) {
  PigeonExamplePackageExampleHostApi* self =
      PIGEON_EXAMPLE_PACKAGE_EXAMPLE_HOST_API(object);
  if (self->user_data != nullptr) {
    self->user_data_free_func(self->user_data);
  }
  self->user_data = nullptr;
  G_OBJECT_CLASS(pigeon_example_package_example_host_api_parent_class)
      ->dispose(object);
}

static void pigeon_example_package_example_host_api_init(
    PigeonExamplePackageExampleHostApi* self) {}

static void pigeon_example_package_example_host_api_class_init(
    PigeonExamplePackageExampleHostApiClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      pigeon_example_package_example_host_api_dispose;
}

static PigeonExamplePackageExampleHostApi*
pigeon_example_package_example_host_api_new(
    const PigeonExamplePackageExampleHostApiVTable* vtable, gpointer user_data,
    GDestroyNotify user_data_free_func) {
  PigeonExamplePackageExampleHostApi* self =
      PIGEON_EXAMPLE_PACKAGE_EXAMPLE_HOST_API(g_object_new(
          pigeon_example_package_example_host_api_get_type(), nullptr));
  self->vtable = vtable;
  self->user_data = user_data;
  self->user_data_free_func = user_data_free_func;
  return self;
}

static void pigeon_example_package_example_host_api_get_host_language_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  PigeonExamplePackageExampleHostApi* self =
      PIGEON_EXAMPLE_PACKAGE_EXAMPLE_HOST_API(user_data);

  if (self->vtable == nullptr || self->vtable->get_host_language == nullptr) {
    return;
  }

  g_autoptr(PigeonExamplePackageExampleHostApiGetHostLanguageResponse)
      response = self->vtable->get_host_language(self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "ExampleHostApi",
              "getHostLanguage");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "ExampleHostApi",
              "getHostLanguage", error->message);
  }
}

static void pigeon_example_package_example_host_api_add_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  PigeonExamplePackageExampleHostApi* self =
      PIGEON_EXAMPLE_PACKAGE_EXAMPLE_HOST_API(user_data);

  if (self->vtable == nullptr || self->vtable->add == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  int64_t a = fl_value_get_int(value0);
  FlValue* value1 = fl_value_get_list_value(message_, 1);
  int64_t b = fl_value_get_int(value1);
  g_autoptr(PigeonExamplePackageExampleHostApiAddResponse) response =
      self->vtable->add(a, b, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "ExampleHostApi", "add");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "ExampleHostApi", "add",
              error->message);
  }
}

static void pigeon_example_package_example_host_api_send_message_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  PigeonExamplePackageExampleHostApi* self =
      PIGEON_EXAMPLE_PACKAGE_EXAMPLE_HOST_API(user_data);

  if (self->vtable == nullptr || self->vtable->send_message == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  PigeonExamplePackageMessageData* message =
      PIGEON_EXAMPLE_PACKAGE_MESSAGE_DATA(
          fl_value_get_custom_value_object(value0));
  g_autoptr(PigeonExamplePackageExampleHostApiResponseHandle) handle =
      pigeon_example_package_example_host_api_response_handle_new(
          channel, response_handle);
  self->vtable->send_message(message, handle, self->user_data);
}

void pigeon_example_package_example_host_api_set_method_handlers(
    FlBinaryMessenger* messenger, const gchar* suffix,
    const PigeonExamplePackageExampleHostApiVTable* vtable, gpointer user_data,
    GDestroyNotify user_data_free_func) {
  g_autofree gchar* dot_suffix =
      suffix != nullptr ? g_strdup_printf(".%s", suffix) : g_strdup("");
  g_autoptr(PigeonExamplePackageExampleHostApi) api_data =
      pigeon_example_package_example_host_api_new(vtable, user_data,
                                                  user_data_free_func);

  g_autoptr(PigeonExamplePackageMessageCodec) codec =
      pigeon_example_package_message_codec_new();
  g_autofree gchar* get_host_language_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_example_package.ExampleHostApi."
      "getHostLanguage%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) get_host_language_channel =
      fl_basic_message_channel_new(messenger, get_host_language_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      get_host_language_channel,
      pigeon_example_package_example_host_api_get_host_language_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* add_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_example_package.ExampleHostApi.add%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) add_channel = fl_basic_message_channel_new(
      messenger, add_channel_name, FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      add_channel, pigeon_example_package_example_host_api_add_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* send_message_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_example_package.ExampleHostApi.sendMessage%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) send_message_channel =
      fl_basic_message_channel_new(messenger, send_message_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      send_message_channel,
      pigeon_example_package_example_host_api_send_message_cb,
      g_object_ref(api_data), g_object_unref);
}

void pigeon_example_package_example_host_api_clear_method_handlers(
    FlBinaryMessenger* messenger, const gchar* suffix) {
  g_autofree gchar* dot_suffix =
      suffix != nullptr ? g_strdup_printf(".%s", suffix) : g_strdup("");

  g_autoptr(PigeonExamplePackageMessageCodec) codec =
      pigeon_example_package_message_codec_new();
  g_autofree gchar* get_host_language_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_example_package.ExampleHostApi."
      "getHostLanguage%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) get_host_language_channel =
      fl_basic_message_channel_new(messenger, get_host_language_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(get_host_language_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* add_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_example_package.ExampleHostApi.add%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) add_channel = fl_basic_message_channel_new(
      messenger, add_channel_name, FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(add_channel, nullptr, nullptr,
                                               nullptr);
  g_autofree gchar* send_message_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_example_package.ExampleHostApi.sendMessage%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) send_message_channel =
      fl_basic_message_channel_new(messenger, send_message_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(send_message_channel, nullptr,
                                               nullptr, nullptr);
}

void pigeon_example_package_example_host_api_respond_send_message(
    PigeonExamplePackageExampleHostApiResponseHandle* response_handle,
    gboolean return_value) {
  g_autoptr(PigeonExamplePackageExampleHostApiSendMessageResponse) response =
      pigeon_example_package_example_host_api_send_message_response_new(
          return_value);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "ExampleHostApi",
              "sendMessage", error->message);
  }
}

void pigeon_example_package_example_host_api_respond_error_send_message(
    PigeonExamplePackageExampleHostApiResponseHandle* response_handle,
    const gchar* code, const gchar* message, FlValue* details) {
  g_autoptr(PigeonExamplePackageExampleHostApiSendMessageResponse) response =
      pigeon_example_package_example_host_api_send_message_response_new_error(
          code, message, details);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "ExampleHostApi",
              "sendMessage", error->message);
  }
}

struct _PigeonExamplePackageMessageFlutterApi {
  GObject parent_instance;

  FlBinaryMessenger* messenger;
  gchar* suffix;
};

G_DEFINE_TYPE(PigeonExamplePackageMessageFlutterApi,
              pigeon_example_package_message_flutter_api, G_TYPE_OBJECT)

static void pigeon_example_package_message_flutter_api_dispose(
    GObject* object) {
  PigeonExamplePackageMessageFlutterApi* self =
      PIGEON_EXAMPLE_PACKAGE_MESSAGE_FLUTTER_API(object);
  g_clear_object(&self->messenger);
  g_clear_pointer(&self->suffix, g_free);
  G_OBJECT_CLASS(pigeon_example_package_message_flutter_api_parent_class)
      ->dispose(object);
}

static void pigeon_example_package_message_flutter_api_init(
    PigeonExamplePackageMessageFlutterApi* self) {}

static void pigeon_example_package_message_flutter_api_class_init(
    PigeonExamplePackageMessageFlutterApiClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      pigeon_example_package_message_flutter_api_dispose;
}

PigeonExamplePackageMessageFlutterApi*
pigeon_example_package_message_flutter_api_new(FlBinaryMessenger* messenger,
                                               const gchar* suffix) {
  PigeonExamplePackageMessageFlutterApi* self =
      PIGEON_EXAMPLE_PACKAGE_MESSAGE_FLUTTER_API(g_object_new(
          pigeon_example_package_message_flutter_api_get_type(), nullptr));
  self->messenger = FL_BINARY_MESSENGER(g_object_ref(messenger));
  self->suffix =
      suffix != nullptr ? g_strdup_printf(".%s", suffix) : g_strdup("");
  return self;
}

struct _PigeonExamplePackageMessageFlutterApiFlutterMethodResponse {
  GObject parent_instance;

  FlValue* error;
  FlValue* return_value;
};

G_DEFINE_TYPE(
    PigeonExamplePackageMessageFlutterApiFlutterMethodResponse,
    pigeon_example_package_message_flutter_api_flutter_method_response,
    G_TYPE_OBJECT)

static void
pigeon_example_package_message_flutter_api_flutter_method_response_dispose(
    GObject* object) {
  PigeonExamplePackageMessageFlutterApiFlutterMethodResponse* self =
      PIGEON_EXAMPLE_PACKAGE_MESSAGE_FLUTTER_API_FLUTTER_METHOD_RESPONSE(
          object);
  g_clear_pointer(&self->error, fl_value_unref);
  g_clear_pointer(&self->return_value, fl_value_unref);
  G_OBJECT_CLASS(
      pigeon_example_package_message_flutter_api_flutter_method_response_parent_class)
      ->dispose(object);
}

static void
pigeon_example_package_message_flutter_api_flutter_method_response_init(
    PigeonExamplePackageMessageFlutterApiFlutterMethodResponse* self) {}

static void
pigeon_example_package_message_flutter_api_flutter_method_response_class_init(
    PigeonExamplePackageMessageFlutterApiFlutterMethodResponseClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      pigeon_example_package_message_flutter_api_flutter_method_response_dispose;
}

static PigeonExamplePackageMessageFlutterApiFlutterMethodResponse*
pigeon_example_package_message_flutter_api_flutter_method_response_new(
    FlValue* response) {
  PigeonExamplePackageMessageFlutterApiFlutterMethodResponse* self =
      PIGEON_EXAMPLE_PACKAGE_MESSAGE_FLUTTER_API_FLUTTER_METHOD_RESPONSE(g_object_new(
          pigeon_example_package_message_flutter_api_flutter_method_response_get_type(),
          nullptr));
  if (fl_value_get_length(response) > 1) {
    self->error = fl_value_ref(response);
  } else {
    FlValue* value = fl_value_get_list_value(response, 0);
    self->return_value = fl_value_ref(value);
  }
  return self;
}

gboolean
pigeon_example_package_message_flutter_api_flutter_method_response_is_error(
    PigeonExamplePackageMessageFlutterApiFlutterMethodResponse* self) {
  g_return_val_if_fail(
      PIGEON_EXAMPLE_PACKAGE_IS_MESSAGE_FLUTTER_API_FLUTTER_METHOD_RESPONSE(
          self),
      FALSE);
  return self->error != nullptr;
}

const gchar*
pigeon_example_package_message_flutter_api_flutter_method_response_get_error_code(
    PigeonExamplePackageMessageFlutterApiFlutterMethodResponse* self) {
  g_return_val_if_fail(
      PIGEON_EXAMPLE_PACKAGE_IS_MESSAGE_FLUTTER_API_FLUTTER_METHOD_RESPONSE(
          self),
      nullptr);
  g_assert(
      pigeon_example_package_message_flutter_api_flutter_method_response_is_error(
          self));
  return fl_value_get_string(fl_value_get_list_value(self->error, 0));
}

const gchar*
pigeon_example_package_message_flutter_api_flutter_method_response_get_error_message(
    PigeonExamplePackageMessageFlutterApiFlutterMethodResponse* self) {
  g_return_val_if_fail(
      PIGEON_EXAMPLE_PACKAGE_IS_MESSAGE_FLUTTER_API_FLUTTER_METHOD_RESPONSE(
          self),
      nullptr);
  g_assert(
      pigeon_example_package_message_flutter_api_flutter_method_response_is_error(
          self));
  return fl_value_get_string(fl_value_get_list_value(self->error, 1));
}

FlValue*
pigeon_example_package_message_flutter_api_flutter_method_response_get_error_details(
    PigeonExamplePackageMessageFlutterApiFlutterMethodResponse* self) {
  g_return_val_if_fail(
      PIGEON_EXAMPLE_PACKAGE_IS_MESSAGE_FLUTTER_API_FLUTTER_METHOD_RESPONSE(
          self),
      nullptr);
  g_assert(
      pigeon_example_package_message_flutter_api_flutter_method_response_is_error(
          self));
  return fl_value_get_list_value(self->error, 2);
}

const gchar*
pigeon_example_package_message_flutter_api_flutter_method_response_get_return_value(
    PigeonExamplePackageMessageFlutterApiFlutterMethodResponse* self) {
  g_return_val_if_fail(
      PIGEON_EXAMPLE_PACKAGE_IS_MESSAGE_FLUTTER_API_FLUTTER_METHOD_RESPONSE(
          self),
      nullptr);
  g_assert(
      !pigeon_example_package_message_flutter_api_flutter_method_response_is_error(
          self));
  return fl_value_get_string(self->return_value);
}

static void pigeon_example_package_message_flutter_api_flutter_method_cb(
    GObject* object, GAsyncResult* result, gpointer user_data) {
  GTask* task = G_TASK(user_data);
  g_task_return_pointer(task, result, g_object_unref);
}

void pigeon_example_package_message_flutter_api_flutter_method(
    PigeonExamplePackageMessageFlutterApi* self, const gchar* a_string,
    GCancellable* cancellable, GAsyncReadyCallback callback,
    gpointer user_data) {
  g_autoptr(FlValue) args = fl_value_new_list();
  fl_value_append_take(args, a_string != nullptr ? fl_value_new_string(a_string)
                                                 : fl_value_new_null());
  g_autofree gchar* channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_example_package.MessageFlutterApi."
      "flutterMethod%s",
      self->suffix);
  g_autoptr(PigeonExamplePackageMessageCodec) codec =
      pigeon_example_package_message_codec_new();
  FlBasicMessageChannel* channel = fl_basic_message_channel_new(
      self->messenger, channel_name, FL_MESSAGE_CODEC(codec));
  GTask* task = g_task_new(self, cancellable, callback, user_data);
  g_task_set_task_data(task, channel, g_object_unref);
  fl_basic_message_channel_send(
      channel, args, cancellable,
      pigeon_example_package_message_flutter_api_flutter_method_cb, task);
}

PigeonExamplePackageMessageFlutterApiFlutterMethodResponse*
pigeon_example_package_message_flutter_api_flutter_method_finish(
    PigeonExamplePackageMessageFlutterApi* self, GAsyncResult* result,
    GError** error) {
  g_autoptr(GTask) task = G_TASK(result);
  GAsyncResult* r = G_ASYNC_RESULT(g_task_propagate_pointer(task, nullptr));
  FlBasicMessageChannel* channel =
      FL_BASIC_MESSAGE_CHANNEL(g_task_get_task_data(task));
  g_autoptr(FlValue) response =
      fl_basic_message_channel_send_finish(channel, r, error);
  if (response == nullptr) {
    return nullptr;
  }
  return pigeon_example_package_message_flutter_api_flutter_method_response_new(
      response);
}
