// dart format width=80
import 'package:drift/internal/versioned_schema.dart' as i0;
import 'package:drift/drift.dart' as i1;
import 'package:drift/src/runtime/query_builder/query_builder.dart' as i2;
import 'package:drift/drift.dart'; // ignore_for_file: type=lint,unused_import

// GENERATED BY drift_dev, DO NOT MODIFY.
final class Schema2 extends i0.VersionedSchema {
  Schema2({required super.database}) : super(version: 2);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    users,
  ];
  late final Shape0 users = Shape0(
      source: i0.VersionedTable(
        entityName: 'users',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_1,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape0 extends i0.VersionedTable {
  Shape0({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<int> _column_0(String aliasedName) =>
    i1.GeneratedColumn<int>('id', aliasedName, false,
        hasAutoIncrement: true,
        type: i1.DriftSqlType.int,
        defaultConstraints:
            i1.GeneratedColumn.constraintIsAlways('PRIMARY KEY AUTOINCREMENT'));
i1.GeneratedColumn<String> _column_1(String aliasedName) =>
    i1.GeneratedColumn<String>('name', aliasedName, false,
        type: i1.DriftSqlType.string);

final class Schema3 extends i0.VersionedSchema {
  Schema3({required super.database}) : super(version: 3);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    users,
    groups,
  ];
  late final Shape0 users = Shape0(
      source: i0.VersionedTable(
        entityName: 'users',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_1,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape1 groups = Shape1(
      source: i0.VersionedTable(
        entityName: 'groups',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [
          'PRIMARY KEY (id)',
        ],
        columns: [
          _column_2,
          _column_3,
          _column_4,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape1 extends i0.VersionedTable {
  Shape1({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get title =>
      columnsByName['title']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get deleted =>
      columnsByName['deleted']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get owner =>
      columnsByName['owner']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<int> _column_2(String aliasedName) =>
    i1.GeneratedColumn<int>('id', aliasedName, false,
        type: i1.DriftSqlType.int, $customConstraints: 'NOT NULL');
i1.GeneratedColumn<String> _column_3(String aliasedName) =>
    i1.GeneratedColumn<String>('title', aliasedName, false,
        type: i1.DriftSqlType.string, $customConstraints: 'NOT NULL');
i1.GeneratedColumn<bool> _column_4(String aliasedName) =>
    i1.GeneratedColumn<bool>('deleted', aliasedName, true,
        type: i1.DriftSqlType.bool,
        $customConstraints: 'DEFAULT FALSE',
        defaultValue: const CustomExpression<bool>('FALSE'));
i1.GeneratedColumn<int> _column_5(String aliasedName) =>
    i1.GeneratedColumn<int>('owner', aliasedName, false,
        type: i1.DriftSqlType.int,
        $customConstraints: 'NOT NULL REFERENCES users (id)');

final class Schema4 extends i0.VersionedSchema {
  Schema4({required super.database}) : super(version: 4);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    users,
    groups,
  ];
  late final Shape0 users = Shape0(
      source: i0.VersionedTable(
        entityName: 'users',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_6,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape1 groups = Shape1(
      source: i0.VersionedTable(
        entityName: 'groups',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [
          'PRIMARY KEY (id)',
        ],
        columns: [
          _column_2,
          _column_3,
          _column_4,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

i1.GeneratedColumn<String> _column_6(String aliasedName) =>
    i1.GeneratedColumn<String>('name', aliasedName, false,
        type: i1.DriftSqlType.string, defaultValue: const Constant('name'));

final class Schema5 extends i0.VersionedSchema {
  Schema5({required super.database}) : super(version: 5);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    users,
    groups,
    groupCount,
  ];
  late final Shape2 users = Shape2(
      source: i0.VersionedTable(
        entityName: 'users',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_6,
          _column_7,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape1 groups = Shape1(
      source: i0.VersionedTable(
        entityName: 'groups',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [
          'PRIMARY KEY (id)',
        ],
        columns: [
          _column_2,
          _column_3,
          _column_4,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape3 groupCount = Shape3(
      source: i0.VersionedView(
        entityName: 'group_count',
        createViewStmt:
            'CREATE VIEW group_count AS SELECT users.*, (SELECT COUNT(*) FROM "groups" WHERE owner = users.id) AS group_count FROM users',
        columns: [
          _column_8,
          _column_1,
          _column_9,
          _column_10,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape2 extends i0.VersionedTable {
  Shape2({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get nextUser =>
      columnsByName['next_user']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<int> _column_7(String aliasedName) =>
    i1.GeneratedColumn<int>('next_user', aliasedName, true,
        type: i1.DriftSqlType.int,
        defaultConstraints:
            i1.GeneratedColumn.constraintIsAlways('REFERENCES users (id)'));

class Shape3 extends i0.VersionedView {
  Shape3({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get nextUser =>
      columnsByName['next_user']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get groupCount =>
      columnsByName['group_count']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<int> _column_8(String aliasedName) =>
    i1.GeneratedColumn<int>('id', aliasedName, false,
        type: i1.DriftSqlType.int);
i1.GeneratedColumn<int> _column_9(String aliasedName) =>
    i1.GeneratedColumn<int>('next_user', aliasedName, true,
        type: i1.DriftSqlType.int);
i1.GeneratedColumn<int> _column_10(String aliasedName) =>
    i1.GeneratedColumn<int>('group_count', aliasedName, false,
        type: i1.DriftSqlType.int);

final class Schema6 extends i0.VersionedSchema {
  Schema6({required super.database}) : super(version: 6);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    users,
    groups,
    groupCount,
  ];
  late final Shape4 users = Shape4(
      source: i0.VersionedTable(
        entityName: 'users',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_6,
          _column_11,
          _column_7,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape1 groups = Shape1(
      source: i0.VersionedTable(
        entityName: 'groups',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [
          'PRIMARY KEY (id)',
        ],
        columns: [
          _column_2,
          _column_3,
          _column_4,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape5 groupCount = Shape5(
      source: i0.VersionedView(
        entityName: 'group_count',
        createViewStmt:
            'CREATE VIEW group_count AS SELECT users.*, (SELECT COUNT(*) FROM "groups" WHERE owner = users.id) AS group_count FROM users',
        columns: [
          _column_8,
          _column_1,
          _column_11,
          _column_9,
          _column_10,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape4 extends i0.VersionedTable {
  Shape4({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get birthday =>
      columnsByName['birthday']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<int> get nextUser =>
      columnsByName['next_user']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<DateTime> _column_11(String aliasedName) =>
    i1.GeneratedColumn<DateTime>('birthday', aliasedName, true,
        type: i1.DriftSqlType.dateTime);

class Shape5 extends i0.VersionedView {
  Shape5({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get birthday =>
      columnsByName['birthday']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<int> get nextUser =>
      columnsByName['next_user']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get groupCount =>
      columnsByName['group_count']! as i1.GeneratedColumn<int>;
}

final class Schema7 extends i0.VersionedSchema {
  Schema7({required super.database}) : super(version: 7);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    users,
    groups,
    groupCount,
    notes,
  ];
  late final Shape4 users = Shape4(
      source: i0.VersionedTable(
        entityName: 'users',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_6,
          _column_11,
          _column_7,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape1 groups = Shape1(
      source: i0.VersionedTable(
        entityName: 'groups',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [
          'PRIMARY KEY (id)',
        ],
        columns: [
          _column_2,
          _column_3,
          _column_4,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape5 groupCount = Shape5(
      source: i0.VersionedView(
        entityName: 'group_count',
        createViewStmt:
            'CREATE VIEW group_count AS SELECT users.*, (SELECT COUNT(*) FROM "groups" WHERE owner = users.id) AS group_count FROM users',
        columns: [
          _column_8,
          _column_1,
          _column_11,
          _column_9,
          _column_10,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape6 notes = Shape6(
      source: i0.VersionedVirtualTable(
        entityName: 'notes',
        moduleAndArgs:
            'fts5(title, content, search_terms, tokenize = "unicode61 tokenchars \'.\'")',
        columns: [
          _column_12,
          _column_13,
          _column_14,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape6 extends i0.VersionedVirtualTable {
  Shape6({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get title =>
      columnsByName['title']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get content =>
      columnsByName['content']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get searchTerms =>
      columnsByName['search_terms']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_12(String aliasedName) =>
    i1.GeneratedColumn<String>('title', aliasedName, false,
        type: i1.DriftSqlType.string, $customConstraints: '');
i1.GeneratedColumn<String> _column_13(String aliasedName) =>
    i1.GeneratedColumn<String>('content', aliasedName, false,
        type: i1.DriftSqlType.string, $customConstraints: '');
i1.GeneratedColumn<String> _column_14(String aliasedName) =>
    i1.GeneratedColumn<String>('search_terms', aliasedName, false,
        type: i1.DriftSqlType.string, $customConstraints: '');

final class Schema8 extends i0.VersionedSchema {
  Schema8({required super.database}) : super(version: 8);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    users,
    groups,
    groupCount,
    notes,
  ];
  late final Shape4 users = Shape4(
      source: i0.VersionedTable(
        entityName: 'users',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [
          'UNIQUE(name, birthday)',
        ],
        columns: [
          _column_0,
          _column_6,
          _column_11,
          _column_15,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape1 groups = Shape1(
      source: i0.VersionedTable(
        entityName: 'groups',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [
          'PRIMARY KEY (id)',
        ],
        columns: [
          _column_2,
          _column_3,
          _column_4,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape5 groupCount = Shape5(
      source: i0.VersionedView(
        entityName: 'group_count',
        createViewStmt:
            'CREATE VIEW group_count AS SELECT users.*, (SELECT COUNT(*) FROM "groups" WHERE owner = users.id) AS group_count FROM users',
        columns: [
          _column_8,
          _column_1,
          _column_11,
          _column_9,
          _column_10,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape6 notes = Shape6(
      source: i0.VersionedVirtualTable(
        entityName: 'notes',
        moduleAndArgs:
            'fts5(title, content, search_terms, tokenize = "unicode61 tokenchars \'.\'")',
        columns: [
          _column_12,
          _column_13,
          _column_14,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

i1.GeneratedColumn<int> _column_15(String aliasedName) =>
    i1.GeneratedColumn<int>('next_user', aliasedName, true,
        type: i1.DriftSqlType.int,
        defaultConstraints:
            i1.GeneratedColumn.constraintIsAlways('REFERENCES "users" ("id")'));

final class Schema9 extends i0.VersionedSchema {
  Schema9({required super.database}) : super(version: 9);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    users,
    groups,
    notes,
    groupCount,
  ];
  late final Shape4 users = Shape4(
      source: i0.VersionedTable(
        entityName: 'users',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [
          'UNIQUE(name, birthday)',
          'CHECK (LENGTH(name) < 10)',
        ],
        columns: [
          _column_0,
          _column_6,
          _column_11,
          _column_7,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape1 groups = Shape1(
      source: i0.VersionedTable(
        entityName: 'groups',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [
          'PRIMARY KEY(id)',
        ],
        columns: [
          _column_2,
          _column_3,
          _column_16,
          _column_17,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape6 notes = Shape6(
      source: i0.VersionedVirtualTable(
        entityName: 'notes',
        moduleAndArgs:
            'fts5(title, content, search_terms, tokenize = "unicode61 tokenchars \'.\'")',
        columns: [
          _column_12,
          _column_13,
          _column_14,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape5 groupCount = Shape5(
      source: i0.VersionedView(
        entityName: 'group_count',
        createViewStmt:
            'CREATE VIEW group_count AS SELECT\n    users.*,\n    (SELECT COUNT(*) FROM "groups" WHERE owner = users.id) AS group_count\n  FROM users;',
        columns: [
          _column_8,
          _column_1,
          _column_11,
          _column_9,
          _column_10,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

i1.GeneratedColumn<bool> _column_16(String aliasedName) =>
    i1.GeneratedColumn<bool>('deleted', aliasedName, true,
        type: i1.DriftSqlType.bool,
        $customConstraints: 'DEFAULT FALSE',
        defaultValue: const CustomExpression('FALSE'));
i1.GeneratedColumn<int> _column_17(String aliasedName) =>
    i1.GeneratedColumn<int>('owner', aliasedName, false,
        type: i1.DriftSqlType.int,
        $customConstraints: 'NOT NULL REFERENCES users(id)');

final class Schema10 extends i0.VersionedSchema {
  Schema10({required super.database}) : super(version: 10);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    users,
    groups,
    notes,
    groupCount,
    userName,
  ];
  late final Shape4 users = Shape4(
      source: i0.VersionedTable(
        entityName: 'users',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [
          'UNIQUE(name, birthday)',
          'CHECK (LENGTH(name) < 10)',
        ],
        columns: [
          _column_0,
          _column_6,
          _column_11,
          _column_7,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape1 groups = Shape1(
      source: i0.VersionedTable(
        entityName: 'groups',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [
          'PRIMARY KEY(id)',
        ],
        columns: [
          _column_2,
          _column_3,
          _column_16,
          _column_17,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape6 notes = Shape6(
      source: i0.VersionedVirtualTable(
        entityName: 'notes',
        moduleAndArgs:
            'fts5(title, content, search_terms, tokenize = "unicode61 tokenchars \'.\'")',
        columns: [
          _column_12,
          _column_13,
          _column_14,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape5 groupCount = Shape5(
      source: i0.VersionedView(
        entityName: 'group_count',
        createViewStmt:
            'CREATE VIEW group_count AS SELECT users.*, (SELECT COUNT(*) FROM "groups" WHERE owner = users.id) AS group_count FROM users;',
        columns: [
          _column_8,
          _column_1,
          _column_11,
          _column_9,
          _column_10,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  final i1.Index userName =
      i1.Index('user_name', 'CREATE INDEX user_name ON users (name)');
}

final class Schema11 extends i0.VersionedSchema {
  Schema11({required super.database}) : super(version: 11);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    users,
    groups,
    notes,
    groupCount,
    userName,
  ];
  late final Shape4 users = Shape4(
      source: i0.VersionedTable(
        entityName: 'users',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [
          'UNIQUE(name, birthday)',
          'CHECK (LENGTH(name) < 10)',
        ],
        columns: [
          _column_0,
          _column_18,
          _column_19,
          _column_7,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape1 groups = Shape1(
      source: i0.VersionedTable(
        entityName: 'groups',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [
          'PRIMARY KEY(id)',
        ],
        columns: [
          _column_2,
          _column_3,
          _column_20,
          _column_17,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape6 notes = Shape6(
      source: i0.VersionedVirtualTable(
        entityName: 'notes',
        moduleAndArgs:
            'fts5(title, content, search_terms, tokenize = "unicode61 tokenchars \'.\'")',
        columns: [
          _column_12,
          _column_13,
          _column_14,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape5 groupCount = Shape5(
      source: i0.VersionedView(
        entityName: 'group_count',
        createViewStmt:
            'CREATE VIEW group_count AS SELECT users.*, (SELECT COUNT(*) FROM "groups" WHERE owner = users.id) AS group_count FROM users;',
        columns: [
          _column_8,
          _column_1,
          _column_11,
          _column_9,
          _column_10,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  final i1.Index userName =
      i1.Index('user_name', 'CREATE INDEX user_name ON users (name)');
}

i1.GeneratedColumn<String> _column_18(String aliasedName) =>
    i1.GeneratedColumn<String>('name', aliasedName, false,
        type: i1.DriftSqlType.string,
        defaultValue: const CustomExpression('\'name\''));
i1.GeneratedColumn<DateTime> _column_19(String aliasedName) =>
    i1.GeneratedColumn<DateTime>('birthday', aliasedName, true,
        check: () =>
            i2.ComparableExpr((i0.VersionedTable.col<DateTime>('birthday')))
                .isBiggerThan(i2.Constant(DateTime(1900))),
        type: i1.DriftSqlType.dateTime);
i1.GeneratedColumn<bool> _column_20(String aliasedName) =>
    i1.GeneratedColumn<bool>('deleted', aliasedName, true,
        type: i1.DriftSqlType.bool,
        $customConstraints: 'NULL DEFAULT FALSE',
        defaultValue: const CustomExpression('FALSE'));
i0.MigrationStepWithVersion migrationSteps({
  required Future<void> Function(i1.Migrator m, Schema2 schema) from1To2,
  required Future<void> Function(i1.Migrator m, Schema3 schema) from2To3,
  required Future<void> Function(i1.Migrator m, Schema4 schema) from3To4,
  required Future<void> Function(i1.Migrator m, Schema5 schema) from4To5,
  required Future<void> Function(i1.Migrator m, Schema6 schema) from5To6,
  required Future<void> Function(i1.Migrator m, Schema7 schema) from6To7,
  required Future<void> Function(i1.Migrator m, Schema8 schema) from7To8,
  required Future<void> Function(i1.Migrator m, Schema9 schema) from8To9,
  required Future<void> Function(i1.Migrator m, Schema10 schema) from9To10,
  required Future<void> Function(i1.Migrator m, Schema11 schema) from10To11,
}) {
  return (currentVersion, database) async {
    switch (currentVersion) {
      case 1:
        final schema = Schema2(database: database);
        final migrator = i1.Migrator(database, schema);
        await from1To2(migrator, schema);
        return 2;
      case 2:
        final schema = Schema3(database: database);
        final migrator = i1.Migrator(database, schema);
        await from2To3(migrator, schema);
        return 3;
      case 3:
        final schema = Schema4(database: database);
        final migrator = i1.Migrator(database, schema);
        await from3To4(migrator, schema);
        return 4;
      case 4:
        final schema = Schema5(database: database);
        final migrator = i1.Migrator(database, schema);
        await from4To5(migrator, schema);
        return 5;
      case 5:
        final schema = Schema6(database: database);
        final migrator = i1.Migrator(database, schema);
        await from5To6(migrator, schema);
        return 6;
      case 6:
        final schema = Schema7(database: database);
        final migrator = i1.Migrator(database, schema);
        await from6To7(migrator, schema);
        return 7;
      case 7:
        final schema = Schema8(database: database);
        final migrator = i1.Migrator(database, schema);
        await from7To8(migrator, schema);
        return 8;
      case 8:
        final schema = Schema9(database: database);
        final migrator = i1.Migrator(database, schema);
        await from8To9(migrator, schema);
        return 9;
      case 9:
        final schema = Schema10(database: database);
        final migrator = i1.Migrator(database, schema);
        await from9To10(migrator, schema);
        return 10;
      case 10:
        final schema = Schema11(database: database);
        final migrator = i1.Migrator(database, schema);
        await from10To11(migrator, schema);
        return 11;
      default:
        throw ArgumentError.value('Unknown migration from $currentVersion');
    }
  };
}

i1.OnUpgrade stepByStep({
  required Future<void> Function(i1.Migrator m, Schema2 schema) from1To2,
  required Future<void> Function(i1.Migrator m, Schema3 schema) from2To3,
  required Future<void> Function(i1.Migrator m, Schema4 schema) from3To4,
  required Future<void> Function(i1.Migrator m, Schema5 schema) from4To5,
  required Future<void> Function(i1.Migrator m, Schema6 schema) from5To6,
  required Future<void> Function(i1.Migrator m, Schema7 schema) from6To7,
  required Future<void> Function(i1.Migrator m, Schema8 schema) from7To8,
  required Future<void> Function(i1.Migrator m, Schema9 schema) from8To9,
  required Future<void> Function(i1.Migrator m, Schema10 schema) from9To10,
  required Future<void> Function(i1.Migrator m, Schema11 schema) from10To11,
}) =>
    i0.VersionedSchema.stepByStepHelper(
        step: migrationSteps(
      from1To2: from1To2,
      from2To3: from2To3,
      from3To4: from3To4,
      from4To5: from4To5,
      from5To6: from5To6,
      from6To7: from6To7,
      from7To8: from7To8,
      from8To9: from8To9,
      from9To10: from9To10,
      from10To11: from10To11,
    ));
