<p align="center">
  <br/>
  <a href="https://opensource.org/license/agpl-v3"><img src="https://img.shields.io/badge/License-AGPL_v3-blue.svg?color=3F51B5&style=for-the-badge&label=License&logoColor=000000&labelColor=ececec" alt="License: AGPLv3"></a>
  <a href="https://discord.immich.app">
    <img src="https://img.shields.io/discord/979116623879368755.svg?label=Discord&logo=Discord&style=for-the-badge&logoColor=000000&labelColor=ececec" alt="Discord"/>
  </a>
  <br/>
  <br/>
</p>

<p align="center">
<img src="/design/immich-logo-stacked-light.svg" width="300" title="Login With Custom URL">
</p>
<h3 align="center">Високопродуктивне рішення для управління фото та відео на власному хостингу</h3>
<br/>
<a href="https://immich.app">
<img src="/design/immich-screenshots.png" title="Головний скріншот">
</a>
<br/>

<p align="center">
  <a href="../README.md">English</a>
  <a href="README_ca_ES.md">Català</a>
  <a href="README_es_ES.md">Español</a>
  <a href="README_fr_FR.md">Français</a>
  <a href="README_it_IT.md">Italiano</a>
  <a href="README_ja_JP.md">日本語</a>
  <a href="README_ko_KR.md">한국어</a>
  <a href="README_de_DE.md">Deutsch</a>
  <a href="README_nl_NL.md">Nederlands</a>
  <a href="README_tr_TR.md">Türkçe</a>
  <a href="README_zh_CN.md">中文</a>
  <a href="README_ru_RU.md">Русский</a>
  <a href="README_pt_BR.md">Português Brasileiro</a>
  <a href="README_sv_SE.md">Svenska</a>
  <a href="README_ar_JO.md">العربية</a>
  <a href="README_vi_VN.md">Tiếng Việt</a>
  <a href="README_th_TH.md">ภาษาไทย</a>
</p>

## Застереження

- ⚠️ Цей проєкт перебуває **в дуже активній** розробці.
- ⚠️ Очікуйте безліч помилок і глобальних змін.
- ⚠️ **Не використовуйте цей застосунок як єдине сховище своїх фото та відео.**
- ⚠️ Завжди дотримуйтесь [плану резервного копіювання 3-2-1](https://www.backblaze.com/blog/the-3-2-1-backup-strategy/) для ваших дорогоцінних фотографій та відео!

> [!NOTE]
> Основну документацію, зокрема посібники зі встановлення, можна знайти за адресою https://immich.app/.

## Посилання

- [Документація](https://immich.app/docs)
- [Про проєкт](https://immich.app/docs/overview/introduction)
- [Встановлення](https://immich.app/docs/install/requirements)
- [Дорожня карта](https://immich.app/roadmap)
- [Демо](#демо)
- [Функції](#функції)
- [Переклади](https://immich.app/docs/developer/translations)
- [Гід для розробки проєкту](https://immich.app/docs/overview/support-the-project)

## Демо

Доступ до демо-версії [тут](https://demo.immich.app). Для мобільного застосунку ви можете використовувати `https://demo.immich.app` в якості `Server Endpoint URL`.

### Облікові дані для входу

| Електронна пошта | Пароль |
| ---------------- | ------ |
| demo@immich.app  | demo   |

## Функції

| Функції                                                  | Додаток | Веб |
| :------------------------------------------------------- | ------- | --- |
| Завантаження та перегляд відео й фото                    | Так     | Так |
| Автоматичне резервне копіювання при відкритті застосунку | Так     | Н/Д |
| Запобігання дублюванню файлів                            | Так     | Так |
| Вибір альбомів для резервного копіювання                 | Так     | Н/Д |
| Завантаження фото та відео на локальний пристрій         | Так     | Так |
| Підтримка кількох користувачів                           | Так     | Так |
| Альбоми та спільні альбоми                               | Так     | Так |
| Прокрутка/перетягування повзунка                         | Так     | Так |
| Підтримка сирих форматів (RAW)                           | Так     | Так |
| Перегляд метаданих (EXIF, карта)                         | Так     | Так |
| Пошук за метаданими, об'єктами, обличчями та CLIP        | Так     | Так |
| Адміністративні функції (управління користувачами)       | Ні      | Так |
| Фонове резервне копіювання                               | Так     | Н/Д |
| Віртуальна прокрутка                                     | Так     | Так |
| Підтримка OAuth                                          | Так     | Так |
| API ключі                                                | Н/Д     | Так |
| Резервне копіювання та відтворення LivePhoto/MotionPhoto | Так     | Так |
| Підтримка відображення 360-градусних зображень           | Ні      | Так |
| Користувацька структура зберігання                       | Так     | Так |
| Публічний доступ                                         | Так     | Так |
| Архів і Вибране                                          | Так     | Так |
| Глобальна карта                                          | Так     | Так |
| Спільний доступ між партнерами                           | Так     | Так |
| Розпізнавання облич та їх кластеризація                  | Так     | Так |
| Спогади (x років тому)                                   | Так     | Так |
| Офлайн підтримка                                         | Так     | Ні  |
| Галерея тільки для читання                               | Так     | Так |
| Стекування фото                                          | Так     | Так |
| Теги                                                     | Ні      | Так |
| Перегляд папок                                           | Ні      | Так |

## Переклади

Більше про переклади [тут](https://immich.app/docs/developer/translations).

<a href="https://hosted.weblate.org/engage/immich/">
<img src="https://hosted.weblate.org/widget/immich/immich/multi-auto.svg" alt="Статус перекладів" />
</a>

## Активність репозиторію

![Діяльність](https://repobeats.axiom.co/api/embed/9e86d9dc3ddd137161f2f6d2e758d7863b1789cb.svg "Зображення аналітики Repobeats")

## Історія зірок

<a href="https://star-history.com/#immich-app/immich&Date">
 <picture>
   <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=immich-app/immich&type=Date&theme=dark" />
   <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=immich-app/immich&type=Date" />
   <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=immich-app/immich&type=Date" width="100%" />
 </picture>
</a>

## Автори

<a href="https://github.com/alextran1502/immich/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=immich-app/immich" width="100%"/>
</a>
