<p align="center"> 
  <br/>
  <a href="https://opensource.org/license/agpl-v3"><img src="https://img.shields.io/badge/License-AGPL_v3-blue.svg?color=3F51B5&style=for-the-badge&label=License&logoColor=000000&labelColor=ececec" alt="Licenza: AGPLv3"></a>
  <a href="https://discord.immich.app">
    <img src="https://img.shields.io/discord/979116623879368755.svg?label=Discord&logo=Discord&style=for-the-badge&logoColor=000000&labelColor=ececec" alt="Discord"/>
  </a>
  <br/>
  <br/>
</p>

<p align="center">
<img src="../design/immich-logo-stacked-light.svg" width="300" title="Accedi con url personalizzato">
</p>
<h3 align="center">Soluzione ad alte prestazioni per la gestione self-hosted di foto e video</h3>
<br/>
<a href="https://immich.app">
<img src="../design/immich-screenshots.png" title="Screenshot Principale">
</a>
<br/>

<p align="center">
  <a href="../README.md">English</a>
  <a href="README_ca_ES.md">Català</a>
  <a href="README_es_ES.md">Español</a>
  <a href="README_fr_FR.md">Français</a>
  <a href="README_ja_JP.md">日本語</a>
  <a href="README_ko_KR.md">한국어</a>
  <a href="README_de_DE.md">Deutsch</a>
  <a href="README_nl_NL.md">Nederlands</a>
  <a href="README_tr_TR.md">Türkçe</a>
  <a href="README_zh_CN.md">中文</a>
  <a href="README_uk_UA.md">Українська</a>
  <a href="README_ru_RU.md">Русский</a>
  <a href="README_pt_BR.md">Português Brasileiro</a>
  <a href="README_sv_SE.md">Svenska</a>
  <a href="README_ar_JO.md">العربية</a>
  <a href="README_th_TH.md">ภาษาไทย</a>
</p>

## Avvertenze

- ⚠️ Il progetto è in fase di sviluppo **molto attivo**.  
- ⚠️ Possono esserci bug o cambiamenti radicali, che possono non essere retrocompatibili (breaking changes).
- ⚠️ **Non usare l’app come unico modo per archiviare le tue foto e i tuoi video.**  
- ⚠️ Segui sempre la regola di backup [3-2-1](https://www.backblaze.com/blog/the-3-2-1-backup-strategy/) per proteggere i tuoi ricordi e le foto a cui tieni!  

> [!NOTE]  
> La documentazione principale, comprese le guide all’installazione, si trova su https://immich.app/.  

## Link utili

- [Documentazione](https://immich.app/docs)  
- [Informazioni](https://immich.app/docs/overview/introduction)  
- [Installazione](https://immich.app/docs/install/requirements)  
- [Roadmap](https://immich.app/roadmap)  
- [Demo](#demo)  
- [Funzionalità](#funzionalità)  
- [Traduzioni](https://immich.app/docs/developer/translations)  
- [Contribuire](https://immich.app/docs/overview/support-the-project)  

## Demo

Accedi alla demo [qui](https://demo.immich.app).  
Per l’app mobile puoi usare `https://demo.immich.app` come `Server Endpoint URL`.  

### Credenziali di accesso

| Email           | Password |
| --------------- | -------- |
| demo@immich.app | demo     |

## Funzionalità

| Funzionalità                                | Mobile | Web |
| :------------------------------------------ | ------ | --- |
| Caricare e visualizzare foto e video        | Sì     | Sì  |
| Backup automatico all’apertura dell’app     | Sì     | N/D |
| Evita la duplicazione dei file              | Sì     | Sì  |
| Backup selettivo di album                   | Sì     | N/D |
| Scaricare foto e video sul dispositivo      | Sì     | Sì  |
| Supporto multi-utente                       | Sì     | Sì  |
| Album e album condivisi                     | Sì     | Sì  |
| Barra di scorrimento trascinabile           | Sì     | Sì  |
| Supporto ai formati RAW                     | Sì     | Sì  |
| Visualizzazione metadati (EXIF, mappa)      | Sì     | Sì  |
| Ricerca per metadati, oggetti, volti, CLIP  | Sì     | Sì  |
| Funzioni amministrative (gestione utenti)   | No     | Sì  |
| Backup in background                        | Sì     | N/D |
| Scorrimento virtuale                        | Sì     | Sì  |
| Supporto OAuth                              | Sì     | Sì  |
| Chiavi API                                  | N/D    | Sì  |
| Backup e riproduzione LivePhoto/MotionPhoto | Sì     | Sì  |
| Supporto immagini a 360°                    | No     | Sì  |
| Struttura di archiviazione personalizzata   | Sì     | Sì  |
| Condivisione pubblica                       | Sì     | Sì  |
| Archivio e preferiti                        | Sì     | Sì  |
| Mappa globale                               | Sì     | Sì  |
| Condivisione con partner                    | Sì     | Sì  |
| Riconoscimento e raggruppamento facciale    | Sì     | Sì  |
| Ricordi (anni fa)                           | Sì     | Sì  |
| Supporto offline                            | Sì     | No  |
| Galleria in sola lettura                    | Sì     | Sì  |
| Foto impilate                               | Sì     | Sì  |
| Tag                                         | No     | Sì  |
| Vista per cartelle                          | Sì     | Sì  |

## Traduzioni

Scopri di più sulle traduzioni [qui](https://immich.app/docs/developer/translations).  

<a href="https://hosted.weblate.org/engage/immich/">
<img src="https://hosted.weblate.org/widget/immich/immich/multi-auto.svg" alt="Stato traduzioni" />
</a>

## Attività del repository

![Attività](https://repobeats.axiom.co/api/embed/9e86d9dc3ddd137161f2f6d2e758d7863b1789cb.svg "Immagine analisi repobeats")

## Cronologia delle stelle

<a href="https://star-history.com/#immich-app/immich&Date">
 <picture>
   <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=immich-app/immich&type=Date&theme=dark" />
   <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=immich-app/immich&type=Date" />
   <img alt="Grafico storico delle stelle" src="https://api.star-history.com/svg?repos=immich-app/immich&type=Date" width="100%" />
 </picture>
</a>

## Contributori

<a href="https://github.com/alextran1502/immich/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=immich-app/immich" width="100%"/>
</a>
