// Autogenerated from Pigeon (v26.0.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon
@file:Suppress("UNCHECKED_CAST", "ArrayInDataClass")

package app.alextran.immich.sync

import android.util.Log
import io.flutter.plugin.common.BasicMessageChannel
import io.flutter.plugin.common.BinaryMessenger
import io.flutter.plugin.common.EventChannel
import io.flutter.plugin.common.MessageCodec
import io.flutter.plugin.common.StandardMethodCodec
import io.flutter.plugin.common.StandardMessageCodec
import java.io.ByteArrayOutputStream
import java.nio.ByteBuffer
private object MessagesPigeonUtils {

  fun wrapResult(result: Any?): List<Any?> {
    return listOf(result)
  }

  fun wrapError(exception: Throwable): List<Any?> {
    return if (exception is FlutterError) {
      listOf(
        exception.code,
        exception.message,
        exception.details
      )
    } else {
      listOf(
        exception.javaClass.simpleName,
        exception.toString(),
        "Cause: " + exception.cause + ", Stacktrace: " + Log.getStackTraceString(exception)
      )
    }
  }
  fun deepEquals(a: Any?, b: Any?): Boolean {
    if (a is ByteArray && b is ByteArray) {
        return a.contentEquals(b)
    }
    if (a is IntArray && b is IntArray) {
        return a.contentEquals(b)
    }
    if (a is LongArray && b is LongArray) {
        return a.contentEquals(b)
    }
    if (a is DoubleArray && b is DoubleArray) {
        return a.contentEquals(b)
    }
    if (a is Array<*> && b is Array<*>) {
      return a.size == b.size &&
          a.indices.all{ deepEquals(a[it], b[it]) }
    }
    if (a is List<*> && b is List<*>) {
      return a.size == b.size &&
          a.indices.all{ deepEquals(a[it], b[it]) }
    }
    if (a is Map<*, *> && b is Map<*, *>) {
      return a.size == b.size && a.all {
          (b as Map<Any?, Any?>).containsKey(it.key) &&
          deepEquals(it.value, b[it.key])
      }
    }
    return a == b
  }
      
}

/**
 * Error class for passing custom error details to Flutter via a thrown PlatformException.
 * @property code The error code.
 * @property message The error message.
 * @property details The error details. Must be a datatype supported by the api codec.
 */
class FlutterError (
  val code: String,
  override val message: String? = null,
  val details: Any? = null
) : Throwable()

/** Generated class from Pigeon that represents data sent in messages. */
data class PlatformAsset (
  val id: String,
  val name: String,
  val type: Long,
  val createdAt: Long? = null,
  val updatedAt: Long? = null,
  val width: Long? = null,
  val height: Long? = null,
  val durationInSeconds: Long,
  val orientation: Long,
  val isFavorite: Boolean
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): PlatformAsset {
      val id = pigeonVar_list[0] as String
      val name = pigeonVar_list[1] as String
      val type = pigeonVar_list[2] as Long
      val createdAt = pigeonVar_list[3] as Long?
      val updatedAt = pigeonVar_list[4] as Long?
      val width = pigeonVar_list[5] as Long?
      val height = pigeonVar_list[6] as Long?
      val durationInSeconds = pigeonVar_list[7] as Long
      val orientation = pigeonVar_list[8] as Long
      val isFavorite = pigeonVar_list[9] as Boolean
      return PlatformAsset(id, name, type, createdAt, updatedAt, width, height, durationInSeconds, orientation, isFavorite)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      id,
      name,
      type,
      createdAt,
      updatedAt,
      width,
      height,
      durationInSeconds,
      orientation,
      isFavorite,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is PlatformAsset) {
      return false
    }
    if (this === other) {
      return true
    }
    return MessagesPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class PlatformAlbum (
  val id: String,
  val name: String,
  val updatedAt: Long? = null,
  val isCloud: Boolean,
  val assetCount: Long
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): PlatformAlbum {
      val id = pigeonVar_list[0] as String
      val name = pigeonVar_list[1] as String
      val updatedAt = pigeonVar_list[2] as Long?
      val isCloud = pigeonVar_list[3] as Boolean
      val assetCount = pigeonVar_list[4] as Long
      return PlatformAlbum(id, name, updatedAt, isCloud, assetCount)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      id,
      name,
      updatedAt,
      isCloud,
      assetCount,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is PlatformAlbum) {
      return false
    }
    if (this === other) {
      return true
    }
    return MessagesPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class SyncDelta (
  val hasChanges: Boolean,
  val updates: List<PlatformAsset>,
  val deletes: List<String>,
  val assetAlbums: Map<String, List<String>>
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): SyncDelta {
      val hasChanges = pigeonVar_list[0] as Boolean
      val updates = pigeonVar_list[1] as List<PlatformAsset>
      val deletes = pigeonVar_list[2] as List<String>
      val assetAlbums = pigeonVar_list[3] as Map<String, List<String>>
      return SyncDelta(hasChanges, updates, deletes, assetAlbums)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      hasChanges,
      updates,
      deletes,
      assetAlbums,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is SyncDelta) {
      return false
    }
    if (this === other) {
      return true
    }
    return MessagesPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}
private open class MessagesPigeonCodec : StandardMessageCodec() {
  override fun readValueOfType(type: Byte, buffer: ByteBuffer): Any? {
    return when (type) {
      129.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          PlatformAsset.fromList(it)
        }
      }
      130.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          PlatformAlbum.fromList(it)
        }
      }
      131.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          SyncDelta.fromList(it)
        }
      }
      else -> super.readValueOfType(type, buffer)
    }
  }
  override fun writeValue(stream: ByteArrayOutputStream, value: Any?)   {
    when (value) {
      is PlatformAsset -> {
        stream.write(129)
        writeValue(stream, value.toList())
      }
      is PlatformAlbum -> {
        stream.write(130)
        writeValue(stream, value.toList())
      }
      is SyncDelta -> {
        stream.write(131)
        writeValue(stream, value.toList())
      }
      else -> super.writeValue(stream, value)
    }
  }
}

/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface NativeSyncApi {
  fun shouldFullSync(): Boolean
  fun getMediaChanges(): SyncDelta
  fun checkpointSync()
  fun clearSyncCheckpoint()
  fun getAssetIdsForAlbum(albumId: String): List<String>
  fun getAlbums(): List<PlatformAlbum>
  fun getAssetsCountSince(albumId: String, timestamp: Long): Long
  fun getAssetsForAlbum(albumId: String, updatedTimeCond: Long?): List<PlatformAsset>
  fun hashPaths(paths: List<String>): List<ByteArray?>

  companion object {
    /** The codec used by NativeSyncApi. */
    val codec: MessageCodec<Any?> by lazy {
      MessagesPigeonCodec()
    }
    /** Sets up an instance of `NativeSyncApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: NativeSyncApi?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      val taskQueue = binaryMessenger.makeBackgroundTaskQueue()
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.immich_mobile.NativeSyncApi.shouldFullSync$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              listOf(api.shouldFullSync())
            } catch (exception: Throwable) {
              MessagesPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.immich_mobile.NativeSyncApi.getMediaChanges$separatedMessageChannelSuffix", codec, taskQueue)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              listOf(api.getMediaChanges())
            } catch (exception: Throwable) {
              MessagesPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.immich_mobile.NativeSyncApi.checkpointSync$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              api.checkpointSync()
              listOf(null)
            } catch (exception: Throwable) {
              MessagesPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.immich_mobile.NativeSyncApi.clearSyncCheckpoint$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              api.clearSyncCheckpoint()
              listOf(null)
            } catch (exception: Throwable) {
              MessagesPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.immich_mobile.NativeSyncApi.getAssetIdsForAlbum$separatedMessageChannelSuffix", codec, taskQueue)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val albumIdArg = args[0] as String
            val wrapped: List<Any?> = try {
              listOf(api.getAssetIdsForAlbum(albumIdArg))
            } catch (exception: Throwable) {
              MessagesPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.immich_mobile.NativeSyncApi.getAlbums$separatedMessageChannelSuffix", codec, taskQueue)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              listOf(api.getAlbums())
            } catch (exception: Throwable) {
              MessagesPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.immich_mobile.NativeSyncApi.getAssetsCountSince$separatedMessageChannelSuffix", codec, taskQueue)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val albumIdArg = args[0] as String
            val timestampArg = args[1] as Long
            val wrapped: List<Any?> = try {
              listOf(api.getAssetsCountSince(albumIdArg, timestampArg))
            } catch (exception: Throwable) {
              MessagesPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.immich_mobile.NativeSyncApi.getAssetsForAlbum$separatedMessageChannelSuffix", codec, taskQueue)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val albumIdArg = args[0] as String
            val updatedTimeCondArg = args[1] as Long?
            val wrapped: List<Any?> = try {
              listOf(api.getAssetsForAlbum(albumIdArg, updatedTimeCondArg))
            } catch (exception: Throwable) {
              MessagesPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.immich_mobile.NativeSyncApi.hashPaths$separatedMessageChannelSuffix", codec, taskQueue)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pathsArg = args[0] as List<String>
            val wrapped: List<Any?> = try {
              listOf(api.hashPaths(pathsArg))
            } catch (exception: Throwable) {
              MessagesPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
