// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// Autogenerated from Pigeon, do not edit directly.
// See also: https://pub.dev/packages/pigeon
// ignore_for_file: public_member_api_docs, non_constant_identifier_names, avoid_as, unused_import, unnecessary_parenthesis, prefer_null_aware_operators, omit_local_variable_types, unused_shown_name, unnecessary_import, no_leading_underscores_for_local_identifiers

import 'dart:async';
import 'dart:io' show Platform;
import 'dart:typed_data' show Float64List, Int32List, Int64List, Uint8List;

import 'package:flutter/foundation.dart'
    show ReadBuffer, WriteBuffer, immutable, protected, visibleForTesting;
import 'package:flutter/services.dart';
import 'package:flutter/widgets.dart' show WidgetsFlutterBinding;

PlatformException _createConnectionError(String channelName) {
  return PlatformException(
    code: 'channel-error',
    message: 'Unable to establish connection on channel: "$channelName".',
  );
}

List<Object?> wrapResponse(
    {Object? result, PlatformException? error, bool empty = false}) {
  if (empty) {
    return <Object?>[];
  }
  if (error == null) {
    return <Object?>[result];
  }
  return <Object?>[error.code, error.message, error.details];
}

/// Provides overrides for the constructors and static members of each proxy
/// API.
///
/// This is only intended to be used with unit tests to prevent errors from
/// making message calls in a unit test.
///
/// See [PigeonOverrides.pigeon_reset] to set all overrides back to null.
@visibleForTesting
class PigeonOverrides {
  /// Overrides [ProxyApiTestClass.new].
  static ProxyApiTestClass Function({
    required bool aBool,
    required int anInt,
    required double aDouble,
    required String aString,
    required Uint8List aUint8List,
    required List<Object?> aList,
    required Map<String?, Object?> aMap,
    required ProxyApiTestEnum anEnum,
    required ProxyApiSuperClass aProxyApi,
    required bool Function(
      ProxyApiTestClass pigeon_instance,
      bool aBool,
    ) flutterEchoBool,
    required int Function(
      ProxyApiTestClass pigeon_instance,
      int anInt,
    ) flutterEchoInt,
    required double Function(
      ProxyApiTestClass pigeon_instance,
      double aDouble,
    ) flutterEchoDouble,
    required String Function(
      ProxyApiTestClass pigeon_instance,
      String aString,
    ) flutterEchoString,
    required Uint8List Function(
      ProxyApiTestClass pigeon_instance,
      Uint8List aList,
    ) flutterEchoUint8List,
    required List<Object?> Function(
      ProxyApiTestClass pigeon_instance,
      List<Object?> aList,
    ) flutterEchoList,
    required List<ProxyApiTestClass?> Function(
      ProxyApiTestClass pigeon_instance,
      List<ProxyApiTestClass?> aList,
    ) flutterEchoProxyApiList,
    required Map<String?, Object?> Function(
      ProxyApiTestClass pigeon_instance,
      Map<String?, Object?> aMap,
    ) flutterEchoMap,
    required Map<String?, ProxyApiTestClass?> Function(
      ProxyApiTestClass pigeon_instance,
      Map<String?, ProxyApiTestClass?> aMap,
    ) flutterEchoProxyApiMap,
    required ProxyApiTestEnum Function(
      ProxyApiTestClass pigeon_instance,
      ProxyApiTestEnum anEnum,
    ) flutterEchoEnum,
    required ProxyApiSuperClass Function(
      ProxyApiTestClass pigeon_instance,
      ProxyApiSuperClass aProxyApi,
    ) flutterEchoProxyApi,
    required Future<String> Function(
      ProxyApiTestClass pigeon_instance,
      String aString,
    ) flutterEchoAsyncString,
    required bool boolParam,
    required int intParam,
    required double doubleParam,
    required String stringParam,
    required Uint8List aUint8ListParam,
    required List<Object?> listParam,
    required Map<String?, Object?> mapParam,
    required ProxyApiTestEnum enumParam,
    required ProxyApiSuperClass proxyApiParam,
    bool? aNullableBool,
    int? aNullableInt,
    double? aNullableDouble,
    String? aNullableString,
    Uint8List? aNullableUint8List,
    List<Object?>? aNullableList,
    Map<String?, Object?>? aNullableMap,
    ProxyApiTestEnum? aNullableEnum,
    ProxyApiSuperClass? aNullableProxyApi,
    void Function(ProxyApiInterface pigeon_instance)? anInterfaceMethod,
    void Function(ProxyApiTestClass pigeon_instance)? flutterNoop,
    Object? Function(ProxyApiTestClass pigeon_instance)? flutterThrowError,
    void Function(ProxyApiTestClass pigeon_instance)? flutterThrowErrorFromVoid,
    bool? Function(
      ProxyApiTestClass pigeon_instance,
      bool? aBool,
    )? flutterEchoNullableBool,
    int? Function(
      ProxyApiTestClass pigeon_instance,
      int? anInt,
    )? flutterEchoNullableInt,
    double? Function(
      ProxyApiTestClass pigeon_instance,
      double? aDouble,
    )? flutterEchoNullableDouble,
    String? Function(
      ProxyApiTestClass pigeon_instance,
      String? aString,
    )? flutterEchoNullableString,
    Uint8List? Function(
      ProxyApiTestClass pigeon_instance,
      Uint8List? aList,
    )? flutterEchoNullableUint8List,
    List<Object?>? Function(
      ProxyApiTestClass pigeon_instance,
      List<Object?>? aList,
    )? flutterEchoNullableList,
    Map<String?, Object?>? Function(
      ProxyApiTestClass pigeon_instance,
      Map<String?, Object?>? aMap,
    )? flutterEchoNullableMap,
    ProxyApiTestEnum? Function(
      ProxyApiTestClass pigeon_instance,
      ProxyApiTestEnum? anEnum,
    )? flutterEchoNullableEnum,
    ProxyApiSuperClass? Function(
      ProxyApiTestClass pigeon_instance,
      ProxyApiSuperClass? aProxyApi,
    )? flutterEchoNullableProxyApi,
    Future<void> Function(ProxyApiTestClass pigeon_instance)? flutterNoopAsync,
    bool? nullableBoolParam,
    int? nullableIntParam,
    double? nullableDoubleParam,
    String? nullableStringParam,
    Uint8List? nullableUint8ListParam,
    List<Object?>? nullableListParam,
    Map<String?, Object?>? nullableMapParam,
    ProxyApiTestEnum? nullableEnumParam,
    ProxyApiSuperClass? nullableProxyApiParam,
  })? proxyApiTestClass_new;

  /// Overrides [ProxyApiTestClass.namedConstructor].
  static ProxyApiTestClass Function({
    required bool aBool,
    required int anInt,
    required double aDouble,
    required String aString,
    required Uint8List aUint8List,
    required List<Object?> aList,
    required Map<String?, Object?> aMap,
    required ProxyApiTestEnum anEnum,
    required ProxyApiSuperClass aProxyApi,
    required bool Function(
      ProxyApiTestClass pigeon_instance,
      bool aBool,
    ) flutterEchoBool,
    required int Function(
      ProxyApiTestClass pigeon_instance,
      int anInt,
    ) flutterEchoInt,
    required double Function(
      ProxyApiTestClass pigeon_instance,
      double aDouble,
    ) flutterEchoDouble,
    required String Function(
      ProxyApiTestClass pigeon_instance,
      String aString,
    ) flutterEchoString,
    required Uint8List Function(
      ProxyApiTestClass pigeon_instance,
      Uint8List aList,
    ) flutterEchoUint8List,
    required List<Object?> Function(
      ProxyApiTestClass pigeon_instance,
      List<Object?> aList,
    ) flutterEchoList,
    required List<ProxyApiTestClass?> Function(
      ProxyApiTestClass pigeon_instance,
      List<ProxyApiTestClass?> aList,
    ) flutterEchoProxyApiList,
    required Map<String?, Object?> Function(
      ProxyApiTestClass pigeon_instance,
      Map<String?, Object?> aMap,
    ) flutterEchoMap,
    required Map<String?, ProxyApiTestClass?> Function(
      ProxyApiTestClass pigeon_instance,
      Map<String?, ProxyApiTestClass?> aMap,
    ) flutterEchoProxyApiMap,
    required ProxyApiTestEnum Function(
      ProxyApiTestClass pigeon_instance,
      ProxyApiTestEnum anEnum,
    ) flutterEchoEnum,
    required ProxyApiSuperClass Function(
      ProxyApiTestClass pigeon_instance,
      ProxyApiSuperClass aProxyApi,
    ) flutterEchoProxyApi,
    required Future<String> Function(
      ProxyApiTestClass pigeon_instance,
      String aString,
    ) flutterEchoAsyncString,
    bool? aNullableBool,
    int? aNullableInt,
    double? aNullableDouble,
    String? aNullableString,
    Uint8List? aNullableUint8List,
    List<Object?>? aNullableList,
    Map<String?, Object?>? aNullableMap,
    ProxyApiTestEnum? aNullableEnum,
    ProxyApiSuperClass? aNullableProxyApi,
    void Function(ProxyApiInterface pigeon_instance)? anInterfaceMethod,
    void Function(ProxyApiTestClass pigeon_instance)? flutterNoop,
    Object? Function(ProxyApiTestClass pigeon_instance)? flutterThrowError,
    void Function(ProxyApiTestClass pigeon_instance)? flutterThrowErrorFromVoid,
    bool? Function(
      ProxyApiTestClass pigeon_instance,
      bool? aBool,
    )? flutterEchoNullableBool,
    int? Function(
      ProxyApiTestClass pigeon_instance,
      int? anInt,
    )? flutterEchoNullableInt,
    double? Function(
      ProxyApiTestClass pigeon_instance,
      double? aDouble,
    )? flutterEchoNullableDouble,
    String? Function(
      ProxyApiTestClass pigeon_instance,
      String? aString,
    )? flutterEchoNullableString,
    Uint8List? Function(
      ProxyApiTestClass pigeon_instance,
      Uint8List? aList,
    )? flutterEchoNullableUint8List,
    List<Object?>? Function(
      ProxyApiTestClass pigeon_instance,
      List<Object?>? aList,
    )? flutterEchoNullableList,
    Map<String?, Object?>? Function(
      ProxyApiTestClass pigeon_instance,
      Map<String?, Object?>? aMap,
    )? flutterEchoNullableMap,
    ProxyApiTestEnum? Function(
      ProxyApiTestClass pigeon_instance,
      ProxyApiTestEnum? anEnum,
    )? flutterEchoNullableEnum,
    ProxyApiSuperClass? Function(
      ProxyApiTestClass pigeon_instance,
      ProxyApiSuperClass? aProxyApi,
    )? flutterEchoNullableProxyApi,
    Future<void> Function(ProxyApiTestClass pigeon_instance)? flutterNoopAsync,
  })? proxyApiTestClass_namedConstructor;

  /// Overrides [ProxyApiSuperClass.new].
  static ProxyApiSuperClass Function()? proxyApiSuperClass_new;

  /// Overrides [ClassWithApiRequirement.new].
  static ClassWithApiRequirement Function()? classWithApiRequirement_new;

  /// Overrides [ProxyApiTestClass.staticAttachedField].
  static ProxyApiSuperClass? proxyApiTestClass_staticAttachedField;

  /// Overrides [ProxyApiTestClass.staticNoop].
  static Future<void> Function()? proxyApiTestClass_staticNoop;

  /// Overrides [ProxyApiTestClass.echoStaticString].
  static Future<String> Function(String)? proxyApiTestClass_echoStaticString;

  /// Overrides [ProxyApiTestClass.staticAsyncNoop].
  static Future<void> Function()? proxyApiTestClass_staticAsyncNoop;

  /// Sets all overridden ProxyApi class members to null.
  static void pigeon_reset() {
    proxyApiTestClass_new = null;
    proxyApiTestClass_namedConstructor = null;
    proxyApiTestClass_staticAttachedField = null;
    proxyApiTestClass_staticNoop = null;
    proxyApiTestClass_echoStaticString = null;
    proxyApiTestClass_staticAsyncNoop = null;
    proxyApiSuperClass_new = null;
    classWithApiRequirement_new = null;
  }
}

/// An immutable object that serves as the base class for all ProxyApis and
/// can provide functional copies of itself.
///
/// All implementers are expected to be [immutable] as defined by the annotation
/// and override [pigeon_copy] returning an instance of itself.
@immutable
abstract class PigeonInternalProxyApiBaseClass {
  /// Construct a [PigeonInternalProxyApiBaseClass].
  PigeonInternalProxyApiBaseClass({
    this.pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
  }) : pigeon_instanceManager =
            pigeon_instanceManager ?? PigeonInstanceManager.instance;

  /// Sends and receives binary data across the Flutter platform barrier.
  ///
  /// If it is null, the default BinaryMessenger will be used, which routes to
  /// the host platform.
  @protected
  final BinaryMessenger? pigeon_binaryMessenger;

  /// Maintains instances stored to communicate with native language objects.
  final PigeonInstanceManager pigeon_instanceManager;

  /// Instantiates and returns a functionally identical object to oneself.
  ///
  /// Outside of tests, this method should only ever be called by
  /// [PigeonInstanceManager].
  ///
  /// Subclasses should always override their parent's implementation of this
  /// method.
  @protected
  PigeonInternalProxyApiBaseClass pigeon_copy();
}

/// Maintains instances used to communicate with the native objects they
/// represent.
///
/// Added instances are stored as weak references and their copies are stored
/// as strong references to maintain access to their variables and callback
/// methods. Both are stored with the same identifier.
///
/// When a weak referenced instance becomes inaccessible,
/// [onWeakReferenceRemoved] is called with its associated identifier.
///
/// If an instance is retrieved and has the possibility to be used,
/// (e.g. calling [getInstanceWithWeakReference]) a copy of the strong reference
/// is added as a weak reference with the same identifier. This prevents a
/// scenario where the weak referenced instance was released and then later
/// returned by the host platform.
class PigeonInstanceManager {
  /// Constructs a [PigeonInstanceManager].
  PigeonInstanceManager({required void Function(int) onWeakReferenceRemoved}) {
    this.onWeakReferenceRemoved = (int identifier) {
      _weakInstances.remove(identifier);
      onWeakReferenceRemoved(identifier);
    };
    _finalizer = Finalizer<int>(this.onWeakReferenceRemoved);
  }

  // Identifiers are locked to a specific range to avoid collisions with objects
  // created simultaneously by the host platform.
  // Host uses identifiers >= 2^16 and Dart is expected to use values n where,
  // 0 <= n < 2^16.
  static const int _maxDartCreatedIdentifier = 65536;

  /// The default [PigeonInstanceManager] used by ProxyApis.
  ///
  /// On creation, this manager makes a call to clear the native
  /// InstanceManager. This is to prevent identifier conflicts after a host
  /// restart.
  static final PigeonInstanceManager instance = _initInstance();

  // Expando is used because it doesn't prevent its keys from becoming
  // inaccessible. This allows the manager to efficiently retrieve an identifier
  // of an instance without holding a strong reference to that instance.
  //
  // It also doesn't use `==` to search for identifiers, which would lead to an
  // infinite loop when comparing an object to its copy. (i.e. which was caused
  // by calling instanceManager.getIdentifier() inside of `==` while this was a
  // HashMap).
  final Expando<int> _identifiers = Expando<int>();
  final Map<int, WeakReference<PigeonInternalProxyApiBaseClass>>
      _weakInstances = <int, WeakReference<PigeonInternalProxyApiBaseClass>>{};
  final Map<int, PigeonInternalProxyApiBaseClass> _strongInstances =
      <int, PigeonInternalProxyApiBaseClass>{};
  late final Finalizer<int> _finalizer;
  int _nextIdentifier = 0;

  /// Called when a weak referenced instance is removed by [removeWeakReference]
  /// or becomes inaccessible.
  late final void Function(int) onWeakReferenceRemoved;

  static PigeonInstanceManager _initInstance() {
    if (Platform.environment['FLUTTER_TEST'] == 'true') {
      return PigeonInstanceManager(onWeakReferenceRemoved: (_) {});
    }
    WidgetsFlutterBinding.ensureInitialized();
    final _PigeonInternalInstanceManagerApi api =
        _PigeonInternalInstanceManagerApi();
    // Clears the native `PigeonInstanceManager` on the initial use of the Dart one.
    api.clear();
    final PigeonInstanceManager instanceManager = PigeonInstanceManager(
      onWeakReferenceRemoved: (int identifier) {
        api.removeStrongReference(identifier);
      },
    );
    _PigeonInternalInstanceManagerApi.setUpMessageHandlers(
        instanceManager: instanceManager);
    ProxyApiTestClass.pigeon_setUpMessageHandlers(
        pigeon_instanceManager: instanceManager);
    ProxyApiSuperClass.pigeon_setUpMessageHandlers(
        pigeon_instanceManager: instanceManager);
    ProxyApiInterface.pigeon_setUpMessageHandlers(
        pigeon_instanceManager: instanceManager);
    ClassWithApiRequirement.pigeon_setUpMessageHandlers(
        pigeon_instanceManager: instanceManager);
    return instanceManager;
  }

  /// Adds a new instance that was instantiated by Dart.
  ///
  /// In other words, Dart wants to add a new instance that will represent
  /// an object that will be instantiated on the host platform.
  ///
  /// Throws assertion error if the instance has already been added.
  ///
  /// Returns the randomly generated id of the [instance] added.
  int addDartCreatedInstance(PigeonInternalProxyApiBaseClass instance) {
    assert(getIdentifier(instance) == null);

    final int identifier = _nextUniqueIdentifier();
    _identifiers[instance] = identifier;
    _weakInstances[identifier] =
        WeakReference<PigeonInternalProxyApiBaseClass>(instance);
    _finalizer.attach(instance, identifier, detach: instance);

    final PigeonInternalProxyApiBaseClass copy = instance.pigeon_copy();
    _identifiers[copy] = identifier;
    _strongInstances[identifier] = copy;
    return identifier;
  }

  /// Removes the instance, if present, and call [onWeakReferenceRemoved] with
  /// its identifier.
  ///
  /// Returns the identifier associated with the removed instance. Otherwise,
  /// `null` if the instance was not found in this manager.
  ///
  /// This does not remove the strong referenced instance associated with
  /// [instance]. This can be done with [remove].
  int? removeWeakReference(PigeonInternalProxyApiBaseClass instance) {
    final int? identifier = getIdentifier(instance);
    if (identifier == null) {
      return null;
    }

    _identifiers[instance] = null;
    _finalizer.detach(instance);
    onWeakReferenceRemoved(identifier);

    return identifier;
  }

  /// Removes [identifier] and its associated strongly referenced instance, if
  /// present, from the manager.
  ///
  /// Returns the strong referenced instance associated with [identifier] before
  /// it was removed. Returns `null` if [identifier] was not associated with
  /// any strong reference.
  ///
  /// Throws an `AssertionError` if the weak referenced instance associated with
  /// [identifier] is not removed first. This can be done with
  /// [removeWeakReference].
  T? remove<T extends PigeonInternalProxyApiBaseClass>(int identifier) {
    final T? instance = _weakInstances[identifier]?.target as T?;
    assert(
      instance == null,
      'A strong instance with identifier $identifier is being removed despite the weak reference still existing: $instance',
    );
    return _strongInstances.remove(identifier) as T?;
  }

  /// Retrieves the instance associated with identifier.
  ///
  /// The value returned is chosen from the following order:
  ///
  /// 1. A weakly referenced instance associated with identifier.
  /// 2. If the only instance associated with identifier is a strongly
  /// referenced instance, a copy of the instance is added as a weak reference
  /// with the same identifier. Returning the newly created copy.
  /// 3. If no instance is associated with identifier, returns null.
  ///
  /// This method also expects the host `InstanceManager` to have a strong
  /// reference to the instance the identifier is associated with.
  T? getInstanceWithWeakReference<T extends PigeonInternalProxyApiBaseClass>(
      int identifier) {
    final PigeonInternalProxyApiBaseClass? weakInstance =
        _weakInstances[identifier]?.target;

    if (weakInstance == null) {
      final PigeonInternalProxyApiBaseClass? strongInstance =
          _strongInstances[identifier];
      if (strongInstance != null) {
        final PigeonInternalProxyApiBaseClass copy =
            strongInstance.pigeon_copy();
        _identifiers[copy] = identifier;
        _weakInstances[identifier] =
            WeakReference<PigeonInternalProxyApiBaseClass>(copy);
        _finalizer.attach(copy, identifier, detach: copy);
        return copy as T;
      }
      return strongInstance as T?;
    }

    return weakInstance as T;
  }

  /// Retrieves the identifier associated with instance.
  int? getIdentifier(PigeonInternalProxyApiBaseClass instance) {
    return _identifiers[instance];
  }

  /// Adds a new instance that was instantiated by the host platform.
  ///
  /// In other words, the host platform wants to add a new instance that
  /// represents an object on the host platform. Stored with [identifier].
  ///
  /// Throws assertion error if the instance or its identifier has already been
  /// added.
  void addHostCreatedInstance(
      PigeonInternalProxyApiBaseClass instance, int identifier) {
    assert(!containsIdentifier(identifier));
    assert(getIdentifier(instance) == null);
    assert(identifier >= 0);

    _identifiers[instance] = identifier;
    _strongInstances[identifier] = instance;
  }

  /// Whether this manager contains the given [identifier].
  bool containsIdentifier(int identifier) {
    return _weakInstances.containsKey(identifier) ||
        _strongInstances.containsKey(identifier);
  }

  int _nextUniqueIdentifier() {
    late int identifier;
    do {
      identifier = _nextIdentifier;
      _nextIdentifier = (_nextIdentifier + 1) % _maxDartCreatedIdentifier;
    } while (containsIdentifier(identifier));
    return identifier;
  }
}

/// Generated API for managing the Dart and native `PigeonInstanceManager`s.
class _PigeonInternalInstanceManagerApi {
  /// Constructor for [_PigeonInternalInstanceManagerApi].
  _PigeonInternalInstanceManagerApi({BinaryMessenger? binaryMessenger})
      : pigeonVar_binaryMessenger = binaryMessenger;

  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  static void setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? binaryMessenger,
    PigeonInstanceManager? instanceManager,
  }) {
    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.PigeonInternalInstanceManager.removeStrongReference',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.PigeonInternalInstanceManager.removeStrongReference was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_identifier = (args[0] as int?);
          assert(arg_identifier != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.PigeonInternalInstanceManager.removeStrongReference was null, expected non-null int.');
          try {
            (instanceManager ?? PigeonInstanceManager.instance)
                .remove(arg_identifier!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
  }

  Future<void> removeStrongReference(int identifier) async {
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.PigeonInternalInstanceManager.removeStrongReference';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[identifier]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Clear the native `PigeonInstanceManager`.
  ///
  /// This is typically called after a hot restart.
  Future<void> clear() async {
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.PigeonInternalInstanceManager.clear';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

class _PigeonInternalProxyApiBaseCodec extends _PigeonCodec {
  const _PigeonInternalProxyApiBaseCodec(this.instanceManager);
  final PigeonInstanceManager instanceManager;
  @override
  void writeValue(WriteBuffer buffer, Object? value) {
    if (value is PigeonInternalProxyApiBaseClass) {
      buffer.putUint8(128);
      writeValue(buffer, instanceManager.getIdentifier(value));
    } else {
      super.writeValue(buffer, value);
    }
  }

  @override
  Object? readValueOfType(int type, ReadBuffer buffer) {
    switch (type) {
      case 128:
        return instanceManager
            .getInstanceWithWeakReference(readValue(buffer)! as int);
      default:
        return super.readValueOfType(type, buffer);
    }
  }
}

enum ProxyApiTestEnum {
  one,
  two,
  three,
}

class _PigeonCodec extends StandardMessageCodec {
  const _PigeonCodec();
  @override
  void writeValue(WriteBuffer buffer, Object? value) {
    if (value is int) {
      buffer.putUint8(4);
      buffer.putInt64(value);
    } else if (value is ProxyApiTestEnum) {
      buffer.putUint8(129);
      writeValue(buffer, value.index);
    } else {
      super.writeValue(buffer, value);
    }
  }

  @override
  Object? readValueOfType(int type, ReadBuffer buffer) {
    switch (type) {
      case 129:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : ProxyApiTestEnum.values[value];
      default:
        return super.readValueOfType(type, buffer);
    }
  }
}

/// The core ProxyApi test class that each supported host language must
/// implement in platform_tests integration tests.
class ProxyApiTestClass extends ProxyApiSuperClass
    implements ProxyApiInterface {
  factory ProxyApiTestClass({
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    required bool aBool,
    required int anInt,
    required double aDouble,
    required String aString,
    required Uint8List aUint8List,
    required List<Object?> aList,
    required Map<String?, Object?> aMap,
    required ProxyApiTestEnum anEnum,
    required ProxyApiSuperClass aProxyApi,
    bool? aNullableBool,
    int? aNullableInt,
    double? aNullableDouble,
    String? aNullableString,
    Uint8List? aNullableUint8List,
    List<Object?>? aNullableList,
    Map<String?, Object?>? aNullableMap,
    ProxyApiTestEnum? aNullableEnum,
    ProxyApiSuperClass? aNullableProxyApi,
    void Function(ProxyApiInterface pigeon_instance)? anInterfaceMethod,
    void Function(ProxyApiTestClass pigeon_instance)? flutterNoop,
    Object? Function(ProxyApiTestClass pigeon_instance)? flutterThrowError,
    void Function(ProxyApiTestClass pigeon_instance)? flutterThrowErrorFromVoid,
    required bool Function(
      ProxyApiTestClass pigeon_instance,
      bool aBool,
    ) flutterEchoBool,
    required int Function(
      ProxyApiTestClass pigeon_instance,
      int anInt,
    ) flutterEchoInt,
    required double Function(
      ProxyApiTestClass pigeon_instance,
      double aDouble,
    ) flutterEchoDouble,
    required String Function(
      ProxyApiTestClass pigeon_instance,
      String aString,
    ) flutterEchoString,
    required Uint8List Function(
      ProxyApiTestClass pigeon_instance,
      Uint8List aList,
    ) flutterEchoUint8List,
    required List<Object?> Function(
      ProxyApiTestClass pigeon_instance,
      List<Object?> aList,
    ) flutterEchoList,
    required List<ProxyApiTestClass?> Function(
      ProxyApiTestClass pigeon_instance,
      List<ProxyApiTestClass?> aList,
    ) flutterEchoProxyApiList,
    required Map<String?, Object?> Function(
      ProxyApiTestClass pigeon_instance,
      Map<String?, Object?> aMap,
    ) flutterEchoMap,
    required Map<String?, ProxyApiTestClass?> Function(
      ProxyApiTestClass pigeon_instance,
      Map<String?, ProxyApiTestClass?> aMap,
    ) flutterEchoProxyApiMap,
    required ProxyApiTestEnum Function(
      ProxyApiTestClass pigeon_instance,
      ProxyApiTestEnum anEnum,
    ) flutterEchoEnum,
    required ProxyApiSuperClass Function(
      ProxyApiTestClass pigeon_instance,
      ProxyApiSuperClass aProxyApi,
    ) flutterEchoProxyApi,
    bool? Function(
      ProxyApiTestClass pigeon_instance,
      bool? aBool,
    )? flutterEchoNullableBool,
    int? Function(
      ProxyApiTestClass pigeon_instance,
      int? anInt,
    )? flutterEchoNullableInt,
    double? Function(
      ProxyApiTestClass pigeon_instance,
      double? aDouble,
    )? flutterEchoNullableDouble,
    String? Function(
      ProxyApiTestClass pigeon_instance,
      String? aString,
    )? flutterEchoNullableString,
    Uint8List? Function(
      ProxyApiTestClass pigeon_instance,
      Uint8List? aList,
    )? flutterEchoNullableUint8List,
    List<Object?>? Function(
      ProxyApiTestClass pigeon_instance,
      List<Object?>? aList,
    )? flutterEchoNullableList,
    Map<String?, Object?>? Function(
      ProxyApiTestClass pigeon_instance,
      Map<String?, Object?>? aMap,
    )? flutterEchoNullableMap,
    ProxyApiTestEnum? Function(
      ProxyApiTestClass pigeon_instance,
      ProxyApiTestEnum? anEnum,
    )? flutterEchoNullableEnum,
    ProxyApiSuperClass? Function(
      ProxyApiTestClass pigeon_instance,
      ProxyApiSuperClass? aProxyApi,
    )? flutterEchoNullableProxyApi,
    Future<void> Function(ProxyApiTestClass pigeon_instance)? flutterNoopAsync,
    required Future<String> Function(
      ProxyApiTestClass pigeon_instance,
      String aString,
    ) flutterEchoAsyncString,
    required bool boolParam,
    required int intParam,
    required double doubleParam,
    required String stringParam,
    required Uint8List aUint8ListParam,
    required List<Object?> listParam,
    required Map<String?, Object?> mapParam,
    required ProxyApiTestEnum enumParam,
    required ProxyApiSuperClass proxyApiParam,
    bool? nullableBoolParam,
    int? nullableIntParam,
    double? nullableDoubleParam,
    String? nullableStringParam,
    Uint8List? nullableUint8ListParam,
    List<Object?>? nullableListParam,
    Map<String?, Object?>? nullableMapParam,
    ProxyApiTestEnum? nullableEnumParam,
    ProxyApiSuperClass? nullableProxyApiParam,
  }) {
    if (PigeonOverrides.proxyApiTestClass_new != null) {
      return PigeonOverrides.proxyApiTestClass_new!(
        aBool: aBool,
        anInt: anInt,
        aDouble: aDouble,
        aString: aString,
        aUint8List: aUint8List,
        aList: aList,
        aMap: aMap,
        anEnum: anEnum,
        aProxyApi: aProxyApi,
        aNullableBool: aNullableBool,
        aNullableInt: aNullableInt,
        aNullableDouble: aNullableDouble,
        aNullableString: aNullableString,
        aNullableUint8List: aNullableUint8List,
        aNullableList: aNullableList,
        aNullableMap: aNullableMap,
        aNullableEnum: aNullableEnum,
        aNullableProxyApi: aNullableProxyApi,
        anInterfaceMethod: anInterfaceMethod,
        flutterNoop: flutterNoop,
        flutterThrowError: flutterThrowError,
        flutterThrowErrorFromVoid: flutterThrowErrorFromVoid,
        flutterEchoBool: flutterEchoBool,
        flutterEchoInt: flutterEchoInt,
        flutterEchoDouble: flutterEchoDouble,
        flutterEchoString: flutterEchoString,
        flutterEchoUint8List: flutterEchoUint8List,
        flutterEchoList: flutterEchoList,
        flutterEchoProxyApiList: flutterEchoProxyApiList,
        flutterEchoMap: flutterEchoMap,
        flutterEchoProxyApiMap: flutterEchoProxyApiMap,
        flutterEchoEnum: flutterEchoEnum,
        flutterEchoProxyApi: flutterEchoProxyApi,
        flutterEchoNullableBool: flutterEchoNullableBool,
        flutterEchoNullableInt: flutterEchoNullableInt,
        flutterEchoNullableDouble: flutterEchoNullableDouble,
        flutterEchoNullableString: flutterEchoNullableString,
        flutterEchoNullableUint8List: flutterEchoNullableUint8List,
        flutterEchoNullableList: flutterEchoNullableList,
        flutterEchoNullableMap: flutterEchoNullableMap,
        flutterEchoNullableEnum: flutterEchoNullableEnum,
        flutterEchoNullableProxyApi: flutterEchoNullableProxyApi,
        flutterNoopAsync: flutterNoopAsync,
        flutterEchoAsyncString: flutterEchoAsyncString,
        boolParam: boolParam,
        intParam: intParam,
        doubleParam: doubleParam,
        stringParam: stringParam,
        aUint8ListParam: aUint8ListParam,
        listParam: listParam,
        mapParam: mapParam,
        enumParam: enumParam,
        proxyApiParam: proxyApiParam,
        nullableBoolParam: nullableBoolParam,
        nullableIntParam: nullableIntParam,
        nullableDoubleParam: nullableDoubleParam,
        nullableStringParam: nullableStringParam,
        nullableUint8ListParam: nullableUint8ListParam,
        nullableListParam: nullableListParam,
        nullableMapParam: nullableMapParam,
        nullableEnumParam: nullableEnumParam,
        nullableProxyApiParam: nullableProxyApiParam,
      );
    }
    return ProxyApiTestClass.pigeon_new(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      aBool: aBool,
      anInt: anInt,
      aDouble: aDouble,
      aString: aString,
      aUint8List: aUint8List,
      aList: aList,
      aMap: aMap,
      anEnum: anEnum,
      aProxyApi: aProxyApi,
      aNullableBool: aNullableBool,
      aNullableInt: aNullableInt,
      aNullableDouble: aNullableDouble,
      aNullableString: aNullableString,
      aNullableUint8List: aNullableUint8List,
      aNullableList: aNullableList,
      aNullableMap: aNullableMap,
      aNullableEnum: aNullableEnum,
      aNullableProxyApi: aNullableProxyApi,
      anInterfaceMethod: anInterfaceMethod,
      flutterNoop: flutterNoop,
      flutterThrowError: flutterThrowError,
      flutterThrowErrorFromVoid: flutterThrowErrorFromVoid,
      flutterEchoBool: flutterEchoBool,
      flutterEchoInt: flutterEchoInt,
      flutterEchoDouble: flutterEchoDouble,
      flutterEchoString: flutterEchoString,
      flutterEchoUint8List: flutterEchoUint8List,
      flutterEchoList: flutterEchoList,
      flutterEchoProxyApiList: flutterEchoProxyApiList,
      flutterEchoMap: flutterEchoMap,
      flutterEchoProxyApiMap: flutterEchoProxyApiMap,
      flutterEchoEnum: flutterEchoEnum,
      flutterEchoProxyApi: flutterEchoProxyApi,
      flutterEchoNullableBool: flutterEchoNullableBool,
      flutterEchoNullableInt: flutterEchoNullableInt,
      flutterEchoNullableDouble: flutterEchoNullableDouble,
      flutterEchoNullableString: flutterEchoNullableString,
      flutterEchoNullableUint8List: flutterEchoNullableUint8List,
      flutterEchoNullableList: flutterEchoNullableList,
      flutterEchoNullableMap: flutterEchoNullableMap,
      flutterEchoNullableEnum: flutterEchoNullableEnum,
      flutterEchoNullableProxyApi: flutterEchoNullableProxyApi,
      flutterNoopAsync: flutterNoopAsync,
      flutterEchoAsyncString: flutterEchoAsyncString,
      boolParam: boolParam,
      intParam: intParam,
      doubleParam: doubleParam,
      stringParam: stringParam,
      aUint8ListParam: aUint8ListParam,
      listParam: listParam,
      mapParam: mapParam,
      enumParam: enumParam,
      proxyApiParam: proxyApiParam,
      nullableBoolParam: nullableBoolParam,
      nullableIntParam: nullableIntParam,
      nullableDoubleParam: nullableDoubleParam,
      nullableStringParam: nullableStringParam,
      nullableUint8ListParam: nullableUint8ListParam,
      nullableListParam: nullableListParam,
      nullableMapParam: nullableMapParam,
      nullableEnumParam: nullableEnumParam,
      nullableProxyApiParam: nullableProxyApiParam,
    );
  }

  @protected
  ProxyApiTestClass.pigeon_new({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.aBool,
    required this.anInt,
    required this.aDouble,
    required this.aString,
    required this.aUint8List,
    required this.aList,
    required this.aMap,
    required this.anEnum,
    required this.aProxyApi,
    this.aNullableBool,
    this.aNullableInt,
    this.aNullableDouble,
    this.aNullableString,
    this.aNullableUint8List,
    this.aNullableList,
    this.aNullableMap,
    this.aNullableEnum,
    this.aNullableProxyApi,
    this.anInterfaceMethod,
    this.flutterNoop,
    this.flutterThrowError,
    this.flutterThrowErrorFromVoid,
    required this.flutterEchoBool,
    required this.flutterEchoInt,
    required this.flutterEchoDouble,
    required this.flutterEchoString,
    required this.flutterEchoUint8List,
    required this.flutterEchoList,
    required this.flutterEchoProxyApiList,
    required this.flutterEchoMap,
    required this.flutterEchoProxyApiMap,
    required this.flutterEchoEnum,
    required this.flutterEchoProxyApi,
    this.flutterEchoNullableBool,
    this.flutterEchoNullableInt,
    this.flutterEchoNullableDouble,
    this.flutterEchoNullableString,
    this.flutterEchoNullableUint8List,
    this.flutterEchoNullableList,
    this.flutterEchoNullableMap,
    this.flutterEchoNullableEnum,
    this.flutterEchoNullableProxyApi,
    this.flutterNoopAsync,
    required this.flutterEchoAsyncString,
    required bool boolParam,
    required int intParam,
    required double doubleParam,
    required String stringParam,
    required Uint8List aUint8ListParam,
    required List<Object?> listParam,
    required Map<String?, Object?> mapParam,
    required ProxyApiTestEnum enumParam,
    required ProxyApiSuperClass proxyApiParam,
    bool? nullableBoolParam,
    int? nullableIntParam,
    double? nullableDoubleParam,
    String? nullableStringParam,
    Uint8List? nullableUint8ListParam,
    List<Object?>? nullableListParam,
    Map<String?, Object?>? nullableMapParam,
    ProxyApiTestEnum? nullableEnumParam,
    ProxyApiSuperClass? nullableProxyApiParam,
  }) : super.pigeon_detached() {
    final int pigeonVar_instanceIdentifier =
        pigeon_instanceManager.addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[
      pigeonVar_instanceIdentifier,
      aBool,
      anInt,
      aDouble,
      aString,
      aUint8List,
      aList,
      aMap,
      anEnum,
      aProxyApi,
      aNullableBool,
      aNullableInt,
      aNullableDouble,
      aNullableString,
      aNullableUint8List,
      aNullableList,
      aNullableMap,
      aNullableEnum,
      aNullableProxyApi,
      boolParam,
      intParam,
      doubleParam,
      stringParam,
      aUint8ListParam,
      listParam,
      mapParam,
      enumParam,
      proxyApiParam,
      nullableBoolParam,
      nullableIntParam,
      nullableDoubleParam,
      nullableStringParam,
      nullableUint8ListParam,
      nullableListParam,
      nullableMapParam,
      nullableEnumParam,
      nullableProxyApiParam
    ]);
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  factory ProxyApiTestClass.namedConstructor({
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    required bool aBool,
    required int anInt,
    required double aDouble,
    required String aString,
    required Uint8List aUint8List,
    required List<Object?> aList,
    required Map<String?, Object?> aMap,
    required ProxyApiTestEnum anEnum,
    required ProxyApiSuperClass aProxyApi,
    bool? aNullableBool,
    int? aNullableInt,
    double? aNullableDouble,
    String? aNullableString,
    Uint8List? aNullableUint8List,
    List<Object?>? aNullableList,
    Map<String?, Object?>? aNullableMap,
    ProxyApiTestEnum? aNullableEnum,
    ProxyApiSuperClass? aNullableProxyApi,
    void Function(ProxyApiInterface pigeon_instance)? anInterfaceMethod,
    void Function(ProxyApiTestClass pigeon_instance)? flutterNoop,
    Object? Function(ProxyApiTestClass pigeon_instance)? flutterThrowError,
    void Function(ProxyApiTestClass pigeon_instance)? flutterThrowErrorFromVoid,
    required bool Function(
      ProxyApiTestClass pigeon_instance,
      bool aBool,
    ) flutterEchoBool,
    required int Function(
      ProxyApiTestClass pigeon_instance,
      int anInt,
    ) flutterEchoInt,
    required double Function(
      ProxyApiTestClass pigeon_instance,
      double aDouble,
    ) flutterEchoDouble,
    required String Function(
      ProxyApiTestClass pigeon_instance,
      String aString,
    ) flutterEchoString,
    required Uint8List Function(
      ProxyApiTestClass pigeon_instance,
      Uint8List aList,
    ) flutterEchoUint8List,
    required List<Object?> Function(
      ProxyApiTestClass pigeon_instance,
      List<Object?> aList,
    ) flutterEchoList,
    required List<ProxyApiTestClass?> Function(
      ProxyApiTestClass pigeon_instance,
      List<ProxyApiTestClass?> aList,
    ) flutterEchoProxyApiList,
    required Map<String?, Object?> Function(
      ProxyApiTestClass pigeon_instance,
      Map<String?, Object?> aMap,
    ) flutterEchoMap,
    required Map<String?, ProxyApiTestClass?> Function(
      ProxyApiTestClass pigeon_instance,
      Map<String?, ProxyApiTestClass?> aMap,
    ) flutterEchoProxyApiMap,
    required ProxyApiTestEnum Function(
      ProxyApiTestClass pigeon_instance,
      ProxyApiTestEnum anEnum,
    ) flutterEchoEnum,
    required ProxyApiSuperClass Function(
      ProxyApiTestClass pigeon_instance,
      ProxyApiSuperClass aProxyApi,
    ) flutterEchoProxyApi,
    bool? Function(
      ProxyApiTestClass pigeon_instance,
      bool? aBool,
    )? flutterEchoNullableBool,
    int? Function(
      ProxyApiTestClass pigeon_instance,
      int? anInt,
    )? flutterEchoNullableInt,
    double? Function(
      ProxyApiTestClass pigeon_instance,
      double? aDouble,
    )? flutterEchoNullableDouble,
    String? Function(
      ProxyApiTestClass pigeon_instance,
      String? aString,
    )? flutterEchoNullableString,
    Uint8List? Function(
      ProxyApiTestClass pigeon_instance,
      Uint8List? aList,
    )? flutterEchoNullableUint8List,
    List<Object?>? Function(
      ProxyApiTestClass pigeon_instance,
      List<Object?>? aList,
    )? flutterEchoNullableList,
    Map<String?, Object?>? Function(
      ProxyApiTestClass pigeon_instance,
      Map<String?, Object?>? aMap,
    )? flutterEchoNullableMap,
    ProxyApiTestEnum? Function(
      ProxyApiTestClass pigeon_instance,
      ProxyApiTestEnum? anEnum,
    )? flutterEchoNullableEnum,
    ProxyApiSuperClass? Function(
      ProxyApiTestClass pigeon_instance,
      ProxyApiSuperClass? aProxyApi,
    )? flutterEchoNullableProxyApi,
    Future<void> Function(ProxyApiTestClass pigeon_instance)? flutterNoopAsync,
    required Future<String> Function(
      ProxyApiTestClass pigeon_instance,
      String aString,
    ) flutterEchoAsyncString,
  }) {
    if (PigeonOverrides.proxyApiTestClass_namedConstructor != null) {
      return PigeonOverrides.proxyApiTestClass_namedConstructor!(
        aBool: aBool,
        anInt: anInt,
        aDouble: aDouble,
        aString: aString,
        aUint8List: aUint8List,
        aList: aList,
        aMap: aMap,
        anEnum: anEnum,
        aProxyApi: aProxyApi,
        aNullableBool: aNullableBool,
        aNullableInt: aNullableInt,
        aNullableDouble: aNullableDouble,
        aNullableString: aNullableString,
        aNullableUint8List: aNullableUint8List,
        aNullableList: aNullableList,
        aNullableMap: aNullableMap,
        aNullableEnum: aNullableEnum,
        aNullableProxyApi: aNullableProxyApi,
        anInterfaceMethod: anInterfaceMethod,
        flutterNoop: flutterNoop,
        flutterThrowError: flutterThrowError,
        flutterThrowErrorFromVoid: flutterThrowErrorFromVoid,
        flutterEchoBool: flutterEchoBool,
        flutterEchoInt: flutterEchoInt,
        flutterEchoDouble: flutterEchoDouble,
        flutterEchoString: flutterEchoString,
        flutterEchoUint8List: flutterEchoUint8List,
        flutterEchoList: flutterEchoList,
        flutterEchoProxyApiList: flutterEchoProxyApiList,
        flutterEchoMap: flutterEchoMap,
        flutterEchoProxyApiMap: flutterEchoProxyApiMap,
        flutterEchoEnum: flutterEchoEnum,
        flutterEchoProxyApi: flutterEchoProxyApi,
        flutterEchoNullableBool: flutterEchoNullableBool,
        flutterEchoNullableInt: flutterEchoNullableInt,
        flutterEchoNullableDouble: flutterEchoNullableDouble,
        flutterEchoNullableString: flutterEchoNullableString,
        flutterEchoNullableUint8List: flutterEchoNullableUint8List,
        flutterEchoNullableList: flutterEchoNullableList,
        flutterEchoNullableMap: flutterEchoNullableMap,
        flutterEchoNullableEnum: flutterEchoNullableEnum,
        flutterEchoNullableProxyApi: flutterEchoNullableProxyApi,
        flutterNoopAsync: flutterNoopAsync,
        flutterEchoAsyncString: flutterEchoAsyncString,
      );
    }
    return ProxyApiTestClass.pigeon_namedConstructor(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      aBool: aBool,
      anInt: anInt,
      aDouble: aDouble,
      aString: aString,
      aUint8List: aUint8List,
      aList: aList,
      aMap: aMap,
      anEnum: anEnum,
      aProxyApi: aProxyApi,
      aNullableBool: aNullableBool,
      aNullableInt: aNullableInt,
      aNullableDouble: aNullableDouble,
      aNullableString: aNullableString,
      aNullableUint8List: aNullableUint8List,
      aNullableList: aNullableList,
      aNullableMap: aNullableMap,
      aNullableEnum: aNullableEnum,
      aNullableProxyApi: aNullableProxyApi,
      anInterfaceMethod: anInterfaceMethod,
      flutterNoop: flutterNoop,
      flutterThrowError: flutterThrowError,
      flutterThrowErrorFromVoid: flutterThrowErrorFromVoid,
      flutterEchoBool: flutterEchoBool,
      flutterEchoInt: flutterEchoInt,
      flutterEchoDouble: flutterEchoDouble,
      flutterEchoString: flutterEchoString,
      flutterEchoUint8List: flutterEchoUint8List,
      flutterEchoList: flutterEchoList,
      flutterEchoProxyApiList: flutterEchoProxyApiList,
      flutterEchoMap: flutterEchoMap,
      flutterEchoProxyApiMap: flutterEchoProxyApiMap,
      flutterEchoEnum: flutterEchoEnum,
      flutterEchoProxyApi: flutterEchoProxyApi,
      flutterEchoNullableBool: flutterEchoNullableBool,
      flutterEchoNullableInt: flutterEchoNullableInt,
      flutterEchoNullableDouble: flutterEchoNullableDouble,
      flutterEchoNullableString: flutterEchoNullableString,
      flutterEchoNullableUint8List: flutterEchoNullableUint8List,
      flutterEchoNullableList: flutterEchoNullableList,
      flutterEchoNullableMap: flutterEchoNullableMap,
      flutterEchoNullableEnum: flutterEchoNullableEnum,
      flutterEchoNullableProxyApi: flutterEchoNullableProxyApi,
      flutterNoopAsync: flutterNoopAsync,
      flutterEchoAsyncString: flutterEchoAsyncString,
    );
  }

  @protected
  ProxyApiTestClass.pigeon_namedConstructor({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.aBool,
    required this.anInt,
    required this.aDouble,
    required this.aString,
    required this.aUint8List,
    required this.aList,
    required this.aMap,
    required this.anEnum,
    required this.aProxyApi,
    this.aNullableBool,
    this.aNullableInt,
    this.aNullableDouble,
    this.aNullableString,
    this.aNullableUint8List,
    this.aNullableList,
    this.aNullableMap,
    this.aNullableEnum,
    this.aNullableProxyApi,
    this.anInterfaceMethod,
    this.flutterNoop,
    this.flutterThrowError,
    this.flutterThrowErrorFromVoid,
    required this.flutterEchoBool,
    required this.flutterEchoInt,
    required this.flutterEchoDouble,
    required this.flutterEchoString,
    required this.flutterEchoUint8List,
    required this.flutterEchoList,
    required this.flutterEchoProxyApiList,
    required this.flutterEchoMap,
    required this.flutterEchoProxyApiMap,
    required this.flutterEchoEnum,
    required this.flutterEchoProxyApi,
    this.flutterEchoNullableBool,
    this.flutterEchoNullableInt,
    this.flutterEchoNullableDouble,
    this.flutterEchoNullableString,
    this.flutterEchoNullableUint8List,
    this.flutterEchoNullableList,
    this.flutterEchoNullableMap,
    this.flutterEchoNullableEnum,
    this.flutterEchoNullableProxyApi,
    this.flutterNoopAsync,
    required this.flutterEchoAsyncString,
  }) : super.pigeon_detached() {
    final int pigeonVar_instanceIdentifier =
        pigeon_instanceManager.addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.namedConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[
      pigeonVar_instanceIdentifier,
      aBool,
      anInt,
      aDouble,
      aString,
      aUint8List,
      aList,
      aMap,
      anEnum,
      aProxyApi,
      aNullableBool,
      aNullableInt,
      aNullableDouble,
      aNullableString,
      aNullableUint8List,
      aNullableList,
      aNullableMap,
      aNullableEnum,
      aNullableProxyApi
    ]);
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [ProxyApiTestClass] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  ProxyApiTestClass.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.aBool,
    required this.anInt,
    required this.aDouble,
    required this.aString,
    required this.aUint8List,
    required this.aList,
    required this.aMap,
    required this.anEnum,
    required this.aProxyApi,
    this.aNullableBool,
    this.aNullableInt,
    this.aNullableDouble,
    this.aNullableString,
    this.aNullableUint8List,
    this.aNullableList,
    this.aNullableMap,
    this.aNullableEnum,
    this.aNullableProxyApi,
    this.anInterfaceMethod,
    this.flutterNoop,
    this.flutterThrowError,
    this.flutterThrowErrorFromVoid,
    required this.flutterEchoBool,
    required this.flutterEchoInt,
    required this.flutterEchoDouble,
    required this.flutterEchoString,
    required this.flutterEchoUint8List,
    required this.flutterEchoList,
    required this.flutterEchoProxyApiList,
    required this.flutterEchoMap,
    required this.flutterEchoProxyApiMap,
    required this.flutterEchoEnum,
    required this.flutterEchoProxyApi,
    this.flutterEchoNullableBool,
    this.flutterEchoNullableInt,
    this.flutterEchoNullableDouble,
    this.flutterEchoNullableString,
    this.flutterEchoNullableUint8List,
    this.flutterEchoNullableList,
    this.flutterEchoNullableMap,
    this.flutterEchoNullableEnum,
    this.flutterEchoNullableProxyApi,
    this.flutterNoopAsync,
    required this.flutterEchoAsyncString,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec
      _pigeonVar_codecProxyApiTestClass =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  final bool aBool;

  final int anInt;

  final double aDouble;

  final String aString;

  final Uint8List aUint8List;

  final List<Object?> aList;

  final Map<String?, Object?> aMap;

  final ProxyApiTestEnum anEnum;

  final ProxyApiSuperClass aProxyApi;

  final bool? aNullableBool;

  final int? aNullableInt;

  final double? aNullableDouble;

  final String? aNullableString;

  final Uint8List? aNullableUint8List;

  final List<Object?>? aNullableList;

  final Map<String?, Object?>? aNullableMap;

  final ProxyApiTestEnum? aNullableEnum;

  final ProxyApiSuperClass? aNullableProxyApi;

  /// A no-op function taking no arguments and returning no value, to sanity
  /// test basic calling.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterNoop: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final void Function(ProxyApiTestClass pigeon_instance)? flutterNoop;

  /// Responds with an error from an async function returning a value.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterThrowError: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final Object? Function(ProxyApiTestClass pigeon_instance)? flutterThrowError;

  /// Responds with an error from an async void function.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterThrowErrorFromVoid: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final void Function(ProxyApiTestClass pigeon_instance)?
      flutterThrowErrorFromVoid;

  /// Returns the passed boolean, to test serialization and deserialization.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterEchoBool: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final bool Function(
    ProxyApiTestClass pigeon_instance,
    bool aBool,
  ) flutterEchoBool;

  /// Returns the passed int, to test serialization and deserialization.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterEchoInt: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final int Function(
    ProxyApiTestClass pigeon_instance,
    int anInt,
  ) flutterEchoInt;

  /// Returns the passed double, to test serialization and deserialization.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterEchoDouble: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final double Function(
    ProxyApiTestClass pigeon_instance,
    double aDouble,
  ) flutterEchoDouble;

  /// Returns the passed string, to test serialization and deserialization.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterEchoString: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final String Function(
    ProxyApiTestClass pigeon_instance,
    String aString,
  ) flutterEchoString;

  /// Returns the passed byte list, to test serialization and deserialization.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterEchoUint8List: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final Uint8List Function(
    ProxyApiTestClass pigeon_instance,
    Uint8List aList,
  ) flutterEchoUint8List;

  /// Returns the passed list, to test serialization and deserialization.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterEchoList: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final List<Object?> Function(
    ProxyApiTestClass pigeon_instance,
    List<Object?> aList,
  ) flutterEchoList;

  /// Returns the passed list with ProxyApis, to test serialization and
  /// deserialization.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterEchoProxyApiList: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final List<ProxyApiTestClass?> Function(
    ProxyApiTestClass pigeon_instance,
    List<ProxyApiTestClass?> aList,
  ) flutterEchoProxyApiList;

  /// Returns the passed map, to test serialization and deserialization.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterEchoMap: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final Map<String?, Object?> Function(
    ProxyApiTestClass pigeon_instance,
    Map<String?, Object?> aMap,
  ) flutterEchoMap;

  /// Returns the passed map with ProxyApis, to test serialization and
  /// deserialization.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterEchoProxyApiMap: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final Map<String?, ProxyApiTestClass?> Function(
    ProxyApiTestClass pigeon_instance,
    Map<String?, ProxyApiTestClass?> aMap,
  ) flutterEchoProxyApiMap;

  /// Returns the passed enum to test serialization and deserialization.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterEchoEnum: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final ProxyApiTestEnum Function(
    ProxyApiTestClass pigeon_instance,
    ProxyApiTestEnum anEnum,
  ) flutterEchoEnum;

  /// Returns the passed ProxyApi to test serialization and deserialization.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterEchoProxyApi: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final ProxyApiSuperClass Function(
    ProxyApiTestClass pigeon_instance,
    ProxyApiSuperClass aProxyApi,
  ) flutterEchoProxyApi;

  /// Returns the passed boolean, to test serialization and deserialization.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterEchoNullableBool: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final bool? Function(
    ProxyApiTestClass pigeon_instance,
    bool? aBool,
  )? flutterEchoNullableBool;

  /// Returns the passed int, to test serialization and deserialization.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterEchoNullableInt: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final int? Function(
    ProxyApiTestClass pigeon_instance,
    int? anInt,
  )? flutterEchoNullableInt;

  /// Returns the passed double, to test serialization and deserialization.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterEchoNullableDouble: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final double? Function(
    ProxyApiTestClass pigeon_instance,
    double? aDouble,
  )? flutterEchoNullableDouble;

  /// Returns the passed string, to test serialization and deserialization.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterEchoNullableString: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final String? Function(
    ProxyApiTestClass pigeon_instance,
    String? aString,
  )? flutterEchoNullableString;

  /// Returns the passed byte list, to test serialization and deserialization.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterEchoNullableUint8List: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final Uint8List? Function(
    ProxyApiTestClass pigeon_instance,
    Uint8List? aList,
  )? flutterEchoNullableUint8List;

  /// Returns the passed list, to test serialization and deserialization.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterEchoNullableList: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final List<Object?>? Function(
    ProxyApiTestClass pigeon_instance,
    List<Object?>? aList,
  )? flutterEchoNullableList;

  /// Returns the passed map, to test serialization and deserialization.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterEchoNullableMap: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final Map<String?, Object?>? Function(
    ProxyApiTestClass pigeon_instance,
    Map<String?, Object?>? aMap,
  )? flutterEchoNullableMap;

  /// Returns the passed enum to test serialization and deserialization.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterEchoNullableEnum: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final ProxyApiTestEnum? Function(
    ProxyApiTestClass pigeon_instance,
    ProxyApiTestEnum? anEnum,
  )? flutterEchoNullableEnum;

  /// Returns the passed ProxyApi to test serialization and deserialization.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterEchoNullableProxyApi: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final ProxyApiSuperClass? Function(
    ProxyApiTestClass pigeon_instance,
    ProxyApiSuperClass? aProxyApi,
  )? flutterEchoNullableProxyApi;

  /// A no-op function taking no arguments and returning no value, to sanity
  /// test basic asynchronous calling.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterNoopAsync: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final Future<void> Function(ProxyApiTestClass pigeon_instance)?
      flutterNoopAsync;

  /// Returns the passed in generic Object asynchronously.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiTestClass instance = ProxyApiTestClass(
  ///  flutterEchoAsyncString: (ProxyApiTestClass pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final Future<String> Function(
    ProxyApiTestClass pigeon_instance,
    String aString,
  ) flutterEchoAsyncString;

  @override
  final void Function(ProxyApiInterface pigeon_instance)? anInterfaceMethod;

  late final ProxyApiSuperClass attachedField = pigeonVar_attachedField();

  static final ProxyApiSuperClass _staticAttachedField =
      pigeonVar_staticAttachedField();

  static ProxyApiSuperClass get staticAttachedField =>
      PigeonOverrides.proxyApiTestClass_staticAttachedField ??
      _staticAttachedField;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    void Function(ProxyApiTestClass pigeon_instance)? flutterNoop,
    Object? Function(ProxyApiTestClass pigeon_instance)? flutterThrowError,
    void Function(ProxyApiTestClass pigeon_instance)? flutterThrowErrorFromVoid,
    bool Function(
      ProxyApiTestClass pigeon_instance,
      bool aBool,
    )? flutterEchoBool,
    int Function(
      ProxyApiTestClass pigeon_instance,
      int anInt,
    )? flutterEchoInt,
    double Function(
      ProxyApiTestClass pigeon_instance,
      double aDouble,
    )? flutterEchoDouble,
    String Function(
      ProxyApiTestClass pigeon_instance,
      String aString,
    )? flutterEchoString,
    Uint8List Function(
      ProxyApiTestClass pigeon_instance,
      Uint8List aList,
    )? flutterEchoUint8List,
    List<Object?> Function(
      ProxyApiTestClass pigeon_instance,
      List<Object?> aList,
    )? flutterEchoList,
    List<ProxyApiTestClass?> Function(
      ProxyApiTestClass pigeon_instance,
      List<ProxyApiTestClass?> aList,
    )? flutterEchoProxyApiList,
    Map<String?, Object?> Function(
      ProxyApiTestClass pigeon_instance,
      Map<String?, Object?> aMap,
    )? flutterEchoMap,
    Map<String?, ProxyApiTestClass?> Function(
      ProxyApiTestClass pigeon_instance,
      Map<String?, ProxyApiTestClass?> aMap,
    )? flutterEchoProxyApiMap,
    ProxyApiTestEnum Function(
      ProxyApiTestClass pigeon_instance,
      ProxyApiTestEnum anEnum,
    )? flutterEchoEnum,
    ProxyApiSuperClass Function(
      ProxyApiTestClass pigeon_instance,
      ProxyApiSuperClass aProxyApi,
    )? flutterEchoProxyApi,
    bool? Function(
      ProxyApiTestClass pigeon_instance,
      bool? aBool,
    )? flutterEchoNullableBool,
    int? Function(
      ProxyApiTestClass pigeon_instance,
      int? anInt,
    )? flutterEchoNullableInt,
    double? Function(
      ProxyApiTestClass pigeon_instance,
      double? aDouble,
    )? flutterEchoNullableDouble,
    String? Function(
      ProxyApiTestClass pigeon_instance,
      String? aString,
    )? flutterEchoNullableString,
    Uint8List? Function(
      ProxyApiTestClass pigeon_instance,
      Uint8List? aList,
    )? flutterEchoNullableUint8List,
    List<Object?>? Function(
      ProxyApiTestClass pigeon_instance,
      List<Object?>? aList,
    )? flutterEchoNullableList,
    Map<String?, Object?>? Function(
      ProxyApiTestClass pigeon_instance,
      Map<String?, Object?>? aMap,
    )? flutterEchoNullableMap,
    ProxyApiTestEnum? Function(
      ProxyApiTestClass pigeon_instance,
      ProxyApiTestEnum? anEnum,
    )? flutterEchoNullableEnum,
    ProxyApiSuperClass? Function(
      ProxyApiTestClass pigeon_instance,
      ProxyApiSuperClass? aProxyApi,
    )? flutterEchoNullableProxyApi,
    Future<void> Function(ProxyApiTestClass pigeon_instance)? flutterNoopAsync,
    Future<String> Function(
      ProxyApiTestClass pigeon_instance,
      String aString,
    )? flutterEchoAsyncString,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
            pigeon_instanceManager ?? PigeonInstanceManager.instance);
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterNoop',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterNoop was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterNoop was null, expected non-null ProxyApiTestClass.');
          try {
            (flutterNoop ?? arg_pigeon_instance!.flutterNoop)
                ?.call(arg_pigeon_instance!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterThrowError',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterThrowError was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterThrowError was null, expected non-null ProxyApiTestClass.');
          try {
            final Object? output =
                (flutterThrowError ?? arg_pigeon_instance!.flutterThrowError)
                    ?.call(arg_pigeon_instance!);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterThrowErrorFromVoid',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterThrowErrorFromVoid was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterThrowErrorFromVoid was null, expected non-null ProxyApiTestClass.');
          try {
            (flutterThrowErrorFromVoid ??
                    arg_pigeon_instance!.flutterThrowErrorFromVoid)
                ?.call(arg_pigeon_instance!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoBool',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoBool was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoBool was null, expected non-null ProxyApiTestClass.');
          final bool? arg_aBool = (args[1] as bool?);
          assert(arg_aBool != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoBool was null, expected non-null bool.');
          try {
            final bool output =
                (flutterEchoBool ?? arg_pigeon_instance!.flutterEchoBool)
                    .call(arg_pigeon_instance!, arg_aBool!);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoInt',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoInt was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoInt was null, expected non-null ProxyApiTestClass.');
          final int? arg_anInt = (args[1] as int?);
          assert(arg_anInt != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoInt was null, expected non-null int.');
          try {
            final int output =
                (flutterEchoInt ?? arg_pigeon_instance!.flutterEchoInt)
                    .call(arg_pigeon_instance!, arg_anInt!);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoDouble',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoDouble was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoDouble was null, expected non-null ProxyApiTestClass.');
          final double? arg_aDouble = (args[1] as double?);
          assert(arg_aDouble != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoDouble was null, expected non-null double.');
          try {
            final double output =
                (flutterEchoDouble ?? arg_pigeon_instance!.flutterEchoDouble)
                    .call(arg_pigeon_instance!, arg_aDouble!);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoString',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoString was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoString was null, expected non-null ProxyApiTestClass.');
          final String? arg_aString = (args[1] as String?);
          assert(arg_aString != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoString was null, expected non-null String.');
          try {
            final String output =
                (flutterEchoString ?? arg_pigeon_instance!.flutterEchoString)
                    .call(arg_pigeon_instance!, arg_aString!);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoUint8List',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoUint8List was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoUint8List was null, expected non-null ProxyApiTestClass.');
          final Uint8List? arg_aList = (args[1] as Uint8List?);
          assert(arg_aList != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoUint8List was null, expected non-null Uint8List.');
          try {
            final Uint8List output = (flutterEchoUint8List ??
                    arg_pigeon_instance!.flutterEchoUint8List)
                .call(arg_pigeon_instance!, arg_aList!);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoList',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoList was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoList was null, expected non-null ProxyApiTestClass.');
          final List<Object?>? arg_aList =
              (args[1] as List<Object?>?)?.cast<Object?>();
          assert(arg_aList != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoList was null, expected non-null List<Object?>.');
          try {
            final List<Object?> output =
                (flutterEchoList ?? arg_pigeon_instance!.flutterEchoList)
                    .call(arg_pigeon_instance!, arg_aList!);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoProxyApiList',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoProxyApiList was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoProxyApiList was null, expected non-null ProxyApiTestClass.');
          final List<ProxyApiTestClass?>? arg_aList =
              (args[1] as List<Object?>?)?.cast<ProxyApiTestClass?>();
          assert(arg_aList != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoProxyApiList was null, expected non-null List<ProxyApiTestClass?>.');
          try {
            final List<ProxyApiTestClass?> output = (flutterEchoProxyApiList ??
                    arg_pigeon_instance!.flutterEchoProxyApiList)
                .call(arg_pigeon_instance!, arg_aList!);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoMap',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoMap was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoMap was null, expected non-null ProxyApiTestClass.');
          final Map<String?, Object?>? arg_aMap =
              (args[1] as Map<Object?, Object?>?)?.cast<String?, Object?>();
          assert(arg_aMap != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoMap was null, expected non-null Map<String?, Object?>.');
          try {
            final Map<String?, Object?> output =
                (flutterEchoMap ?? arg_pigeon_instance!.flutterEchoMap)
                    .call(arg_pigeon_instance!, arg_aMap!);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoProxyApiMap',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoProxyApiMap was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoProxyApiMap was null, expected non-null ProxyApiTestClass.');
          final Map<String?, ProxyApiTestClass?>? arg_aMap =
              (args[1] as Map<Object?, Object?>?)
                  ?.cast<String?, ProxyApiTestClass?>();
          assert(arg_aMap != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoProxyApiMap was null, expected non-null Map<String?, ProxyApiTestClass?>.');
          try {
            final Map<String?, ProxyApiTestClass?> output =
                (flutterEchoProxyApiMap ??
                        arg_pigeon_instance!.flutterEchoProxyApiMap)
                    .call(arg_pigeon_instance!, arg_aMap!);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoEnum',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoEnum was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoEnum was null, expected non-null ProxyApiTestClass.');
          final ProxyApiTestEnum? arg_anEnum = (args[1] as ProxyApiTestEnum?);
          assert(arg_anEnum != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoEnum was null, expected non-null ProxyApiTestEnum.');
          try {
            final ProxyApiTestEnum output =
                (flutterEchoEnum ?? arg_pigeon_instance!.flutterEchoEnum)
                    .call(arg_pigeon_instance!, arg_anEnum!);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoProxyApi',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoProxyApi was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoProxyApi was null, expected non-null ProxyApiTestClass.');
          final ProxyApiSuperClass? arg_aProxyApi =
              (args[1] as ProxyApiSuperClass?);
          assert(arg_aProxyApi != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoProxyApi was null, expected non-null ProxyApiSuperClass.');
          try {
            final ProxyApiSuperClass output = (flutterEchoProxyApi ??
                    arg_pigeon_instance!.flutterEchoProxyApi)
                .call(arg_pigeon_instance!, arg_aProxyApi!);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableBool',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableBool was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableBool was null, expected non-null ProxyApiTestClass.');
          final bool? arg_aBool = (args[1] as bool?);
          try {
            final bool? output = (flutterEchoNullableBool ??
                    arg_pigeon_instance!.flutterEchoNullableBool)
                ?.call(arg_pigeon_instance!, arg_aBool);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableInt',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableInt was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableInt was null, expected non-null ProxyApiTestClass.');
          final int? arg_anInt = (args[1] as int?);
          try {
            final int? output = (flutterEchoNullableInt ??
                    arg_pigeon_instance!.flutterEchoNullableInt)
                ?.call(arg_pigeon_instance!, arg_anInt);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableDouble',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableDouble was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableDouble was null, expected non-null ProxyApiTestClass.');
          final double? arg_aDouble = (args[1] as double?);
          try {
            final double? output = (flutterEchoNullableDouble ??
                    arg_pigeon_instance!.flutterEchoNullableDouble)
                ?.call(arg_pigeon_instance!, arg_aDouble);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableString',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableString was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableString was null, expected non-null ProxyApiTestClass.');
          final String? arg_aString = (args[1] as String?);
          try {
            final String? output = (flutterEchoNullableString ??
                    arg_pigeon_instance!.flutterEchoNullableString)
                ?.call(arg_pigeon_instance!, arg_aString);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableUint8List',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableUint8List was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableUint8List was null, expected non-null ProxyApiTestClass.');
          final Uint8List? arg_aList = (args[1] as Uint8List?);
          try {
            final Uint8List? output = (flutterEchoNullableUint8List ??
                    arg_pigeon_instance!.flutterEchoNullableUint8List)
                ?.call(arg_pigeon_instance!, arg_aList);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableList',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableList was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableList was null, expected non-null ProxyApiTestClass.');
          final List<Object?>? arg_aList =
              (args[1] as List<Object?>?)?.cast<Object?>();
          try {
            final List<Object?>? output = (flutterEchoNullableList ??
                    arg_pigeon_instance!.flutterEchoNullableList)
                ?.call(arg_pigeon_instance!, arg_aList);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableMap',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableMap was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableMap was null, expected non-null ProxyApiTestClass.');
          final Map<String?, Object?>? arg_aMap =
              (args[1] as Map<Object?, Object?>?)?.cast<String?, Object?>();
          try {
            final Map<String?, Object?>? output = (flutterEchoNullableMap ??
                    arg_pigeon_instance!.flutterEchoNullableMap)
                ?.call(arg_pigeon_instance!, arg_aMap);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableEnum',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableEnum was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableEnum was null, expected non-null ProxyApiTestClass.');
          final ProxyApiTestEnum? arg_anEnum = (args[1] as ProxyApiTestEnum?);
          try {
            final ProxyApiTestEnum? output = (flutterEchoNullableEnum ??
                    arg_pigeon_instance!.flutterEchoNullableEnum)
                ?.call(arg_pigeon_instance!, arg_anEnum);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableProxyApi',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableProxyApi was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableProxyApi was null, expected non-null ProxyApiTestClass.');
          final ProxyApiSuperClass? arg_aProxyApi =
              (args[1] as ProxyApiSuperClass?);
          try {
            final ProxyApiSuperClass? output = (flutterEchoNullableProxyApi ??
                    arg_pigeon_instance!.flutterEchoNullableProxyApi)
                ?.call(arg_pigeon_instance!, arg_aProxyApi);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterNoopAsync',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterNoopAsync was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterNoopAsync was null, expected non-null ProxyApiTestClass.');
          try {
            await (flutterNoopAsync ?? arg_pigeon_instance!.flutterNoopAsync)
                ?.call(arg_pigeon_instance!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoAsyncString',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoAsyncString was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiTestClass? arg_pigeon_instance =
              (args[0] as ProxyApiTestClass?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoAsyncString was null, expected non-null ProxyApiTestClass.');
          final String? arg_aString = (args[1] as String?);
          assert(arg_aString != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoAsyncString was null, expected non-null String.');
          try {
            final String output = await (flutterEchoAsyncString ??
                    arg_pigeon_instance!.flutterEchoAsyncString)
                .call(arg_pigeon_instance!, arg_aString!);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
  }

  ProxyApiSuperClass pigeonVar_attachedField() {
    final ProxyApiSuperClass pigeonVar_instance =
        ProxyApiSuperClass.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    final int pigeonVar_instanceIdentifier =
        pigeon_instanceManager.addDartCreatedInstance(pigeonVar_instance);
    () async {
      const String pigeonVar_channelName =
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.attachedField';
      final BasicMessageChannel<Object?> pigeonVar_channel =
          BasicMessageChannel<Object?>(
        pigeonVar_channelName,
        pigeonChannelCodec,
        binaryMessenger: pigeonVar_binaryMessenger,
      );
      final Future<Object?> pigeonVar_sendFuture =
          pigeonVar_channel.send(<Object?>[this, pigeonVar_instanceIdentifier]);
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
    return pigeonVar_instance;
  }

  static ProxyApiSuperClass pigeonVar_staticAttachedField() {
    final ProxyApiSuperClass pigeonVar_instance =
        ProxyApiSuperClass.pigeon_detached();
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(PigeonInstanceManager.instance);
    final BinaryMessenger pigeonVar_binaryMessenger =
        ServicesBinding.instance.defaultBinaryMessenger;
    final int pigeonVar_instanceIdentifier = PigeonInstanceManager.instance
        .addDartCreatedInstance(pigeonVar_instance);
    () async {
      const String pigeonVar_channelName =
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.staticAttachedField';
      final BasicMessageChannel<Object?> pigeonVar_channel =
          BasicMessageChannel<Object?>(
        pigeonVar_channelName,
        pigeonChannelCodec,
        binaryMessenger: pigeonVar_binaryMessenger,
      );
      final Future<Object?> pigeonVar_sendFuture =
          pigeonVar_channel.send(<Object?>[pigeonVar_instanceIdentifier]);
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
    return pigeonVar_instance;
  }

  /// A no-op function taking no arguments and returning no value, to sanity
  /// test basic calling.
  Future<void> noop() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.noop';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Returns an error, to test error handling.
  Future<Object?> throwError() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.throwError';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return pigeonVar_replyList[0];
    }
  }

  /// Returns an error from a void function, to test error handling.
  Future<void> throwErrorFromVoid() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.throwErrorFromVoid';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Returns a Flutter error, to test error handling.
  Future<Object?> throwFlutterError() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.throwFlutterError';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return pigeonVar_replyList[0];
    }
  }

  /// Returns passed in int.
  Future<int> echoInt(int anInt) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoInt';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, anInt]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as int?)!;
    }
  }

  /// Returns passed in double.
  Future<double> echoDouble(double aDouble) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoDouble';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aDouble]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as double?)!;
    }
  }

  /// Returns the passed in boolean.
  Future<bool> echoBool(bool aBool) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoBool';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aBool]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as bool?)!;
    }
  }

  /// Returns the passed in string.
  Future<String> echoString(String aString) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoString';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aString]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as String?)!;
    }
  }

  /// Returns the passed in Uint8List.
  Future<Uint8List> echoUint8List(Uint8List aUint8List) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoUint8List';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aUint8List]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as Uint8List?)!;
    }
  }

  /// Returns the passed in generic Object.
  Future<Object> echoObject(Object anObject) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoObject';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, anObject]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return pigeonVar_replyList[0]!;
    }
  }

  /// Returns the passed list, to test serialization and deserialization.
  Future<List<Object?>> echoList(List<Object?> aList) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoList';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aList]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!.cast<Object?>();
    }
  }

  /// Returns the passed list with ProxyApis, to test serialization and
  /// deserialization.
  Future<List<ProxyApiTestClass>> echoProxyApiList(
      List<ProxyApiTestClass> aList) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoProxyApiList';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aList]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!
          .cast<ProxyApiTestClass>();
    }
  }

  /// Returns the passed map, to test serialization and deserialization.
  Future<Map<String?, Object?>> echoMap(Map<String?, Object?> aMap) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoMap';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aMap]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as Map<Object?, Object?>?)!
          .cast<String?, Object?>();
    }
  }

  /// Returns the passed map with ProxyApis, to test serialization and
  /// deserialization.
  Future<Map<String, ProxyApiTestClass>> echoProxyApiMap(
      Map<String, ProxyApiTestClass> aMap) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoProxyApiMap';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aMap]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as Map<Object?, Object?>?)!
          .cast<String, ProxyApiTestClass>();
    }
  }

  /// Returns the passed enum to test serialization and deserialization.
  Future<ProxyApiTestEnum> echoEnum(ProxyApiTestEnum anEnum) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoEnum';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, anEnum]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as ProxyApiTestEnum?)!;
    }
  }

  /// Returns the passed ProxyApi to test serialization and deserialization.
  Future<ProxyApiSuperClass> echoProxyApi(ProxyApiSuperClass aProxyApi) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoProxyApi';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aProxyApi]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as ProxyApiSuperClass?)!;
    }
  }

  /// Returns passed in int.
  Future<int?> echoNullableInt(int? aNullableInt) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableInt';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aNullableInt]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as int?);
    }
  }

  /// Returns passed in double.
  Future<double?> echoNullableDouble(double? aNullableDouble) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableDouble';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aNullableDouble]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as double?);
    }
  }

  /// Returns the passed in boolean.
  Future<bool?> echoNullableBool(bool? aNullableBool) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableBool';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aNullableBool]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as bool?);
    }
  }

  /// Returns the passed in string.
  Future<String?> echoNullableString(String? aNullableString) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableString';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aNullableString]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as String?);
    }
  }

  /// Returns the passed in Uint8List.
  Future<Uint8List?> echoNullableUint8List(
      Uint8List? aNullableUint8List) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableUint8List';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aNullableUint8List]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as Uint8List?);
    }
  }

  /// Returns the passed in generic Object.
  Future<Object?> echoNullableObject(Object? aNullableObject) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableObject';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aNullableObject]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return pigeonVar_replyList[0];
    }
  }

  /// Returns the passed list, to test serialization and deserialization.
  Future<List<Object?>?> echoNullableList(List<Object?>? aNullableList) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableList';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aNullableList]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)?.cast<Object?>();
    }
  }

  /// Returns the passed map, to test serialization and deserialization.
  Future<Map<String?, Object?>?> echoNullableMap(
      Map<String?, Object?>? aNullableMap) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableMap';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aNullableMap]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as Map<Object?, Object?>?)
          ?.cast<String?, Object?>();
    }
  }

  Future<ProxyApiTestEnum?> echoNullableEnum(
      ProxyApiTestEnum? aNullableEnum) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableEnum';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aNullableEnum]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as ProxyApiTestEnum?);
    }
  }

  /// Returns the passed ProxyApi to test serialization and deserialization.
  Future<ProxyApiSuperClass?> echoNullableProxyApi(
      ProxyApiSuperClass? aNullableProxyApi) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableProxyApi';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aNullableProxyApi]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as ProxyApiSuperClass?);
    }
  }

  /// A no-op function taking no arguments and returning no value, to sanity
  /// test basic asynchronous calling.
  Future<void> noopAsync() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.noopAsync';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Returns passed in int asynchronously.
  Future<int> echoAsyncInt(int anInt) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncInt';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, anInt]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as int?)!;
    }
  }

  /// Returns passed in double asynchronously.
  Future<double> echoAsyncDouble(double aDouble) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncDouble';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aDouble]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as double?)!;
    }
  }

  /// Returns the passed in boolean asynchronously.
  Future<bool> echoAsyncBool(bool aBool) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncBool';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aBool]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as bool?)!;
    }
  }

  /// Returns the passed string asynchronously.
  Future<String> echoAsyncString(String aString) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncString';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aString]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as String?)!;
    }
  }

  /// Returns the passed in Uint8List asynchronously.
  Future<Uint8List> echoAsyncUint8List(Uint8List aUint8List) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncUint8List';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aUint8List]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as Uint8List?)!;
    }
  }

  /// Returns the passed in generic Object asynchronously.
  Future<Object> echoAsyncObject(Object anObject) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncObject';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, anObject]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return pigeonVar_replyList[0]!;
    }
  }

  /// Returns the passed list, to test asynchronous serialization and deserialization.
  Future<List<Object?>> echoAsyncList(List<Object?> aList) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncList';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aList]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!.cast<Object?>();
    }
  }

  /// Returns the passed map, to test asynchronous serialization and deserialization.
  Future<Map<String?, Object?>> echoAsyncMap(Map<String?, Object?> aMap) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncMap';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aMap]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as Map<Object?, Object?>?)!
          .cast<String?, Object?>();
    }
  }

  /// Returns the passed enum, to test asynchronous serialization and deserialization.
  Future<ProxyApiTestEnum> echoAsyncEnum(ProxyApiTestEnum anEnum) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncEnum';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, anEnum]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as ProxyApiTestEnum?)!;
    }
  }

  /// Responds with an error from an async function returning a value.
  Future<Object?> throwAsyncError() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.throwAsyncError';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return pigeonVar_replyList[0];
    }
  }

  /// Responds with an error from an async void function.
  Future<void> throwAsyncErrorFromVoid() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.throwAsyncErrorFromVoid';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Responds with a Flutter error from an async function returning a value.
  Future<Object?> throwAsyncFlutterError() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.throwAsyncFlutterError';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return pigeonVar_replyList[0];
    }
  }

  /// Returns passed in int asynchronously.
  Future<int?> echoAsyncNullableInt(int? anInt) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableInt';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, anInt]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as int?);
    }
  }

  /// Returns passed in double asynchronously.
  Future<double?> echoAsyncNullableDouble(double? aDouble) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableDouble';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aDouble]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as double?);
    }
  }

  /// Returns the passed in boolean asynchronously.
  Future<bool?> echoAsyncNullableBool(bool? aBool) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableBool';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aBool]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as bool?);
    }
  }

  /// Returns the passed string asynchronously.
  Future<String?> echoAsyncNullableString(String? aString) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableString';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aString]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as String?);
    }
  }

  /// Returns the passed in Uint8List asynchronously.
  Future<Uint8List?> echoAsyncNullableUint8List(Uint8List? aUint8List) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableUint8List';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aUint8List]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as Uint8List?);
    }
  }

  /// Returns the passed in generic Object asynchronously.
  Future<Object?> echoAsyncNullableObject(Object? anObject) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableObject';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, anObject]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return pigeonVar_replyList[0];
    }
  }

  /// Returns the passed list, to test asynchronous serialization and deserialization.
  Future<List<Object?>?> echoAsyncNullableList(List<Object?>? aList) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableList';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aList]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)?.cast<Object?>();
    }
  }

  /// Returns the passed map, to test asynchronous serialization and deserialization.
  Future<Map<String?, Object?>?> echoAsyncNullableMap(
      Map<String?, Object?>? aMap) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableMap';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aMap]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as Map<Object?, Object?>?)
          ?.cast<String?, Object?>();
    }
  }

  /// Returns the passed enum, to test asynchronous serialization and deserialization.
  Future<ProxyApiTestEnum?> echoAsyncNullableEnum(
      ProxyApiTestEnum? anEnum) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableEnum';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, anEnum]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as ProxyApiTestEnum?);
    }
  }

  static Future<void> staticNoop({
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
  }) async {
    if (PigeonOverrides.proxyApiTestClass_staticNoop != null) {
      return PigeonOverrides.proxyApiTestClass_staticNoop!();
    }
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
            pigeon_instanceManager ?? PigeonInstanceManager.instance);
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.staticNoop';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  static Future<String> echoStaticString(
    String aString, {
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
  }) async {
    if (PigeonOverrides.proxyApiTestClass_echoStaticString != null) {
      return PigeonOverrides.proxyApiTestClass_echoStaticString!(aString);
    }
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
            pigeon_instanceManager ?? PigeonInstanceManager.instance);
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoStaticString';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[aString]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as String?)!;
    }
  }

  static Future<void> staticAsyncNoop({
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
  }) async {
    if (PigeonOverrides.proxyApiTestClass_staticAsyncNoop != null) {
      return PigeonOverrides.proxyApiTestClass_staticAsyncNoop!();
    }
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
            pigeon_instanceManager ?? PigeonInstanceManager.instance);
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.staticAsyncNoop';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> callFlutterNoop() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterNoop';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<Object?> callFlutterThrowError() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterThrowError';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return pigeonVar_replyList[0];
    }
  }

  Future<void> callFlutterThrowErrorFromVoid() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterThrowErrorFromVoid';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<bool> callFlutterEchoBool(bool aBool) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoBool';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aBool]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as bool?)!;
    }
  }

  Future<int> callFlutterEchoInt(int anInt) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoInt';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, anInt]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as int?)!;
    }
  }

  Future<double> callFlutterEchoDouble(double aDouble) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoDouble';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aDouble]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as double?)!;
    }
  }

  Future<String> callFlutterEchoString(String aString) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoString';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aString]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as String?)!;
    }
  }

  Future<Uint8List> callFlutterEchoUint8List(Uint8List aUint8List) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoUint8List';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aUint8List]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as Uint8List?)!;
    }
  }

  Future<List<Object?>> callFlutterEchoList(List<Object?> aList) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoList';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aList]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!.cast<Object?>();
    }
  }

  Future<List<ProxyApiTestClass?>> callFlutterEchoProxyApiList(
      List<ProxyApiTestClass?> aList) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoProxyApiList';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aList]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!
          .cast<ProxyApiTestClass?>();
    }
  }

  Future<Map<String?, Object?>> callFlutterEchoMap(
      Map<String?, Object?> aMap) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoMap';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aMap]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as Map<Object?, Object?>?)!
          .cast<String?, Object?>();
    }
  }

  Future<Map<String?, ProxyApiTestClass?>> callFlutterEchoProxyApiMap(
      Map<String?, ProxyApiTestClass?> aMap) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoProxyApiMap';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aMap]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as Map<Object?, Object?>?)!
          .cast<String?, ProxyApiTestClass?>();
    }
  }

  Future<ProxyApiTestEnum> callFlutterEchoEnum(ProxyApiTestEnum anEnum) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoEnum';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, anEnum]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as ProxyApiTestEnum?)!;
    }
  }

  Future<ProxyApiSuperClass> callFlutterEchoProxyApi(
      ProxyApiSuperClass aProxyApi) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoProxyApi';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aProxyApi]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as ProxyApiSuperClass?)!;
    }
  }

  Future<bool?> callFlutterEchoNullableBool(bool? aBool) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableBool';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aBool]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as bool?);
    }
  }

  Future<int?> callFlutterEchoNullableInt(int? anInt) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableInt';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, anInt]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as int?);
    }
  }

  Future<double?> callFlutterEchoNullableDouble(double? aDouble) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableDouble';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aDouble]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as double?);
    }
  }

  Future<String?> callFlutterEchoNullableString(String? aString) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableString';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aString]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as String?);
    }
  }

  Future<Uint8List?> callFlutterEchoNullableUint8List(
      Uint8List? aUint8List) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableUint8List';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aUint8List]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as Uint8List?);
    }
  }

  Future<List<Object?>?> callFlutterEchoNullableList(
      List<Object?>? aList) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableList';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aList]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)?.cast<Object?>();
    }
  }

  Future<Map<String?, Object?>?> callFlutterEchoNullableMap(
      Map<String?, Object?>? aMap) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableMap';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aMap]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as Map<Object?, Object?>?)
          ?.cast<String?, Object?>();
    }
  }

  Future<ProxyApiTestEnum?> callFlutterEchoNullableEnum(
      ProxyApiTestEnum? anEnum) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableEnum';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, anEnum]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as ProxyApiTestEnum?);
    }
  }

  Future<ProxyApiSuperClass?> callFlutterEchoNullableProxyApi(
      ProxyApiSuperClass? aProxyApi) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableProxyApi';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aProxyApi]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as ProxyApiSuperClass?);
    }
  }

  Future<void> callFlutterNoopAsync() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterNoopAsync';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<String> callFlutterEchoAsyncString(String aString) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiTestClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoAsyncString';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this, aString]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as String?)!;
    }
  }

  @override
  ProxyApiTestClass pigeon_copy() {
    return ProxyApiTestClass.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      aBool: aBool,
      anInt: anInt,
      aDouble: aDouble,
      aString: aString,
      aUint8List: aUint8List,
      aList: aList,
      aMap: aMap,
      anEnum: anEnum,
      aProxyApi: aProxyApi,
      aNullableBool: aNullableBool,
      aNullableInt: aNullableInt,
      aNullableDouble: aNullableDouble,
      aNullableString: aNullableString,
      aNullableUint8List: aNullableUint8List,
      aNullableList: aNullableList,
      aNullableMap: aNullableMap,
      aNullableEnum: aNullableEnum,
      aNullableProxyApi: aNullableProxyApi,
      anInterfaceMethod: anInterfaceMethod,
      flutterNoop: flutterNoop,
      flutterThrowError: flutterThrowError,
      flutterThrowErrorFromVoid: flutterThrowErrorFromVoid,
      flutterEchoBool: flutterEchoBool,
      flutterEchoInt: flutterEchoInt,
      flutterEchoDouble: flutterEchoDouble,
      flutterEchoString: flutterEchoString,
      flutterEchoUint8List: flutterEchoUint8List,
      flutterEchoList: flutterEchoList,
      flutterEchoProxyApiList: flutterEchoProxyApiList,
      flutterEchoMap: flutterEchoMap,
      flutterEchoProxyApiMap: flutterEchoProxyApiMap,
      flutterEchoEnum: flutterEchoEnum,
      flutterEchoProxyApi: flutterEchoProxyApi,
      flutterEchoNullableBool: flutterEchoNullableBool,
      flutterEchoNullableInt: flutterEchoNullableInt,
      flutterEchoNullableDouble: flutterEchoNullableDouble,
      flutterEchoNullableString: flutterEchoNullableString,
      flutterEchoNullableUint8List: flutterEchoNullableUint8List,
      flutterEchoNullableList: flutterEchoNullableList,
      flutterEchoNullableMap: flutterEchoNullableMap,
      flutterEchoNullableEnum: flutterEchoNullableEnum,
      flutterEchoNullableProxyApi: flutterEchoNullableProxyApi,
      flutterNoopAsync: flutterNoopAsync,
      flutterEchoAsyncString: flutterEchoAsyncString,
    );
  }
}

/// ProxyApi to serve as a super class to the core ProxyApi class.
class ProxyApiSuperClass extends PigeonInternalProxyApiBaseClass {
  factory ProxyApiSuperClass({
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
  }) {
    if (PigeonOverrides.proxyApiSuperClass_new != null) {
      return PigeonOverrides.proxyApiSuperClass_new!();
    }
    return ProxyApiSuperClass.pigeon_new(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }

  @protected
  ProxyApiSuperClass.pigeon_new({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  }) {
    final int pigeonVar_instanceIdentifier =
        pigeon_instanceManager.addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiSuperClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiSuperClass.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[pigeonVar_instanceIdentifier]);
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [ProxyApiSuperClass] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  ProxyApiSuperClass.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  late final _PigeonInternalProxyApiBaseCodec
      _pigeonVar_codecProxyApiSuperClass =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    ProxyApiSuperClass Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
            pigeon_instanceManager ?? PigeonInstanceManager.instance);
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiSuperClass.pigeon_newInstance',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiSuperClass.pigeon_newInstance was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(arg_pigeon_instanceIdentifier != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiSuperClass.pigeon_newInstance was null, expected non-null int.');
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
              pigeon_newInstance?.call() ??
                  ProxyApiSuperClass.pigeon_detached(
                    pigeon_binaryMessenger: pigeon_binaryMessenger,
                    pigeon_instanceManager: pigeon_instanceManager,
                  ),
              arg_pigeon_instanceIdentifier!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
  }

  Future<void> aSuperMethod() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProxyApiSuperClass;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiSuperClass.aSuperMethod';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  @override
  ProxyApiSuperClass pigeon_copy() {
    return ProxyApiSuperClass.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// ProxyApi to serve as an interface to the core ProxyApi class.
class ProxyApiInterface extends PigeonInternalProxyApiBaseClass {
  /// Constructs [ProxyApiInterface] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  ProxyApiInterface.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    this.anInterfaceMethod,
  });

  /// Callback method.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final ProxyApiInterface instance = ProxyApiInterface(
  ///  anInterfaceMethod: (ProxyApiInterface pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final void Function(ProxyApiInterface pigeon_instance)? anInterfaceMethod;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    ProxyApiInterface Function()? pigeon_newInstance,
    void Function(ProxyApiInterface pigeon_instance)? anInterfaceMethod,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
            pigeon_instanceManager ?? PigeonInstanceManager.instance);
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiInterface.pigeon_newInstance',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiInterface.pigeon_newInstance was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(arg_pigeon_instanceIdentifier != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiInterface.pigeon_newInstance was null, expected non-null int.');
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
              pigeon_newInstance?.call() ??
                  ProxyApiInterface.pigeon_detached(
                    pigeon_binaryMessenger: pigeon_binaryMessenger,
                    pigeon_instanceManager: pigeon_instanceManager,
                  ),
              arg_pigeon_instanceIdentifier!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }

    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ProxyApiInterface.anInterfaceMethod',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiInterface.anInterfaceMethod was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final ProxyApiInterface? arg_pigeon_instance =
              (args[0] as ProxyApiInterface?);
          assert(arg_pigeon_instance != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ProxyApiInterface.anInterfaceMethod was null, expected non-null ProxyApiInterface.');
          try {
            (anInterfaceMethod ?? arg_pigeon_instance!.anInterfaceMethod)
                ?.call(arg_pigeon_instance!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
  }

  @override
  ProxyApiInterface pigeon_copy() {
    return ProxyApiInterface.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      anInterfaceMethod: anInterfaceMethod,
    );
  }
}

class ClassWithApiRequirement extends PigeonInternalProxyApiBaseClass {
  factory ClassWithApiRequirement({
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
  }) {
    if (PigeonOverrides.classWithApiRequirement_new != null) {
      return PigeonOverrides.classWithApiRequirement_new!();
    }
    return ClassWithApiRequirement.pigeon_new(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }

  @protected
  ClassWithApiRequirement.pigeon_new({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  }) {
    final int pigeonVar_instanceIdentifier =
        pigeon_instanceManager.addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecClassWithApiRequirement;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ClassWithApiRequirement.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[pigeonVar_instanceIdentifier]);
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [ClassWithApiRequirement] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  ClassWithApiRequirement.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  late final _PigeonInternalProxyApiBaseCodec
      _pigeonVar_codecClassWithApiRequirement =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    ClassWithApiRequirement Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
            pigeon_instanceManager ?? PigeonInstanceManager.instance);
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<
          Object?> pigeonVar_channel = BasicMessageChannel<
              Object?>(
          'dev.flutter.pigeon.pigeon_integration_tests.ClassWithApiRequirement.pigeon_newInstance',
          pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ClassWithApiRequirement.pigeon_newInstance was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(arg_pigeon_instanceIdentifier != null,
              'Argument for dev.flutter.pigeon.pigeon_integration_tests.ClassWithApiRequirement.pigeon_newInstance was null, expected non-null int.');
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
              pigeon_newInstance?.call() ??
                  ClassWithApiRequirement.pigeon_detached(
                    pigeon_binaryMessenger: pigeon_binaryMessenger,
                    pigeon_instanceManager: pigeon_instanceManager,
                  ),
              arg_pigeon_instanceIdentifier!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
                error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
  }

  Future<void> aMethod() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecClassWithApiRequirement;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.pigeon_integration_tests.ClassWithApiRequirement.aMethod';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture =
        pigeonVar_channel.send(<Object?>[this]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  @override
  ClassWithApiRequirement pigeon_copy() {
    return ClassWithApiRequirement.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}
