// dart format width=80
import 'package:drift/internal/versioned_schema.dart' as i0;
import 'package:drift/drift.dart' as i1;
import 'dart:typed_data' as i2;
import 'package:drift/drift.dart'; // ignore_for_file: type=lint,unused_import

// GENERATED BY drift_dev, DO NOT MODIFY.
final class Schema2 extends i0.VersionedSchema {
  Schema2({required super.database}) : super(version: 2);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    userEntity,
    remoteAssetEntity,
    localAssetEntity,
    stackEntity,
    idxLocalAssetChecksum,
    uQRemoteAssetOwnerChecksum,
    idxRemoteAssetChecksum,
    userMetadataEntity,
    partnerEntity,
    localAlbumEntity,
    localAlbumAssetEntity,
    remoteExifEntity,
    remoteAlbumEntity,
    remoteAlbumAssetEntity,
    remoteAlbumUserEntity,
    memoryEntity,
    memoryAssetEntity,
    personEntity,
  ];
  late final Shape0 userEntity = Shape0(
    source: i0.VersionedTable(
      entityName: 'user_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_1,
        _column_2,
        _column_3,
        _column_4,
        _column_5,
        _column_6,
        _column_7,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape1 remoteAssetEntity = Shape1(
    source: i0.VersionedTable(
      entityName: 'remote_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_1,
        _column_8,
        _column_9,
        _column_5,
        _column_10,
        _column_11,
        _column_12,
        _column_0,
        _column_13,
        _column_14,
        _column_15,
        _column_16,
        _column_17,
        _column_18,
        _column_19,
        _column_20,
        _column_21,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape2 localAssetEntity = Shape2(
    source: i0.VersionedTable(
      entityName: 'local_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_1,
        _column_8,
        _column_9,
        _column_5,
        _column_10,
        _column_11,
        _column_12,
        _column_0,
        _column_22,
        _column_14,
        _column_23,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape3 stackEntity = Shape3(
    source: i0.VersionedTable(
      entityName: 'stack_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [_column_0, _column_9, _column_5, _column_15, _column_24],
      attachedDatabase: database,
    ),
    alias: null,
  );
  final i1.Index idxLocalAssetChecksum = i1.Index(
    'idx_local_asset_checksum',
    'CREATE INDEX idx_local_asset_checksum ON local_asset_entity (checksum)',
  );
  final i1.Index uQRemoteAssetOwnerChecksum = i1.Index(
    'UQ_remote_asset_owner_checksum',
    'CREATE UNIQUE INDEX UQ_remote_asset_owner_checksum ON remote_asset_entity (checksum, owner_id)',
  );
  final i1.Index idxRemoteAssetChecksum = i1.Index(
    'idx_remote_asset_checksum',
    'CREATE INDEX idx_remote_asset_checksum ON remote_asset_entity (checksum)',
  );
  late final Shape4 userMetadataEntity = Shape4(
    source: i0.VersionedTable(
      entityName: 'user_metadata_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(user_id, "key")'],
      columns: [_column_25, _column_26, _column_27],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape5 partnerEntity = Shape5(
    source: i0.VersionedTable(
      entityName: 'partner_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(shared_by_id, shared_with_id)'],
      columns: [_column_28, _column_29, _column_30],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape6 localAlbumEntity = Shape6(
    source: i0.VersionedTable(
      entityName: 'local_album_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_1,
        _column_5,
        _column_31,
        _column_32,
        _column_33,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape7 localAlbumAssetEntity = Shape7(
    source: i0.VersionedTable(
      entityName: 'local_album_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id, album_id)'],
      columns: [_column_34, _column_35],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape8 remoteExifEntity = Shape8(
    source: i0.VersionedTable(
      entityName: 'remote_exif_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id)'],
      columns: [
        _column_36,
        _column_37,
        _column_38,
        _column_39,
        _column_40,
        _column_41,
        _column_11,
        _column_10,
        _column_42,
        _column_43,
        _column_44,
        _column_45,
        _column_46,
        _column_47,
        _column_48,
        _column_49,
        _column_50,
        _column_51,
        _column_52,
        _column_53,
        _column_54,
        _column_55,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape9 remoteAlbumEntity = Shape9(
    source: i0.VersionedTable(
      entityName: 'remote_album_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_1,
        _column_56,
        _column_9,
        _column_5,
        _column_15,
        _column_57,
        _column_58,
        _column_59,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape7 remoteAlbumAssetEntity = Shape7(
    source: i0.VersionedTable(
      entityName: 'remote_album_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id, album_id)'],
      columns: [_column_36, _column_60],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape10 remoteAlbumUserEntity = Shape10(
    source: i0.VersionedTable(
      entityName: 'remote_album_user_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(album_id, user_id)'],
      columns: [_column_60, _column_25, _column_61],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape11 memoryEntity = Shape11(
    source: i0.VersionedTable(
      entityName: 'memory_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_9,
        _column_5,
        _column_18,
        _column_15,
        _column_8,
        _column_62,
        _column_63,
        _column_64,
        _column_65,
        _column_66,
        _column_67,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape12 memoryAssetEntity = Shape12(
    source: i0.VersionedTable(
      entityName: 'memory_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id, memory_id)'],
      columns: [_column_36, _column_68],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape13 personEntity = Shape13(
    source: i0.VersionedTable(
      entityName: 'person_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_9,
        _column_5,
        _column_15,
        _column_1,
        _column_69,
        _column_70,
        _column_71,
        _column_72,
        _column_73,
        _column_74,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
}

class Shape0 extends i0.VersionedTable {
  Shape0({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get id =>
      columnsByName['id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get isAdmin =>
      columnsByName['is_admin']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get email =>
      columnsByName['email']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get profileImagePath =>
      columnsByName['profile_image_path']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get updatedAt =>
      columnsByName['updated_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<int> get quotaSizeInBytes =>
      columnsByName['quota_size_in_bytes']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get quotaUsageInBytes =>
      columnsByName['quota_usage_in_bytes']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<String> _column_0(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'id',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_1(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'name',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<bool> _column_2(String aliasedName) =>
    i1.GeneratedColumn<bool>(
      'is_admin',
      aliasedName,
      false,
      type: i1.DriftSqlType.bool,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'CHECK ("is_admin" IN (0, 1))',
      ),
      defaultValue: const CustomExpression('0'),
    );
i1.GeneratedColumn<String> _column_3(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'email',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_4(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'profile_image_path',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<DateTime> _column_5(String aliasedName) =>
    i1.GeneratedColumn<DateTime>(
      'updated_at',
      aliasedName,
      false,
      type: i1.DriftSqlType.dateTime,
      defaultValue: const CustomExpression('CURRENT_TIMESTAMP'),
    );
i1.GeneratedColumn<int> _column_6(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'quota_size_in_bytes',
      aliasedName,
      true,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<int> _column_7(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'quota_usage_in_bytes',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
      defaultValue: const CustomExpression('0'),
    );

class Shape1 extends i0.VersionedTable {
  Shape1({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get type =>
      columnsByName['type']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<DateTime> get createdAt =>
      columnsByName['created_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<DateTime> get updatedAt =>
      columnsByName['updated_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<int> get width =>
      columnsByName['width']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get height =>
      columnsByName['height']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get durationInSeconds =>
      columnsByName['duration_in_seconds']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get id =>
      columnsByName['id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get checksum =>
      columnsByName['checksum']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get isFavorite =>
      columnsByName['is_favorite']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get ownerId =>
      columnsByName['owner_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get localDateTime =>
      columnsByName['local_date_time']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<String> get thumbHash =>
      columnsByName['thumb_hash']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get deletedAt =>
      columnsByName['deleted_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<String> get livePhotoVideoId =>
      columnsByName['live_photo_video_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get visibility =>
      columnsByName['visibility']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get stackId =>
      columnsByName['stack_id']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<int> _column_8(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'type',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<DateTime> _column_9(String aliasedName) =>
    i1.GeneratedColumn<DateTime>(
      'created_at',
      aliasedName,
      false,
      type: i1.DriftSqlType.dateTime,
      defaultValue: const CustomExpression('CURRENT_TIMESTAMP'),
    );
i1.GeneratedColumn<int> _column_10(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'width',
      aliasedName,
      true,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<int> _column_11(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'height',
      aliasedName,
      true,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<int> _column_12(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'duration_in_seconds',
      aliasedName,
      true,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<String> _column_13(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'checksum',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<bool> _column_14(String aliasedName) =>
    i1.GeneratedColumn<bool>(
      'is_favorite',
      aliasedName,
      false,
      type: i1.DriftSqlType.bool,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'CHECK ("is_favorite" IN (0, 1))',
      ),
      defaultValue: const CustomExpression('0'),
    );
i1.GeneratedColumn<String> _column_15(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'owner_id',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'REFERENCES user_entity (id) ON DELETE CASCADE',
      ),
    );
i1.GeneratedColumn<DateTime> _column_16(String aliasedName) =>
    i1.GeneratedColumn<DateTime>(
      'local_date_time',
      aliasedName,
      true,
      type: i1.DriftSqlType.dateTime,
    );
i1.GeneratedColumn<String> _column_17(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'thumb_hash',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<DateTime> _column_18(String aliasedName) =>
    i1.GeneratedColumn<DateTime>(
      'deleted_at',
      aliasedName,
      true,
      type: i1.DriftSqlType.dateTime,
    );
i1.GeneratedColumn<String> _column_19(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'live_photo_video_id',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<int> _column_20(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'visibility',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<String> _column_21(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'stack_id',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );

class Shape2 extends i0.VersionedTable {
  Shape2({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get type =>
      columnsByName['type']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<DateTime> get createdAt =>
      columnsByName['created_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<DateTime> get updatedAt =>
      columnsByName['updated_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<int> get width =>
      columnsByName['width']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get height =>
      columnsByName['height']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get durationInSeconds =>
      columnsByName['duration_in_seconds']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get id =>
      columnsByName['id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get checksum =>
      columnsByName['checksum']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get isFavorite =>
      columnsByName['is_favorite']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get orientation =>
      columnsByName['orientation']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<String> _column_22(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'checksum',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<int> _column_23(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'orientation',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
      defaultValue: const CustomExpression('0'),
    );

class Shape3 extends i0.VersionedTable {
  Shape3({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get id =>
      columnsByName['id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get createdAt =>
      columnsByName['created_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<DateTime> get updatedAt =>
      columnsByName['updated_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<String> get ownerId =>
      columnsByName['owner_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get primaryAssetId =>
      columnsByName['primary_asset_id']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_24(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'primary_asset_id',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'REFERENCES remote_asset_entity (id)',
      ),
    );

class Shape4 extends i0.VersionedTable {
  Shape4({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get userId =>
      columnsByName['user_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get key =>
      columnsByName['key']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<i2.Uint8List> get value =>
      columnsByName['value']! as i1.GeneratedColumn<i2.Uint8List>;
}

i1.GeneratedColumn<String> _column_25(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'user_id',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'REFERENCES user_entity (id) ON DELETE CASCADE',
      ),
    );
i1.GeneratedColumn<int> _column_26(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'key',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<i2.Uint8List> _column_27(String aliasedName) =>
    i1.GeneratedColumn<i2.Uint8List>(
      'value',
      aliasedName,
      false,
      type: i1.DriftSqlType.blob,
    );

class Shape5 extends i0.VersionedTable {
  Shape5({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get sharedById =>
      columnsByName['shared_by_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get sharedWithId =>
      columnsByName['shared_with_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get inTimeline =>
      columnsByName['in_timeline']! as i1.GeneratedColumn<bool>;
}

i1.GeneratedColumn<String> _column_28(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'shared_by_id',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'REFERENCES user_entity (id) ON DELETE CASCADE',
      ),
    );
i1.GeneratedColumn<String> _column_29(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'shared_with_id',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'REFERENCES user_entity (id) ON DELETE CASCADE',
      ),
    );
i1.GeneratedColumn<bool> _column_30(String aliasedName) =>
    i1.GeneratedColumn<bool>(
      'in_timeline',
      aliasedName,
      false,
      type: i1.DriftSqlType.bool,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'CHECK ("in_timeline" IN (0, 1))',
      ),
      defaultValue: const CustomExpression('0'),
    );

class Shape6 extends i0.VersionedTable {
  Shape6({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get id =>
      columnsByName['id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get updatedAt =>
      columnsByName['updated_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<int> get backupSelection =>
      columnsByName['backup_selection']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get isIosSharedAlbum =>
      columnsByName['is_ios_shared_album']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get marker_ =>
      columnsByName['marker']! as i1.GeneratedColumn<bool>;
}

i1.GeneratedColumn<int> _column_31(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'backup_selection',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<bool> _column_32(String aliasedName) =>
    i1.GeneratedColumn<bool>(
      'is_ios_shared_album',
      aliasedName,
      false,
      type: i1.DriftSqlType.bool,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'CHECK ("is_ios_shared_album" IN (0, 1))',
      ),
      defaultValue: const CustomExpression('0'),
    );
i1.GeneratedColumn<bool> _column_33(String aliasedName) =>
    i1.GeneratedColumn<bool>(
      'marker',
      aliasedName,
      true,
      type: i1.DriftSqlType.bool,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'CHECK ("marker" IN (0, 1))',
      ),
    );

class Shape7 extends i0.VersionedTable {
  Shape7({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get assetId =>
      columnsByName['asset_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get albumId =>
      columnsByName['album_id']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_34(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'asset_id',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'REFERENCES local_asset_entity (id) ON DELETE CASCADE',
      ),
    );
i1.GeneratedColumn<String> _column_35(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'album_id',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'REFERENCES local_album_entity (id) ON DELETE CASCADE',
      ),
    );

class Shape8 extends i0.VersionedTable {
  Shape8({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get assetId =>
      columnsByName['asset_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get city =>
      columnsByName['city']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get state =>
      columnsByName['state']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get country =>
      columnsByName['country']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get dateTimeOriginal =>
      columnsByName['date_time_original']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<String> get description =>
      columnsByName['description']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get height =>
      columnsByName['height']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get width =>
      columnsByName['width']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get exposureTime =>
      columnsByName['exposure_time']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<double> get fNumber =>
      columnsByName['f_number']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<int> get fileSize =>
      columnsByName['file_size']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<double> get focalLength =>
      columnsByName['focal_length']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get latitude =>
      columnsByName['latitude']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get longitude =>
      columnsByName['longitude']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<int> get iso =>
      columnsByName['iso']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get make =>
      columnsByName['make']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get model =>
      columnsByName['model']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get lens =>
      columnsByName['lens']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get orientation =>
      columnsByName['orientation']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get timeZone =>
      columnsByName['time_zone']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get rating =>
      columnsByName['rating']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get projectionType =>
      columnsByName['projection_type']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_36(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'asset_id',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'REFERENCES remote_asset_entity (id) ON DELETE CASCADE',
      ),
    );
i1.GeneratedColumn<String> _column_37(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'city',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_38(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'state',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_39(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'country',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<DateTime> _column_40(String aliasedName) =>
    i1.GeneratedColumn<DateTime>(
      'date_time_original',
      aliasedName,
      true,
      type: i1.DriftSqlType.dateTime,
    );
i1.GeneratedColumn<String> _column_41(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'description',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_42(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'exposure_time',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<double> _column_43(String aliasedName) =>
    i1.GeneratedColumn<double>(
      'f_number',
      aliasedName,
      true,
      type: i1.DriftSqlType.double,
    );
i1.GeneratedColumn<int> _column_44(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'file_size',
      aliasedName,
      true,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<double> _column_45(String aliasedName) =>
    i1.GeneratedColumn<double>(
      'focal_length',
      aliasedName,
      true,
      type: i1.DriftSqlType.double,
    );
i1.GeneratedColumn<double> _column_46(String aliasedName) =>
    i1.GeneratedColumn<double>(
      'latitude',
      aliasedName,
      true,
      type: i1.DriftSqlType.double,
    );
i1.GeneratedColumn<double> _column_47(String aliasedName) =>
    i1.GeneratedColumn<double>(
      'longitude',
      aliasedName,
      true,
      type: i1.DriftSqlType.double,
    );
i1.GeneratedColumn<int> _column_48(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'iso',
      aliasedName,
      true,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<String> _column_49(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'make',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_50(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'model',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_51(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'lens',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_52(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'orientation',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_53(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'time_zone',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<int> _column_54(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'rating',
      aliasedName,
      true,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<String> _column_55(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'projection_type',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );

class Shape9 extends i0.VersionedTable {
  Shape9({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get id =>
      columnsByName['id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get description =>
      columnsByName['description']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get createdAt =>
      columnsByName['created_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<DateTime> get updatedAt =>
      columnsByName['updated_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<String> get ownerId =>
      columnsByName['owner_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get thumbnailAssetId =>
      columnsByName['thumbnail_asset_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get isActivityEnabled =>
      columnsByName['is_activity_enabled']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get order =>
      columnsByName['order']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<String> _column_56(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'description',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      defaultValue: const CustomExpression('\'\''),
    );
i1.GeneratedColumn<String> _column_57(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'thumbnail_asset_id',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'REFERENCES remote_asset_entity (id) ON DELETE SET NULL',
      ),
    );
i1.GeneratedColumn<bool> _column_58(String aliasedName) =>
    i1.GeneratedColumn<bool>(
      'is_activity_enabled',
      aliasedName,
      false,
      type: i1.DriftSqlType.bool,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'CHECK ("is_activity_enabled" IN (0, 1))',
      ),
      defaultValue: const CustomExpression('1'),
    );
i1.GeneratedColumn<int> _column_59(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'order',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<String> _column_60(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'album_id',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'REFERENCES remote_album_entity (id) ON DELETE CASCADE',
      ),
    );

class Shape10 extends i0.VersionedTable {
  Shape10({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get albumId =>
      columnsByName['album_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get userId =>
      columnsByName['user_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get role =>
      columnsByName['role']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<int> _column_61(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'role',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
    );

class Shape11 extends i0.VersionedTable {
  Shape11({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get id =>
      columnsByName['id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get createdAt =>
      columnsByName['created_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<DateTime> get updatedAt =>
      columnsByName['updated_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<DateTime> get deletedAt =>
      columnsByName['deleted_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<String> get ownerId =>
      columnsByName['owner_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get type =>
      columnsByName['type']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get data =>
      columnsByName['data']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get isSaved =>
      columnsByName['is_saved']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<DateTime> get memoryAt =>
      columnsByName['memory_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<DateTime> get seenAt =>
      columnsByName['seen_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<DateTime> get showAt =>
      columnsByName['show_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<DateTime> get hideAt =>
      columnsByName['hide_at']! as i1.GeneratedColumn<DateTime>;
}

i1.GeneratedColumn<String> _column_62(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'data',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<bool> _column_63(String aliasedName) =>
    i1.GeneratedColumn<bool>(
      'is_saved',
      aliasedName,
      false,
      type: i1.DriftSqlType.bool,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'CHECK ("is_saved" IN (0, 1))',
      ),
      defaultValue: const CustomExpression('0'),
    );
i1.GeneratedColumn<DateTime> _column_64(String aliasedName) =>
    i1.GeneratedColumn<DateTime>(
      'memory_at',
      aliasedName,
      false,
      type: i1.DriftSqlType.dateTime,
    );
i1.GeneratedColumn<DateTime> _column_65(String aliasedName) =>
    i1.GeneratedColumn<DateTime>(
      'seen_at',
      aliasedName,
      true,
      type: i1.DriftSqlType.dateTime,
    );
i1.GeneratedColumn<DateTime> _column_66(String aliasedName) =>
    i1.GeneratedColumn<DateTime>(
      'show_at',
      aliasedName,
      true,
      type: i1.DriftSqlType.dateTime,
    );
i1.GeneratedColumn<DateTime> _column_67(String aliasedName) =>
    i1.GeneratedColumn<DateTime>(
      'hide_at',
      aliasedName,
      true,
      type: i1.DriftSqlType.dateTime,
    );

class Shape12 extends i0.VersionedTable {
  Shape12({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get assetId =>
      columnsByName['asset_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get memoryId =>
      columnsByName['memory_id']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_68(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'memory_id',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'REFERENCES memory_entity (id) ON DELETE CASCADE',
      ),
    );

class Shape13 extends i0.VersionedTable {
  Shape13({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get id =>
      columnsByName['id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get createdAt =>
      columnsByName['created_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<DateTime> get updatedAt =>
      columnsByName['updated_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<String> get ownerId =>
      columnsByName['owner_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get faceAssetId =>
      columnsByName['face_asset_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get thumbnailPath =>
      columnsByName['thumbnail_path']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get isFavorite =>
      columnsByName['is_favorite']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get isHidden =>
      columnsByName['is_hidden']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get color =>
      columnsByName['color']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get birthDate =>
      columnsByName['birth_date']! as i1.GeneratedColumn<DateTime>;
}

i1.GeneratedColumn<String> _column_69(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'face_asset_id',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_70(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'thumbnail_path',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<bool> _column_71(String aliasedName) =>
    i1.GeneratedColumn<bool>(
      'is_favorite',
      aliasedName,
      false,
      type: i1.DriftSqlType.bool,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'CHECK ("is_favorite" IN (0, 1))',
      ),
    );
i1.GeneratedColumn<bool> _column_72(String aliasedName) =>
    i1.GeneratedColumn<bool>(
      'is_hidden',
      aliasedName,
      false,
      type: i1.DriftSqlType.bool,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'CHECK ("is_hidden" IN (0, 1))',
      ),
    );
i1.GeneratedColumn<String> _column_73(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'color',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<DateTime> _column_74(String aliasedName) =>
    i1.GeneratedColumn<DateTime>(
      'birth_date',
      aliasedName,
      true,
      type: i1.DriftSqlType.dateTime,
    );

final class Schema3 extends i0.VersionedSchema {
  Schema3({required super.database}) : super(version: 3);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    userEntity,
    remoteAssetEntity,
    localAssetEntity,
    stackEntity,
    idxLocalAssetChecksum,
    uQRemoteAssetOwnerChecksum,
    idxRemoteAssetChecksum,
    userMetadataEntity,
    partnerEntity,
    localAlbumEntity,
    localAlbumAssetEntity,
    remoteExifEntity,
    remoteAlbumEntity,
    remoteAlbumAssetEntity,
    remoteAlbumUserEntity,
    memoryEntity,
    memoryAssetEntity,
    personEntity,
  ];
  late final Shape0 userEntity = Shape0(
    source: i0.VersionedTable(
      entityName: 'user_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_1,
        _column_2,
        _column_3,
        _column_4,
        _column_5,
        _column_6,
        _column_7,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape1 remoteAssetEntity = Shape1(
    source: i0.VersionedTable(
      entityName: 'remote_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_1,
        _column_8,
        _column_9,
        _column_5,
        _column_10,
        _column_11,
        _column_12,
        _column_0,
        _column_13,
        _column_14,
        _column_15,
        _column_16,
        _column_17,
        _column_18,
        _column_19,
        _column_20,
        _column_21,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape2 localAssetEntity = Shape2(
    source: i0.VersionedTable(
      entityName: 'local_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_1,
        _column_8,
        _column_9,
        _column_5,
        _column_10,
        _column_11,
        _column_12,
        _column_0,
        _column_22,
        _column_14,
        _column_23,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape3 stackEntity = Shape3(
    source: i0.VersionedTable(
      entityName: 'stack_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [_column_0, _column_9, _column_5, _column_15, _column_75],
      attachedDatabase: database,
    ),
    alias: null,
  );
  final i1.Index idxLocalAssetChecksum = i1.Index(
    'idx_local_asset_checksum',
    'CREATE INDEX idx_local_asset_checksum ON local_asset_entity (checksum)',
  );
  final i1.Index uQRemoteAssetOwnerChecksum = i1.Index(
    'UQ_remote_asset_owner_checksum',
    'CREATE UNIQUE INDEX UQ_remote_asset_owner_checksum ON remote_asset_entity (checksum, owner_id)',
  );
  final i1.Index idxRemoteAssetChecksum = i1.Index(
    'idx_remote_asset_checksum',
    'CREATE INDEX idx_remote_asset_checksum ON remote_asset_entity (checksum)',
  );
  late final Shape4 userMetadataEntity = Shape4(
    source: i0.VersionedTable(
      entityName: 'user_metadata_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(user_id, "key")'],
      columns: [_column_25, _column_26, _column_27],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape5 partnerEntity = Shape5(
    source: i0.VersionedTable(
      entityName: 'partner_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(shared_by_id, shared_with_id)'],
      columns: [_column_28, _column_29, _column_30],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape6 localAlbumEntity = Shape6(
    source: i0.VersionedTable(
      entityName: 'local_album_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_1,
        _column_5,
        _column_31,
        _column_32,
        _column_33,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape7 localAlbumAssetEntity = Shape7(
    source: i0.VersionedTable(
      entityName: 'local_album_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id, album_id)'],
      columns: [_column_34, _column_35],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape8 remoteExifEntity = Shape8(
    source: i0.VersionedTable(
      entityName: 'remote_exif_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id)'],
      columns: [
        _column_36,
        _column_37,
        _column_38,
        _column_39,
        _column_40,
        _column_41,
        _column_11,
        _column_10,
        _column_42,
        _column_43,
        _column_44,
        _column_45,
        _column_46,
        _column_47,
        _column_48,
        _column_49,
        _column_50,
        _column_51,
        _column_52,
        _column_53,
        _column_54,
        _column_55,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape9 remoteAlbumEntity = Shape9(
    source: i0.VersionedTable(
      entityName: 'remote_album_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_1,
        _column_56,
        _column_9,
        _column_5,
        _column_15,
        _column_57,
        _column_58,
        _column_59,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape7 remoteAlbumAssetEntity = Shape7(
    source: i0.VersionedTable(
      entityName: 'remote_album_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id, album_id)'],
      columns: [_column_36, _column_60],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape10 remoteAlbumUserEntity = Shape10(
    source: i0.VersionedTable(
      entityName: 'remote_album_user_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(album_id, user_id)'],
      columns: [_column_60, _column_25, _column_61],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape11 memoryEntity = Shape11(
    source: i0.VersionedTable(
      entityName: 'memory_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_9,
        _column_5,
        _column_18,
        _column_15,
        _column_8,
        _column_62,
        _column_63,
        _column_64,
        _column_65,
        _column_66,
        _column_67,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape12 memoryAssetEntity = Shape12(
    source: i0.VersionedTable(
      entityName: 'memory_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id, memory_id)'],
      columns: [_column_36, _column_68],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape13 personEntity = Shape13(
    source: i0.VersionedTable(
      entityName: 'person_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_9,
        _column_5,
        _column_15,
        _column_1,
        _column_69,
        _column_70,
        _column_71,
        _column_72,
        _column_73,
        _column_74,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
}

i1.GeneratedColumn<String> _column_75(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'primary_asset_id',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
    );

final class Schema4 extends i0.VersionedSchema {
  Schema4({required super.database}) : super(version: 4);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    userEntity,
    remoteAssetEntity,
    stackEntity,
    localAssetEntity,
    localAlbumEntity,
    localAlbumAssetEntity,
    idxLocalAssetChecksum,
    uQRemoteAssetOwnerChecksum,
    idxRemoteAssetChecksum,
    userMetadataEntity,
    partnerEntity,
    remoteExifEntity,
    remoteAlbumEntity,
    remoteAlbumAssetEntity,
    remoteAlbumUserEntity,
    memoryEntity,
    memoryAssetEntity,
    personEntity,
    assetFaceEntity,
  ];
  late final Shape0 userEntity = Shape0(
    source: i0.VersionedTable(
      entityName: 'user_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_1,
        _column_2,
        _column_3,
        _column_4,
        _column_5,
        _column_6,
        _column_7,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape1 remoteAssetEntity = Shape1(
    source: i0.VersionedTable(
      entityName: 'remote_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_1,
        _column_8,
        _column_9,
        _column_5,
        _column_10,
        _column_11,
        _column_12,
        _column_0,
        _column_13,
        _column_14,
        _column_15,
        _column_16,
        _column_17,
        _column_18,
        _column_19,
        _column_20,
        _column_21,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape3 stackEntity = Shape3(
    source: i0.VersionedTable(
      entityName: 'stack_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [_column_0, _column_9, _column_5, _column_15, _column_75],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape2 localAssetEntity = Shape2(
    source: i0.VersionedTable(
      entityName: 'local_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_1,
        _column_8,
        _column_9,
        _column_5,
        _column_10,
        _column_11,
        _column_12,
        _column_0,
        _column_22,
        _column_14,
        _column_23,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape6 localAlbumEntity = Shape6(
    source: i0.VersionedTable(
      entityName: 'local_album_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_1,
        _column_5,
        _column_31,
        _column_32,
        _column_33,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape7 localAlbumAssetEntity = Shape7(
    source: i0.VersionedTable(
      entityName: 'local_album_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id, album_id)'],
      columns: [_column_34, _column_35],
      attachedDatabase: database,
    ),
    alias: null,
  );
  final i1.Index idxLocalAssetChecksum = i1.Index(
    'idx_local_asset_checksum',
    'CREATE INDEX idx_local_asset_checksum ON local_asset_entity (checksum)',
  );
  final i1.Index uQRemoteAssetOwnerChecksum = i1.Index(
    'UQ_remote_asset_owner_checksum',
    'CREATE UNIQUE INDEX UQ_remote_asset_owner_checksum ON remote_asset_entity (checksum, owner_id)',
  );
  final i1.Index idxRemoteAssetChecksum = i1.Index(
    'idx_remote_asset_checksum',
    'CREATE INDEX idx_remote_asset_checksum ON remote_asset_entity (checksum)',
  );
  late final Shape4 userMetadataEntity = Shape4(
    source: i0.VersionedTable(
      entityName: 'user_metadata_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(user_id, "key")'],
      columns: [_column_25, _column_26, _column_27],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape5 partnerEntity = Shape5(
    source: i0.VersionedTable(
      entityName: 'partner_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(shared_by_id, shared_with_id)'],
      columns: [_column_28, _column_29, _column_30],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape8 remoteExifEntity = Shape8(
    source: i0.VersionedTable(
      entityName: 'remote_exif_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id)'],
      columns: [
        _column_36,
        _column_37,
        _column_38,
        _column_39,
        _column_40,
        _column_41,
        _column_11,
        _column_10,
        _column_42,
        _column_43,
        _column_44,
        _column_45,
        _column_46,
        _column_47,
        _column_48,
        _column_49,
        _column_50,
        _column_51,
        _column_52,
        _column_53,
        _column_54,
        _column_55,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape9 remoteAlbumEntity = Shape9(
    source: i0.VersionedTable(
      entityName: 'remote_album_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_1,
        _column_56,
        _column_9,
        _column_5,
        _column_15,
        _column_57,
        _column_58,
        _column_59,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape7 remoteAlbumAssetEntity = Shape7(
    source: i0.VersionedTable(
      entityName: 'remote_album_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id, album_id)'],
      columns: [_column_36, _column_60],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape10 remoteAlbumUserEntity = Shape10(
    source: i0.VersionedTable(
      entityName: 'remote_album_user_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(album_id, user_id)'],
      columns: [_column_60, _column_25, _column_61],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape11 memoryEntity = Shape11(
    source: i0.VersionedTable(
      entityName: 'memory_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_9,
        _column_5,
        _column_18,
        _column_15,
        _column_8,
        _column_62,
        _column_63,
        _column_64,
        _column_65,
        _column_66,
        _column_67,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape12 memoryAssetEntity = Shape12(
    source: i0.VersionedTable(
      entityName: 'memory_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id, memory_id)'],
      columns: [_column_36, _column_68],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape14 personEntity = Shape14(
    source: i0.VersionedTable(
      entityName: 'person_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_9,
        _column_5,
        _column_15,
        _column_1,
        _column_69,
        _column_71,
        _column_72,
        _column_73,
        _column_74,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape15 assetFaceEntity = Shape15(
    source: i0.VersionedTable(
      entityName: 'asset_face_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_36,
        _column_76,
        _column_77,
        _column_78,
        _column_79,
        _column_80,
        _column_81,
        _column_82,
        _column_83,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
}

class Shape14 extends i0.VersionedTable {
  Shape14({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get id =>
      columnsByName['id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get createdAt =>
      columnsByName['created_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<DateTime> get updatedAt =>
      columnsByName['updated_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<String> get ownerId =>
      columnsByName['owner_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get faceAssetId =>
      columnsByName['face_asset_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get isFavorite =>
      columnsByName['is_favorite']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get isHidden =>
      columnsByName['is_hidden']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get color =>
      columnsByName['color']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get birthDate =>
      columnsByName['birth_date']! as i1.GeneratedColumn<DateTime>;
}

class Shape15 extends i0.VersionedTable {
  Shape15({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get id =>
      columnsByName['id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get assetId =>
      columnsByName['asset_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get personId =>
      columnsByName['person_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get imageWidth =>
      columnsByName['image_width']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get imageHeight =>
      columnsByName['image_height']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get boundingBoxX1 =>
      columnsByName['bounding_box_x1']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get boundingBoxY1 =>
      columnsByName['bounding_box_y1']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get boundingBoxX2 =>
      columnsByName['bounding_box_x2']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get boundingBoxY2 =>
      columnsByName['bounding_box_y2']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get sourceType =>
      columnsByName['source_type']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_76(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'person_id',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'REFERENCES person_entity (id) ON DELETE SET NULL',
      ),
    );
i1.GeneratedColumn<int> _column_77(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'image_width',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<int> _column_78(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'image_height',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<int> _column_79(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'bounding_box_x1',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<int> _column_80(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'bounding_box_y1',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<int> _column_81(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'bounding_box_x2',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<int> _column_82(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'bounding_box_y2',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<String> _column_83(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'source_type',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
    );

final class Schema5 extends i0.VersionedSchema {
  Schema5({required super.database}) : super(version: 5);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    userEntity,
    remoteAssetEntity,
    stackEntity,
    localAssetEntity,
    localAlbumEntity,
    localAlbumAssetEntity,
    idxLocalAssetChecksum,
    uQRemoteAssetOwnerChecksum,
    idxRemoteAssetChecksum,
    userMetadataEntity,
    partnerEntity,
    remoteExifEntity,
    remoteAlbumEntity,
    remoteAlbumAssetEntity,
    remoteAlbumUserEntity,
    memoryEntity,
    memoryAssetEntity,
    personEntity,
    assetFaceEntity,
  ];
  late final Shape16 userEntity = Shape16(
    source: i0.VersionedTable(
      entityName: 'user_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_1,
        _column_2,
        _column_3,
        _column_84,
        _column_85,
        _column_5,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape1 remoteAssetEntity = Shape1(
    source: i0.VersionedTable(
      entityName: 'remote_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_1,
        _column_8,
        _column_9,
        _column_5,
        _column_10,
        _column_11,
        _column_12,
        _column_0,
        _column_13,
        _column_14,
        _column_15,
        _column_16,
        _column_17,
        _column_18,
        _column_19,
        _column_20,
        _column_21,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape3 stackEntity = Shape3(
    source: i0.VersionedTable(
      entityName: 'stack_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [_column_0, _column_9, _column_5, _column_15, _column_75],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape2 localAssetEntity = Shape2(
    source: i0.VersionedTable(
      entityName: 'local_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_1,
        _column_8,
        _column_9,
        _column_5,
        _column_10,
        _column_11,
        _column_12,
        _column_0,
        _column_22,
        _column_14,
        _column_23,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape6 localAlbumEntity = Shape6(
    source: i0.VersionedTable(
      entityName: 'local_album_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_1,
        _column_5,
        _column_31,
        _column_32,
        _column_33,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape7 localAlbumAssetEntity = Shape7(
    source: i0.VersionedTable(
      entityName: 'local_album_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id, album_id)'],
      columns: [_column_34, _column_35],
      attachedDatabase: database,
    ),
    alias: null,
  );
  final i1.Index idxLocalAssetChecksum = i1.Index(
    'idx_local_asset_checksum',
    'CREATE INDEX idx_local_asset_checksum ON local_asset_entity (checksum)',
  );
  final i1.Index uQRemoteAssetOwnerChecksum = i1.Index(
    'UQ_remote_asset_owner_checksum',
    'CREATE UNIQUE INDEX UQ_remote_asset_owner_checksum ON remote_asset_entity (checksum, owner_id)',
  );
  final i1.Index idxRemoteAssetChecksum = i1.Index(
    'idx_remote_asset_checksum',
    'CREATE INDEX idx_remote_asset_checksum ON remote_asset_entity (checksum)',
  );
  late final Shape4 userMetadataEntity = Shape4(
    source: i0.VersionedTable(
      entityName: 'user_metadata_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(user_id, "key")'],
      columns: [_column_25, _column_26, _column_27],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape5 partnerEntity = Shape5(
    source: i0.VersionedTable(
      entityName: 'partner_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(shared_by_id, shared_with_id)'],
      columns: [_column_28, _column_29, _column_30],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape8 remoteExifEntity = Shape8(
    source: i0.VersionedTable(
      entityName: 'remote_exif_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id)'],
      columns: [
        _column_36,
        _column_37,
        _column_38,
        _column_39,
        _column_40,
        _column_41,
        _column_11,
        _column_10,
        _column_42,
        _column_43,
        _column_44,
        _column_45,
        _column_46,
        _column_47,
        _column_48,
        _column_49,
        _column_50,
        _column_51,
        _column_52,
        _column_53,
        _column_54,
        _column_55,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape9 remoteAlbumEntity = Shape9(
    source: i0.VersionedTable(
      entityName: 'remote_album_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_1,
        _column_56,
        _column_9,
        _column_5,
        _column_15,
        _column_57,
        _column_58,
        _column_59,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape7 remoteAlbumAssetEntity = Shape7(
    source: i0.VersionedTable(
      entityName: 'remote_album_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id, album_id)'],
      columns: [_column_36, _column_60],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape10 remoteAlbumUserEntity = Shape10(
    source: i0.VersionedTable(
      entityName: 'remote_album_user_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(album_id, user_id)'],
      columns: [_column_60, _column_25, _column_61],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape11 memoryEntity = Shape11(
    source: i0.VersionedTable(
      entityName: 'memory_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_9,
        _column_5,
        _column_18,
        _column_15,
        _column_8,
        _column_62,
        _column_63,
        _column_64,
        _column_65,
        _column_66,
        _column_67,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape12 memoryAssetEntity = Shape12(
    source: i0.VersionedTable(
      entityName: 'memory_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id, memory_id)'],
      columns: [_column_36, _column_68],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape14 personEntity = Shape14(
    source: i0.VersionedTable(
      entityName: 'person_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_9,
        _column_5,
        _column_15,
        _column_1,
        _column_69,
        _column_71,
        _column_72,
        _column_73,
        _column_74,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape15 assetFaceEntity = Shape15(
    source: i0.VersionedTable(
      entityName: 'asset_face_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_36,
        _column_76,
        _column_77,
        _column_78,
        _column_79,
        _column_80,
        _column_81,
        _column_82,
        _column_83,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
}

class Shape16 extends i0.VersionedTable {
  Shape16({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get id =>
      columnsByName['id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get isAdmin =>
      columnsByName['is_admin']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get email =>
      columnsByName['email']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get hasProfileImage =>
      columnsByName['has_profile_image']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<DateTime> get profileChangedAt =>
      columnsByName['profile_changed_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<DateTime> get updatedAt =>
      columnsByName['updated_at']! as i1.GeneratedColumn<DateTime>;
}

i1.GeneratedColumn<bool> _column_84(String aliasedName) =>
    i1.GeneratedColumn<bool>(
      'has_profile_image',
      aliasedName,
      false,
      type: i1.DriftSqlType.bool,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'CHECK ("has_profile_image" IN (0, 1))',
      ),
      defaultValue: const CustomExpression('0'),
    );
i1.GeneratedColumn<DateTime> _column_85(String aliasedName) =>
    i1.GeneratedColumn<DateTime>(
      'profile_changed_at',
      aliasedName,
      false,
      type: i1.DriftSqlType.dateTime,
      defaultValue: const CustomExpression('CURRENT_TIMESTAMP'),
    );

final class Schema6 extends i0.VersionedSchema {
  Schema6({required super.database}) : super(version: 6);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    userEntity,
    remoteAssetEntity,
    stackEntity,
    localAssetEntity,
    localAlbumEntity,
    localAlbumAssetEntity,
    idxLocalAssetChecksum,
    idxRemoteAssetOwnerChecksum,
    uQRemoteAssetsOwnerChecksum,
    uQRemoteAssetsOwnerLibraryChecksum,
    idxRemoteAssetChecksum,
    userMetadataEntity,
    partnerEntity,
    remoteExifEntity,
    remoteAlbumEntity,
    remoteAlbumAssetEntity,
    remoteAlbumUserEntity,
    memoryEntity,
    memoryAssetEntity,
    personEntity,
    assetFaceEntity,
  ];
  late final Shape16 userEntity = Shape16(
    source: i0.VersionedTable(
      entityName: 'user_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_1,
        _column_2,
        _column_3,
        _column_84,
        _column_85,
        _column_5,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape17 remoteAssetEntity = Shape17(
    source: i0.VersionedTable(
      entityName: 'remote_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_1,
        _column_8,
        _column_9,
        _column_5,
        _column_10,
        _column_11,
        _column_12,
        _column_0,
        _column_13,
        _column_14,
        _column_15,
        _column_16,
        _column_17,
        _column_18,
        _column_19,
        _column_20,
        _column_21,
        _column_86,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape3 stackEntity = Shape3(
    source: i0.VersionedTable(
      entityName: 'stack_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [_column_0, _column_9, _column_5, _column_15, _column_75],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape2 localAssetEntity = Shape2(
    source: i0.VersionedTable(
      entityName: 'local_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_1,
        _column_8,
        _column_9,
        _column_5,
        _column_10,
        _column_11,
        _column_12,
        _column_0,
        _column_22,
        _column_14,
        _column_23,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape6 localAlbumEntity = Shape6(
    source: i0.VersionedTable(
      entityName: 'local_album_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_1,
        _column_5,
        _column_31,
        _column_32,
        _column_33,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape7 localAlbumAssetEntity = Shape7(
    source: i0.VersionedTable(
      entityName: 'local_album_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id, album_id)'],
      columns: [_column_34, _column_35],
      attachedDatabase: database,
    ),
    alias: null,
  );
  final i1.Index idxLocalAssetChecksum = i1.Index(
    'idx_local_asset_checksum',
    'CREATE INDEX idx_local_asset_checksum ON local_asset_entity (checksum)',
  );
  final i1.Index idxRemoteAssetOwnerChecksum = i1.Index(
    'idx_remote_asset_owner_checksum',
    'CREATE INDEX idx_remote_asset_owner_checksum ON remote_asset_entity (owner_id, checksum)',
  );
  final i1.Index uQRemoteAssetsOwnerChecksum = i1.Index(
    'UQ_remote_assets_owner_checksum',
    'CREATE UNIQUE INDEX IF NOT EXISTS UQ_remote_assets_owner_checksum ON remote_asset_entity (owner_id, checksum) WHERE(library_id IS NULL)',
  );
  final i1.Index uQRemoteAssetsOwnerLibraryChecksum = i1.Index(
    'UQ_remote_assets_owner_library_checksum',
    'CREATE UNIQUE INDEX IF NOT EXISTS UQ_remote_assets_owner_library_checksum ON remote_asset_entity (owner_id, library_id, checksum) WHERE(library_id IS NOT NULL)',
  );
  final i1.Index idxRemoteAssetChecksum = i1.Index(
    'idx_remote_asset_checksum',
    'CREATE INDEX idx_remote_asset_checksum ON remote_asset_entity (checksum)',
  );
  late final Shape4 userMetadataEntity = Shape4(
    source: i0.VersionedTable(
      entityName: 'user_metadata_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(user_id, "key")'],
      columns: [_column_25, _column_26, _column_27],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape5 partnerEntity = Shape5(
    source: i0.VersionedTable(
      entityName: 'partner_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(shared_by_id, shared_with_id)'],
      columns: [_column_28, _column_29, _column_30],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape8 remoteExifEntity = Shape8(
    source: i0.VersionedTable(
      entityName: 'remote_exif_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id)'],
      columns: [
        _column_36,
        _column_37,
        _column_38,
        _column_39,
        _column_40,
        _column_41,
        _column_11,
        _column_10,
        _column_42,
        _column_43,
        _column_44,
        _column_45,
        _column_46,
        _column_47,
        _column_48,
        _column_49,
        _column_50,
        _column_51,
        _column_52,
        _column_53,
        _column_54,
        _column_55,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape9 remoteAlbumEntity = Shape9(
    source: i0.VersionedTable(
      entityName: 'remote_album_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_1,
        _column_56,
        _column_9,
        _column_5,
        _column_15,
        _column_57,
        _column_58,
        _column_59,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape7 remoteAlbumAssetEntity = Shape7(
    source: i0.VersionedTable(
      entityName: 'remote_album_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id, album_id)'],
      columns: [_column_36, _column_60],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape10 remoteAlbumUserEntity = Shape10(
    source: i0.VersionedTable(
      entityName: 'remote_album_user_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(album_id, user_id)'],
      columns: [_column_60, _column_25, _column_61],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape11 memoryEntity = Shape11(
    source: i0.VersionedTable(
      entityName: 'memory_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_9,
        _column_5,
        _column_18,
        _column_15,
        _column_8,
        _column_62,
        _column_63,
        _column_64,
        _column_65,
        _column_66,
        _column_67,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape12 memoryAssetEntity = Shape12(
    source: i0.VersionedTable(
      entityName: 'memory_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id, memory_id)'],
      columns: [_column_36, _column_68],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape14 personEntity = Shape14(
    source: i0.VersionedTable(
      entityName: 'person_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_9,
        _column_5,
        _column_15,
        _column_1,
        _column_69,
        _column_71,
        _column_72,
        _column_73,
        _column_74,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape15 assetFaceEntity = Shape15(
    source: i0.VersionedTable(
      entityName: 'asset_face_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_36,
        _column_76,
        _column_77,
        _column_78,
        _column_79,
        _column_80,
        _column_81,
        _column_82,
        _column_83,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
}

class Shape17 extends i0.VersionedTable {
  Shape17({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get type =>
      columnsByName['type']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<DateTime> get createdAt =>
      columnsByName['created_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<DateTime> get updatedAt =>
      columnsByName['updated_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<int> get width =>
      columnsByName['width']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get height =>
      columnsByName['height']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get durationInSeconds =>
      columnsByName['duration_in_seconds']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get id =>
      columnsByName['id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get checksum =>
      columnsByName['checksum']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get isFavorite =>
      columnsByName['is_favorite']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get ownerId =>
      columnsByName['owner_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get localDateTime =>
      columnsByName['local_date_time']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<String> get thumbHash =>
      columnsByName['thumb_hash']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get deletedAt =>
      columnsByName['deleted_at']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<String> get livePhotoVideoId =>
      columnsByName['live_photo_video_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get visibility =>
      columnsByName['visibility']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get stackId =>
      columnsByName['stack_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get libraryId =>
      columnsByName['library_id']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_86(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'library_id',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );

final class Schema7 extends i0.VersionedSchema {
  Schema7({required super.database}) : super(version: 7);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    userEntity,
    remoteAssetEntity,
    stackEntity,
    localAssetEntity,
    localAlbumEntity,
    localAlbumAssetEntity,
    idxLocalAssetChecksum,
    idxRemoteAssetOwnerChecksum,
    uQRemoteAssetsOwnerChecksum,
    uQRemoteAssetsOwnerLibraryChecksum,
    idxRemoteAssetChecksum,
    userMetadataEntity,
    partnerEntity,
    remoteExifEntity,
    remoteAlbumEntity,
    remoteAlbumAssetEntity,
    remoteAlbumUserEntity,
    memoryEntity,
    memoryAssetEntity,
    personEntity,
    assetFaceEntity,
    idxLatLng,
  ];
  late final Shape16 userEntity = Shape16(
    source: i0.VersionedTable(
      entityName: 'user_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_1,
        _column_2,
        _column_3,
        _column_84,
        _column_85,
        _column_5,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape17 remoteAssetEntity = Shape17(
    source: i0.VersionedTable(
      entityName: 'remote_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_1,
        _column_8,
        _column_9,
        _column_5,
        _column_10,
        _column_11,
        _column_12,
        _column_0,
        _column_13,
        _column_14,
        _column_15,
        _column_16,
        _column_17,
        _column_18,
        _column_19,
        _column_20,
        _column_21,
        _column_86,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape3 stackEntity = Shape3(
    source: i0.VersionedTable(
      entityName: 'stack_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [_column_0, _column_9, _column_5, _column_15, _column_75],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape2 localAssetEntity = Shape2(
    source: i0.VersionedTable(
      entityName: 'local_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_1,
        _column_8,
        _column_9,
        _column_5,
        _column_10,
        _column_11,
        _column_12,
        _column_0,
        _column_22,
        _column_14,
        _column_23,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape6 localAlbumEntity = Shape6(
    source: i0.VersionedTable(
      entityName: 'local_album_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_1,
        _column_5,
        _column_31,
        _column_32,
        _column_33,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape7 localAlbumAssetEntity = Shape7(
    source: i0.VersionedTable(
      entityName: 'local_album_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id, album_id)'],
      columns: [_column_34, _column_35],
      attachedDatabase: database,
    ),
    alias: null,
  );
  final i1.Index idxLocalAssetChecksum = i1.Index(
    'idx_local_asset_checksum',
    'CREATE INDEX IF NOT EXISTS idx_local_asset_checksum ON local_asset_entity (checksum)',
  );
  final i1.Index idxRemoteAssetOwnerChecksum = i1.Index(
    'idx_remote_asset_owner_checksum',
    'CREATE INDEX IF NOT EXISTS idx_remote_asset_owner_checksum ON remote_asset_entity (owner_id, checksum)',
  );
  final i1.Index uQRemoteAssetsOwnerChecksum = i1.Index(
    'UQ_remote_assets_owner_checksum',
    'CREATE UNIQUE INDEX IF NOT EXISTS UQ_remote_assets_owner_checksum ON remote_asset_entity (owner_id, checksum) WHERE(library_id IS NULL)',
  );
  final i1.Index uQRemoteAssetsOwnerLibraryChecksum = i1.Index(
    'UQ_remote_assets_owner_library_checksum',
    'CREATE UNIQUE INDEX IF NOT EXISTS UQ_remote_assets_owner_library_checksum ON remote_asset_entity (owner_id, library_id, checksum) WHERE(library_id IS NOT NULL)',
  );
  final i1.Index idxRemoteAssetChecksum = i1.Index(
    'idx_remote_asset_checksum',
    'CREATE INDEX IF NOT EXISTS idx_remote_asset_checksum ON remote_asset_entity (checksum)',
  );
  late final Shape4 userMetadataEntity = Shape4(
    source: i0.VersionedTable(
      entityName: 'user_metadata_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(user_id, "key")'],
      columns: [_column_25, _column_26, _column_27],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape5 partnerEntity = Shape5(
    source: i0.VersionedTable(
      entityName: 'partner_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(shared_by_id, shared_with_id)'],
      columns: [_column_28, _column_29, _column_30],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape8 remoteExifEntity = Shape8(
    source: i0.VersionedTable(
      entityName: 'remote_exif_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id)'],
      columns: [
        _column_36,
        _column_37,
        _column_38,
        _column_39,
        _column_40,
        _column_41,
        _column_11,
        _column_10,
        _column_42,
        _column_43,
        _column_44,
        _column_45,
        _column_46,
        _column_47,
        _column_48,
        _column_49,
        _column_50,
        _column_51,
        _column_52,
        _column_53,
        _column_54,
        _column_55,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape9 remoteAlbumEntity = Shape9(
    source: i0.VersionedTable(
      entityName: 'remote_album_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_1,
        _column_56,
        _column_9,
        _column_5,
        _column_15,
        _column_57,
        _column_58,
        _column_59,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape7 remoteAlbumAssetEntity = Shape7(
    source: i0.VersionedTable(
      entityName: 'remote_album_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id, album_id)'],
      columns: [_column_36, _column_60],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape10 remoteAlbumUserEntity = Shape10(
    source: i0.VersionedTable(
      entityName: 'remote_album_user_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(album_id, user_id)'],
      columns: [_column_60, _column_25, _column_61],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape11 memoryEntity = Shape11(
    source: i0.VersionedTable(
      entityName: 'memory_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_9,
        _column_5,
        _column_18,
        _column_15,
        _column_8,
        _column_62,
        _column_63,
        _column_64,
        _column_65,
        _column_66,
        _column_67,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape12 memoryAssetEntity = Shape12(
    source: i0.VersionedTable(
      entityName: 'memory_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id, memory_id)'],
      columns: [_column_36, _column_68],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape14 personEntity = Shape14(
    source: i0.VersionedTable(
      entityName: 'person_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_9,
        _column_5,
        _column_15,
        _column_1,
        _column_69,
        _column_71,
        _column_72,
        _column_73,
        _column_74,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape15 assetFaceEntity = Shape15(
    source: i0.VersionedTable(
      entityName: 'asset_face_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_36,
        _column_76,
        _column_77,
        _column_78,
        _column_79,
        _column_80,
        _column_81,
        _column_82,
        _column_83,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  final i1.Index idxLatLng = i1.Index(
    'idx_lat_lng',
    'CREATE INDEX IF NOT EXISTS idx_lat_lng ON remote_exif_entity (latitude, longitude)',
  );
}

final class Schema8 extends i0.VersionedSchema {
  Schema8({required super.database}) : super(version: 8);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    userEntity,
    remoteAssetEntity,
    stackEntity,
    localAssetEntity,
    localAlbumEntity,
    localAlbumAssetEntity,
    idxLocalAssetChecksum,
    idxRemoteAssetOwnerChecksum,
    uQRemoteAssetsOwnerChecksum,
    uQRemoteAssetsOwnerLibraryChecksum,
    idxRemoteAssetChecksum,
    userMetadataEntity,
    partnerEntity,
    remoteExifEntity,
    remoteAlbumEntity,
    remoteAlbumAssetEntity,
    remoteAlbumUserEntity,
    memoryEntity,
    memoryAssetEntity,
    personEntity,
    assetFaceEntity,
    storeEntity,
    idxLatLng,
  ];
  late final Shape16 userEntity = Shape16(
    source: i0.VersionedTable(
      entityName: 'user_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_1,
        _column_2,
        _column_3,
        _column_84,
        _column_85,
        _column_5,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape17 remoteAssetEntity = Shape17(
    source: i0.VersionedTable(
      entityName: 'remote_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_1,
        _column_8,
        _column_9,
        _column_5,
        _column_10,
        _column_11,
        _column_12,
        _column_0,
        _column_13,
        _column_14,
        _column_15,
        _column_16,
        _column_17,
        _column_18,
        _column_19,
        _column_20,
        _column_21,
        _column_86,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape3 stackEntity = Shape3(
    source: i0.VersionedTable(
      entityName: 'stack_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [_column_0, _column_9, _column_5, _column_15, _column_75],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape2 localAssetEntity = Shape2(
    source: i0.VersionedTable(
      entityName: 'local_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_1,
        _column_8,
        _column_9,
        _column_5,
        _column_10,
        _column_11,
        _column_12,
        _column_0,
        _column_22,
        _column_14,
        _column_23,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape6 localAlbumEntity = Shape6(
    source: i0.VersionedTable(
      entityName: 'local_album_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_1,
        _column_5,
        _column_31,
        _column_32,
        _column_33,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape7 localAlbumAssetEntity = Shape7(
    source: i0.VersionedTable(
      entityName: 'local_album_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id, album_id)'],
      columns: [_column_34, _column_35],
      attachedDatabase: database,
    ),
    alias: null,
  );
  final i1.Index idxLocalAssetChecksum = i1.Index(
    'idx_local_asset_checksum',
    'CREATE INDEX IF NOT EXISTS idx_local_asset_checksum ON local_asset_entity (checksum)',
  );
  final i1.Index idxRemoteAssetOwnerChecksum = i1.Index(
    'idx_remote_asset_owner_checksum',
    'CREATE INDEX IF NOT EXISTS idx_remote_asset_owner_checksum ON remote_asset_entity (owner_id, checksum)',
  );
  final i1.Index uQRemoteAssetsOwnerChecksum = i1.Index(
    'UQ_remote_assets_owner_checksum',
    'CREATE UNIQUE INDEX IF NOT EXISTS UQ_remote_assets_owner_checksum ON remote_asset_entity (owner_id, checksum) WHERE(library_id IS NULL)',
  );
  final i1.Index uQRemoteAssetsOwnerLibraryChecksum = i1.Index(
    'UQ_remote_assets_owner_library_checksum',
    'CREATE UNIQUE INDEX IF NOT EXISTS UQ_remote_assets_owner_library_checksum ON remote_asset_entity (owner_id, library_id, checksum) WHERE(library_id IS NOT NULL)',
  );
  final i1.Index idxRemoteAssetChecksum = i1.Index(
    'idx_remote_asset_checksum',
    'CREATE INDEX IF NOT EXISTS idx_remote_asset_checksum ON remote_asset_entity (checksum)',
  );
  late final Shape4 userMetadataEntity = Shape4(
    source: i0.VersionedTable(
      entityName: 'user_metadata_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(user_id, "key")'],
      columns: [_column_25, _column_26, _column_27],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape5 partnerEntity = Shape5(
    source: i0.VersionedTable(
      entityName: 'partner_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(shared_by_id, shared_with_id)'],
      columns: [_column_28, _column_29, _column_30],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape8 remoteExifEntity = Shape8(
    source: i0.VersionedTable(
      entityName: 'remote_exif_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id)'],
      columns: [
        _column_36,
        _column_37,
        _column_38,
        _column_39,
        _column_40,
        _column_41,
        _column_11,
        _column_10,
        _column_42,
        _column_43,
        _column_44,
        _column_45,
        _column_46,
        _column_47,
        _column_48,
        _column_49,
        _column_50,
        _column_51,
        _column_52,
        _column_53,
        _column_54,
        _column_55,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape9 remoteAlbumEntity = Shape9(
    source: i0.VersionedTable(
      entityName: 'remote_album_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_1,
        _column_56,
        _column_9,
        _column_5,
        _column_15,
        _column_57,
        _column_58,
        _column_59,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape7 remoteAlbumAssetEntity = Shape7(
    source: i0.VersionedTable(
      entityName: 'remote_album_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id, album_id)'],
      columns: [_column_36, _column_60],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape10 remoteAlbumUserEntity = Shape10(
    source: i0.VersionedTable(
      entityName: 'remote_album_user_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(album_id, user_id)'],
      columns: [_column_60, _column_25, _column_61],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape11 memoryEntity = Shape11(
    source: i0.VersionedTable(
      entityName: 'memory_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_9,
        _column_5,
        _column_18,
        _column_15,
        _column_8,
        _column_62,
        _column_63,
        _column_64,
        _column_65,
        _column_66,
        _column_67,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape12 memoryAssetEntity = Shape12(
    source: i0.VersionedTable(
      entityName: 'memory_asset_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(asset_id, memory_id)'],
      columns: [_column_36, _column_68],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape14 personEntity = Shape14(
    source: i0.VersionedTable(
      entityName: 'person_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_9,
        _column_5,
        _column_15,
        _column_1,
        _column_69,
        _column_71,
        _column_72,
        _column_73,
        _column_74,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape15 assetFaceEntity = Shape15(
    source: i0.VersionedTable(
      entityName: 'asset_face_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [
        _column_0,
        _column_36,
        _column_76,
        _column_77,
        _column_78,
        _column_79,
        _column_80,
        _column_81,
        _column_82,
        _column_83,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape18 storeEntity = Shape18(
    source: i0.VersionedTable(
      entityName: 'store_entity',
      withoutRowId: true,
      isStrict: true,
      tableConstraints: ['PRIMARY KEY(id)'],
      columns: [_column_87, _column_88, _column_89],
      attachedDatabase: database,
    ),
    alias: null,
  );
  final i1.Index idxLatLng = i1.Index(
    'idx_lat_lng',
    'CREATE INDEX IF NOT EXISTS idx_lat_lng ON remote_exif_entity (latitude, longitude)',
  );
}

class Shape18 extends i0.VersionedTable {
  Shape18({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get stringValue =>
      columnsByName['string_value']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get intValue =>
      columnsByName['int_value']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<int> _column_87(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'id',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<String> _column_88(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'string_value',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<int> _column_89(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'int_value',
      aliasedName,
      true,
      type: i1.DriftSqlType.int,
    );
i0.MigrationStepWithVersion migrationSteps({
  required Future<void> Function(i1.Migrator m, Schema2 schema) from1To2,
  required Future<void> Function(i1.Migrator m, Schema3 schema) from2To3,
  required Future<void> Function(i1.Migrator m, Schema4 schema) from3To4,
  required Future<void> Function(i1.Migrator m, Schema5 schema) from4To5,
  required Future<void> Function(i1.Migrator m, Schema6 schema) from5To6,
  required Future<void> Function(i1.Migrator m, Schema7 schema) from6To7,
  required Future<void> Function(i1.Migrator m, Schema8 schema) from7To8,
}) {
  return (currentVersion, database) async {
    switch (currentVersion) {
      case 1:
        final schema = Schema2(database: database);
        final migrator = i1.Migrator(database, schema);
        await from1To2(migrator, schema);
        return 2;
      case 2:
        final schema = Schema3(database: database);
        final migrator = i1.Migrator(database, schema);
        await from2To3(migrator, schema);
        return 3;
      case 3:
        final schema = Schema4(database: database);
        final migrator = i1.Migrator(database, schema);
        await from3To4(migrator, schema);
        return 4;
      case 4:
        final schema = Schema5(database: database);
        final migrator = i1.Migrator(database, schema);
        await from4To5(migrator, schema);
        return 5;
      case 5:
        final schema = Schema6(database: database);
        final migrator = i1.Migrator(database, schema);
        await from5To6(migrator, schema);
        return 6;
      case 6:
        final schema = Schema7(database: database);
        final migrator = i1.Migrator(database, schema);
        await from6To7(migrator, schema);
        return 7;
      case 7:
        final schema = Schema8(database: database);
        final migrator = i1.Migrator(database, schema);
        await from7To8(migrator, schema);
        return 8;
      default:
        throw ArgumentError.value('Unknown migration from $currentVersion');
    }
  };
}

i1.OnUpgrade stepByStep({
  required Future<void> Function(i1.Migrator m, Schema2 schema) from1To2,
  required Future<void> Function(i1.Migrator m, Schema3 schema) from2To3,
  required Future<void> Function(i1.Migrator m, Schema4 schema) from3To4,
  required Future<void> Function(i1.Migrator m, Schema5 schema) from4To5,
  required Future<void> Function(i1.Migrator m, Schema6 schema) from5To6,
  required Future<void> Function(i1.Migrator m, Schema7 schema) from6To7,
  required Future<void> Function(i1.Migrator m, Schema8 schema) from7To8,
}) => i0.VersionedSchema.stepByStepHelper(
  step: migrationSteps(
    from1To2: from1To2,
    from2To3: from2To3,
    from3To4: from3To4,
    from4To5: from4To5,
    from5To6: from5To6,
    from6To7: from6To7,
    from7To8: from7To8,
  ),
);
