// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// Autogenerated from Pigeon, do not edit directly.
// See also: https://pub.dev/packages/pigeon

import Foundation

#if os(iOS)
  import Flutter
#elseif os(macOS)
  import FlutterMacOS
#else
  #error("Unsupported platform.")
#endif

/// Error class for passing custom error details to Dart side.
final class ProxyApiTestsError: Error {
  let code: String
  let message: String?
  let details: Sendable?

  init(code: String, message: String?, details: Sendable?) {
    self.code = code
    self.message = message
    self.details = details
  }

  var localizedDescription: String {
    return
      "ProxyApiTestsError(code: \(code), message: \(message ?? "<nil>"), details: \(details ?? "<nil>")"
  }
}

private func wrapResult(_ result: Any?) -> [Any?] {
  return [result]
}

private func wrapError(_ error: Any) -> [Any?] {
  if let pigeonError = error as? ProxyApiTestsError {
    return [
      pigeonError.code,
      pigeonError.message,
      pigeonError.details,
    ]
  }
  if let flutterError = error as? FlutterError {
    return [
      flutterError.code,
      flutterError.message,
      flutterError.details,
    ]
  }
  return [
    "\(error)",
    "\(type(of: error))",
    "Stacktrace: \(Thread.callStackSymbols)",
  ]
}

private func createConnectionError(withChannelName channelName: String) -> ProxyApiTestsError {
  return ProxyApiTestsError(
    code: "channel-error", message: "Unable to establish connection on channel: '\(channelName)'.",
    details: "")
}

private func isNullish(_ value: Any?) -> Bool {
  return value is NSNull || value == nil
}

private func nilOrValue<T>(_ value: Any?) -> T? {
  if value is NSNull { return nil }
  return value as! T?
}

/// Handles the callback when an object is deallocated.
protocol ProxyApiTestsPigeonInternalFinalizerDelegate: AnyObject {
  /// Invoked when the strong reference of an object is deallocated in an `InstanceManager`.
  func onDeinit(identifier: Int64)
}

// Attaches to an object to receive a callback when the object is deallocated.
internal final class ProxyApiTestsPigeonInternalFinalizer {
  internal static let associatedObjectKey = malloc(1)!

  private let identifier: Int64
  // Reference to the delegate is weak because the callback should be ignored if the
  // `InstanceManager` is deallocated.
  internal weak var delegate: ProxyApiTestsPigeonInternalFinalizerDelegate?

  private init(identifier: Int64, delegate: ProxyApiTestsPigeonInternalFinalizerDelegate) {
    self.identifier = identifier
    self.delegate = delegate
  }

  internal static func attach(
    to instance: AnyObject, identifier: Int64,
    delegate: ProxyApiTestsPigeonInternalFinalizerDelegate
  ) {
    let finalizer = ProxyApiTestsPigeonInternalFinalizer(identifier: identifier, delegate: delegate)
    objc_setAssociatedObject(instance, associatedObjectKey, finalizer, .OBJC_ASSOCIATION_RETAIN)
  }

  static func detach(from instance: AnyObject) {
    let finalizer =
      objc_getAssociatedObject(instance, associatedObjectKey)
      as? ProxyApiTestsPigeonInternalFinalizer
    if let finalizer = finalizer {
      finalizer.delegate = nil
      objc_setAssociatedObject(instance, associatedObjectKey, nil, .OBJC_ASSOCIATION_ASSIGN)
    }
  }

  deinit {
    delegate?.onDeinit(identifier: identifier)
  }
}

/// Maintains instances used to communicate with the corresponding objects in Dart.
///
/// Objects stored in this container are represented by an object in Dart that is also stored in
/// an InstanceManager with the same identifier.
///
/// When an instance is added with an identifier, either can be used to retrieve the other.
///
/// Added instances are added as a weak reference and a strong reference. When the strong
/// reference is removed and the weak reference is deallocated,`ProxyApiTestsPigeonInternalFinalizerDelegate.onDeinit`
/// is called with the instance's identifier. However, if the strong reference is removed and then the identifier is
/// retrieved with the intention to pass the identifier to Dart (e.g. by calling `identifierWithStrongReference`),
/// the strong reference to the instance is re-added. The strong reference will then need to be removed manually
/// again.
///
/// Accessing and inserting to an InstanceManager is thread safe.
final class ProxyApiTestsPigeonInstanceManager {
  // Identifiers are locked to a specific range to avoid collisions with objects
  // created simultaneously from Dart.
  // Host uses identifiers >= 2^16 and Dart is expected to use values n where,
  // 0 <= n < 2^16.
  private static let minHostCreatedIdentifier: Int64 = 65536

  private let lockQueue = DispatchQueue(label: "ProxyApiTestsPigeonInstanceManager")
  private let identifiers: NSMapTable<AnyObject, NSNumber> = NSMapTable(
    keyOptions: [.weakMemory, .objectPointerPersonality], valueOptions: .strongMemory)
  private let weakInstances: NSMapTable<NSNumber, AnyObject> = NSMapTable(
    keyOptions: .strongMemory, valueOptions: [.weakMemory, .objectPointerPersonality])
  private let strongInstances: NSMapTable<NSNumber, AnyObject> = NSMapTable(
    keyOptions: .strongMemory, valueOptions: [.strongMemory, .objectPointerPersonality])
  private let finalizerDelegate: ProxyApiTestsPigeonInternalFinalizerDelegate
  private var nextIdentifier: Int64 = minHostCreatedIdentifier

  public init(finalizerDelegate: ProxyApiTestsPigeonInternalFinalizerDelegate) {
    self.finalizerDelegate = finalizerDelegate
  }

  /// Adds a new instance that was instantiated from Dart.
  ///
  /// The same instance can be added multiple times, but each identifier must be unique. This allows
  /// two objects that are equivalent (e.g. conforms to `Equatable`)  to both be added.
  ///
  /// - Parameters:
  ///   - instance: the instance to be stored
  ///   - identifier: the identifier to be paired with instance. This value must be >= 0 and unique
  func addDartCreatedInstance(_ instance: AnyObject, withIdentifier identifier: Int64) {
    lockQueue.async {
      self.addInstance(instance, withIdentifier: identifier)
    }
  }

  /// Adds a new instance that was instantiated from the host platform.
  ///
  /// - Parameters:
  ///   - instance: the instance to be stored. This must be unique to all other added instances.
  /// - Returns: the unique identifier (>= 0) stored with instance
  func addHostCreatedInstance(_ instance: AnyObject) -> Int64 {
    assert(!containsInstance(instance), "Instance of \(instance) has already been added.")
    var identifier: Int64 = -1
    lockQueue.sync {
      identifier = nextIdentifier
      nextIdentifier += 1
      self.addInstance(instance, withIdentifier: identifier)
    }
    return identifier
  }

  /// Removes `instanceIdentifier` and its associated strongly referenced instance, if present, from the manager.
  ///
  /// - Parameters:
  ///   - instanceIdentifier: the identifier paired to an instance.
  /// - Returns: removed instance if the manager contains the given identifier, otherwise `nil` if
  ///   the manager doesn't contain the value
  func removeInstance<T: AnyObject>(withIdentifier instanceIdentifier: Int64) throws -> T? {
    var instance: AnyObject? = nil
    lockQueue.sync {
      instance = strongInstances.object(forKey: NSNumber(value: instanceIdentifier))
      strongInstances.removeObject(forKey: NSNumber(value: instanceIdentifier))
    }
    return instance as? T
  }

  /// Retrieves the instance associated with identifier.
  ///
  /// - Parameters:
  ///   - instanceIdentifier: the identifier associated with an instance
  /// - Returns: the instance associated with `instanceIdentifier` if the manager contains the value, otherwise
  ///   `nil` if the manager doesn't contain the value
  func instance<T: AnyObject>(forIdentifier instanceIdentifier: Int64) -> T? {
    var instance: AnyObject? = nil
    lockQueue.sync {
      instance = weakInstances.object(forKey: NSNumber(value: instanceIdentifier))
    }
    return instance as? T
  }

  private func addInstance(_ instance: AnyObject, withIdentifier identifier: Int64) {
    assert(identifier >= 0)
    assert(
      weakInstances.object(forKey: identifier as NSNumber) == nil,
      "Identifier has already been added: \(identifier)")
    identifiers.setObject(NSNumber(value: identifier), forKey: instance)
    weakInstances.setObject(instance, forKey: NSNumber(value: identifier))
    strongInstances.setObject(instance, forKey: NSNumber(value: identifier))
    ProxyApiTestsPigeonInternalFinalizer.attach(
      to: instance, identifier: identifier, delegate: finalizerDelegate)
  }

  /// Retrieves the identifier paired with an instance.
  ///
  /// If the manager contains a strong reference to `instance`, it will return the identifier
  /// associated with `instance`. If the manager contains only a weak reference to `instance`, a new
  /// strong reference to `instance` will be added and will need to be removed again with `removeInstance`.
  ///
  /// If this method returns a nonnull identifier, this method also expects the Dart
  /// `ProxyApiTestsPigeonInstanceManager` to have, or recreate, a weak reference to the Dart instance the
  /// identifier is associated with.
  ///
  /// - Parameters:
  ///   - instance: an instance that may be stored in the manager
  /// - Returns: the identifier associated with `instance` if the manager contains the value, otherwise
  ///   `nil` if the manager doesn't contain the value
  func identifierWithStrongReference(forInstance instance: AnyObject) -> Int64? {
    var identifier: Int64? = nil
    lockQueue.sync {
      if let existingIdentifier = identifiers.object(forKey: instance)?.int64Value {
        strongInstances.setObject(instance, forKey: NSNumber(value: existingIdentifier))
        identifier = existingIdentifier
      }
    }
    return identifier
  }

  /// Whether this manager contains the given `instance`.
  ///
  /// - Parameters:
  ///   - instance: the instance whose presence in this manager is to be tested
  /// - Returns: whether this manager contains the given `instance`
  func containsInstance(_ instance: AnyObject) -> Bool {
    var containsInstance = false
    lockQueue.sync {
      containsInstance = identifiers.object(forKey: instance) != nil
    }
    return containsInstance
  }

  /// Removes all of the instances from this manager.
  ///
  /// The manager will be empty after this call returns.
  func removeAllObjects() throws {
    lockQueue.sync {
      let weakInstancesEnumerator = weakInstances.objectEnumerator()!
      while let instance = weakInstancesEnumerator.nextObject() {
        ProxyApiTestsPigeonInternalFinalizer.detach(from: instance as AnyObject)
      }
      identifiers.removeAllObjects()
      weakInstances.removeAllObjects()
      strongInstances.removeAllObjects()
      nextIdentifier = ProxyApiTestsPigeonInstanceManager.minHostCreatedIdentifier
    }
  }

  /// The number of instances stored as a strong reference.
  ///
  /// For debugging and testing purposes.
  internal var strongInstanceCount: Int {
    var count: Int = 0
    lockQueue.sync {
      count = strongInstances.count
    }
    return count
  }

  /// The number of instances stored as a weak reference.
  ///
  /// For debugging and testing purposes. NSMapTables that store keys or objects as weak
  /// reference will be reclaimed non-deterministically.
  internal var weakInstanceCount: Int {
    var count: Int = 0
    lockQueue.sync {
      count = weakInstances.count
    }
    return count
  }
}

private class ProxyApiTestsPigeonInstanceManagerApi {
  /// The codec used for serializing messages.
  var codec: FlutterStandardMessageCodec { ProxyApiTestsPigeonCodec.shared }

  /// Handles sending and receiving messages with Dart.
  unowned let binaryMessenger: FlutterBinaryMessenger

  init(binaryMessenger: FlutterBinaryMessenger) {
    self.binaryMessenger = binaryMessenger
  }

  /// Sets up an instance of `ProxyApiTestsPigeonInstanceManagerApi` to handle messages through the `binaryMessenger`.
  static func setUpMessageHandlers(
    binaryMessenger: FlutterBinaryMessenger, instanceManager: ProxyApiTestsPigeonInstanceManager?
  ) {
    let codec = ProxyApiTestsPigeonCodec.shared
    let removeStrongReferenceChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.PigeonInternalInstanceManager.removeStrongReference",
      binaryMessenger: binaryMessenger, codec: codec)
    if let instanceManager = instanceManager {
      removeStrongReferenceChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let identifierArg = args[0] as! Int64
        do {
          let _: AnyObject? = try instanceManager.removeInstance(withIdentifier: identifierArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      removeStrongReferenceChannel.setMessageHandler(nil)
    }
    let clearChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.PigeonInternalInstanceManager.clear",
      binaryMessenger: binaryMessenger, codec: codec)
    if let instanceManager = instanceManager {
      clearChannel.setMessageHandler { _, reply in
        do {
          try instanceManager.removeAllObjects()
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      clearChannel.setMessageHandler(nil)
    }
  }

  /// Sends a message to the Dart `InstanceManager` to remove the strong reference of the instance associated with `identifier`.
  func removeStrongReference(
    identifier identifierArg: Int64,
    completion: @escaping (Result<Void, ProxyApiTestsError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.PigeonInternalInstanceManager.removeStrongReference"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([identifierArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else {
        completion(.success(()))
      }
    }
  }
}
protocol ProxyApiTestsPigeonProxyApiDelegate {
  /// An implementation of [PigeonApiProxyApiTestClass] used to add a new Dart instance of
  /// `ProxyApiTestClass` to the Dart `InstanceManager` and make calls to Dart.
  func pigeonApiProxyApiTestClass(_ registrar: ProxyApiTestsPigeonProxyApiRegistrar)
    -> PigeonApiProxyApiTestClass
  /// An implementation of [PigeonApiProxyApiSuperClass] used to add a new Dart instance of
  /// `ProxyApiSuperClass` to the Dart `InstanceManager` and make calls to Dart.
  func pigeonApiProxyApiSuperClass(_ registrar: ProxyApiTestsPigeonProxyApiRegistrar)
    -> PigeonApiProxyApiSuperClass
  /// An implementation of [PigeonApiProxyApiInterface] used to add a new Dart instance of
  /// `ProxyApiInterface` to the Dart `InstanceManager` and make calls to Dart.
  func pigeonApiProxyApiInterface(_ registrar: ProxyApiTestsPigeonProxyApiRegistrar)
    -> PigeonApiProxyApiInterface
  /// An implementation of [PigeonApiClassWithApiRequirement] used to add a new Dart instance of
  /// `ClassWithApiRequirement` to the Dart `InstanceManager` and make calls to Dart.
  func pigeonApiClassWithApiRequirement(_ registrar: ProxyApiTestsPigeonProxyApiRegistrar)
    -> PigeonApiClassWithApiRequirement
}

extension ProxyApiTestsPigeonProxyApiDelegate {
  func pigeonApiProxyApiInterface(_ registrar: ProxyApiTestsPigeonProxyApiRegistrar)
    -> PigeonApiProxyApiInterface
  {
    return PigeonApiProxyApiInterface(
      pigeonRegistrar: registrar, delegate: PigeonApiDelegateProxyApiInterface())
  }
}

open class ProxyApiTestsPigeonProxyApiRegistrar {
  let binaryMessenger: FlutterBinaryMessenger
  let apiDelegate: ProxyApiTestsPigeonProxyApiDelegate
  let instanceManager: ProxyApiTestsPigeonInstanceManager
  /// Whether APIs should ignore calling to Dart.
  public var ignoreCallsToDart = false
  private var _codec: FlutterStandardMessageCodec?
  var codec: FlutterStandardMessageCodec {
    if _codec == nil {
      _codec = FlutterStandardMessageCodec(
        readerWriter: ProxyApiTestsPigeonInternalProxyApiCodecReaderWriter(pigeonRegistrar: self))
    }
    return _codec!
  }

  private class InstanceManagerApiFinalizerDelegate: ProxyApiTestsPigeonInternalFinalizerDelegate {
    let api: ProxyApiTestsPigeonInstanceManagerApi

    init(_ api: ProxyApiTestsPigeonInstanceManagerApi) {
      self.api = api
    }

    public func onDeinit(identifier: Int64) {
      api.removeStrongReference(identifier: identifier) {
        _ in
      }
    }
  }

  init(binaryMessenger: FlutterBinaryMessenger, apiDelegate: ProxyApiTestsPigeonProxyApiDelegate) {
    self.binaryMessenger = binaryMessenger
    self.apiDelegate = apiDelegate
    self.instanceManager = ProxyApiTestsPigeonInstanceManager(
      finalizerDelegate: InstanceManagerApiFinalizerDelegate(
        ProxyApiTestsPigeonInstanceManagerApi(binaryMessenger: binaryMessenger)))
  }

  func setUp() {
    ProxyApiTestsPigeonInstanceManagerApi.setUpMessageHandlers(
      binaryMessenger: binaryMessenger, instanceManager: instanceManager)
    PigeonApiProxyApiTestClass.setUpMessageHandlers(
      binaryMessenger: binaryMessenger, api: apiDelegate.pigeonApiProxyApiTestClass(self))
    PigeonApiProxyApiSuperClass.setUpMessageHandlers(
      binaryMessenger: binaryMessenger, api: apiDelegate.pigeonApiProxyApiSuperClass(self))
    PigeonApiClassWithApiRequirement.setUpMessageHandlers(
      binaryMessenger: binaryMessenger, api: apiDelegate.pigeonApiClassWithApiRequirement(self))
  }
  func tearDown() {
    ProxyApiTestsPigeonInstanceManagerApi.setUpMessageHandlers(
      binaryMessenger: binaryMessenger, instanceManager: nil)
    PigeonApiProxyApiTestClass.setUpMessageHandlers(binaryMessenger: binaryMessenger, api: nil)
    PigeonApiProxyApiSuperClass.setUpMessageHandlers(binaryMessenger: binaryMessenger, api: nil)
    PigeonApiClassWithApiRequirement.setUpMessageHandlers(
      binaryMessenger: binaryMessenger, api: nil)
  }
}
private class ProxyApiTestsPigeonInternalProxyApiCodecReaderWriter: FlutterStandardReaderWriter {
  unowned let pigeonRegistrar: ProxyApiTestsPigeonProxyApiRegistrar

  private class ProxyApiTestsPigeonInternalProxyApiCodecReader: ProxyApiTestsPigeonCodecReader {
    unowned let pigeonRegistrar: ProxyApiTestsPigeonProxyApiRegistrar

    init(data: Data, pigeonRegistrar: ProxyApiTestsPigeonProxyApiRegistrar) {
      self.pigeonRegistrar = pigeonRegistrar
      super.init(data: data)
    }

    override func readValue(ofType type: UInt8) -> Any? {
      switch type {
      case 128:
        let identifier = self.readValue()
        let instance: AnyObject? = pigeonRegistrar.instanceManager.instance(
          forIdentifier: identifier is Int64 ? identifier as! Int64 : Int64(identifier as! Int32))
        if instance == nil {
          print("Failed to find instance with identifier: \(identifier!)")
        }
        return instance
      default:
        return super.readValue(ofType: type)
      }
    }
  }

  private class ProxyApiTestsPigeonInternalProxyApiCodecWriter: ProxyApiTestsPigeonCodecWriter {
    unowned let pigeonRegistrar: ProxyApiTestsPigeonProxyApiRegistrar

    init(data: NSMutableData, pigeonRegistrar: ProxyApiTestsPigeonProxyApiRegistrar) {
      self.pigeonRegistrar = pigeonRegistrar
      super.init(data: data)
    }

    override func writeValue(_ value: Any) {
      if value is [Any] || value is Bool || value is Data || value is [AnyHashable: Any]
        || value is Double || value is FlutterStandardTypedData || value is Int64 || value is String
        || value is ProxyApiTestEnum
      {
        super.writeValue(value)
        return
      }

      if let instance = value as? ProxyApiTestClass {
        pigeonRegistrar.apiDelegate.pigeonApiProxyApiTestClass(pigeonRegistrar).pigeonNewInstance(
          pigeonInstance: instance
        ) { _ in }
        super.writeByte(128)
        super.writeValue(
          pigeonRegistrar.instanceManager.identifierWithStrongReference(
            forInstance: instance as AnyObject)!)
        return
      }

      if let instance = value as? ProxyApiSuperClass {
        pigeonRegistrar.apiDelegate.pigeonApiProxyApiSuperClass(pigeonRegistrar).pigeonNewInstance(
          pigeonInstance: instance
        ) { _ in }
        super.writeByte(128)
        super.writeValue(
          pigeonRegistrar.instanceManager.identifierWithStrongReference(
            forInstance: instance as AnyObject)!)
        return
      }

      if let instance = value as? ProxyApiInterface {
        pigeonRegistrar.apiDelegate.pigeonApiProxyApiInterface(pigeonRegistrar).pigeonNewInstance(
          pigeonInstance: instance
        ) { _ in }
        super.writeByte(128)
        super.writeValue(
          pigeonRegistrar.instanceManager.identifierWithStrongReference(
            forInstance: instance as AnyObject)!)
        return
      }

      if #available(iOS 15.0.0, macOS 10.0.0, *), let instance = value as? ClassWithApiRequirement {
        pigeonRegistrar.apiDelegate.pigeonApiClassWithApiRequirement(pigeonRegistrar)
          .pigeonNewInstance(
            pigeonInstance: instance
          ) { _ in }
        super.writeByte(128)
        super.writeValue(
          pigeonRegistrar.instanceManager.identifierWithStrongReference(
            forInstance: instance as AnyObject)!)
        return
      }

      if let instance = value as AnyObject?,
        pigeonRegistrar.instanceManager.containsInstance(instance)
      {
        super.writeByte(128)
        super.writeValue(
          pigeonRegistrar.instanceManager.identifierWithStrongReference(forInstance: instance)!)
      } else {
        print("Unsupported value: \(value) of \(type(of: value))")
        assert(false, "Unsupported value for ProxyApiTestsPigeonInternalProxyApiCodecWriter")
      }

    }
  }

  init(pigeonRegistrar: ProxyApiTestsPigeonProxyApiRegistrar) {
    self.pigeonRegistrar = pigeonRegistrar
  }

  override func reader(with data: Data) -> FlutterStandardReader {
    return ProxyApiTestsPigeonInternalProxyApiCodecReader(
      data: data, pigeonRegistrar: pigeonRegistrar)
  }

  override func writer(with data: NSMutableData) -> FlutterStandardWriter {
    return ProxyApiTestsPigeonInternalProxyApiCodecWriter(
      data: data, pigeonRegistrar: pigeonRegistrar)
  }
}

enum ProxyApiTestEnum: Int {
  case one = 0
  case two = 1
  case three = 2
}

private class ProxyApiTestsPigeonCodecReader: FlutterStandardReader {
  override func readValue(ofType type: UInt8) -> Any? {
    switch type {
    case 129:
      let enumResultAsInt: Int? = nilOrValue(self.readValue() as! Int?)
      if let enumResultAsInt = enumResultAsInt {
        return ProxyApiTestEnum(rawValue: enumResultAsInt)
      }
      return nil
    default:
      return super.readValue(ofType: type)
    }
  }
}

private class ProxyApiTestsPigeonCodecWriter: FlutterStandardWriter {
  override func writeValue(_ value: Any) {
    if let value = value as? ProxyApiTestEnum {
      super.writeByte(129)
      super.writeValue(value.rawValue)
    } else {
      super.writeValue(value)
    }
  }
}

private class ProxyApiTestsPigeonCodecReaderWriter: FlutterStandardReaderWriter {
  override func reader(with data: Data) -> FlutterStandardReader {
    return ProxyApiTestsPigeonCodecReader(data: data)
  }

  override func writer(with data: NSMutableData) -> FlutterStandardWriter {
    return ProxyApiTestsPigeonCodecWriter(data: data)
  }
}

class ProxyApiTestsPigeonCodec: FlutterStandardMessageCodec, @unchecked Sendable {
  static let shared = ProxyApiTestsPigeonCodec(readerWriter: ProxyApiTestsPigeonCodecReaderWriter())
}

protocol PigeonApiDelegateProxyApiTestClass {
  func pigeonDefaultConstructor(
    pigeonApi: PigeonApiProxyApiTestClass, aBool: Bool, anInt: Int64, aDouble: Double,
    aString: String, aUint8List: FlutterStandardTypedData, aList: [Any?], aMap: [String?: Any?],
    anEnum: ProxyApiTestEnum, aProxyApi: ProxyApiSuperClass, aNullableBool: Bool?,
    aNullableInt: Int64?, aNullableDouble: Double?, aNullableString: String?,
    aNullableUint8List: FlutterStandardTypedData?, aNullableList: [Any?]?,
    aNullableMap: [String?: Any?]?, aNullableEnum: ProxyApiTestEnum?,
    aNullableProxyApi: ProxyApiSuperClass?, boolParam: Bool, intParam: Int64, doubleParam: Double,
    stringParam: String, aUint8ListParam: FlutterStandardTypedData, listParam: [Any?],
    mapParam: [String?: Any?], enumParam: ProxyApiTestEnum, proxyApiParam: ProxyApiSuperClass,
    nullableBoolParam: Bool?, nullableIntParam: Int64?, nullableDoubleParam: Double?,
    nullableStringParam: String?, nullableUint8ListParam: FlutterStandardTypedData?,
    nullableListParam: [Any?]?, nullableMapParam: [String?: Any?]?,
    nullableEnumParam: ProxyApiTestEnum?, nullableProxyApiParam: ProxyApiSuperClass?
  ) throws -> ProxyApiTestClass
  func namedConstructor(
    pigeonApi: PigeonApiProxyApiTestClass, aBool: Bool, anInt: Int64, aDouble: Double,
    aString: String, aUint8List: FlutterStandardTypedData, aList: [Any?], aMap: [String?: Any?],
    anEnum: ProxyApiTestEnum, aProxyApi: ProxyApiSuperClass, aNullableBool: Bool?,
    aNullableInt: Int64?, aNullableDouble: Double?, aNullableString: String?,
    aNullableUint8List: FlutterStandardTypedData?, aNullableList: [Any?]?,
    aNullableMap: [String?: Any?]?, aNullableEnum: ProxyApiTestEnum?,
    aNullableProxyApi: ProxyApiSuperClass?
  ) throws -> ProxyApiTestClass
  func attachedField(pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass)
    throws -> ProxyApiSuperClass
  func staticAttachedField(pigeonApi: PigeonApiProxyApiTestClass) throws -> ProxyApiSuperClass
  /// A no-op function taking no arguments and returning no value, to sanity
  /// test basic calling.
  func noop(pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass) throws
  /// Returns an error, to test error handling.
  func throwError(pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass) throws
    -> Any?
  /// Returns an error from a void function, to test error handling.
  func throwErrorFromVoid(pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass)
    throws
  /// Returns a Flutter error, to test error handling.
  func throwFlutterError(pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass)
    throws -> Any?
  /// Returns passed in int.
  func echoInt(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, anInt: Int64
  ) throws -> Int64
  /// Returns passed in double.
  func echoDouble(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aDouble: Double
  ) throws -> Double
  /// Returns the passed in boolean.
  func echoBool(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aBool: Bool
  ) throws -> Bool
  /// Returns the passed in string.
  func echoString(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aString: String
  ) throws -> String
  /// Returns the passed in Uint8List.
  func echoUint8List(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    aUint8List: FlutterStandardTypedData
  ) throws -> FlutterStandardTypedData
  /// Returns the passed in generic Object.
  func echoObject(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, anObject: Any
  ) throws -> Any
  /// Returns the passed list, to test serialization and deserialization.
  func echoList(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aList: [Any?]
  ) throws -> [Any?]
  /// Returns the passed list with ProxyApis, to test serialization and
  /// deserialization.
  func echoProxyApiList(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    aList: [ProxyApiTestClass]
  ) throws -> [ProxyApiTestClass]
  /// Returns the passed map, to test serialization and deserialization.
  func echoMap(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aMap: [String?: Any?]
  ) throws -> [String?: Any?]
  /// Returns the passed map with ProxyApis, to test serialization and
  /// deserialization.
  func echoProxyApiMap(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    aMap: [String: ProxyApiTestClass]
  ) throws -> [String: ProxyApiTestClass]
  /// Returns the passed enum to test serialization and deserialization.
  func echoEnum(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    anEnum: ProxyApiTestEnum
  ) throws -> ProxyApiTestEnum
  /// Returns the passed ProxyApi to test serialization and deserialization.
  func echoProxyApi(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    aProxyApi: ProxyApiSuperClass
  ) throws -> ProxyApiSuperClass
  /// Returns passed in int.
  func echoNullableInt(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aNullableInt: Int64?
  ) throws -> Int64?
  /// Returns passed in double.
  func echoNullableDouble(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    aNullableDouble: Double?
  ) throws -> Double?
  /// Returns the passed in boolean.
  func echoNullableBool(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aNullableBool: Bool?
  ) throws -> Bool?
  /// Returns the passed in string.
  func echoNullableString(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    aNullableString: String?
  ) throws -> String?
  /// Returns the passed in Uint8List.
  func echoNullableUint8List(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    aNullableUint8List: FlutterStandardTypedData?
  ) throws -> FlutterStandardTypedData?
  /// Returns the passed in generic Object.
  func echoNullableObject(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aNullableObject: Any?
  ) throws -> Any?
  /// Returns the passed list, to test serialization and deserialization.
  func echoNullableList(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aNullableList: [Any?]?
  ) throws -> [Any?]?
  /// Returns the passed map, to test serialization and deserialization.
  func echoNullableMap(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    aNullableMap: [String?: Any?]?
  ) throws -> [String?: Any?]?
  func echoNullableEnum(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    aNullableEnum: ProxyApiTestEnum?
  ) throws -> ProxyApiTestEnum?
  /// Returns the passed ProxyApi to test serialization and deserialization.
  func echoNullableProxyApi(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    aNullableProxyApi: ProxyApiSuperClass?
  ) throws -> ProxyApiSuperClass?
  /// A no-op function taking no arguments and returning no value, to sanity
  /// test basic asynchronous calling.
  func noopAsync(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    completion: @escaping (Result<Void, Error>) -> Void)
  /// Returns passed in int asynchronously.
  func echoAsyncInt(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, anInt: Int64,
    completion: @escaping (Result<Int64, Error>) -> Void)
  /// Returns passed in double asynchronously.
  func echoAsyncDouble(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aDouble: Double,
    completion: @escaping (Result<Double, Error>) -> Void)
  /// Returns the passed in boolean asynchronously.
  func echoAsyncBool(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aBool: Bool,
    completion: @escaping (Result<Bool, Error>) -> Void)
  /// Returns the passed string asynchronously.
  func echoAsyncString(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aString: String,
    completion: @escaping (Result<String, Error>) -> Void)
  /// Returns the passed in Uint8List asynchronously.
  func echoAsyncUint8List(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    aUint8List: FlutterStandardTypedData,
    completion: @escaping (Result<FlutterStandardTypedData, Error>) -> Void)
  /// Returns the passed in generic Object asynchronously.
  func echoAsyncObject(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, anObject: Any,
    completion: @escaping (Result<Any, Error>) -> Void)
  /// Returns the passed list, to test asynchronous serialization and deserialization.
  func echoAsyncList(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aList: [Any?],
    completion: @escaping (Result<[Any?], Error>) -> Void)
  /// Returns the passed map, to test asynchronous serialization and deserialization.
  func echoAsyncMap(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aMap: [String?: Any?],
    completion: @escaping (Result<[String?: Any?], Error>) -> Void)
  /// Returns the passed enum, to test asynchronous serialization and deserialization.
  func echoAsyncEnum(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    anEnum: ProxyApiTestEnum, completion: @escaping (Result<ProxyApiTestEnum, Error>) -> Void)
  /// Responds with an error from an async function returning a value.
  func throwAsyncError(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    completion: @escaping (Result<Any?, Error>) -> Void)
  /// Responds with an error from an async void function.
  func throwAsyncErrorFromVoid(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    completion: @escaping (Result<Void, Error>) -> Void)
  /// Responds with a Flutter error from an async function returning a value.
  func throwAsyncFlutterError(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    completion: @escaping (Result<Any?, Error>) -> Void)
  /// Returns passed in int asynchronously.
  func echoAsyncNullableInt(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, anInt: Int64?,
    completion: @escaping (Result<Int64?, Error>) -> Void)
  /// Returns passed in double asynchronously.
  func echoAsyncNullableDouble(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aDouble: Double?,
    completion: @escaping (Result<Double?, Error>) -> Void)
  /// Returns the passed in boolean asynchronously.
  func echoAsyncNullableBool(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aBool: Bool?,
    completion: @escaping (Result<Bool?, Error>) -> Void)
  /// Returns the passed string asynchronously.
  func echoAsyncNullableString(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aString: String?,
    completion: @escaping (Result<String?, Error>) -> Void)
  /// Returns the passed in Uint8List asynchronously.
  func echoAsyncNullableUint8List(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    aUint8List: FlutterStandardTypedData?,
    completion: @escaping (Result<FlutterStandardTypedData?, Error>) -> Void)
  /// Returns the passed in generic Object asynchronously.
  func echoAsyncNullableObject(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, anObject: Any?,
    completion: @escaping (Result<Any?, Error>) -> Void)
  /// Returns the passed list, to test asynchronous serialization and deserialization.
  func echoAsyncNullableList(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aList: [Any?]?,
    completion: @escaping (Result<[Any?]?, Error>) -> Void)
  /// Returns the passed map, to test asynchronous serialization and deserialization.
  func echoAsyncNullableMap(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    aMap: [String?: Any?]?, completion: @escaping (Result<[String?: Any?]?, Error>) -> Void)
  /// Returns the passed enum, to test asynchronous serialization and deserialization.
  func echoAsyncNullableEnum(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    anEnum: ProxyApiTestEnum?, completion: @escaping (Result<ProxyApiTestEnum?, Error>) -> Void)
  func staticNoop(pigeonApi: PigeonApiProxyApiTestClass) throws
  func echoStaticString(pigeonApi: PigeonApiProxyApiTestClass, aString: String) throws -> String
  func staticAsyncNoop(
    pigeonApi: PigeonApiProxyApiTestClass, completion: @escaping (Result<Void, Error>) -> Void)
  func callFlutterNoop(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    completion: @escaping (Result<Void, Error>) -> Void)
  func callFlutterThrowError(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    completion: @escaping (Result<Any?, Error>) -> Void)
  func callFlutterThrowErrorFromVoid(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    completion: @escaping (Result<Void, Error>) -> Void)
  func callFlutterEchoBool(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aBool: Bool,
    completion: @escaping (Result<Bool, Error>) -> Void)
  func callFlutterEchoInt(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, anInt: Int64,
    completion: @escaping (Result<Int64, Error>) -> Void)
  func callFlutterEchoDouble(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aDouble: Double,
    completion: @escaping (Result<Double, Error>) -> Void)
  func callFlutterEchoString(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aString: String,
    completion: @escaping (Result<String, Error>) -> Void)
  func callFlutterEchoUint8List(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    aUint8List: FlutterStandardTypedData,
    completion: @escaping (Result<FlutterStandardTypedData, Error>) -> Void)
  func callFlutterEchoList(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aList: [Any?],
    completion: @escaping (Result<[Any?], Error>) -> Void)
  func callFlutterEchoProxyApiList(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    aList: [ProxyApiTestClass?], completion: @escaping (Result<[ProxyApiTestClass?], Error>) -> Void
  )
  func callFlutterEchoMap(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aMap: [String?: Any?],
    completion: @escaping (Result<[String?: Any?], Error>) -> Void)
  func callFlutterEchoProxyApiMap(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    aMap: [String?: ProxyApiTestClass?],
    completion: @escaping (Result<[String?: ProxyApiTestClass?], Error>) -> Void)
  func callFlutterEchoEnum(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    anEnum: ProxyApiTestEnum, completion: @escaping (Result<ProxyApiTestEnum, Error>) -> Void)
  func callFlutterEchoProxyApi(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    aProxyApi: ProxyApiSuperClass, completion: @escaping (Result<ProxyApiSuperClass, Error>) -> Void
  )
  func callFlutterEchoNullableBool(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aBool: Bool?,
    completion: @escaping (Result<Bool?, Error>) -> Void)
  func callFlutterEchoNullableInt(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, anInt: Int64?,
    completion: @escaping (Result<Int64?, Error>) -> Void)
  func callFlutterEchoNullableDouble(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aDouble: Double?,
    completion: @escaping (Result<Double?, Error>) -> Void)
  func callFlutterEchoNullableString(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aString: String?,
    completion: @escaping (Result<String?, Error>) -> Void)
  func callFlutterEchoNullableUint8List(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    aUint8List: FlutterStandardTypedData?,
    completion: @escaping (Result<FlutterStandardTypedData?, Error>) -> Void)
  func callFlutterEchoNullableList(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aList: [Any?]?,
    completion: @escaping (Result<[Any?]?, Error>) -> Void)
  func callFlutterEchoNullableMap(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    aMap: [String?: Any?]?, completion: @escaping (Result<[String?: Any?]?, Error>) -> Void)
  func callFlutterEchoNullableEnum(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    anEnum: ProxyApiTestEnum?, completion: @escaping (Result<ProxyApiTestEnum?, Error>) -> Void)
  func callFlutterEchoNullableProxyApi(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    aProxyApi: ProxyApiSuperClass?,
    completion: @escaping (Result<ProxyApiSuperClass?, Error>) -> Void)
  func callFlutterNoopAsync(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass,
    completion: @escaping (Result<Void, Error>) -> Void)
  func callFlutterEchoAsyncString(
    pigeonApi: PigeonApiProxyApiTestClass, pigeonInstance: ProxyApiTestClass, aString: String,
    completion: @escaping (Result<String, Error>) -> Void)
}

protocol PigeonApiProtocolProxyApiTestClass {
  /// A no-op function taking no arguments and returning no value, to sanity
  /// test basic calling.
  func flutterNoop(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass,
    completion: @escaping (Result<Void, ProxyApiTestsError>) -> Void)
  /// Responds with an error from an async function returning a value.
  func flutterThrowError(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass,
    completion: @escaping (Result<Any?, ProxyApiTestsError>) -> Void)
  /// Responds with an error from an async void function.
  func flutterThrowErrorFromVoid(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass,
    completion: @escaping (Result<Void, ProxyApiTestsError>) -> Void)
  /// Returns the passed boolean, to test serialization and deserialization.
  func flutterEchoBool(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aBool aBoolArg: Bool,
    completion: @escaping (Result<Bool, ProxyApiTestsError>) -> Void)
  /// Returns the passed int, to test serialization and deserialization.
  func flutterEchoInt(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, anInt anIntArg: Int64,
    completion: @escaping (Result<Int64, ProxyApiTestsError>) -> Void)
  /// Returns the passed double, to test serialization and deserialization.
  func flutterEchoDouble(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aDouble aDoubleArg: Double,
    completion: @escaping (Result<Double, ProxyApiTestsError>) -> Void)
  /// Returns the passed string, to test serialization and deserialization.
  func flutterEchoString(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aString aStringArg: String,
    completion: @escaping (Result<String, ProxyApiTestsError>) -> Void)
  /// Returns the passed byte list, to test serialization and deserialization.
  func flutterEchoUint8List(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aList aListArg: FlutterStandardTypedData,
    completion: @escaping (Result<FlutterStandardTypedData, ProxyApiTestsError>) -> Void)
  /// Returns the passed list, to test serialization and deserialization.
  func flutterEchoList(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aList aListArg: [Any?],
    completion: @escaping (Result<[Any?], ProxyApiTestsError>) -> Void)
  /// Returns the passed list with ProxyApis, to test serialization and
  /// deserialization.
  func flutterEchoProxyApiList(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aList aListArg: [ProxyApiTestClass?],
    completion: @escaping (Result<[ProxyApiTestClass?], ProxyApiTestsError>) -> Void)
  /// Returns the passed map, to test serialization and deserialization.
  func flutterEchoMap(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aMap aMapArg: [String?: Any?],
    completion: @escaping (Result<[String?: Any?], ProxyApiTestsError>) -> Void)
  /// Returns the passed map with ProxyApis, to test serialization and
  /// deserialization.
  func flutterEchoProxyApiMap(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass,
    aMap aMapArg: [String?: ProxyApiTestClass?],
    completion: @escaping (Result<[String?: ProxyApiTestClass?], ProxyApiTestsError>) -> Void)
  /// Returns the passed enum to test serialization and deserialization.
  func flutterEchoEnum(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, anEnum anEnumArg: ProxyApiTestEnum,
    completion: @escaping (Result<ProxyApiTestEnum, ProxyApiTestsError>) -> Void)
  /// Returns the passed ProxyApi to test serialization and deserialization.
  func flutterEchoProxyApi(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aProxyApi aProxyApiArg: ProxyApiSuperClass,
    completion: @escaping (Result<ProxyApiSuperClass, ProxyApiTestsError>) -> Void)
  /// Returns the passed boolean, to test serialization and deserialization.
  func flutterEchoNullableBool(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aBool aBoolArg: Bool?,
    completion: @escaping (Result<Bool?, ProxyApiTestsError>) -> Void)
  /// Returns the passed int, to test serialization and deserialization.
  func flutterEchoNullableInt(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, anInt anIntArg: Int64?,
    completion: @escaping (Result<Int64?, ProxyApiTestsError>) -> Void)
  /// Returns the passed double, to test serialization and deserialization.
  func flutterEchoNullableDouble(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aDouble aDoubleArg: Double?,
    completion: @escaping (Result<Double?, ProxyApiTestsError>) -> Void)
  /// Returns the passed string, to test serialization and deserialization.
  func flutterEchoNullableString(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aString aStringArg: String?,
    completion: @escaping (Result<String?, ProxyApiTestsError>) -> Void)
  /// Returns the passed byte list, to test serialization and deserialization.
  func flutterEchoNullableUint8List(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aList aListArg: FlutterStandardTypedData?,
    completion: @escaping (Result<FlutterStandardTypedData?, ProxyApiTestsError>) -> Void)
  /// Returns the passed list, to test serialization and deserialization.
  func flutterEchoNullableList(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aList aListArg: [Any?]?,
    completion: @escaping (Result<[Any?]?, ProxyApiTestsError>) -> Void)
  /// Returns the passed map, to test serialization and deserialization.
  func flutterEchoNullableMap(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aMap aMapArg: [String?: Any?]?,
    completion: @escaping (Result<[String?: Any?]?, ProxyApiTestsError>) -> Void)
  /// Returns the passed enum to test serialization and deserialization.
  func flutterEchoNullableEnum(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, anEnum anEnumArg: ProxyApiTestEnum?,
    completion: @escaping (Result<ProxyApiTestEnum?, ProxyApiTestsError>) -> Void)
  /// Returns the passed ProxyApi to test serialization and deserialization.
  func flutterEchoNullableProxyApi(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass,
    aProxyApi aProxyApiArg: ProxyApiSuperClass?,
    completion: @escaping (Result<ProxyApiSuperClass?, ProxyApiTestsError>) -> Void)
  /// A no-op function taking no arguments and returning no value, to sanity
  /// test basic asynchronous calling.
  func flutterNoopAsync(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass,
    completion: @escaping (Result<Void, ProxyApiTestsError>) -> Void)
  /// Returns the passed in generic Object asynchronously.
  func flutterEchoAsyncString(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aString aStringArg: String,
    completion: @escaping (Result<String, ProxyApiTestsError>) -> Void)
}

final class PigeonApiProxyApiTestClass: PigeonApiProtocolProxyApiTestClass {
  unowned let pigeonRegistrar: ProxyApiTestsPigeonProxyApiRegistrar
  let pigeonDelegate: PigeonApiDelegateProxyApiTestClass
  ///An implementation of [ProxyApiSuperClass] used to access callback methods
  var pigeonApiProxyApiSuperClass: PigeonApiProxyApiSuperClass {
    return pigeonRegistrar.apiDelegate.pigeonApiProxyApiSuperClass(pigeonRegistrar)
  }

  ///An implementation of [ProxyApiInterface] used to access callback methods
  var pigeonApiProxyApiInterface: PigeonApiProxyApiInterface {
    return pigeonRegistrar.apiDelegate.pigeonApiProxyApiInterface(pigeonRegistrar)
  }

  init(
    pigeonRegistrar: ProxyApiTestsPigeonProxyApiRegistrar,
    delegate: PigeonApiDelegateProxyApiTestClass
  ) {
    self.pigeonRegistrar = pigeonRegistrar
    self.pigeonDelegate = delegate
  }
  static func setUpMessageHandlers(
    binaryMessenger: FlutterBinaryMessenger, api: PigeonApiProxyApiTestClass?
  ) {
    let codec: FlutterStandardMessageCodec =
      api != nil
      ? FlutterStandardMessageCodec(
        readerWriter: ProxyApiTestsPigeonInternalProxyApiCodecReaderWriter(
          pigeonRegistrar: api!.pigeonRegistrar))
      : FlutterStandardMessageCodec.sharedInstance()
    let pigeonDefaultConstructorChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.pigeon_defaultConstructor",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      pigeonDefaultConstructorChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonIdentifierArg = args[0] as! Int64
        let aBoolArg = args[1] as! Bool
        let anIntArg = args[2] as! Int64
        let aDoubleArg = args[3] as! Double
        let aStringArg = args[4] as! String
        let aUint8ListArg = args[5] as! FlutterStandardTypedData
        let aListArg = args[6] as! [Any?]
        let aMapArg = args[7] as! [String?: Any?]
        let anEnumArg = args[8] as! ProxyApiTestEnum
        let aProxyApiArg = args[9] as! ProxyApiSuperClass
        let aNullableBoolArg: Bool? = nilOrValue(args[10])
        let aNullableIntArg: Int64? = nilOrValue(args[11])
        let aNullableDoubleArg: Double? = nilOrValue(args[12])
        let aNullableStringArg: String? = nilOrValue(args[13])
        let aNullableUint8ListArg: FlutterStandardTypedData? = nilOrValue(args[14])
        let aNullableListArg: [Any?]? = nilOrValue(args[15])
        let aNullableMapArg: [String?: Any?]? = nilOrValue(args[16])
        let aNullableEnumArg: ProxyApiTestEnum? = nilOrValue(args[17])
        let aNullableProxyApiArg: ProxyApiSuperClass? = nilOrValue(args[18])
        let boolParamArg = args[19] as! Bool
        let intParamArg = args[20] as! Int64
        let doubleParamArg = args[21] as! Double
        let stringParamArg = args[22] as! String
        let aUint8ListParamArg = args[23] as! FlutterStandardTypedData
        let listParamArg = args[24] as! [Any?]
        let mapParamArg = args[25] as! [String?: Any?]
        let enumParamArg = args[26] as! ProxyApiTestEnum
        let proxyApiParamArg = args[27] as! ProxyApiSuperClass
        let nullableBoolParamArg: Bool? = nilOrValue(args[28])
        let nullableIntParamArg: Int64? = nilOrValue(args[29])
        let nullableDoubleParamArg: Double? = nilOrValue(args[30])
        let nullableStringParamArg: String? = nilOrValue(args[31])
        let nullableUint8ListParamArg: FlutterStandardTypedData? = nilOrValue(args[32])
        let nullableListParamArg: [Any?]? = nilOrValue(args[33])
        let nullableMapParamArg: [String?: Any?]? = nilOrValue(args[34])
        let nullableEnumParamArg: ProxyApiTestEnum? = nilOrValue(args[35])
        let nullableProxyApiParamArg: ProxyApiSuperClass? = nilOrValue(args[36])
        do {
          api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
            try api.pigeonDelegate.pigeonDefaultConstructor(
              pigeonApi: api, aBool: aBoolArg, anInt: anIntArg, aDouble: aDoubleArg,
              aString: aStringArg, aUint8List: aUint8ListArg, aList: aListArg, aMap: aMapArg,
              anEnum: anEnumArg, aProxyApi: aProxyApiArg, aNullableBool: aNullableBoolArg,
              aNullableInt: aNullableIntArg, aNullableDouble: aNullableDoubleArg,
              aNullableString: aNullableStringArg, aNullableUint8List: aNullableUint8ListArg,
              aNullableList: aNullableListArg, aNullableMap: aNullableMapArg,
              aNullableEnum: aNullableEnumArg, aNullableProxyApi: aNullableProxyApiArg,
              boolParam: boolParamArg, intParam: intParamArg, doubleParam: doubleParamArg,
              stringParam: stringParamArg, aUint8ListParam: aUint8ListParamArg,
              listParam: listParamArg, mapParam: mapParamArg, enumParam: enumParamArg,
              proxyApiParam: proxyApiParamArg, nullableBoolParam: nullableBoolParamArg,
              nullableIntParam: nullableIntParamArg, nullableDoubleParam: nullableDoubleParamArg,
              nullableStringParam: nullableStringParamArg,
              nullableUint8ListParam: nullableUint8ListParamArg,
              nullableListParam: nullableListParamArg, nullableMapParam: nullableMapParamArg,
              nullableEnumParam: nullableEnumParamArg,
              nullableProxyApiParam: nullableProxyApiParamArg),
            withIdentifier: pigeonIdentifierArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      pigeonDefaultConstructorChannel.setMessageHandler(nil)
    }
    let namedConstructorChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.namedConstructor",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      namedConstructorChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonIdentifierArg = args[0] as! Int64
        let aBoolArg = args[1] as! Bool
        let anIntArg = args[2] as! Int64
        let aDoubleArg = args[3] as! Double
        let aStringArg = args[4] as! String
        let aUint8ListArg = args[5] as! FlutterStandardTypedData
        let aListArg = args[6] as! [Any?]
        let aMapArg = args[7] as! [String?: Any?]
        let anEnumArg = args[8] as! ProxyApiTestEnum
        let aProxyApiArg = args[9] as! ProxyApiSuperClass
        let aNullableBoolArg: Bool? = nilOrValue(args[10])
        let aNullableIntArg: Int64? = nilOrValue(args[11])
        let aNullableDoubleArg: Double? = nilOrValue(args[12])
        let aNullableStringArg: String? = nilOrValue(args[13])
        let aNullableUint8ListArg: FlutterStandardTypedData? = nilOrValue(args[14])
        let aNullableListArg: [Any?]? = nilOrValue(args[15])
        let aNullableMapArg: [String?: Any?]? = nilOrValue(args[16])
        let aNullableEnumArg: ProxyApiTestEnum? = nilOrValue(args[17])
        let aNullableProxyApiArg: ProxyApiSuperClass? = nilOrValue(args[18])
        do {
          api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
            try api.pigeonDelegate.namedConstructor(
              pigeonApi: api, aBool: aBoolArg, anInt: anIntArg, aDouble: aDoubleArg,
              aString: aStringArg, aUint8List: aUint8ListArg, aList: aListArg, aMap: aMapArg,
              anEnum: anEnumArg, aProxyApi: aProxyApiArg, aNullableBool: aNullableBoolArg,
              aNullableInt: aNullableIntArg, aNullableDouble: aNullableDoubleArg,
              aNullableString: aNullableStringArg, aNullableUint8List: aNullableUint8ListArg,
              aNullableList: aNullableListArg, aNullableMap: aNullableMapArg,
              aNullableEnum: aNullableEnumArg, aNullableProxyApi: aNullableProxyApiArg),
            withIdentifier: pigeonIdentifierArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      namedConstructorChannel.setMessageHandler(nil)
    }
    let attachedFieldChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.attachedField",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      attachedFieldChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let pigeonIdentifierArg = args[1] as! Int64
        do {
          api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
            try api.pigeonDelegate.attachedField(pigeonApi: api, pigeonInstance: pigeonInstanceArg),
            withIdentifier: pigeonIdentifierArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      attachedFieldChannel.setMessageHandler(nil)
    }
    let staticAttachedFieldChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.staticAttachedField",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      staticAttachedFieldChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonIdentifierArg = args[0] as! Int64
        do {
          api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
            try api.pigeonDelegate.staticAttachedField(pigeonApi: api),
            withIdentifier: pigeonIdentifierArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      staticAttachedFieldChannel.setMessageHandler(nil)
    }
    let noopChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.noop",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      noopChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        do {
          try api.pigeonDelegate.noop(pigeonApi: api, pigeonInstance: pigeonInstanceArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      noopChannel.setMessageHandler(nil)
    }
    let throwErrorChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.throwError",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      throwErrorChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        do {
          let result = try api.pigeonDelegate.throwError(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      throwErrorChannel.setMessageHandler(nil)
    }
    let throwErrorFromVoidChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.throwErrorFromVoid",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      throwErrorFromVoidChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        do {
          try api.pigeonDelegate.throwErrorFromVoid(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      throwErrorFromVoidChannel.setMessageHandler(nil)
    }
    let throwFlutterErrorChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.throwFlutterError",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      throwFlutterErrorChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        do {
          let result = try api.pigeonDelegate.throwFlutterError(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      throwFlutterErrorChannel.setMessageHandler(nil)
    }
    let echoIntChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoInt",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoIntChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let anIntArg = args[1] as! Int64
        do {
          let result = try api.pigeonDelegate.echoInt(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg, anInt: anIntArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoIntChannel.setMessageHandler(nil)
    }
    let echoDoubleChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoDouble",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoDoubleChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aDoubleArg = args[1] as! Double
        do {
          let result = try api.pigeonDelegate.echoDouble(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg, aDouble: aDoubleArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoDoubleChannel.setMessageHandler(nil)
    }
    let echoBoolChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoBool",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoBoolChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aBoolArg = args[1] as! Bool
        do {
          let result = try api.pigeonDelegate.echoBool(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg, aBool: aBoolArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoBoolChannel.setMessageHandler(nil)
    }
    let echoStringChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoString",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoStringChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aStringArg = args[1] as! String
        do {
          let result = try api.pigeonDelegate.echoString(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg, aString: aStringArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoStringChannel.setMessageHandler(nil)
    }
    let echoUint8ListChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoUint8List",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoUint8ListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aUint8ListArg = args[1] as! FlutterStandardTypedData
        do {
          let result = try api.pigeonDelegate.echoUint8List(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg, aUint8List: aUint8ListArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoUint8ListChannel.setMessageHandler(nil)
    }
    let echoObjectChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoObject",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoObjectChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let anObjectArg = args[1]!
        do {
          let result = try api.pigeonDelegate.echoObject(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg, anObject: anObjectArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoObjectChannel.setMessageHandler(nil)
    }
    let echoListChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoList",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aListArg = args[1] as! [Any?]
        do {
          let result = try api.pigeonDelegate.echoList(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg, aList: aListArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoListChannel.setMessageHandler(nil)
    }
    let echoProxyApiListChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoProxyApiList",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoProxyApiListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aListArg = args[1] as! [ProxyApiTestClass]
        do {
          let result = try api.pigeonDelegate.echoProxyApiList(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg, aList: aListArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoProxyApiListChannel.setMessageHandler(nil)
    }
    let echoMapChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoMap",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aMapArg = args[1] as! [String?: Any?]
        do {
          let result = try api.pigeonDelegate.echoMap(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg, aMap: aMapArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoMapChannel.setMessageHandler(nil)
    }
    let echoProxyApiMapChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoProxyApiMap",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoProxyApiMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aMapArg = args[1] as! [String: ProxyApiTestClass]
        do {
          let result = try api.pigeonDelegate.echoProxyApiMap(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg, aMap: aMapArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoProxyApiMapChannel.setMessageHandler(nil)
    }
    let echoEnumChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoEnum",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoEnumChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let anEnumArg = args[1] as! ProxyApiTestEnum
        do {
          let result = try api.pigeonDelegate.echoEnum(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg, anEnum: anEnumArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoEnumChannel.setMessageHandler(nil)
    }
    let echoProxyApiChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoProxyApi",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoProxyApiChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aProxyApiArg = args[1] as! ProxyApiSuperClass
        do {
          let result = try api.pigeonDelegate.echoProxyApi(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg, aProxyApi: aProxyApiArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoProxyApiChannel.setMessageHandler(nil)
    }
    let echoNullableIntChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableInt",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableIntChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aNullableIntArg: Int64? = nilOrValue(args[1])
        do {
          let result = try api.pigeonDelegate.echoNullableInt(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg, aNullableInt: aNullableIntArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableIntChannel.setMessageHandler(nil)
    }
    let echoNullableDoubleChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableDouble",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableDoubleChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aNullableDoubleArg: Double? = nilOrValue(args[1])
        do {
          let result = try api.pigeonDelegate.echoNullableDouble(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg, aNullableDouble: aNullableDoubleArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableDoubleChannel.setMessageHandler(nil)
    }
    let echoNullableBoolChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableBool",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableBoolChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aNullableBoolArg: Bool? = nilOrValue(args[1])
        do {
          let result = try api.pigeonDelegate.echoNullableBool(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg, aNullableBool: aNullableBoolArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableBoolChannel.setMessageHandler(nil)
    }
    let echoNullableStringChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableString",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableStringChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aNullableStringArg: String? = nilOrValue(args[1])
        do {
          let result = try api.pigeonDelegate.echoNullableString(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg, aNullableString: aNullableStringArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableStringChannel.setMessageHandler(nil)
    }
    let echoNullableUint8ListChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableUint8List",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableUint8ListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aNullableUint8ListArg: FlutterStandardTypedData? = nilOrValue(args[1])
        do {
          let result = try api.pigeonDelegate.echoNullableUint8List(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg,
            aNullableUint8List: aNullableUint8ListArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableUint8ListChannel.setMessageHandler(nil)
    }
    let echoNullableObjectChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableObject",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableObjectChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aNullableObjectArg: Any? = args[1]
        do {
          let result = try api.pigeonDelegate.echoNullableObject(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg, aNullableObject: aNullableObjectArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableObjectChannel.setMessageHandler(nil)
    }
    let echoNullableListChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableList",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aNullableListArg: [Any?]? = nilOrValue(args[1])
        do {
          let result = try api.pigeonDelegate.echoNullableList(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg, aNullableList: aNullableListArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableListChannel.setMessageHandler(nil)
    }
    let echoNullableMapChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableMap",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aNullableMapArg: [String?: Any?]? = nilOrValue(args[1])
        do {
          let result = try api.pigeonDelegate.echoNullableMap(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg, aNullableMap: aNullableMapArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableMapChannel.setMessageHandler(nil)
    }
    let echoNullableEnumChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableEnum",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableEnumChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aNullableEnumArg: ProxyApiTestEnum? = nilOrValue(args[1])
        do {
          let result = try api.pigeonDelegate.echoNullableEnum(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg, aNullableEnum: aNullableEnumArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableEnumChannel.setMessageHandler(nil)
    }
    let echoNullableProxyApiChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableProxyApi",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoNullableProxyApiChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aNullableProxyApiArg: ProxyApiSuperClass? = nilOrValue(args[1])
        do {
          let result = try api.pigeonDelegate.echoNullableProxyApi(
            pigeonApi: api, pigeonInstance: pigeonInstanceArg,
            aNullableProxyApi: aNullableProxyApiArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoNullableProxyApiChannel.setMessageHandler(nil)
    }
    let noopAsyncChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.noopAsync",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      noopAsyncChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        api.pigeonDelegate.noopAsync(pigeonApi: api, pigeonInstance: pigeonInstanceArg) { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      noopAsyncChannel.setMessageHandler(nil)
    }
    let echoAsyncIntChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncInt",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncIntChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let anIntArg = args[1] as! Int64
        api.pigeonDelegate.echoAsyncInt(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, anInt: anIntArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncIntChannel.setMessageHandler(nil)
    }
    let echoAsyncDoubleChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncDouble",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncDoubleChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aDoubleArg = args[1] as! Double
        api.pigeonDelegate.echoAsyncDouble(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aDouble: aDoubleArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncDoubleChannel.setMessageHandler(nil)
    }
    let echoAsyncBoolChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncBool",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncBoolChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aBoolArg = args[1] as! Bool
        api.pigeonDelegate.echoAsyncBool(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aBool: aBoolArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncBoolChannel.setMessageHandler(nil)
    }
    let echoAsyncStringChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncString",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncStringChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aStringArg = args[1] as! String
        api.pigeonDelegate.echoAsyncString(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aString: aStringArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncStringChannel.setMessageHandler(nil)
    }
    let echoAsyncUint8ListChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncUint8List",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncUint8ListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aUint8ListArg = args[1] as! FlutterStandardTypedData
        api.pigeonDelegate.echoAsyncUint8List(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aUint8List: aUint8ListArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncUint8ListChannel.setMessageHandler(nil)
    }
    let echoAsyncObjectChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncObject",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncObjectChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let anObjectArg = args[1]!
        api.pigeonDelegate.echoAsyncObject(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, anObject: anObjectArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncObjectChannel.setMessageHandler(nil)
    }
    let echoAsyncListChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncList",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aListArg = args[1] as! [Any?]
        api.pigeonDelegate.echoAsyncList(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aList: aListArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncListChannel.setMessageHandler(nil)
    }
    let echoAsyncMapChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncMap",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aMapArg = args[1] as! [String?: Any?]
        api.pigeonDelegate.echoAsyncMap(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aMap: aMapArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncMapChannel.setMessageHandler(nil)
    }
    let echoAsyncEnumChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncEnum",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncEnumChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let anEnumArg = args[1] as! ProxyApiTestEnum
        api.pigeonDelegate.echoAsyncEnum(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, anEnum: anEnumArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncEnumChannel.setMessageHandler(nil)
    }
    let throwAsyncErrorChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.throwAsyncError",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      throwAsyncErrorChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        api.pigeonDelegate.throwAsyncError(pigeonApi: api, pigeonInstance: pigeonInstanceArg) {
          result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      throwAsyncErrorChannel.setMessageHandler(nil)
    }
    let throwAsyncErrorFromVoidChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.throwAsyncErrorFromVoid",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      throwAsyncErrorFromVoidChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        api.pigeonDelegate.throwAsyncErrorFromVoid(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg
        ) { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      throwAsyncErrorFromVoidChannel.setMessageHandler(nil)
    }
    let throwAsyncFlutterErrorChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.throwAsyncFlutterError",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      throwAsyncFlutterErrorChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        api.pigeonDelegate.throwAsyncFlutterError(pigeonApi: api, pigeonInstance: pigeonInstanceArg)
        { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      throwAsyncFlutterErrorChannel.setMessageHandler(nil)
    }
    let echoAsyncNullableIntChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableInt",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableIntChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let anIntArg: Int64? = nilOrValue(args[1])
        api.pigeonDelegate.echoAsyncNullableInt(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, anInt: anIntArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableIntChannel.setMessageHandler(nil)
    }
    let echoAsyncNullableDoubleChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableDouble",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableDoubleChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aDoubleArg: Double? = nilOrValue(args[1])
        api.pigeonDelegate.echoAsyncNullableDouble(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aDouble: aDoubleArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableDoubleChannel.setMessageHandler(nil)
    }
    let echoAsyncNullableBoolChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableBool",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableBoolChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aBoolArg: Bool? = nilOrValue(args[1])
        api.pigeonDelegate.echoAsyncNullableBool(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aBool: aBoolArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableBoolChannel.setMessageHandler(nil)
    }
    let echoAsyncNullableStringChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableString",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableStringChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aStringArg: String? = nilOrValue(args[1])
        api.pigeonDelegate.echoAsyncNullableString(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aString: aStringArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableStringChannel.setMessageHandler(nil)
    }
    let echoAsyncNullableUint8ListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableUint8List",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableUint8ListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aUint8ListArg: FlutterStandardTypedData? = nilOrValue(args[1])
        api.pigeonDelegate.echoAsyncNullableUint8List(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aUint8List: aUint8ListArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableUint8ListChannel.setMessageHandler(nil)
    }
    let echoAsyncNullableObjectChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableObject",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableObjectChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let anObjectArg: Any? = args[1]
        api.pigeonDelegate.echoAsyncNullableObject(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, anObject: anObjectArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableObjectChannel.setMessageHandler(nil)
    }
    let echoAsyncNullableListChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableList",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aListArg: [Any?]? = nilOrValue(args[1])
        api.pigeonDelegate.echoAsyncNullableList(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aList: aListArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableListChannel.setMessageHandler(nil)
    }
    let echoAsyncNullableMapChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableMap",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aMapArg: [String?: Any?]? = nilOrValue(args[1])
        api.pigeonDelegate.echoAsyncNullableMap(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aMap: aMapArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableMapChannel.setMessageHandler(nil)
    }
    let echoAsyncNullableEnumChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableEnum",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoAsyncNullableEnumChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let anEnumArg: ProxyApiTestEnum? = nilOrValue(args[1])
        api.pigeonDelegate.echoAsyncNullableEnum(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, anEnum: anEnumArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      echoAsyncNullableEnumChannel.setMessageHandler(nil)
    }
    let staticNoopChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.staticNoop",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      staticNoopChannel.setMessageHandler { _, reply in
        do {
          try api.pigeonDelegate.staticNoop(pigeonApi: api)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      staticNoopChannel.setMessageHandler(nil)
    }
    let echoStaticStringChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoStaticString",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      echoStaticStringChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let aStringArg = args[0] as! String
        do {
          let result = try api.pigeonDelegate.echoStaticString(pigeonApi: api, aString: aStringArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      echoStaticStringChannel.setMessageHandler(nil)
    }
    let staticAsyncNoopChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.staticAsyncNoop",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      staticAsyncNoopChannel.setMessageHandler { _, reply in
        api.pigeonDelegate.staticAsyncNoop(pigeonApi: api) { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      staticAsyncNoopChannel.setMessageHandler(nil)
    }
    let callFlutterNoopChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterNoop",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterNoopChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        api.pigeonDelegate.callFlutterNoop(pigeonApi: api, pigeonInstance: pigeonInstanceArg) {
          result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterNoopChannel.setMessageHandler(nil)
    }
    let callFlutterThrowErrorChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterThrowError",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterThrowErrorChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        api.pigeonDelegate.callFlutterThrowError(pigeonApi: api, pigeonInstance: pigeonInstanceArg)
        { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterThrowErrorChannel.setMessageHandler(nil)
    }
    let callFlutterThrowErrorFromVoidChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterThrowErrorFromVoid",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterThrowErrorFromVoidChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        api.pigeonDelegate.callFlutterThrowErrorFromVoid(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg
        ) { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterThrowErrorFromVoidChannel.setMessageHandler(nil)
    }
    let callFlutterEchoBoolChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoBool",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoBoolChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aBoolArg = args[1] as! Bool
        api.pigeonDelegate.callFlutterEchoBool(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aBool: aBoolArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoBoolChannel.setMessageHandler(nil)
    }
    let callFlutterEchoIntChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoInt",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoIntChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let anIntArg = args[1] as! Int64
        api.pigeonDelegate.callFlutterEchoInt(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, anInt: anIntArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoIntChannel.setMessageHandler(nil)
    }
    let callFlutterEchoDoubleChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoDouble",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoDoubleChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aDoubleArg = args[1] as! Double
        api.pigeonDelegate.callFlutterEchoDouble(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aDouble: aDoubleArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoDoubleChannel.setMessageHandler(nil)
    }
    let callFlutterEchoStringChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoString",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoStringChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aStringArg = args[1] as! String
        api.pigeonDelegate.callFlutterEchoString(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aString: aStringArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoStringChannel.setMessageHandler(nil)
    }
    let callFlutterEchoUint8ListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoUint8List",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoUint8ListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aUint8ListArg = args[1] as! FlutterStandardTypedData
        api.pigeonDelegate.callFlutterEchoUint8List(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aUint8List: aUint8ListArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoUint8ListChannel.setMessageHandler(nil)
    }
    let callFlutterEchoListChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoList",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aListArg = args[1] as! [Any?]
        api.pigeonDelegate.callFlutterEchoList(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aList: aListArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoListChannel.setMessageHandler(nil)
    }
    let callFlutterEchoProxyApiListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoProxyApiList",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoProxyApiListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aListArg = args[1] as! [ProxyApiTestClass?]
        api.pigeonDelegate.callFlutterEchoProxyApiList(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aList: aListArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoProxyApiListChannel.setMessageHandler(nil)
    }
    let callFlutterEchoMapChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoMap",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aMapArg = args[1] as! [String?: Any?]
        api.pigeonDelegate.callFlutterEchoMap(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aMap: aMapArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoMapChannel.setMessageHandler(nil)
    }
    let callFlutterEchoProxyApiMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoProxyApiMap",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoProxyApiMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aMapArg = args[1] as! [String?: ProxyApiTestClass?]
        api.pigeonDelegate.callFlutterEchoProxyApiMap(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aMap: aMapArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoProxyApiMapChannel.setMessageHandler(nil)
    }
    let callFlutterEchoEnumChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoEnum",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoEnumChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let anEnumArg = args[1] as! ProxyApiTestEnum
        api.pigeonDelegate.callFlutterEchoEnum(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, anEnum: anEnumArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoEnumChannel.setMessageHandler(nil)
    }
    let callFlutterEchoProxyApiChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoProxyApi",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoProxyApiChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aProxyApiArg = args[1] as! ProxyApiSuperClass
        api.pigeonDelegate.callFlutterEchoProxyApi(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aProxyApi: aProxyApiArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoProxyApiChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableBoolChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableBool",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableBoolChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aBoolArg: Bool? = nilOrValue(args[1])
        api.pigeonDelegate.callFlutterEchoNullableBool(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aBool: aBoolArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableBoolChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableIntChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableInt",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableIntChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let anIntArg: Int64? = nilOrValue(args[1])
        api.pigeonDelegate.callFlutterEchoNullableInt(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, anInt: anIntArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableIntChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableDoubleChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableDouble",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableDoubleChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aDoubleArg: Double? = nilOrValue(args[1])
        api.pigeonDelegate.callFlutterEchoNullableDouble(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aDouble: aDoubleArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableDoubleChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableStringChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableString",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableStringChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aStringArg: String? = nilOrValue(args[1])
        api.pigeonDelegate.callFlutterEchoNullableString(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aString: aStringArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableStringChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableUint8ListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableUint8List",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableUint8ListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aUint8ListArg: FlutterStandardTypedData? = nilOrValue(args[1])
        api.pigeonDelegate.callFlutterEchoNullableUint8List(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aUint8List: aUint8ListArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableUint8ListChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableListChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableList",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableListChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aListArg: [Any?]? = nilOrValue(args[1])
        api.pigeonDelegate.callFlutterEchoNullableList(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aList: aListArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableListChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableMapChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableMap",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aMapArg: [String?: Any?]? = nilOrValue(args[1])
        api.pigeonDelegate.callFlutterEchoNullableMap(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aMap: aMapArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableMapChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableEnumChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableEnum",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableEnumChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let anEnumArg: ProxyApiTestEnum? = nilOrValue(args[1])
        api.pigeonDelegate.callFlutterEchoNullableEnum(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, anEnum: anEnumArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableEnumChannel.setMessageHandler(nil)
    }
    let callFlutterEchoNullableProxyApiChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableProxyApi",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoNullableProxyApiChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aProxyApiArg: ProxyApiSuperClass? = nilOrValue(args[1])
        api.pigeonDelegate.callFlutterEchoNullableProxyApi(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aProxyApi: aProxyApiArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoNullableProxyApiChannel.setMessageHandler(nil)
    }
    let callFlutterNoopAsyncChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterNoopAsync",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterNoopAsyncChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        api.pigeonDelegate.callFlutterNoopAsync(pigeonApi: api, pigeonInstance: pigeonInstanceArg) {
          result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterNoopAsyncChannel.setMessageHandler(nil)
    }
    let callFlutterEchoAsyncStringChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoAsyncString",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      callFlutterEchoAsyncStringChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiTestClass
        let aStringArg = args[1] as! String
        api.pigeonDelegate.callFlutterEchoAsyncString(
          pigeonApi: api, pigeonInstance: pigeonInstanceArg, aString: aStringArg
        ) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      callFlutterEchoAsyncStringChannel.setMessageHandler(nil)
    }
  }

  ///Creates a Dart instance of ProxyApiTestClass and attaches it to [pigeonInstance].
  func pigeonNewInstance(
    pigeonInstance: ProxyApiTestClass,
    completion: @escaping (Result<Void, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
    } else if pigeonRegistrar.instanceManager.containsInstance(pigeonInstance as AnyObject) {
      completion(.success(()))
    } else {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "new-instance-error",
            message:
              "Error: Attempting to create a new Dart instance of ProxyApiTestClass, but the class has a nonnull callback method.",
            details: "")))
    }
  }
  /// A no-op function taking no arguments and returning no value, to sanity
  /// test basic calling.
  func flutterNoop(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass,
    completion: @escaping (Result<Void, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterNoop"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else {
        completion(.success(()))
      }
    }
  }

  /// Responds with an error from an async function returning a value.
  func flutterThrowError(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass,
    completion: @escaping (Result<Any?, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterThrowError"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else {
        let result: Any? = listResponse[0]
        completion(.success(result))
      }
    }
  }

  /// Responds with an error from an async void function.
  func flutterThrowErrorFromVoid(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass,
    completion: @escaping (Result<Void, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterThrowErrorFromVoid"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else {
        completion(.success(()))
      }
    }
  }

  /// Returns the passed boolean, to test serialization and deserialization.
  func flutterEchoBool(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aBool aBoolArg: Bool,
    completion: @escaping (Result<Bool, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoBool"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg, aBoolArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            ProxyApiTestsError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! Bool
        completion(.success(result))
      }
    }
  }

  /// Returns the passed int, to test serialization and deserialization.
  func flutterEchoInt(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, anInt anIntArg: Int64,
    completion: @escaping (Result<Int64, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoInt"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg, anIntArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            ProxyApiTestsError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! Int64
        completion(.success(result))
      }
    }
  }

  /// Returns the passed double, to test serialization and deserialization.
  func flutterEchoDouble(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aDouble aDoubleArg: Double,
    completion: @escaping (Result<Double, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoDouble"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg, aDoubleArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            ProxyApiTestsError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! Double
        completion(.success(result))
      }
    }
  }

  /// Returns the passed string, to test serialization and deserialization.
  func flutterEchoString(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aString aStringArg: String,
    completion: @escaping (Result<String, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoString"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg, aStringArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            ProxyApiTestsError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! String
        completion(.success(result))
      }
    }
  }

  /// Returns the passed byte list, to test serialization and deserialization.
  func flutterEchoUint8List(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aList aListArg: FlutterStandardTypedData,
    completion: @escaping (Result<FlutterStandardTypedData, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoUint8List"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg, aListArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            ProxyApiTestsError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! FlutterStandardTypedData
        completion(.success(result))
      }
    }
  }

  /// Returns the passed list, to test serialization and deserialization.
  func flutterEchoList(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aList aListArg: [Any?],
    completion: @escaping (Result<[Any?], ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoList"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg, aListArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            ProxyApiTestsError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! [Any?]
        completion(.success(result))
      }
    }
  }

  /// Returns the passed list with ProxyApis, to test serialization and
  /// deserialization.
  func flutterEchoProxyApiList(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aList aListArg: [ProxyApiTestClass?],
    completion: @escaping (Result<[ProxyApiTestClass?], ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoProxyApiList"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg, aListArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            ProxyApiTestsError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! [ProxyApiTestClass?]
        completion(.success(result))
      }
    }
  }

  /// Returns the passed map, to test serialization and deserialization.
  func flutterEchoMap(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aMap aMapArg: [String?: Any?],
    completion: @escaping (Result<[String?: Any?], ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoMap"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg, aMapArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            ProxyApiTestsError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! [String?: Any?]
        completion(.success(result))
      }
    }
  }

  /// Returns the passed map with ProxyApis, to test serialization and
  /// deserialization.
  func flutterEchoProxyApiMap(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass,
    aMap aMapArg: [String?: ProxyApiTestClass?],
    completion: @escaping (Result<[String?: ProxyApiTestClass?], ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoProxyApiMap"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg, aMapArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            ProxyApiTestsError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! [String?: ProxyApiTestClass?]
        completion(.success(result))
      }
    }
  }

  /// Returns the passed enum to test serialization and deserialization.
  func flutterEchoEnum(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, anEnum anEnumArg: ProxyApiTestEnum,
    completion: @escaping (Result<ProxyApiTestEnum, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoEnum"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg, anEnumArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            ProxyApiTestsError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! ProxyApiTestEnum
        completion(.success(result))
      }
    }
  }

  /// Returns the passed ProxyApi to test serialization and deserialization.
  func flutterEchoProxyApi(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aProxyApi aProxyApiArg: ProxyApiSuperClass,
    completion: @escaping (Result<ProxyApiSuperClass, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoProxyApi"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg, aProxyApiArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            ProxyApiTestsError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! ProxyApiSuperClass
        completion(.success(result))
      }
    }
  }

  /// Returns the passed boolean, to test serialization and deserialization.
  func flutterEchoNullableBool(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aBool aBoolArg: Bool?,
    completion: @escaping (Result<Bool?, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableBool"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg, aBoolArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else {
        let result: Bool? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }

  /// Returns the passed int, to test serialization and deserialization.
  func flutterEchoNullableInt(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, anInt anIntArg: Int64?,
    completion: @escaping (Result<Int64?, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableInt"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg, anIntArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else {
        let result: Int64? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }

  /// Returns the passed double, to test serialization and deserialization.
  func flutterEchoNullableDouble(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aDouble aDoubleArg: Double?,
    completion: @escaping (Result<Double?, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableDouble"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg, aDoubleArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else {
        let result: Double? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }

  /// Returns the passed string, to test serialization and deserialization.
  func flutterEchoNullableString(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aString aStringArg: String?,
    completion: @escaping (Result<String?, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableString"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg, aStringArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else {
        let result: String? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }

  /// Returns the passed byte list, to test serialization and deserialization.
  func flutterEchoNullableUint8List(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aList aListArg: FlutterStandardTypedData?,
    completion: @escaping (Result<FlutterStandardTypedData?, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableUint8List"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg, aListArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else {
        let result: FlutterStandardTypedData? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }

  /// Returns the passed list, to test serialization and deserialization.
  func flutterEchoNullableList(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aList aListArg: [Any?]?,
    completion: @escaping (Result<[Any?]?, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableList"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg, aListArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else {
        let result: [Any?]? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }

  /// Returns the passed map, to test serialization and deserialization.
  func flutterEchoNullableMap(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aMap aMapArg: [String?: Any?]?,
    completion: @escaping (Result<[String?: Any?]?, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableMap"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg, aMapArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else {
        let result: [String?: Any?]? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }

  /// Returns the passed enum to test serialization and deserialization.
  func flutterEchoNullableEnum(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, anEnum anEnumArg: ProxyApiTestEnum?,
    completion: @escaping (Result<ProxyApiTestEnum?, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableEnum"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg, anEnumArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else {
        let result: ProxyApiTestEnum? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }

  /// Returns the passed ProxyApi to test serialization and deserialization.
  func flutterEchoNullableProxyApi(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass,
    aProxyApi aProxyApiArg: ProxyApiSuperClass?,
    completion: @escaping (Result<ProxyApiSuperClass?, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableProxyApi"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg, aProxyApiArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else {
        let result: ProxyApiSuperClass? = nilOrValue(listResponse[0])
        completion(.success(result))
      }
    }
  }

  /// A no-op function taking no arguments and returning no value, to sanity
  /// test basic asynchronous calling.
  func flutterNoopAsync(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass,
    completion: @escaping (Result<Void, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterNoopAsync"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else {
        completion(.success(()))
      }
    }
  }

  /// Returns the passed in generic Object asynchronously.
  func flutterEchoAsyncString(
    pigeonInstance pigeonInstanceArg: ProxyApiTestClass, aString aStringArg: String,
    completion: @escaping (Result<String, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoAsyncString"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg, aStringArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(
          .failure(
            ProxyApiTestsError(
              code: "null-error",
              message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! String
        completion(.success(result))
      }
    }
  }

}
protocol PigeonApiDelegateProxyApiSuperClass {
  func pigeonDefaultConstructor(pigeonApi: PigeonApiProxyApiSuperClass) throws -> ProxyApiSuperClass
  func aSuperMethod(pigeonApi: PigeonApiProxyApiSuperClass, pigeonInstance: ProxyApiSuperClass)
    throws
}

protocol PigeonApiProtocolProxyApiSuperClass {
}

final class PigeonApiProxyApiSuperClass: PigeonApiProtocolProxyApiSuperClass {
  unowned let pigeonRegistrar: ProxyApiTestsPigeonProxyApiRegistrar
  let pigeonDelegate: PigeonApiDelegateProxyApiSuperClass
  init(
    pigeonRegistrar: ProxyApiTestsPigeonProxyApiRegistrar,
    delegate: PigeonApiDelegateProxyApiSuperClass
  ) {
    self.pigeonRegistrar = pigeonRegistrar
    self.pigeonDelegate = delegate
  }
  static func setUpMessageHandlers(
    binaryMessenger: FlutterBinaryMessenger, api: PigeonApiProxyApiSuperClass?
  ) {
    let codec: FlutterStandardMessageCodec =
      api != nil
      ? FlutterStandardMessageCodec(
        readerWriter: ProxyApiTestsPigeonInternalProxyApiCodecReaderWriter(
          pigeonRegistrar: api!.pigeonRegistrar))
      : FlutterStandardMessageCodec.sharedInstance()
    let pigeonDefaultConstructorChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiSuperClass.pigeon_defaultConstructor",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      pigeonDefaultConstructorChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonIdentifierArg = args[0] as! Int64
        do {
          api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
            try api.pigeonDelegate.pigeonDefaultConstructor(pigeonApi: api),
            withIdentifier: pigeonIdentifierArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      pigeonDefaultConstructorChannel.setMessageHandler(nil)
    }
    let aSuperMethodChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiSuperClass.aSuperMethod",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      aSuperMethodChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let pigeonInstanceArg = args[0] as! ProxyApiSuperClass
        do {
          try api.pigeonDelegate.aSuperMethod(pigeonApi: api, pigeonInstance: pigeonInstanceArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      aSuperMethodChannel.setMessageHandler(nil)
    }
  }

  ///Creates a Dart instance of ProxyApiSuperClass and attaches it to [pigeonInstance].
  func pigeonNewInstance(
    pigeonInstance: ProxyApiSuperClass,
    completion: @escaping (Result<Void, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
    } else if pigeonRegistrar.instanceManager.containsInstance(pigeonInstance as AnyObject) {
      completion(.success(()))
    } else {
      let pigeonIdentifierArg = pigeonRegistrar.instanceManager.addHostCreatedInstance(
        pigeonInstance as AnyObject)
      let binaryMessenger = pigeonRegistrar.binaryMessenger
      let codec = pigeonRegistrar.codec
      let channelName: String =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiSuperClass.pigeon_newInstance"
      let channel = FlutterBasicMessageChannel(
        name: channelName, binaryMessenger: binaryMessenger, codec: codec)
      channel.sendMessage([pigeonIdentifierArg] as [Any?]) { response in
        guard let listResponse = response as? [Any?] else {
          completion(.failure(createConnectionError(withChannelName: channelName)))
          return
        }
        if listResponse.count > 1 {
          let code: String = listResponse[0] as! String
          let message: String? = nilOrValue(listResponse[1])
          let details: String? = nilOrValue(listResponse[2])
          completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
        } else {
          completion(.success(()))
        }
      }
    }
  }
}
open class PigeonApiDelegateProxyApiInterface {
}

protocol PigeonApiProtocolProxyApiInterface {
  func anInterfaceMethod(
    pigeonInstance pigeonInstanceArg: ProxyApiInterface,
    completion: @escaping (Result<Void, ProxyApiTestsError>) -> Void)
}

final class PigeonApiProxyApiInterface: PigeonApiProtocolProxyApiInterface {
  unowned let pigeonRegistrar: ProxyApiTestsPigeonProxyApiRegistrar
  let pigeonDelegate: PigeonApiDelegateProxyApiInterface
  init(
    pigeonRegistrar: ProxyApiTestsPigeonProxyApiRegistrar,
    delegate: PigeonApiDelegateProxyApiInterface
  ) {
    self.pigeonRegistrar = pigeonRegistrar
    self.pigeonDelegate = delegate
  }
  ///Creates a Dart instance of ProxyApiInterface and attaches it to [pigeonInstance].
  func pigeonNewInstance(
    pigeonInstance: ProxyApiInterface,
    completion: @escaping (Result<Void, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
    } else if pigeonRegistrar.instanceManager.containsInstance(pigeonInstance as AnyObject) {
      completion(.success(()))
    } else {
      let pigeonIdentifierArg = pigeonRegistrar.instanceManager.addHostCreatedInstance(
        pigeonInstance as AnyObject)
      let binaryMessenger = pigeonRegistrar.binaryMessenger
      let codec = pigeonRegistrar.codec
      let channelName: String =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiInterface.pigeon_newInstance"
      let channel = FlutterBasicMessageChannel(
        name: channelName, binaryMessenger: binaryMessenger, codec: codec)
      channel.sendMessage([pigeonIdentifierArg] as [Any?]) { response in
        guard let listResponse = response as? [Any?] else {
          completion(.failure(createConnectionError(withChannelName: channelName)))
          return
        }
        if listResponse.count > 1 {
          let code: String = listResponse[0] as! String
          let message: String? = nilOrValue(listResponse[1])
          let details: String? = nilOrValue(listResponse[2])
          completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
        } else {
          completion(.success(()))
        }
      }
    }
  }
  func anInterfaceMethod(
    pigeonInstance pigeonInstanceArg: ProxyApiInterface,
    completion: @escaping (Result<Void, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
      return
    }
    let binaryMessenger = pigeonRegistrar.binaryMessenger
    let codec = pigeonRegistrar.codec
    let channelName: String =
      "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiInterface.anInterfaceMethod"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([pigeonInstanceArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
      } else {
        completion(.success(()))
      }
    }
  }

}
protocol PigeonApiDelegateClassWithApiRequirement {
  @available(iOS 15.0.0, macOS 10.0.0, *)
  func pigeonDefaultConstructor(pigeonApi: PigeonApiClassWithApiRequirement) throws
    -> ClassWithApiRequirement
  @available(iOS 15.0.0, macOS 10.0.0, *)
  func aMethod(pigeonApi: PigeonApiClassWithApiRequirement, pigeonInstance: ClassWithApiRequirement)
    throws
}

protocol PigeonApiProtocolClassWithApiRequirement {
}

final class PigeonApiClassWithApiRequirement: PigeonApiProtocolClassWithApiRequirement {
  unowned let pigeonRegistrar: ProxyApiTestsPigeonProxyApiRegistrar
  let pigeonDelegate: PigeonApiDelegateClassWithApiRequirement
  init(
    pigeonRegistrar: ProxyApiTestsPigeonProxyApiRegistrar,
    delegate: PigeonApiDelegateClassWithApiRequirement
  ) {
    self.pigeonRegistrar = pigeonRegistrar
    self.pigeonDelegate = delegate
  }
  static func setUpMessageHandlers(
    binaryMessenger: FlutterBinaryMessenger, api: PigeonApiClassWithApiRequirement?
  ) {
    let codec: FlutterStandardMessageCodec =
      api != nil
      ? FlutterStandardMessageCodec(
        readerWriter: ProxyApiTestsPigeonInternalProxyApiCodecReaderWriter(
          pigeonRegistrar: api!.pigeonRegistrar))
      : FlutterStandardMessageCodec.sharedInstance()
    if #available(iOS 15.0.0, macOS 10.0.0, *) {
      let pigeonDefaultConstructorChannel = FlutterBasicMessageChannel(
        name:
          "dev.flutter.pigeon.pigeon_integration_tests.ClassWithApiRequirement.pigeon_defaultConstructor",
        binaryMessenger: binaryMessenger, codec: codec)
      if let api = api {
        pigeonDefaultConstructorChannel.setMessageHandler { message, reply in
          let args = message as! [Any?]
          let pigeonIdentifierArg = args[0] as! Int64
          do {
            api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
              try api.pigeonDelegate.pigeonDefaultConstructor(pigeonApi: api),
              withIdentifier: pigeonIdentifierArg)
            reply(wrapResult(nil))
          } catch {
            reply(wrapError(error))
          }
        }
      } else {
        pigeonDefaultConstructorChannel.setMessageHandler(nil)
      }
    } else {
      let pigeonDefaultConstructorChannel = FlutterBasicMessageChannel(
        name:
          "dev.flutter.pigeon.pigeon_integration_tests.ClassWithApiRequirement.pigeon_defaultConstructor",
        binaryMessenger: binaryMessenger, codec: codec)
      if api != nil {
        pigeonDefaultConstructorChannel.setMessageHandler { message, reply in
          reply(
            wrapError(
              FlutterError(
                code: "PigeonUnsupportedOperationError",
                message:
                  "Call to pigeonDefaultConstructor requires @available(iOS 15.0.0, macOS 10.0.0, *).",
                details: nil
              )))
        }
      } else {
        pigeonDefaultConstructorChannel.setMessageHandler(nil)
      }
    }
    if #available(iOS 15.0.0, macOS 10.0.0, *) {
      let aMethodChannel = FlutterBasicMessageChannel(
        name: "dev.flutter.pigeon.pigeon_integration_tests.ClassWithApiRequirement.aMethod",
        binaryMessenger: binaryMessenger, codec: codec)
      if let api = api {
        aMethodChannel.setMessageHandler { message, reply in
          let args = message as! [Any?]
          let pigeonInstanceArg = args[0] as! ClassWithApiRequirement
          do {
            try api.pigeonDelegate.aMethod(pigeonApi: api, pigeonInstance: pigeonInstanceArg)
            reply(wrapResult(nil))
          } catch {
            reply(wrapError(error))
          }
        }
      } else {
        aMethodChannel.setMessageHandler(nil)
      }
    } else {
      let aMethodChannel = FlutterBasicMessageChannel(
        name: "dev.flutter.pigeon.pigeon_integration_tests.ClassWithApiRequirement.aMethod",
        binaryMessenger: binaryMessenger, codec: codec)
      if api != nil {
        aMethodChannel.setMessageHandler { message, reply in
          reply(
            wrapError(
              FlutterError(
                code: "PigeonUnsupportedOperationError",
                message: "Call to aMethod requires @available(iOS 15.0.0, macOS 10.0.0, *).",
                details: nil
              )))
        }
      } else {
        aMethodChannel.setMessageHandler(nil)
      }
    }
  }

  ///Creates a Dart instance of ClassWithApiRequirement and attaches it to [pigeonInstance].
  @available(iOS 15.0.0, macOS 10.0.0, *)
  func pigeonNewInstance(
    pigeonInstance: ClassWithApiRequirement,
    completion: @escaping (Result<Void, ProxyApiTestsError>) -> Void
  ) {
    if pigeonRegistrar.ignoreCallsToDart {
      completion(
        .failure(
          ProxyApiTestsError(
            code: "ignore-calls-error",
            message: "Calls to Dart are being ignored.", details: "")))
    } else if pigeonRegistrar.instanceManager.containsInstance(pigeonInstance as AnyObject) {
      completion(.success(()))
    } else {
      let pigeonIdentifierArg = pigeonRegistrar.instanceManager.addHostCreatedInstance(
        pigeonInstance as AnyObject)
      let binaryMessenger = pigeonRegistrar.binaryMessenger
      let codec = pigeonRegistrar.codec
      let channelName: String =
        "dev.flutter.pigeon.pigeon_integration_tests.ClassWithApiRequirement.pigeon_newInstance"
      let channel = FlutterBasicMessageChannel(
        name: channelName, binaryMessenger: binaryMessenger, codec: codec)
      channel.sendMessage([pigeonIdentifierArg] as [Any?]) { response in
        guard let listResponse = response as? [Any?] else {
          completion(.failure(createConnectionError(withChannelName: channelName)))
          return
        }
        if listResponse.count > 1 {
          let code: String = listResponse[0] as! String
          let message: String? = nilOrValue(listResponse[1])
          let details: String? = nilOrValue(listResponse[2])
          completion(.failure(ProxyApiTestsError(code: code, message: message, details: details)))
        } else {
          completion(.success(()))
        }
      }
    }
  }
}
