// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// Autogenerated from Pigeon, do not edit directly.
// See also: https://pub.dev/packages/pigeon

package com.example.alternate_language_test_plugin;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.CLASS;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import java.io.ByteArrayOutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/** Generated class from Pigeon. */
@SuppressWarnings({"unused", "unchecked", "CodeBlock2Expr", "RedundantSuppression", "serial"})
public class CoreTests {

  /** Error class for passing custom error details to Flutter via a thrown PlatformException. */
  public static class FlutterError extends RuntimeException {

    /** The error code. */
    public final String code;

    /** The error details. Must be a datatype supported by the api codec. */
    public final Object details;

    public FlutterError(@NonNull String code, @Nullable String message, @Nullable Object details) {
      super(message);
      this.code = code;
      this.details = details;
    }
  }

  @NonNull
  protected static ArrayList<Object> wrapError(@NonNull Throwable exception) {
    ArrayList<Object> errorList = new ArrayList<>(3);
    if (exception instanceof FlutterError) {
      FlutterError error = (FlutterError) exception;
      errorList.add(error.code);
      errorList.add(error.getMessage());
      errorList.add(error.details);
    } else {
      errorList.add(exception.toString());
      errorList.add(exception.getClass().getSimpleName());
      errorList.add(
          "Cause: " + exception.getCause() + ", Stacktrace: " + Log.getStackTraceString(exception));
    }
    return errorList;
  }

  @NonNull
  protected static FlutterError createConnectionError(@NonNull String channelName) {
    return new FlutterError(
        "channel-error", "Unable to establish connection on channel: " + channelName + ".", "");
  }

  @Target(METHOD)
  @Retention(CLASS)
  @interface CanIgnoreReturnValue {}

  public enum AnEnum {
    ONE(0),
    TWO(1),
    THREE(2),
    FORTY_TWO(3),
    FOUR_HUNDRED_TWENTY_TWO(4);

    final int index;

    AnEnum(final int index) {
      this.index = index;
    }
  }

  public enum AnotherEnum {
    JUST_IN_CASE(0);

    final int index;

    AnotherEnum(final int index) {
      this.index = index;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class UnusedClass {
    private @Nullable Object aField;

    public @Nullable Object getAField() {
      return aField;
    }

    public void setAField(@Nullable Object setterArg) {
      this.aField = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (o == null || getClass() != o.getClass()) {
        return false;
      }
      UnusedClass that = (UnusedClass) o;
      return Objects.equals(aField, that.aField);
    }

    @Override
    public int hashCode() {
      return Objects.hash(aField);
    }

    public static final class Builder {

      private @Nullable Object aField;

      @CanIgnoreReturnValue
      public @NonNull Builder setAField(@Nullable Object setterArg) {
        this.aField = setterArg;
        return this;
      }

      public @NonNull UnusedClass build() {
        UnusedClass pigeonReturn = new UnusedClass();
        pigeonReturn.setAField(aField);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(1);
      toListResult.add(aField);
      return toListResult;
    }

    static @NonNull UnusedClass fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      UnusedClass pigeonResult = new UnusedClass();
      Object aField = pigeonVar_list.get(0);
      pigeonResult.setAField(aField);
      return pigeonResult;
    }
  }

  /**
   * A class containing all supported types.
   *
   * <p>Generated class from Pigeon that represents data sent in messages.
   */
  public static final class AllTypes {
    private @NonNull Boolean aBool;

    public @NonNull Boolean getABool() {
      return aBool;
    }

    public void setABool(@NonNull Boolean setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"aBool\" is null.");
      }
      this.aBool = setterArg;
    }

    private @NonNull Long anInt;

    public @NonNull Long getAnInt() {
      return anInt;
    }

    public void setAnInt(@NonNull Long setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"anInt\" is null.");
      }
      this.anInt = setterArg;
    }

    private @NonNull Long anInt64;

    public @NonNull Long getAnInt64() {
      return anInt64;
    }

    public void setAnInt64(@NonNull Long setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"anInt64\" is null.");
      }
      this.anInt64 = setterArg;
    }

    private @NonNull Double aDouble;

    public @NonNull Double getADouble() {
      return aDouble;
    }

    public void setADouble(@NonNull Double setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"aDouble\" is null.");
      }
      this.aDouble = setterArg;
    }

    private @NonNull byte[] aByteArray;

    public @NonNull byte[] getAByteArray() {
      return aByteArray;
    }

    public void setAByteArray(@NonNull byte[] setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"aByteArray\" is null.");
      }
      this.aByteArray = setterArg;
    }

    private @NonNull int[] a4ByteArray;

    public @NonNull int[] getA4ByteArray() {
      return a4ByteArray;
    }

    public void setA4ByteArray(@NonNull int[] setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"a4ByteArray\" is null.");
      }
      this.a4ByteArray = setterArg;
    }

    private @NonNull long[] a8ByteArray;

    public @NonNull long[] getA8ByteArray() {
      return a8ByteArray;
    }

    public void setA8ByteArray(@NonNull long[] setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"a8ByteArray\" is null.");
      }
      this.a8ByteArray = setterArg;
    }

    private @NonNull double[] aFloatArray;

    public @NonNull double[] getAFloatArray() {
      return aFloatArray;
    }

    public void setAFloatArray(@NonNull double[] setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"aFloatArray\" is null.");
      }
      this.aFloatArray = setterArg;
    }

    private @NonNull AnEnum anEnum;

    public @NonNull AnEnum getAnEnum() {
      return anEnum;
    }

    public void setAnEnum(@NonNull AnEnum setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"anEnum\" is null.");
      }
      this.anEnum = setterArg;
    }

    private @NonNull AnotherEnum anotherEnum;

    public @NonNull AnotherEnum getAnotherEnum() {
      return anotherEnum;
    }

    public void setAnotherEnum(@NonNull AnotherEnum setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"anotherEnum\" is null.");
      }
      this.anotherEnum = setterArg;
    }

    private @NonNull String aString;

    public @NonNull String getAString() {
      return aString;
    }

    public void setAString(@NonNull String setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"aString\" is null.");
      }
      this.aString = setterArg;
    }

    private @NonNull Object anObject;

    public @NonNull Object getAnObject() {
      return anObject;
    }

    public void setAnObject(@NonNull Object setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"anObject\" is null.");
      }
      this.anObject = setterArg;
    }

    private @NonNull List<Object> list;

    public @NonNull List<Object> getList() {
      return list;
    }

    public void setList(@NonNull List<Object> setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"list\" is null.");
      }
      this.list = setterArg;
    }

    private @NonNull List<String> stringList;

    public @NonNull List<String> getStringList() {
      return stringList;
    }

    public void setStringList(@NonNull List<String> setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"stringList\" is null.");
      }
      this.stringList = setterArg;
    }

    private @NonNull List<Long> intList;

    public @NonNull List<Long> getIntList() {
      return intList;
    }

    public void setIntList(@NonNull List<Long> setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"intList\" is null.");
      }
      this.intList = setterArg;
    }

    private @NonNull List<Double> doubleList;

    public @NonNull List<Double> getDoubleList() {
      return doubleList;
    }

    public void setDoubleList(@NonNull List<Double> setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"doubleList\" is null.");
      }
      this.doubleList = setterArg;
    }

    private @NonNull List<Boolean> boolList;

    public @NonNull List<Boolean> getBoolList() {
      return boolList;
    }

    public void setBoolList(@NonNull List<Boolean> setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"boolList\" is null.");
      }
      this.boolList = setterArg;
    }

    private @NonNull List<AnEnum> enumList;

    public @NonNull List<AnEnum> getEnumList() {
      return enumList;
    }

    public void setEnumList(@NonNull List<AnEnum> setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"enumList\" is null.");
      }
      this.enumList = setterArg;
    }

    private @NonNull List<Object> objectList;

    public @NonNull List<Object> getObjectList() {
      return objectList;
    }

    public void setObjectList(@NonNull List<Object> setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"objectList\" is null.");
      }
      this.objectList = setterArg;
    }

    private @NonNull List<List<Object>> listList;

    public @NonNull List<List<Object>> getListList() {
      return listList;
    }

    public void setListList(@NonNull List<List<Object>> setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"listList\" is null.");
      }
      this.listList = setterArg;
    }

    private @NonNull List<Map<Object, Object>> mapList;

    public @NonNull List<Map<Object, Object>> getMapList() {
      return mapList;
    }

    public void setMapList(@NonNull List<Map<Object, Object>> setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"mapList\" is null.");
      }
      this.mapList = setterArg;
    }

    private @NonNull Map<Object, Object> map;

    public @NonNull Map<Object, Object> getMap() {
      return map;
    }

    public void setMap(@NonNull Map<Object, Object> setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"map\" is null.");
      }
      this.map = setterArg;
    }

    private @NonNull Map<String, String> stringMap;

    public @NonNull Map<String, String> getStringMap() {
      return stringMap;
    }

    public void setStringMap(@NonNull Map<String, String> setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"stringMap\" is null.");
      }
      this.stringMap = setterArg;
    }

    private @NonNull Map<Long, Long> intMap;

    public @NonNull Map<Long, Long> getIntMap() {
      return intMap;
    }

    public void setIntMap(@NonNull Map<Long, Long> setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"intMap\" is null.");
      }
      this.intMap = setterArg;
    }

    private @NonNull Map<AnEnum, AnEnum> enumMap;

    public @NonNull Map<AnEnum, AnEnum> getEnumMap() {
      return enumMap;
    }

    public void setEnumMap(@NonNull Map<AnEnum, AnEnum> setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"enumMap\" is null.");
      }
      this.enumMap = setterArg;
    }

    private @NonNull Map<Object, Object> objectMap;

    public @NonNull Map<Object, Object> getObjectMap() {
      return objectMap;
    }

    public void setObjectMap(@NonNull Map<Object, Object> setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"objectMap\" is null.");
      }
      this.objectMap = setterArg;
    }

    private @NonNull Map<Long, List<Object>> listMap;

    public @NonNull Map<Long, List<Object>> getListMap() {
      return listMap;
    }

    public void setListMap(@NonNull Map<Long, List<Object>> setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"listMap\" is null.");
      }
      this.listMap = setterArg;
    }

    private @NonNull Map<Long, Map<Object, Object>> mapMap;

    public @NonNull Map<Long, Map<Object, Object>> getMapMap() {
      return mapMap;
    }

    public void setMapMap(@NonNull Map<Long, Map<Object, Object>> setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"mapMap\" is null.");
      }
      this.mapMap = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    AllTypes() {}

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (o == null || getClass() != o.getClass()) {
        return false;
      }
      AllTypes that = (AllTypes) o;
      return aBool.equals(that.aBool)
          && anInt.equals(that.anInt)
          && anInt64.equals(that.anInt64)
          && aDouble.equals(that.aDouble)
          && Arrays.equals(aByteArray, that.aByteArray)
          && Arrays.equals(a4ByteArray, that.a4ByteArray)
          && Arrays.equals(a8ByteArray, that.a8ByteArray)
          && Arrays.equals(aFloatArray, that.aFloatArray)
          && anEnum.equals(that.anEnum)
          && anotherEnum.equals(that.anotherEnum)
          && aString.equals(that.aString)
          && anObject.equals(that.anObject)
          && list.equals(that.list)
          && stringList.equals(that.stringList)
          && intList.equals(that.intList)
          && doubleList.equals(that.doubleList)
          && boolList.equals(that.boolList)
          && enumList.equals(that.enumList)
          && objectList.equals(that.objectList)
          && listList.equals(that.listList)
          && mapList.equals(that.mapList)
          && map.equals(that.map)
          && stringMap.equals(that.stringMap)
          && intMap.equals(that.intMap)
          && enumMap.equals(that.enumMap)
          && objectMap.equals(that.objectMap)
          && listMap.equals(that.listMap)
          && mapMap.equals(that.mapMap);
    }

    @Override
    public int hashCode() {
      int pigeonVar_result =
          Objects.hash(
              aBool,
              anInt,
              anInt64,
              aDouble,
              anEnum,
              anotherEnum,
              aString,
              anObject,
              list,
              stringList,
              intList,
              doubleList,
              boolList,
              enumList,
              objectList,
              listList,
              mapList,
              map,
              stringMap,
              intMap,
              enumMap,
              objectMap,
              listMap,
              mapMap);
      pigeonVar_result = 31 * pigeonVar_result + Arrays.hashCode(aByteArray);
      pigeonVar_result = 31 * pigeonVar_result + Arrays.hashCode(a4ByteArray);
      pigeonVar_result = 31 * pigeonVar_result + Arrays.hashCode(a8ByteArray);
      pigeonVar_result = 31 * pigeonVar_result + Arrays.hashCode(aFloatArray);
      return pigeonVar_result;
    }

    public static final class Builder {

      private @Nullable Boolean aBool;

      @CanIgnoreReturnValue
      public @NonNull Builder setABool(@NonNull Boolean setterArg) {
        this.aBool = setterArg;
        return this;
      }

      private @Nullable Long anInt;

      @CanIgnoreReturnValue
      public @NonNull Builder setAnInt(@NonNull Long setterArg) {
        this.anInt = setterArg;
        return this;
      }

      private @Nullable Long anInt64;

      @CanIgnoreReturnValue
      public @NonNull Builder setAnInt64(@NonNull Long setterArg) {
        this.anInt64 = setterArg;
        return this;
      }

      private @Nullable Double aDouble;

      @CanIgnoreReturnValue
      public @NonNull Builder setADouble(@NonNull Double setterArg) {
        this.aDouble = setterArg;
        return this;
      }

      private @Nullable byte[] aByteArray;

      @CanIgnoreReturnValue
      public @NonNull Builder setAByteArray(@NonNull byte[] setterArg) {
        this.aByteArray = setterArg;
        return this;
      }

      private @Nullable int[] a4ByteArray;

      @CanIgnoreReturnValue
      public @NonNull Builder setA4ByteArray(@NonNull int[] setterArg) {
        this.a4ByteArray = setterArg;
        return this;
      }

      private @Nullable long[] a8ByteArray;

      @CanIgnoreReturnValue
      public @NonNull Builder setA8ByteArray(@NonNull long[] setterArg) {
        this.a8ByteArray = setterArg;
        return this;
      }

      private @Nullable double[] aFloatArray;

      @CanIgnoreReturnValue
      public @NonNull Builder setAFloatArray(@NonNull double[] setterArg) {
        this.aFloatArray = setterArg;
        return this;
      }

      private @Nullable AnEnum anEnum;

      @CanIgnoreReturnValue
      public @NonNull Builder setAnEnum(@NonNull AnEnum setterArg) {
        this.anEnum = setterArg;
        return this;
      }

      private @Nullable AnotherEnum anotherEnum;

      @CanIgnoreReturnValue
      public @NonNull Builder setAnotherEnum(@NonNull AnotherEnum setterArg) {
        this.anotherEnum = setterArg;
        return this;
      }

      private @Nullable String aString;

      @CanIgnoreReturnValue
      public @NonNull Builder setAString(@NonNull String setterArg) {
        this.aString = setterArg;
        return this;
      }

      private @Nullable Object anObject;

      @CanIgnoreReturnValue
      public @NonNull Builder setAnObject(@NonNull Object setterArg) {
        this.anObject = setterArg;
        return this;
      }

      private @Nullable List<Object> list;

      @CanIgnoreReturnValue
      public @NonNull Builder setList(@NonNull List<Object> setterArg) {
        this.list = setterArg;
        return this;
      }

      private @Nullable List<String> stringList;

      @CanIgnoreReturnValue
      public @NonNull Builder setStringList(@NonNull List<String> setterArg) {
        this.stringList = setterArg;
        return this;
      }

      private @Nullable List<Long> intList;

      @CanIgnoreReturnValue
      public @NonNull Builder setIntList(@NonNull List<Long> setterArg) {
        this.intList = setterArg;
        return this;
      }

      private @Nullable List<Double> doubleList;

      @CanIgnoreReturnValue
      public @NonNull Builder setDoubleList(@NonNull List<Double> setterArg) {
        this.doubleList = setterArg;
        return this;
      }

      private @Nullable List<Boolean> boolList;

      @CanIgnoreReturnValue
      public @NonNull Builder setBoolList(@NonNull List<Boolean> setterArg) {
        this.boolList = setterArg;
        return this;
      }

      private @Nullable List<AnEnum> enumList;

      @CanIgnoreReturnValue
      public @NonNull Builder setEnumList(@NonNull List<AnEnum> setterArg) {
        this.enumList = setterArg;
        return this;
      }

      private @Nullable List<Object> objectList;

      @CanIgnoreReturnValue
      public @NonNull Builder setObjectList(@NonNull List<Object> setterArg) {
        this.objectList = setterArg;
        return this;
      }

      private @Nullable List<List<Object>> listList;

      @CanIgnoreReturnValue
      public @NonNull Builder setListList(@NonNull List<List<Object>> setterArg) {
        this.listList = setterArg;
        return this;
      }

      private @Nullable List<Map<Object, Object>> mapList;

      @CanIgnoreReturnValue
      public @NonNull Builder setMapList(@NonNull List<Map<Object, Object>> setterArg) {
        this.mapList = setterArg;
        return this;
      }

      private @Nullable Map<Object, Object> map;

      @CanIgnoreReturnValue
      public @NonNull Builder setMap(@NonNull Map<Object, Object> setterArg) {
        this.map = setterArg;
        return this;
      }

      private @Nullable Map<String, String> stringMap;

      @CanIgnoreReturnValue
      public @NonNull Builder setStringMap(@NonNull Map<String, String> setterArg) {
        this.stringMap = setterArg;
        return this;
      }

      private @Nullable Map<Long, Long> intMap;

      @CanIgnoreReturnValue
      public @NonNull Builder setIntMap(@NonNull Map<Long, Long> setterArg) {
        this.intMap = setterArg;
        return this;
      }

      private @Nullable Map<AnEnum, AnEnum> enumMap;

      @CanIgnoreReturnValue
      public @NonNull Builder setEnumMap(@NonNull Map<AnEnum, AnEnum> setterArg) {
        this.enumMap = setterArg;
        return this;
      }

      private @Nullable Map<Object, Object> objectMap;

      @CanIgnoreReturnValue
      public @NonNull Builder setObjectMap(@NonNull Map<Object, Object> setterArg) {
        this.objectMap = setterArg;
        return this;
      }

      private @Nullable Map<Long, List<Object>> listMap;

      @CanIgnoreReturnValue
      public @NonNull Builder setListMap(@NonNull Map<Long, List<Object>> setterArg) {
        this.listMap = setterArg;
        return this;
      }

      private @Nullable Map<Long, Map<Object, Object>> mapMap;

      @CanIgnoreReturnValue
      public @NonNull Builder setMapMap(@NonNull Map<Long, Map<Object, Object>> setterArg) {
        this.mapMap = setterArg;
        return this;
      }

      public @NonNull AllTypes build() {
        AllTypes pigeonReturn = new AllTypes();
        pigeonReturn.setABool(aBool);
        pigeonReturn.setAnInt(anInt);
        pigeonReturn.setAnInt64(anInt64);
        pigeonReturn.setADouble(aDouble);
        pigeonReturn.setAByteArray(aByteArray);
        pigeonReturn.setA4ByteArray(a4ByteArray);
        pigeonReturn.setA8ByteArray(a8ByteArray);
        pigeonReturn.setAFloatArray(aFloatArray);
        pigeonReturn.setAnEnum(anEnum);
        pigeonReturn.setAnotherEnum(anotherEnum);
        pigeonReturn.setAString(aString);
        pigeonReturn.setAnObject(anObject);
        pigeonReturn.setList(list);
        pigeonReturn.setStringList(stringList);
        pigeonReturn.setIntList(intList);
        pigeonReturn.setDoubleList(doubleList);
        pigeonReturn.setBoolList(boolList);
        pigeonReturn.setEnumList(enumList);
        pigeonReturn.setObjectList(objectList);
        pigeonReturn.setListList(listList);
        pigeonReturn.setMapList(mapList);
        pigeonReturn.setMap(map);
        pigeonReturn.setStringMap(stringMap);
        pigeonReturn.setIntMap(intMap);
        pigeonReturn.setEnumMap(enumMap);
        pigeonReturn.setObjectMap(objectMap);
        pigeonReturn.setListMap(listMap);
        pigeonReturn.setMapMap(mapMap);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(28);
      toListResult.add(aBool);
      toListResult.add(anInt);
      toListResult.add(anInt64);
      toListResult.add(aDouble);
      toListResult.add(aByteArray);
      toListResult.add(a4ByteArray);
      toListResult.add(a8ByteArray);
      toListResult.add(aFloatArray);
      toListResult.add(anEnum);
      toListResult.add(anotherEnum);
      toListResult.add(aString);
      toListResult.add(anObject);
      toListResult.add(list);
      toListResult.add(stringList);
      toListResult.add(intList);
      toListResult.add(doubleList);
      toListResult.add(boolList);
      toListResult.add(enumList);
      toListResult.add(objectList);
      toListResult.add(listList);
      toListResult.add(mapList);
      toListResult.add(map);
      toListResult.add(stringMap);
      toListResult.add(intMap);
      toListResult.add(enumMap);
      toListResult.add(objectMap);
      toListResult.add(listMap);
      toListResult.add(mapMap);
      return toListResult;
    }

    static @NonNull AllTypes fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      AllTypes pigeonResult = new AllTypes();
      Object aBool = pigeonVar_list.get(0);
      pigeonResult.setABool((Boolean) aBool);
      Object anInt = pigeonVar_list.get(1);
      pigeonResult.setAnInt((Long) anInt);
      Object anInt64 = pigeonVar_list.get(2);
      pigeonResult.setAnInt64((Long) anInt64);
      Object aDouble = pigeonVar_list.get(3);
      pigeonResult.setADouble((Double) aDouble);
      Object aByteArray = pigeonVar_list.get(4);
      pigeonResult.setAByteArray((byte[]) aByteArray);
      Object a4ByteArray = pigeonVar_list.get(5);
      pigeonResult.setA4ByteArray((int[]) a4ByteArray);
      Object a8ByteArray = pigeonVar_list.get(6);
      pigeonResult.setA8ByteArray((long[]) a8ByteArray);
      Object aFloatArray = pigeonVar_list.get(7);
      pigeonResult.setAFloatArray((double[]) aFloatArray);
      Object anEnum = pigeonVar_list.get(8);
      pigeonResult.setAnEnum((AnEnum) anEnum);
      Object anotherEnum = pigeonVar_list.get(9);
      pigeonResult.setAnotherEnum((AnotherEnum) anotherEnum);
      Object aString = pigeonVar_list.get(10);
      pigeonResult.setAString((String) aString);
      Object anObject = pigeonVar_list.get(11);
      pigeonResult.setAnObject(anObject);
      Object list = pigeonVar_list.get(12);
      pigeonResult.setList((List<Object>) list);
      Object stringList = pigeonVar_list.get(13);
      pigeonResult.setStringList((List<String>) stringList);
      Object intList = pigeonVar_list.get(14);
      pigeonResult.setIntList((List<Long>) intList);
      Object doubleList = pigeonVar_list.get(15);
      pigeonResult.setDoubleList((List<Double>) doubleList);
      Object boolList = pigeonVar_list.get(16);
      pigeonResult.setBoolList((List<Boolean>) boolList);
      Object enumList = pigeonVar_list.get(17);
      pigeonResult.setEnumList((List<AnEnum>) enumList);
      Object objectList = pigeonVar_list.get(18);
      pigeonResult.setObjectList((List<Object>) objectList);
      Object listList = pigeonVar_list.get(19);
      pigeonResult.setListList((List<List<Object>>) listList);
      Object mapList = pigeonVar_list.get(20);
      pigeonResult.setMapList((List<Map<Object, Object>>) mapList);
      Object map = pigeonVar_list.get(21);
      pigeonResult.setMap((Map<Object, Object>) map);
      Object stringMap = pigeonVar_list.get(22);
      pigeonResult.setStringMap((Map<String, String>) stringMap);
      Object intMap = pigeonVar_list.get(23);
      pigeonResult.setIntMap((Map<Long, Long>) intMap);
      Object enumMap = pigeonVar_list.get(24);
      pigeonResult.setEnumMap((Map<AnEnum, AnEnum>) enumMap);
      Object objectMap = pigeonVar_list.get(25);
      pigeonResult.setObjectMap((Map<Object, Object>) objectMap);
      Object listMap = pigeonVar_list.get(26);
      pigeonResult.setListMap((Map<Long, List<Object>>) listMap);
      Object mapMap = pigeonVar_list.get(27);
      pigeonResult.setMapMap((Map<Long, Map<Object, Object>>) mapMap);
      return pigeonResult;
    }
  }

  /**
   * A class containing all supported nullable types.
   *
   * <p>Generated class from Pigeon that represents data sent in messages.
   */
  public static final class AllNullableTypes {
    private @Nullable Boolean aNullableBool;

    public @Nullable Boolean getANullableBool() {
      return aNullableBool;
    }

    public void setANullableBool(@Nullable Boolean setterArg) {
      this.aNullableBool = setterArg;
    }

    private @Nullable Long aNullableInt;

    public @Nullable Long getANullableInt() {
      return aNullableInt;
    }

    public void setANullableInt(@Nullable Long setterArg) {
      this.aNullableInt = setterArg;
    }

    private @Nullable Long aNullableInt64;

    public @Nullable Long getANullableInt64() {
      return aNullableInt64;
    }

    public void setANullableInt64(@Nullable Long setterArg) {
      this.aNullableInt64 = setterArg;
    }

    private @Nullable Double aNullableDouble;

    public @Nullable Double getANullableDouble() {
      return aNullableDouble;
    }

    public void setANullableDouble(@Nullable Double setterArg) {
      this.aNullableDouble = setterArg;
    }

    private @Nullable byte[] aNullableByteArray;

    public @Nullable byte[] getANullableByteArray() {
      return aNullableByteArray;
    }

    public void setANullableByteArray(@Nullable byte[] setterArg) {
      this.aNullableByteArray = setterArg;
    }

    private @Nullable int[] aNullable4ByteArray;

    public @Nullable int[] getANullable4ByteArray() {
      return aNullable4ByteArray;
    }

    public void setANullable4ByteArray(@Nullable int[] setterArg) {
      this.aNullable4ByteArray = setterArg;
    }

    private @Nullable long[] aNullable8ByteArray;

    public @Nullable long[] getANullable8ByteArray() {
      return aNullable8ByteArray;
    }

    public void setANullable8ByteArray(@Nullable long[] setterArg) {
      this.aNullable8ByteArray = setterArg;
    }

    private @Nullable double[] aNullableFloatArray;

    public @Nullable double[] getANullableFloatArray() {
      return aNullableFloatArray;
    }

    public void setANullableFloatArray(@Nullable double[] setterArg) {
      this.aNullableFloatArray = setterArg;
    }

    private @Nullable AnEnum aNullableEnum;

    public @Nullable AnEnum getANullableEnum() {
      return aNullableEnum;
    }

    public void setANullableEnum(@Nullable AnEnum setterArg) {
      this.aNullableEnum = setterArg;
    }

    private @Nullable AnotherEnum anotherNullableEnum;

    public @Nullable AnotherEnum getAnotherNullableEnum() {
      return anotherNullableEnum;
    }

    public void setAnotherNullableEnum(@Nullable AnotherEnum setterArg) {
      this.anotherNullableEnum = setterArg;
    }

    private @Nullable String aNullableString;

    public @Nullable String getANullableString() {
      return aNullableString;
    }

    public void setANullableString(@Nullable String setterArg) {
      this.aNullableString = setterArg;
    }

    private @Nullable Object aNullableObject;

    public @Nullable Object getANullableObject() {
      return aNullableObject;
    }

    public void setANullableObject(@Nullable Object setterArg) {
      this.aNullableObject = setterArg;
    }

    private @Nullable AllNullableTypes allNullableTypes;

    public @Nullable AllNullableTypes getAllNullableTypes() {
      return allNullableTypes;
    }

    public void setAllNullableTypes(@Nullable AllNullableTypes setterArg) {
      this.allNullableTypes = setterArg;
    }

    private @Nullable List<Object> list;

    public @Nullable List<Object> getList() {
      return list;
    }

    public void setList(@Nullable List<Object> setterArg) {
      this.list = setterArg;
    }

    private @Nullable List<String> stringList;

    public @Nullable List<String> getStringList() {
      return stringList;
    }

    public void setStringList(@Nullable List<String> setterArg) {
      this.stringList = setterArg;
    }

    private @Nullable List<Long> intList;

    public @Nullable List<Long> getIntList() {
      return intList;
    }

    public void setIntList(@Nullable List<Long> setterArg) {
      this.intList = setterArg;
    }

    private @Nullable List<Double> doubleList;

    public @Nullable List<Double> getDoubleList() {
      return doubleList;
    }

    public void setDoubleList(@Nullable List<Double> setterArg) {
      this.doubleList = setterArg;
    }

    private @Nullable List<Boolean> boolList;

    public @Nullable List<Boolean> getBoolList() {
      return boolList;
    }

    public void setBoolList(@Nullable List<Boolean> setterArg) {
      this.boolList = setterArg;
    }

    private @Nullable List<AnEnum> enumList;

    public @Nullable List<AnEnum> getEnumList() {
      return enumList;
    }

    public void setEnumList(@Nullable List<AnEnum> setterArg) {
      this.enumList = setterArg;
    }

    private @Nullable List<Object> objectList;

    public @Nullable List<Object> getObjectList() {
      return objectList;
    }

    public void setObjectList(@Nullable List<Object> setterArg) {
      this.objectList = setterArg;
    }

    private @Nullable List<List<Object>> listList;

    public @Nullable List<List<Object>> getListList() {
      return listList;
    }

    public void setListList(@Nullable List<List<Object>> setterArg) {
      this.listList = setterArg;
    }

    private @Nullable List<Map<Object, Object>> mapList;

    public @Nullable List<Map<Object, Object>> getMapList() {
      return mapList;
    }

    public void setMapList(@Nullable List<Map<Object, Object>> setterArg) {
      this.mapList = setterArg;
    }

    private @Nullable List<AllNullableTypes> recursiveClassList;

    public @Nullable List<AllNullableTypes> getRecursiveClassList() {
      return recursiveClassList;
    }

    public void setRecursiveClassList(@Nullable List<AllNullableTypes> setterArg) {
      this.recursiveClassList = setterArg;
    }

    private @Nullable Map<Object, Object> map;

    public @Nullable Map<Object, Object> getMap() {
      return map;
    }

    public void setMap(@Nullable Map<Object, Object> setterArg) {
      this.map = setterArg;
    }

    private @Nullable Map<String, String> stringMap;

    public @Nullable Map<String, String> getStringMap() {
      return stringMap;
    }

    public void setStringMap(@Nullable Map<String, String> setterArg) {
      this.stringMap = setterArg;
    }

    private @Nullable Map<Long, Long> intMap;

    public @Nullable Map<Long, Long> getIntMap() {
      return intMap;
    }

    public void setIntMap(@Nullable Map<Long, Long> setterArg) {
      this.intMap = setterArg;
    }

    private @Nullable Map<AnEnum, AnEnum> enumMap;

    public @Nullable Map<AnEnum, AnEnum> getEnumMap() {
      return enumMap;
    }

    public void setEnumMap(@Nullable Map<AnEnum, AnEnum> setterArg) {
      this.enumMap = setterArg;
    }

    private @Nullable Map<Object, Object> objectMap;

    public @Nullable Map<Object, Object> getObjectMap() {
      return objectMap;
    }

    public void setObjectMap(@Nullable Map<Object, Object> setterArg) {
      this.objectMap = setterArg;
    }

    private @Nullable Map<Long, List<Object>> listMap;

    public @Nullable Map<Long, List<Object>> getListMap() {
      return listMap;
    }

    public void setListMap(@Nullable Map<Long, List<Object>> setterArg) {
      this.listMap = setterArg;
    }

    private @Nullable Map<Long, Map<Object, Object>> mapMap;

    public @Nullable Map<Long, Map<Object, Object>> getMapMap() {
      return mapMap;
    }

    public void setMapMap(@Nullable Map<Long, Map<Object, Object>> setterArg) {
      this.mapMap = setterArg;
    }

    private @Nullable Map<Long, AllNullableTypes> recursiveClassMap;

    public @Nullable Map<Long, AllNullableTypes> getRecursiveClassMap() {
      return recursiveClassMap;
    }

    public void setRecursiveClassMap(@Nullable Map<Long, AllNullableTypes> setterArg) {
      this.recursiveClassMap = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (o == null || getClass() != o.getClass()) {
        return false;
      }
      AllNullableTypes that = (AllNullableTypes) o;
      return Objects.equals(aNullableBool, that.aNullableBool)
          && Objects.equals(aNullableInt, that.aNullableInt)
          && Objects.equals(aNullableInt64, that.aNullableInt64)
          && Objects.equals(aNullableDouble, that.aNullableDouble)
          && Arrays.equals(aNullableByteArray, that.aNullableByteArray)
          && Arrays.equals(aNullable4ByteArray, that.aNullable4ByteArray)
          && Arrays.equals(aNullable8ByteArray, that.aNullable8ByteArray)
          && Arrays.equals(aNullableFloatArray, that.aNullableFloatArray)
          && Objects.equals(aNullableEnum, that.aNullableEnum)
          && Objects.equals(anotherNullableEnum, that.anotherNullableEnum)
          && Objects.equals(aNullableString, that.aNullableString)
          && Objects.equals(aNullableObject, that.aNullableObject)
          && Objects.equals(allNullableTypes, that.allNullableTypes)
          && Objects.equals(list, that.list)
          && Objects.equals(stringList, that.stringList)
          && Objects.equals(intList, that.intList)
          && Objects.equals(doubleList, that.doubleList)
          && Objects.equals(boolList, that.boolList)
          && Objects.equals(enumList, that.enumList)
          && Objects.equals(objectList, that.objectList)
          && Objects.equals(listList, that.listList)
          && Objects.equals(mapList, that.mapList)
          && Objects.equals(recursiveClassList, that.recursiveClassList)
          && Objects.equals(map, that.map)
          && Objects.equals(stringMap, that.stringMap)
          && Objects.equals(intMap, that.intMap)
          && Objects.equals(enumMap, that.enumMap)
          && Objects.equals(objectMap, that.objectMap)
          && Objects.equals(listMap, that.listMap)
          && Objects.equals(mapMap, that.mapMap)
          && Objects.equals(recursiveClassMap, that.recursiveClassMap);
    }

    @Override
    public int hashCode() {
      int pigeonVar_result =
          Objects.hash(
              aNullableBool,
              aNullableInt,
              aNullableInt64,
              aNullableDouble,
              aNullableEnum,
              anotherNullableEnum,
              aNullableString,
              aNullableObject,
              allNullableTypes,
              list,
              stringList,
              intList,
              doubleList,
              boolList,
              enumList,
              objectList,
              listList,
              mapList,
              recursiveClassList,
              map,
              stringMap,
              intMap,
              enumMap,
              objectMap,
              listMap,
              mapMap,
              recursiveClassMap);
      pigeonVar_result = 31 * pigeonVar_result + Arrays.hashCode(aNullableByteArray);
      pigeonVar_result = 31 * pigeonVar_result + Arrays.hashCode(aNullable4ByteArray);
      pigeonVar_result = 31 * pigeonVar_result + Arrays.hashCode(aNullable8ByteArray);
      pigeonVar_result = 31 * pigeonVar_result + Arrays.hashCode(aNullableFloatArray);
      return pigeonVar_result;
    }

    public static final class Builder {

      private @Nullable Boolean aNullableBool;

      @CanIgnoreReturnValue
      public @NonNull Builder setANullableBool(@Nullable Boolean setterArg) {
        this.aNullableBool = setterArg;
        return this;
      }

      private @Nullable Long aNullableInt;

      @CanIgnoreReturnValue
      public @NonNull Builder setANullableInt(@Nullable Long setterArg) {
        this.aNullableInt = setterArg;
        return this;
      }

      private @Nullable Long aNullableInt64;

      @CanIgnoreReturnValue
      public @NonNull Builder setANullableInt64(@Nullable Long setterArg) {
        this.aNullableInt64 = setterArg;
        return this;
      }

      private @Nullable Double aNullableDouble;

      @CanIgnoreReturnValue
      public @NonNull Builder setANullableDouble(@Nullable Double setterArg) {
        this.aNullableDouble = setterArg;
        return this;
      }

      private @Nullable byte[] aNullableByteArray;

      @CanIgnoreReturnValue
      public @NonNull Builder setANullableByteArray(@Nullable byte[] setterArg) {
        this.aNullableByteArray = setterArg;
        return this;
      }

      private @Nullable int[] aNullable4ByteArray;

      @CanIgnoreReturnValue
      public @NonNull Builder setANullable4ByteArray(@Nullable int[] setterArg) {
        this.aNullable4ByteArray = setterArg;
        return this;
      }

      private @Nullable long[] aNullable8ByteArray;

      @CanIgnoreReturnValue
      public @NonNull Builder setANullable8ByteArray(@Nullable long[] setterArg) {
        this.aNullable8ByteArray = setterArg;
        return this;
      }

      private @Nullable double[] aNullableFloatArray;

      @CanIgnoreReturnValue
      public @NonNull Builder setANullableFloatArray(@Nullable double[] setterArg) {
        this.aNullableFloatArray = setterArg;
        return this;
      }

      private @Nullable AnEnum aNullableEnum;

      @CanIgnoreReturnValue
      public @NonNull Builder setANullableEnum(@Nullable AnEnum setterArg) {
        this.aNullableEnum = setterArg;
        return this;
      }

      private @Nullable AnotherEnum anotherNullableEnum;

      @CanIgnoreReturnValue
      public @NonNull Builder setAnotherNullableEnum(@Nullable AnotherEnum setterArg) {
        this.anotherNullableEnum = setterArg;
        return this;
      }

      private @Nullable String aNullableString;

      @CanIgnoreReturnValue
      public @NonNull Builder setANullableString(@Nullable String setterArg) {
        this.aNullableString = setterArg;
        return this;
      }

      private @Nullable Object aNullableObject;

      @CanIgnoreReturnValue
      public @NonNull Builder setANullableObject(@Nullable Object setterArg) {
        this.aNullableObject = setterArg;
        return this;
      }

      private @Nullable AllNullableTypes allNullableTypes;

      @CanIgnoreReturnValue
      public @NonNull Builder setAllNullableTypes(@Nullable AllNullableTypes setterArg) {
        this.allNullableTypes = setterArg;
        return this;
      }

      private @Nullable List<Object> list;

      @CanIgnoreReturnValue
      public @NonNull Builder setList(@Nullable List<Object> setterArg) {
        this.list = setterArg;
        return this;
      }

      private @Nullable List<String> stringList;

      @CanIgnoreReturnValue
      public @NonNull Builder setStringList(@Nullable List<String> setterArg) {
        this.stringList = setterArg;
        return this;
      }

      private @Nullable List<Long> intList;

      @CanIgnoreReturnValue
      public @NonNull Builder setIntList(@Nullable List<Long> setterArg) {
        this.intList = setterArg;
        return this;
      }

      private @Nullable List<Double> doubleList;

      @CanIgnoreReturnValue
      public @NonNull Builder setDoubleList(@Nullable List<Double> setterArg) {
        this.doubleList = setterArg;
        return this;
      }

      private @Nullable List<Boolean> boolList;

      @CanIgnoreReturnValue
      public @NonNull Builder setBoolList(@Nullable List<Boolean> setterArg) {
        this.boolList = setterArg;
        return this;
      }

      private @Nullable List<AnEnum> enumList;

      @CanIgnoreReturnValue
      public @NonNull Builder setEnumList(@Nullable List<AnEnum> setterArg) {
        this.enumList = setterArg;
        return this;
      }

      private @Nullable List<Object> objectList;

      @CanIgnoreReturnValue
      public @NonNull Builder setObjectList(@Nullable List<Object> setterArg) {
        this.objectList = setterArg;
        return this;
      }

      private @Nullable List<List<Object>> listList;

      @CanIgnoreReturnValue
      public @NonNull Builder setListList(@Nullable List<List<Object>> setterArg) {
        this.listList = setterArg;
        return this;
      }

      private @Nullable List<Map<Object, Object>> mapList;

      @CanIgnoreReturnValue
      public @NonNull Builder setMapList(@Nullable List<Map<Object, Object>> setterArg) {
        this.mapList = setterArg;
        return this;
      }

      private @Nullable List<AllNullableTypes> recursiveClassList;

      @CanIgnoreReturnValue
      public @NonNull Builder setRecursiveClassList(@Nullable List<AllNullableTypes> setterArg) {
        this.recursiveClassList = setterArg;
        return this;
      }

      private @Nullable Map<Object, Object> map;

      @CanIgnoreReturnValue
      public @NonNull Builder setMap(@Nullable Map<Object, Object> setterArg) {
        this.map = setterArg;
        return this;
      }

      private @Nullable Map<String, String> stringMap;

      @CanIgnoreReturnValue
      public @NonNull Builder setStringMap(@Nullable Map<String, String> setterArg) {
        this.stringMap = setterArg;
        return this;
      }

      private @Nullable Map<Long, Long> intMap;

      @CanIgnoreReturnValue
      public @NonNull Builder setIntMap(@Nullable Map<Long, Long> setterArg) {
        this.intMap = setterArg;
        return this;
      }

      private @Nullable Map<AnEnum, AnEnum> enumMap;

      @CanIgnoreReturnValue
      public @NonNull Builder setEnumMap(@Nullable Map<AnEnum, AnEnum> setterArg) {
        this.enumMap = setterArg;
        return this;
      }

      private @Nullable Map<Object, Object> objectMap;

      @CanIgnoreReturnValue
      public @NonNull Builder setObjectMap(@Nullable Map<Object, Object> setterArg) {
        this.objectMap = setterArg;
        return this;
      }

      private @Nullable Map<Long, List<Object>> listMap;

      @CanIgnoreReturnValue
      public @NonNull Builder setListMap(@Nullable Map<Long, List<Object>> setterArg) {
        this.listMap = setterArg;
        return this;
      }

      private @Nullable Map<Long, Map<Object, Object>> mapMap;

      @CanIgnoreReturnValue
      public @NonNull Builder setMapMap(@Nullable Map<Long, Map<Object, Object>> setterArg) {
        this.mapMap = setterArg;
        return this;
      }

      private @Nullable Map<Long, AllNullableTypes> recursiveClassMap;

      @CanIgnoreReturnValue
      public @NonNull Builder setRecursiveClassMap(
          @Nullable Map<Long, AllNullableTypes> setterArg) {
        this.recursiveClassMap = setterArg;
        return this;
      }

      public @NonNull AllNullableTypes build() {
        AllNullableTypes pigeonReturn = new AllNullableTypes();
        pigeonReturn.setANullableBool(aNullableBool);
        pigeonReturn.setANullableInt(aNullableInt);
        pigeonReturn.setANullableInt64(aNullableInt64);
        pigeonReturn.setANullableDouble(aNullableDouble);
        pigeonReturn.setANullableByteArray(aNullableByteArray);
        pigeonReturn.setANullable4ByteArray(aNullable4ByteArray);
        pigeonReturn.setANullable8ByteArray(aNullable8ByteArray);
        pigeonReturn.setANullableFloatArray(aNullableFloatArray);
        pigeonReturn.setANullableEnum(aNullableEnum);
        pigeonReturn.setAnotherNullableEnum(anotherNullableEnum);
        pigeonReturn.setANullableString(aNullableString);
        pigeonReturn.setANullableObject(aNullableObject);
        pigeonReturn.setAllNullableTypes(allNullableTypes);
        pigeonReturn.setList(list);
        pigeonReturn.setStringList(stringList);
        pigeonReturn.setIntList(intList);
        pigeonReturn.setDoubleList(doubleList);
        pigeonReturn.setBoolList(boolList);
        pigeonReturn.setEnumList(enumList);
        pigeonReturn.setObjectList(objectList);
        pigeonReturn.setListList(listList);
        pigeonReturn.setMapList(mapList);
        pigeonReturn.setRecursiveClassList(recursiveClassList);
        pigeonReturn.setMap(map);
        pigeonReturn.setStringMap(stringMap);
        pigeonReturn.setIntMap(intMap);
        pigeonReturn.setEnumMap(enumMap);
        pigeonReturn.setObjectMap(objectMap);
        pigeonReturn.setListMap(listMap);
        pigeonReturn.setMapMap(mapMap);
        pigeonReturn.setRecursiveClassMap(recursiveClassMap);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(31);
      toListResult.add(aNullableBool);
      toListResult.add(aNullableInt);
      toListResult.add(aNullableInt64);
      toListResult.add(aNullableDouble);
      toListResult.add(aNullableByteArray);
      toListResult.add(aNullable4ByteArray);
      toListResult.add(aNullable8ByteArray);
      toListResult.add(aNullableFloatArray);
      toListResult.add(aNullableEnum);
      toListResult.add(anotherNullableEnum);
      toListResult.add(aNullableString);
      toListResult.add(aNullableObject);
      toListResult.add(allNullableTypes);
      toListResult.add(list);
      toListResult.add(stringList);
      toListResult.add(intList);
      toListResult.add(doubleList);
      toListResult.add(boolList);
      toListResult.add(enumList);
      toListResult.add(objectList);
      toListResult.add(listList);
      toListResult.add(mapList);
      toListResult.add(recursiveClassList);
      toListResult.add(map);
      toListResult.add(stringMap);
      toListResult.add(intMap);
      toListResult.add(enumMap);
      toListResult.add(objectMap);
      toListResult.add(listMap);
      toListResult.add(mapMap);
      toListResult.add(recursiveClassMap);
      return toListResult;
    }

    static @NonNull AllNullableTypes fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      AllNullableTypes pigeonResult = new AllNullableTypes();
      Object aNullableBool = pigeonVar_list.get(0);
      pigeonResult.setANullableBool((Boolean) aNullableBool);
      Object aNullableInt = pigeonVar_list.get(1);
      pigeonResult.setANullableInt((Long) aNullableInt);
      Object aNullableInt64 = pigeonVar_list.get(2);
      pigeonResult.setANullableInt64((Long) aNullableInt64);
      Object aNullableDouble = pigeonVar_list.get(3);
      pigeonResult.setANullableDouble((Double) aNullableDouble);
      Object aNullableByteArray = pigeonVar_list.get(4);
      pigeonResult.setANullableByteArray((byte[]) aNullableByteArray);
      Object aNullable4ByteArray = pigeonVar_list.get(5);
      pigeonResult.setANullable4ByteArray((int[]) aNullable4ByteArray);
      Object aNullable8ByteArray = pigeonVar_list.get(6);
      pigeonResult.setANullable8ByteArray((long[]) aNullable8ByteArray);
      Object aNullableFloatArray = pigeonVar_list.get(7);
      pigeonResult.setANullableFloatArray((double[]) aNullableFloatArray);
      Object aNullableEnum = pigeonVar_list.get(8);
      pigeonResult.setANullableEnum((AnEnum) aNullableEnum);
      Object anotherNullableEnum = pigeonVar_list.get(9);
      pigeonResult.setAnotherNullableEnum((AnotherEnum) anotherNullableEnum);
      Object aNullableString = pigeonVar_list.get(10);
      pigeonResult.setANullableString((String) aNullableString);
      Object aNullableObject = pigeonVar_list.get(11);
      pigeonResult.setANullableObject(aNullableObject);
      Object allNullableTypes = pigeonVar_list.get(12);
      pigeonResult.setAllNullableTypes((AllNullableTypes) allNullableTypes);
      Object list = pigeonVar_list.get(13);
      pigeonResult.setList((List<Object>) list);
      Object stringList = pigeonVar_list.get(14);
      pigeonResult.setStringList((List<String>) stringList);
      Object intList = pigeonVar_list.get(15);
      pigeonResult.setIntList((List<Long>) intList);
      Object doubleList = pigeonVar_list.get(16);
      pigeonResult.setDoubleList((List<Double>) doubleList);
      Object boolList = pigeonVar_list.get(17);
      pigeonResult.setBoolList((List<Boolean>) boolList);
      Object enumList = pigeonVar_list.get(18);
      pigeonResult.setEnumList((List<AnEnum>) enumList);
      Object objectList = pigeonVar_list.get(19);
      pigeonResult.setObjectList((List<Object>) objectList);
      Object listList = pigeonVar_list.get(20);
      pigeonResult.setListList((List<List<Object>>) listList);
      Object mapList = pigeonVar_list.get(21);
      pigeonResult.setMapList((List<Map<Object, Object>>) mapList);
      Object recursiveClassList = pigeonVar_list.get(22);
      pigeonResult.setRecursiveClassList((List<AllNullableTypes>) recursiveClassList);
      Object map = pigeonVar_list.get(23);
      pigeonResult.setMap((Map<Object, Object>) map);
      Object stringMap = pigeonVar_list.get(24);
      pigeonResult.setStringMap((Map<String, String>) stringMap);
      Object intMap = pigeonVar_list.get(25);
      pigeonResult.setIntMap((Map<Long, Long>) intMap);
      Object enumMap = pigeonVar_list.get(26);
      pigeonResult.setEnumMap((Map<AnEnum, AnEnum>) enumMap);
      Object objectMap = pigeonVar_list.get(27);
      pigeonResult.setObjectMap((Map<Object, Object>) objectMap);
      Object listMap = pigeonVar_list.get(28);
      pigeonResult.setListMap((Map<Long, List<Object>>) listMap);
      Object mapMap = pigeonVar_list.get(29);
      pigeonResult.setMapMap((Map<Long, Map<Object, Object>>) mapMap);
      Object recursiveClassMap = pigeonVar_list.get(30);
      pigeonResult.setRecursiveClassMap((Map<Long, AllNullableTypes>) recursiveClassMap);
      return pigeonResult;
    }
  }

  /**
   * The primary purpose for this class is to ensure coverage of Swift structs with nullable items,
   * as the primary [AllNullableTypes] class is being used to test Swift classes.
   *
   * <p>Generated class from Pigeon that represents data sent in messages.
   */
  public static final class AllNullableTypesWithoutRecursion {
    private @Nullable Boolean aNullableBool;

    public @Nullable Boolean getANullableBool() {
      return aNullableBool;
    }

    public void setANullableBool(@Nullable Boolean setterArg) {
      this.aNullableBool = setterArg;
    }

    private @Nullable Long aNullableInt;

    public @Nullable Long getANullableInt() {
      return aNullableInt;
    }

    public void setANullableInt(@Nullable Long setterArg) {
      this.aNullableInt = setterArg;
    }

    private @Nullable Long aNullableInt64;

    public @Nullable Long getANullableInt64() {
      return aNullableInt64;
    }

    public void setANullableInt64(@Nullable Long setterArg) {
      this.aNullableInt64 = setterArg;
    }

    private @Nullable Double aNullableDouble;

    public @Nullable Double getANullableDouble() {
      return aNullableDouble;
    }

    public void setANullableDouble(@Nullable Double setterArg) {
      this.aNullableDouble = setterArg;
    }

    private @Nullable byte[] aNullableByteArray;

    public @Nullable byte[] getANullableByteArray() {
      return aNullableByteArray;
    }

    public void setANullableByteArray(@Nullable byte[] setterArg) {
      this.aNullableByteArray = setterArg;
    }

    private @Nullable int[] aNullable4ByteArray;

    public @Nullable int[] getANullable4ByteArray() {
      return aNullable4ByteArray;
    }

    public void setANullable4ByteArray(@Nullable int[] setterArg) {
      this.aNullable4ByteArray = setterArg;
    }

    private @Nullable long[] aNullable8ByteArray;

    public @Nullable long[] getANullable8ByteArray() {
      return aNullable8ByteArray;
    }

    public void setANullable8ByteArray(@Nullable long[] setterArg) {
      this.aNullable8ByteArray = setterArg;
    }

    private @Nullable double[] aNullableFloatArray;

    public @Nullable double[] getANullableFloatArray() {
      return aNullableFloatArray;
    }

    public void setANullableFloatArray(@Nullable double[] setterArg) {
      this.aNullableFloatArray = setterArg;
    }

    private @Nullable AnEnum aNullableEnum;

    public @Nullable AnEnum getANullableEnum() {
      return aNullableEnum;
    }

    public void setANullableEnum(@Nullable AnEnum setterArg) {
      this.aNullableEnum = setterArg;
    }

    private @Nullable AnotherEnum anotherNullableEnum;

    public @Nullable AnotherEnum getAnotherNullableEnum() {
      return anotherNullableEnum;
    }

    public void setAnotherNullableEnum(@Nullable AnotherEnum setterArg) {
      this.anotherNullableEnum = setterArg;
    }

    private @Nullable String aNullableString;

    public @Nullable String getANullableString() {
      return aNullableString;
    }

    public void setANullableString(@Nullable String setterArg) {
      this.aNullableString = setterArg;
    }

    private @Nullable Object aNullableObject;

    public @Nullable Object getANullableObject() {
      return aNullableObject;
    }

    public void setANullableObject(@Nullable Object setterArg) {
      this.aNullableObject = setterArg;
    }

    private @Nullable List<Object> list;

    public @Nullable List<Object> getList() {
      return list;
    }

    public void setList(@Nullable List<Object> setterArg) {
      this.list = setterArg;
    }

    private @Nullable List<String> stringList;

    public @Nullable List<String> getStringList() {
      return stringList;
    }

    public void setStringList(@Nullable List<String> setterArg) {
      this.stringList = setterArg;
    }

    private @Nullable List<Long> intList;

    public @Nullable List<Long> getIntList() {
      return intList;
    }

    public void setIntList(@Nullable List<Long> setterArg) {
      this.intList = setterArg;
    }

    private @Nullable List<Double> doubleList;

    public @Nullable List<Double> getDoubleList() {
      return doubleList;
    }

    public void setDoubleList(@Nullable List<Double> setterArg) {
      this.doubleList = setterArg;
    }

    private @Nullable List<Boolean> boolList;

    public @Nullable List<Boolean> getBoolList() {
      return boolList;
    }

    public void setBoolList(@Nullable List<Boolean> setterArg) {
      this.boolList = setterArg;
    }

    private @Nullable List<AnEnum> enumList;

    public @Nullable List<AnEnum> getEnumList() {
      return enumList;
    }

    public void setEnumList(@Nullable List<AnEnum> setterArg) {
      this.enumList = setterArg;
    }

    private @Nullable List<Object> objectList;

    public @Nullable List<Object> getObjectList() {
      return objectList;
    }

    public void setObjectList(@Nullable List<Object> setterArg) {
      this.objectList = setterArg;
    }

    private @Nullable List<List<Object>> listList;

    public @Nullable List<List<Object>> getListList() {
      return listList;
    }

    public void setListList(@Nullable List<List<Object>> setterArg) {
      this.listList = setterArg;
    }

    private @Nullable List<Map<Object, Object>> mapList;

    public @Nullable List<Map<Object, Object>> getMapList() {
      return mapList;
    }

    public void setMapList(@Nullable List<Map<Object, Object>> setterArg) {
      this.mapList = setterArg;
    }

    private @Nullable Map<Object, Object> map;

    public @Nullable Map<Object, Object> getMap() {
      return map;
    }

    public void setMap(@Nullable Map<Object, Object> setterArg) {
      this.map = setterArg;
    }

    private @Nullable Map<String, String> stringMap;

    public @Nullable Map<String, String> getStringMap() {
      return stringMap;
    }

    public void setStringMap(@Nullable Map<String, String> setterArg) {
      this.stringMap = setterArg;
    }

    private @Nullable Map<Long, Long> intMap;

    public @Nullable Map<Long, Long> getIntMap() {
      return intMap;
    }

    public void setIntMap(@Nullable Map<Long, Long> setterArg) {
      this.intMap = setterArg;
    }

    private @Nullable Map<AnEnum, AnEnum> enumMap;

    public @Nullable Map<AnEnum, AnEnum> getEnumMap() {
      return enumMap;
    }

    public void setEnumMap(@Nullable Map<AnEnum, AnEnum> setterArg) {
      this.enumMap = setterArg;
    }

    private @Nullable Map<Object, Object> objectMap;

    public @Nullable Map<Object, Object> getObjectMap() {
      return objectMap;
    }

    public void setObjectMap(@Nullable Map<Object, Object> setterArg) {
      this.objectMap = setterArg;
    }

    private @Nullable Map<Long, List<Object>> listMap;

    public @Nullable Map<Long, List<Object>> getListMap() {
      return listMap;
    }

    public void setListMap(@Nullable Map<Long, List<Object>> setterArg) {
      this.listMap = setterArg;
    }

    private @Nullable Map<Long, Map<Object, Object>> mapMap;

    public @Nullable Map<Long, Map<Object, Object>> getMapMap() {
      return mapMap;
    }

    public void setMapMap(@Nullable Map<Long, Map<Object, Object>> setterArg) {
      this.mapMap = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (o == null || getClass() != o.getClass()) {
        return false;
      }
      AllNullableTypesWithoutRecursion that = (AllNullableTypesWithoutRecursion) o;
      return Objects.equals(aNullableBool, that.aNullableBool)
          && Objects.equals(aNullableInt, that.aNullableInt)
          && Objects.equals(aNullableInt64, that.aNullableInt64)
          && Objects.equals(aNullableDouble, that.aNullableDouble)
          && Arrays.equals(aNullableByteArray, that.aNullableByteArray)
          && Arrays.equals(aNullable4ByteArray, that.aNullable4ByteArray)
          && Arrays.equals(aNullable8ByteArray, that.aNullable8ByteArray)
          && Arrays.equals(aNullableFloatArray, that.aNullableFloatArray)
          && Objects.equals(aNullableEnum, that.aNullableEnum)
          && Objects.equals(anotherNullableEnum, that.anotherNullableEnum)
          && Objects.equals(aNullableString, that.aNullableString)
          && Objects.equals(aNullableObject, that.aNullableObject)
          && Objects.equals(list, that.list)
          && Objects.equals(stringList, that.stringList)
          && Objects.equals(intList, that.intList)
          && Objects.equals(doubleList, that.doubleList)
          && Objects.equals(boolList, that.boolList)
          && Objects.equals(enumList, that.enumList)
          && Objects.equals(objectList, that.objectList)
          && Objects.equals(listList, that.listList)
          && Objects.equals(mapList, that.mapList)
          && Objects.equals(map, that.map)
          && Objects.equals(stringMap, that.stringMap)
          && Objects.equals(intMap, that.intMap)
          && Objects.equals(enumMap, that.enumMap)
          && Objects.equals(objectMap, that.objectMap)
          && Objects.equals(listMap, that.listMap)
          && Objects.equals(mapMap, that.mapMap);
    }

    @Override
    public int hashCode() {
      int pigeonVar_result =
          Objects.hash(
              aNullableBool,
              aNullableInt,
              aNullableInt64,
              aNullableDouble,
              aNullableEnum,
              anotherNullableEnum,
              aNullableString,
              aNullableObject,
              list,
              stringList,
              intList,
              doubleList,
              boolList,
              enumList,
              objectList,
              listList,
              mapList,
              map,
              stringMap,
              intMap,
              enumMap,
              objectMap,
              listMap,
              mapMap);
      pigeonVar_result = 31 * pigeonVar_result + Arrays.hashCode(aNullableByteArray);
      pigeonVar_result = 31 * pigeonVar_result + Arrays.hashCode(aNullable4ByteArray);
      pigeonVar_result = 31 * pigeonVar_result + Arrays.hashCode(aNullable8ByteArray);
      pigeonVar_result = 31 * pigeonVar_result + Arrays.hashCode(aNullableFloatArray);
      return pigeonVar_result;
    }

    public static final class Builder {

      private @Nullable Boolean aNullableBool;

      @CanIgnoreReturnValue
      public @NonNull Builder setANullableBool(@Nullable Boolean setterArg) {
        this.aNullableBool = setterArg;
        return this;
      }

      private @Nullable Long aNullableInt;

      @CanIgnoreReturnValue
      public @NonNull Builder setANullableInt(@Nullable Long setterArg) {
        this.aNullableInt = setterArg;
        return this;
      }

      private @Nullable Long aNullableInt64;

      @CanIgnoreReturnValue
      public @NonNull Builder setANullableInt64(@Nullable Long setterArg) {
        this.aNullableInt64 = setterArg;
        return this;
      }

      private @Nullable Double aNullableDouble;

      @CanIgnoreReturnValue
      public @NonNull Builder setANullableDouble(@Nullable Double setterArg) {
        this.aNullableDouble = setterArg;
        return this;
      }

      private @Nullable byte[] aNullableByteArray;

      @CanIgnoreReturnValue
      public @NonNull Builder setANullableByteArray(@Nullable byte[] setterArg) {
        this.aNullableByteArray = setterArg;
        return this;
      }

      private @Nullable int[] aNullable4ByteArray;

      @CanIgnoreReturnValue
      public @NonNull Builder setANullable4ByteArray(@Nullable int[] setterArg) {
        this.aNullable4ByteArray = setterArg;
        return this;
      }

      private @Nullable long[] aNullable8ByteArray;

      @CanIgnoreReturnValue
      public @NonNull Builder setANullable8ByteArray(@Nullable long[] setterArg) {
        this.aNullable8ByteArray = setterArg;
        return this;
      }

      private @Nullable double[] aNullableFloatArray;

      @CanIgnoreReturnValue
      public @NonNull Builder setANullableFloatArray(@Nullable double[] setterArg) {
        this.aNullableFloatArray = setterArg;
        return this;
      }

      private @Nullable AnEnum aNullableEnum;

      @CanIgnoreReturnValue
      public @NonNull Builder setANullableEnum(@Nullable AnEnum setterArg) {
        this.aNullableEnum = setterArg;
        return this;
      }

      private @Nullable AnotherEnum anotherNullableEnum;

      @CanIgnoreReturnValue
      public @NonNull Builder setAnotherNullableEnum(@Nullable AnotherEnum setterArg) {
        this.anotherNullableEnum = setterArg;
        return this;
      }

      private @Nullable String aNullableString;

      @CanIgnoreReturnValue
      public @NonNull Builder setANullableString(@Nullable String setterArg) {
        this.aNullableString = setterArg;
        return this;
      }

      private @Nullable Object aNullableObject;

      @CanIgnoreReturnValue
      public @NonNull Builder setANullableObject(@Nullable Object setterArg) {
        this.aNullableObject = setterArg;
        return this;
      }

      private @Nullable List<Object> list;

      @CanIgnoreReturnValue
      public @NonNull Builder setList(@Nullable List<Object> setterArg) {
        this.list = setterArg;
        return this;
      }

      private @Nullable List<String> stringList;

      @CanIgnoreReturnValue
      public @NonNull Builder setStringList(@Nullable List<String> setterArg) {
        this.stringList = setterArg;
        return this;
      }

      private @Nullable List<Long> intList;

      @CanIgnoreReturnValue
      public @NonNull Builder setIntList(@Nullable List<Long> setterArg) {
        this.intList = setterArg;
        return this;
      }

      private @Nullable List<Double> doubleList;

      @CanIgnoreReturnValue
      public @NonNull Builder setDoubleList(@Nullable List<Double> setterArg) {
        this.doubleList = setterArg;
        return this;
      }

      private @Nullable List<Boolean> boolList;

      @CanIgnoreReturnValue
      public @NonNull Builder setBoolList(@Nullable List<Boolean> setterArg) {
        this.boolList = setterArg;
        return this;
      }

      private @Nullable List<AnEnum> enumList;

      @CanIgnoreReturnValue
      public @NonNull Builder setEnumList(@Nullable List<AnEnum> setterArg) {
        this.enumList = setterArg;
        return this;
      }

      private @Nullable List<Object> objectList;

      @CanIgnoreReturnValue
      public @NonNull Builder setObjectList(@Nullable List<Object> setterArg) {
        this.objectList = setterArg;
        return this;
      }

      private @Nullable List<List<Object>> listList;

      @CanIgnoreReturnValue
      public @NonNull Builder setListList(@Nullable List<List<Object>> setterArg) {
        this.listList = setterArg;
        return this;
      }

      private @Nullable List<Map<Object, Object>> mapList;

      @CanIgnoreReturnValue
      public @NonNull Builder setMapList(@Nullable List<Map<Object, Object>> setterArg) {
        this.mapList = setterArg;
        return this;
      }

      private @Nullable Map<Object, Object> map;

      @CanIgnoreReturnValue
      public @NonNull Builder setMap(@Nullable Map<Object, Object> setterArg) {
        this.map = setterArg;
        return this;
      }

      private @Nullable Map<String, String> stringMap;

      @CanIgnoreReturnValue
      public @NonNull Builder setStringMap(@Nullable Map<String, String> setterArg) {
        this.stringMap = setterArg;
        return this;
      }

      private @Nullable Map<Long, Long> intMap;

      @CanIgnoreReturnValue
      public @NonNull Builder setIntMap(@Nullable Map<Long, Long> setterArg) {
        this.intMap = setterArg;
        return this;
      }

      private @Nullable Map<AnEnum, AnEnum> enumMap;

      @CanIgnoreReturnValue
      public @NonNull Builder setEnumMap(@Nullable Map<AnEnum, AnEnum> setterArg) {
        this.enumMap = setterArg;
        return this;
      }

      private @Nullable Map<Object, Object> objectMap;

      @CanIgnoreReturnValue
      public @NonNull Builder setObjectMap(@Nullable Map<Object, Object> setterArg) {
        this.objectMap = setterArg;
        return this;
      }

      private @Nullable Map<Long, List<Object>> listMap;

      @CanIgnoreReturnValue
      public @NonNull Builder setListMap(@Nullable Map<Long, List<Object>> setterArg) {
        this.listMap = setterArg;
        return this;
      }

      private @Nullable Map<Long, Map<Object, Object>> mapMap;

      @CanIgnoreReturnValue
      public @NonNull Builder setMapMap(@Nullable Map<Long, Map<Object, Object>> setterArg) {
        this.mapMap = setterArg;
        return this;
      }

      public @NonNull AllNullableTypesWithoutRecursion build() {
        AllNullableTypesWithoutRecursion pigeonReturn = new AllNullableTypesWithoutRecursion();
        pigeonReturn.setANullableBool(aNullableBool);
        pigeonReturn.setANullableInt(aNullableInt);
        pigeonReturn.setANullableInt64(aNullableInt64);
        pigeonReturn.setANullableDouble(aNullableDouble);
        pigeonReturn.setANullableByteArray(aNullableByteArray);
        pigeonReturn.setANullable4ByteArray(aNullable4ByteArray);
        pigeonReturn.setANullable8ByteArray(aNullable8ByteArray);
        pigeonReturn.setANullableFloatArray(aNullableFloatArray);
        pigeonReturn.setANullableEnum(aNullableEnum);
        pigeonReturn.setAnotherNullableEnum(anotherNullableEnum);
        pigeonReturn.setANullableString(aNullableString);
        pigeonReturn.setANullableObject(aNullableObject);
        pigeonReturn.setList(list);
        pigeonReturn.setStringList(stringList);
        pigeonReturn.setIntList(intList);
        pigeonReturn.setDoubleList(doubleList);
        pigeonReturn.setBoolList(boolList);
        pigeonReturn.setEnumList(enumList);
        pigeonReturn.setObjectList(objectList);
        pigeonReturn.setListList(listList);
        pigeonReturn.setMapList(mapList);
        pigeonReturn.setMap(map);
        pigeonReturn.setStringMap(stringMap);
        pigeonReturn.setIntMap(intMap);
        pigeonReturn.setEnumMap(enumMap);
        pigeonReturn.setObjectMap(objectMap);
        pigeonReturn.setListMap(listMap);
        pigeonReturn.setMapMap(mapMap);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(28);
      toListResult.add(aNullableBool);
      toListResult.add(aNullableInt);
      toListResult.add(aNullableInt64);
      toListResult.add(aNullableDouble);
      toListResult.add(aNullableByteArray);
      toListResult.add(aNullable4ByteArray);
      toListResult.add(aNullable8ByteArray);
      toListResult.add(aNullableFloatArray);
      toListResult.add(aNullableEnum);
      toListResult.add(anotherNullableEnum);
      toListResult.add(aNullableString);
      toListResult.add(aNullableObject);
      toListResult.add(list);
      toListResult.add(stringList);
      toListResult.add(intList);
      toListResult.add(doubleList);
      toListResult.add(boolList);
      toListResult.add(enumList);
      toListResult.add(objectList);
      toListResult.add(listList);
      toListResult.add(mapList);
      toListResult.add(map);
      toListResult.add(stringMap);
      toListResult.add(intMap);
      toListResult.add(enumMap);
      toListResult.add(objectMap);
      toListResult.add(listMap);
      toListResult.add(mapMap);
      return toListResult;
    }

    static @NonNull AllNullableTypesWithoutRecursion fromList(
        @NonNull ArrayList<Object> pigeonVar_list) {
      AllNullableTypesWithoutRecursion pigeonResult = new AllNullableTypesWithoutRecursion();
      Object aNullableBool = pigeonVar_list.get(0);
      pigeonResult.setANullableBool((Boolean) aNullableBool);
      Object aNullableInt = pigeonVar_list.get(1);
      pigeonResult.setANullableInt((Long) aNullableInt);
      Object aNullableInt64 = pigeonVar_list.get(2);
      pigeonResult.setANullableInt64((Long) aNullableInt64);
      Object aNullableDouble = pigeonVar_list.get(3);
      pigeonResult.setANullableDouble((Double) aNullableDouble);
      Object aNullableByteArray = pigeonVar_list.get(4);
      pigeonResult.setANullableByteArray((byte[]) aNullableByteArray);
      Object aNullable4ByteArray = pigeonVar_list.get(5);
      pigeonResult.setANullable4ByteArray((int[]) aNullable4ByteArray);
      Object aNullable8ByteArray = pigeonVar_list.get(6);
      pigeonResult.setANullable8ByteArray((long[]) aNullable8ByteArray);
      Object aNullableFloatArray = pigeonVar_list.get(7);
      pigeonResult.setANullableFloatArray((double[]) aNullableFloatArray);
      Object aNullableEnum = pigeonVar_list.get(8);
      pigeonResult.setANullableEnum((AnEnum) aNullableEnum);
      Object anotherNullableEnum = pigeonVar_list.get(9);
      pigeonResult.setAnotherNullableEnum((AnotherEnum) anotherNullableEnum);
      Object aNullableString = pigeonVar_list.get(10);
      pigeonResult.setANullableString((String) aNullableString);
      Object aNullableObject = pigeonVar_list.get(11);
      pigeonResult.setANullableObject(aNullableObject);
      Object list = pigeonVar_list.get(12);
      pigeonResult.setList((List<Object>) list);
      Object stringList = pigeonVar_list.get(13);
      pigeonResult.setStringList((List<String>) stringList);
      Object intList = pigeonVar_list.get(14);
      pigeonResult.setIntList((List<Long>) intList);
      Object doubleList = pigeonVar_list.get(15);
      pigeonResult.setDoubleList((List<Double>) doubleList);
      Object boolList = pigeonVar_list.get(16);
      pigeonResult.setBoolList((List<Boolean>) boolList);
      Object enumList = pigeonVar_list.get(17);
      pigeonResult.setEnumList((List<AnEnum>) enumList);
      Object objectList = pigeonVar_list.get(18);
      pigeonResult.setObjectList((List<Object>) objectList);
      Object listList = pigeonVar_list.get(19);
      pigeonResult.setListList((List<List<Object>>) listList);
      Object mapList = pigeonVar_list.get(20);
      pigeonResult.setMapList((List<Map<Object, Object>>) mapList);
      Object map = pigeonVar_list.get(21);
      pigeonResult.setMap((Map<Object, Object>) map);
      Object stringMap = pigeonVar_list.get(22);
      pigeonResult.setStringMap((Map<String, String>) stringMap);
      Object intMap = pigeonVar_list.get(23);
      pigeonResult.setIntMap((Map<Long, Long>) intMap);
      Object enumMap = pigeonVar_list.get(24);
      pigeonResult.setEnumMap((Map<AnEnum, AnEnum>) enumMap);
      Object objectMap = pigeonVar_list.get(25);
      pigeonResult.setObjectMap((Map<Object, Object>) objectMap);
      Object listMap = pigeonVar_list.get(26);
      pigeonResult.setListMap((Map<Long, List<Object>>) listMap);
      Object mapMap = pigeonVar_list.get(27);
      pigeonResult.setMapMap((Map<Long, Map<Object, Object>>) mapMap);
      return pigeonResult;
    }
  }

  /**
   * A class for testing nested class handling.
   *
   * <p>This is needed to test nested nullable and non-nullable classes, `AllNullableTypes` is
   * non-nullable here as it is easier to instantiate than `AllTypes` when testing doesn't require
   * both (ie. testing null classes).
   *
   * <p>Generated class from Pigeon that represents data sent in messages.
   */
  public static final class AllClassesWrapper {
    private @NonNull AllNullableTypes allNullableTypes;

    public @NonNull AllNullableTypes getAllNullableTypes() {
      return allNullableTypes;
    }

    public void setAllNullableTypes(@NonNull AllNullableTypes setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"allNullableTypes\" is null.");
      }
      this.allNullableTypes = setterArg;
    }

    private @Nullable AllNullableTypesWithoutRecursion allNullableTypesWithoutRecursion;

    public @Nullable AllNullableTypesWithoutRecursion getAllNullableTypesWithoutRecursion() {
      return allNullableTypesWithoutRecursion;
    }

    public void setAllNullableTypesWithoutRecursion(
        @Nullable AllNullableTypesWithoutRecursion setterArg) {
      this.allNullableTypesWithoutRecursion = setterArg;
    }

    private @Nullable AllTypes allTypes;

    public @Nullable AllTypes getAllTypes() {
      return allTypes;
    }

    public void setAllTypes(@Nullable AllTypes setterArg) {
      this.allTypes = setterArg;
    }

    private @NonNull List<AllTypes> classList;

    public @NonNull List<AllTypes> getClassList() {
      return classList;
    }

    public void setClassList(@NonNull List<AllTypes> setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"classList\" is null.");
      }
      this.classList = setterArg;
    }

    private @Nullable List<AllNullableTypesWithoutRecursion> nullableClassList;

    public @Nullable List<AllNullableTypesWithoutRecursion> getNullableClassList() {
      return nullableClassList;
    }

    public void setNullableClassList(@Nullable List<AllNullableTypesWithoutRecursion> setterArg) {
      this.nullableClassList = setterArg;
    }

    private @NonNull Map<Long, AllTypes> classMap;

    public @NonNull Map<Long, AllTypes> getClassMap() {
      return classMap;
    }

    public void setClassMap(@NonNull Map<Long, AllTypes> setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"classMap\" is null.");
      }
      this.classMap = setterArg;
    }

    private @Nullable Map<Long, AllNullableTypesWithoutRecursion> nullableClassMap;

    public @Nullable Map<Long, AllNullableTypesWithoutRecursion> getNullableClassMap() {
      return nullableClassMap;
    }

    public void setNullableClassMap(
        @Nullable Map<Long, AllNullableTypesWithoutRecursion> setterArg) {
      this.nullableClassMap = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    AllClassesWrapper() {}

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (o == null || getClass() != o.getClass()) {
        return false;
      }
      AllClassesWrapper that = (AllClassesWrapper) o;
      return allNullableTypes.equals(that.allNullableTypes)
          && Objects.equals(allNullableTypesWithoutRecursion, that.allNullableTypesWithoutRecursion)
          && Objects.equals(allTypes, that.allTypes)
          && classList.equals(that.classList)
          && Objects.equals(nullableClassList, that.nullableClassList)
          && classMap.equals(that.classMap)
          && Objects.equals(nullableClassMap, that.nullableClassMap);
    }

    @Override
    public int hashCode() {
      return Objects.hash(
          allNullableTypes,
          allNullableTypesWithoutRecursion,
          allTypes,
          classList,
          nullableClassList,
          classMap,
          nullableClassMap);
    }

    public static final class Builder {

      private @Nullable AllNullableTypes allNullableTypes;

      @CanIgnoreReturnValue
      public @NonNull Builder setAllNullableTypes(@NonNull AllNullableTypes setterArg) {
        this.allNullableTypes = setterArg;
        return this;
      }

      private @Nullable AllNullableTypesWithoutRecursion allNullableTypesWithoutRecursion;

      @CanIgnoreReturnValue
      public @NonNull Builder setAllNullableTypesWithoutRecursion(
          @Nullable AllNullableTypesWithoutRecursion setterArg) {
        this.allNullableTypesWithoutRecursion = setterArg;
        return this;
      }

      private @Nullable AllTypes allTypes;

      @CanIgnoreReturnValue
      public @NonNull Builder setAllTypes(@Nullable AllTypes setterArg) {
        this.allTypes = setterArg;
        return this;
      }

      private @Nullable List<AllTypes> classList;

      @CanIgnoreReturnValue
      public @NonNull Builder setClassList(@NonNull List<AllTypes> setterArg) {
        this.classList = setterArg;
        return this;
      }

      private @Nullable List<AllNullableTypesWithoutRecursion> nullableClassList;

      @CanIgnoreReturnValue
      public @NonNull Builder setNullableClassList(
          @Nullable List<AllNullableTypesWithoutRecursion> setterArg) {
        this.nullableClassList = setterArg;
        return this;
      }

      private @Nullable Map<Long, AllTypes> classMap;

      @CanIgnoreReturnValue
      public @NonNull Builder setClassMap(@NonNull Map<Long, AllTypes> setterArg) {
        this.classMap = setterArg;
        return this;
      }

      private @Nullable Map<Long, AllNullableTypesWithoutRecursion> nullableClassMap;

      @CanIgnoreReturnValue
      public @NonNull Builder setNullableClassMap(
          @Nullable Map<Long, AllNullableTypesWithoutRecursion> setterArg) {
        this.nullableClassMap = setterArg;
        return this;
      }

      public @NonNull AllClassesWrapper build() {
        AllClassesWrapper pigeonReturn = new AllClassesWrapper();
        pigeonReturn.setAllNullableTypes(allNullableTypes);
        pigeonReturn.setAllNullableTypesWithoutRecursion(allNullableTypesWithoutRecursion);
        pigeonReturn.setAllTypes(allTypes);
        pigeonReturn.setClassList(classList);
        pigeonReturn.setNullableClassList(nullableClassList);
        pigeonReturn.setClassMap(classMap);
        pigeonReturn.setNullableClassMap(nullableClassMap);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(7);
      toListResult.add(allNullableTypes);
      toListResult.add(allNullableTypesWithoutRecursion);
      toListResult.add(allTypes);
      toListResult.add(classList);
      toListResult.add(nullableClassList);
      toListResult.add(classMap);
      toListResult.add(nullableClassMap);
      return toListResult;
    }

    static @NonNull AllClassesWrapper fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      AllClassesWrapper pigeonResult = new AllClassesWrapper();
      Object allNullableTypes = pigeonVar_list.get(0);
      pigeonResult.setAllNullableTypes((AllNullableTypes) allNullableTypes);
      Object allNullableTypesWithoutRecursion = pigeonVar_list.get(1);
      pigeonResult.setAllNullableTypesWithoutRecursion(
          (AllNullableTypesWithoutRecursion) allNullableTypesWithoutRecursion);
      Object allTypes = pigeonVar_list.get(2);
      pigeonResult.setAllTypes((AllTypes) allTypes);
      Object classList = pigeonVar_list.get(3);
      pigeonResult.setClassList((List<AllTypes>) classList);
      Object nullableClassList = pigeonVar_list.get(4);
      pigeonResult.setNullableClassList((List<AllNullableTypesWithoutRecursion>) nullableClassList);
      Object classMap = pigeonVar_list.get(5);
      pigeonResult.setClassMap((Map<Long, AllTypes>) classMap);
      Object nullableClassMap = pigeonVar_list.get(6);
      pigeonResult.setNullableClassMap(
          (Map<Long, AllNullableTypesWithoutRecursion>) nullableClassMap);
      return pigeonResult;
    }
  }

  /**
   * A data class containing a List, used in unit tests.
   *
   * <p>Generated class from Pigeon that represents data sent in messages.
   */
  public static final class TestMessage {
    private @Nullable List<Object> testList;

    public @Nullable List<Object> getTestList() {
      return testList;
    }

    public void setTestList(@Nullable List<Object> setterArg) {
      this.testList = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (o == null || getClass() != o.getClass()) {
        return false;
      }
      TestMessage that = (TestMessage) o;
      return Objects.equals(testList, that.testList);
    }

    @Override
    public int hashCode() {
      return Objects.hash(testList);
    }

    public static final class Builder {

      private @Nullable List<Object> testList;

      @CanIgnoreReturnValue
      public @NonNull Builder setTestList(@Nullable List<Object> setterArg) {
        this.testList = setterArg;
        return this;
      }

      public @NonNull TestMessage build() {
        TestMessage pigeonReturn = new TestMessage();
        pigeonReturn.setTestList(testList);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(1);
      toListResult.add(testList);
      return toListResult;
    }

    static @NonNull TestMessage fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      TestMessage pigeonResult = new TestMessage();
      Object testList = pigeonVar_list.get(0);
      pigeonResult.setTestList((List<Object>) testList);
      return pigeonResult;
    }
  }

  private static class PigeonCodec extends StandardMessageCodec {
    public static final PigeonCodec INSTANCE = new PigeonCodec();

    private PigeonCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 129:
          {
            Object value = readValue(buffer);
            return value == null ? null : AnEnum.values()[((Long) value).intValue()];
          }
        case (byte) 130:
          {
            Object value = readValue(buffer);
            return value == null ? null : AnotherEnum.values()[((Long) value).intValue()];
          }
        case (byte) 131:
          return UnusedClass.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 132:
          return AllTypes.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 133:
          return AllNullableTypes.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 134:
          return AllNullableTypesWithoutRecursion.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 135:
          return AllClassesWrapper.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 136:
          return TestMessage.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof AnEnum) {
        stream.write(129);
        writeValue(stream, value == null ? null : ((AnEnum) value).index);
      } else if (value instanceof AnotherEnum) {
        stream.write(130);
        writeValue(stream, value == null ? null : ((AnotherEnum) value).index);
      } else if (value instanceof UnusedClass) {
        stream.write(131);
        writeValue(stream, ((UnusedClass) value).toList());
      } else if (value instanceof AllTypes) {
        stream.write(132);
        writeValue(stream, ((AllTypes) value).toList());
      } else if (value instanceof AllNullableTypes) {
        stream.write(133);
        writeValue(stream, ((AllNullableTypes) value).toList());
      } else if (value instanceof AllNullableTypesWithoutRecursion) {
        stream.write(134);
        writeValue(stream, ((AllNullableTypesWithoutRecursion) value).toList());
      } else if (value instanceof AllClassesWrapper) {
        stream.write(135);
        writeValue(stream, ((AllClassesWrapper) value).toList());
      } else if (value instanceof TestMessage) {
        stream.write(136);
        writeValue(stream, ((TestMessage) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Asynchronous error handling return type for non-nullable API method returns. */
  public interface Result<T> {
    /** Success case callback method for handling returns. */
    void success(@NonNull T result);

    /** Failure case callback method for handling errors. */
    void error(@NonNull Throwable error);
  }
  /** Asynchronous error handling return type for nullable API method returns. */
  public interface NullableResult<T> {
    /** Success case callback method for handling returns. */
    void success(@Nullable T result);

    /** Failure case callback method for handling errors. */
    void error(@NonNull Throwable error);
  }
  /** Asynchronous error handling return type for void API method returns. */
  public interface VoidResult {
    /** Success case callback method for handling returns. */
    void success();

    /** Failure case callback method for handling errors. */
    void error(@NonNull Throwable error);
  }
  /**
   * The core interface that each host language plugin must implement in platform_test integration
   * tests.
   *
   * <p>Generated interface from Pigeon that represents a handler of messages from Flutter.
   */
  public interface HostIntegrationCoreApi {
    /**
     * A no-op function taking no arguments and returning no value, to sanity test basic calling.
     */
    void noop();
    /** Returns the passed object, to test serialization and deserialization. */
    @NonNull
    AllTypes echoAllTypes(@NonNull AllTypes everything);
    /** Returns an error, to test error handling. */
    @Nullable
    Object throwError();
    /** Returns an error from a void function, to test error handling. */
    void throwErrorFromVoid();
    /** Returns a Flutter error, to test error handling. */
    @Nullable
    Object throwFlutterError();
    /** Returns passed in int. */
    @NonNull
    Long echoInt(@NonNull Long anInt);
    /** Returns passed in double. */
    @NonNull
    Double echoDouble(@NonNull Double aDouble);
    /** Returns the passed in boolean. */
    @NonNull
    Boolean echoBool(@NonNull Boolean aBool);
    /** Returns the passed in string. */
    @NonNull
    String echoString(@NonNull String aString);
    /** Returns the passed in Uint8List. */
    @NonNull
    byte[] echoUint8List(@NonNull byte[] aUint8List);
    /** Returns the passed in generic Object. */
    @NonNull
    Object echoObject(@NonNull Object anObject);
    /** Returns the passed list, to test serialization and deserialization. */
    @NonNull
    List<Object> echoList(@NonNull List<Object> list);
    /** Returns the passed list, to test serialization and deserialization. */
    @NonNull
    List<AnEnum> echoEnumList(@NonNull List<AnEnum> enumList);
    /** Returns the passed list, to test serialization and deserialization. */
    @NonNull
    List<AllNullableTypes> echoClassList(@NonNull List<AllNullableTypes> classList);
    /** Returns the passed list, to test serialization and deserialization. */
    @NonNull
    List<AnEnum> echoNonNullEnumList(@NonNull List<AnEnum> enumList);
    /** Returns the passed list, to test serialization and deserialization. */
    @NonNull
    List<AllNullableTypes> echoNonNullClassList(@NonNull List<AllNullableTypes> classList);
    /** Returns the passed map, to test serialization and deserialization. */
    @NonNull
    Map<Object, Object> echoMap(@NonNull Map<Object, Object> map);
    /** Returns the passed map, to test serialization and deserialization. */
    @NonNull
    Map<String, String> echoStringMap(@NonNull Map<String, String> stringMap);
    /** Returns the passed map, to test serialization and deserialization. */
    @NonNull
    Map<Long, Long> echoIntMap(@NonNull Map<Long, Long> intMap);
    /** Returns the passed map, to test serialization and deserialization. */
    @NonNull
    Map<AnEnum, AnEnum> echoEnumMap(@NonNull Map<AnEnum, AnEnum> enumMap);
    /** Returns the passed map, to test serialization and deserialization. */
    @NonNull
    Map<Long, AllNullableTypes> echoClassMap(@NonNull Map<Long, AllNullableTypes> classMap);
    /** Returns the passed map, to test serialization and deserialization. */
    @NonNull
    Map<String, String> echoNonNullStringMap(@NonNull Map<String, String> stringMap);
    /** Returns the passed map, to test serialization and deserialization. */
    @NonNull
    Map<Long, Long> echoNonNullIntMap(@NonNull Map<Long, Long> intMap);
    /** Returns the passed map, to test serialization and deserialization. */
    @NonNull
    Map<AnEnum, AnEnum> echoNonNullEnumMap(@NonNull Map<AnEnum, AnEnum> enumMap);
    /** Returns the passed map, to test serialization and deserialization. */
    @NonNull
    Map<Long, AllNullableTypes> echoNonNullClassMap(@NonNull Map<Long, AllNullableTypes> classMap);
    /** Returns the passed class to test nested class serialization and deserialization. */
    @NonNull
    AllClassesWrapper echoClassWrapper(@NonNull AllClassesWrapper wrapper);
    /** Returns the passed enum to test serialization and deserialization. */
    @NonNull
    AnEnum echoEnum(@NonNull AnEnum anEnum);
    /** Returns the passed enum to test serialization and deserialization. */
    @NonNull
    AnotherEnum echoAnotherEnum(@NonNull AnotherEnum anotherEnum);
    /** Returns the default string. */
    @NonNull
    String echoNamedDefaultString(@NonNull String aString);
    /** Returns passed in double. */
    @NonNull
    Double echoOptionalDefaultDouble(@NonNull Double aDouble);
    /** Returns passed in int. */
    @NonNull
    Long echoRequiredInt(@NonNull Long anInt);
    /** Returns the passed object, to test serialization and deserialization. */
    @Nullable
    AllNullableTypes echoAllNullableTypes(@Nullable AllNullableTypes everything);
    /** Returns the passed object, to test serialization and deserialization. */
    @Nullable
    AllNullableTypesWithoutRecursion echoAllNullableTypesWithoutRecursion(
        @Nullable AllNullableTypesWithoutRecursion everything);
    /**
     * Returns the inner `aString` value from the wrapped object, to test sending of nested objects.
     */
    @Nullable
    String extractNestedNullableString(@NonNull AllClassesWrapper wrapper);
    /**
     * Returns the inner `aString` value from the wrapped object, to test sending of nested objects.
     */
    @NonNull
    AllClassesWrapper createNestedNullableString(@Nullable String nullableString);
    /** Returns passed in arguments of multiple types. */
    @NonNull
    AllNullableTypes sendMultipleNullableTypes(
        @Nullable Boolean aNullableBool,
        @Nullable Long aNullableInt,
        @Nullable String aNullableString);
    /** Returns passed in arguments of multiple types. */
    @NonNull
    AllNullableTypesWithoutRecursion sendMultipleNullableTypesWithoutRecursion(
        @Nullable Boolean aNullableBool,
        @Nullable Long aNullableInt,
        @Nullable String aNullableString);
    /** Returns passed in int. */
    @Nullable
    Long echoNullableInt(@Nullable Long aNullableInt);
    /** Returns passed in double. */
    @Nullable
    Double echoNullableDouble(@Nullable Double aNullableDouble);
    /** Returns the passed in boolean. */
    @Nullable
    Boolean echoNullableBool(@Nullable Boolean aNullableBool);
    /** Returns the passed in string. */
    @Nullable
    String echoNullableString(@Nullable String aNullableString);
    /** Returns the passed in Uint8List. */
    @Nullable
    byte[] echoNullableUint8List(@Nullable byte[] aNullableUint8List);
    /** Returns the passed in generic Object. */
    @Nullable
    Object echoNullableObject(@Nullable Object aNullableObject);
    /** Returns the passed list, to test serialization and deserialization. */
    @Nullable
    List<Object> echoNullableList(@Nullable List<Object> aNullableList);
    /** Returns the passed list, to test serialization and deserialization. */
    @Nullable
    List<AnEnum> echoNullableEnumList(@Nullable List<AnEnum> enumList);
    /** Returns the passed list, to test serialization and deserialization. */
    @Nullable
    List<AllNullableTypes> echoNullableClassList(@Nullable List<AllNullableTypes> classList);
    /** Returns the passed list, to test serialization and deserialization. */
    @Nullable
    List<AnEnum> echoNullableNonNullEnumList(@Nullable List<AnEnum> enumList);
    /** Returns the passed list, to test serialization and deserialization. */
    @Nullable
    List<AllNullableTypes> echoNullableNonNullClassList(@Nullable List<AllNullableTypes> classList);
    /** Returns the passed map, to test serialization and deserialization. */
    @Nullable
    Map<Object, Object> echoNullableMap(@Nullable Map<Object, Object> map);
    /** Returns the passed map, to test serialization and deserialization. */
    @Nullable
    Map<String, String> echoNullableStringMap(@Nullable Map<String, String> stringMap);
    /** Returns the passed map, to test serialization and deserialization. */
    @Nullable
    Map<Long, Long> echoNullableIntMap(@Nullable Map<Long, Long> intMap);
    /** Returns the passed map, to test serialization and deserialization. */
    @Nullable
    Map<AnEnum, AnEnum> echoNullableEnumMap(@Nullable Map<AnEnum, AnEnum> enumMap);
    /** Returns the passed map, to test serialization and deserialization. */
    @Nullable
    Map<Long, AllNullableTypes> echoNullableClassMap(
        @Nullable Map<Long, AllNullableTypes> classMap);
    /** Returns the passed map, to test serialization and deserialization. */
    @Nullable
    Map<String, String> echoNullableNonNullStringMap(@Nullable Map<String, String> stringMap);
    /** Returns the passed map, to test serialization and deserialization. */
    @Nullable
    Map<Long, Long> echoNullableNonNullIntMap(@Nullable Map<Long, Long> intMap);
    /** Returns the passed map, to test serialization and deserialization. */
    @Nullable
    Map<AnEnum, AnEnum> echoNullableNonNullEnumMap(@Nullable Map<AnEnum, AnEnum> enumMap);
    /** Returns the passed map, to test serialization and deserialization. */
    @Nullable
    Map<Long, AllNullableTypes> echoNullableNonNullClassMap(
        @Nullable Map<Long, AllNullableTypes> classMap);

    @Nullable
    AnEnum echoNullableEnum(@Nullable AnEnum anEnum);

    @Nullable
    AnotherEnum echoAnotherNullableEnum(@Nullable AnotherEnum anotherEnum);
    /** Returns passed in int. */
    @Nullable
    Long echoOptionalNullableInt(@Nullable Long aNullableInt);
    /** Returns the passed in string. */
    @Nullable
    String echoNamedNullableString(@Nullable String aNullableString);
    /**
     * A no-op function taking no arguments and returning no value, to sanity test basic
     * asynchronous calling.
     */
    void noopAsync(@NonNull VoidResult result);
    /** Returns passed in int asynchronously. */
    void echoAsyncInt(@NonNull Long anInt, @NonNull Result<Long> result);
    /** Returns passed in double asynchronously. */
    void echoAsyncDouble(@NonNull Double aDouble, @NonNull Result<Double> result);
    /** Returns the passed in boolean asynchronously. */
    void echoAsyncBool(@NonNull Boolean aBool, @NonNull Result<Boolean> result);
    /** Returns the passed string asynchronously. */
    void echoAsyncString(@NonNull String aString, @NonNull Result<String> result);
    /** Returns the passed in Uint8List asynchronously. */
    void echoAsyncUint8List(@NonNull byte[] aUint8List, @NonNull Result<byte[]> result);
    /** Returns the passed in generic Object asynchronously. */
    void echoAsyncObject(@NonNull Object anObject, @NonNull Result<Object> result);
    /** Returns the passed list, to test asynchronous serialization and deserialization. */
    void echoAsyncList(@NonNull List<Object> list, @NonNull Result<List<Object>> result);
    /** Returns the passed list, to test asynchronous serialization and deserialization. */
    void echoAsyncEnumList(@NonNull List<AnEnum> enumList, @NonNull Result<List<AnEnum>> result);
    /** Returns the passed list, to test asynchronous serialization and deserialization. */
    void echoAsyncClassList(
        @NonNull List<AllNullableTypes> classList, @NonNull Result<List<AllNullableTypes>> result);
    /** Returns the passed map, to test asynchronous serialization and deserialization. */
    void echoAsyncMap(
        @NonNull Map<Object, Object> map, @NonNull Result<Map<Object, Object>> result);
    /** Returns the passed map, to test asynchronous serialization and deserialization. */
    void echoAsyncStringMap(
        @NonNull Map<String, String> stringMap, @NonNull Result<Map<String, String>> result);
    /** Returns the passed map, to test asynchronous serialization and deserialization. */
    void echoAsyncIntMap(@NonNull Map<Long, Long> intMap, @NonNull Result<Map<Long, Long>> result);
    /** Returns the passed map, to test asynchronous serialization and deserialization. */
    void echoAsyncEnumMap(
        @NonNull Map<AnEnum, AnEnum> enumMap, @NonNull Result<Map<AnEnum, AnEnum>> result);
    /** Returns the passed map, to test asynchronous serialization and deserialization. */
    void echoAsyncClassMap(
        @NonNull Map<Long, AllNullableTypes> classMap,
        @NonNull Result<Map<Long, AllNullableTypes>> result);
    /** Returns the passed enum, to test asynchronous serialization and deserialization. */
    void echoAsyncEnum(@NonNull AnEnum anEnum, @NonNull Result<AnEnum> result);
    /** Returns the passed enum, to test asynchronous serialization and deserialization. */
    void echoAnotherAsyncEnum(
        @NonNull AnotherEnum anotherEnum, @NonNull Result<AnotherEnum> result);
    /** Responds with an error from an async function returning a value. */
    void throwAsyncError(@NonNull NullableResult<Object> result);
    /** Responds with an error from an async void function. */
    void throwAsyncErrorFromVoid(@NonNull VoidResult result);
    /** Responds with a Flutter error from an async function returning a value. */
    void throwAsyncFlutterError(@NonNull NullableResult<Object> result);
    /** Returns the passed object, to test async serialization and deserialization. */
    void echoAsyncAllTypes(@NonNull AllTypes everything, @NonNull Result<AllTypes> result);
    /** Returns the passed object, to test serialization and deserialization. */
    void echoAsyncNullableAllNullableTypes(
        @Nullable AllNullableTypes everything, @NonNull NullableResult<AllNullableTypes> result);
    /** Returns the passed object, to test serialization and deserialization. */
    void echoAsyncNullableAllNullableTypesWithoutRecursion(
        @Nullable AllNullableTypesWithoutRecursion everything,
        @NonNull NullableResult<AllNullableTypesWithoutRecursion> result);
    /** Returns passed in int asynchronously. */
    void echoAsyncNullableInt(@Nullable Long anInt, @NonNull NullableResult<Long> result);
    /** Returns passed in double asynchronously. */
    void echoAsyncNullableDouble(@Nullable Double aDouble, @NonNull NullableResult<Double> result);
    /** Returns the passed in boolean asynchronously. */
    void echoAsyncNullableBool(@Nullable Boolean aBool, @NonNull NullableResult<Boolean> result);
    /** Returns the passed string asynchronously. */
    void echoAsyncNullableString(@Nullable String aString, @NonNull NullableResult<String> result);
    /** Returns the passed in Uint8List asynchronously. */
    void echoAsyncNullableUint8List(
        @Nullable byte[] aUint8List, @NonNull NullableResult<byte[]> result);
    /** Returns the passed in generic Object asynchronously. */
    void echoAsyncNullableObject(@Nullable Object anObject, @NonNull NullableResult<Object> result);
    /** Returns the passed list, to test asynchronous serialization and deserialization. */
    void echoAsyncNullableList(
        @Nullable List<Object> list, @NonNull NullableResult<List<Object>> result);
    /** Returns the passed list, to test asynchronous serialization and deserialization. */
    void echoAsyncNullableEnumList(
        @Nullable List<AnEnum> enumList, @NonNull NullableResult<List<AnEnum>> result);
    /** Returns the passed list, to test asynchronous serialization and deserialization. */
    void echoAsyncNullableClassList(
        @Nullable List<AllNullableTypes> classList,
        @NonNull NullableResult<List<AllNullableTypes>> result);
    /** Returns the passed map, to test asynchronous serialization and deserialization. */
    void echoAsyncNullableMap(
        @Nullable Map<Object, Object> map, @NonNull NullableResult<Map<Object, Object>> result);
    /** Returns the passed map, to test asynchronous serialization and deserialization. */
    void echoAsyncNullableStringMap(
        @Nullable Map<String, String> stringMap,
        @NonNull NullableResult<Map<String, String>> result);
    /** Returns the passed map, to test asynchronous serialization and deserialization. */
    void echoAsyncNullableIntMap(
        @Nullable Map<Long, Long> intMap, @NonNull NullableResult<Map<Long, Long>> result);
    /** Returns the passed map, to test asynchronous serialization and deserialization. */
    void echoAsyncNullableEnumMap(
        @Nullable Map<AnEnum, AnEnum> enumMap, @NonNull NullableResult<Map<AnEnum, AnEnum>> result);
    /** Returns the passed map, to test asynchronous serialization and deserialization. */
    void echoAsyncNullableClassMap(
        @Nullable Map<Long, AllNullableTypes> classMap,
        @NonNull NullableResult<Map<Long, AllNullableTypes>> result);
    /** Returns the passed enum, to test asynchronous serialization and deserialization. */
    void echoAsyncNullableEnum(@Nullable AnEnum anEnum, @NonNull NullableResult<AnEnum> result);
    /** Returns the passed enum, to test asynchronous serialization and deserialization. */
    void echoAnotherAsyncNullableEnum(
        @Nullable AnotherEnum anotherEnum, @NonNull NullableResult<AnotherEnum> result);
    /**
     * Returns true if the handler is run on a main thread, which should be true since there is no
     * TaskQueue annotation.
     */
    @NonNull
    Boolean defaultIsMainThread();
    /**
     * Returns true if the handler is run on a non-main thread, which should be true for any
     * platform with TaskQueue support.
     */
    @NonNull
    Boolean taskQueueIsBackgroundThread();

    void callFlutterNoop(@NonNull VoidResult result);

    void callFlutterThrowError(@NonNull NullableResult<Object> result);

    void callFlutterThrowErrorFromVoid(@NonNull VoidResult result);

    void callFlutterEchoAllTypes(@NonNull AllTypes everything, @NonNull Result<AllTypes> result);

    void callFlutterEchoAllNullableTypes(
        @Nullable AllNullableTypes everything, @NonNull NullableResult<AllNullableTypes> result);

    void callFlutterSendMultipleNullableTypes(
        @Nullable Boolean aNullableBool,
        @Nullable Long aNullableInt,
        @Nullable String aNullableString,
        @NonNull Result<AllNullableTypes> result);

    void callFlutterEchoAllNullableTypesWithoutRecursion(
        @Nullable AllNullableTypesWithoutRecursion everything,
        @NonNull NullableResult<AllNullableTypesWithoutRecursion> result);

    void callFlutterSendMultipleNullableTypesWithoutRecursion(
        @Nullable Boolean aNullableBool,
        @Nullable Long aNullableInt,
        @Nullable String aNullableString,
        @NonNull Result<AllNullableTypesWithoutRecursion> result);

    void callFlutterEchoBool(@NonNull Boolean aBool, @NonNull Result<Boolean> result);

    void callFlutterEchoInt(@NonNull Long anInt, @NonNull Result<Long> result);

    void callFlutterEchoDouble(@NonNull Double aDouble, @NonNull Result<Double> result);

    void callFlutterEchoString(@NonNull String aString, @NonNull Result<String> result);

    void callFlutterEchoUint8List(@NonNull byte[] list, @NonNull Result<byte[]> result);

    void callFlutterEchoList(@NonNull List<Object> list, @NonNull Result<List<Object>> result);

    void callFlutterEchoEnumList(
        @NonNull List<AnEnum> enumList, @NonNull Result<List<AnEnum>> result);

    void callFlutterEchoClassList(
        @NonNull List<AllNullableTypes> classList, @NonNull Result<List<AllNullableTypes>> result);

    void callFlutterEchoNonNullEnumList(
        @NonNull List<AnEnum> enumList, @NonNull Result<List<AnEnum>> result);

    void callFlutterEchoNonNullClassList(
        @NonNull List<AllNullableTypes> classList, @NonNull Result<List<AllNullableTypes>> result);

    void callFlutterEchoMap(
        @NonNull Map<Object, Object> map, @NonNull Result<Map<Object, Object>> result);

    void callFlutterEchoStringMap(
        @NonNull Map<String, String> stringMap, @NonNull Result<Map<String, String>> result);

    void callFlutterEchoIntMap(
        @NonNull Map<Long, Long> intMap, @NonNull Result<Map<Long, Long>> result);

    void callFlutterEchoEnumMap(
        @NonNull Map<AnEnum, AnEnum> enumMap, @NonNull Result<Map<AnEnum, AnEnum>> result);

    void callFlutterEchoClassMap(
        @NonNull Map<Long, AllNullableTypes> classMap,
        @NonNull Result<Map<Long, AllNullableTypes>> result);

    void callFlutterEchoNonNullStringMap(
        @NonNull Map<String, String> stringMap, @NonNull Result<Map<String, String>> result);

    void callFlutterEchoNonNullIntMap(
        @NonNull Map<Long, Long> intMap, @NonNull Result<Map<Long, Long>> result);

    void callFlutterEchoNonNullEnumMap(
        @NonNull Map<AnEnum, AnEnum> enumMap, @NonNull Result<Map<AnEnum, AnEnum>> result);

    void callFlutterEchoNonNullClassMap(
        @NonNull Map<Long, AllNullableTypes> classMap,
        @NonNull Result<Map<Long, AllNullableTypes>> result);

    void callFlutterEchoEnum(@NonNull AnEnum anEnum, @NonNull Result<AnEnum> result);

    void callFlutterEchoAnotherEnum(
        @NonNull AnotherEnum anotherEnum, @NonNull Result<AnotherEnum> result);

    void callFlutterEchoNullableBool(
        @Nullable Boolean aBool, @NonNull NullableResult<Boolean> result);

    void callFlutterEchoNullableInt(@Nullable Long anInt, @NonNull NullableResult<Long> result);

    void callFlutterEchoNullableDouble(
        @Nullable Double aDouble, @NonNull NullableResult<Double> result);

    void callFlutterEchoNullableString(
        @Nullable String aString, @NonNull NullableResult<String> result);

    void callFlutterEchoNullableUint8List(
        @Nullable byte[] list, @NonNull NullableResult<byte[]> result);

    void callFlutterEchoNullableList(
        @Nullable List<Object> list, @NonNull NullableResult<List<Object>> result);

    void callFlutterEchoNullableEnumList(
        @Nullable List<AnEnum> enumList, @NonNull NullableResult<List<AnEnum>> result);

    void callFlutterEchoNullableClassList(
        @Nullable List<AllNullableTypes> classList,
        @NonNull NullableResult<List<AllNullableTypes>> result);

    void callFlutterEchoNullableNonNullEnumList(
        @Nullable List<AnEnum> enumList, @NonNull NullableResult<List<AnEnum>> result);

    void callFlutterEchoNullableNonNullClassList(
        @Nullable List<AllNullableTypes> classList,
        @NonNull NullableResult<List<AllNullableTypes>> result);

    void callFlutterEchoNullableMap(
        @Nullable Map<Object, Object> map, @NonNull NullableResult<Map<Object, Object>> result);

    void callFlutterEchoNullableStringMap(
        @Nullable Map<String, String> stringMap,
        @NonNull NullableResult<Map<String, String>> result);

    void callFlutterEchoNullableIntMap(
        @Nullable Map<Long, Long> intMap, @NonNull NullableResult<Map<Long, Long>> result);

    void callFlutterEchoNullableEnumMap(
        @Nullable Map<AnEnum, AnEnum> enumMap, @NonNull NullableResult<Map<AnEnum, AnEnum>> result);

    void callFlutterEchoNullableClassMap(
        @Nullable Map<Long, AllNullableTypes> classMap,
        @NonNull NullableResult<Map<Long, AllNullableTypes>> result);

    void callFlutterEchoNullableNonNullStringMap(
        @Nullable Map<String, String> stringMap,
        @NonNull NullableResult<Map<String, String>> result);

    void callFlutterEchoNullableNonNullIntMap(
        @Nullable Map<Long, Long> intMap, @NonNull NullableResult<Map<Long, Long>> result);

    void callFlutterEchoNullableNonNullEnumMap(
        @Nullable Map<AnEnum, AnEnum> enumMap, @NonNull NullableResult<Map<AnEnum, AnEnum>> result);

    void callFlutterEchoNullableNonNullClassMap(
        @Nullable Map<Long, AllNullableTypes> classMap,
        @NonNull NullableResult<Map<Long, AllNullableTypes>> result);

    void callFlutterEchoNullableEnum(
        @Nullable AnEnum anEnum, @NonNull NullableResult<AnEnum> result);

    void callFlutterEchoAnotherNullableEnum(
        @Nullable AnotherEnum anotherEnum, @NonNull NullableResult<AnotherEnum> result);

    void callFlutterSmallApiEchoString(@NonNull String aString, @NonNull Result<String> result);

    /** The codec used by HostIntegrationCoreApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return PigeonCodec.INSTANCE;
    }
    /**
     * Sets up an instance of `HostIntegrationCoreApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setUp(
        @NonNull BinaryMessenger binaryMessenger, @Nullable HostIntegrationCoreApi api) {
      setUp(binaryMessenger, "", api);
    }

    static void setUp(
        @NonNull BinaryMessenger binaryMessenger,
        @NonNull String messageChannelSuffix,
        @Nullable HostIntegrationCoreApi api) {
      messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
      BinaryMessenger.TaskQueue taskQueue = binaryMessenger.makeBackgroundTaskQueue();
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.noop"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                try {
                  api.noop();
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAllTypes"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AllTypes everythingArg = (AllTypes) args.get(0);
                try {
                  AllTypes output = api.echoAllTypes(everythingArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.throwError"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                try {
                  Object output = api.throwError();
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.throwErrorFromVoid"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                try {
                  api.throwErrorFromVoid();
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.throwFlutterError"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                try {
                  Object output = api.throwFlutterError();
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoInt"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Long anIntArg = (Long) args.get(0);
                try {
                  Long output = api.echoInt(anIntArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoDouble"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Double aDoubleArg = (Double) args.get(0);
                try {
                  Double output = api.echoDouble(aDoubleArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoBool"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Boolean aBoolArg = (Boolean) args.get(0);
                try {
                  Boolean output = api.echoBool(aBoolArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoString"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                String aStringArg = (String) args.get(0);
                try {
                  String output = api.echoString(aStringArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoUint8List"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                byte[] aUint8ListArg = (byte[]) args.get(0);
                try {
                  byte[] output = api.echoUint8List(aUint8ListArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoObject"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Object anObjectArg = args.get(0);
                try {
                  Object output = api.echoObject(anObjectArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<Object> listArg = (List<Object>) args.get(0);
                try {
                  List<Object> output = api.echoList(listArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoEnumList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<AnEnum> enumListArg = (List<AnEnum>) args.get(0);
                try {
                  List<AnEnum> output = api.echoEnumList(enumListArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoClassList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<AllNullableTypes> classListArg = (List<AllNullableTypes>) args.get(0);
                try {
                  List<AllNullableTypes> output = api.echoClassList(classListArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNonNullEnumList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<AnEnum> enumListArg = (List<AnEnum>) args.get(0);
                try {
                  List<AnEnum> output = api.echoNonNullEnumList(enumListArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNonNullClassList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<AllNullableTypes> classListArg = (List<AllNullableTypes>) args.get(0);
                try {
                  List<AllNullableTypes> output = api.echoNonNullClassList(classListArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Object, Object> mapArg = (Map<Object, Object>) args.get(0);
                try {
                  Map<Object, Object> output = api.echoMap(mapArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoStringMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<String, String> stringMapArg = (Map<String, String>) args.get(0);
                try {
                  Map<String, String> output = api.echoStringMap(stringMapArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoIntMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Long, Long> intMapArg = (Map<Long, Long>) args.get(0);
                try {
                  Map<Long, Long> output = api.echoIntMap(intMapArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoEnumMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<AnEnum, AnEnum> enumMapArg = (Map<AnEnum, AnEnum>) args.get(0);
                try {
                  Map<AnEnum, AnEnum> output = api.echoEnumMap(enumMapArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoClassMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Long, AllNullableTypes> classMapArg = (Map<Long, AllNullableTypes>) args.get(0);
                try {
                  Map<Long, AllNullableTypes> output = api.echoClassMap(classMapArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNonNullStringMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<String, String> stringMapArg = (Map<String, String>) args.get(0);
                try {
                  Map<String, String> output = api.echoNonNullStringMap(stringMapArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNonNullIntMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Long, Long> intMapArg = (Map<Long, Long>) args.get(0);
                try {
                  Map<Long, Long> output = api.echoNonNullIntMap(intMapArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNonNullEnumMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<AnEnum, AnEnum> enumMapArg = (Map<AnEnum, AnEnum>) args.get(0);
                try {
                  Map<AnEnum, AnEnum> output = api.echoNonNullEnumMap(enumMapArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNonNullClassMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Long, AllNullableTypes> classMapArg = (Map<Long, AllNullableTypes>) args.get(0);
                try {
                  Map<Long, AllNullableTypes> output = api.echoNonNullClassMap(classMapArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoClassWrapper"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AllClassesWrapper wrapperArg = (AllClassesWrapper) args.get(0);
                try {
                  AllClassesWrapper output = api.echoClassWrapper(wrapperArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoEnum"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AnEnum anEnumArg = (AnEnum) args.get(0);
                try {
                  AnEnum output = api.echoEnum(anEnumArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAnotherEnum"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AnotherEnum anotherEnumArg = (AnotherEnum) args.get(0);
                try {
                  AnotherEnum output = api.echoAnotherEnum(anotherEnumArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNamedDefaultString"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                String aStringArg = (String) args.get(0);
                try {
                  String output = api.echoNamedDefaultString(aStringArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoOptionalDefaultDouble"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Double aDoubleArg = (Double) args.get(0);
                try {
                  Double output = api.echoOptionalDefaultDouble(aDoubleArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoRequiredInt"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Long anIntArg = (Long) args.get(0);
                try {
                  Long output = api.echoRequiredInt(anIntArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAllNullableTypes"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AllNullableTypes everythingArg = (AllNullableTypes) args.get(0);
                try {
                  AllNullableTypes output = api.echoAllNullableTypes(everythingArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAllNullableTypesWithoutRecursion"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AllNullableTypesWithoutRecursion everythingArg =
                    (AllNullableTypesWithoutRecursion) args.get(0);
                try {
                  AllNullableTypesWithoutRecursion output =
                      api.echoAllNullableTypesWithoutRecursion(everythingArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.extractNestedNullableString"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AllClassesWrapper wrapperArg = (AllClassesWrapper) args.get(0);
                try {
                  String output = api.extractNestedNullableString(wrapperArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.createNestedNullableString"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                String nullableStringArg = (String) args.get(0);
                try {
                  AllClassesWrapper output = api.createNestedNullableString(nullableStringArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.sendMultipleNullableTypes"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Boolean aNullableBoolArg = (Boolean) args.get(0);
                Long aNullableIntArg = (Long) args.get(1);
                String aNullableStringArg = (String) args.get(2);
                try {
                  AllNullableTypes output =
                      api.sendMultipleNullableTypes(
                          aNullableBoolArg, aNullableIntArg, aNullableStringArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.sendMultipleNullableTypesWithoutRecursion"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Boolean aNullableBoolArg = (Boolean) args.get(0);
                Long aNullableIntArg = (Long) args.get(1);
                String aNullableStringArg = (String) args.get(2);
                try {
                  AllNullableTypesWithoutRecursion output =
                      api.sendMultipleNullableTypesWithoutRecursion(
                          aNullableBoolArg, aNullableIntArg, aNullableStringArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableInt"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Long aNullableIntArg = (Long) args.get(0);
                try {
                  Long output = api.echoNullableInt(aNullableIntArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableDouble"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Double aNullableDoubleArg = (Double) args.get(0);
                try {
                  Double output = api.echoNullableDouble(aNullableDoubleArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableBool"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Boolean aNullableBoolArg = (Boolean) args.get(0);
                try {
                  Boolean output = api.echoNullableBool(aNullableBoolArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableString"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                String aNullableStringArg = (String) args.get(0);
                try {
                  String output = api.echoNullableString(aNullableStringArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableUint8List"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                byte[] aNullableUint8ListArg = (byte[]) args.get(0);
                try {
                  byte[] output = api.echoNullableUint8List(aNullableUint8ListArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableObject"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Object aNullableObjectArg = args.get(0);
                try {
                  Object output = api.echoNullableObject(aNullableObjectArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<Object> aNullableListArg = (List<Object>) args.get(0);
                try {
                  List<Object> output = api.echoNullableList(aNullableListArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableEnumList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<AnEnum> enumListArg = (List<AnEnum>) args.get(0);
                try {
                  List<AnEnum> output = api.echoNullableEnumList(enumListArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableClassList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<AllNullableTypes> classListArg = (List<AllNullableTypes>) args.get(0);
                try {
                  List<AllNullableTypes> output = api.echoNullableClassList(classListArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableNonNullEnumList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<AnEnum> enumListArg = (List<AnEnum>) args.get(0);
                try {
                  List<AnEnum> output = api.echoNullableNonNullEnumList(enumListArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableNonNullClassList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<AllNullableTypes> classListArg = (List<AllNullableTypes>) args.get(0);
                try {
                  List<AllNullableTypes> output = api.echoNullableNonNullClassList(classListArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Object, Object> mapArg = (Map<Object, Object>) args.get(0);
                try {
                  Map<Object, Object> output = api.echoNullableMap(mapArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableStringMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<String, String> stringMapArg = (Map<String, String>) args.get(0);
                try {
                  Map<String, String> output = api.echoNullableStringMap(stringMapArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableIntMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Long, Long> intMapArg = (Map<Long, Long>) args.get(0);
                try {
                  Map<Long, Long> output = api.echoNullableIntMap(intMapArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableEnumMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<AnEnum, AnEnum> enumMapArg = (Map<AnEnum, AnEnum>) args.get(0);
                try {
                  Map<AnEnum, AnEnum> output = api.echoNullableEnumMap(enumMapArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableClassMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Long, AllNullableTypes> classMapArg = (Map<Long, AllNullableTypes>) args.get(0);
                try {
                  Map<Long, AllNullableTypes> output = api.echoNullableClassMap(classMapArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableNonNullStringMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<String, String> stringMapArg = (Map<String, String>) args.get(0);
                try {
                  Map<String, String> output = api.echoNullableNonNullStringMap(stringMapArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableNonNullIntMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Long, Long> intMapArg = (Map<Long, Long>) args.get(0);
                try {
                  Map<Long, Long> output = api.echoNullableNonNullIntMap(intMapArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableNonNullEnumMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<AnEnum, AnEnum> enumMapArg = (Map<AnEnum, AnEnum>) args.get(0);
                try {
                  Map<AnEnum, AnEnum> output = api.echoNullableNonNullEnumMap(enumMapArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableNonNullClassMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Long, AllNullableTypes> classMapArg = (Map<Long, AllNullableTypes>) args.get(0);
                try {
                  Map<Long, AllNullableTypes> output = api.echoNullableNonNullClassMap(classMapArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNullableEnum"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AnEnum anEnumArg = (AnEnum) args.get(0);
                try {
                  AnEnum output = api.echoNullableEnum(anEnumArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAnotherNullableEnum"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AnotherEnum anotherEnumArg = (AnotherEnum) args.get(0);
                try {
                  AnotherEnum output = api.echoAnotherNullableEnum(anotherEnumArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoOptionalNullableInt"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Long aNullableIntArg = (Long) args.get(0);
                try {
                  Long output = api.echoOptionalNullableInt(aNullableIntArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoNamedNullableString"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                String aNullableStringArg = (String) args.get(0);
                try {
                  String output = api.echoNamedNullableString(aNullableStringArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.noopAsync"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                VoidResult resultCallback =
                    new VoidResult() {
                      public void success() {
                        wrapped.add(0, null);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.noopAsync(resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncInt"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Long anIntArg = (Long) args.get(0);
                Result<Long> resultCallback =
                    new Result<Long>() {
                      public void success(Long result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncInt(anIntArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncDouble"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Double aDoubleArg = (Double) args.get(0);
                Result<Double> resultCallback =
                    new Result<Double>() {
                      public void success(Double result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncDouble(aDoubleArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncBool"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Boolean aBoolArg = (Boolean) args.get(0);
                Result<Boolean> resultCallback =
                    new Result<Boolean>() {
                      public void success(Boolean result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncBool(aBoolArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncString"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                String aStringArg = (String) args.get(0);
                Result<String> resultCallback =
                    new Result<String>() {
                      public void success(String result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncString(aStringArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncUint8List"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                byte[] aUint8ListArg = (byte[]) args.get(0);
                Result<byte[]> resultCallback =
                    new Result<byte[]>() {
                      public void success(byte[] result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncUint8List(aUint8ListArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncObject"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Object anObjectArg = args.get(0);
                Result<Object> resultCallback =
                    new Result<Object>() {
                      public void success(Object result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncObject(anObjectArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<Object> listArg = (List<Object>) args.get(0);
                Result<List<Object>> resultCallback =
                    new Result<List<Object>>() {
                      public void success(List<Object> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncList(listArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncEnumList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<AnEnum> enumListArg = (List<AnEnum>) args.get(0);
                Result<List<AnEnum>> resultCallback =
                    new Result<List<AnEnum>>() {
                      public void success(List<AnEnum> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncEnumList(enumListArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncClassList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<AllNullableTypes> classListArg = (List<AllNullableTypes>) args.get(0);
                Result<List<AllNullableTypes>> resultCallback =
                    new Result<List<AllNullableTypes>>() {
                      public void success(List<AllNullableTypes> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncClassList(classListArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Object, Object> mapArg = (Map<Object, Object>) args.get(0);
                Result<Map<Object, Object>> resultCallback =
                    new Result<Map<Object, Object>>() {
                      public void success(Map<Object, Object> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncMap(mapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncStringMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<String, String> stringMapArg = (Map<String, String>) args.get(0);
                Result<Map<String, String>> resultCallback =
                    new Result<Map<String, String>>() {
                      public void success(Map<String, String> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncStringMap(stringMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncIntMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Long, Long> intMapArg = (Map<Long, Long>) args.get(0);
                Result<Map<Long, Long>> resultCallback =
                    new Result<Map<Long, Long>>() {
                      public void success(Map<Long, Long> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncIntMap(intMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncEnumMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<AnEnum, AnEnum> enumMapArg = (Map<AnEnum, AnEnum>) args.get(0);
                Result<Map<AnEnum, AnEnum>> resultCallback =
                    new Result<Map<AnEnum, AnEnum>>() {
                      public void success(Map<AnEnum, AnEnum> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncEnumMap(enumMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncClassMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Long, AllNullableTypes> classMapArg = (Map<Long, AllNullableTypes>) args.get(0);
                Result<Map<Long, AllNullableTypes>> resultCallback =
                    new Result<Map<Long, AllNullableTypes>>() {
                      public void success(Map<Long, AllNullableTypes> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncClassMap(classMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncEnum"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AnEnum anEnumArg = (AnEnum) args.get(0);
                Result<AnEnum> resultCallback =
                    new Result<AnEnum>() {
                      public void success(AnEnum result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncEnum(anEnumArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAnotherAsyncEnum"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AnotherEnum anotherEnumArg = (AnotherEnum) args.get(0);
                Result<AnotherEnum> resultCallback =
                    new Result<AnotherEnum>() {
                      public void success(AnotherEnum result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAnotherAsyncEnum(anotherEnumArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.throwAsyncError"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                NullableResult<Object> resultCallback =
                    new NullableResult<Object>() {
                      public void success(Object result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.throwAsyncError(resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.throwAsyncErrorFromVoid"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                VoidResult resultCallback =
                    new VoidResult() {
                      public void success() {
                        wrapped.add(0, null);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.throwAsyncErrorFromVoid(resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.throwAsyncFlutterError"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                NullableResult<Object> resultCallback =
                    new NullableResult<Object>() {
                      public void success(Object result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.throwAsyncFlutterError(resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncAllTypes"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AllTypes everythingArg = (AllTypes) args.get(0);
                Result<AllTypes> resultCallback =
                    new Result<AllTypes>() {
                      public void success(AllTypes result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncAllTypes(everythingArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableAllNullableTypes"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AllNullableTypes everythingArg = (AllNullableTypes) args.get(0);
                NullableResult<AllNullableTypes> resultCallback =
                    new NullableResult<AllNullableTypes>() {
                      public void success(AllNullableTypes result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncNullableAllNullableTypes(everythingArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableAllNullableTypesWithoutRecursion"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AllNullableTypesWithoutRecursion everythingArg =
                    (AllNullableTypesWithoutRecursion) args.get(0);
                NullableResult<AllNullableTypesWithoutRecursion> resultCallback =
                    new NullableResult<AllNullableTypesWithoutRecursion>() {
                      public void success(AllNullableTypesWithoutRecursion result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncNullableAllNullableTypesWithoutRecursion(
                    everythingArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableInt"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Long anIntArg = (Long) args.get(0);
                NullableResult<Long> resultCallback =
                    new NullableResult<Long>() {
                      public void success(Long result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncNullableInt(anIntArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableDouble"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Double aDoubleArg = (Double) args.get(0);
                NullableResult<Double> resultCallback =
                    new NullableResult<Double>() {
                      public void success(Double result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncNullableDouble(aDoubleArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableBool"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Boolean aBoolArg = (Boolean) args.get(0);
                NullableResult<Boolean> resultCallback =
                    new NullableResult<Boolean>() {
                      public void success(Boolean result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncNullableBool(aBoolArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableString"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                String aStringArg = (String) args.get(0);
                NullableResult<String> resultCallback =
                    new NullableResult<String>() {
                      public void success(String result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncNullableString(aStringArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableUint8List"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                byte[] aUint8ListArg = (byte[]) args.get(0);
                NullableResult<byte[]> resultCallback =
                    new NullableResult<byte[]>() {
                      public void success(byte[] result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncNullableUint8List(aUint8ListArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableObject"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Object anObjectArg = args.get(0);
                NullableResult<Object> resultCallback =
                    new NullableResult<Object>() {
                      public void success(Object result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncNullableObject(anObjectArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<Object> listArg = (List<Object>) args.get(0);
                NullableResult<List<Object>> resultCallback =
                    new NullableResult<List<Object>>() {
                      public void success(List<Object> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncNullableList(listArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableEnumList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<AnEnum> enumListArg = (List<AnEnum>) args.get(0);
                NullableResult<List<AnEnum>> resultCallback =
                    new NullableResult<List<AnEnum>>() {
                      public void success(List<AnEnum> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncNullableEnumList(enumListArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableClassList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<AllNullableTypes> classListArg = (List<AllNullableTypes>) args.get(0);
                NullableResult<List<AllNullableTypes>> resultCallback =
                    new NullableResult<List<AllNullableTypes>>() {
                      public void success(List<AllNullableTypes> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncNullableClassList(classListArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Object, Object> mapArg = (Map<Object, Object>) args.get(0);
                NullableResult<Map<Object, Object>> resultCallback =
                    new NullableResult<Map<Object, Object>>() {
                      public void success(Map<Object, Object> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncNullableMap(mapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableStringMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<String, String> stringMapArg = (Map<String, String>) args.get(0);
                NullableResult<Map<String, String>> resultCallback =
                    new NullableResult<Map<String, String>>() {
                      public void success(Map<String, String> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncNullableStringMap(stringMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableIntMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Long, Long> intMapArg = (Map<Long, Long>) args.get(0);
                NullableResult<Map<Long, Long>> resultCallback =
                    new NullableResult<Map<Long, Long>>() {
                      public void success(Map<Long, Long> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncNullableIntMap(intMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableEnumMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<AnEnum, AnEnum> enumMapArg = (Map<AnEnum, AnEnum>) args.get(0);
                NullableResult<Map<AnEnum, AnEnum>> resultCallback =
                    new NullableResult<Map<AnEnum, AnEnum>>() {
                      public void success(Map<AnEnum, AnEnum> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncNullableEnumMap(enumMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableClassMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Long, AllNullableTypes> classMapArg = (Map<Long, AllNullableTypes>) args.get(0);
                NullableResult<Map<Long, AllNullableTypes>> resultCallback =
                    new NullableResult<Map<Long, AllNullableTypes>>() {
                      public void success(Map<Long, AllNullableTypes> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncNullableClassMap(classMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAsyncNullableEnum"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AnEnum anEnumArg = (AnEnum) args.get(0);
                NullableResult<AnEnum> resultCallback =
                    new NullableResult<AnEnum>() {
                      public void success(AnEnum result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAsyncNullableEnum(anEnumArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.echoAnotherAsyncNullableEnum"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AnotherEnum anotherEnumArg = (AnotherEnum) args.get(0);
                NullableResult<AnotherEnum> resultCallback =
                    new NullableResult<AnotherEnum>() {
                      public void success(AnotherEnum result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echoAnotherAsyncNullableEnum(anotherEnumArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.defaultIsMainThread"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                try {
                  Boolean output = api.defaultIsMainThread();
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.taskQueueIsBackgroundThread"
                    + messageChannelSuffix,
                getCodec(),
                taskQueue);
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                try {
                  Boolean output = api.taskQueueIsBackgroundThread();
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterNoop"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                VoidResult resultCallback =
                    new VoidResult() {
                      public void success() {
                        wrapped.add(0, null);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterNoop(resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterThrowError"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                NullableResult<Object> resultCallback =
                    new NullableResult<Object>() {
                      public void success(Object result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterThrowError(resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterThrowErrorFromVoid"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                VoidResult resultCallback =
                    new VoidResult() {
                      public void success() {
                        wrapped.add(0, null);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterThrowErrorFromVoid(resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoAllTypes"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AllTypes everythingArg = (AllTypes) args.get(0);
                Result<AllTypes> resultCallback =
                    new Result<AllTypes>() {
                      public void success(AllTypes result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoAllTypes(everythingArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoAllNullableTypes"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AllNullableTypes everythingArg = (AllNullableTypes) args.get(0);
                NullableResult<AllNullableTypes> resultCallback =
                    new NullableResult<AllNullableTypes>() {
                      public void success(AllNullableTypes result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoAllNullableTypes(everythingArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterSendMultipleNullableTypes"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Boolean aNullableBoolArg = (Boolean) args.get(0);
                Long aNullableIntArg = (Long) args.get(1);
                String aNullableStringArg = (String) args.get(2);
                Result<AllNullableTypes> resultCallback =
                    new Result<AllNullableTypes>() {
                      public void success(AllNullableTypes result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterSendMultipleNullableTypes(
                    aNullableBoolArg, aNullableIntArg, aNullableStringArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoAllNullableTypesWithoutRecursion"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AllNullableTypesWithoutRecursion everythingArg =
                    (AllNullableTypesWithoutRecursion) args.get(0);
                NullableResult<AllNullableTypesWithoutRecursion> resultCallback =
                    new NullableResult<AllNullableTypesWithoutRecursion>() {
                      public void success(AllNullableTypesWithoutRecursion result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoAllNullableTypesWithoutRecursion(everythingArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterSendMultipleNullableTypesWithoutRecursion"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Boolean aNullableBoolArg = (Boolean) args.get(0);
                Long aNullableIntArg = (Long) args.get(1);
                String aNullableStringArg = (String) args.get(2);
                Result<AllNullableTypesWithoutRecursion> resultCallback =
                    new Result<AllNullableTypesWithoutRecursion>() {
                      public void success(AllNullableTypesWithoutRecursion result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterSendMultipleNullableTypesWithoutRecursion(
                    aNullableBoolArg, aNullableIntArg, aNullableStringArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoBool"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Boolean aBoolArg = (Boolean) args.get(0);
                Result<Boolean> resultCallback =
                    new Result<Boolean>() {
                      public void success(Boolean result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoBool(aBoolArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoInt"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Long anIntArg = (Long) args.get(0);
                Result<Long> resultCallback =
                    new Result<Long>() {
                      public void success(Long result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoInt(anIntArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoDouble"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Double aDoubleArg = (Double) args.get(0);
                Result<Double> resultCallback =
                    new Result<Double>() {
                      public void success(Double result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoDouble(aDoubleArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoString"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                String aStringArg = (String) args.get(0);
                Result<String> resultCallback =
                    new Result<String>() {
                      public void success(String result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoString(aStringArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoUint8List"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                byte[] listArg = (byte[]) args.get(0);
                Result<byte[]> resultCallback =
                    new Result<byte[]>() {
                      public void success(byte[] result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoUint8List(listArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<Object> listArg = (List<Object>) args.get(0);
                Result<List<Object>> resultCallback =
                    new Result<List<Object>>() {
                      public void success(List<Object> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoList(listArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoEnumList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<AnEnum> enumListArg = (List<AnEnum>) args.get(0);
                Result<List<AnEnum>> resultCallback =
                    new Result<List<AnEnum>>() {
                      public void success(List<AnEnum> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoEnumList(enumListArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoClassList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<AllNullableTypes> classListArg = (List<AllNullableTypes>) args.get(0);
                Result<List<AllNullableTypes>> resultCallback =
                    new Result<List<AllNullableTypes>>() {
                      public void success(List<AllNullableTypes> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoClassList(classListArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNonNullEnumList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<AnEnum> enumListArg = (List<AnEnum>) args.get(0);
                Result<List<AnEnum>> resultCallback =
                    new Result<List<AnEnum>>() {
                      public void success(List<AnEnum> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNonNullEnumList(enumListArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNonNullClassList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<AllNullableTypes> classListArg = (List<AllNullableTypes>) args.get(0);
                Result<List<AllNullableTypes>> resultCallback =
                    new Result<List<AllNullableTypes>>() {
                      public void success(List<AllNullableTypes> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNonNullClassList(classListArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Object, Object> mapArg = (Map<Object, Object>) args.get(0);
                Result<Map<Object, Object>> resultCallback =
                    new Result<Map<Object, Object>>() {
                      public void success(Map<Object, Object> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoMap(mapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoStringMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<String, String> stringMapArg = (Map<String, String>) args.get(0);
                Result<Map<String, String>> resultCallback =
                    new Result<Map<String, String>>() {
                      public void success(Map<String, String> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoStringMap(stringMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoIntMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Long, Long> intMapArg = (Map<Long, Long>) args.get(0);
                Result<Map<Long, Long>> resultCallback =
                    new Result<Map<Long, Long>>() {
                      public void success(Map<Long, Long> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoIntMap(intMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoEnumMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<AnEnum, AnEnum> enumMapArg = (Map<AnEnum, AnEnum>) args.get(0);
                Result<Map<AnEnum, AnEnum>> resultCallback =
                    new Result<Map<AnEnum, AnEnum>>() {
                      public void success(Map<AnEnum, AnEnum> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoEnumMap(enumMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoClassMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Long, AllNullableTypes> classMapArg = (Map<Long, AllNullableTypes>) args.get(0);
                Result<Map<Long, AllNullableTypes>> resultCallback =
                    new Result<Map<Long, AllNullableTypes>>() {
                      public void success(Map<Long, AllNullableTypes> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoClassMap(classMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNonNullStringMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<String, String> stringMapArg = (Map<String, String>) args.get(0);
                Result<Map<String, String>> resultCallback =
                    new Result<Map<String, String>>() {
                      public void success(Map<String, String> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNonNullStringMap(stringMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNonNullIntMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Long, Long> intMapArg = (Map<Long, Long>) args.get(0);
                Result<Map<Long, Long>> resultCallback =
                    new Result<Map<Long, Long>>() {
                      public void success(Map<Long, Long> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNonNullIntMap(intMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNonNullEnumMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<AnEnum, AnEnum> enumMapArg = (Map<AnEnum, AnEnum>) args.get(0);
                Result<Map<AnEnum, AnEnum>> resultCallback =
                    new Result<Map<AnEnum, AnEnum>>() {
                      public void success(Map<AnEnum, AnEnum> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNonNullEnumMap(enumMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNonNullClassMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Long, AllNullableTypes> classMapArg = (Map<Long, AllNullableTypes>) args.get(0);
                Result<Map<Long, AllNullableTypes>> resultCallback =
                    new Result<Map<Long, AllNullableTypes>>() {
                      public void success(Map<Long, AllNullableTypes> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNonNullClassMap(classMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoEnum"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AnEnum anEnumArg = (AnEnum) args.get(0);
                Result<AnEnum> resultCallback =
                    new Result<AnEnum>() {
                      public void success(AnEnum result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoEnum(anEnumArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoAnotherEnum"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AnotherEnum anotherEnumArg = (AnotherEnum) args.get(0);
                Result<AnotherEnum> resultCallback =
                    new Result<AnotherEnum>() {
                      public void success(AnotherEnum result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoAnotherEnum(anotherEnumArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableBool"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Boolean aBoolArg = (Boolean) args.get(0);
                NullableResult<Boolean> resultCallback =
                    new NullableResult<Boolean>() {
                      public void success(Boolean result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNullableBool(aBoolArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableInt"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Long anIntArg = (Long) args.get(0);
                NullableResult<Long> resultCallback =
                    new NullableResult<Long>() {
                      public void success(Long result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNullableInt(anIntArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableDouble"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Double aDoubleArg = (Double) args.get(0);
                NullableResult<Double> resultCallback =
                    new NullableResult<Double>() {
                      public void success(Double result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNullableDouble(aDoubleArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableString"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                String aStringArg = (String) args.get(0);
                NullableResult<String> resultCallback =
                    new NullableResult<String>() {
                      public void success(String result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNullableString(aStringArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableUint8List"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                byte[] listArg = (byte[]) args.get(0);
                NullableResult<byte[]> resultCallback =
                    new NullableResult<byte[]>() {
                      public void success(byte[] result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNullableUint8List(listArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<Object> listArg = (List<Object>) args.get(0);
                NullableResult<List<Object>> resultCallback =
                    new NullableResult<List<Object>>() {
                      public void success(List<Object> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNullableList(listArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableEnumList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<AnEnum> enumListArg = (List<AnEnum>) args.get(0);
                NullableResult<List<AnEnum>> resultCallback =
                    new NullableResult<List<AnEnum>>() {
                      public void success(List<AnEnum> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNullableEnumList(enumListArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableClassList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<AllNullableTypes> classListArg = (List<AllNullableTypes>) args.get(0);
                NullableResult<List<AllNullableTypes>> resultCallback =
                    new NullableResult<List<AllNullableTypes>>() {
                      public void success(List<AllNullableTypes> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNullableClassList(classListArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableNonNullEnumList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<AnEnum> enumListArg = (List<AnEnum>) args.get(0);
                NullableResult<List<AnEnum>> resultCallback =
                    new NullableResult<List<AnEnum>>() {
                      public void success(List<AnEnum> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNullableNonNullEnumList(enumListArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableNonNullClassList"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                List<AllNullableTypes> classListArg = (List<AllNullableTypes>) args.get(0);
                NullableResult<List<AllNullableTypes>> resultCallback =
                    new NullableResult<List<AllNullableTypes>>() {
                      public void success(List<AllNullableTypes> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNullableNonNullClassList(classListArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Object, Object> mapArg = (Map<Object, Object>) args.get(0);
                NullableResult<Map<Object, Object>> resultCallback =
                    new NullableResult<Map<Object, Object>>() {
                      public void success(Map<Object, Object> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNullableMap(mapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableStringMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<String, String> stringMapArg = (Map<String, String>) args.get(0);
                NullableResult<Map<String, String>> resultCallback =
                    new NullableResult<Map<String, String>>() {
                      public void success(Map<String, String> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNullableStringMap(stringMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableIntMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Long, Long> intMapArg = (Map<Long, Long>) args.get(0);
                NullableResult<Map<Long, Long>> resultCallback =
                    new NullableResult<Map<Long, Long>>() {
                      public void success(Map<Long, Long> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNullableIntMap(intMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableEnumMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<AnEnum, AnEnum> enumMapArg = (Map<AnEnum, AnEnum>) args.get(0);
                NullableResult<Map<AnEnum, AnEnum>> resultCallback =
                    new NullableResult<Map<AnEnum, AnEnum>>() {
                      public void success(Map<AnEnum, AnEnum> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNullableEnumMap(enumMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableClassMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Long, AllNullableTypes> classMapArg = (Map<Long, AllNullableTypes>) args.get(0);
                NullableResult<Map<Long, AllNullableTypes>> resultCallback =
                    new NullableResult<Map<Long, AllNullableTypes>>() {
                      public void success(Map<Long, AllNullableTypes> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNullableClassMap(classMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableNonNullStringMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<String, String> stringMapArg = (Map<String, String>) args.get(0);
                NullableResult<Map<String, String>> resultCallback =
                    new NullableResult<Map<String, String>>() {
                      public void success(Map<String, String> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNullableNonNullStringMap(stringMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableNonNullIntMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Long, Long> intMapArg = (Map<Long, Long>) args.get(0);
                NullableResult<Map<Long, Long>> resultCallback =
                    new NullableResult<Map<Long, Long>>() {
                      public void success(Map<Long, Long> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNullableNonNullIntMap(intMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableNonNullEnumMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<AnEnum, AnEnum> enumMapArg = (Map<AnEnum, AnEnum>) args.get(0);
                NullableResult<Map<AnEnum, AnEnum>> resultCallback =
                    new NullableResult<Map<AnEnum, AnEnum>>() {
                      public void success(Map<AnEnum, AnEnum> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNullableNonNullEnumMap(enumMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableNonNullClassMap"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Map<Long, AllNullableTypes> classMapArg = (Map<Long, AllNullableTypes>) args.get(0);
                NullableResult<Map<Long, AllNullableTypes>> resultCallback =
                    new NullableResult<Map<Long, AllNullableTypes>>() {
                      public void success(Map<Long, AllNullableTypes> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNullableNonNullClassMap(classMapArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoNullableEnum"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AnEnum anEnumArg = (AnEnum) args.get(0);
                NullableResult<AnEnum> resultCallback =
                    new NullableResult<AnEnum>() {
                      public void success(AnEnum result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoNullableEnum(anEnumArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterEchoAnotherNullableEnum"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                AnotherEnum anotherEnumArg = (AnotherEnum) args.get(0);
                NullableResult<AnotherEnum> resultCallback =
                    new NullableResult<AnotherEnum>() {
                      public void success(AnotherEnum result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterEchoAnotherNullableEnum(anotherEnumArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.callFlutterSmallApiEchoString"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                String aStringArg = (String) args.get(0);
                Result<String> resultCallback =
                    new Result<String>() {
                      public void success(String result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.callFlutterSmallApiEchoString(aStringArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /**
   * The core interface that the Dart platform_test code implements for host integration tests to
   * call into.
   *
   * <p>Generated class from Pigeon that represents Flutter messages that can be called from Java.
   */
  public static class FlutterIntegrationCoreApi {
    private final @NonNull BinaryMessenger binaryMessenger;
    private final String messageChannelSuffix;

    public FlutterIntegrationCoreApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this(argBinaryMessenger, "");
    }

    public FlutterIntegrationCoreApi(
        @NonNull BinaryMessenger argBinaryMessenger, @NonNull String messageChannelSuffix) {
      this.binaryMessenger = argBinaryMessenger;
      this.messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
    }

    /** Public interface for sending reply. The codec used by FlutterIntegrationCoreApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return PigeonCodec.INSTANCE;
    }
    /**
     * A no-op function taking no arguments and returning no value, to sanity test basic calling.
     */
    public void noop(@NonNull VoidResult result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.noop"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          null,
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                result.success();
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Responds with an error from an async function returning a value. */
    public void throwError(@NonNull NullableResult<Object> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.throwError"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          null,
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                Object output = listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Responds with an error from an async void function. */
    public void throwErrorFromVoid(@NonNull VoidResult result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.throwErrorFromVoid"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          null,
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                result.success();
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed object, to test serialization and deserialization. */
    public void echoAllTypes(@NonNull AllTypes everythingArg, @NonNull Result<AllTypes> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoAllTypes"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(everythingArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                AllTypes output = (AllTypes) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed object, to test serialization and deserialization. */
    public void echoAllNullableTypes(
        @Nullable AllNullableTypes everythingArg,
        @NonNull NullableResult<AllNullableTypes> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoAllNullableTypes"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(everythingArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                AllNullableTypes output = (AllNullableTypes) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /**
     * Returns passed in arguments of multiple types.
     *
     * <p>Tests multiple-arity FlutterApi handling.
     */
    public void sendMultipleNullableTypes(
        @Nullable Boolean aNullableBoolArg,
        @Nullable Long aNullableIntArg,
        @Nullable String aNullableStringArg,
        @NonNull Result<AllNullableTypes> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.sendMultipleNullableTypes"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Arrays.asList(aNullableBoolArg, aNullableIntArg, aNullableStringArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                AllNullableTypes output = (AllNullableTypes) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed object, to test serialization and deserialization. */
    public void echoAllNullableTypesWithoutRecursion(
        @Nullable AllNullableTypesWithoutRecursion everythingArg,
        @NonNull NullableResult<AllNullableTypesWithoutRecursion> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoAllNullableTypesWithoutRecursion"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(everythingArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                AllNullableTypesWithoutRecursion output =
                    (AllNullableTypesWithoutRecursion) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /**
     * Returns passed in arguments of multiple types.
     *
     * <p>Tests multiple-arity FlutterApi handling.
     */
    public void sendMultipleNullableTypesWithoutRecursion(
        @Nullable Boolean aNullableBoolArg,
        @Nullable Long aNullableIntArg,
        @Nullable String aNullableStringArg,
        @NonNull Result<AllNullableTypesWithoutRecursion> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.sendMultipleNullableTypesWithoutRecursion"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Arrays.asList(aNullableBoolArg, aNullableIntArg, aNullableStringArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                AllNullableTypesWithoutRecursion output =
                    (AllNullableTypesWithoutRecursion) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed boolean, to test serialization and deserialization. */
    public void echoBool(@NonNull Boolean aBoolArg, @NonNull Result<Boolean> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoBool"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(aBoolArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                Boolean output = (Boolean) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed int, to test serialization and deserialization. */
    public void echoInt(@NonNull Long anIntArg, @NonNull Result<Long> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoInt"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(anIntArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                Long output = (Long) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed double, to test serialization and deserialization. */
    public void echoDouble(@NonNull Double aDoubleArg, @NonNull Result<Double> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoDouble"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(aDoubleArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                Double output = (Double) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed string, to test serialization and deserialization. */
    public void echoString(@NonNull String aStringArg, @NonNull Result<String> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoString"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(aStringArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                String output = (String) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed byte list, to test serialization and deserialization. */
    public void echoUint8List(@NonNull byte[] listArg, @NonNull Result<byte[]> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoUint8List"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(listArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                byte[] output = (byte[]) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed list, to test serialization and deserialization. */
    public void echoList(@NonNull List<Object> listArg, @NonNull Result<List<Object>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoList"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(listArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                List<Object> output = (List<Object>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed list, to test serialization and deserialization. */
    public void echoEnumList(
        @NonNull List<AnEnum> enumListArg, @NonNull Result<List<AnEnum>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoEnumList"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(enumListArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                List<AnEnum> output = (List<AnEnum>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed list, to test serialization and deserialization. */
    public void echoClassList(
        @NonNull List<AllNullableTypes> classListArg,
        @NonNull Result<List<AllNullableTypes>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoClassList"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(classListArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                List<AllNullableTypes> output = (List<AllNullableTypes>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed list, to test serialization and deserialization. */
    public void echoNonNullEnumList(
        @NonNull List<AnEnum> enumListArg, @NonNull Result<List<AnEnum>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNonNullEnumList"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(enumListArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                List<AnEnum> output = (List<AnEnum>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed list, to test serialization and deserialization. */
    public void echoNonNullClassList(
        @NonNull List<AllNullableTypes> classListArg,
        @NonNull Result<List<AllNullableTypes>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNonNullClassList"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(classListArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                List<AllNullableTypes> output = (List<AllNullableTypes>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed map, to test serialization and deserialization. */
    public void echoMap(
        @NonNull Map<Object, Object> mapArg, @NonNull Result<Map<Object, Object>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoMap"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(mapArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                Map<Object, Object> output = (Map<Object, Object>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed map, to test serialization and deserialization. */
    public void echoStringMap(
        @NonNull Map<String, String> stringMapArg, @NonNull Result<Map<String, String>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoStringMap"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(stringMapArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                Map<String, String> output = (Map<String, String>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed map, to test serialization and deserialization. */
    public void echoIntMap(
        @NonNull Map<Long, Long> intMapArg, @NonNull Result<Map<Long, Long>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoIntMap"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(intMapArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                Map<Long, Long> output = (Map<Long, Long>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed map, to test serialization and deserialization. */
    public void echoEnumMap(
        @NonNull Map<AnEnum, AnEnum> enumMapArg, @NonNull Result<Map<AnEnum, AnEnum>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoEnumMap"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(enumMapArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                Map<AnEnum, AnEnum> output = (Map<AnEnum, AnEnum>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed map, to test serialization and deserialization. */
    public void echoClassMap(
        @NonNull Map<Long, AllNullableTypes> classMapArg,
        @NonNull Result<Map<Long, AllNullableTypes>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoClassMap"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(classMapArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                Map<Long, AllNullableTypes> output = (Map<Long, AllNullableTypes>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed map, to test serialization and deserialization. */
    public void echoNonNullStringMap(
        @NonNull Map<String, String> stringMapArg, @NonNull Result<Map<String, String>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNonNullStringMap"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(stringMapArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                Map<String, String> output = (Map<String, String>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed map, to test serialization and deserialization. */
    public void echoNonNullIntMap(
        @NonNull Map<Long, Long> intMapArg, @NonNull Result<Map<Long, Long>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNonNullIntMap"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(intMapArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                Map<Long, Long> output = (Map<Long, Long>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed map, to test serialization and deserialization. */
    public void echoNonNullEnumMap(
        @NonNull Map<AnEnum, AnEnum> enumMapArg, @NonNull Result<Map<AnEnum, AnEnum>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNonNullEnumMap"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(enumMapArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                Map<AnEnum, AnEnum> output = (Map<AnEnum, AnEnum>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed map, to test serialization and deserialization. */
    public void echoNonNullClassMap(
        @NonNull Map<Long, AllNullableTypes> classMapArg,
        @NonNull Result<Map<Long, AllNullableTypes>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNonNullClassMap"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(classMapArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                Map<Long, AllNullableTypes> output = (Map<Long, AllNullableTypes>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed enum to test serialization and deserialization. */
    public void echoEnum(@NonNull AnEnum anEnumArg, @NonNull Result<AnEnum> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoEnum"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(anEnumArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                AnEnum output = (AnEnum) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed enum to test serialization and deserialization. */
    public void echoAnotherEnum(
        @NonNull AnotherEnum anotherEnumArg, @NonNull Result<AnotherEnum> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoAnotherEnum"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(anotherEnumArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                AnotherEnum output = (AnotherEnum) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed boolean, to test serialization and deserialization. */
    public void echoNullableBool(
        @Nullable Boolean aBoolArg, @NonNull NullableResult<Boolean> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableBool"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(aBoolArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                Boolean output = (Boolean) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed int, to test serialization and deserialization. */
    public void echoNullableInt(@Nullable Long anIntArg, @NonNull NullableResult<Long> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableInt"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(anIntArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                Long output = (Long) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed double, to test serialization and deserialization. */
    public void echoNullableDouble(
        @Nullable Double aDoubleArg, @NonNull NullableResult<Double> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableDouble"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(aDoubleArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                Double output = (Double) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed string, to test serialization and deserialization. */
    public void echoNullableString(
        @Nullable String aStringArg, @NonNull NullableResult<String> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableString"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(aStringArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                String output = (String) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed byte list, to test serialization and deserialization. */
    public void echoNullableUint8List(
        @Nullable byte[] listArg, @NonNull NullableResult<byte[]> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableUint8List"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(listArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                byte[] output = (byte[]) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed list, to test serialization and deserialization. */
    public void echoNullableList(
        @Nullable List<Object> listArg, @NonNull NullableResult<List<Object>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableList"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(listArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                List<Object> output = (List<Object>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed list, to test serialization and deserialization. */
    public void echoNullableEnumList(
        @Nullable List<AnEnum> enumListArg, @NonNull NullableResult<List<AnEnum>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableEnumList"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(enumListArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                List<AnEnum> output = (List<AnEnum>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed list, to test serialization and deserialization. */
    public void echoNullableClassList(
        @Nullable List<AllNullableTypes> classListArg,
        @NonNull NullableResult<List<AllNullableTypes>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableClassList"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(classListArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                List<AllNullableTypes> output = (List<AllNullableTypes>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed list, to test serialization and deserialization. */
    public void echoNullableNonNullEnumList(
        @Nullable List<AnEnum> enumListArg, @NonNull NullableResult<List<AnEnum>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableNonNullEnumList"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(enumListArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                List<AnEnum> output = (List<AnEnum>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed list, to test serialization and deserialization. */
    public void echoNullableNonNullClassList(
        @Nullable List<AllNullableTypes> classListArg,
        @NonNull NullableResult<List<AllNullableTypes>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableNonNullClassList"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(classListArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                List<AllNullableTypes> output = (List<AllNullableTypes>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed map, to test serialization and deserialization. */
    public void echoNullableMap(
        @Nullable Map<Object, Object> mapArg, @NonNull NullableResult<Map<Object, Object>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableMap"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(mapArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                Map<Object, Object> output = (Map<Object, Object>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed map, to test serialization and deserialization. */
    public void echoNullableStringMap(
        @Nullable Map<String, String> stringMapArg,
        @NonNull NullableResult<Map<String, String>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableStringMap"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(stringMapArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                Map<String, String> output = (Map<String, String>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed map, to test serialization and deserialization. */
    public void echoNullableIntMap(
        @Nullable Map<Long, Long> intMapArg, @NonNull NullableResult<Map<Long, Long>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableIntMap"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(intMapArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                Map<Long, Long> output = (Map<Long, Long>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed map, to test serialization and deserialization. */
    public void echoNullableEnumMap(
        @Nullable Map<AnEnum, AnEnum> enumMapArg,
        @NonNull NullableResult<Map<AnEnum, AnEnum>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableEnumMap"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(enumMapArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                Map<AnEnum, AnEnum> output = (Map<AnEnum, AnEnum>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed map, to test serialization and deserialization. */
    public void echoNullableClassMap(
        @Nullable Map<Long, AllNullableTypes> classMapArg,
        @NonNull NullableResult<Map<Long, AllNullableTypes>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableClassMap"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(classMapArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                Map<Long, AllNullableTypes> output = (Map<Long, AllNullableTypes>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed map, to test serialization and deserialization. */
    public void echoNullableNonNullStringMap(
        @Nullable Map<String, String> stringMapArg,
        @NonNull NullableResult<Map<String, String>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableNonNullStringMap"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(stringMapArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                Map<String, String> output = (Map<String, String>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed map, to test serialization and deserialization. */
    public void echoNullableNonNullIntMap(
        @Nullable Map<Long, Long> intMapArg, @NonNull NullableResult<Map<Long, Long>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableNonNullIntMap"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(intMapArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                Map<Long, Long> output = (Map<Long, Long>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed map, to test serialization and deserialization. */
    public void echoNullableNonNullEnumMap(
        @Nullable Map<AnEnum, AnEnum> enumMapArg,
        @NonNull NullableResult<Map<AnEnum, AnEnum>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableNonNullEnumMap"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(enumMapArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                Map<AnEnum, AnEnum> output = (Map<AnEnum, AnEnum>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed map, to test serialization and deserialization. */
    public void echoNullableNonNullClassMap(
        @Nullable Map<Long, AllNullableTypes> classMapArg,
        @NonNull NullableResult<Map<Long, AllNullableTypes>> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableNonNullClassMap"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(classMapArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                Map<Long, AllNullableTypes> output = (Map<Long, AllNullableTypes>) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed enum to test serialization and deserialization. */
    public void echoNullableEnum(
        @Nullable AnEnum anEnumArg, @NonNull NullableResult<AnEnum> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoNullableEnum"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(anEnumArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                AnEnum output = (AnEnum) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed enum to test serialization and deserialization. */
    public void echoAnotherNullableEnum(
        @Nullable AnotherEnum anotherEnumArg, @NonNull NullableResult<AnotherEnum> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoAnotherNullableEnum"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(anotherEnumArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                @SuppressWarnings("ConstantConditions")
                AnotherEnum output = (AnotherEnum) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /**
     * A no-op function taking no arguments and returning no value, to sanity test basic
     * asynchronous calling.
     */
    public void noopAsync(@NonNull VoidResult result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.noopAsync"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          null,
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                result.success();
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
    /** Returns the passed in generic Object asynchronously. */
    public void echoAsyncString(@NonNull String aStringArg, @NonNull Result<String> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi.echoAsyncString"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(aStringArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                String output = (String) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
  }
  /**
   * An API that can be implemented for minimal, compile-only tests.
   *
   * <p>Generated interface from Pigeon that represents a handler of messages from Flutter.
   */
  public interface HostTrivialApi {

    void noop();

    /** The codec used by HostTrivialApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return PigeonCodec.INSTANCE;
    }
    /** Sets up an instance of `HostTrivialApi` to handle messages through the `binaryMessenger`. */
    static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable HostTrivialApi api) {
      setUp(binaryMessenger, "", api);
    }

    static void setUp(
        @NonNull BinaryMessenger binaryMessenger,
        @NonNull String messageChannelSuffix,
        @Nullable HostTrivialApi api) {
      messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostTrivialApi.noop"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                try {
                  api.noop();
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /**
   * A simple API implemented in some unit tests.
   *
   * <p>Generated interface from Pigeon that represents a handler of messages from Flutter.
   */
  public interface HostSmallApi {

    void echo(@NonNull String aString, @NonNull Result<String> result);

    void voidVoid(@NonNull VoidResult result);

    /** The codec used by HostSmallApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return PigeonCodec.INSTANCE;
    }
    /** Sets up an instance of `HostSmallApi` to handle messages through the `binaryMessenger`. */
    static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable HostSmallApi api) {
      setUp(binaryMessenger, "", api);
    }

    static void setUp(
        @NonNull BinaryMessenger binaryMessenger,
        @NonNull String messageChannelSuffix,
        @Nullable HostSmallApi api) {
      messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostSmallApi.echo"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                String aStringArg = (String) args.get(0);
                Result<String> resultCallback =
                    new Result<String>() {
                      public void success(String result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.echo(aStringArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.HostSmallApi.voidVoid"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                VoidResult resultCallback =
                    new VoidResult() {
                      public void success() {
                        wrapped.add(0, null);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.voidVoid(resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /**
   * A simple API called in some unit tests.
   *
   * <p>Generated class from Pigeon that represents Flutter messages that can be called from Java.
   */
  public static class FlutterSmallApi {
    private final @NonNull BinaryMessenger binaryMessenger;
    private final String messageChannelSuffix;

    public FlutterSmallApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this(argBinaryMessenger, "");
    }

    public FlutterSmallApi(
        @NonNull BinaryMessenger argBinaryMessenger, @NonNull String messageChannelSuffix) {
      this.binaryMessenger = argBinaryMessenger;
      this.messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
    }

    /** Public interface for sending reply. The codec used by FlutterSmallApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return PigeonCodec.INSTANCE;
    }

    public void echoWrappedList(@NonNull TestMessage msgArg, @NonNull Result<TestMessage> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterSmallApi.echoWrappedList"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(msgArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                TestMessage output = (TestMessage) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }

    public void echoString(@NonNull String aStringArg, @NonNull Result<String> result) {
      final String channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.FlutterSmallApi.echoString"
              + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(aStringArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(
                    new FlutterError(
                        (String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else if (listReply.get(0) == null) {
                result.error(
                    new FlutterError(
                        "null-error",
                        "Flutter api returned null value for non-null return value.",
                        ""));
              } else {
                @SuppressWarnings("ConstantConditions")
                String output = (String) listReply.get(0);
                result.success(output);
              }
            } else {
              result.error(createConnectionError(channelName));
            }
          });
    }
  }
}
