# Partner Sharing

:::tip Sharing specific assets
For sharing a specific set of assets, you can use the shared album feature of Immich.
:::

Immich allows you to share your library with other users. They can then view your library and download the assets. You can manage Partner Sharing from the [User Settings](docs/features/user-settings.md) page on the web.

Partner Sharing includes:

- Access to all non-archived and trashed photos and videos.
- Access to all metadata, including GPS information.
- Access to share assets via shared links, albums, etc.

:::info
Partner sharing is one-way. To view your partner's assets, they must also share them with you.
:::

## Sharing with a Partner

:::note Duplicates
Partner sharing may result in displaying duplicate assets on the main timeline.
:::

<img src={require('./img/partner-sharing-1.png').default} width="70%" title='Add Partner 1' />

<img src={require('./img/partner-sharing-2.png').default} width="70%" title='Add Partner 2' />

<img src={require('./img/partner-sharing-4.png').default} width="70%" title='Add Partner 4' />

## Viewing Partner Assets

Access partner assets via the Sharing page.

<img src={require('./img/partner-sharing-3.png').default} width="70%" title='Access to the Shared Library' />

## Timeline Integration

Partner shared photos can be displayed in the main timeline. This feature can be enabled on a per-partner basis and can be viewed and updated on both the web and mobile app.

### Web:

Account Settings -> Sharing -> Show in timeline

<img src={require('./img/partner-sharing-5.png').default} width="70%" title='Partner Sharing for the web interface' />

### Mobile App:

From the partner’s view, on the top right corner of the app bar

<img src={require('./img/partner-sharing-6.png').default} width="30%" title='Partner Sharing for the mobile app' />

## Removing Access

In order to remove a partner, you can go to User -> Account Settings -> Sharing and click on the X button.

<img src={require('./img/partner-sharing-7.png').default} width="70%" title='Remove Partner' />
