import 'dart:async';

import 'package:analyzer/src/dart/analysis/analysis_context_collection.dart';
import 'package:analyzer/src/dart/analysis/byte_store.dart';
import 'package:analyzer/src/dart/analysis/status.dart';

void main() async {
  final byteStore = MemoryByteStore();

  for (var i = 0; i < 2; i++) {
    final collection = AnalysisContextCollectionImpl(
      includedPaths: [
        // '/Users/scheglov/Source/Dart/sdk.git/sdk/pkg/analysis_server',
        '/Users/scheglov/Source/Dart/sdk.git/sdk/pkg/analysis_server/lib/src/computer',
      ],
      byteStore: byteStore,
      drainStreams: false,
    );

    final timer = Stopwatch()..start();
    for (final analysisContext in collection.contexts) {
      for (final path in analysisContext.contextRoot.analyzedFiles()) {
        if (path.endsWith('.dart')) {
          analysisContext.driver.addFile(path);
        }
      }
    }

    final idleCompleter = Completer<void>();
    collection.scheduler.events.listen((event) {
      if (event is AnalysisStatus && event.isIdle) {
        idleCompleter.complete();
      }
    });

    await idleCompleter.future;
    print('[time: ${timer.elapsedMilliseconds} ms]');
    // await collection.dispose();
  }
}
