// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v10.0.1), do not edit directly.
// See also: https://pub.dev/packages/pigeon
// ignore_for_file: public_member_api_docs, non_constant_identifier_names, avoid_as, unused_import, unnecessary_parenthesis, prefer_null_aware_operators, omit_local_variable_types, unused_shown_name, unnecessary_import

import 'dart:async';
import 'dart:typed_data' show Float64List, Int32List, Int64List, Uint8List;

import 'package:flutter/foundation.dart' show ReadBuffer, WriteBuffer;
import 'package:flutter/services.dart';

class TypeGroup {
  TypeGroup({
    required this.label,
    required this.extensions,
  });

  String label;

  List<String?> extensions;

  Object encode() {
    return <Object?>[
      label,
      extensions,
    ];
  }

  static TypeGroup decode(Object result) {
    result as List<Object?>;
    return TypeGroup(
      label: result[0]! as String,
      extensions: (result[1] as List<Object?>?)!.cast<String?>(),
    );
  }
}

class SelectionOptions {
  SelectionOptions({
    required this.allowMultiple,
    required this.selectFolders,
    required this.allowedTypes,
  });

  bool allowMultiple;

  bool selectFolders;

  List<TypeGroup?> allowedTypes;

  Object encode() {
    return <Object?>[
      allowMultiple,
      selectFolders,
      allowedTypes,
    ];
  }

  static SelectionOptions decode(Object result) {
    result as List<Object?>;
    return SelectionOptions(
      allowMultiple: result[0]! as bool,
      selectFolders: result[1]! as bool,
      allowedTypes: (result[2] as List<Object?>?)!.cast<TypeGroup?>(),
    );
  }
}

/// The result from an open or save dialog.
class FileDialogResult {
  FileDialogResult({
    required this.paths,
    this.typeGroupIndex,
  });

  /// The selected paths.
  ///
  /// Empty if the dialog was canceled.
  List<String?> paths;

  /// The type group index (into the list provided in [SelectionOptions]) of
  /// the group that was selected when the dialog was confirmed.
  ///
  /// Null if no type groups were provided, or the dialog was canceled.
  int? typeGroupIndex;

  Object encode() {
    return <Object?>[
      paths,
      typeGroupIndex,
    ];
  }

  static FileDialogResult decode(Object result) {
    result as List<Object?>;
    return FileDialogResult(
      paths: (result[0] as List<Object?>?)!.cast<String?>(),
      typeGroupIndex: result[1] as int?,
    );
  }
}

class _FileSelectorApiCodec extends StandardMessageCodec {
  const _FileSelectorApiCodec();
  @override
  void writeValue(WriteBuffer buffer, Object? value) {
    if (value is FileDialogResult) {
      buffer.putUint8(128);
      writeValue(buffer, value.encode());
    } else if (value is SelectionOptions) {
      buffer.putUint8(129);
      writeValue(buffer, value.encode());
    } else if (value is TypeGroup) {
      buffer.putUint8(130);
      writeValue(buffer, value.encode());
    } else {
      super.writeValue(buffer, value);
    }
  }

  @override
  Object? readValueOfType(int type, ReadBuffer buffer) {
    switch (type) {
      case 128:
        return FileDialogResult.decode(readValue(buffer)!);
      case 129:
        return SelectionOptions.decode(readValue(buffer)!);
      case 130:
        return TypeGroup.decode(readValue(buffer)!);
      default:
        return super.readValueOfType(type, buffer);
    }
  }
}

class FileSelectorApi {
  /// Constructor for [FileSelectorApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  FileSelectorApi({BinaryMessenger? binaryMessenger})
      : _binaryMessenger = binaryMessenger;
  final BinaryMessenger? _binaryMessenger;

  static const MessageCodec<Object?> codec = _FileSelectorApiCodec();

  Future<FileDialogResult> showOpenDialog(SelectionOptions arg_options,
      String? arg_initialDirectory, String? arg_confirmButtonText) async {
    final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.FileSelectorApi.showOpenDialog', codec,
        binaryMessenger: _binaryMessenger);
    final List<Object?>? replyList = await channel.send(
            <Object?>[arg_options, arg_initialDirectory, arg_confirmButtonText])
        as List<Object?>?;
    if (replyList == null) {
      throw PlatformException(
        code: 'channel-error',
        message: 'Unable to establish connection on channel.',
      );
    } else if (replyList.length > 1) {
      throw PlatformException(
        code: replyList[0]! as String,
        message: replyList[1] as String?,
        details: replyList[2],
      );
    } else if (replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (replyList[0] as FileDialogResult?)!;
    }
  }

  Future<FileDialogResult> showSaveDialog(
      SelectionOptions arg_options,
      String? arg_initialDirectory,
      String? arg_suggestedName,
      String? arg_confirmButtonText) async {
    final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.FileSelectorApi.showSaveDialog', codec,
        binaryMessenger: _binaryMessenger);
    final List<Object?>? replyList = await channel.send(<Object?>[
      arg_options,
      arg_initialDirectory,
      arg_suggestedName,
      arg_confirmButtonText
    ]) as List<Object?>?;
    if (replyList == null) {
      throw PlatformException(
        code: 'channel-error',
        message: 'Unable to establish connection on channel.',
      );
    } else if (replyList.length > 1) {
      throw PlatformException(
        code: replyList[0]! as String,
        message: replyList[1] as String?,
        details: replyList[2],
      );
    } else if (replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (replyList[0] as FileDialogResult?)!;
    }
  }
}
