# Contribution

Feel free to contribute to the FakeStandby project! Consider the [Code Of Conduct](CODE_OF_CONDUCT.md) before contributing.
Each change will be reviewed by a maintainer (only Jonas Bernard yet) and applied, if it fits the Code Of Conduct and pursues the [Project aims](PROJECT_AIMS.md).
You can contribute to the project in the following 4 different ways.

## Conceptual contribution
If you have any conceptual or strategic critics or ideas, just leave them [here on GitHub](https://github.com/JonasBernard/FakeStandby/issues/new/choose).
Make sure to be clear and precise, while keeping sentences short and easy to understand. For special edge cases you should give additional context and screenshots
where possible. As my native language is German, issues in English and German are equally accepted.

## Translations
You can help translating the app content and other texts to any supported language using [this link](https://poeditor.com/join/project/WkxMBheCVb).
If your native language is not supported yet, you can suggest it using the same link.

While translating make sure to mind the context. You're translating an android app that saves battery. It may help to open the app for translating
to keep track of the strings you're translating, and where they are displayed in the app.

## Code contribution
To code contribute fork this repository and [create a pull request](https://github.com/JonasBernard/FakeStandby/compare) after you commited
your changes to your fork.

Code should be tested on one real device at least, the more the better.

Whatever you do, do not hardcode stings that are displayed to the user!
Strings have to be added to the according string xml files in at least English.
The rest of the translation can be done by someone else on the translation platform.

As the app will be published on F-Droid, the code has to fit their [Inclusion Policy](https://f-droid.org/en/docs/Inclusion_Policy/).
This means, you can't just add any closed source dependencies or google services to the app. Make sure to double check the changes against this policy before
commiting.

## Contribute to Website and PR media
To contribute to the website have a look at the [corresponding branch](https://github.com/JonasBernard/FakeStandby/tree/gh-pages).

To add PR meida and images anywhere to the project, [contact me directly](mailto:public.jbernard@web.de).
