/*
 * Decompiled with CFR 0.152.
 */
package com.antlersoft.android.contentxml;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.util.Xml;
import com.antlersoft.android.contentxml.ContentValuesElement;
import com.antlersoft.util.xml.IElement;
import com.antlersoft.util.xml.IHandlerStack;
import com.antlersoft.util.xml.SimpleAttributes;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlpull.v1.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqliteElement
implements IElement {
    private ArrayList<String> _tableNames;
    SQLiteDatabase _db;
    private ReplaceStrategy _replaceStrategy;
    private String _databaseTag;
    static final String[] TABLE_ARRAY = new String[]{"name"};
    static final String TABLE_ELEMENT = "table";
    static final String TABLE_NAME_ATTRIBUTE = "table_name";
    static final String ROW_ELEMENT = "row";

    public static void exportDbAsXmlToStream(SQLiteDatabase sQLiteDatabase, Writer writer) throws SAXException, IOException {
        XmlSerializer xmlSerializer = Xml.newSerializer();
        xmlSerializer.setOutput(writer);
        new SqliteElement(sQLiteDatabase, "database").writeToXML(new XmlSerializerHandler(xmlSerializer));
        xmlSerializer.flush();
    }

    public static void importXmlStreamToDb(SQLiteDatabase sQLiteDatabase, Reader reader, ReplaceStrategy replaceStrategy) throws SAXException, IOException {
        SqliteElement sqliteElement = new SqliteElement(sQLiteDatabase, "database");
        sqliteElement.setReplaceStrategy(replaceStrategy);
        StackContentHandler stackContentHandler = new StackContentHandler();
        stackContentHandler.pushHandlerStack(sqliteElement.readFromXML(stackContentHandler));
        Xml.parse((Reader)reader, (ContentHandler)stackContentHandler);
    }

    public SqliteElement(SQLiteDatabase sQLiteDatabase, String string) {
        this._db = sQLiteDatabase;
        this._tableNames = new ArrayList();
        this._databaseTag = string;
        this._replaceStrategy = ReplaceStrategy.REPLACE_EXISTING;
    }

    public ReplaceStrategy getReplaceStrategy() {
        return this._replaceStrategy;
    }

    public void setReplaceStrategy(ReplaceStrategy replaceStrategy) {
        this._replaceStrategy = replaceStrategy;
    }

    public void addTable(String string) {
        if (!this._tableNames.contains(string)) {
            this._tableNames.add(string);
        }
    }

    public void removeTable(String string) {
        this.getTableNames().remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<String> getTableNames() {
        if (this._tableNames.size() == 0) {
            Cursor cursor = this._db.query("sqlite_master", TABLE_ARRAY, "type = 'table'", null, null, null, null);
            try {
                while (cursor.moveToNext()) {
                    String string = cursor.getString(0);
                    String string2 = string.toLowerCase();
                    if (string2.equals("android_metadata") || string2.equals("sqlite_sequence")) continue;
                    this._tableNames.add(string);
                }
            }
            finally {
                cursor.close();
            }
        }
        return this._tableNames;
    }

    @Override
    public String getElementTag() {
        return this._databaseTag;
    }

    @Override
    public DefaultHandler readFromXML(IHandlerStack iHandlerStack) {
        return new SqliteElementHandler(iHandlerStack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToXML(ContentHandler contentHandler) throws SAXException {
        contentHandler.startElement("", "", this.getElementTag(), null);
        for (String string : this.getTableNames()) {
            SimpleAttributes simpleAttributes = new SimpleAttributes();
            simpleAttributes.addValue(TABLE_NAME_ATTRIBUTE, string);
            contentHandler.startElement("", "", TABLE_ELEMENT, simpleAttributes.getAttributes());
            Cursor cursor = this._db.query(string, null, null, null, null, null, null);
            try {
                if (cursor.moveToFirst()) {
                    ContentValues contentValues = new ContentValues();
                    do {
                        DatabaseUtils.cursorRowToContentValues((Cursor)cursor, (ContentValues)contentValues);
                        new ContentValuesElement(contentValues, ROW_ELEMENT).writeToXML(contentHandler);
                    } while (cursor.moveToNext());
                }
            }
            finally {
                cursor.close();
            }
            contentHandler.endElement("", "", TABLE_ELEMENT);
        }
        contentHandler.endElement("", "", this.getElementTag());
    }

    static class XmlSerializerHandler
    extends DefaultHandler {
        XmlSerializer _serializer;
        boolean _first;

        XmlSerializerHandler(XmlSerializer xmlSerializer) {
            this._serializer = xmlSerializer;
            this._first = true;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            try {
                this._serializer.text(cArray, n, n2);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException.getMessage(), iOException);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            try {
                this._serializer.endTag(string, string3);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException.getMessage(), iOException);
            }
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            try {
                this._serializer.ignorableWhitespace(new String(cArray, n, n2));
            }
            catch (IOException iOException) {
                throw new SAXException(iOException.getMessage(), iOException);
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                if (this._first) {
                    this._first = false;
                } else {
                    this._serializer.ignorableWhitespace("\r\n");
                }
                this._serializer.startTag(string, string3);
                if (attributes != null) {
                    int n = attributes.getLength();
                    for (int i = 0; i < n; ++i) {
                        this._serializer.attribute(attributes.getURI(i), attributes.getQName(i), attributes.getValue(i));
                    }
                }
            }
            catch (IOException iOException) {
                throw new SAXException(iOException.getMessage(), iOException);
            }
        }
    }

    class SqliteElementHandler
    extends DefaultHandler {
        private IHandlerStack _stack;
        private String _currentTable;
        private ContentValues _lastRow;
        private static final long INSERT_FAILED = -1L;

        public SqliteElementHandler(IHandlerStack iHandlerStack) {
            this._stack = iHandlerStack;
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            this.saveLastRow();
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.saveLastRow();
            if (string2.equals(SqliteElement.TABLE_ELEMENT)) {
                this._currentTable = attributes.getValue(SqliteElement.TABLE_NAME_ATTRIBUTE);
                if (this._currentTable == null) {
                    throw new SAXException("table_name not found in table element.");
                }
                if (SqliteElement.this.getTableNames().contains(this._currentTable)) {
                    if (SqliteElement.this.getReplaceStrategy() == ReplaceStrategy.REPLACE_ALL) {
                        SqliteElement.this._db.delete(this._currentTable, null, null);
                    }
                } else {
                    this._currentTable = null;
                }
            } else if (string2.equals(SqliteElement.ROW_ELEMENT)) {
                this._lastRow = new ContentValues();
                ContentValuesElement contentValuesElement = new ContentValuesElement(this._lastRow, SqliteElement.ROW_ELEMENT);
                this._stack.startWithHandler(contentValuesElement.readFromXML(this._stack), string, string2, string3, attributes);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void saveLastRow() {
            if (this._lastRow == null) return;
            try {
                if (this._currentTable == null) return;
                long l = SqliteElement.this._db.insert(this._currentTable, null, this._lastRow);
                if (l != -1L) return;
                switch (SqliteElement.this.getReplaceStrategy()) {
                    case REPLACE_ALL: {
                        throw new SQLException("Failed to insert row in " + this._currentTable + " after emptying");
                    }
                    case REPLACE_EXISTING: {
                        SqliteElement.this._db.delete(this._currentTable, "_id = ?", new String[]{this._lastRow.getAsString("_id")});
                        SqliteElement.this._db.insertOrThrow(this._currentTable, null, this._lastRow);
                        return;
                    }
                }
                return;
            }
            finally {
                this._lastRow = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReplaceStrategy {
        REPLACE_ALL,
        REPLACE_EXISTING,
        REPLACE_NONE;

    }

    public static class StackContentHandler
    implements ContentHandler,
    IHandlerStack {
        private Stack<ContentHandler> _stack = new Stack();

        public void popHandlerStack() {
            this._stack.pop();
        }

        public void pushHandlerStack(DefaultHandler defaultHandler) {
            this._stack.push(defaultHandler);
        }

        public void startWithHandler(DefaultHandler defaultHandler, String string, String string2, String string3, Attributes attributes) throws SAXException {
            this._stack.push(defaultHandler);
            defaultHandler.startElement(string, string2, string3, attributes);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this._stack.peek().characters(cArray, n, n2);
        }

        public void endDocument() throws SAXException {
            this._stack.peek().endDocument();
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            this._stack.peek().endElement(string, string2, string3);
        }

        public void endPrefixMapping(String string) throws SAXException {
            this._stack.peek().endPrefixMapping(string);
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this._stack.peek().ignorableWhitespace(cArray, n, n2);
        }

        public void processingInstruction(String string, String string2) throws SAXException {
            this._stack.peek().processingInstruction(string, string2);
        }

        public void setDocumentLocator(Locator locator) {
            this._stack.peek().setDocumentLocator(locator);
        }

        public void skippedEntity(String string) throws SAXException {
            this._stack.peek().skippedEntity(string);
        }

        public void startDocument() throws SAXException {
            this._stack.peek().startDocument();
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this._stack.peek().startElement(string, string2, string3, attributes);
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
            this._stack.peek().startPrefixMapping(string, string2);
        }
    }
}

