# Aer - fork of [Anemo]

> [!NOTE]  
> - This fork focuses on supporting app's *private location* on external storage (~ SD card)  
> - If no external storage exists it'll gracefully fall back to using internal storage  
> - Anemo and Aer can be used side by side for maximal profit

[Anemo]: https://github.com/2bllw8/anemo

[![Aer CI](https://github.com/nain-F49FF806/anemo-aer/actions/workflows/main.yml/badge.svg)](https://github.com/nain-F49FF806/anemo-aer/actions/workflows/main.yml)
[![Latest release](https://img.shields.io/github/v/release/nain-F49FF806/anemo-aer?label=download)](https://github.com/nain-F49FF806/anemo-aer/releases/latest)

Aer is a private local storage utility application for android.
Instead of being a stand-alone file manager user interface, it hooks into various components of
Android making it feel like a native part of the operating system.
Moreover it provides ways for the user to export contents from other apps and save them as files.

## Features

- Create folders and organize files freely
- All files in the private storage won't appear in the other apps
- Access in the system Files application (the _DocumentsProviderUI_)
    - An optional shortcut for devices that do not expose the system Files app is offered
- Lock access to the private storage
  - Quick tile
  - Auto lock after 15 minutes
  - Password for locking access to the files
- Import content using the share Android functionality

## Download

Get the Aer apk from github [releases](https://github.com/nain-F49FF806/anemo-aer/releases)

<!--- 
[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
     alt="Get it on F-Droid"
     height="60">](https://f-droid.org/packages/exe.bbllw8.anemo/)
-->

## Build

With Gradle:
- `./gradlew :app:assembleRelease`
- `./gradlew :app:assembleDebug`

## Get help

Open an discussion [on github](https://github.com/2bllw8/anemo/discussions/new?category=Q-A)

## Contributions

**Every contributions, including ideas, bug reports and Pull Requests are welcome!**

- **Solve bug(s)**, add **feature(s)** or **translate** Aer to your native language by making a **[pull request](https://help.github.com/articles/about-pull-requests/)**
- You have an idea for improvement or a new feature? Open a feature request **[upstream](https://github.com/2bllw8/anemo/issues/new?assignees=&labels=enhancement&template=feature_request.yml&title=[Feature+request]+)** or specifically **[for Aer](https://github.com/nain-F49FF806/anemo-aer/issues/new?assignees=&labels=enhancement&template=feature_request.yml&title=[Feature+request]+)**
- You faced a bug, let us know by opening a **[bug report](https://github.com/nain-F49FF806/anemo-aer/issues/new?assignees=&labels=bug&template=bug_report.yml&title=%5BBug%5D+)**

## License

Aer is licensed under the [GNU General Public License v3 (GPL-3)](http://www.gnu.org/copyleft/gpl.html).
