package agrigolo.chubbyclick;

public class TapTempo {

    private int count = 0;
    private long tapStart = 0;
    private long tapTimer = 0;
    private long tapPrevious = 0;
    private double bpmAvg = 0;

    // Get BPM
    public boolean tap() {
        tapTimer = System.currentTimeMillis();

        if (count == 0) {
            tapStart = tapTimer;
            tapPrevious = tapStart;
            count = 1;
            return true;

        } else {
            //Reset tempo after a given timeout
            if ((tapTimer - tapPrevious) >= 4000) {
                count = 0;
                tapStart = 0;
                tapTimer = 0;
                tapPrevious = 0;
                bpmAvg = 0;
                return false;
            }
            bpmAvg = 60000 * count / (tapTimer - tapStart);

            if (bpmAvg > 400) {
                bpmAvg = 400;
            }

            bpmAvg = Math.round(bpmAvg);
            tapPrevious = tapTimer;
            count++;
        }
        return true;
    }

    public double getAvgBpm() {
        return this.bpmAvg;
    }

}
