package agrigolo.chubbyclick.practice;

import android.os.Bundle;
import android.text.Editable;
import android.text.Html;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RadioGroup;
import android.widget.TextView;

import androidx.fragment.app.Fragment;

import com.google.android.material.snackbar.Snackbar;

import java.util.ArrayList;
import java.util.List;

import agrigolo.chubbyclick.R;
import agrigolo.chubbyclick.metronome.Metronome;
import agrigolo.chubbyclick.utilities.Preferences;

public class PracticeFragment extends Fragment {

    private Metronome metronome = new Metronome(4, 4, "abbb");
    private Double startBPM;
    private Double endBPM;
    private double current_bpm;
    private int current_beat = Integer.parseInt(Preferences.getBeat());
    private String beatSubdivisions = Preferences.getBeatSubdivisions();
    private View v;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup parent, Bundle savedInstanceState) {
        v = inflater.inflate(R.layout.fragment_practice, parent, false);

        androidx.appcompat.widget.Toolbar toolbar = (androidx.appcompat.widget.Toolbar) v.findViewById(R.id.toolbar);
        toolbar.setSubtitle(Html.fromHtml("<small>" + getResources().getString(R.string.text_practice_subtitle) + "</small>"));

        final Button startButton = v.findViewById(R.id.start_stop);
        final TextView currentBPMValue = v.findViewById(R.id.bpm_text);
        final RadioGroup increase_decrease = v.findViewById(R.id.increase_decrease_group);
        final TextView bpmStart = v.findViewById(R.id.bpm_start_value);
        final TextView bpmChangeValue = v.findViewById(R.id.bpm_change_value);
        final TextView measures = v.findViewById(R.id.measures_value);
        final TextView bpmEnd = v.findViewById(R.id.until_value);

        syncPreferences("load");

        startButton.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                if (!metronome.isPlaying()) {
                    if (TextUtils.isEmpty(bpmStart.getText())
                            || TextUtils.isEmpty(bpmChangeValue.getText())
                            || TextUtils.isEmpty(measures.getText())
                    ) {
                        Snackbar.make(v, getResources().getString(R.string.practice_empty_fields), 2000).show();
                        return;
                    }
                    startBPM = Double.parseDouble(bpmStart.getText().toString());
                    endBPM = Double.parseDouble(bpmEnd.getText().toString());
                    if (increase_decrease.getCheckedRadioButtonId() == R.id.increase_button) {
                        if (endBPM < startBPM) {
                            Snackbar.make(v, getResources().getString(R.string.practice_error_1), 2000).show();
                            return;
                        }
                    }
                    if (increase_decrease.getCheckedRadioButtonId() == R.id.decrease_button) {
                        if (endBPM > startBPM) {
                            Snackbar.make(v, getResources().getString(R.string.practice_error_2), 2000).show();
                            return;
                        }
                    }
                    final Double bpmChange = Double.parseDouble(bpmChangeValue.getText().toString());
                    final int changeMeasures = Integer.parseInt(measures.getText().toString());

                    current_bpm = startBPM;
                    currentBPMValue.setText(String.valueOf((int) current_bpm));
                    metronome = new Metronome(startBPM, current_beat, beatSubdivisions);
                    metronome.execute();
                    startButton.setText(getResources().getString(R.string.text_stop));

                    metronome.setMetronomeListener(new Metronome.MetronomeListener() {
                        @Override
                        public void onMeasureChange(int current_measure) {
                            int selected = increase_decrease.getCheckedRadioButtonId();
                            switch (selected) {
                                case R.id.increase_button:
                                    if ((current_bpm + bpmChange <= endBPM) && (current_measure % changeMeasures == 0)) {
                                        current_bpm += bpmChange;
                                        currentBPMValue.setText(String.valueOf((int) current_bpm));
                                        metronome.setBpm(current_bpm);
                                    }
                                case R.id.decrease_button:
                                    if (current_bpm - bpmChange >= endBPM && (current_measure % changeMeasures == 0)) {
                                        current_bpm -= bpmChange;
                                        currentBPMValue.setText(String.valueOf((int) current_bpm));
                                        metronome.setBpm(current_bpm);
                                    }
                            }
                        }

                    });
                } else {
                    metronome.stop();
                    startButton.setText(getResources().getString(R.string.text_start));

                }
            }
        });

        List<TextView> practiceTextViews = new ArrayList<TextView>() {
            {
                add(bpmStart);
                add(bpmEnd);
                add(measures);
                add(bpmChangeValue);
            }
        };

        for (final TextView textView : practiceTextViews)
            textView.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                }

                @Override
                public void afterTextChanged(Editable editable) {
                    validateNumber(textView.getId());
                }
            });

        return v;
    }

    private void validateNumber(int id) {
        TextView textView = v.findViewById(id);
        int currentValue;

        try {
            currentValue = Integer.parseInt(textView.getText().toString());
            if (currentValue == 0) textView.setText("1");
            else if (currentValue > 400) textView.setText("400");
        } catch (NumberFormatException ex) {
            textView.setText("1");
        }
    }

    private void syncPreferences(String mode) {
        TextView bpmStart = v.findViewById(R.id.bpm_start_value);
        TextView bpmEnd = v.findViewById(R.id.until_value);
        TextView bpmChangeValue = v.findViewById(R.id.bpm_change_value);
        TextView measures = v.findViewById(R.id.measures_value);
        RadioGroup increase_decrease = v.findViewById(R.id.increase_decrease_group);

        switch (mode) {
            case "save":
                Preferences.setPracticeStartBPM(bpmStart.getText().toString());
                Preferences.setPracticeEndBPM(bpmEnd.getText().toString());
                Preferences.setPracticeChangeBPM(bpmChangeValue.getText().toString());
                Preferences.setPracticeMeasures(measures.getText().toString());
                if (increase_decrease.getCheckedRadioButtonId() == R.id.increase_button)
                    Preferences.setPracticeIncreaseDecrease("increase");
                else Preferences.setPracticeIncreaseDecrease("decrease");
                break;
            case "load":
                bpmStart.setText(Preferences.getPracticeStartBPM());
                bpmEnd.setText(Preferences.getPracticeEndBPM());
                bpmChangeValue.setText(Preferences.getPracticeChangeBPM());
                measures.setText(Preferences.getPracticeMeasures());
                if (Preferences.getPracticeIncreaseDecrease() == "increase")
                    increase_decrease.check(R.id.increase_button);
                else increase_decrease.check(R.id.decrease_button);
                break;
        }
    }

    private void stopClick() {
        if (metronome.isPlaying()) {
            metronome.stop();
            metronome = new Metronome(current_bpm, current_beat, beatSubdivisions);
        }
    }

    @Override
    public void onDetach() {
        stopClick();
        syncPreferences("save");
        super.onDetach();
    }

}