package agrigolo.chubbyclick.practice;

import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RadioGroup;
import android.widget.TextView;

import androidx.fragment.app.Fragment;

import agrigolo.chubbyclick.R;
import agrigolo.chubbyclick.metronome.Metronome;
import agrigolo.chubbyclick.utilities.Preferences;

public class PracticeFragment extends Fragment {

    private Preferences prefs;
    private Metronome metronome;
    private Double startBPM;
    private double current_bpm;
    private int current_beat = 4;
    private View v;
    private Boolean playing = false;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup parent, Bundle savedInstanceState) {
        v = inflater.inflate(R.layout.fragment_practice, parent, false);

        final Button startButton = v.findViewById(R.id.start_stop);
        final TextView currentBPMValue = v.findViewById(R.id.bpm_text);
        final RadioGroup increase_decrease = v.findViewById(R.id.increase_decrease_group);
        final TextView bpmStart = v.findViewById(R.id.bpm_start_value);
        final TextView bpmChangeValue = v.findViewById(R.id.bpm_change_value);
        final TextView measures = v.findViewById(R.id.measures_value);

        startButton.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                startBPM = Double.parseDouble(bpmStart.getText().toString());

                if (playing == false && startBPM != null) {
                    playing = true;
                    current_bpm = startBPM;
                    currentBPMValue.setText(String.valueOf(startBPM.intValue()));
                    metronome = new Metronome(startBPM, current_beat);
                    metronome.execute();
                    startButton.setText(getResources().getString(R.string.text_stop));

                    metronome.setMetronomeListener(new Metronome.MetronomeListener() {
                        @Override
                        public void onMeasureChange(int current_measure) {
                            //TODO : Create Metronome Practice Function
                            int selected = increase_decrease.getCheckedRadioButtonId();
                            if (selected == R.id.increase_button) {

                            }
                            if (selected == R.id.decrease_button) {

                            }
                            Log.w("chubby", String.valueOf(selected));
                        }
                    });

                } else {
                    playing = false;
                    metronome.stop();
                    metronome = new Metronome(startBPM, current_beat);
                    startButton.setText(getResources().getString(R.string.text_start));

                }
            }
        });

        return v;
    }

}