package agrigolo.chubbyclick;

import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.SeekBar;
import android.widget.TextView;

import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;

import com.google.android.material.snackbar.Snackbar;

import agrigolo.chubbyclick.metronome.Metronome;
import agrigolo.chubbyclick.utilities.Preferences;
import agrigolo.chubbyclick.utilities.TapTempo;

import static java.lang.Double.valueOf;

public class HomeFragment extends androidx.fragment.app.Fragment {

    private boolean soundDialogOpened = false;
    private Preferences prefs;
    private double current_bpm;
    private int current_beat;
    private Context myContext;
    private TapTempo taptempo = new TapTempo();
    private Metronome metronome;
    private OnFragmentInteractionListener mListener;
    private View v;

    public HomeFragment() {
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setHasOptionsMenu(true);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {

        v = inflater.inflate(R.layout.fragment_home, null, false);

        Toolbar toolbar = v.findViewById(R.id.toolbar);
        ((AppCompatActivity) getActivity()).setSupportActionBar(toolbar);

        prefs = new Preferences();

        current_beat = Integer.parseInt(Preferences.getBeat());
        current_bpm = Double.parseDouble(Preferences.getBpm());

        metronome = new Metronome(current_bpm, current_beat);

        final SeekBar seekbar = v.findViewById(R.id.tempo_seek);
        final TextView bpmText = v.findViewById(R.id.bpm_text);
        final TextView beatText = v.findViewById(R.id.input_beats);
        beatText.setText(String.valueOf(current_beat));

        seekbar.setProgress((int) current_bpm);
        bpmText.setText(String.valueOf((int) current_bpm));

        final Button startButton = v.findViewById(R.id.start_stop);
        final Button tapTempoButton = v.findViewById(R.id.tap_tempo);
        final Button minusOneButton = v.findViewById(R.id.minus_1);
        final Button minusTenButton = v.findViewById(R.id.minus_10);
        final Button plusOneButton = v.findViewById(R.id.plus_1);
        final Button plusTenButton = v.findViewById(R.id.plus_10);
        final Button beatPlusButton = v.findViewById(R.id.beat_plus);
        final Button beatMinusButton = v.findViewById(R.id.beat_minus);

        startButton.setText(getResources().getString(R.string.text_start));

        tapTempoButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (!taptempo.tap()) {
                    Snackbar.make(v, getResources().getString(R.string.taptempo_reset), 4000).show();
                }
                current_bpm = taptempo.getAvgBpm();
                change_bpm(current_bpm);
            }
        });
        minusOneButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (current_bpm > 1) {
                    current_bpm -= 1;
                    change_bpm(current_bpm);
                }
            }
        });
        minusTenButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (current_bpm > 10) {
                    current_bpm -= 10;
                    change_bpm(current_bpm);
                }
            }
        });
        plusOneButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (current_bpm < 400) {
                    current_bpm += 1;
                    change_bpm(current_bpm);
                }
            }
        });
        plusTenButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (current_bpm <= 390) {
                    current_bpm += 10;
                    change_bpm(current_bpm);
                }
            }
        });
        beatMinusButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (current_beat > 1) {
                    current_beat -= 1;
                    beatText.setText(String.valueOf(current_beat));
                    prefs.setBeat(String.valueOf(current_beat));
                    if (metronome.isPlaying()) {
                        restartClick();
                    }
                }
            }
        });

        beatPlusButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (current_beat < 32) {
                    current_beat += 1;
                    beatText.setText(String.valueOf(current_beat));
                    prefs.setBeat(String.valueOf(current_beat));
                    if (metronome.isPlaying()) {
                        restartClick();
                    }
                }
            }
        });

        beatText.addTextChangedListener(new TextWatcher() {

            public void afterTextChanged(Editable s) {
                current_beat = Integer.parseInt(beatText.getText().toString());
                metronome.setBeat(current_beat);
                prefs.setBeat(String.valueOf(current_beat));

            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });


        startButton.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                if (soundDialogOpened) {
                    metronome = new Metronome(current_bpm, current_beat);
                    soundDialogOpened = false;
                }
                if (!metronome.isPlaying()) {
                    metronome.execute();
                    startButton.setText(getResources().getString(R.string.text_stop));
                } else {
                    metronome.stop();
                    metronome = new Metronome(current_bpm, current_beat);
                    startButton.setText(getResources().getString(R.string.text_start));
                }
            }
        });

        seekbar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int i, boolean b) {
                bpmText.setText("" + i);
                current_bpm = valueOf(seekBar.getProgress());
                metronome.setBpm(current_bpm);
                Preferences.setBpm(String.valueOf(current_bpm));
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
            }

        });

        return v;
    }

    @Override
    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {

        inflater.inflate(R.menu.main_menu, menu);

        if (prefs.getScreenAlwaysOn().equals("true")) {
            menu.findItem(R.id.action_menu_screen_on).setChecked(true);
        } else if (prefs.getScreenAlwaysOn().equals("false")){
            menu.findItem(R.id.action_menu_screen_on).setChecked(false);
        }
        super.onCreateOptionsMenu(menu, inflater);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case R.id.action_menu_settings:
                soundSettingsDialog();
                return true;
            case R.id.action_menu_about:
                aboutDialog();
                return true;
            case R.id.action_menu_screen_on:
                if (item.isChecked()) {
                    item.setChecked(false);
                    prefs.setScreenAlwaysOn("false");
                    ((MainActivity) getActivity()).screenAlwaysOn();
                    Log.w("chubby", prefs.getScreenAlwaysOn());
                } else {
                    item.setChecked(true);
                    prefs.setScreenAlwaysOn("true");
                    ((MainActivity) getActivity()).screenAlwaysOn();
                    Log.w("chubby", prefs.getScreenAlwaysOn());
                }
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    private void restartClick() {
        metronome.stop();
        metronome = new Metronome(current_bpm, current_beat);
        metronome.execute();
    }

    private void change_bpm(double bpm) {
        SeekBar seekbar = this.getView().findViewById(R.id.tempo_seek);
        TextView bpmText = this.getView().findViewById(R.id.bpm_text);
        bpmText.setText("" + (int) bpm);
        metronome.setBpm(bpm);
        seekbar.setProgress((int) bpm);
        Preferences.setBpm(String.valueOf(bpm));
    }

    private void aboutDialog() {
        AlertDialog.Builder dialog = new AlertDialog.Builder(myContext);
        dialog.setMessage(getResources().getString(R.string.about_message));
        dialog.setTitle("Chubby Click " + BuildConfig.VERSION_NAME);
        dialog.setPositiveButton("Ok",
                new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog,
                                        int which) {
                    }
                });
        AlertDialog alertDialog = dialog.create();
        alertDialog.show();
    }

    private void soundSettingsDialog() {
        stopClick();
        soundDialogOpened = true;
        soundSettingsDialog soundDialog = new soundSettingsDialog();
        soundDialog.showDialog(current_bpm, current_beat, myContext);

        Button startButton = this.getView().findViewById(R.id.start_stop);
        startButton.setText(getResources().getString(R.string.text_start));
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof OnFragmentInteractionListener) {
            mListener = (OnFragmentInteractionListener) context;
            myContext = context;
        } else {
            throw new RuntimeException(context.toString()
                    + " must implement OnFragmentInteractionListener");
        }
    }

    @Override
    public void onDetach() {
        stopClick();
        mListener = null;
        super.onDetach();
    }

    private void stopClick() {
        if (metronome.isPlaying()) {
            metronome.stop();
            metronome = new Metronome(current_bpm, current_beat);
        }
    }

    public interface OnFragmentInteractionListener {
        void onFragmentInteraction(Uri uri);
    }
}
